// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "LegacyGhostCellsGeneratorParallelObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkPUnstructuredGridGhostCellsGenerator.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(LegacyGhostCellsGeneratorParallelObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkPUnstructuredGridGhostCellsGenerator)


LegacyGhostCellsGeneratorParallelObjectFactory::LegacyGhostCellsGeneratorParallelObjectFactory()
{
this->RegisterOverride("vtkUnstructuredGridGhostCellsGenerator", "vtkPUnstructuredGridGhostCellsGenerator", "Override for LegacyGhostCellsGeneratorParallel module", 1, vtkObjectFactoryCreatevtkPUnstructuredGridGhostCellsGenerator);

}

const char * LegacyGhostCellsGeneratorParallelObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void LegacyGhostCellsGeneratorParallelObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int LegacyGhostCellsGeneratorParallelCount = 0;

LEGACYGHOSTCELLSGENERATORPARALLEL_EXPORT void LegacyGhostCellsGeneratorParallel_AutoInit_Construct()
{
  if(++LegacyGhostCellsGeneratorParallelCount == 1)
  {


    LegacyGhostCellsGeneratorParallelObjectFactory* factory = LegacyGhostCellsGeneratorParallelObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
