// ClientServer wrapper for vtkCompositeDataDisplayAttributes object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkCompositeDataDisplayAttributes.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkCompositeDataDisplayAttributesClientServerNewCommand(void* /*ctx*/)
{
  return vtkCompositeDataDisplayAttributes::New();
}


static int vtkCompositeDataDisplayAttributesCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkCompositeDataDisplayAttributes *op = vtkCompositeDataDisplayAttributes::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkCompositeDataDisplayAttributes.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkCompositeDataDisplayAttributes  *temp20;
      {
      temp20 = vtkCompositeDataDisplayAttributes::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkCompositeDataDisplayAttributes::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkCompositeDataDisplayAttributes  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkCompositeDataDisplayAttributes::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkCompositeDataDisplayAttributes  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkCompositeDataDisplayAttributes::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockVisibilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockVisibilities();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetBlockVisibility",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    bool   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockVisibility(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockVisibility(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockVisibility(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockVisibility(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockVisibilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockVisibilities();
      return 1;
      }
    }
  if (!strcmp("HasBlockPickabilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockPickabilities();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetBlockPickability",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    bool   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockPickability(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockPickability",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockPickability(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockPickability",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockPickability(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockPickability",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockPickability(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockPickabilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockPickabilities();
      return 1;
      }
    }
  if (!strcmp("SetBlockScalarVisibility",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    bool   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockScalarVisibility(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockScalarVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockScalarVisibility(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockScalarVisibility(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarVisibilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockScalarVisibilities();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarVisibility",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockScalarVisibility(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarVisibilities",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockScalarVisibilities();
      return 1;
      }
    }
  if (!strcmp("SetBlockUseLookupTableScalarRange",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    bool   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockUseLookupTableScalarRange(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockUseLookupTableScalarRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockUseLookupTableScalarRange(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockUseLookupTableScalarRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockUseLookupTableScalarRange(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockUseLookupTableScalarRanges",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockUseLookupTableScalarRanges();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockUseLookupTableScalarRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockUseLookupTableScalarRange(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockUseLookupTableScalarRanges",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockUseLookupTableScalarRanges();
      return 1;
      }
    }
  if (!strcmp("SetBlockInterpolateScalarsBeforeMapping",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    bool   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockInterpolateScalarsBeforeMapping(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockInterpolateScalarsBeforeMapping",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockInterpolateScalarsBeforeMapping(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockInterpolateScalarsBeforeMapping",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockInterpolateScalarsBeforeMapping(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockInterpolateScalarsBeforeMappings",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockInterpolateScalarsBeforeMappings();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockInterpolateScalarsBeforeMapping",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockInterpolateScalarsBeforeMapping(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockInterpolateScalarsBeforeMappings",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockInterpolateScalarsBeforeMappings();
      return 1;
      }
    }
  if (!strcmp("HasBlockColors",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockColors();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockColor",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockColor(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockColor",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockColor(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockColors",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockColors();
      return 1;
      }
    }
  if (!strcmp("SetBlockOpacity",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    double   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockOpacity(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockOpacity",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockOpacity(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockOpacities",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockOpacities();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockOpacity",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockOpacity(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockOpacity",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockOpacity(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockOpacities",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockOpacities();
      return 1;
      }
    }
  if (!strcmp("SetBlockMaterial",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    char    *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockMaterial(temp0,static_cast<std::string>(vtkStdString(temp1)));
      return 1;
      }
    }
  if (!strcmp("GetBlockMaterial",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    const std::string  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = &(op)->GetBlockMaterial(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << *temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockMaterials",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockMaterials();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockMaterial",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockMaterial(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockMaterial",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockMaterial(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockMaterials",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockMaterials();
      return 1;
      }
    }
  if (!strcmp("SetBlockColorMode",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockColorMode(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockColorMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockColorMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockColorMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockColorMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockColorModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockColorModes();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockColorMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockColorMode(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockColorModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockColorModes();
      return 1;
      }
    }
  if (!strcmp("SetBlockScalarMode",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockScalarMode(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockScalarMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockScalarMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockScalarMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockScalarModes();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockScalarMode(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockScalarModes();
      return 1;
      }
    }
  if (!strcmp("SetBlockArrayAccessMode",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockArrayAccessMode(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockArrayAccessMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockArrayAccessMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayAccessMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockArrayAccessMode(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayAccessModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockArrayAccessModes();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayAccessMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockArrayAccessMode(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayAccessModes",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockArrayAccessModes();
      return 1;
      }
    }
  if (!strcmp("SetBlockArrayComponent",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockArrayComponent(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockArrayComponent",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockArrayComponent(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayComponent",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockArrayComponent(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockArrayComponents();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayComponent",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockArrayComponent(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayComponents",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockArrayComponents();
      return 1;
      }
    }
  if (!strcmp("SetBlockArrayId",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockArrayId(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockArrayId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    int      temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockArrayId(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockArrayId(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockArrayIds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockArrayId(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockArrayIds();
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockScalarRange(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockScalarRanges",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockScalarRanges();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarRange",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockScalarRange(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockScalarRanges",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockScalarRanges();
      return 1;
      }
    }
  if (!strcmp("SetBlockArrayName",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    char    *temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockArrayName(temp0,static_cast<std::string>(vtkStdString(temp1)));
      return 1;
      }
    }
  if (!strcmp("GetBlockArrayName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    std::string   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockArrayName(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockArrayName(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockArrayNames",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockArrayNames();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayName",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockArrayName(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockArrayNames",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockArrayNames();
      return 1;
      }
    }
  if (!strcmp("SetBlockFieldDataTupleId",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkDataObject  *temp0;
    long long   temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetBlockFieldDataTupleId(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetBlockFieldDataTupleId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    long long   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->GetBlockFieldDataTupleId(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockFieldDataTupleId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockFieldDataTupleId(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockFieldDataTupleIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockFieldDataTupleIds();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockFieldDataTupleId",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockFieldDataTupleId(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockFieldDataTupleIds",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockFieldDataTupleIds();
      return 1;
      }
    }
  if (!strcmp("HasBlockLookupTable",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    bool   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      temp20 = (op)->HasBlockLookupTable(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HasBlockLookupTables",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->HasBlockLookupTables();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RemoveBlockLookupTable",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkDataObject  *temp0;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkDataObject"))
      {
      op->RemoveBlockLookupTable(temp0);
      return 1;
      }
    }
  if (!strcmp("RemoveBlockLookupTables",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RemoveBlockLookupTables();
      return 1;
      }
    }
  if (!strcmp("DataObjectFromIndex",method) && msg.GetNumberOfArguments(0) == 5)
    {
    unsigned int      temp0;
    vtkDataObject  *temp1;
    unsigned int      temp2;
    vtkDataObject  *temp20;
    if(msg.GetArgument(0, 2, &temp0) &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkDataObject") &&
      msg.GetArgument(0, 4, &temp2))
      {
      temp20 = vtkCompositeDataDisplayAttributes::DataObjectFromIndex(temp0,temp1,temp2);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkObject";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkCompositeDataDisplayAttributes, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkCompositeDataDisplayAttributes_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkCompositeDataDisplayAttributes", vtkCompositeDataDisplayAttributesClientServerNewCommand);
    csi->AddCommandFunction("vtkCompositeDataDisplayAttributes", vtkCompositeDataDisplayAttributesCommand);
    }
}
}
