// python wrapper for vtkTransferFunctionChartHistogram2D
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkSmartPointer.h"
#include "vtkTransferFunctionChartHistogram2D.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkTransferFunctionChartHistogram2D(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkTransferFunctionChartHistogram2D_ClassNew(); }


static PyObject *
PyvtkTransferFunctionChartHistogram2D_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkTransferFunctionChartHistogram2D::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkTransferFunctionChartHistogram2D::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkTransferFunctionChartHistogram2D *tempr = vtkTransferFunctionChartHistogram2D::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTransferFunctionChartHistogram2D *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkTransferFunctionChartHistogram2D::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkTransferFunctionChartHistogram2D::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkTransferFunctionChartHistogram2D::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_IsInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInitialized");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsInitialized() :
      op->vtkTransferFunctionChartHistogram2D::IsInitialized());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_AddNewBox_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddNewBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkTransferFunctionBoxItem> tempr = (ap.IsBound() ?
      op->AddNewBox() :
      op->vtkTransferFunctionChartHistogram2D::AddNewBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionChartHistogram2D_AddNewBox_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddNewBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkRectd *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  double temp2;
  bool temp3 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkRectd") &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    vtkSmartPointer<vtkTransferFunctionBoxItem> tempr = (ap.IsBound() ?
      op->AddNewBox(*temp0, temp1, temp2, temp3) :
      op->vtkTransferFunctionChartHistogram2D::AddNewBox(*temp0, temp1, temp2, temp3));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkTransferFunctionChartHistogram2D_AddNewBox(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkTransferFunctionChartHistogram2D_AddNewBox_s1(self, args);
    case 3:
    case 4:
      return PyvtkTransferFunctionChartHistogram2D_AddNewBox_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddNewBox");
  return nullptr;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_AddBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkSmartPointer<vtkTransferFunctionBoxItem> temp0;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkTransferFunctionBoxItem") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->AddBox(temp0, temp1);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::AddBox(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_RemoveBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkSmartPointer<vtkTransferFunctionBoxItem> temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTransferFunctionBoxItem"))
  {
    if (ap.IsBound())
    {
      op->RemoveBox(temp0);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::RemoveBox(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_MouseDoubleClickEvent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MouseDoubleClickEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkContextMouseEvent *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkContextMouseEvent"))
  {
    bool tempr = (ap.IsBound() ?
      op->MouseDoubleClickEvent(*temp0) :
      op->vtkTransferFunctionChartHistogram2D::MouseDoubleClickEvent(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_KeyPressEvent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "KeyPressEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkContextKeyEvent *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkContextKeyEvent"))
  {
    bool tempr = (ap.IsBound() ?
      op->KeyPressEvent(*temp0) :
      op->vtkTransferFunctionChartHistogram2D::KeyPressEvent(*temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetInputData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkImageData *temp0 = nullptr;
  long long temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkImageData") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0, temp1);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::SetInputData(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetTransferFunction2D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransferFunction2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkPVTransferFunction2D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVTransferFunction2D"))
  {
    if (ap.IsBound())
    {
      op->SetTransferFunction2D(temp0);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::SetTransferFunction2D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_GetTransferFunction2D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransferFunction2D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTransferFunction2D *tempr = (ap.IsBound() ?
      op->GetTransferFunction2D() :
      op->vtkTransferFunctionChartHistogram2D::GetTransferFunction2D());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_GetActiveBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkTransferFunctionBoxItem> tempr = (ap.IsBound() ?
      op->GetActiveBox() :
      op->vtkTransferFunctionChartHistogram2D::GetActiveBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetActiveBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkSmartPointer<vtkTransferFunctionBoxItem> temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTransferFunctionBoxItem"))
  {
    if (ap.IsBound())
    {
      op->SetActiveBox(temp0);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::SetActiveBox(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveBoxColorAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetActiveBoxColorAlpha(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::SetActiveBoxColorAlpha(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveBoxColorAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetActiveBoxColorAlpha(temp0, temp1);
    }
    else
    {
      op->vtkTransferFunctionChartHistogram2D::SetActiveBoxColorAlpha(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha_s1(self, args);
    case 2:
      return PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetActiveBoxColorAlpha");
  return nullptr;
}


static PyObject *
PyvtkTransferFunctionChartHistogram2D_Paint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Paint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionChartHistogram2D *op = static_cast<vtkTransferFunctionChartHistogram2D *>(vp);

  vtkContext2D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkContext2D"))
  {
    bool tempr = (ap.IsBound() ?
      op->Paint(temp0) :
      op->vtkTransferFunctionChartHistogram2D::Paint(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkTransferFunctionChartHistogram2D_Methods[] = {
  {"IsTypeOf", PyvtkTransferFunctionChartHistogram2D_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkTransferFunctionChartHistogram2D_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkTransferFunctionChartHistogram2D_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkTransferFunctionChartHistogram2D\nC++: static vtkTransferFunctionChartHistogram2D *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkTransferFunctionChartHistogram2D_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkTransferFunctionChartHistogram2D\nC++: vtkTransferFunctionChartHistogram2D *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkTransferFunctionChartHistogram2D_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkTransferFunctionChartHistogram2D_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsInitialized", PyvtkTransferFunctionChartHistogram2D_IsInitialized, METH_VARARGS,
   "IsInitialized(self) -> bool\nC++: bool IsInitialized()\n\nGet whether the chart has been initialized with a histogram.\n"},
  {"AddNewBox", PyvtkTransferFunctionChartHistogram2D_AddNewBox, METH_VARARGS,
   "AddNewBox(self) -> vtkTransferFunctionBoxItem\nC++: vtkSmartPointer<vtkTransferFunctionBoxItem> AddNewBox()\nAddNewBox(self, r:vtkRectd, color:[float, ...], alpha:float,\n    addToTF2D:bool=True) -> vtkTransferFunctionBoxItem\nC++: vtkSmartPointer<vtkTransferFunctionBoxItem> AddNewBox(\n    const vtkRectd &r, double *color, double alpha,\n    bool addToTF2D=true)\n\nAdd a new box item to the chart. If addToTF2D is set to true\n(default), the box is also added to the client transfer function.\nThis flag is set to false when adding box items corresponding to\nthe boxes already existing in the transfer function.\n"},
  {"AddBox", PyvtkTransferFunctionChartHistogram2D_AddBox, METH_VARARGS,
   "AddBox(self, box:vtkTransferFunctionBoxItem, addToTF2D:bool=True)\n    -> None\nC++: void AddBox(vtkSmartPointer<vtkTransferFunctionBoxItem> box,\n    bool addToTF2D=true)\n\n"},
  {"RemoveBox", PyvtkTransferFunctionChartHistogram2D_RemoveBox, METH_VARARGS,
   "RemoveBox(self, box:vtkTransferFunctionBoxItem) -> None\nC++: virtual void RemoveBox(\n    vtkSmartPointer<vtkTransferFunctionBoxItem> box)\n\nRemove box item from the chart\n"},
  {"MouseDoubleClickEvent", PyvtkTransferFunctionChartHistogram2D_MouseDoubleClickEvent, METH_VARARGS,
   "MouseDoubleClickEvent(self, mouse:vtkContextMouseEvent) -> bool\nC++: bool MouseDoubleClickEvent(const vtkContextMouseEvent &mouse)\n     override;\n\nOverride to add new box item to the chart when double clicked.\n"},
  {"KeyPressEvent", PyvtkTransferFunctionChartHistogram2D_KeyPressEvent, METH_VARARGS,
   "KeyPressEvent(self, key:vtkContextKeyEvent) -> bool\nC++: bool KeyPressEvent(const vtkContextKeyEvent &key) override;\n\nOverride to delete the active box item\n"},
  {"SetInputData", PyvtkTransferFunctionChartHistogram2D_SetInputData, METH_VARARGS,
   "SetInputData(self, __a:vtkImageData, z:int=0) -> None\nC++: void SetInputData(vtkImageData *, vtkIdType z=0) override;\n\nSet the input image data for the 2D histogram\n"},
  {"SetTransferFunction2D", PyvtkTransferFunctionChartHistogram2D_SetTransferFunction2D, METH_VARARGS,
   "SetTransferFunction2D(self, transfer2D:vtkPVTransferFunction2D)\n    -> None\nC++: virtual void SetTransferFunction2D(\n    vtkPVTransferFunction2D *transfer2D)\n\nSet/Get the 2D transfer function\n"},
  {"GetTransferFunction2D", PyvtkTransferFunctionChartHistogram2D_GetTransferFunction2D, METH_VARARGS,
   "GetTransferFunction2D(self) -> vtkPVTransferFunction2D\nC++: virtual vtkPVTransferFunction2D *GetTransferFunction2D()\n\n"},
  {"GetActiveBox", PyvtkTransferFunctionChartHistogram2D_GetActiveBox, METH_VARARGS,
   "GetActiveBox(self) -> vtkTransferFunctionBoxItem\nC++: vtkSmartPointer<vtkTransferFunctionBoxItem> GetActiveBox()\n\nSet/Get the actively selected box.\n"},
  {"SetActiveBox", PyvtkTransferFunctionChartHistogram2D_SetActiveBox, METH_VARARGS,
   "SetActiveBox(self, box:vtkTransferFunctionBoxItem) -> None\nC++: void SetActiveBox(\n    vtkSmartPointer<vtkTransferFunctionBoxItem> box)\n\n"},
  {"SetActiveBoxColorAlpha", PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha, METH_VARARGS,
   "SetActiveBoxColorAlpha(self, r:float, g:float, b:float, a:float)\n    -> None\nC++: void SetActiveBoxColorAlpha(double r, double g, double b,\n    double a)\nSetActiveBoxColorAlpha(self, color:[float, float, float],\n    alpha:float) -> None\nC++: void SetActiveBoxColorAlpha(double color[3], double alpha)\n\nSet active box color and alpha.\n"},
  {"Paint", PyvtkTransferFunctionChartHistogram2D_Paint, METH_VARARGS,
   "Paint(self, painter:vtkContext2D) -> bool\nC++: bool Paint(vtkContext2D *painter) override;\n\nPaint event for the chart, called whenever the chart needs to be\ndrawn\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkTransferFunctionChartHistogram2D_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("transfer_function2d"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionChartHistogram2D_GetTransferFunction2D(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionChartHistogram2D_SetTransferFunction2D(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionChartHistogram2D_SetTransferFunction2D(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTransferFunction2D/SetTransferFunction2D\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_box"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionChartHistogram2D_SetActiveBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionChartHistogram2D_SetActiveBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActiveBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_box_color_alpha"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionChartHistogram2D_SetActiveBoxColorAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActiveBoxColorAlpha\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_box"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionChartHistogram2D_GetActiveBox(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveBox\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkTransferFunctionChartHistogram2D_Doc =
  "vtkTransferFunctionChartHistogram2D - no description provided.\n\n"
  "Superclass: vtkChartHistogram2D\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkTransferFunctionChartHistogram2D_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkTransferFunctionChartHistogram2D", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkTransferFunctionChartHistogram2D_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkTransferFunctionChartHistogram2D_StaticNew()
{
  return vtkTransferFunctionChartHistogram2D::New();
}

PyObject *PyvtkTransferFunctionChartHistogram2D_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkTransferFunctionChartHistogram2D_Type, PyvtkTransferFunctionChartHistogram2D_Methods,
    "vtkTransferFunctionChartHistogram2D",
 &PyvtkTransferFunctionChartHistogram2D_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkChartHistogram2D");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(vtkTransferFunctionChartHistogram2D::TransferFunctionModified);
  if (o)
  {
    PyDict_SetItemString(d, "TransferFunctionModified", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkTransferFunctionChartHistogram2D_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkTransferFunctionChartHistogram2D(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkTransferFunctionChartHistogram2D_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkTransferFunctionChartHistogram2D", o) != 0)
  {
    Py_DECREF(o);
  }

}

