// python wrapper for vtkPVPlotMatrixRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPlotMatrixRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPlotMatrixRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPlotMatrixRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkChartRepresentation_ClassNew
extern "C" { PyObject *PyvtkChartRepresentation_ClassNew(); }
#define DECLARED_PyvtkChartRepresentation_ClassNew
#endif

static PyObject *
PyvtkPVPlotMatrixRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPlotMatrixRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPlotMatrixRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPlotMatrixRepresentation *tempr = vtkPVPlotMatrixRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPlotMatrixRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPlotMatrixRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPlotMatrixRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPlotMatrixRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetSeriesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeriesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSeriesVisibility(temp0, temp1);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetSeriesVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_ClearSeriesVisibilities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearSeriesVisibilities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearSeriesVisibilities();
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::ClearSeriesVisibilities();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetHistogramColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHistogramColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetHistogramColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetHistogramColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetMarkerStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMarkerStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMarkerStyle(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetMarkerStyle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotMarkerStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotMarkerStyle(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotMarkerStyle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetMarkerSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMarkerSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMarkerSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetMarkerSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotMarkerSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotMarkerSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotMarkerSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetDensityMapVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDensityMapVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDensityMapVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetDensityMapVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotDensityMapVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotDensityMapVisibility(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotDensityMapVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetDensityLineSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDensityLineSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDensityLineSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetDensityLineSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityLineSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotDensityLineSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotDensityLineSize(temp0);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotDensityLineSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetDensityMapFirstDecileColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDensityMapFirstDecileColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDensityMapFirstDecileColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetDensityMapFirstDecileColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapFirstDecileColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotDensityMapFirstDecileColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotDensityMapFirstDecileColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotDensityMapFirstDecileColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetDensityMapMedianColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDensityMapMedianColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDensityMapMedianColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetDensityMapMedianColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapMedianColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotDensityMapMedianColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotDensityMapMedianColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotDensityMapMedianColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetDensityMapLastDecileColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDensityMapLastDecileColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDensityMapLastDecileColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetDensityMapLastDecileColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapLastDecileColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivePlotDensityMapLastDecileColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetActivePlotDensityMapLastDecileColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVPlotMatrixRepresentation::SetActivePlotDensityMapLastDecileColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlotMatrixRepresentation_GetPlotMatrix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlotMatrix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPlotMatrixRepresentation *op = static_cast<vtkPVPlotMatrixRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkScatterPlotMatrix *tempr = (ap.IsBound() ?
      op->GetPlotMatrix() :
      op->vtkPVPlotMatrixRepresentation::GetPlotMatrix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPlotMatrixRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPVPlotMatrixRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPlotMatrixRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPlotMatrixRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPlotMatrixRepresentation\nC++: static vtkPVPlotMatrixRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPlotMatrixRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPlotMatrixRepresentation\nC++: vtkPVPlotMatrixRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPlotMatrixRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPlotMatrixRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetVisibility", PyvtkPVPlotMatrixRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, visible:bool) -> None\nC++: void SetVisibility(bool visible) override;\n\nSets the visibility for the plot matrix representation.\n"},
  {"SetSeriesVisibility", PyvtkPVPlotMatrixRepresentation_SetSeriesVisibility, METH_VARARGS,
   "SetSeriesVisibility(self, series:str, visibility:bool) -> None\nC++: void SetSeriesVisibility(const char *series, bool visibility)\n\nSet series visibility given its name. The order in which\nSetSeriesVisibility is called is used to determine the order for\neach of the plots in the grid.\n"},
  {"ClearSeriesVisibilities", PyvtkPVPlotMatrixRepresentation_ClearSeriesVisibilities, METH_VARARGS,
   "ClearSeriesVisibilities(self) -> None\nC++: void ClearSeriesVisibilities()\n\n"},
  {"SetColor", PyvtkPVPlotMatrixRepresentation_SetColor, METH_VARARGS,
   "SetColor(self, r:float, g:float, b:float) -> None\nC++: void SetColor(double r, double g, double b)\n\nSets the color for the scatter plots in the plot matrix.\n"},
  {"SetActivePlotColor", PyvtkPVPlotMatrixRepresentation_SetActivePlotColor, METH_VARARGS,
   "SetActivePlotColor(self, r:float, g:float, b:float) -> None\nC++: void SetActivePlotColor(double r, double g, double b)\n\nSets the color for the active plot.\n"},
  {"SetHistogramColor", PyvtkPVPlotMatrixRepresentation_SetHistogramColor, METH_VARARGS,
   "SetHistogramColor(self, r:float, g:float, b:float) -> None\nC++: void SetHistogramColor(double r, double g, double b)\n\nSets the color for the histograms.\n"},
  {"SetMarkerStyle", PyvtkPVPlotMatrixRepresentation_SetMarkerStyle, METH_VARARGS,
   "SetMarkerStyle(self, style:int) -> None\nC++: void SetMarkerStyle(int style)\n\nSets the marker style for the scatter plots.\n"},
  {"SetActivePlotMarkerStyle", PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerStyle, METH_VARARGS,
   "SetActivePlotMarkerStyle(self, style:int) -> None\nC++: void SetActivePlotMarkerStyle(int style)\n\nSets the marker style for the active plot.\n"},
  {"SetMarkerSize", PyvtkPVPlotMatrixRepresentation_SetMarkerSize, METH_VARARGS,
   "SetMarkerSize(self, size:float) -> None\nC++: void SetMarkerSize(double size)\n\nSets the marker size for the scatter plots.\n"},
  {"SetActivePlotMarkerSize", PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerSize, METH_VARARGS,
   "SetActivePlotMarkerSize(self, size:float) -> None\nC++: void SetActivePlotMarkerSize(double size)\n\nSets the marker size for the active plots.\n"},
  {"SetDensityMapVisibility", PyvtkPVPlotMatrixRepresentation_SetDensityMapVisibility, METH_VARARGS,
   "SetDensityMapVisibility(self, visible:bool) -> None\nC++: void SetDensityMapVisibility(bool visible)\n\nSet the scatter plot density map visibility\n"},
  {"SetActivePlotDensityMapVisibility", PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapVisibility, METH_VARARGS,
   "SetActivePlotDensityMapVisibility(self, visible:bool) -> None\nC++: void SetActivePlotDensityMapVisibility(bool visible)\n\nSet the active plot density map visibility\n"},
  {"SetDensityLineSize", PyvtkPVPlotMatrixRepresentation_SetDensityLineSize, METH_VARARGS,
   "SetDensityLineSize(self, size:float) -> None\nC++: void SetDensityLineSize(double size)\n\nSets the line size for the density map in the plot matrix.\n"},
  {"SetActivePlotDensityLineSize", PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityLineSize, METH_VARARGS,
   "SetActivePlotDensityLineSize(self, size:float) -> None\nC++: void SetActivePlotDensityLineSize(double size)\n\nSets the line size for the density map in the active plot.\n"},
  {"SetDensityMapFirstDecileColor", PyvtkPVPlotMatrixRepresentation_SetDensityMapFirstDecileColor, METH_VARARGS,
   "SetDensityMapFirstDecileColor(self, r:float, g:float, b:float)\n    -> None\nC++: void SetDensityMapFirstDecileColor(double r, double g,\n    double b)\n\nSets the color for the density map first DecileColor in the\nscatter plots.\n"},
  {"SetActivePlotDensityMapFirstDecileColor", PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapFirstDecileColor, METH_VARARGS,
   "SetActivePlotDensityMapFirstDecileColor(self, r:float, g:float,\n    b:float) -> None\nC++: void SetActivePlotDensityMapFirstDecileColor(double r,\n    double g, double b)\n\nSets the color for the density map first DecileColor in the\nscatter plots.\n"},
  {"SetDensityMapMedianColor", PyvtkPVPlotMatrixRepresentation_SetDensityMapMedianColor, METH_VARARGS,
   "SetDensityMapMedianColor(self, r:float, g:float, b:float) -> None\nC++: void SetDensityMapMedianColor(double r, double g, double b)\n\nSets the color for the density map MeanColor in the scatter\nplots.\n"},
  {"SetActivePlotDensityMapMedianColor", PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapMedianColor, METH_VARARGS,
   "SetActivePlotDensityMapMedianColor(self, r:float, g:float,\n    b:float) -> None\nC++: void SetActivePlotDensityMapMedianColor(double r, double g,\n    double b)\n\nSets the color for the density map MeanColor in the scatter\nplots.\n"},
  {"SetDensityMapLastDecileColor", PyvtkPVPlotMatrixRepresentation_SetDensityMapLastDecileColor, METH_VARARGS,
   "SetDensityMapLastDecileColor(self, r:float, g:float, b:float)\n    -> None\nC++: void SetDensityMapLastDecileColor(double r, double g,\n    double b)\n\nSets the color for the density map last DecileColor in the\nscatter plots.\n"},
  {"SetActivePlotDensityMapLastDecileColor", PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapLastDecileColor, METH_VARARGS,
   "SetActivePlotDensityMapLastDecileColor(self, r:float, g:float,\n    b:float) -> None\nC++: void SetActivePlotDensityMapLastDecileColor(double r,\n    double g, double b)\n\nSets the color for the density map last DecileColor in the\nscatter plots.\n"},
  {"GetPlotMatrix", PyvtkPVPlotMatrixRepresentation_GetPlotMatrix, METH_VARARGS,
   "GetPlotMatrix(self) -> vtkScatterPlotMatrix\nC++: vtkScatterPlotMatrix *GetPlotMatrix()\n\nReturns the scatter plot matrix.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPlotMatrixRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("histogram_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetHistogramColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetHistogramColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHistogramColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("marker_style"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetMarkerStyle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetMarkerStyle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMarkerStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_marker_style"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerStyle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerStyle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotMarkerStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("marker_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetMarkerSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetMarkerSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMarkerSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_marker_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotMarkerSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotMarkerSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("density_map_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDensityMapVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_density_map_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotDensityMapVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("density_line_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityLineSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityLineSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDensityLineSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_density_line_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityLineSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityLineSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotDensityLineSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("density_map_first_decile_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapFirstDecileColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapFirstDecileColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDensityMapFirstDecileColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_density_map_first_decile_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapFirstDecileColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapFirstDecileColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotDensityMapFirstDecileColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("density_map_median_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapMedianColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapMedianColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDensityMapMedianColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_density_map_median_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapMedianColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapMedianColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotDensityMapMedianColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("density_map_last_decile_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapLastDecileColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetDensityMapLastDecileColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDensityMapLastDecileColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_plot_density_map_last_decile_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapLastDecileColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPlotMatrixRepresentation_SetActivePlotDensityMapLastDecileColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActivePlotDensityMapLastDecileColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plot_matrix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlotMatrixRepresentation_GetPlotMatrix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPlotMatrix\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPlotMatrixRepresentation_Doc =
  "vtkPVPlotMatrixRepresentation - vtkChartRepresentation subclass for\nscatter-plot-matrix representation.\n\n"
  "Superclass: vtkChartRepresentation\n\n"
  "vtkPVPlotMatrixRepresentation manages representations in a\n"
  "vtkScatterPlotMatrix view. It exposes API that affects how the matrix\n"
  "is rendered as well as API to control which of the columns in the\n"
  "input vtkTable are to be plotted in the matrix.\n\n"
  "vtkPVPlotMatrixRepresentation currently does not support multiblock\n"
  "of tables and only the first table is rendered.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPlotMatrixRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVPlotMatrixRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPlotMatrixRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPlotMatrixRepresentation_StaticNew()
{
  return vtkPVPlotMatrixRepresentation::New();
}

PyObject *PyvtkPVPlotMatrixRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPlotMatrixRepresentation_Type, PyvtkPVPlotMatrixRepresentation_Methods,
    "vtkPVPlotMatrixRepresentation",
 &PyvtkPVPlotMatrixRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkChartRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPlotMatrixRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPlotMatrixRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPlotMatrixRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPlotMatrixRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

