// python wrapper for vtkIceTCompositePass
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkIceTCompositePass.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkIceTCompositePass(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkIceTCompositePass_ClassNew(); }


static PyObject *
PyvtkIceTCompositePass_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkIceTCompositePass::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkIceTCompositePass::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkIceTCompositePass *tempr = vtkIceTCompositePass::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkIceTCompositePass *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkIceTCompositePass::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkIceTCompositePass::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkIceTCompositePass::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkIceTCompositePass::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  vtkRenderPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderPass"))
  {
    if (ap.IsBound())
    {
      op->SetRenderPass(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetRenderPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderPass *tempr = (ap.IsBound() ?
      op->GetRenderPass() :
      op->vtkIceTCompositePass::GetRenderPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetTileDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileDimensions(temp0, temp1);
    }
    else
    {
      op->vtkIceTCompositePass::SetTileDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkIceTCompositePass_SetTileDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTileDimensions(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetTileDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkIceTCompositePass_SetTileDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkIceTCompositePass_SetTileDimensions_s1(self, args);
    case 1:
      return PyvtkIceTCompositePass_SetTileDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTileDimensions");
  return nullptr;
}


static PyObject *
PyvtkIceTCompositePass_GetTileDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileDimensions() :
      op->vtkIceTCompositePass::GetTileDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetTileMullions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileMullions(temp0, temp1);
    }
    else
    {
      op->vtkIceTCompositePass::SetTileMullions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkIceTCompositePass_SetTileMullions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTileMullions(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetTileMullions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkIceTCompositePass_SetTileMullions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkIceTCompositePass_SetTileMullions_s1(self, args);
    case 1:
      return PyvtkIceTCompositePass_SetTileMullions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTileMullions");
  return nullptr;
}


static PyObject *
PyvtkIceTCompositePass_GetTileMullions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileMullions() :
      op->vtkIceTCompositePass::GetTileMullions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetDataReplicatedOnAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataReplicatedOnAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataReplicatedOnAllProcesses(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetDataReplicatedOnAllProcesses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetDataReplicatedOnAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataReplicatedOnAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDataReplicatedOnAllProcesses() :
      op->vtkIceTCompositePass::GetDataReplicatedOnAllProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_DataReplicatedOnAllProcessesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataReplicatedOnAllProcessesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataReplicatedOnAllProcessesOn();
    }
    else
    {
      op->vtkIceTCompositePass::DataReplicatedOnAllProcessesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_DataReplicatedOnAllProcessesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataReplicatedOnAllProcessesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DataReplicatedOnAllProcessesOff();
    }
    else
    {
      op->vtkIceTCompositePass::DataReplicatedOnAllProcessesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactor(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetImageReductionFactorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactorMinValue() :
      op->vtkIceTCompositePass::GetImageReductionFactorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetImageReductionFactorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactorMaxValue() :
      op->vtkIceTCompositePass::GetImageReductionFactorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactor() :
      op->vtkIceTCompositePass::GetImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetOrderedCompositingHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOrderedCompositingHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOrderedCompositingHelper *tempr = (ap.IsBound() ?
      op->GetOrderedCompositingHelper() :
      op->vtkIceTCompositePass::GetOrderedCompositingHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetOrderedCompositingHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrderedCompositingHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  vtkOrderedCompositingHelper *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOrderedCompositingHelper"))
  {
    if (ap.IsBound())
    {
      op->SetOrderedCompositingHelper(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetOrderedCompositingHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetRenderEmptyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderEmptyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRenderEmptyImages() :
      op->vtkIceTCompositePass::GetRenderEmptyImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetRenderEmptyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderEmptyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderEmptyImages(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetRenderEmptyImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_RenderEmptyImagesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderEmptyImagesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RenderEmptyImagesOn();
    }
    else
    {
      op->vtkIceTCompositePass::RenderEmptyImagesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_RenderEmptyImagesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderEmptyImagesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RenderEmptyImagesOff();
    }
    else
    {
      op->vtkIceTCompositePass::RenderEmptyImagesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetUseOrderedCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOrderedCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseOrderedCompositing() :
      op->vtkIceTCompositePass::GetUseOrderedCompositing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetUseOrderedCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOrderedCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOrderedCompositing(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetUseOrderedCompositing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_UseOrderedCompositingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseOrderedCompositingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseOrderedCompositingOn();
    }
    else
    {
      op->vtkIceTCompositePass::UseOrderedCompositingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_UseOrderedCompositingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseOrderedCompositingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseOrderedCompositingOff();
    }
    else
    {
      op->vtkIceTCompositePass::UseOrderedCompositingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetLastRenderedDepths(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastRenderedDepths");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFloatArray *tempr = (ap.IsBound() ?
      op->GetLastRenderedDepths() :
      op->vtkIceTCompositePass::GetLastRenderedDepths());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetEnableFloatValuePass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableFloatValuePass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableFloatValuePass(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetEnableFloatValuePass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetLastRenderedRGBA32F(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastRenderedRGBA32F");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFloatArray *tempr = (ap.IsBound() ?
      op->GetLastRenderedRGBA32F() :
      op->vtkIceTCompositePass::GetLastRenderedRGBA32F());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetDisplayRGBAResults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayRGBAResults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayRGBAResults(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetDisplayRGBAResults(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetDisplayRGBAResults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayRGBAResults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayRGBAResults() :
      op->vtkIceTCompositePass::GetDisplayRGBAResults());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_SetDisplayDepthResults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayDepthResults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayDepthResults(temp0);
    }
    else
    {
      op->vtkIceTCompositePass::SetDisplayDepthResults(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTCompositePass_GetDisplayDepthResults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayDepthResults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTCompositePass *op = static_cast<vtkIceTCompositePass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayDepthResults() :
      op->vtkIceTCompositePass::GetDisplayDepthResults());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkIceTCompositePass_Methods[] = {
  {"IsTypeOf", PyvtkIceTCompositePass_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkIceTCompositePass_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkIceTCompositePass_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkIceTCompositePass\nC++: static vtkIceTCompositePass *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkIceTCompositePass_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkIceTCompositePass\nC++: vtkIceTCompositePass *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkIceTCompositePass_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkIceTCompositePass_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ReleaseGraphicsResources", PyvtkIceTCompositePass_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, w:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *w) override;\n\nRelease graphics resources and ask components to release their\nown resources.\n\\pre w_exists: w!=0\n"},
  {"GetController", PyvtkIceTCompositePass_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\nController If it is nullptr, nothing will be rendered and a\nwarning will be emitted. Initial value is a nullptr pointer.\n"},
  {"SetController", PyvtkIceTCompositePass_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: virtual void SetController(\n    vtkMultiProcessController *controller)\n\n"},
  {"SetRenderPass", PyvtkIceTCompositePass_SetRenderPass, METH_VARARGS,
   "SetRenderPass(self, __a:vtkRenderPass) -> None\nC++: void SetRenderPass(vtkRenderPass *)\n\nGet/Set the render pass used to do the actual rendering. The\nresult of this delete pass is what gets composited using IceT.\nInitial value is a nullptr pointer.\n"},
  {"GetRenderPass", PyvtkIceTCompositePass_GetRenderPass, METH_VARARGS,
   "GetRenderPass(self) -> vtkRenderPass\nC++: virtual vtkRenderPass *GetRenderPass()\n\n"},
  {"SetTileDimensions", PyvtkIceTCompositePass_SetTileDimensions, METH_VARARGS,
   "SetTileDimensions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTileDimensions(int _arg1, int _arg2)\nSetTileDimensions(self, _arg:(int, int)) -> None\nC++: void SetTileDimensions(const int _arg[2])\n\nGet/Set the tile dimensions. Default is (1, 1). If any of the\ndimensions is > 1 than tile display mode is assumed.\n"},
  {"GetTileDimensions", PyvtkIceTCompositePass_GetTileDimensions, METH_VARARGS,
   "GetTileDimensions(self) -> (int, int)\nC++: virtual int *GetTileDimensions()\n\n"},
  {"SetTileMullions", PyvtkIceTCompositePass_SetTileMullions, METH_VARARGS,
   "SetTileMullions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTileMullions(int _arg1, int _arg2)\nSetTileMullions(self, _arg:(int, int)) -> None\nC++: void SetTileMullions(const int _arg[2])\n\nGet/Set the tile mullions. The mullions are measured in pixels.\nUse negative numbers for overlap. Initial value is {0,0}.\n"},
  {"GetTileMullions", PyvtkIceTCompositePass_GetTileMullions, METH_VARARGS,
   "GetTileMullions(self) -> (int, int)\nC++: virtual int *GetTileMullions()\n\n"},
  {"SetDataReplicatedOnAllProcesses", PyvtkIceTCompositePass_SetDataReplicatedOnAllProcesses, METH_VARARGS,
   "SetDataReplicatedOnAllProcesses(self, _arg:bool) -> None\nC++: virtual void SetDataReplicatedOnAllProcesses(bool _arg)\n\nSet to true if data is replicated on all processes. This will\nenable IceT to minimize communications since data is available on\nall process. Off by default. Initial value is false.\n"},
  {"GetDataReplicatedOnAllProcesses", PyvtkIceTCompositePass_GetDataReplicatedOnAllProcesses, METH_VARARGS,
   "GetDataReplicatedOnAllProcesses(self) -> bool\nC++: virtual bool GetDataReplicatedOnAllProcesses()\n\n"},
  {"DataReplicatedOnAllProcessesOn", PyvtkIceTCompositePass_DataReplicatedOnAllProcessesOn, METH_VARARGS,
   "DataReplicatedOnAllProcessesOn(self) -> None\nC++: virtual void DataReplicatedOnAllProcessesOn()\n\n"},
  {"DataReplicatedOnAllProcessesOff", PyvtkIceTCompositePass_DataReplicatedOnAllProcessesOff, METH_VARARGS,
   "DataReplicatedOnAllProcessesOff(self) -> None\nC++: virtual void DataReplicatedOnAllProcessesOff()\n\n"},
  {"SetImageReductionFactor", PyvtkIceTCompositePass_SetImageReductionFactor, METH_VARARGS,
   "SetImageReductionFactor(self, _arg:int) -> None\nC++: virtual void SetImageReductionFactor(int _arg)\n\nSet the image reduction factor. This can be used to speed up\ncompositing. When using vtkIceTCompositePass use this image\nreduction factor rather than that on vtkSynchronizedRenderers\nsince using vtkSynchronizedRenderers::ImageReductionFactor will\nnot work correctly with IceT. Initial value is 1.\n"},
  {"GetImageReductionFactorMinValue", PyvtkIceTCompositePass_GetImageReductionFactorMinValue, METH_VARARGS,
   "GetImageReductionFactorMinValue(self) -> int\nC++: virtual int GetImageReductionFactorMinValue()\n\n"},
  {"GetImageReductionFactorMaxValue", PyvtkIceTCompositePass_GetImageReductionFactorMaxValue, METH_VARARGS,
   "GetImageReductionFactorMaxValue(self) -> int\nC++: virtual int GetImageReductionFactorMaxValue()\n\n"},
  {"GetImageReductionFactor", PyvtkIceTCompositePass_GetImageReductionFactor, METH_VARARGS,
   "GetImageReductionFactor(self) -> int\nC++: virtual int GetImageReductionFactor()\n\n"},
  {"GetOrderedCompositingHelper", PyvtkIceTCompositePass_GetOrderedCompositingHelper, METH_VARARGS,
   "GetOrderedCompositingHelper(self) -> vtkOrderedCompositingHelper\nC++: virtual vtkOrderedCompositingHelper *GetOrderedCompositingHelper(\n    )\n\npartition ordering that gives processes ordering. Initial value\nis a nullptr pointer. This is used only when\nUseOrderedCompositing is true.\n"},
  {"SetOrderedCompositingHelper", PyvtkIceTCompositePass_SetOrderedCompositingHelper, METH_VARARGS,
   "SetOrderedCompositingHelper(self,\n    helper:vtkOrderedCompositingHelper) -> None\nC++: virtual void SetOrderedCompositingHelper(\n    vtkOrderedCompositingHelper *helper)\n\n"},
  {"GetRenderEmptyImages", PyvtkIceTCompositePass_GetRenderEmptyImages, METH_VARARGS,
   "GetRenderEmptyImages(self) -> bool\nC++: virtual bool GetRenderEmptyImages()\n\nEnable/disable rendering of empty images. Painters that use MPI\nglobal collective communication need to enable this. Initial\nvalue is false.\n"},
  {"SetRenderEmptyImages", PyvtkIceTCompositePass_SetRenderEmptyImages, METH_VARARGS,
   "SetRenderEmptyImages(self, _arg:bool) -> None\nC++: virtual void SetRenderEmptyImages(bool _arg)\n\n"},
  {"RenderEmptyImagesOn", PyvtkIceTCompositePass_RenderEmptyImagesOn, METH_VARARGS,
   "RenderEmptyImagesOn(self) -> None\nC++: virtual void RenderEmptyImagesOn()\n\n"},
  {"RenderEmptyImagesOff", PyvtkIceTCompositePass_RenderEmptyImagesOff, METH_VARARGS,
   "RenderEmptyImagesOff(self) -> None\nC++: virtual void RenderEmptyImagesOff()\n\n"},
  {"GetUseOrderedCompositing", PyvtkIceTCompositePass_GetUseOrderedCompositing, METH_VARARGS,
   "GetUseOrderedCompositing(self) -> bool\nC++: virtual bool GetUseOrderedCompositing()\n\nSet this to true, if compositing must be done in a specific\norder. This is necessary when rendering volumes or translucent\ngeometries. When UseOrderedCompositing is set to true, it is\nexpected that the OrderedCompositingHelper is set as well.\nOrderedCompositingHelper is used to decide the process-order for\ncompositing. Initial value is false.\n"},
  {"SetUseOrderedCompositing", PyvtkIceTCompositePass_SetUseOrderedCompositing, METH_VARARGS,
   "SetUseOrderedCompositing(self, _arg:bool) -> None\nC++: virtual void SetUseOrderedCompositing(bool _arg)\n\n"},
  {"UseOrderedCompositingOn", PyvtkIceTCompositePass_UseOrderedCompositingOn, METH_VARARGS,
   "UseOrderedCompositingOn(self) -> None\nC++: virtual void UseOrderedCompositingOn()\n\n"},
  {"UseOrderedCompositingOff", PyvtkIceTCompositePass_UseOrderedCompositingOff, METH_VARARGS,
   "UseOrderedCompositingOff(self) -> None\nC++: virtual void UseOrderedCompositingOff()\n\n"},
  {"GetLastRenderedDepths", PyvtkIceTCompositePass_GetLastRenderedDepths, METH_VARARGS,
   "GetLastRenderedDepths(self) -> vtkFloatArray\nC++: vtkFloatArray *GetLastRenderedDepths()\n\nProvides access to the last rendered depth-buffer, if any. May\nreturn nullptr if depth buffer was not composited and available\non the current rank.\n"},
  {"SetEnableFloatValuePass", PyvtkIceTCompositePass_SetEnableFloatValuePass, METH_VARARGS,
   "SetEnableFloatValuePass(self, _arg:bool) -> None\nC++: virtual void SetEnableFloatValuePass(bool _arg)\n\nAdjusts this pass to handle vtkValuePass::FLOATING_POINT, in\nwhich floating- point values are rendered to vtkValuePass's\ninternal FBO.\n"},
  {"GetLastRenderedRGBA32F", PyvtkIceTCompositePass_GetLastRenderedRGBA32F, METH_VARARGS,
   "GetLastRenderedRGBA32F(self) -> vtkFloatArray\nC++: vtkFloatArray *GetLastRenderedRGBA32F()\n\nProvides access to the last rendered float image in vtkValuePass,\nif any. May return nullptr if a float image was not composited\nand is not available on the current rank.\n"},
  {"SetDisplayRGBAResults", PyvtkIceTCompositePass_SetDisplayRGBAResults, METH_VARARGS,
   "SetDisplayRGBAResults(self, _arg:bool) -> None\nC++: virtual void SetDisplayRGBAResults(bool _arg)\n\nWhen set to true, vtkIceTCompositePass will push back compositing\nresults to the display on ranks where the IceT generated a\ncomposited result. Generally speaking, for a vtkRenderPass, this\nmust always be `true`. However, for ParaView use cases many times\nwe display the compositing result on the server-side. In which\ncase, we can save on the extra work to push results to screen.\nHence, vtkIceTCompositePass sets this to false by default.\n"},
  {"GetDisplayRGBAResults", PyvtkIceTCompositePass_GetDisplayRGBAResults, METH_VARARGS,
   "GetDisplayRGBAResults(self) -> bool\nC++: virtual bool GetDisplayRGBAResults()\n\n"},
  {"SetDisplayDepthResults", PyvtkIceTCompositePass_SetDisplayDepthResults, METH_VARARGS,
   "SetDisplayDepthResults(self, _arg:bool) -> None\nC++: virtual void SetDisplayDepthResults(bool _arg)\n\n"},
  {"GetDisplayDepthResults", PyvtkIceTCompositePass_GetDisplayDepthResults, METH_VARARGS,
   "GetDisplayDepthResults(self) -> bool\nC++: virtual bool GetDisplayDepthResults()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkIceTCompositePass_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetRenderPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetRenderPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetRenderPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderPass/SetRenderPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetTileDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetTileDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetTileDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTileDimensions/SetTileDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_mullions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetTileMullions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetTileMullions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetTileMullions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTileMullions/SetTileMullions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_replicated_on_all_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetDataReplicatedOnAllProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetDataReplicatedOnAllProcesses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetDataReplicatedOnAllProcesses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataReplicatedOnAllProcesses/SetDataReplicatedOnAllProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageReductionFactor/SetImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ordered_compositing_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetOrderedCompositingHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetOrderedCompositingHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetOrderedCompositingHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOrderedCompositingHelper/SetOrderedCompositingHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_empty_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetRenderEmptyImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetRenderEmptyImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetRenderEmptyImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderEmptyImages/SetRenderEmptyImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ordered_compositing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetUseOrderedCompositing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetUseOrderedCompositing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetUseOrderedCompositing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseOrderedCompositing/SetUseOrderedCompositing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_float_value_pass"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetEnableFloatValuePass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetEnableFloatValuePass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnableFloatValuePass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_rgba_results"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetDisplayRGBAResults(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetDisplayRGBAResults(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetDisplayRGBAResults(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayRGBAResults/SetDisplayRGBAResults\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_depth_results"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetDisplayDepthResults(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTCompositePass_SetDisplayDepthResults(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTCompositePass_SetDisplayDepthResults(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayDepthResults/SetDisplayDepthResults\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_rendered_depths"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetLastRenderedDepths(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastRenderedDepths\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_rendered_rgba32f"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTCompositePass_GetLastRenderedRGBA32F(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastRenderedRGBA32F\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkIceTCompositePass_Doc =
  "vtkIceTCompositePass - IceT enabled render pass for distributed\nrendering\n\n"
  "Superclass: vtkRenderPass\n\n"
  "vtkIceTCompositePass is a vtkRenderPass subclass that can be used for\n"
  "compositing images (RGBA_UBYTE, depth or RGBA_32F) across processes\n"
  "using IceT. This can be used in lieu of vtkCompositeRGBAPass. The\n"
  "usage of this pass differs slightly from vtkCompositeRGBAPass.\n"
  "vtkCompositeRGBAPass composites the active frame buffer, while this\n"
  "class requires that the render pass to render info the frame buffer\n"
  "that needs to be composited should be set as an ivar using\n"
  "SetRenderPass().\n\n"
  "This class also provides support for tile-displays. Simply set the\n"
  "TileDimensions > [1, 1] and instead of rendering a composited image\n"
  "on the root node, it will split the view among all tiles and generate\n"
  "renderings on all processes.\n\n"
  "Warning: Compositing RGBA_32F is only supported for a specific pass\n"
  "(vtkValuePass). For a more generic integration, vtkRenderPass should\n"
  "expose an internal FBO API.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkIceTCompositePass_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkIceTCompositePass", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkIceTCompositePass_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkIceTCompositePass_StaticNew()
{
  return vtkIceTCompositePass::New();
}

PyObject *PyvtkIceTCompositePass_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkIceTCompositePass_Type, PyvtkIceTCompositePass_Methods,
    "vtkIceTCompositePass",
 &PyvtkIceTCompositePass_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRenderPass");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkIceTCompositePass_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkIceTCompositePass(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkIceTCompositePass_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkIceTCompositePass", o) != 0)
  {
    Py_DECREF(o);
  }

}

