// python wrapper for vtkSteeringDataGenerator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSteeringDataGenerator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSteeringDataGenerator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSteeringDataGenerator_ClassNew(); }


static PyObject *
PyvtkSteeringDataGenerator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSteeringDataGenerator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSteeringDataGenerator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSteeringDataGenerator *tempr = vtkSteeringDataGenerator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSteeringDataGenerator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSteeringDataGenerator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSteeringDataGenerator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSteeringDataGenerator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetPartitionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPartitionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPartitionType(temp0);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetPartitionType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_GetPartitionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPartitionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPartitionType() :
      op->vtkSteeringDataGenerator::GetPartitionType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldAssociation(temp0);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetFieldAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_GetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociation() :
      op->vtkSteeringDataGenerator::GetFieldAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetSelectionConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetSelectionConnection(temp0, temp1);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetSelectionConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSteeringDataGenerator_SetSelectionConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectionConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetSelectionConnection(temp0);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetSelectionConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSteeringDataGenerator_SetSelectionConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSteeringDataGenerator_SetSelectionConnection_s1(self, args);
    case 1:
      return PyvtkSteeringDataGenerator_SetSelectionConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSelectionConnection");
  return nullptr;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple1Double(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple1Double");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTuple1Double(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple1Double(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple1Int(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple1Int");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTuple1Int(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple1Int(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple1IdType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple1IdType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  long long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTuple1IdType(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple1IdType(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple2Double(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple2Double");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTuple2Double(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple2Double(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple2Int(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple2Int");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTuple2Int(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple2Int(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple2IdType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple2IdType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  long long temp2;
  long long temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTuple2IdType(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple2IdType(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple3Double(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple3Double");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  double temp2;
  double temp3;
  double temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetTuple3Double(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple3Double(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple3Int(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple3Int");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetTuple3Int(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple3Int(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_SetTuple3IdType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTuple3IdType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  long long temp1;
  long long temp2;
  long long temp3;
  long long temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetTuple3IdType(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkSteeringDataGenerator::SetTuple3IdType(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Clear(temp0);
    }
    else
    {
      op->vtkSteeringDataGenerator::Clear(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSteeringDataGenerator_TransferSelectionToInternals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TransferSelectionToInternals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSteeringDataGenerator *op = static_cast<vtkSteeringDataGenerator *>(vp);

  vtkSelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelection"))
  {
    if (ap.IsBound())
    {
      op->TransferSelectionToInternals(temp0);
    }
    else
    {
      op->vtkSteeringDataGenerator::TransferSelectionToInternals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSteeringDataGenerator_Methods[] = {
  {"IsTypeOf", PyvtkSteeringDataGenerator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSteeringDataGenerator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSteeringDataGenerator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSteeringDataGenerator\nC++: static vtkSteeringDataGenerator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSteeringDataGenerator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSteeringDataGenerator\nC++: vtkSteeringDataGenerator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSteeringDataGenerator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSteeringDataGenerator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPartitionType", PyvtkSteeringDataGenerator_SetPartitionType, METH_VARARGS,
   "SetPartitionType(self, _arg:int) -> None\nC++: virtual void SetPartitionType(int _arg)\n\nChoose the type for a partition in the output\nvtkMultiBlockDataSet. Accepted values are any non-composite\ndataset type know to vtkDataObjectTypes.\n"},
  {"GetPartitionType", PyvtkSteeringDataGenerator_GetPartitionType, METH_VARARGS,
   "GetPartitionType(self) -> int\nC++: virtual int GetPartitionType()\n\n"},
  {"SetFieldAssociation", PyvtkSteeringDataGenerator_SetFieldAssociation, METH_VARARGS,
   "SetFieldAssociation(self, _arg:int) -> None\nC++: virtual void SetFieldAssociation(int _arg)\n\nIndicate the field association to which the specified data arrays\nare added. The FieldAssociation must make sense for the chosen\nPartitionType i.e. setting FieldAssociation to\nvtkDataObjectTypes::FIELD_ASSOCIATION_ROWS for a PartitionType of\nVTK_POLY_DATA is invalid.\n"},
  {"GetFieldAssociation", PyvtkSteeringDataGenerator_GetFieldAssociation, METH_VARARGS,
   "GetFieldAssociation(self) -> int\nC++: virtual int GetFieldAssociation()\n\n"},
  {"SetSelectionConnection", PyvtkSteeringDataGenerator_SetSelectionConnection, METH_VARARGS,
   "SetSelectionConnection(self, index:int,\n    algOutput:vtkAlgorithmOutput) -> None\nC++: void SetSelectionConnection(int index,\n    vtkAlgorithmOutput *algOutput)\nSetSelectionConnection(self, algOutput:vtkAlgorithmOutput) -> None\nC++: void SetSelectionConnection(vtkAlgorithmOutput *algOutput)\n\nConvenience method to specify the selection connection (2nd input\nport).\n\nNote that for now only the first node of the selection will be\nconsidered as we didn't support expresion.\n"},
  {"SetTuple1Double", PyvtkSteeringDataGenerator_SetTuple1Double, METH_VARARGS,
   "SetTuple1Double(self, arrayname:str, index:int, val:float) -> None\nC++: void SetTuple1Double(const char *arrayname, vtkIdType index,\n    double val)\n\nMethods to add individual tuples to the data arrays. The number\nof components and type of the array depends on the API overload\nused. The array is idenfied using arrayname. Array names are\nassumed unique. Changing the type or components of any array\nwithout calling `Clear` first is not supported. The array will be\nresized to contain the tuple indicated.\n"},
  {"SetTuple1Int", PyvtkSteeringDataGenerator_SetTuple1Int, METH_VARARGS,
   "SetTuple1Int(self, arrayname:str, index:int, val:int) -> None\nC++: void SetTuple1Int(const char *arrayname, vtkIdType index,\n    int val)\n\n"},
  {"SetTuple1IdType", PyvtkSteeringDataGenerator_SetTuple1IdType, METH_VARARGS,
   "SetTuple1IdType(self, arrayname:str, index:int, val:int) -> None\nC++: void SetTuple1IdType(const char *arrayname, vtkIdType index,\n    vtkIdType val)\n\n"},
  {"SetTuple2Double", PyvtkSteeringDataGenerator_SetTuple2Double, METH_VARARGS,
   "SetTuple2Double(self, arrayname:str, index:int, val0:float,\n    val1:float) -> None\nC++: void SetTuple2Double(const char *arrayname, vtkIdType index,\n    double val0, double val1)\n\n"},
  {"SetTuple2Int", PyvtkSteeringDataGenerator_SetTuple2Int, METH_VARARGS,
   "SetTuple2Int(self, arrayname:str, index:int, val0:int, val1:int)\n    -> None\nC++: void SetTuple2Int(const char *arrayname, vtkIdType index,\n    int val0, int val1)\n\n"},
  {"SetTuple2IdType", PyvtkSteeringDataGenerator_SetTuple2IdType, METH_VARARGS,
   "SetTuple2IdType(self, arrayname:str, index:int, val0:int,\n    val1:int) -> None\nC++: void SetTuple2IdType(const char *arrayname, vtkIdType index,\n    vtkIdType val0, vtkIdType val1)\n\n"},
  {"SetTuple3Double", PyvtkSteeringDataGenerator_SetTuple3Double, METH_VARARGS,
   "SetTuple3Double(self, arrayname:str, index:int, val0:float,\n    val1:float, val2:float) -> None\nC++: void SetTuple3Double(const char *arrayname, vtkIdType index,\n    double val0, double val1, double val2)\n\n"},
  {"SetTuple3Int", PyvtkSteeringDataGenerator_SetTuple3Int, METH_VARARGS,
   "SetTuple3Int(self, arrayname:str, index:int, val0:int, val1:int,\n    val2:int) -> None\nC++: void SetTuple3Int(const char *arrayname, vtkIdType index,\n    int val0, int val1, int val2)\n\n"},
  {"SetTuple3IdType", PyvtkSteeringDataGenerator_SetTuple3IdType, METH_VARARGS,
   "SetTuple3IdType(self, arrayname:str, index:int, val0:int,\n    val1:int, val3:int) -> None\nC++: void SetTuple3IdType(const char *arrayname, vtkIdType index,\n    vtkIdType val0, vtkIdType val1, vtkIdType val3)\n\n"},
  {"Clear", PyvtkSteeringDataGenerator_Clear, METH_VARARGS,
   "Clear(self, arrayname:str) -> None\nC++: void Clear(const char *arrayname)\n\nRemove the array identified by the arrayname, if any.\n"},
  {"TransferSelectionToInternals", PyvtkSteeringDataGenerator_TransferSelectionToInternals, METH_VARARGS,
   "TransferSelectionToInternals(self, selection:vtkSelection) -> None\nC++: void TransferSelectionToInternals(vtkSelection *selection)\n\nAppend as array the list of selected id and the field type of the\ncurrent selection.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSteeringDataGenerator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("partition_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSteeringDataGenerator_GetPartitionType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSteeringDataGenerator_SetPartitionType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSteeringDataGenerator_SetPartitionType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPartitionType/SetPartitionType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSteeringDataGenerator_GetFieldAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSteeringDataGenerator_SetFieldAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSteeringDataGenerator_SetFieldAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldAssociation/SetFieldAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSteeringDataGenerator_SetSelectionConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSteeringDataGenerator_SetSelectionConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSelectionConnection\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSteeringDataGenerator_Doc =
  "vtkSteeringDataGenerator - source to generate dataset given field\narrays\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkSteeringDataGenerator is simply a dataset generator that generates\n"
  "a single partition vtkMultiBlockDataSet with the 1st partition being\n"
  "non-empty dataset of the type specified using\n"
  "`vtkSteeringDataGenerator::SetPartitionType` with arrays added to the\n"
  "field type chosen using\n"
  "vtkSteeringDataGenerator::SetFieldAssociation`.\n\n"
  "If the PartitionType is a vtkPointSet subclass, then one can use\n"
  "**coords** as the field array name to add point coordinates when\n"
  "FieldAssociation is set to vtkDataObject::FIELD_ASSOCIATION_POINTS.\n\n"
  "A sample proxy definition that uses this source is as follows:\n\n"
  "{xml}\n\n\n"
  " <ProxyGroup name=\"sources\">\n"
  "    <!--\n"
  "====================================================================\n"
  "-->\n"
  "    <SourceProxy class=\"vtkSteeringDataGenerator\"\n"
  "name=\"TestSteeringDataGeneratorSource\">\n\n\n"
  "     <InputProperty command=\"SetSelectionConnection\"\n"
  "                   name=\"Selection\"\n"
  "                   panel_visibility=\"default\"\n"
  "                   port_index=\"0\">\n"
  "       <DataTypeDomain name=\"input_type\">\n"
  "         <DataType value=\"vtkSelection\"/>\n"
  "       \n"
  "       \n"
  "         The input that provides the selection object.\n"
  "       \n"
  "       \n"
  "         <Optional/>\n"
  "         <SelectionInput/>\n"
  "       \n"
  "     \n\n\n"
  "      <IntVectorProperty name=\"PartitionType\"\n"
  "                         command=\"SetPartitionType\"\n"
  "                         number_of_elements=\"1\"\n"
  "                         default_values=\"0\"\n"
  "                         panel_visibility=\"never\">\n"
  "        <!-- 0 == VTK_POLY_DATA -->\n"
  "      \n\n\n"
  "      <IntVectorProperty name=\"FieldAssociation\"\n"
  "                         command=\"SetFieldAssociation\"\n"
  "                         number_of_elements=\"1\"\n"
  "                         default_values=\"0\"\n"
  "                         panel_visibility=\"never\" />\n\n\n"
  "      <DoubleVectorProperty name=\"Center\"\n"
  "                            command=\"SetTuple3Double\"\n"
  "                            use_index=\"1\"\n"
  "                            clean_command=\"Clear\"\n"
  "                            initial_string=\"coords\"\n"
  "                            number_of_elements_per_command=\"3\"\n"
  "                            repeat_command=\"1\" />\n\n\n"
  "      <IdTypeVectorProperty name=\"Id\"\n"
  "                            command=\"SetTuple2IdType\"\n"
  "                            clean_command=\"Clear\"\n"
  "                            use_index=\"1\"\n"
  "                            initial_string=\"Id\"\n"
  "                            number_of_elements_per_command=\"2\"\n"
  "                            repeat_command=\"1\" />\n\n\n"
  "      <IntVectorProperty name=\"Type\"\n"
  "                         command=\"SetTuple1Int\"\n"
  "                         clean_command=\"Clear\"\n"
  "                         use_index=\"1\"\n"
  "                         initial_string=\"Type\"\n"
  "                         number_of_elements_per_command=\"1\"\n"
  "                         repeat_command=\"1\" />\n"
  "    \n"
  "   \n\n"
  "@section vtkSteeringDataGenerator_caveats Caveats\n\n"
  "This filter should ideally generated `vtkPartitionedDataSet`.\n"
  "However, until `vtkPartitionedDataSet` is well supported, we are\n"
  "making it generate vtkMultiBlockDataSet.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSteeringDataGenerator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingLive.vtkSteeringDataGenerator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSteeringDataGenerator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSteeringDataGenerator_StaticNew()
{
  return vtkSteeringDataGenerator::New();
}

PyObject *PyvtkSteeringDataGenerator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSteeringDataGenerator_Type, PyvtkSteeringDataGenerator_Methods,
    "vtkSteeringDataGenerator",
 &PyvtkSteeringDataGenerator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSteeringDataGenerator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSteeringDataGenerator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSteeringDataGenerator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSteeringDataGenerator", o) != 0)
  {
    Py_DECREF(o);
  }

}

