// python wrapper for vtkPVGradientFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGradientFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGradientFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGradientFilter_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGradientFilter_BoundaryMethod_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVGradientFilter.BoundaryMethod", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVGradientFilter_BoundaryMethod_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVGradientFilter_BoundaryMethod_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVGradientFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGradientFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGradientFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGradientFilter *tempr = vtkPVGradientFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGradientFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGradientFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGradientFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGradientFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_SetDimensionality(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionality");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionality(temp0);
    }
    else
    {
      op->vtkPVGradientFilter::SetDimensionality(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetDimensionalityMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionalityMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDimensionalityMinValue() :
      op->vtkPVGradientFilter::GetDimensionalityMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetDimensionalityMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionalityMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDimensionalityMaxValue() :
      op->vtkPVGradientFilter::GetDimensionalityMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetDimensionality(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionality");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDimensionality() :
      op->vtkPVGradientFilter::GetDimensionality());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_SetBoundaryMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryMethod(temp0);
    }
    else
    {
      op->vtkPVGradientFilter::SetBoundaryMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetBoundaryMethodMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryMethodMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryMethodMinValue() :
      op->vtkPVGradientFilter::GetBoundaryMethodMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetBoundaryMethodMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryMethodMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryMethodMaxValue() :
      op->vtkPVGradientFilter::GetBoundaryMethodMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetBoundaryMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryMethod() :
      op->vtkPVGradientFilter::GetBoundaryMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_SetHTGMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHTGMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHTGMode(temp0);
    }
    else
    {
      op->vtkPVGradientFilter::SetHTGMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetHTGModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGModeMinValue() :
      op->vtkPVGradientFilter::GetHTGModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetHTGModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGModeMaxValue() :
      op->vtkPVGradientFilter::GetHTGModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetHTGMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetHTGMode() :
      op->vtkPVGradientFilter::GetHTGMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_SetHTGExtensiveComputation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHTGExtensiveComputation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHTGExtensiveComputation(temp0);
    }
    else
    {
      op->vtkPVGradientFilter::SetHTGExtensiveComputation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_GetHTGExtensiveComputation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHTGExtensiveComputation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHTGExtensiveComputation() :
      op->vtkPVGradientFilter::GetHTGExtensiveComputation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_HTGExtensiveComputationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HTGExtensiveComputationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HTGExtensiveComputationOn();
    }
    else
    {
      op->vtkPVGradientFilter::HTGExtensiveComputationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGradientFilter_HTGExtensiveComputationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HTGExtensiveComputationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGradientFilter *op = static_cast<vtkPVGradientFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HTGExtensiveComputationOff();
    }
    else
    {
      op->vtkPVGradientFilter::HTGExtensiveComputationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGradientFilter_Methods[] = {
  {"IsTypeOf", PyvtkPVGradientFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGradientFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGradientFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGradientFilter\nC++: static vtkPVGradientFilter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGradientFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGradientFilter\nC++: vtkPVGradientFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGradientFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGradientFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetDimensionality", PyvtkPVGradientFilter_SetDimensionality, METH_VARARGS,
   "SetDimensionality(self, _arg:int) -> None\nC++: virtual void SetDimensionality(int _arg)\n\nGet/Set the number of dimensions used to compute the gradient\nwhen using SMOOTHED. In two dimensions, the X and Y dimensions\nare used. The default is set to 3. Used in vtkImageGradient for\nthe vtkImageData type. The default is set to 3.\n"},
  {"GetDimensionalityMinValue", PyvtkPVGradientFilter_GetDimensionalityMinValue, METH_VARARGS,
   "GetDimensionalityMinValue(self) -> int\nC++: virtual int GetDimensionalityMinValue()\n\n"},
  {"GetDimensionalityMaxValue", PyvtkPVGradientFilter_GetDimensionalityMaxValue, METH_VARARGS,
   "GetDimensionalityMaxValue(self) -> int\nC++: virtual int GetDimensionalityMaxValue()\n\n"},
  {"GetDimensionality", PyvtkPVGradientFilter_GetDimensionality, METH_VARARGS,
   "GetDimensionality(self) -> int\nC++: virtual int GetDimensionality()\n\n"},
  {"SetBoundaryMethod", PyvtkPVGradientFilter_SetBoundaryMethod, METH_VARARGS,
   "SetBoundaryMethod(self, _arg:int) -> None\nC++: virtual void SetBoundaryMethod(int _arg)\n\nGet/Set the method used to compute the gradient on the boundaries\nof a vtkImageData. SMOOTHED corresponds to the vtkImageGradient\nimplementation with HandleBoundaries on, while NON_SMOOTHED\ncorresponds to the vtkGradientFilter implementation. The default\nis set to NON_SMOOTHED.\n"},
  {"GetBoundaryMethodMinValue", PyvtkPVGradientFilter_GetBoundaryMethodMinValue, METH_VARARGS,
   "GetBoundaryMethodMinValue(self) -> int\nC++: virtual int GetBoundaryMethodMinValue()\n\n"},
  {"GetBoundaryMethodMaxValue", PyvtkPVGradientFilter_GetBoundaryMethodMaxValue, METH_VARARGS,
   "GetBoundaryMethodMaxValue(self) -> int\nC++: virtual int GetBoundaryMethodMaxValue()\n\n"},
  {"GetBoundaryMethod", PyvtkPVGradientFilter_GetBoundaryMethod, METH_VARARGS,
   "GetBoundaryMethod(self) -> int\nC++: virtual int GetBoundaryMethod()\n\n"},
  {"SetHTGMode", PyvtkPVGradientFilter_SetHTGMode, METH_VARARGS,
   "SetHTGMode(self, _arg:int) -> None\nC++: virtual void SetHTGMode(int _arg)\n\nGet/Set the mode used to compute the gradient on a\nvtkHyperTreeGrid. Reminder: in the context of HyperTreeGrids,\npossible values for gradient computation are:\n- UNLIMITED - Neighborhood is virtually refined so coarser cells\n  have limited impact on finer ones.\n- UNSTRUCTURED - Coarser cells are processed as is and may have a\ngreater weight than finer cells. The default is set to UNLIMITED.\n"},
  {"GetHTGModeMinValue", PyvtkPVGradientFilter_GetHTGModeMinValue, METH_VARARGS,
   "GetHTGModeMinValue(self) -> int\nC++: virtual int GetHTGModeMinValue()\n\n"},
  {"GetHTGModeMaxValue", PyvtkPVGradientFilter_GetHTGModeMaxValue, METH_VARARGS,
   "GetHTGModeMaxValue(self) -> int\nC++: virtual int GetHTGModeMaxValue()\n\n"},
  {"GetHTGMode", PyvtkPVGradientFilter_GetHTGMode, METH_VARARGS,
   "GetHTGMode(self) -> int\nC++: virtual int GetHTGMode()\n\n"},
  {"SetHTGExtensiveComputation", PyvtkPVGradientFilter_SetHTGExtensiveComputation, METH_VARARGS,
   "SetHTGExtensiveComputation(self, _arg:bool) -> None\nC++: virtual void SetHTGExtensiveComputation(bool _arg)\n\nGet/Set the extensiveness mode used to compute the gradient on a\nvtkHyperTreeGrid. This parameter only work in UNLIMITED mode.\nHTGExtensiveComputation is meant to reduce the influence of an\nattribute as the corresponding cell is virtually subdivided. The\ndefault is set to false.\n"},
  {"GetHTGExtensiveComputation", PyvtkPVGradientFilter_GetHTGExtensiveComputation, METH_VARARGS,
   "GetHTGExtensiveComputation(self) -> bool\nC++: virtual bool GetHTGExtensiveComputation()\n\n"},
  {"HTGExtensiveComputationOn", PyvtkPVGradientFilter_HTGExtensiveComputationOn, METH_VARARGS,
   "HTGExtensiveComputationOn(self) -> None\nC++: virtual void HTGExtensiveComputationOn()\n\n"},
  {"HTGExtensiveComputationOff", PyvtkPVGradientFilter_HTGExtensiveComputationOff, METH_VARARGS,
   "HTGExtensiveComputationOff(self) -> None\nC++: virtual void HTGExtensiveComputationOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGradientFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("dimensionality"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGradientFilter_GetDimensionality(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGradientFilter_SetDimensionality(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGradientFilter_SetDimensionality(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionality/SetDimensionality\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("boundary_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGradientFilter_GetBoundaryMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGradientFilter_SetBoundaryMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGradientFilter_SetBoundaryMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBoundaryMethod/SetBoundaryMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("htg_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGradientFilter_GetHTGMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGradientFilter_SetHTGMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGradientFilter_SetHTGMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHTGMode/SetHTGMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("htg_extensive_computation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGradientFilter_GetHTGExtensiveComputation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGradientFilter_SetHTGExtensiveComputation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGradientFilter_SetHTGExtensiveComputation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHTGExtensiveComputation/SetHTGExtensiveComputation\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGradientFilter_Doc =
  "vtkPVGradientFilter - Filter to unify gradient implementations for\ndifferent types.\n\n"
  "Superclass: vtkGradientFilter\n\n"
  "This is a subclass of vtkGradientFilter that allows to apply gradient\n"
  "filters to different structure types through a unique filter. In\n"
  "practice, vtkGradientFilter can be applied to any vtkDataSet. For\n"
  "unstructured grids, the gradient is computed using the cell\n"
  "derivatives, while for structured grids, central differencing is\n"
  "used, except on the boundaries of the dataset where forward and\n"
  "backward differencing is used for the boundary elements. For\n"
  "vtkImageData, it is possible to use the vtkImageGradient\n"
  "implementation. Note that vtkImageGradient always uses central\n"
  "differencing by duplicating the boundary values, which has a\n"
  "smoothing effect. This can be done by setting the boundary handling\n"
  "method to 'SMOOTHED'.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGradientFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVGradientFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGradientFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGradientFilter_StaticNew()
{
  return vtkPVGradientFilter::New();
}

PyObject *PyvtkPVGradientFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGradientFilter_Type, PyvtkPVGradientFilter_Methods,
    "vtkPVGradientFilter",
 &PyvtkPVGradientFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGradientFilter");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVGradientFilter_BoundaryMethod_Type);
  PyVTKEnum_Add(&PyvtkPVGradientFilter_BoundaryMethod_Type, "vtkPVGradientFilter.BoundaryMethod");

  o = (PyObject *)&PyvtkPVGradientFilter_BoundaryMethod_Type;
  if (PyDict_SetItemString(d, "BoundaryMethod", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "SMOOTHED", vtkPVGradientFilter::SMOOTHED },
        { "NON_SMOOTHED", vtkPVGradientFilter::NON_SMOOTHED },
      };

    o = PyvtkPVGradientFilter_BoundaryMethod_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGradientFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGradientFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGradientFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGradientFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

