/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_INC_HELPIDS_H
#define INCLUDED_SVX_INC_HELPIDS_H

#include <rtl/ustring.hxx>

inline constexpr OUString HID_BMPMASK_CTL_QCOL_1 = u"SVX_HID_BMPMASK_CTL_QCOL_1"_ustr;
inline constexpr OUString HID_COLOR_CTL_COLORS = u"SVX_HID_COLOR_CTL_COLORS"_ustr;
inline constexpr OUString HID_CTRL3D_HSCROLL = u"SVX_HID_CTRL3D_HSCROLL"_ustr;
inline constexpr OUString HID_CTRL3D_SWITCHER = u"SVX_HID_CTRL3D_SWITCHER"_ustr;
inline constexpr OUString HID_CTRL3D_VSCROLL = u"SVX_HID_CTRL3D_VSCROLL"_ustr;
inline constexpr OUString HID_CTRL_COLOR = u"SVX_HID_CTRL_COLOR"_ustr;
inline constexpr OUString HID_POPUP_COLOR = u"SVX_HID_POPUP_COLOR"_ustr;
inline constexpr OUString HID_POPUP_COLOR_CTRL = u"SVX_HID_POPUP_COLOR_CTRL"_ustr;
inline constexpr OUString HID_POPUP_FRAME = u"SVX_HID_POPUP_FRAME"_ustr;
inline constexpr OUString HID_POPUP_LINE = u"SVX_HID_POPUP_LINE"_ustr;
inline constexpr OUString HID_POPUP_LINEEND = u"SVX_HID_POPUP_LINEEND"_ustr;
inline constexpr OUString HID_POPUP_LINEEND_CTRL = u"SVX_HID_POPUP_LINEEND_CTRL"_ustr;
inline constexpr OUString HID_STYLE_LISTBOX = u"SVX_HID_STYLE_LISTBOX"_ustr;
inline constexpr OUString HID_VALUESET_EXTRUSION_LIGHTING = u"SVX_HID_VALUESET_EXTRUSION_LIGHTING"_ustr;
inline constexpr OUString HID_UNDERLINE_BTN = u"SVX_HID_UNDERLINE_BTN"_ustr;
inline constexpr OUString HID_SPACING_MB_KERN = u"SVX_HID_SPACING_MB_KERN"_ustr;

inline constexpr OUString HID_FORM_NAVIGATOR = u"SVX_HID_FORM_NAVIGATOR"_ustr;
inline constexpr OUString HID_FORM_NAVIGATOR_WIN = u"SVX_HID_FORM_NAVIGATOR_WIN"_ustr;
inline constexpr OUString HID_FIELD_SEL = u"SVX_HID_FIELD_SEL"_ustr;
inline constexpr OUString HID_FIELD_SEL_WIN = u"SVX_HID_FIELD_SEL_WIN"_ustr;
inline constexpr OUString HID_FILTER_NAVIGATOR = u"SVX_HID_FILTER_NAVIGATOR"_ustr;
inline constexpr OUString HID_FILTER_NAVIGATOR_WIN = u"SVX_HID_FILTER_NAVIGATOR_WIN"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_FIRST = u"SVX_HID_GRID_TRAVEL_FIRST"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_PREV = u"SVX_HID_GRID_TRAVEL_PREV"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_NEXT = u"SVX_HID_GRID_TRAVEL_NEXT"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_LAST = u"SVX_HID_GRID_TRAVEL_LAST"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_NEW = u"SVX_HID_GRID_TRAVEL_NEW"_ustr;
inline constexpr OUString HID_GRID_TRAVEL_ABSOLUTE = u"SVX_HID_GRID_TRAVEL_ABSOLUTE"_ustr;
inline constexpr OUString HID_GRID_NUMBEROFRECORDS = u"SVX_HID_GRID_NUMBEROFRECORDS"_ustr;

// Help IDs for Manage Track Changes
inline constexpr OUString HID_REDLINE_CTRL_VIEW = u"SVX_HID_REDLINE_CTRL_VIEW"_ustr;
inline constexpr OUString HID_REDLINE_CTRL_FILTER = u"SVX_HID_REDLINE_CTRL_FILTER"_ustr;

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
