#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0073\x0068\x0073";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0068\x0075\x0073\x0077\x0061\x0070";
static constexpr OUStringLiteral countryID = u"\x0043\x0041";
static constexpr OUStringLiteral countryDefaultName = u"\x0043\x0061\x006e\x0061\x0064\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_shs_CA(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"";
static constexpr OUStringLiteral dateSeparator = u"\x002d";
static constexpr OUStringLiteral thousandSeparator = u"\x002c";
static constexpr OUStringLiteral decimalSeparator = u"\x002e";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002e";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"\x002c\x0020";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x002c\x0020";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x0020";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x0020";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x201c";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x201d";
static constexpr OUStringLiteral timeAM = u"\x0041\x004d";
static constexpr OUStringLiteral timePM = u"\x0050\x004d";
static constexpr OUStringLiteral measurementSystem = u"\x006d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_shs_CA(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceFrom0[] = {0x5b, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x59, 0x5d, 0x0};
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x24, 0x2d, 0x36, 0x34, 0x38, 0x5d, 0x0};
static constexpr OUStringLiteral FormatKey0 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement0 = u"\x1";
static constexpr OUStringLiteral FormatType0 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage0 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex0 = u"\x0";
static constexpr OUStringLiteral FormatCode0 = u"\x0047\x0065\x006e\x0065\x0072\x0061\x006c";
static constexpr OUStringLiteral FormatDefaultName0 = u"";
static constexpr OUStringLiteral FormatKey1 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement1 = u"\x1";
static constexpr OUStringLiteral FormatType1 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage1 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex1 = u"\x1";
static constexpr OUStringLiteral FormatCode1 = u"\x0030";
static constexpr OUStringLiteral FormatDefaultName1 = u"";
static constexpr OUStringLiteral FormatKey2 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement2 = u"\x0";
static constexpr OUStringLiteral FormatType2 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage2 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex2 = u"\x2";
static constexpr OUStringLiteral FormatCode2 = u"\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName2 = u"";
static constexpr OUStringLiteral FormatKey3 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement3 = u"\x0";
static constexpr OUStringLiteral FormatType3 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage3 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex3 = u"\x3";
static constexpr OUStringLiteral FormatCode3 = u"\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName3 = u"";
static constexpr OUStringLiteral FormatKey4 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement4 = u"\x0";
static constexpr OUStringLiteral FormatType4 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage4 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex4 = u"\x4";
static constexpr OUStringLiteral FormatCode4 = u"\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName4 = u"";
static constexpr OUStringLiteral FormatKey5 = u"\x0046\x0069\x0078\x0065\x0064\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement5 = u"\x0";
static constexpr OUStringLiteral FormatType5 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage5 = u"\x0046\x0049\x0058\x0045\x0044\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex5 = u"\x5";
static constexpr OUStringLiteral FormatCode5 = u"\x0023\x002c\x0023\x0023\x0023\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName5 = u"";
static constexpr OUStringLiteral FormatKey6 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement6 = u"\x0";
static constexpr OUStringLiteral FormatType6 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage6 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex6 = u"\x6";
static constexpr OUStringLiteral FormatCode6 = u"\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName6 = u"";
static constexpr OUStringLiteral FormatKey7 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement7 = u"\x1";
static constexpr OUStringLiteral FormatType7 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage7 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex7 = u"\x7";
static constexpr OUStringLiteral FormatCode7 = u"\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName7 = u"";
static constexpr OUStringLiteral FormatKey8 = u"\x0053\x0063\x0069\x0065\x006e\x0074\x0069\x0066\x0069\x0063\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement8 = u"\x0";
static constexpr OUStringLiteral FormatType8 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage8 = u"\x0053\x0043\x0049\x0045\x004e\x0054\x0049\x0046\x0049\x0043\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex8 = u"\x4e";
static constexpr OUStringLiteral FormatCode8 = u"\x0023\x0023\x0030\x002e\x0030\x0030\x0045\x002b\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName8 = u"";
static constexpr OUStringLiteral FormatKey9 = u"\x0050\x0065\x0072\x0063\x0065\x006e\x0074\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement9 = u"\x1";
static constexpr OUStringLiteral FormatType9 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage9 = u"\x0050\x0045\x0052\x0043\x0045\x004e\x0054\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex9 = u"\x8";
static constexpr OUStringLiteral FormatCode9 = u"\x0030\x0025";
static constexpr OUStringLiteral FormatDefaultName9 = u"";
static constexpr OUStringLiteral FormatKey10 = u"\x0050\x0065\x0072\x0063\x0065\x006e\x0074\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement10 = u"\x1";
static constexpr OUStringLiteral FormatType10 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage10 = u"\x0050\x0045\x0052\x0043\x0045\x004e\x0054\x005f\x004e\x0055\x004d\x0042\x0045\x0052";
static constexpr OUStringLiteral Formatindex10 = u"\x9";
static constexpr OUStringLiteral FormatCode10 = u"\x0030\x002e\x0030\x0030\x0025";
static constexpr OUStringLiteral FormatDefaultName10 = u"";
static constexpr OUStringLiteral FormatKey11 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement11 = u"\x1";
static constexpr OUStringLiteral FormatType11 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage11 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex11 = u"\xc";
static constexpr OUStringLiteral FormatCode11 = u"\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x003b\x002d\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName11 = u"";
static constexpr OUStringLiteral FormatKey12 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement12 = u"\x0";
static constexpr OUStringLiteral FormatType12 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage12 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex12 = u"\xd";
static constexpr OUStringLiteral FormatCode12 = u"\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x003b\x002d\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName12 = u"";
static constexpr OUStringLiteral FormatKey13 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement13 = u"\x0";
static constexpr OUStringLiteral FormatType13 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage13 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex13 = u"\xe";
static constexpr OUStringLiteral FormatCode13 = u"\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030";
static constexpr OUStringLiteral FormatDefaultName13 = u"";
static constexpr OUStringLiteral FormatKey14 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement14 = u"\x1";
static constexpr OUStringLiteral FormatType14 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage14 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex14 = u"\xf";
static constexpr OUStringLiteral FormatCode14 = u"\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName14 = u"";
static constexpr OUStringLiteral FormatKey15 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement15 = u"\x0";
static constexpr OUStringLiteral FormatType15 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage15 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex15 = u"\x10";
static constexpr OUStringLiteral FormatCode15 = u"\x0023\x002c\x0023\x0023\x0030\x002e\x0030\x0030\x0020\x0043\x0043\x0043";
static constexpr OUStringLiteral FormatDefaultName15 = u"";
static constexpr OUStringLiteral FormatKey16 = u"\x0043\x0075\x0072\x0072\x0065\x006e\x0063\x0079\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement16 = u"\x0";
static constexpr OUStringLiteral FormatType16 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage16 = u"\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059";
static constexpr OUStringLiteral Formatindex16 = u"\x11";
static constexpr OUStringLiteral FormatCode16 = u"\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x002d\x002d\x003b\x005b\x0052\x0045\x0044\x005d\x002d\x005b\x0043\x0055\x0052\x0052\x0045\x004e\x0043\x0059\x005d\x0023\x002c\x0023\x0023\x0030\x002e\x002d\x002d";
static constexpr OUStringLiteral FormatDefaultName16 = u"";
static constexpr OUStringLiteral FormatKey17 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement17 = u"\x1";
static constexpr OUStringLiteral FormatType17 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage17 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex17 = u"\x12";
static constexpr OUStringLiteral FormatCode17 = u"\x0059\x0059\x002d\x004d\x002d\x0044";
static constexpr OUStringLiteral FormatDefaultName17 = u"";
static constexpr OUStringLiteral FormatKey18 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0039";
static constexpr OUStringLiteral defaultFormatElement18 = u"\x1";
static constexpr OUStringLiteral FormatType18 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage18 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex18 = u"\x13";
static constexpr OUStringLiteral FormatCode18 = u"\x004e\x004e\x004e\x004e\x004d\x004d\x004d\x004d\x0020\x0044\x0044\x002c\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName18 = u"";
static constexpr OUStringLiteral FormatKey19 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0038";
static constexpr OUStringLiteral defaultFormatElement19 = u"\x0";
static constexpr OUStringLiteral FormatType19 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage19 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex19 = u"\x14";
static constexpr OUStringLiteral FormatCode19 = u"\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName19 = u"";
static constexpr OUStringLiteral FormatKey20 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0037";
static constexpr OUStringLiteral defaultFormatElement20 = u"\x1";
static constexpr OUStringLiteral FormatType20 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage20 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex20 = u"\x15";
static constexpr OUStringLiteral FormatCode20 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName20 = u"";
static constexpr OUStringLiteral FormatKey21 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0030";
static constexpr OUStringLiteral defaultFormatElement21 = u"\x0";
static constexpr OUStringLiteral FormatType21 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage21 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex21 = u"\x16";
static constexpr OUStringLiteral FormatCode21 = u"\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName21 = u"";
static constexpr OUStringLiteral FormatKey22 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0031";
static constexpr OUStringLiteral defaultFormatElement22 = u"\x0";
static constexpr OUStringLiteral FormatType22 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage22 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex22 = u"\x17";
static constexpr OUStringLiteral FormatCode22 = u"\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName22 = u"";
static constexpr OUStringLiteral FormatKey23 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0036";
static constexpr OUStringLiteral defaultFormatElement23 = u"\x0";
static constexpr OUStringLiteral FormatType23 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage23 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex23 = u"\x18";
static constexpr OUStringLiteral FormatCode23 = u"\x0044\x002e\x0020\x004d\x004d\x004d\x002e\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName23 = u"";
static constexpr OUStringLiteral FormatKey24 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0032";
static constexpr OUStringLiteral defaultFormatElement24 = u"\x0";
static constexpr OUStringLiteral FormatType24 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage24 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex24 = u"\x19";
static constexpr OUStringLiteral FormatCode24 = u"\x004d\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName24 = u"";
static constexpr OUStringLiteral FormatKey25 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0037";
static constexpr OUStringLiteral defaultFormatElement25 = u"\x0";
static constexpr OUStringLiteral FormatType25 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage25 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex25 = u"\x1a";
static constexpr OUStringLiteral FormatCode25 = u"\x0044\x002e\x0020\x004d\x004d\x004d\x004d\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName25 = u"";
static constexpr OUStringLiteral FormatKey26 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0033";
static constexpr OUStringLiteral defaultFormatElement26 = u"\x0";
static constexpr OUStringLiteral FormatType26 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage26 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex26 = u"\x1b";
static constexpr OUStringLiteral FormatCode26 = u"\x004e\x004e\x002c\x0020\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName26 = u"";
static constexpr OUStringLiteral FormatKey27 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement27 = u"\x0";
static constexpr OUStringLiteral FormatType27 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage27 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex27 = u"\x1c";
static constexpr OUStringLiteral FormatCode27 = u"\x004e\x004e\x0020\x0044\x0044\x002d\x004d\x004d\x004d\x0020\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName27 = u"";
static constexpr OUStringLiteral FormatKey28 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0034";
static constexpr OUStringLiteral defaultFormatElement28 = u"\x0";
static constexpr OUStringLiteral FormatType28 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage28 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex28 = u"\x1d";
static constexpr OUStringLiteral FormatCode28 = u"\x004e\x004e\x002c\x0020\x004d\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName28 = u"";
static constexpr OUStringLiteral FormatKey29 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0035";
static constexpr OUStringLiteral defaultFormatElement29 = u"\x0";
static constexpr OUStringLiteral FormatType29 = u"\x006c\x006f\x006e\x0067";
static constexpr OUStringLiteral FormatUsage29 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex29 = u"\x1e";
static constexpr OUStringLiteral FormatCode29 = u"\x004e\x004e\x004e\x004e\x004d\x004d\x004d\x004d\x0020\x0044\x002c\x0020\x0059\x0059\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName29 = u"";
static constexpr OUStringLiteral FormatKey30 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0038";
static constexpr OUStringLiteral defaultFormatElement30 = u"\x0";
static constexpr OUStringLiteral FormatType30 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage30 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex30 = u"\x1f";
static constexpr OUStringLiteral FormatCode30 = u"\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName30 = u"";
static constexpr OUStringLiteral FormatKey31 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031\x0039";
static constexpr OUStringLiteral defaultFormatElement31 = u"\x0";
static constexpr OUStringLiteral FormatType31 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage31 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex31 = u"\x20";
static constexpr OUStringLiteral FormatCode31 = u"\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName31 = u"";
static constexpr OUStringLiteral FormatKey32 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032\x0030";
static constexpr OUStringLiteral defaultFormatElement32 = u"\x0";
static constexpr OUStringLiteral FormatType32 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage32 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex32 = u"\x21";
static constexpr OUStringLiteral FormatCode32 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName32 = u"\x0049\x0053\x004f\x0020\x0038\x0036\x0030\x0031";
static constexpr OUStringLiteral FormatKey33 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement33 = u"\x0";
static constexpr OUStringLiteral FormatType33 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage33 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex33 = u"\x22";
static constexpr OUStringLiteral FormatCode33 = u"\x0059\x0059\x002d\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName33 = u"";
static constexpr OUStringLiteral FormatKey34 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement34 = u"\x0";
static constexpr OUStringLiteral FormatType34 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage34 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex34 = u"\x23";
static constexpr OUStringLiteral FormatCode34 = u"\x004d\x004d\x004d\x0020\x0044\x0044";
static constexpr OUStringLiteral FormatDefaultName34 = u"";
static constexpr OUStringLiteral FormatKey35 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement35 = u"\x0";
static constexpr OUStringLiteral FormatType35 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage35 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex35 = u"\x24";
static constexpr OUStringLiteral FormatCode35 = u"\x004d\x004d\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName35 = u"";
static constexpr OUStringLiteral FormatKey36 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement36 = u"\x0";
static constexpr OUStringLiteral FormatType36 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage36 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex36 = u"\x25";
static constexpr OUStringLiteral FormatCode36 = u"\x0051\x0051\x0020\x0059\x0059";
static constexpr OUStringLiteral FormatDefaultName36 = u"";
static constexpr OUStringLiteral FormatKey37 = u"\x0044\x0061\x0074\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032\x0031";
static constexpr OUStringLiteral defaultFormatElement37 = u"\x0";
static constexpr OUStringLiteral FormatType37 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage37 = u"\x0044\x0041\x0054\x0045";
static constexpr OUStringLiteral Formatindex37 = u"\x26";
static constexpr OUStringLiteral FormatCode37 = u"\x0057\x0057";
static constexpr OUStringLiteral FormatDefaultName37 = u"";
static constexpr OUStringLiteral FormatKey38 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement38 = u"\x0";
static constexpr OUStringLiteral FormatType38 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage38 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex38 = u"\x27";
static constexpr OUStringLiteral FormatCode38 = u"\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName38 = u"";
static constexpr OUStringLiteral FormatKey39 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement39 = u"\x0";
static constexpr OUStringLiteral FormatType39 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage39 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex39 = u"\x28";
static constexpr OUStringLiteral FormatCode39 = u"\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName39 = u"";
static constexpr OUStringLiteral FormatKey40 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement40 = u"\x1";
static constexpr OUStringLiteral FormatType40 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage40 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex40 = u"\x29";
static constexpr OUStringLiteral FormatCode40 = u"\x0048\x0048\x003a\x004d\x004d\x0020\x0041\x004d\x002f\x0050\x004d";
static constexpr OUStringLiteral FormatDefaultName40 = u"";
static constexpr OUStringLiteral FormatKey41 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0034";
static constexpr OUStringLiteral defaultFormatElement41 = u"\x1";
static constexpr OUStringLiteral FormatType41 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage41 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex41 = u"\x2a";
static constexpr OUStringLiteral FormatCode41 = u"\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053\x0020\x0041\x004d\x002f\x0050\x004d";
static constexpr OUStringLiteral FormatDefaultName41 = u"";
static constexpr OUStringLiteral FormatKey42 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0035";
static constexpr OUStringLiteral defaultFormatElement42 = u"\x0";
static constexpr OUStringLiteral FormatType42 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage42 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex42 = u"\x2b";
static constexpr OUStringLiteral FormatCode42 = u"\x005b\x0048\x0048\x005d\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName42 = u"";
static constexpr OUStringLiteral FormatKey43 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0036";
static constexpr OUStringLiteral defaultFormatElement43 = u"\x0";
static constexpr OUStringLiteral FormatType43 = u"\x0073\x0068\x006f\x0072\x0074";
static constexpr OUStringLiteral FormatUsage43 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex43 = u"\x2c";
static constexpr OUStringLiteral FormatCode43 = u"\x004d\x004d\x003a\x0053\x0053\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName43 = u"";
static constexpr OUStringLiteral FormatKey44 = u"\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0037";
static constexpr OUStringLiteral defaultFormatElement44 = u"\x0";
static constexpr OUStringLiteral FormatType44 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage44 = u"\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex44 = u"\x2d";
static constexpr OUStringLiteral FormatCode44 = u"\x005b\x0048\x0048\x005d\x003a\x004d\x004d\x003a\x0053\x0053\x002e\x0030\x0030";
static constexpr OUStringLiteral FormatDefaultName44 = u"";
static constexpr OUStringLiteral FormatKey45 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0031";
static constexpr OUStringLiteral defaultFormatElement45 = u"\x0";
static constexpr OUStringLiteral FormatType45 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage45 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex45 = u"\x2e";
static constexpr OUStringLiteral FormatCode45 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044\x0020\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName45 = u"";
static constexpr OUStringLiteral FormatKey46 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0032";
static constexpr OUStringLiteral defaultFormatElement46 = u"\x0";
static constexpr OUStringLiteral FormatType46 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage46 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex46 = u"\x2f";
static constexpr OUStringLiteral FormatCode46 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044\x0020\x0048\x0048\x003a\x004d\x004d\x003a\x0053\x0053";
static constexpr OUStringLiteral FormatDefaultName46 = u"";
static constexpr OUStringLiteral FormatKey47 = u"\x0044\x0061\x0074\x0065\x0054\x0069\x006d\x0065\x0046\x006f\x0072\x006d\x0061\x0074\x0073\x006b\x0065\x0079\x0033";
static constexpr OUStringLiteral defaultFormatElement47 = u"\x1";
static constexpr OUStringLiteral FormatType47 = u"\x006d\x0065\x0064\x0069\x0075\x006d";
static constexpr OUStringLiteral FormatUsage47 = u"\x0044\x0041\x0054\x0045\x005f\x0054\x0049\x004d\x0045";
static constexpr OUStringLiteral Formatindex47 = u"\x32";
static constexpr OUStringLiteral FormatCode47 = u"\x0059\x0059\x0059\x0059\x002d\x004d\x004d\x002d\x0044\x0044\x0020\x0048\x0048\x003a\x004d\x004d";
static constexpr OUStringLiteral FormatDefaultName47 = u"";

static const sal_Int16 FormatElementsCount0 = 48;
static constexpr OUString FormatElementsArray0[] = {
	FormatCode0,
	FormatDefaultName0,
	FormatKey0,
	FormatType0,
	FormatUsage0,
	Formatindex0,
	defaultFormatElement0,
	FormatCode1,
	FormatDefaultName1,
	FormatKey1,
	FormatType1,
	FormatUsage1,
	Formatindex1,
	defaultFormatElement1,
	FormatCode2,
	FormatDefaultName2,
	FormatKey2,
	FormatType2,
	FormatUsage2,
	Formatindex2,
	defaultFormatElement2,
	FormatCode3,
	FormatDefaultName3,
	FormatKey3,
	FormatType3,
	FormatUsage3,
	Formatindex3,
	defaultFormatElement3,
	FormatCode4,
	FormatDefaultName4,
	FormatKey4,
	FormatType4,
	FormatUsage4,
	Formatindex4,
	defaultFormatElement4,
	FormatCode5,
	FormatDefaultName5,
	FormatKey5,
	FormatType5,
	FormatUsage5,
	Formatindex5,
	defaultFormatElement5,
	FormatCode6,
	FormatDefaultName6,
	FormatKey6,
	FormatType6,
	FormatUsage6,
	Formatindex6,
	defaultFormatElement6,
	FormatCode7,
	FormatDefaultName7,
	FormatKey7,
	FormatType7,
	FormatUsage7,
	Formatindex7,
	defaultFormatElement7,
	FormatCode8,
	FormatDefaultName8,
	FormatKey8,
	FormatType8,
	FormatUsage8,
	Formatindex8,
	defaultFormatElement8,
	FormatCode9,
	FormatDefaultName9,
	FormatKey9,
	FormatType9,
	FormatUsage9,
	Formatindex9,
	defaultFormatElement9,
	FormatCode10,
	FormatDefaultName10,
	FormatKey10,
	FormatType10,
	FormatUsage10,
	Formatindex10,
	defaultFormatElement10,
	FormatCode11,
	FormatDefaultName11,
	FormatKey11,
	FormatType11,
	FormatUsage11,
	Formatindex11,
	defaultFormatElement11,
	FormatCode12,
	FormatDefaultName12,
	FormatKey12,
	FormatType12,
	FormatUsage12,
	Formatindex12,
	defaultFormatElement12,
	FormatCode13,
	FormatDefaultName13,
	FormatKey13,
	FormatType13,
	FormatUsage13,
	Formatindex13,
	defaultFormatElement13,
	FormatCode14,
	FormatDefaultName14,
	FormatKey14,
	FormatType14,
	FormatUsage14,
	Formatindex14,
	defaultFormatElement14,
	FormatCode15,
	FormatDefaultName15,
	FormatKey15,
	FormatType15,
	FormatUsage15,
	Formatindex15,
	defaultFormatElement15,
	FormatCode16,
	FormatDefaultName16,
	FormatKey16,
	FormatType16,
	FormatUsage16,
	Formatindex16,
	defaultFormatElement16,
	FormatCode17,
	FormatDefaultName17,
	FormatKey17,
	FormatType17,
	FormatUsage17,
	Formatindex17,
	defaultFormatElement17,
	FormatCode18,
	FormatDefaultName18,
	FormatKey18,
	FormatType18,
	FormatUsage18,
	Formatindex18,
	defaultFormatElement18,
	FormatCode19,
	FormatDefaultName19,
	FormatKey19,
	FormatType19,
	FormatUsage19,
	Formatindex19,
	defaultFormatElement19,
	FormatCode20,
	FormatDefaultName20,
	FormatKey20,
	FormatType20,
	FormatUsage20,
	Formatindex20,
	defaultFormatElement20,
	FormatCode21,
	FormatDefaultName21,
	FormatKey21,
	FormatType21,
	FormatUsage21,
	Formatindex21,
	defaultFormatElement21,
	FormatCode22,
	FormatDefaultName22,
	FormatKey22,
	FormatType22,
	FormatUsage22,
	Formatindex22,
	defaultFormatElement22,
	FormatCode23,
	FormatDefaultName23,
	FormatKey23,
	FormatType23,
	FormatUsage23,
	Formatindex23,
	defaultFormatElement23,
	FormatCode24,
	FormatDefaultName24,
	FormatKey24,
	FormatType24,
	FormatUsage24,
	Formatindex24,
	defaultFormatElement24,
	FormatCode25,
	FormatDefaultName25,
	FormatKey25,
	FormatType25,
	FormatUsage25,
	Formatindex25,
	defaultFormatElement25,
	FormatCode26,
	FormatDefaultName26,
	FormatKey26,
	FormatType26,
	FormatUsage26,
	Formatindex26,
	defaultFormatElement26,
	FormatCode27,
	FormatDefaultName27,
	FormatKey27,
	FormatType27,
	FormatUsage27,
	Formatindex27,
	defaultFormatElement27,
	FormatCode28,
	FormatDefaultName28,
	FormatKey28,
	FormatType28,
	FormatUsage28,
	Formatindex28,
	defaultFormatElement28,
	FormatCode29,
	FormatDefaultName29,
	FormatKey29,
	FormatType29,
	FormatUsage29,
	Formatindex29,
	defaultFormatElement29,
	FormatCode30,
	FormatDefaultName30,
	FormatKey30,
	FormatType30,
	FormatUsage30,
	Formatindex30,
	defaultFormatElement30,
	FormatCode31,
	FormatDefaultName31,
	FormatKey31,
	FormatType31,
	FormatUsage31,
	Formatindex31,
	defaultFormatElement31,
	FormatCode32,
	FormatDefaultName32,
	FormatKey32,
	FormatType32,
	FormatUsage32,
	Formatindex32,
	defaultFormatElement32,
	FormatCode33,
	FormatDefaultName33,
	FormatKey33,
	FormatType33,
	FormatUsage33,
	Formatindex33,
	defaultFormatElement33,
	FormatCode34,
	FormatDefaultName34,
	FormatKey34,
	FormatType34,
	FormatUsage34,
	Formatindex34,
	defaultFormatElement34,
	FormatCode35,
	FormatDefaultName35,
	FormatKey35,
	FormatType35,
	FormatUsage35,
	Formatindex35,
	defaultFormatElement35,
	FormatCode36,
	FormatDefaultName36,
	FormatKey36,
	FormatType36,
	FormatUsage36,
	Formatindex36,
	defaultFormatElement36,
	FormatCode37,
	FormatDefaultName37,
	FormatKey37,
	FormatType37,
	FormatUsage37,
	Formatindex37,
	defaultFormatElement37,
	FormatCode38,
	FormatDefaultName38,
	FormatKey38,
	FormatType38,
	FormatUsage38,
	Formatindex38,
	defaultFormatElement38,
	FormatCode39,
	FormatDefaultName39,
	FormatKey39,
	FormatType39,
	FormatUsage39,
	Formatindex39,
	defaultFormatElement39,
	FormatCode40,
	FormatDefaultName40,
	FormatKey40,
	FormatType40,
	FormatUsage40,
	Formatindex40,
	defaultFormatElement40,
	FormatCode41,
	FormatDefaultName41,
	FormatKey41,
	FormatType41,
	FormatUsage41,
	Formatindex41,
	defaultFormatElement41,
	FormatCode42,
	FormatDefaultName42,
	FormatKey42,
	FormatType42,
	FormatUsage42,
	Formatindex42,
	defaultFormatElement42,
	FormatCode43,
	FormatDefaultName43,
	FormatKey43,
	FormatType43,
	FormatUsage43,
	Formatindex43,
	defaultFormatElement43,
	FormatCode44,
	FormatDefaultName44,
	FormatKey44,
	FormatType44,
	FormatUsage44,
	Formatindex44,
	defaultFormatElement44,
	FormatCode45,
	FormatDefaultName45,
	FormatKey45,
	FormatType45,
	FormatUsage45,
	Formatindex45,
	defaultFormatElement45,
	FormatCode46,
	FormatDefaultName46,
	FormatKey46,
	FormatType46,
	FormatUsage46,
	Formatindex46,
	defaultFormatElement46,
	FormatCode47,
	FormatDefaultName47,
	FormatKey47,
	FormatType47,
	FormatUsage47,
	Formatindex47,
	defaultFormatElement47,
};

SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_shs_CA(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	count = FormatElementsCount0;
	from = replaceFrom0;
	to = replaceTo0;
	return (const OUString *)FormatElementsArray0;
}
static constexpr OUStringLiteral DateAcceptancePattern0 = u"\x004d\x002d\x0044";
static constexpr OUStringLiteral DateAcceptancePattern1 = u"\x004d\x002f\x0044\x002f\x0059";
static constexpr OUStringLiteral DateAcceptancePattern2 = u"\x004d\x002f\x0044";
static constexpr OUStringLiteral DateAcceptancePattern3 = u"\x0059\x002d\x004d\x002d\x0044";
static const sal_Int16 DateAcceptancePatternsCount = 4;
static constexpr OUString DateAcceptancePatternsArray[] = {
	DateAcceptancePattern0,
	DateAcceptancePattern1,
	DateAcceptancePattern2,
	DateAcceptancePattern3,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getDateAcceptancePatterns_shs_CA(sal_Int16& count)
{
	count = DateAcceptancePatternsCount;
	return (OUString const *)DateAcceptancePatternsArray;
}
static constexpr OUStringLiteral CollatorID0 = u"\x0061\x006c\x0070\x0068\x0061\x006e\x0075\x006d\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral CollatorRule0 = u"";
static constexpr OUStringLiteral defaultCollator0 = u"\x1";

static constexpr OUStringLiteral collationOption0 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static const sal_Int16 nbOfCollationOptions = 1;

static const sal_Int16 nbOfCollations = 1;


static constexpr OUString LCCollatorArray[] = {
	CollatorID0,
	defaultCollator0,
	CollatorRule0,
};

static constexpr OUString collationOptions[] = {collationOption0};
SAL_DLLPUBLIC_EXPORT OUString const *  getCollatorImplementation_shs_CA(sal_Int16& count)
{
	count = nbOfCollations;
	return (OUString const *)LCCollatorArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getCollationOptions_shs_CA(sal_Int16& count)
{
	count = nbOfCollationOptions;
	return (OUString const *)collationOptions;
}
static constexpr OUStringLiteral searchOption0 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static const sal_Int16 nbOfSearchOptions = 1;

static constexpr OUString searchOptions[] = {searchOption0 };
SAL_DLLPUBLIC_EXPORT OUString const *  getSearchOptions_shs_CA(sal_Int16& count)
{
	count = nbOfSearchOptions;
	return (OUString const *)searchOptions;
}
static constexpr OUStringLiteral IndexID0 = u"\x0061\x006c\x0070\x0068\x0061\x006e\x0075\x006d\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral IndexModule0 = u"";
static constexpr OUStringLiteral IndexKey0 = u"\x0041\x002d\x005a";
static constexpr OUStringLiteral defaultIndex0 = u"\x1";
static constexpr OUStringLiteral defaultPhonetic0 = u"\x0";

static constexpr OUStringLiteral unicodeScript0 = u"\x0030";
static constexpr OUStringLiteral unicodeScript1 = u"\x0031";
static constexpr OUStringLiteral followPageWord0 = u"\x0070\x002e";
static constexpr OUStringLiteral followPageWord1 = u"\x0070\x0070\x002e";
static const sal_Int16 nbOfIndexs = 1;


static constexpr OUString IndexArray[] = {
	IndexID0,
	IndexModule0,
	IndexKey0,
	defaultIndex0,
	defaultPhonetic0,
};

static const sal_Int16 nbOfUnicodeScripts = 2;

static constexpr OUString UnicodeScriptArray[] = {unicodeScript0, unicodeScript1 };

static const sal_Int16 nbOfPageWords = 2;

static constexpr OUString FollowPageWordArray[] = {
	followPageWord0,
	followPageWord1	
};

SAL_DLLPUBLIC_EXPORT OUString const *  getIndexAlgorithm_shs_CA(sal_Int16& count)
{
	count = nbOfIndexs;
	return (OUString const *)IndexArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getUnicodeScripts_shs_CA(sal_Int16& count)
{
	count = nbOfUnicodeScripts;
	return (OUString const *)UnicodeScriptArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getFollowPageWords_shs_CA(sal_Int16& count)
{
	count = nbOfPageWords;
	return (OUString const *)FollowPageWordArray;
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x0053\x0078\x0065";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x0053\x0078\x0065\x0074\x0073\x0070\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x0053";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x0053\x0070\x0065";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x0053\x0070\x0065\x0074\x006b\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x0053";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x0053\x0065\x006c";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x0053\x0065\x006c\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x0053";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x0053\x006b\x0065";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x0053\x006b\x0065\x006c\x006c\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x0053";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x0053\x006d\x0065";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x0053\x006d\x0065\x0073\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x0053";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x0053\x0074\x0073";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x0053\x0074\x0073\x0065\x006c\x006b\x0073\x0074\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x0053";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x0053\x0074\x0071";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x0053\x0074\x0071\x006d\x0065\x006b\x0073\x0074\x0065\x0073\x0071\x0027\x0074";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x0053";
static constexpr OUStringLiteral monthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName00 = u"\x004b\x0077\x0065\x0020";
static constexpr OUStringLiteral monthDefaultFullName00 = u"\x0050\x0065\x006c\x006c\x006b\x0077\x0065\x0074\x0027\x006d\x0069\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName00 = u"\x0050";
static constexpr OUStringLiteral monthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName01 = u"\x0054\x0073\x0069";
static constexpr OUStringLiteral monthDefaultFullName01 = u"\x0050\x0065\x006c\x0063\x0074\x0073\x0069\x0070\x0077\x0065\x006e\x0027\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName01 = u"\x0050";
static constexpr OUStringLiteral monthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName02 = u"\x0053\x0071\x0065";
static constexpr OUStringLiteral monthDefaultFullName02 = u"\x0050\x0065\x006c\x006c\x0073\x0071\x0065\x0027\x0070\x0074\x0073";
static constexpr OUStringLiteral monthDefaultNarrowName02 = u"\x0050";
static constexpr OUStringLiteral monthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName03 = u"\x0045\x0027\x0077";
static constexpr OUStringLiteral monthDefaultFullName03 = u"\x0050\x0065\x0073\x006c\x006c\x0065\x0027\x0077\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName03 = u"\x0050";
static constexpr OUStringLiteral monthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName04 = u"\x0045\x006c\x006c";
static constexpr OUStringLiteral monthDefaultFullName04 = u"\x0050\x0065\x006c\x006c\x0037\x0065\x006c\x006c\x0037\x0065\x0027\x0037\x006c\x006c\x0071\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName04 = u"\x0050";
static constexpr OUStringLiteral monthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName05 = u"\x0054\x0073\x0070";
static constexpr OUStringLiteral monthDefaultFullName05 = u"\x0050\x0065\x006c\x006c\x0074\x0073\x0070\x0065\x0027\x006e\x0074\x0073\x006b";
static constexpr OUStringLiteral monthDefaultNarrowName05 = u"\x0050";
static constexpr OUStringLiteral monthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName06 = u"\x0054\x0071\x0077";
static constexpr OUStringLiteral monthDefaultFullName06 = u"\x0050\x0065\x006c\x006c\x0074\x0071\x0077\x0065\x006c\x0071\x0027\x0077\x0065\x0027\x006c\x0027\x0074";
static constexpr OUStringLiteral monthDefaultNarrowName06 = u"\x0050";
static constexpr OUStringLiteral monthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName07 = u"\x0043\x0074\x0027";
static constexpr OUStringLiteral monthDefaultFullName07 = u"\x0050\x0065\x006c\x006c\x0063\x0074\x0027\x0065\x0027\x0078\x0065\x006c\x0027\x0063\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName07 = u"\x0050";
static constexpr OUStringLiteral monthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName08 = u"\x0051\x0065\x006c";
static constexpr OUStringLiteral monthDefaultFullName08 = u"\x0050\x0065\x0073\x0071\x0065\x006c\x0071\x006c\x0065\x0027\x006c\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName08 = u"\x0050";
static constexpr OUStringLiteral monthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName09 = u"\x0057\x0065\x006c";
static constexpr OUStringLiteral monthDefaultFullName09 = u"\x0050\x0065\x0073\x006c\x006c\x0077\x0065\x0027\x006c\x0073\x0074\x0065\x006e";
static constexpr OUStringLiteral monthDefaultNarrowName09 = u"\x0050";
static constexpr OUStringLiteral monthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName010 = u"\x0055\x0037\x006c";
static constexpr OUStringLiteral monthDefaultFullName010 = u"\x0050\x0065\x006c\x006c\x0063\x0037\x0065\x006c\x006c\x0037\x0075\x0027\x0037\x006c\x006c\x0063\x0077\x0074\x0065\x006e\x0027";
static constexpr OUStringLiteral monthDefaultNarrowName010 = u"\x0050";
static constexpr OUStringLiteral monthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName011 = u"\x0054\x0065\x0074";
static constexpr OUStringLiteral monthDefaultFullName011 = u"\x0050\x0065\x006c\x006c\x0074\x0065\x0074\x0065\x0027\x0074\x0071\x0027\x0065\x006d";
static constexpr OUStringLiteral monthDefaultNarrowName011 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName00 = u"\x004b\x0077\x0065\x0020";
static constexpr OUStringLiteral genitiveMonthDefaultFullName00 = u"\x0050\x0065\x006c\x006c\x006b\x0077\x0065\x0074\x0027\x006d\x0069\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName00 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName01 = u"\x0054\x0073\x0069";
static constexpr OUStringLiteral genitiveMonthDefaultFullName01 = u"\x0050\x0065\x006c\x0063\x0074\x0073\x0069\x0070\x0077\x0065\x006e\x0027\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName01 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName02 = u"\x0053\x0071\x0065";
static constexpr OUStringLiteral genitiveMonthDefaultFullName02 = u"\x0050\x0065\x006c\x006c\x0073\x0071\x0065\x0027\x0070\x0074\x0073";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName02 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName03 = u"\x0045\x0027\x0077";
static constexpr OUStringLiteral genitiveMonthDefaultFullName03 = u"\x0050\x0065\x0073\x006c\x006c\x0065\x0027\x0077\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName03 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName04 = u"\x0045\x006c\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultFullName04 = u"\x0050\x0065\x006c\x006c\x0037\x0065\x006c\x006c\x0037\x0065\x0027\x0037\x006c\x006c\x0071\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName04 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName05 = u"\x0054\x0073\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultFullName05 = u"\x0050\x0065\x006c\x006c\x0074\x0073\x0070\x0065\x0027\x006e\x0074\x0073\x006b";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName05 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName06 = u"\x0054\x0071\x0077";
static constexpr OUStringLiteral genitiveMonthDefaultFullName06 = u"\x0050\x0065\x006c\x006c\x0074\x0071\x0077\x0065\x006c\x0071\x0027\x0077\x0065\x0027\x006c\x0027\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName06 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName07 = u"\x0043\x0074\x0027";
static constexpr OUStringLiteral genitiveMonthDefaultFullName07 = u"\x0050\x0065\x006c\x006c\x0063\x0074\x0027\x0065\x0027\x0078\x0065\x006c\x0027\x0063\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName07 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName08 = u"\x0051\x0065\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultFullName08 = u"\x0050\x0065\x0073\x0071\x0065\x006c\x0071\x006c\x0065\x0027\x006c\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName08 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName09 = u"\x0057\x0065\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultFullName09 = u"\x0050\x0065\x0073\x006c\x006c\x0077\x0065\x0027\x006c\x0073\x0074\x0065\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName09 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName010 = u"\x0055\x0037\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultFullName010 = u"\x0050\x0065\x006c\x006c\x0063\x0037\x0065\x006c\x006c\x0037\x0075\x0027\x0037\x006c\x006c\x0063\x0077\x0074\x0065\x006e\x0027";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName010 = u"\x0050";
static constexpr OUStringLiteral genitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName011 = u"\x0054\x0065\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultFullName011 = u"\x0050\x0065\x006c\x006c\x0074\x0065\x0074\x0065\x0027\x0074\x0071\x0027\x0065\x006d";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName011 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName00 = u"\x004b\x0077\x0065\x0020";
static constexpr OUStringLiteral partitiveMonthDefaultFullName00 = u"\x0050\x0065\x006c\x006c\x006b\x0077\x0065\x0074\x0027\x006d\x0069\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName00 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName01 = u"\x0054\x0073\x0069";
static constexpr OUStringLiteral partitiveMonthDefaultFullName01 = u"\x0050\x0065\x006c\x0063\x0074\x0073\x0069\x0070\x0077\x0065\x006e\x0027\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName01 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName02 = u"\x0053\x0071\x0065";
static constexpr OUStringLiteral partitiveMonthDefaultFullName02 = u"\x0050\x0065\x006c\x006c\x0073\x0071\x0065\x0027\x0070\x0074\x0073";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName02 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName03 = u"\x0045\x0027\x0077";
static constexpr OUStringLiteral partitiveMonthDefaultFullName03 = u"\x0050\x0065\x0073\x006c\x006c\x0065\x0027\x0077\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName03 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName04 = u"\x0045\x006c\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultFullName04 = u"\x0050\x0065\x006c\x006c\x0037\x0065\x006c\x006c\x0037\x0065\x0027\x0037\x006c\x006c\x0071\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName04 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName05 = u"\x0054\x0073\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultFullName05 = u"\x0050\x0065\x006c\x006c\x0074\x0073\x0070\x0065\x0027\x006e\x0074\x0073\x006b";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName05 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName06 = u"\x0054\x0071\x0077";
static constexpr OUStringLiteral partitiveMonthDefaultFullName06 = u"\x0050\x0065\x006c\x006c\x0074\x0071\x0077\x0065\x006c\x0071\x0027\x0077\x0065\x0027\x006c\x0027\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName06 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName07 = u"\x0043\x0074\x0027";
static constexpr OUStringLiteral partitiveMonthDefaultFullName07 = u"\x0050\x0065\x006c\x006c\x0063\x0074\x0027\x0065\x0027\x0078\x0065\x006c\x0027\x0063\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName07 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName08 = u"\x0051\x0065\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultFullName08 = u"\x0050\x0065\x0073\x0071\x0065\x006c\x0071\x006c\x0065\x0027\x006c\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName08 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName09 = u"\x0057\x0065\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultFullName09 = u"\x0050\x0065\x0073\x006c\x006c\x0077\x0065\x0027\x006c\x0073\x0074\x0065\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName09 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName010 = u"\x0055\x0037\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultFullName010 = u"\x0050\x0065\x006c\x006c\x0063\x0037\x0065\x006c\x006c\x0037\x0075\x0027\x0037\x006c\x006c\x0063\x0077\x0074\x0065\x006e\x0027";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName010 = u"\x0050";
static constexpr OUStringLiteral partitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName011 = u"\x0054\x0065\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultFullName011 = u"\x0050\x0065\x006c\x006c\x0074\x0065\x0074\x0065\x0027\x0074\x0071\x0027\x0065\x006d";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName011 = u"\x0050";
static constexpr OUStringLiteral eraID00 = u"\x0062\x0063";

static constexpr OUStringLiteral eraDefaultAbbrvName00 = u"\x0042\x0043";
static constexpr OUStringLiteral eraDefaultFullName00 = u"\x0042\x0043";
static constexpr OUStringLiteral eraID01 = u"\x0061\x0064";

static constexpr OUStringLiteral eraDefaultAbbrvName01 = u"\x0041\x0044";
static constexpr OUStringLiteral eraDefaultFullName01 = u"\x0041\x0044";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\xc";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfEras = u"\x2";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthID00,
	monthDefaultAbbrvName00,
	monthDefaultFullName00,
	monthDefaultNarrowName00,
	monthID01,
	monthDefaultAbbrvName01,
	monthDefaultFullName01,
	monthDefaultNarrowName01,
	monthID02,
	monthDefaultAbbrvName02,
	monthDefaultFullName02,
	monthDefaultNarrowName02,
	monthID03,
	monthDefaultAbbrvName03,
	monthDefaultFullName03,
	monthDefaultNarrowName03,
	monthID04,
	monthDefaultAbbrvName04,
	monthDefaultFullName04,
	monthDefaultNarrowName04,
	monthID05,
	monthDefaultAbbrvName05,
	monthDefaultFullName05,
	monthDefaultNarrowName05,
	monthID06,
	monthDefaultAbbrvName06,
	monthDefaultFullName06,
	monthDefaultNarrowName06,
	monthID07,
	monthDefaultAbbrvName07,
	monthDefaultFullName07,
	monthDefaultNarrowName07,
	monthID08,
	monthDefaultAbbrvName08,
	monthDefaultFullName08,
	monthDefaultNarrowName08,
	monthID09,
	monthDefaultAbbrvName09,
	monthDefaultFullName09,
	monthDefaultNarrowName09,
	monthID010,
	monthDefaultAbbrvName010,
	monthDefaultFullName010,
	monthDefaultNarrowName010,
	monthID011,
	monthDefaultAbbrvName011,
	monthDefaultFullName011,
	monthDefaultNarrowName011,
	genitiveMonthID00,
	genitiveMonthDefaultAbbrvName00,
	genitiveMonthDefaultFullName00,
	genitiveMonthDefaultNarrowName00,
	genitiveMonthID01,
	genitiveMonthDefaultAbbrvName01,
	genitiveMonthDefaultFullName01,
	genitiveMonthDefaultNarrowName01,
	genitiveMonthID02,
	genitiveMonthDefaultAbbrvName02,
	genitiveMonthDefaultFullName02,
	genitiveMonthDefaultNarrowName02,
	genitiveMonthID03,
	genitiveMonthDefaultAbbrvName03,
	genitiveMonthDefaultFullName03,
	genitiveMonthDefaultNarrowName03,
	genitiveMonthID04,
	genitiveMonthDefaultAbbrvName04,
	genitiveMonthDefaultFullName04,
	genitiveMonthDefaultNarrowName04,
	genitiveMonthID05,
	genitiveMonthDefaultAbbrvName05,
	genitiveMonthDefaultFullName05,
	genitiveMonthDefaultNarrowName05,
	genitiveMonthID06,
	genitiveMonthDefaultAbbrvName06,
	genitiveMonthDefaultFullName06,
	genitiveMonthDefaultNarrowName06,
	genitiveMonthID07,
	genitiveMonthDefaultAbbrvName07,
	genitiveMonthDefaultFullName07,
	genitiveMonthDefaultNarrowName07,
	genitiveMonthID08,
	genitiveMonthDefaultAbbrvName08,
	genitiveMonthDefaultFullName08,
	genitiveMonthDefaultNarrowName08,
	genitiveMonthID09,
	genitiveMonthDefaultAbbrvName09,
	genitiveMonthDefaultFullName09,
	genitiveMonthDefaultNarrowName09,
	genitiveMonthID010,
	genitiveMonthDefaultAbbrvName010,
	genitiveMonthDefaultFullName010,
	genitiveMonthDefaultNarrowName010,
	genitiveMonthID011,
	genitiveMonthDefaultAbbrvName011,
	genitiveMonthDefaultFullName011,
	genitiveMonthDefaultNarrowName011,
	partitiveMonthID00,
	partitiveMonthDefaultAbbrvName00,
	partitiveMonthDefaultFullName00,
	partitiveMonthDefaultNarrowName00,
	partitiveMonthID01,
	partitiveMonthDefaultAbbrvName01,
	partitiveMonthDefaultFullName01,
	partitiveMonthDefaultNarrowName01,
	partitiveMonthID02,
	partitiveMonthDefaultAbbrvName02,
	partitiveMonthDefaultFullName02,
	partitiveMonthDefaultNarrowName02,
	partitiveMonthID03,
	partitiveMonthDefaultAbbrvName03,
	partitiveMonthDefaultFullName03,
	partitiveMonthDefaultNarrowName03,
	partitiveMonthID04,
	partitiveMonthDefaultAbbrvName04,
	partitiveMonthDefaultFullName04,
	partitiveMonthDefaultNarrowName04,
	partitiveMonthID05,
	partitiveMonthDefaultAbbrvName05,
	partitiveMonthDefaultFullName05,
	partitiveMonthDefaultNarrowName05,
	partitiveMonthID06,
	partitiveMonthDefaultAbbrvName06,
	partitiveMonthDefaultFullName06,
	partitiveMonthDefaultNarrowName06,
	partitiveMonthID07,
	partitiveMonthDefaultAbbrvName07,
	partitiveMonthDefaultFullName07,
	partitiveMonthDefaultNarrowName07,
	partitiveMonthID08,
	partitiveMonthDefaultAbbrvName08,
	partitiveMonthDefaultFullName08,
	partitiveMonthDefaultNarrowName08,
	partitiveMonthID09,
	partitiveMonthDefaultAbbrvName09,
	partitiveMonthDefaultFullName09,
	partitiveMonthDefaultNarrowName09,
	partitiveMonthID010,
	partitiveMonthDefaultAbbrvName010,
	partitiveMonthDefaultFullName010,
	partitiveMonthDefaultNarrowName010,
	partitiveMonthID011,
	partitiveMonthDefaultAbbrvName011,
	partitiveMonthDefaultFullName011,
	partitiveMonthDefaultNarrowName011,
	eraID00,
	eraDefaultAbbrvName00,
	eraDefaultFullName00,
	eraID01,
	eraDefaultAbbrvName01,
	eraDefaultFullName01,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_shs_CA(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0043\x0041\x0044";
static constexpr OUStringLiteral currencySymbol0 = u"\x0024";
static constexpr OUStringLiteral bankSymbol0 = u"\x0043\x0041\x0044";
static constexpr OUStringLiteral currencyName0 = u"\x0043\x0041\x0020\x0044\x006f\x006c\x006c\x0061\x0072";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_shs_CA(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
static constexpr OUStringLiteral Transliteration0 = u"\x0053\x0045\x004e\x0054\x0045\x004e\x0043\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration1 = u"\x004c\x004f\x0057\x0045\x0052\x0043\x0041\x0053\x0045\x005f\x0055\x0050\x0050\x0045\x0052\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration2 = u"\x0055\x0050\x0050\x0045\x0052\x0043\x0041\x0053\x0045\x005f\x004c\x004f\x0057\x0045\x0052\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration3 = u"\x0054\x0049\x0054\x004c\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration4 = u"\x0054\x004f\x0047\x0047\x004c\x0045\x005f\x0043\x0041\x0053\x0045";
static constexpr OUStringLiteral Transliteration5 = u"\x0049\x0047\x004e\x004f\x0052\x0045\x005f\x0043\x0041\x0053\x0045";
static const sal_Int16 nbOfTransliterations = 6;


static constexpr OUString LCTransliterationsArray[] = {
	Transliteration0,
	Transliteration1,
	Transliteration2,
	Transliteration3,
	Transliteration4,
	Transliteration5,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getTransliterations_shs_CA(sal_Int16& count)
{
	count = nbOfTransliterations;
	return (OUString const *)LCTransliterationsArray;
}
static constexpr OUStringLiteral ReservedWord0 = u"\x0074\x0072\x0075\x0065";
static constexpr OUStringLiteral ReservedWord1 = u"\x0066\x0061\x006c\x0073\x0065";
static constexpr OUStringLiteral ReservedWord2 = u"\x0031\x0073\x0074\x0020\x0071\x0075\x0061\x0072\x0074\x0065\x0072";
static constexpr OUStringLiteral ReservedWord3 = u"\x0032\x006e\x0064\x0020\x0071\x0075\x0061\x0072\x0074\x0065\x0072";
static constexpr OUStringLiteral ReservedWord4 = u"\x0033\x0072\x0064\x0020\x0071\x0075\x0061\x0072\x0074\x0065\x0072";
static constexpr OUStringLiteral ReservedWord5 = u"\x0034\x0074\x0068\x0020\x0071\x0075\x0061\x0072\x0074\x0065\x0072";
static constexpr OUStringLiteral ReservedWord6 = u"\x0061\x0062\x006f\x0076\x0065";
static constexpr OUStringLiteral ReservedWord7 = u"\x0062\x0065\x006c\x006f\x0077";
static constexpr OUStringLiteral ReservedWord8 = u"\x0051\x0031";
static constexpr OUStringLiteral ReservedWord9 = u"\x0051\x0032";
static constexpr OUStringLiteral ReservedWord10 = u"\x0051\x0033";
static constexpr OUStringLiteral ReservedWord11 = u"\x0051\x0034";
static const sal_Int16 nbOfReservedWords = 12;


static constexpr OUString LCReservedWordsArray[] = {
	ReservedWord0,
	ReservedWord1,
	ReservedWord2,
	ReservedWord3,
	ReservedWord4,
	ReservedWord5,
	ReservedWord6,
	ReservedWord7,
	ReservedWord8,
	ReservedWord9,
	ReservedWord10,
	ReservedWord11,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getReservedWords_shs_CA(sal_Int16& count)
{
	count = nbOfReservedWords;
	return (OUString const *)LCReservedWordsArray;
}
static constexpr OUStringLiteral forbiddenBegin = u"";
static constexpr OUStringLiteral forbiddenEnd = u"";
static constexpr OUStringLiteral hangingChars = u"";

static constexpr OUString LCForbiddenCharactersArray[] = {
	forbiddenBegin,
	forbiddenEnd,
	hangingChars
};

SAL_DLLPUBLIC_EXPORT OUString const *  getForbiddenCharacters_shs_CA(sal_Int16& count)
{
	count = 3;
	return (OUString const *)LCForbiddenCharactersArray;
}
static constexpr OUStringLiteral EditMode = u"";
static constexpr OUStringLiteral DictionaryMode = u"";
static constexpr OUStringLiteral WordCountMode = u"";
static constexpr OUStringLiteral CharacterMode = u"";
static constexpr OUStringLiteral LineMode = u"";

static constexpr OUString LCBreakIteratorRulesArray[] = {
	EditMode,
	DictionaryMode,
	WordCountMode,
	CharacterMode,
	LineMode
};

SAL_DLLPUBLIC_EXPORT OUString const *  getBreakIteratorRules_shs_CA(sal_Int16& count)
{
	count = 5;
	return (OUString const *)LCBreakIteratorRulesArray;
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_shs_CA(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_shs_CA(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

