
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsTextItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsTextItem>
#include <QChildEvent>
#include <QColor>
#include <QCursor>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QGraphicsEffect>
#include <QGraphicsItem>
#include <QGraphicsItemGroup>
#include <QGraphicsObject>
#include <QGraphicsScene>
#include <QGraphicsSceneContextMenuEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneWheelEvent>
#include <QGraphicsWidget>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPainterPath>
#include <QPointF>
#include <QPolygonF>
#include <QRectF>
#include <QRegion>
#include <QSize>
#include <QStyleOptionGraphicsItem>
#include <QTextCursor>
#include <QTextDocument>
#include <QThread>
#include <QTimerEvent>
#include <QTransform>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsTextItem

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsTextItem::staticMetaObject);
}


// void QGraphicsTextItem::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->adjustSize ();
}


// QRectF QGraphicsTextItem::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsTextItem *)cls)->boundingRect ());
}


// bool QGraphicsTextItem::contains(const QPointF &point)


static void _init_f_contains_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsTextItem *)cls)->contains (arg1));
}


// QColor QGraphicsTextItem::defaultTextColor()


static void _init_f_defaultTextColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_defaultTextColor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QGraphicsTextItem *)cls)->defaultTextColor ());
}


// QTextDocument *QGraphicsTextItem::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocument * > ((QTextDocument *)((QGraphicsTextItem *)cls)->document ());
}


// QFont QGraphicsTextItem::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QGraphicsTextItem *)cls)->font ());
}


// bool QGraphicsTextItem::isObscuredBy(const QGraphicsItem *item)


static void _init_f_isObscuredBy_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscuredBy_c2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsTextItem *)cls)->isObscuredBy (arg1));
}


// QPainterPath QGraphicsTextItem::opaqueArea()


static void _init_f_opaqueArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_opaqueArea_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsTextItem *)cls)->opaqueArea ());
}


// bool QGraphicsTextItem::openExternalLinks()


static void _init_f_openExternalLinks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_openExternalLinks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsTextItem *)cls)->openExternalLinks ());
}


// void QGraphicsTextItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionGraphicsItem *arg2 = gsi::arg_reader<const QStyleOptionGraphicsItem * >() (args, heap);
  QWidget *arg3 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->paint (arg1, arg2, arg3);
}


// void QGraphicsTextItem::setDefaultTextColor(const QColor &c)


static void _init_f_setDefaultTextColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultTextColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setDefaultTextColor (arg1);
}


// void QGraphicsTextItem::setDocument(QTextDocument *document)


static void _init_f_setDocument_1955 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocument_1955 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setDocument (arg1);
}


// void QGraphicsTextItem::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setFont (arg1);
}


// void QGraphicsTextItem::setHtml(const QString &html)


static void _init_f_setHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setHtml (arg1);
}


// void QGraphicsTextItem::setOpenExternalLinks(bool open)


static void _init_f_setOpenExternalLinks_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("open");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpenExternalLinks_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setOpenExternalLinks (arg1);
}


// void QGraphicsTextItem::setPlainText(const QString &text)


static void _init_f_setPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setPlainText (arg1);
}


// void QGraphicsTextItem::setTabChangesFocus(bool b)


static void _init_f_setTabChangesFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabChangesFocus_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setTabChangesFocus (arg1);
}


// void QGraphicsTextItem::setTextCursor(const QTextCursor &cursor)


static void _init_f_setTextCursor_2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextCursor_2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setTextCursor (arg1);
}


// void QGraphicsTextItem::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)


static void _init_f_setTextInteractionFlags_3396 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::TextInteractionFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextInteractionFlags_3396 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::TextInteractionFlag> arg1 = gsi::arg_reader<QFlags<Qt::TextInteractionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setTextInteractionFlags (arg1);
}


// void QGraphicsTextItem::setTextWidth(double width)


static void _init_f_setTextWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem *)cls)->setTextWidth (arg1);
}


// QPainterPath QGraphicsTextItem::shape()


static void _init_f_shape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_shape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsTextItem *)cls)->shape ());
}


// bool QGraphicsTextItem::tabChangesFocus()


static void _init_f_tabChangesFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabChangesFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsTextItem *)cls)->tabChangesFocus ());
}


// QTextCursor QGraphicsTextItem::textCursor()


static void _init_f_textCursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCursor > ();
}

static void _call_f_textCursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCursor > ((QTextCursor)((QGraphicsTextItem *)cls)->textCursor ());
}


// QFlags<Qt::TextInteractionFlag> QGraphicsTextItem::textInteractionFlags()


static void _init_f_textInteractionFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::TextInteractionFlag> > ();
}

static void _call_f_textInteractionFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::TextInteractionFlag> > ((QFlags<Qt::TextInteractionFlag>)((QGraphicsTextItem *)cls)->textInteractionFlags ());
}


// double QGraphicsTextItem::textWidth()


static void _init_f_textWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_textWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsTextItem *)cls)->textWidth ());
}


// QString QGraphicsTextItem::toHtml()


static void _init_f_toHtml_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toHtml_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGraphicsTextItem *)cls)->toHtml ());
}


// QString QGraphicsTextItem::toPlainText()


static void _init_f_toPlainText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toPlainText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGraphicsTextItem *)cls)->toPlainText ());
}


// int QGraphicsTextItem::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsTextItem *)cls)->type ());
}


// static QString QGraphicsTextItem::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsTextItem::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsTextItem () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QGraphicsTextItem::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsTextItem::boundingRect()\nThis is a reimplementation of QGraphicsItem::boundingRect", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QGraphicsTextItem::contains(const QPointF &point)\nThis is a reimplementation of QGraphicsItem::contains", true, &_init_f_contains_c1986, &_call_f_contains_c1986);
  methods += new qt_gsi::GenericMethod (":defaultTextColor", "@brief Method QColor QGraphicsTextItem::defaultTextColor()\n", true, &_init_f_defaultTextColor_c0, &_call_f_defaultTextColor_c0);
  methods += new qt_gsi::GenericMethod (":document", "@brief Method QTextDocument *QGraphicsTextItem::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QGraphicsTextItem::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy?", "@brief Method bool QGraphicsTextItem::isObscuredBy(const QGraphicsItem *item)\nThis is a reimplementation of QGraphicsItem::isObscuredBy", true, &_init_f_isObscuredBy_c2614, &_call_f_isObscuredBy_c2614);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Method QPainterPath QGraphicsTextItem::opaqueArea()\nThis is a reimplementation of QGraphicsItem::opaqueArea", true, &_init_f_opaqueArea_c0, &_call_f_opaqueArea_c0);
  methods += new qt_gsi::GenericMethod (":openExternalLinks", "@brief Method bool QGraphicsTextItem::openExternalLinks()\n", true, &_init_f_openExternalLinks_c0, &_call_f_openExternalLinks_c0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QGraphicsTextItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis is a reimplementation of QGraphicsItem::paint", false, &_init_f_paint_6301, &_call_f_paint_6301);
  methods += new qt_gsi::GenericMethod ("setDefaultTextColor|defaultTextColor=", "@brief Method void QGraphicsTextItem::setDefaultTextColor(const QColor &c)\n", false, &_init_f_setDefaultTextColor_1905, &_call_f_setDefaultTextColor_1905);
  methods += new qt_gsi::GenericMethod ("setDocument|document=", "@brief Method void QGraphicsTextItem::setDocument(QTextDocument *document)\n", false, &_init_f_setDocument_1955, &_call_f_setDocument_1955);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QGraphicsTextItem::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setHtml", "@brief Method void QGraphicsTextItem::setHtml(const QString &html)\n", false, &_init_f_setHtml_2025, &_call_f_setHtml_2025);
  methods += new qt_gsi::GenericMethod ("setOpenExternalLinks|openExternalLinks=", "@brief Method void QGraphicsTextItem::setOpenExternalLinks(bool open)\n", false, &_init_f_setOpenExternalLinks_864, &_call_f_setOpenExternalLinks_864);
  methods += new qt_gsi::GenericMethod ("setPlainText", "@brief Method void QGraphicsTextItem::setPlainText(const QString &text)\n", false, &_init_f_setPlainText_2025, &_call_f_setPlainText_2025);
  methods += new qt_gsi::GenericMethod ("setTabChangesFocus|tabChangesFocus=", "@brief Method void QGraphicsTextItem::setTabChangesFocus(bool b)\n", false, &_init_f_setTabChangesFocus_864, &_call_f_setTabChangesFocus_864);
  methods += new qt_gsi::GenericMethod ("setTextCursor|textCursor=", "@brief Method void QGraphicsTextItem::setTextCursor(const QTextCursor &cursor)\n", false, &_init_f_setTextCursor_2453, &_call_f_setTextCursor_2453);
  methods += new qt_gsi::GenericMethod ("setTextInteractionFlags|textInteractionFlags=", "@brief Method void QGraphicsTextItem::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)\n", false, &_init_f_setTextInteractionFlags_3396, &_call_f_setTextInteractionFlags_3396);
  methods += new qt_gsi::GenericMethod ("setTextWidth|textWidth=", "@brief Method void QGraphicsTextItem::setTextWidth(double width)\n", false, &_init_f_setTextWidth_1071, &_call_f_setTextWidth_1071);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Method QPainterPath QGraphicsTextItem::shape()\nThis is a reimplementation of QGraphicsItem::shape", true, &_init_f_shape_c0, &_call_f_shape_c0);
  methods += new qt_gsi::GenericMethod (":tabChangesFocus", "@brief Method bool QGraphicsTextItem::tabChangesFocus()\n", true, &_init_f_tabChangesFocus_c0, &_call_f_tabChangesFocus_c0);
  methods += new qt_gsi::GenericMethod (":textCursor", "@brief Method QTextCursor QGraphicsTextItem::textCursor()\n", true, &_init_f_textCursor_c0, &_call_f_textCursor_c0);
  methods += new qt_gsi::GenericMethod (":textInteractionFlags", "@brief Method QFlags<Qt::TextInteractionFlag> QGraphicsTextItem::textInteractionFlags()\n", true, &_init_f_textInteractionFlags_c0, &_call_f_textInteractionFlags_c0);
  methods += new qt_gsi::GenericMethod (":textWidth", "@brief Method double QGraphicsTextItem::textWidth()\n", true, &_init_f_textWidth_c0, &_call_f_textWidth_c0);
  methods += new qt_gsi::GenericMethod ("toHtml", "@brief Method QString QGraphicsTextItem::toHtml()\n", true, &_init_f_toHtml_c0, &_call_f_toHtml_c0);
  methods += new qt_gsi::GenericMethod ("toPlainText", "@brief Method QString QGraphicsTextItem::toPlainText()\n", true, &_init_f_toPlainText_c0, &_call_f_toPlainText_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method int QGraphicsTextItem::type()\nThis is a reimplementation of QGraphicsItem::type", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += gsi::qt_signal ("childrenChanged()", "childrenChanged", "@brief Signal declaration for QGraphicsTextItem::childrenChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsTextItem::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("enabledChanged()", "enabledChanged", "@brief Signal declaration for QGraphicsTextItem::enabledChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("heightChanged()", "heightChanged", "@brief Signal declaration for QGraphicsTextItem::heightChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("linkActivated(const QString &)", "linkActivated", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsTextItem::linkActivated(const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("linkHovered(const QString &)", "linkHovered", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsTextItem::linkHovered(const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsTextItem::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("opacityChanged()", "opacityChanged", "@brief Signal declaration for QGraphicsTextItem::opacityChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("parentChanged()", "parentChanged", "@brief Signal declaration for QGraphicsTextItem::parentChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rotationChanged()", "rotationChanged", "@brief Signal declaration for QGraphicsTextItem::rotationChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("scaleChanged()", "scaleChanged", "@brief Signal declaration for QGraphicsTextItem::scaleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("visibleChanged()", "visibleChanged", "@brief Signal declaration for QGraphicsTextItem::visibleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("widthChanged()", "widthChanged", "@brief Signal declaration for QGraphicsTextItem::widthChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("xChanged()", "xChanged", "@brief Signal declaration for QGraphicsTextItem::xChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("yChanged()", "yChanged", "@brief Signal declaration for QGraphicsTextItem::yChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("zChanged()", "zChanged", "@brief Signal declaration for QGraphicsTextItem::zChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsTextItem::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QGraphicsObject> &qtdecl_QGraphicsObject ();

qt_gsi::QtNativeClass<QGraphicsTextItem> decl_QGraphicsTextItem (qtdecl_QGraphicsObject (), "QtWidgets", "QGraphicsTextItem_Native",
  methods_QGraphicsTextItem (),
  "@hide\n@alias QGraphicsTextItem");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsTextItem> &qtdecl_QGraphicsTextItem () { return decl_QGraphicsTextItem; }

}


class QGraphicsTextItem_Adaptor : public QGraphicsTextItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsTextItem_Adaptor();

  //  [adaptor ctor] QGraphicsTextItem::QGraphicsTextItem(QGraphicsItem *parent)
  QGraphicsTextItem_Adaptor() : QGraphicsTextItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsTextItem::QGraphicsTextItem(QGraphicsItem *parent)
  QGraphicsTextItem_Adaptor(QGraphicsItem *parent) : QGraphicsTextItem(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsTextItem::QGraphicsTextItem(const QString &text, QGraphicsItem *parent)
  QGraphicsTextItem_Adaptor(const QString &text) : QGraphicsTextItem(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsTextItem::QGraphicsTextItem(const QString &text, QGraphicsItem *parent)
  QGraphicsTextItem_Adaptor(const QString &text, QGraphicsItem *parent) : QGraphicsTextItem(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsTextItem::addToIndex()
  void fp_QGraphicsTextItem_addToIndex_0 () {
    QGraphicsTextItem::addToIndex();
  }

  //  [expose] bool QGraphicsTextItem::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsTextItem_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsTextItem::isSignalConnected(signal);
  }

  //  [expose] void QGraphicsTextItem::prepareGeometryChange()
  void fp_QGraphicsTextItem_prepareGeometryChange_0 () {
    QGraphicsTextItem::prepareGeometryChange();
  }

  //  [expose] int QGraphicsTextItem::receivers(const char *signal)
  int fp_QGraphicsTextItem_receivers_c1731 (const char *signal) const {
    return QGraphicsTextItem::receivers(signal);
  }

  //  [expose] void QGraphicsTextItem::removeFromIndex()
  void fp_QGraphicsTextItem_removeFromIndex_0 () {
    QGraphicsTextItem::removeFromIndex();
  }

  //  [expose] QObject *QGraphicsTextItem::sender()
  QObject * fp_QGraphicsTextItem_sender_c0 () const {
    return QGraphicsTextItem::sender();
  }

  //  [expose] int QGraphicsTextItem::senderSignalIndex()
  int fp_QGraphicsTextItem_senderSignalIndex_c0 () const {
    return QGraphicsTextItem::senderSignalIndex();
  }

  //  [expose] void QGraphicsTextItem::updateMicroFocus()
  void fp_QGraphicsTextItem_updateMicroFocus_0 () {
    QGraphicsTextItem::updateMicroFocus();
  }

  //  [adaptor impl] void QGraphicsTextItem::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsTextItem::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsTextItem_Adaptor, int>(&QGraphicsTextItem_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsTextItem::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsTextItem::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    return QGraphicsTextItem::boundingRect();
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsTextItem_Adaptor, QRectF>(&QGraphicsTextItem_Adaptor::cbs_boundingRect_c0_0);
    } else {
      return QGraphicsTextItem::boundingRect();
    }
  }

  //  [emitter impl] void QGraphicsTextItem::childrenChanged()
  void emitter_QGraphicsTextItem_childrenChanged_0()
  {
    emit QGraphicsTextItem::childrenChanged();
  }

  //  [adaptor impl] bool QGraphicsTextItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsTextItem::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsTextItem_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsTextItem_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsTextItem::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsTextItem::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsTextItem_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsTextItem_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsTextItem::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsTextItem::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsTextItem_Adaptor, bool, const QPointF &>(&QGraphicsTextItem_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsTextItem::contains(point);
    }
  }

  //  [emitter impl] void QGraphicsTextItem::destroyed(QObject *)
  void emitter_QGraphicsTextItem_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsTextItem::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsTextItem::enabledChanged()
  void emitter_QGraphicsTextItem_enabledChanged_0()
  {
    emit QGraphicsTextItem::enabledChanged();
  }

  //  [adaptor impl] bool QGraphicsTextItem::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsTextItem::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsTextItem_Adaptor, bool, QObject *, QEvent *>(&QGraphicsTextItem_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsTextItem::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsTextItem::heightChanged()
  void emitter_QGraphicsTextItem_heightChanged_0()
  {
    emit QGraphicsTextItem::heightChanged();
  }

  //  [adaptor impl] bool QGraphicsTextItem::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsTextItem::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsTextItem_Adaptor, bool, const QGraphicsItem *>(&QGraphicsTextItem_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsTextItem::isObscuredBy(item);
    }
  }

  //  [emitter impl] void QGraphicsTextItem::linkActivated(const QString &)
  void emitter_QGraphicsTextItem_linkActivated_2025(const QString &arg1)
  {
    emit QGraphicsTextItem::linkActivated(arg1);
  }

  //  [emitter impl] void QGraphicsTextItem::linkHovered(const QString &)
  void emitter_QGraphicsTextItem_linkHovered_2025(const QString &arg1)
  {
    emit QGraphicsTextItem::linkHovered(arg1);
  }

  //  [emitter impl] void QGraphicsTextItem::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsTextItem_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsTextItem::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QGraphicsTextItem::opacityChanged()
  void emitter_QGraphicsTextItem_opacityChanged_0()
  {
    emit QGraphicsTextItem::opacityChanged();
  }

  //  [adaptor impl] QPainterPath QGraphicsTextItem::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsTextItem::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsTextItem_Adaptor, QPainterPath>(&QGraphicsTextItem_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsTextItem::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_0(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsTextItem::paint(painter, option, widget);
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_0.can_issue()) {
      cb_paint_6301_0.issue<QGraphicsTextItem_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsTextItem_Adaptor::cbs_paint_6301_0, painter, option, widget);
    } else {
      QGraphicsTextItem::paint(painter, option, widget);
    }
  }

  //  [emitter impl] void QGraphicsTextItem::parentChanged()
  void emitter_QGraphicsTextItem_parentChanged_0()
  {
    emit QGraphicsTextItem::parentChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::rotationChanged()
  void emitter_QGraphicsTextItem_rotationChanged_0()
  {
    emit QGraphicsTextItem::rotationChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::scaleChanged()
  void emitter_QGraphicsTextItem_scaleChanged_0()
  {
    emit QGraphicsTextItem::scaleChanged();
  }

  //  [adaptor impl] QPainterPath QGraphicsTextItem::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsTextItem::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsTextItem_Adaptor, QPainterPath>(&QGraphicsTextItem_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsTextItem::shape();
    }
  }

  //  [adaptor impl] int QGraphicsTextItem::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsTextItem::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsTextItem_Adaptor, int>(&QGraphicsTextItem_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsTextItem::type();
    }
  }

  //  [emitter impl] void QGraphicsTextItem::visibleChanged()
  void emitter_QGraphicsTextItem_visibleChanged_0()
  {
    emit QGraphicsTextItem::visibleChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::widthChanged()
  void emitter_QGraphicsTextItem_widthChanged_0()
  {
    emit QGraphicsTextItem::widthChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::xChanged()
  void emitter_QGraphicsTextItem_xChanged_0()
  {
    emit QGraphicsTextItem::xChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::yChanged()
  void emitter_QGraphicsTextItem_yChanged_0()
  {
    emit QGraphicsTextItem::yChanged();
  }

  //  [emitter impl] void QGraphicsTextItem::zChanged()
  void emitter_QGraphicsTextItem_zChanged_0()
  {
    emit QGraphicsTextItem::zChanged();
  }

  //  [adaptor impl] void QGraphicsTextItem::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsTextItem::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsTextItem_Adaptor, QChildEvent *>(&QGraphicsTextItem_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsTextItem::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsTextItem::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsTextItem_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsTextItem::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsTextItem::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsTextItem_Adaptor, QEvent *>(&QGraphicsTextItem_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsTextItem::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsTextItem::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsTextItem_Adaptor, const QMetaMethod &>(&QGraphicsTextItem_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsTextItem::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsTextItem::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsTextItem_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsTextItem::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsTextItem::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsTextItem_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsTextItem::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsTextItem::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsTextItem_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsTextItem::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsTextItem::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsTextItem_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsTextItem::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::event(QEvent *ev)
  bool cbs_event_1217_0(QEvent *ev)
  {
    return QGraphicsTextItem::event(ev);
  }

  virtual bool event(QEvent *ev)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsTextItem_Adaptor, bool, QEvent *>(&QGraphicsTextItem_Adaptor::cbs_event_1217_0, ev);
    } else {
      return QGraphicsTextItem::event(ev);
    }
  }

  //  [adaptor impl] QVariant QGraphicsTextItem::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsTextItem::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsTextItem_Adaptor, QVariant, const QVariant &>(&QGraphicsTextItem_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsTextItem::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsTextItem::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsTextItem_Adaptor, QFocusEvent *>(&QGraphicsTextItem_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsTextItem::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsTextItem::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsTextItem_Adaptor, QFocusEvent *>(&QGraphicsTextItem_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsTextItem::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsTextItem::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsTextItem_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsTextItem::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsTextItem::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsTextItem_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsTextItem::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsTextItem::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsTextItem_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsTextItem::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsTextItem::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsTextItem_Adaptor, QInputMethodEvent *>(&QGraphicsTextItem_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsTextItem::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsTextItem::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsTextItem::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsTextItem_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsTextItem_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsTextItem::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsTextItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsTextItem::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsTextItem_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsTextItem_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsTextItem::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsTextItem::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsTextItem_Adaptor, QKeyEvent *>(&QGraphicsTextItem_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsTextItem::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsTextItem::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsTextItem_Adaptor, QKeyEvent *>(&QGraphicsTextItem_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsTextItem::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsTextItem::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsTextItem_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsTextItem::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsTextItem::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsTextItem_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsTextItem::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsTextItem::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsTextItem_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsTextItem::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsTextItem::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsTextItem_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsTextItem::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsTextItem::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsTextItem_Adaptor, bool, QEvent *>(&QGraphicsTextItem_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsTextItem::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsTextItem::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsTextItem_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsTextItem_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsTextItem::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsTextItem::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsTextItem_Adaptor, unsigned int, const QVariant &>(&QGraphicsTextItem_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsTextItem::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] bool QGraphicsTextItem::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsTextItem::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsTextItem_Adaptor, bool, unsigned int>(&QGraphicsTextItem_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsTextItem::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsTextItem::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsTextItem_Adaptor, QTimerEvent *>(&QGraphicsTextItem_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsTextItem::timerEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsTextItem::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsTextItem::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsTextItem_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsTextItem_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsTextItem::wheelEvent(event);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_0;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsTextItem_Adaptor::~QGraphicsTextItem_Adaptor() { }

//  Constructor QGraphicsTextItem::QGraphicsTextItem(QGraphicsItem *parent) (adaptor class)

static void _init_ctor_QGraphicsTextItem_Adaptor_1919 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return_new<QGraphicsTextItem_Adaptor> ();
}

static void _call_ctor_QGraphicsTextItem_Adaptor_1919 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args ? gsi::arg_reader<QGraphicsItem * >() (args, heap) : gsi::arg_maker<QGraphicsItem * >() (nullptr, heap);
  ret.write<QGraphicsTextItem_Adaptor *> (new QGraphicsTextItem_Adaptor (arg1));
}


//  Constructor QGraphicsTextItem::QGraphicsTextItem(const QString &text, QGraphicsItem *parent) (adaptor class)

static void _init_ctor_QGraphicsTextItem_Adaptor_3836 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QGraphicsItem * > (argspec_1);
  decl->set_return_new<QGraphicsTextItem_Adaptor> ();
}

static void _call_ctor_QGraphicsTextItem_Adaptor_3836 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QGraphicsItem *arg2 = args ? gsi::arg_reader<QGraphicsItem * >() (args, heap) : gsi::arg_maker<QGraphicsItem * >() (nullptr, heap);
  ret.write<QGraphicsTextItem_Adaptor *> (new QGraphicsTextItem_Adaptor (arg1, arg2));
}


// exposed void QGraphicsTextItem::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_addToIndex_0 ();
}


// void QGraphicsTextItem::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_advance_767_0 = cb;
}


// QRectF QGraphicsTextItem::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsTextItem_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}


// void QGraphicsTextItem::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QGraphicsTextItem::childrenChanged()

static void _init_emitter_childrenChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_childrenChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_childrenChanged_0 ();
}


// bool QGraphicsTextItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}


// bool QGraphicsTextItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = args.read<const QPainterPath & > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}


// bool QGraphicsTextItem::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}


// void QGraphicsTextItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}


// void QGraphicsTextItem::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsTextItem::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_destroyed_1302 (arg1);
}


// void QGraphicsTextItem::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsTextItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}


// void QGraphicsTextItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}


// void QGraphicsTextItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}


// void QGraphicsTextItem::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}


// emitter void QGraphicsTextItem::enabledChanged()

static void _init_emitter_enabledChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_enabledChanged_0 ();
}


// bool QGraphicsTextItem::event(QEvent *ev)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsTextItem::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QVariant QGraphicsTextItem::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsTextItem_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}


// void QGraphicsTextItem::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// void QGraphicsTextItem::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// emitter void QGraphicsTextItem::heightChanged()

static void _init_emitter_heightChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_heightChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_heightChanged_0 ();
}


// void QGraphicsTextItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}


// void QGraphicsTextItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}


// void QGraphicsTextItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}


// void QGraphicsTextItem::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsTextItem::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsTextItem_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QGraphicsTextItem::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}


// exposed bool QGraphicsTextItem::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_isSignalConnected_c2394 (arg1));
}


// QVariant QGraphicsTextItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsTextItem_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}


// void QGraphicsTextItem::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsTextItem::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// emitter void QGraphicsTextItem::linkActivated(const QString &)

static void _init_emitter_linkActivated_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_linkActivated_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_linkActivated_2025 (arg1);
}


// emitter void QGraphicsTextItem::linkHovered(const QString &)

static void _init_emitter_linkHovered_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_linkHovered_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_linkHovered_2025 (arg1);
}


// void QGraphicsTextItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}


// void QGraphicsTextItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}


// void QGraphicsTextItem::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}


// void QGraphicsTextItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}


// emitter void QGraphicsTextItem::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_objectNameChanged_4567 (arg1);
}


// emitter void QGraphicsTextItem::opacityChanged()

static void _init_emitter_opacityChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_opacityChanged_0 ();
}


// QPainterPath QGraphicsTextItem::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsTextItem_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}


// void QGraphicsTextItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_paint_6301_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_paint_6301_0 = cb;
}


// emitter void QGraphicsTextItem::parentChanged()

static void _init_emitter_parentChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_parentChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_parentChanged_0 ();
}


// exposed void QGraphicsTextItem::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_prepareGeometryChange_0 ();
}


// exposed int QGraphicsTextItem::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_receivers_c1731 (arg1));
}


// exposed void QGraphicsTextItem::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_removeFromIndex_0 ();
}


// emitter void QGraphicsTextItem::rotationChanged()

static void _init_emitter_rotationChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rotationChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_rotationChanged_0 ();
}


// emitter void QGraphicsTextItem::scaleChanged()

static void _init_emitter_scaleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_scaleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_scaleChanged_0 ();
}


// bool QGraphicsTextItem::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}


// bool QGraphicsTextItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}


// exposed QObject *QGraphicsTextItem::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_sender_c0 ());
}


// exposed int QGraphicsTextItem::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_senderSignalIndex_c0 ());
}


// void QGraphicsTextItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}


// QPainterPath QGraphicsTextItem::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsTextItem_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_shape_c0_0 = cb;
}


// bool QGraphicsTextItem::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<bool > ((bool)((QGraphicsTextItem_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}


// void QGraphicsTextItem::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// int QGraphicsTextItem::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsTextItem_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// exposed void QGraphicsTextItem::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->fp_QGraphicsTextItem_updateMicroFocus_0 ();
}


// emitter void QGraphicsTextItem::visibleChanged()

static void _init_emitter_visibleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_visibleChanged_0 ();
}


// void QGraphicsTextItem::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsTextItem_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsTextItem_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}


// emitter void QGraphicsTextItem::widthChanged()

static void _init_emitter_widthChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_widthChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_widthChanged_0 ();
}


// emitter void QGraphicsTextItem::xChanged()

static void _init_emitter_xChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_xChanged_0 ();
}


// emitter void QGraphicsTextItem::yChanged()

static void _init_emitter_yChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_yChanged_0 ();
}


// emitter void QGraphicsTextItem::zChanged()

static void _init_emitter_zChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_zChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsTextItem_Adaptor *)cls)->emitter_QGraphicsTextItem_zChanged_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsTextItem> &qtdecl_QGraphicsTextItem ();

static gsi::Methods methods_QGraphicsTextItem_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsTextItem::QGraphicsTextItem(QGraphicsItem *parent)\nThis method creates an object of class QGraphicsTextItem.", &_init_ctor_QGraphicsTextItem_Adaptor_1919, &_call_ctor_QGraphicsTextItem_Adaptor_1919);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsTextItem::QGraphicsTextItem(const QString &text, QGraphicsItem *parent)\nThis method creates an object of class QGraphicsTextItem.", &_init_ctor_QGraphicsTextItem_Adaptor_3836, &_call_ctor_QGraphicsTextItem_Adaptor_3836);
  methods += new qt_gsi::GenericMethod ("*addToIndex", "@brief Method void QGraphicsTextItem::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsTextItem::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsTextItem::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsTextItem::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_childrenChanged", "@brief Emitter for signal void QGraphicsTextItem::childrenChanged()\nCall this method to emit this signal.", false, &_init_emitter_childrenChanged_0, &_call_emitter_childrenChanged_0);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsTextItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsTextItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsTextItem::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsTextItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsTextItem::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsTextItem::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsTextItem::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsTextItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsTextItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsTextItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsTextItem::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsTextItem::enabledChanged()\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_0, &_call_emitter_enabledChanged_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsTextItem::event(QEvent *ev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsTextItem::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsTextItem::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsTextItem::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsTextItem::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("emit_heightChanged", "@brief Emitter for signal void QGraphicsTextItem::heightChanged()\nCall this method to emit this signal.", false, &_init_emitter_heightChanged_0, &_call_emitter_heightChanged_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsTextItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsTextItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsTextItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsTextItem::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsTextItem::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsTextItem::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsTextItem::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsTextItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsTextItem::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsTextItem::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("emit_linkActivated", "@brief Emitter for signal void QGraphicsTextItem::linkActivated(const QString &)\nCall this method to emit this signal.", false, &_init_emitter_linkActivated_2025, &_call_emitter_linkActivated_2025);
  methods += new qt_gsi::GenericMethod ("emit_linkHovered", "@brief Emitter for signal void QGraphicsTextItem::linkHovered(const QString &)\nCall this method to emit this signal.", false, &_init_emitter_linkHovered_2025, &_call_emitter_linkHovered_2025);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsTextItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsTextItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsTextItem::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsTextItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsTextItem::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QGraphicsTextItem::opacityChanged()\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_0, &_call_emitter_opacityChanged_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsTextItem::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsTextItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_0, &_call_cbs_paint_6301_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_0, &_call_cbs_paint_6301_0, &_set_callback_cbs_paint_6301_0);
  methods += new qt_gsi::GenericMethod ("emit_parentChanged", "@brief Emitter for signal void QGraphicsTextItem::parentChanged()\nCall this method to emit this signal.", false, &_init_emitter_parentChanged_0, &_call_emitter_parentChanged_0);
  methods += new qt_gsi::GenericMethod ("*prepareGeometryChange", "@brief Method void QGraphicsTextItem::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsTextItem::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removeFromIndex", "@brief Method void QGraphicsTextItem::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
  methods += new qt_gsi::GenericMethod ("emit_rotationChanged", "@brief Emitter for signal void QGraphicsTextItem::rotationChanged()\nCall this method to emit this signal.", false, &_init_emitter_rotationChanged_0, &_call_emitter_rotationChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_scaleChanged", "@brief Emitter for signal void QGraphicsTextItem::scaleChanged()\nCall this method to emit this signal.", false, &_init_emitter_scaleChanged_0, &_call_emitter_scaleChanged_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsTextItem::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsTextItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsTextItem::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsTextItem::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsTextItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsTextItem::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsTextItem::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsTextItem::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsTextItem::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QGraphicsTextItem::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QGraphicsTextItem::visibleChanged()\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_0, &_call_emitter_visibleChanged_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsTextItem::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("emit_widthChanged", "@brief Emitter for signal void QGraphicsTextItem::widthChanged()\nCall this method to emit this signal.", false, &_init_emitter_widthChanged_0, &_call_emitter_widthChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QGraphicsTextItem::xChanged()\nCall this method to emit this signal.", false, &_init_emitter_xChanged_0, &_call_emitter_xChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QGraphicsTextItem::yChanged()\nCall this method to emit this signal.", false, &_init_emitter_yChanged_0, &_call_emitter_yChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_zChanged", "@brief Emitter for signal void QGraphicsTextItem::zChanged()\nCall this method to emit this signal.", false, &_init_emitter_zChanged_0, &_call_emitter_zChanged_0);
  return methods;
}

gsi::Class<QGraphicsTextItem_Adaptor> decl_QGraphicsTextItem_Adaptor (qtdecl_QGraphicsTextItem (), "QtWidgets", "QGraphicsTextItem",
  methods_QGraphicsTextItem_Adaptor (),
  "@qt\n@brief Binding of QGraphicsTextItem");

}

