/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_regenerate_bb = R"doc(Detect the peak of a signal and repeat every period samples.

If a peak is detected, this block outputs a 1 repeated every period samples until reset by detection of another 1 on the input or stopped after max_regen regenerations have occurred.


Note that if max_regen=(-1)/ULONG_MAX then the regeneration will run forever.

Constructor Specific Documentation:

Make a regenerate block.

Args:
    period : The number of samples between regenerations
    max_regen : The maximum number of regenerations to perform; if set to ULONG_MAX, it will regenerate continuously.)doc";


static const char* __doc_gr_blocks_regenerate_bb_regenerate_bb_0 = R"doc()doc";


static const char* __doc_gr_blocks_regenerate_bb_regenerate_bb_1 = R"doc()doc";


static const char* __doc_gr_blocks_regenerate_bb_make = R"doc(Detect the peak of a signal and repeat every period samples.

If a peak is detected, this block outputs a 1 repeated every period samples until reset by detection of another 1 on the input or stopped after max_regen regenerations have occurred.


Note that if max_regen=(-1)/ULONG_MAX then the regeneration will run forever.

Constructor Specific Documentation:

Make a regenerate block.

Args:
    period : The number of samples between regenerations
    max_regen : The maximum number of regenerations to perform; if set to ULONG_MAX, it will regenerate continuously.)doc";


static const char* __doc_gr_blocks_regenerate_bb_set_max_regen = R"doc(Reset the maximum regeneration count; this will reset the current regen.)doc";


static const char* __doc_gr_blocks_regenerate_bb_set_period = R"doc(Reset the period of regenerations; this will reset the current regen.)doc";


static const char* __doc_gr_blocks_regenerate_bb_max_regen = R"doc(return the maximum regeneration count.)doc";


static const char* __doc_gr_blocks_regenerate_bb_period = R"doc(return the regeneration period.)doc";
