/* gitg-remote-notification.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-remote-notification.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include "libgitg-ext.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <glib/gi18n-lib.h>

#define GITG_REMOTE_NOTIFICATION_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REMOTE_NOTIFICATION (gitg_remote_notification_get_type ())
#define GITG_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification))
#define GITG_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))
#define GITG_IS_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_IS_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_REMOTE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))

typedef struct _GitgRemoteNotification GitgRemoteNotification;
typedef struct _GitgRemoteNotificationClass GitgRemoteNotificationClass;
typedef struct _GitgRemoteNotificationPrivate GitgRemoteNotificationPrivate;
enum  {
	GITG_REMOTE_NOTIFICATION_0_PROPERTY,
	GITG_REMOTE_NOTIFICATION_WIDGET_PROPERTY,
	GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY,
	GITG_REMOTE_NOTIFICATION_REMOTE_STATE_PROPERTY,
	GITG_REMOTE_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block74Data Block74Data;
typedef struct _Block75Data Block75Data;
typedef struct _Block76Data Block76Data;
typedef struct _Block77Data Block77Data;
typedef struct _Block78Data Block78Data;
enum  {
	GITG_REMOTE_NOTIFICATION_CANCEL_SIGNAL,
	GITG_REMOTE_NOTIFICATION_NUM_SIGNALS
};
static guint gitg_remote_notification_signals[GITG_REMOTE_NOTIFICATION_NUM_SIGNALS] = {0};

struct _GitgRemoteNotification {
	GitgProgressBin parent_instance;
	GitgRemoteNotificationPrivate * priv;
};

struct _GitgRemoteNotificationClass {
	GitgProgressBinClass parent_class;
};

struct _GitgRemoteNotificationPrivate {
	GitgRemote* d_remote;
	GtkImage* d_image_icon;
	GtkLabel* d_label_text;
	GtkButton* d_button_cancel;
	gboolean d_finished;
	gchar* d_text;
};

struct _Block74Data {
	int _ref_count_;
	GitgRemoteNotification* self;
	gchar* text;
};

struct _Block75Data {
	int _ref_count_;
	GitgRemoteNotification* self;
	gchar* text;
};

struct _Block76Data {
	int _ref_count_;
	GitgRemoteNotification* self;
	gboolean auto_close;
};

struct _Block77Data {
	int _ref_count_;
	GitgRemoteNotification* self;
	gchar* value;
};

struct _Block78Data {
	int _ref_count_;
	GitgRemoteNotification* self;
	GitgRemoteState value;
};

static gint GitgRemoteNotification_private_offset;
static gpointer gitg_remote_notification_parent_class = NULL;
static GitgExtNotificationIface * gitg_remote_notification_gitg_ext_notification_parent_iface = NULL;

VALA_EXTERN GType gitg_remote_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoteNotification, g_object_unref)
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_new (GitgRemote* remote);
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_construct (GType object_type,
                                                            GitgRemote* remote);
VALA_EXTERN void gitg_remote_notification_success (GitgRemoteNotification* self,
                                       const gchar* text);
static Block74Data* block74_data_ref (Block74Data* _data74_);
static void block74_data_unref (void * _userdata_);
static gboolean __lambda92_ (Block74Data* _data74_);
VALA_EXTERN void gitg_remote_notification_set_text (GitgRemoteNotification* self,
                                        const gchar* value);
static void gitg_remote_notification_finish (GitgRemoteNotification* self,
                                      gboolean auto_close);
static gboolean ___lambda92__gsource_func (gpointer self);
VALA_EXTERN void gitg_remote_notification_error (GitgRemoteNotification* self,
                                     const gchar* text);
static Block75Data* block75_data_ref (Block75Data* _data75_);
static void block75_data_unref (void * _userdata_);
static gboolean __lambda95_ (Block75Data* _data75_);
static gboolean ___lambda95__gsource_func (gpointer self);
static Block76Data* block76_data_ref (Block76Data* _data76_);
static void block76_data_unref (void * _userdata_);
static gboolean __lambda94_ (Block76Data* _data76_);
static gboolean ___lambda94__gsource_func (gpointer self);
static void gitg_remote_notification_on_button_cancel_clicked (GitgRemoteNotification* self);
static void _gitg_remote_notification_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
VALA_EXTERN const gchar* gitg_remote_notification_get_text (GitgRemoteNotification* self);
static Block77Data* block77_data_ref (Block77Data* _data77_);
static void block77_data_unref (void * _userdata_);
static gboolean _gitg_remote_notification_text___lambda93_ (Block77Data* _data77_);
static gboolean __gitg_remote_notification_text___lambda93__gsource_func (gpointer self);
VALA_EXTERN void gitg_remote_notification_set_remote_state (GitgRemoteNotification* self,
                                                GitgRemoteState value);
static Block78Data* block78_data_ref (Block78Data* _data78_);
static void block78_data_unref (void * _userdata_);
static gboolean _gitg_remote_notification_remote_state___lambda96_ (Block78Data* _data78_);
static gboolean __gitg_remote_notification_remote_state___lambda96__gsource_func (gpointer self);
static void gitg_remote_notification_finalize (GObject * obj);
static GType gitg_remote_notification_get_type_once (void);
static void _vala_gitg_remote_notification_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gitg_remote_notification_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
gitg_remote_notification_get_instance_private (GitgRemoteNotification* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemoteNotification_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgRemoteNotification*
gitg_remote_notification_construct (GType object_type,
                                    GitgRemote* remote)
{
	GitgRemoteNotification * self = NULL;
	GitgRemote* _tmp0_;
	GitgRemote* _tmp1_;
	GitgRemote* _tmp2_;
	g_return_val_if_fail (remote != NULL, NULL);
	self = (GitgRemoteNotification*) gitg_progress_bin_construct (object_type);
	_tmp0_ = _g_object_ref0 (remote);
	_g_object_unref0 (self->priv->d_remote);
	self->priv->d_remote = _tmp0_;
	_tmp1_ = self->priv->d_remote;
	g_object_bind_property_with_closures ((GObject*) _tmp1_, "state", (GObject*) self, "remote_state", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = self->priv->d_remote;
	g_object_bind_property_with_closures ((GObject*) _tmp2_, "transfer-progress", (GObject*) self, "fraction", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

GitgRemoteNotification*
gitg_remote_notification_new (GitgRemote* remote)
{
	return gitg_remote_notification_construct (GITG_TYPE_REMOTE_NOTIFICATION, remote);
}

static Block74Data*
block74_data_ref (Block74Data* _data74_)
{
	g_atomic_int_inc (&_data74_->_ref_count_);
	return _data74_;
}

static void
block74_data_unref (void * _userdata_)
{
	Block74Data* _data74_;
	_data74_ = (Block74Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data74_->_ref_count_)) {
		GitgRemoteNotification* self;
		self = _data74_->self;
		_g_free0 (_data74_->text);
		_g_object_unref0 (self);
		g_slice_free (Block74Data, _data74_);
	}
}

static gboolean
__lambda92_ (Block74Data* _data74_)
{
	GitgRemoteNotification* self;
	GtkImage* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean result;
	self = _data74_->self;
	_tmp0_ = self->priv->d_image_icon;
	g_object_set (_tmp0_, "icon-name", "emblem-ok-symbolic", NULL);
	gitg_remote_notification_set_text (self, _data74_->text);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "success");
	gitg_remote_notification_finish (self, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda92__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda92_ (self);
	return result;
}

void
gitg_remote_notification_success (GitgRemoteNotification* self,
                                  const gchar* text)
{
	Block74Data* _data74_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data74_ = g_slice_new0 (Block74Data);
	_data74_->_ref_count_ = 1;
	_data74_->self = g_object_ref (self);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data74_->text);
	_data74_->text = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda92__gsource_func, block74_data_ref (_data74_), block74_data_unref);
	block74_data_unref (_data74_);
	_data74_ = NULL;
}

static Block75Data*
block75_data_ref (Block75Data* _data75_)
{
	g_atomic_int_inc (&_data75_->_ref_count_);
	return _data75_;
}

static void
block75_data_unref (void * _userdata_)
{
	Block75Data* _data75_;
	_data75_ = (Block75Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data75_->_ref_count_)) {
		GitgRemoteNotification* self;
		self = _data75_->self;
		_g_free0 (_data75_->text);
		_g_object_unref0 (self);
		g_slice_free (Block75Data, _data75_);
	}
}

static gboolean
__lambda95_ (Block75Data* _data75_)
{
	GitgRemoteNotification* self;
	GtkImage* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean result;
	self = _data75_->self;
	_tmp0_ = self->priv->d_image_icon;
	g_object_set (_tmp0_, "icon-name", "network-error-symbolic", NULL);
	gitg_remote_notification_set_text (self, _data75_->text);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "error");
	gitg_remote_notification_finish (self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda95__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda95_ (self);
	return result;
}

void
gitg_remote_notification_error (GitgRemoteNotification* self,
                                const gchar* text)
{
	Block75Data* _data75_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data75_ = g_slice_new0 (Block75Data);
	_data75_->_ref_count_ = 1;
	_data75_->self = g_object_ref (self);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data75_->text);
	_data75_->text = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda95__gsource_func, block75_data_ref (_data75_), block75_data_unref);
	block75_data_unref (_data75_);
	_data75_ = NULL;
}

static Block76Data*
block76_data_ref (Block76Data* _data76_)
{
	g_atomic_int_inc (&_data76_->_ref_count_);
	return _data76_;
}

static void
block76_data_unref (void * _userdata_)
{
	Block76Data* _data76_;
	_data76_ = (Block76Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data76_->_ref_count_)) {
		GitgRemoteNotification* self;
		self = _data76_->self;
		_g_object_unref0 (self);
		g_slice_free (Block76Data, _data76_);
	}
}

static gboolean
__lambda94_ (Block76Data* _data76_)
{
	GitgRemoteNotification* self;
	GtkButton* _tmp0_;
	gboolean result;
	self = _data76_->self;
	self->priv->d_finished = TRUE;
	_tmp0_ = self->priv->d_button_cancel;
	gtk_button_set_label (_tmp0_, _ ("Close"));
	if (_data76_->auto_close) {
		g_signal_emit_by_name ((GitgExtNotification*) self, "close", (guint) 3000);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda94__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda94_ (self);
	return result;
}

static void
gitg_remote_notification_finish (GitgRemoteNotification* self,
                                 gboolean auto_close)
{
	Block76Data* _data76_;
	g_return_if_fail (self != NULL);
	_data76_ = g_slice_new0 (Block76Data);
	_data76_->_ref_count_ = 1;
	_data76_->self = g_object_ref (self);
	_data76_->auto_close = auto_close;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda94__gsource_func, block76_data_ref (_data76_), block76_data_unref);
	block76_data_unref (_data76_);
	_data76_ = NULL;
}

static void
gitg_remote_notification_on_button_cancel_clicked (GitgRemoteNotification* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_finished) {
		g_signal_emit_by_name ((GitgExtNotification*) self, "close", (guint) 0);
	} else {
		g_signal_emit (self, gitg_remote_notification_signals[GITG_REMOTE_NOTIFICATION_CANCEL_SIGNAL], 0);
	}
}

static void
_gitg_remote_notification_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	gitg_remote_notification_on_button_cancel_clicked ((GitgRemoteNotification*) self);
}

static GtkWidget*
gitg_remote_notification_real_get_widget (GitgExtNotification* base)
{
	GtkWidget* result;
	GitgRemoteNotification* self;
	GtkWidget* _tmp0_;
	self = (GitgRemoteNotification*) base;
	_tmp0_ = _g_object_ref0 ((GtkWidget*) self);
	result = _tmp0_;
	return result;
}

const gchar*
gitg_remote_notification_get_text (GitgRemoteNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_text;
	result = _tmp0_;
	return result;
}

static Block77Data*
block77_data_ref (Block77Data* _data77_)
{
	g_atomic_int_inc (&_data77_->_ref_count_);
	return _data77_;
}

static void
block77_data_unref (void * _userdata_)
{
	Block77Data* _data77_;
	_data77_ = (Block77Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data77_->_ref_count_)) {
		GitgRemoteNotification* self;
		self = _data77_->self;
		_g_free0 (_data77_->value);
		_g_object_unref0 (self);
		g_slice_free (Block77Data, _data77_);
	}
}

static gboolean
_gitg_remote_notification_text___lambda93_ (Block77Data* _data77_)
{
	GitgRemoteNotification* self;
	GtkLabel* _tmp0_;
	gboolean result;
	self = _data77_->self;
	_tmp0_ = self->priv->d_label_text;
	gtk_label_set_label (_tmp0_, _data77_->value);
	result = FALSE;
	return result;
}

static gboolean
__gitg_remote_notification_text___lambda93__gsource_func (gpointer self)
{
	gboolean result;
	result = _gitg_remote_notification_text___lambda93_ (self);
	return result;
}

void
gitg_remote_notification_set_text (GitgRemoteNotification* self,
                                   const gchar* value)
{
	Block77Data* _data77_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data77_ = g_slice_new0 (Block77Data);
	_data77_->_ref_count_ = 1;
	_data77_->self = g_object_ref (self);
	_tmp0_ = g_strdup (value);
	_g_free0 (_data77_->value);
	_data77_->value = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __gitg_remote_notification_text___lambda93__gsource_func, block77_data_ref (_data77_), block77_data_unref);
	block77_data_unref (_data77_);
	_data77_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY]);
}

static Block78Data*
block78_data_ref (Block78Data* _data78_)
{
	g_atomic_int_inc (&_data78_->_ref_count_);
	return _data78_;
}

static void
block78_data_unref (void * _userdata_)
{
	Block78Data* _data78_;
	_data78_ = (Block78Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data78_->_ref_count_)) {
		GitgRemoteNotification* self;
		self = _data78_->self;
		_g_object_unref0 (self);
		g_slice_free (Block78Data, _data78_);
	}
}

static gboolean
_gitg_remote_notification_remote_state___lambda96_ (Block78Data* _data78_)
{
	GitgRemoteNotification* self;
	gboolean result;
	self = _data78_->self;
	switch (_data78_->value) {
		case GITG_REMOTE_STATE_CONNECTING:
		{
			GtkImage* _tmp0_;
			_tmp0_ = self->priv->d_image_icon;
			g_object_set (_tmp0_, "icon-name", "network-wireless-acquiring-symbolic", NULL);
			break;
		}
		case GITG_REMOTE_STATE_CONNECTED:
		{
			GtkImage* _tmp1_;
			_tmp1_ = self->priv->d_image_icon;
			g_object_set (_tmp1_, "icon-name", "network-idle-symbolic", NULL);
			break;
		}
		case GITG_REMOTE_STATE_TRANSFERRING:
		{
			GtkImage* _tmp2_;
			_tmp2_ = self->priv->d_image_icon;
			g_object_set (_tmp2_, "icon-name", "network-transmit-receive-symbolic", NULL);
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
__gitg_remote_notification_remote_state___lambda96__gsource_func (gpointer self)
{
	gboolean result;
	result = _gitg_remote_notification_remote_state___lambda96_ (self);
	return result;
}

void
gitg_remote_notification_set_remote_state (GitgRemoteNotification* self,
                                           GitgRemoteState value)
{
	Block78Data* _data78_;
	g_return_if_fail (self != NULL);
	_data78_ = g_slice_new0 (Block78Data);
	_data78_->_ref_count_ = 1;
	_data78_->self = g_object_ref (self);
	_data78_->value = value;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __gitg_remote_notification_remote_state___lambda96__gsource_func, block78_data_ref (_data78_), block78_data_unref);
	block78_data_unref (_data78_);
	_data78_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_REMOTE_STATE_PROPERTY]);
}

static void
gitg_remote_notification_class_init (GitgRemoteNotificationClass * klass,
                                     gpointer klass_data)
{
	gitg_remote_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemoteNotification_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_remote_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_remote_notification_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_notification_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_NOTIFICATION_WIDGET_PROPERTY, gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY, gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_NOTIFICATION_REMOTE_STATE_PROPERTY, gitg_remote_notification_properties[GITG_REMOTE_NOTIFICATION_REMOTE_STATE_PROPERTY] = g_param_spec_enum ("remote-state", "remote-state", "remote-state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-remote-notification.ui");
	gitg_remote_notification_signals[GITG_REMOTE_NOTIFICATION_CANCEL_SIGNAL] = g_signal_new ("cancel", GITG_TYPE_REMOTE_NOTIFICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, GitgRemoteNotification_private_offset + G_STRUCT_OFFSET (GitgRemoteNotificationPrivate, d_image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_text", FALSE, GitgRemoteNotification_private_offset + G_STRUCT_OFFSET (GitgRemoteNotificationPrivate, d_label_text));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_cancel", FALSE, GitgRemoteNotification_private_offset + G_STRUCT_OFFSET (GitgRemoteNotificationPrivate, d_button_cancel));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_button_cancel_clicked", G_CALLBACK(_gitg_remote_notification_on_button_cancel_clicked_gtk_button_clicked));
}

static void
gitg_remote_notification_gitg_ext_notification_interface_init (GitgExtNotificationIface * iface,
                                                               gpointer iface_data)
{
	gitg_remote_notification_gitg_ext_notification_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_widget = gitg_remote_notification_real_get_widget;
}

static void
gitg_remote_notification_instance_init (GitgRemoteNotification * self,
                                        gpointer klass)
{
	self->priv = gitg_remote_notification_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_remote_notification_finalize (GObject * obj)
{
	GitgRemoteNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification);
	_g_object_unref0 (self->priv->d_remote);
	_g_free0 (self->priv->d_text);
	G_OBJECT_CLASS (gitg_remote_notification_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoteNotification), 0, (GInstanceInitFunc) gitg_remote_notification_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_notification_info = { (GInterfaceInitFunc) gitg_remote_notification_gitg_ext_notification_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_remote_notification_type_id;
	gitg_remote_notification_type_id = g_type_register_static (GITG_TYPE_PROGRESS_BIN, "GitgRemoteNotification", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_remote_notification_type_id, GITG_EXT_TYPE_NOTIFICATION, &gitg_ext_notification_info);
	GitgRemoteNotification_private_offset = g_type_add_instance_private (gitg_remote_notification_type_id, sizeof (GitgRemoteNotificationPrivate));
	return gitg_remote_notification_type_id;
}

GType
gitg_remote_notification_get_type (void)
{
	static gsize gitg_remote_notification_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_notification_type_id__once)) {
		GType gitg_remote_notification_type_id;
		gitg_remote_notification_type_id = gitg_remote_notification_get_type_once ();
		g_once_init_leave (&gitg_remote_notification_type_id__once, gitg_remote_notification_type_id);
	}
	return gitg_remote_notification_type_id__once;
}

static void
_vala_gitg_remote_notification_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GitgRemoteNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification);
	switch (property_id) {
		case GITG_REMOTE_NOTIFICATION_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_notification_get_widget ((GitgExtNotification*) self));
		break;
		case GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY:
		g_value_set_string (value, gitg_remote_notification_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_remote_notification_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GitgRemoteNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification);
	switch (property_id) {
		case GITG_REMOTE_NOTIFICATION_TEXT_PROPERTY:
		gitg_remote_notification_set_text (self, g_value_get_string (value));
		break;
		case GITG_REMOTE_NOTIFICATION_REMOTE_STATE_PROPERTY:
		gitg_remote_notification_set_remote_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

