/** generated file, do not edit! */
#ifndef DT_PREFERENCES_H
#define DT_PREFERENCES_H

#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-variable"

#include <gtk/gtk.h>
#include "control/conf.h"
#include "common/calculator.h"
#include "gui/preferences.h"

#define NON_DEF_CHAR "●"

static gboolean handle_enter_key(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  guint keyval;

  gdk_event_get_keyval ((GdkEvent*)event, &keyval);

  if(keyval == GDK_KEY_Return || keyval == GDK_KEY_KP_Enter)
    return TRUE;
  return FALSE;
}

static void set_widget_label_default(GtkWidget *widget,
                                     const char *confstr,
                                     GtkWidget *label,
                                     const float factor)
{
  gboolean is_default = TRUE;

  if(GTK_IS_CHECK_BUTTON(widget))
  {
    const gboolean c_default = dt_confgen_get_bool(confstr, DT_DEFAULT);
    const gboolean c_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
    is_default = (c_state == c_default);
  }
  else if(DT_IS_BAUHAUS_WIDGET(widget))
  {
    const int v_default = dt_bauhaus_combobox_get_default(widget);
    const int v_state = GPOINTER_TO_INT(dt_bauhaus_combobox_get_data(widget));
    is_default = (v_state == v_default);
  }
  else if(GTK_IS_SPIN_BUTTON(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const float v_default = dt_calculator_solve(1, c_default) * factor;
    const float v_state = gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget));
    is_default = (v_state == v_default);
  }
  else if(GTK_IS_ENTRY(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const gchar *c_state = gtk_entry_get_text(GTK_ENTRY(widget));
    is_default = (g_strcmp0(c_state, c_default) == 0);
  }
  else if(GTK_IS_FILE_CHOOSER(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const gchar *c_state = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
    is_default = (g_strcmp0(c_state, c_default) == 0);
  }
  else
  {
    // other unsupported widgets
    return;
  }

  if(is_default)
  {
    // replace * with space
    gtk_label_set_text(GTK_LABEL(label), "");
    gtk_widget_set_tooltip_text(label, NULL);
  }
  else
  {
    // replace space with *
    gtk_label_set_text(GTK_LABEL(label), NON_DEF_CHAR);
    gtk_widget_set_tooltip_text(label, _("this setting has been modified"));
  }
}

static GtkWidget *create_tab(GtkWidget *stack,
                             const char *title,
                             const char *l10n_title)
{
  GtkWidget *widget, *box;
  GtkWidget *grid = gtk_grid_new();
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
  GtkWidget *scroll = dt_gui_scroll_wrap(grid);
  GtkWidget *help = gtk_button_new_with_label(_("?"));
  gtk_widget_set_halign(help, GTK_ALIGN_END);
  gchar *pref = g_strdup_printf("preferences-settings/%s", title);
  g_object_set_data_full(G_OBJECT(help), "dt-help-url", pref, g_free);
  g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
  gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
  gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
  gtk_stack_add_titled(GTK_STACK(stack), tab_box, l10n_title, l10n_title);
  return grid;
}

static GtkWidget *setup_pref(GtkWidget **label,
                             GtkWidget **labelev,
                             const gchar *pref,
                             const gchar *shortdes)
{
  const gboolean is_default = dt_conf_is_default(pref);
  GtkWidget *labdef = NULL;
  if(is_default)
  {
    labdef = gtk_label_new("");
  }
  else
  {
    labdef = gtk_label_new(NON_DEF_CHAR);
    gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
  }
  gtk_widget_set_name(labdef, "preference_non_default");
  *label = gtk_label_new_with_mnemonic(shortdes);
  gtk_label_set_xalign(GTK_LABEL(*label), .0);
  *labelev = gtk_event_box_new();
  gtk_widget_add_events(*labelev, GDK_BUTTON_PRESS_MASK);
  gtk_container_add(GTK_CONTAINER(*labelev), *label);
  gtk_event_box_set_visible_window(GTK_EVENT_BOX(*labelev), FALSE);
  return labdef;
}

static void setup_not_available(GtkWidget **widget,
                                GtkWidget *labelev)
{
  gtk_widget_destroy(*widget);
  *widget = gtk_label_new(_("not available"));
  gtk_widget_set_halign(*widget, GTK_ALIGN_START);
  gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
  gtk_widget_set_tooltip_text(*widget, _("not available on this system"));
  gtk_widget_set_sensitive(labelev, FALSE);
  gtk_widget_set_sensitive(*widget, FALSE);
}

static void wrapup_pref(const gchar *name,
                        GtkWidget *grid,
                        GtkWidget *labelev,
                        GtkWidget *labdef,
                        GtkWidget *label,
                        GtkWidget *widget,
                        int *line,
                        gboolean (*callback)(GtkWidget *, GdkEventButton *, GtkWidget*))
{
  gtk_widget_set_name(widget, name);
  gtk_grid_attach(GTK_GRID(grid), labelev, 0, *line, 1, 1);
  gtk_grid_attach(GTK_GRID(grid), labdef, 1, *line, 1, 1);
  gtk_grid_attach(GTK_GRID(grid), widget, 2, (*line)++, 1, 1);
  gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
  g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(callback), (gpointer)widget);
}

static gboolean click_widget_label(GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_BUTTON_PRESS && GTK_IS_BUTTON(widget))
  {
    gtk_button_clicked(GTK_BUTTON(widget));
    return TRUE;
  }
  else
    return FALSE;
}

static gboolean preferences_response_callback(GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return TRUE;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return TRUE;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return TRUE;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));
  return FALSE;
}

static gboolean click_widget_toggle_set(GtkWidget *label,
                                        GdkEventButton *event,
                                        GtkWidget *widget,
                                        const gboolean value)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), value);
    return TRUE;
  }
  return FALSE;
}

static gboolean click_widget_toggle_true(GtkWidget *label,
                                         GdkEventButton *event,
                                         GtkWidget *widget)
{
  return click_widget_toggle_set(label, event, widget, TRUE);
}

static gboolean click_widget_toggle_false(GtkWidget *label,
                                          GdkEventButton *event,
                                          GtkWidget *widget)
{
  return click_widget_toggle_set(label, event, widget, FALSE);
}

static gboolean click_widget_enum(GtkWidget *label,
                                  GdkEventButton *event,
                                  GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
  }

gboolean restart_required = FALSE;

static gboolean
click_widget_id1 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id2 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 5 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id3 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id4 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id5 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id6 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 1 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id7 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "120|400");
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id8 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)", strlen("$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id9 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>", strlen("<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id10 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)", strlen("$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id11 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(PICTURES_FOLDER)/Darktable");
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id12 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id13 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id14 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 50 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id15 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 20 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id16 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id17 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {    
    const float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 250 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id18 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "aplay");
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id19 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gchar *path = dt_conf_expand_default_dir("$(home)");
    dt_conf_set_string("plugins/darkroom/lut3d/def_path", path);
    g_free(path);
    path = dt_conf_get_string("plugins/darkroom/lut3d/def_path");
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(widget), path);
    g_free(path);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id20 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gchar *path = dt_conf_expand_default_dir("$(home)");
    dt_conf_set_string("plugins/darkroom/segments/def_path", path);
    g_free(path);
    path = dt_conf_get_string("plugins/darkroom/segments/def_path");
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(widget), path);
    g_free(path);
    return TRUE;
  }
  return FALSE;
}

static gboolean
click_widget_id21 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(!click_widget_label(label, event, widget)
     && event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    return TRUE;
  }
  return FALSE;
}

static void
preferences_response_callback_id22 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/prefer_focused", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id23 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/prefer_expanded", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id24 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/prefer_enabled", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id25 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/prefer_unmasked", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id26 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("accel/select_order", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id27 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/assign_instance", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id28 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("show_splash_screen", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id29 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("accel/load_defaults", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id30 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("bauhaus/zoom_step", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id31 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("bauhaus/marker_shape", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id32 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("database/multiple_workspace", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id33 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("database/create_snapshot", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id1 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("database/keep_snapshots", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id2 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("slideshow_delay", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id34 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("resourcelevel", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id35 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("write_sidecar_files", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id36 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("compress_xmp_tags", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id3 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("autosave_interval", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id37 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("omit_tag_hierarchy", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id38 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/tagging/no_uncategorized", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id39 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/lighttable/tagging/case_sensitivity", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id40 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("opencl", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id41 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("opencl_scheduling_profile", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id42 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("opencl_tune_headroom", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id43 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_intelropenclhdgraphics", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id44 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_nvidiacuda", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id45 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_amdacceleratedparallelprocessing", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id46 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_rusticl", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id47 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_apple", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id48 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_openclon12", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id49 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("clplatform_other", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id50 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_remove", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id51 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_delete", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id52 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_discard", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id53 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("send_to_trash", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id54 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_move", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id55 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_copy", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id56 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ask_before_rmdir", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id4 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("plugins/lighttable/recentcollect/max_items", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id5 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("plugins/lighttable/collect/history_max", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id6 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("show_folder_levels", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id57 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/collect/filmroll_sort", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id58 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/lighttable/thumbnail_raw_min_level", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id59 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/lighttable/thumbnail_hq_min_level", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id60 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("cache_disk_backend", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id61 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("cache_disk_backend_full", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id62 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("thumbtable_fractional_scrolling", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id63 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("backthumbs_mipsize", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id64 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("backthumbs_initialize", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id7 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("plugins/lighttable/thumbnail_sizes", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_response_callback_id8 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
    gtk_text_buffer_get_start_iter(buffer, &start);
    gtk_text_buffer_get_end_iter(buffer, &end);
    dt_conf_set_string("plugins/lighttable/extended_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
  }
}

static void
preferences_response_callback_id9 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
    gtk_text_buffer_get_start_iter(buffer, &start);
    gtk_text_buffer_get_end_iter(buffer, &end);
    dt_conf_set_string("plugins/lighttable/thumbnail_tooltip_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
  }
}

static void
preferences_response_callback_id65 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("masks_scroll_down_increases", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id66 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id67 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("channel_display", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id10 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
    gtk_text_buffer_get_start_iter(buffer, &start);
    gtk_text_buffer_get_end_iter(buffer, &end);
    dt_conf_set_string("plugins/darkroom/image_infos_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
  }
}

static void
preferences_response_callback_id68 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/darkroom/image_infos_position", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id69 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("modules/default_presets_first", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id70 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/darkroom/hide_default_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id71 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/darkroom/show_guides_in_ui", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id72 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/hide_default_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id11 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("session/base_directory_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_response_callback_id12 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("session/sub_directory_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_response_callback_id73 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("session/use_filename", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id13 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("session/filename_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_response_callback_id74 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/collect/single-click", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id75 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/act_on", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id76 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/tagging/ask_before_delete_tag", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id14 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("plugins/lighttable/tagging/confidence", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id15 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("plugins/lighttable/tagging/nb_recent_tags", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id77 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/style/ask_before_delete_style", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id78 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/preset/ask_before_delete_preset", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id79 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/export/ask_before_export_overwrite", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id80 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/metadata_view/pretty_location", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id81 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("lighttable/ui/single_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id82 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/single_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id83 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/single_module_group_only", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id84 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/activate_expand", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id85 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("lighttable/ui/scroll_to_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id86 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/scroll_to_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id87 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/sidebar_scroll_default", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id16 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("plugins/darkroom/ui/border_size", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id88 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/scrollbars", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id89 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("panel_scrollbars_always_visible", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id17 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const float factor = 1.0f;
    dt_conf_set_int("darkroom/ui/transition_duration", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
  }
}

static void
preferences_response_callback_id90 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/lighttable/export/force_lcms2", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id91 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("rating_one_double_tap", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id92 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("lighttable/ui/scrollbars", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id93 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("lighttable/ui/milliseconds", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id94 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/loading_screen", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id95 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/lighttable/export/pixel_interpolator_warp", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id96 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/lighttable/export/pixel_interpolator", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id97 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/pwstorage/pwstorage_backend", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id98 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/imageio/storage/export/auto_login", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id99 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/darkroom/histogram/panel_position", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id100 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/darkroom/panel_swap", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id101 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("ui_last/display_profile_source", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id102 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("run_crawler_on_start", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id18 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("plugins/lighttable/audio_player", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_response_callback_id19 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    gchar *folder = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
    dt_conf_set_string("plugins/darkroom/lut3d/def_path", folder);
    g_free(folder);
  }
}

static void
preferences_response_callback_id20 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    gchar *folder = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
    dt_conf_set_string("plugins/darkroom/segments/def_path", folder);
    g_free(folder);
  }
}

static void
preferences_response_callback_id103 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("plugins/darkroom/workflow", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id104 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/darkroom/basecurve/auto_apply_percamera_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id105 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("ui/detect_mono_exif", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id106 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("plugins/darkroom/show_warnings", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id107 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    const gchar *index = dt_bauhaus_combobox_get_data(widget);
    gchar *s = g_strndup(index, strchr(index, ']') - index);
    dt_conf_set_string("darkroom/ui/hide_header_buttons", s);
    g_free(s);
  }
}

static void
preferences_response_callback_id108 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/show_mask_indicator", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id109 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/rename_new_instance", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id110 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_bool("darkroom/ui/auto_module_name_update", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  }
}

static void
preferences_response_callback_id21 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  if(!preferences_response_callback(dialog, response_id, widget))
  {
    dt_conf_set_string("plugins/midi/devices", gtk_entry_get_text(GTK_ENTRY(widget)));
  }
}

static void
preferences_changed_callback_id22 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_focused", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id23 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_expanded", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id24 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_enabled", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id25 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_unmasked", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id26 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/select_order", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id27 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/assign_instance", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id28 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "show_splash_screen", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id29 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "accel/load_defaults", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id30 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "bauhaus/zoom_step", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id31 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "bauhaus/marker_shape", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id32 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "database/multiple_workspace", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id33 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "database/create_snapshot", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id1 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "database/keep_snapshots", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id2 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "slideshow_delay", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id34 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "resourcelevel", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id35 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "write_sidecar_files", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id36 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "compress_xmp_tags", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id3 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "autosave_interval", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id37 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "omit_tag_hierarchy", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id38 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/no_uncategorized", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id39 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/case_sensitivity", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id40 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "opencl", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id41 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "opencl_scheduling_profile", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id42 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "opencl_tune_headroom", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id43 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_intelropenclhdgraphics", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id44 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_nvidiacuda", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id45 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_amdacceleratedparallelprocessing", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id46 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_rusticl", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id47 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_apple", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id48 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_openclon12", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id49 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_other", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id50 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_remove", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id51 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_delete", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id52 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_discard", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id53 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "send_to_trash", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id54 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_move", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id55 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_copy", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id56 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_rmdir", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id4 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/recentcollect/max_items", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id5 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/collect/history_max", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id6 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "show_folder_levels", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id57 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/collect/filmroll_sort", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id58 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_raw_min_level", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id59 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_hq_min_level", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id60 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "cache_disk_backend", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id61 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "cache_disk_backend_full", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id62 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "thumbtable_fractional_scrolling", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id63 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "backthumbs_mipsize", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id64 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "backthumbs_initialize", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id7 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_sizes", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id8 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/extended_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id9 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_tooltip_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id65 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "masks_scroll_down_increases", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id66 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/mouse/middle_button_cycle_zoom_to_200_percent", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id67 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "channel_display", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id10 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/image_infos_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id68 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/image_infos_position", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id69 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "modules/default_presets_first", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id70 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/hide_default_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id71 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/show_guides_in_ui", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id72 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/hide_default_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id11 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "session/base_directory_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id12 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "session/sub_directory_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id73 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "session/use_filename", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id13 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "session/filename_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id74 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/collect/single-click", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id75 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/act_on", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id76 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/ask_before_delete_tag", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id14 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/confidence", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id15 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/nb_recent_tags", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id77 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/style/ask_before_delete_style", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id78 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/preset/ask_before_delete_preset", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id79 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/ask_before_export_overwrite", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id80 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/metadata_view/pretty_location", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id81 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/single_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id82 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/single_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id83 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/single_module_group_only", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id84 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/activate_expand", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id85 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/scroll_to_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id86 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/scroll_to_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id87 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/sidebar_scroll_default", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id16 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/ui/border_size", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id88 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/scrollbars", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id89 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "panel_scrollbars_always_visible", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id17 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/transition_duration", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id90 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/force_lcms2", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id91 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "rating_one_double_tap", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id92 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/scrollbars", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id93 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/milliseconds", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id94 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/loading_screen", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id95 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/pixel_interpolator_warp", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id96 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/pixel_interpolator", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id97 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/pwstorage/pwstorage_backend", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id98 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/imageio/storage/export/auto_login", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id99 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/histogram/panel_position", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id100 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/panel_swap", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id101 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ui_last/display_profile_source", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id102 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "run_crawler_on_start", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id18 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/audio_player", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id19 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/lut3d/def_path", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id20 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/segments/def_path", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id103 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/workflow", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id104 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/basecurve/auto_apply_percamera_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id105 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "ui/detect_mono_exif", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id106 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/show_warnings", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id107 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/hide_header_buttons", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id108 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/show_mask_indicator", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id109 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/rename_new_instance", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id110 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/auto_module_name_update", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id21 (GtkWidget *widget, gpointer user_data)
{

    const float factor = 1.0f;
  set_widget_label_default(widget, "plugins/midi/devices", GTK_WIDGET(user_data), factor);
}


static void init_tab_generated(GtkWidget *dialog, GtkWidget *stack)
{
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "import",
                                 _("import"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("session options"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "session/base_directory_pattern",
                                   _("base filmroll's directory"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/base_directory_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id11), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id11), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(PICTURES_FOLDER)/Darktable");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("directory where new imported filmrolls are created"));
    wrapup_pref("session/base_directory_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id11);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "session/sub_directory_pattern",
                                   _("filmroll name"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/sub_directory_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id12), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id12), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("name of the imported filmroll"));
    wrapup_pref("session/sub_directory_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id12);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "session/use_filename",
                                   _("keep original filename"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("session/use_filename"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id73), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id73), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("keep original filename instead of a pattern while importing from camera or card"));
    wrapup_pref("session/use_filename",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "session/filename_pattern",
                                   _("file naming pattern"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/filename_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id13), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id13), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("file naming pattern used for a import session"));
    wrapup_pref("session/filename_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id13);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "lighttable",
                                 _("lighttable"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/hide_default_presets",
                                   _("hide built-in presets for utility modules"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/hide_default_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id72), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id72), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("hide built-in presets of utility modules in presets menu."));
    wrapup_pref("plugins/lighttable/hide_default_presets",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/collect/single-click",
                                   _("use single-click in the collections module"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/collect/single-click"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id74), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id74), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("check this option to use single-click to select items in the collections module. this will allow you to do range selections for date-time and numeric values."));
    wrapup_pref("plugins/lighttable/collect/single-click",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/act_on",
                                   _("prioritize the hovered image over the selected images"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/act_on"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id75), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id75), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this defines how the list of images to act on is constructed."));
    wrapup_pref("plugins/lighttable/act_on",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "lighttable/ui/single_module",
                                   _("expand a single utility module at a time"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/single_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id81), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id81), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this option toggles the behavior of shift clicking in lighttable mode"));
    wrapup_pref("lighttable/ui/single_module",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "lighttable/ui/scroll_to_module",
                                   _("scroll utility modules to the top when expanded"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/scroll_to_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id85), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id85), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when this option is enabled then darktable will try to scroll the module to the top of the visible list"));
    wrapup_pref("lighttable/ui/scroll_to_module",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "rating_one_double_tap",
                                   _("rating an image one star twice will not zero out the rating"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("rating_one_double_tap"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id91), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id91), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines whether rating an image one star twice will zero out star rating"));
    wrapup_pref("rating_one_double_tap",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "lighttable/ui/scrollbars",
                                   _("show scrollbars for central view"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/scrollbars"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id92), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id92), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines whether scrollbars should be displayed"));
    wrapup_pref("lighttable/ui/scrollbars",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "lighttable/ui/milliseconds",
                                   _("show image time with milliseconds"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/milliseconds"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id93), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id93), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines whether time should be displayed with milliseconds"));
    wrapup_pref("lighttable/ui/milliseconds",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("thumbnails"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/thumbnail_raw_min_level",
                                   _("use raw file instead of embedded JPEG from size"));

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/thumbnail_raw_min_level");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id58), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id58), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "never"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if the thumbnail size is greater than this value, it will be processed using raw file instead of the embedded preview JPEG (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"));
    wrapup_pref("plugins/lighttable/thumbnail_raw_min_level",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/thumbnail_hq_min_level",
                                   _("high quality processing from size"));

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/thumbnail_hq_min_level");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id59), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id59), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "720p"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if the thumbnail size is greater than this value, it will be processed using the full quality rendering path (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"));
    wrapup_pref("plugins/lighttable/thumbnail_hq_min_level",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "cache_disk_backend",
                                   _("enable disk backend for thumbnail cache"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("cache_disk_backend"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id60), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id60), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, write thumbnails to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached thumbnails again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when browsing a lot.\nto generate all thumbnails of your entire collection offline, run 'darktable-generate-cache'."));
    wrapup_pref("cache_disk_backend",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "cache_disk_backend_full",
                                   _("enable disk backend for full preview cache"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("cache_disk_backend_full"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id61), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id61), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, write full preview to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached full previews again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when zooming image in full preview mode."));
    wrapup_pref("cache_disk_backend_full",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "thumbtable_fractional_scrolling",
                                   _("enable smooth scrolling for lighttable thumbnails"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("thumbtable_fractional_scrolling"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id62), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id62), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, scrolling the lighttable scrolls by some number of pixels, as expected with a touch pad.\ndisabled, the lighttable scrolls full rows of thumbnails, as befits a scroll wheel."));
    wrapup_pref("thumbtable_fractional_scrolling",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "backthumbs_mipsize",
                                   _("generate thumbnails in background"));

    widget = dt_gui_preferences_enum(NULL, "backthumbs_mipsize");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id63), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id63), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "never"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if 'enable disk backend for thumbnail cache' is enabled thumbnails/mipmaps up to the selected size are generated while user is inactive in lighttable."));
    wrapup_pref("backthumbs_mipsize",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "backthumbs_initialize",
                                   _("reset cached thumbnails"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("backthumbs_initialize"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id64), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id64), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("force thumbnails to be regenerated by resetting the database. this may be needed in case some thumbnails have been manually removed or corrupted."));
    wrapup_pref("backthumbs_initialize",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/thumbnail_sizes",
                                   _("delimiters for size categories"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/thumbnail_sizes");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id7), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id7), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "120|400");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("size categories are used to be able to set different overlays and CSS values depending of the size of the thumbnail, separated by |.\nfor example, 120|400 means 3 categories of thumbnails: <120px, 120-400px, >400px"));
    wrapup_pref("plugins/lighttable/thumbnail_sizes",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id7);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/extended_pattern",
                                   _("pattern for the thumbnail extended overlay text"));

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/extended_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id8), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("see manual to know all the tags you can use."));
    wrapup_pref("plugins/lighttable/extended_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id8);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/thumbnail_tooltip_pattern",
                                   _("pattern for the thumbnail tooltip (empty to disable)"));

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/thumbnail_tooltip_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id9), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("see manual to know all the tags you can use."));
    wrapup_pref("plugins/lighttable/thumbnail_tooltip_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id9);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "darkroom",
                                 _("darkroom"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "masks_scroll_down_increases",
                                   _("scroll down to increase mask parameters"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("masks_scroll_down_increases"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id65), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id65), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when using the mouse scroll wheel to change mask parameters, scroll down to increase the mask size, feather size, opacity, brush hardness and gradient curvature\nby default scrolling up increases these parameters"));
    wrapup_pref("masks_scroll_down_increases",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/mouse/middle_button_cycle_zoom_to_200_percent",
                                   _("middle mouse button zooms to 200%"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/mouse/middle_button_cycle_zoom_to_200_percent"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id66), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id66), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("if enabled, the zoom level will cycle between 100%, 200% and fit to viewport on middle mouse clicks. if disabled, it will toggle between viewport size and 100%, and the 'ctrl' key can be used to control the zoom level."));
    wrapup_pref("darkroom/mouse/middle_button_cycle_zoom_to_200_percent",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/image_infos_pattern",
                                   _("pattern for the image information line"));

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/image_infos_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id10), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("see manual for a list of the tags you can use."));
    wrapup_pref("plugins/darkroom/image_infos_pattern",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id10);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/image_infos_position",
                                   _("position of the image information line"));

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/image_infos_position");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id68), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id68), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "bottom"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    wrapup_pref("plugins/darkroom/image_infos_position",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/ui/border_size",
                                   _("border around image in darkroom mode"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/darkroom/ui/border_size") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id16), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id16), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("process the image in darkroom mode with a small border. set to 0 if you don't want any border."));
    wrapup_pref("plugins/darkroom/ui/border_size",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id16);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/scrollbars",
                                   _("show scrollbars for central view"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/scrollbars"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id88), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id88), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines whether scrollbars should be displayed"));
    wrapup_pref("darkroom/ui/scrollbars",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/loading_screen",
                                   _("show loading screen between images"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/loading_screen"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id94), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id94), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("show gray loading screen when navigating between images in the darkroom\ndisable to just show a toast message"));
    wrapup_pref("darkroom/ui/loading_screen",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("modules"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "channel_display",
                                   _("display of individual color channels"));

    widget = dt_gui_preferences_enum(NULL, "channel_display");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id67), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id67), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "false color"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines how color channels are displayed when activated in the parametric masks feature."));
    wrapup_pref("channel_display",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/hide_default_presets",
                                   _("hide built-in presets for processing modules"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/hide_default_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id70), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id70), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("hide built-in presets of processing modules in presets menu."));
    wrapup_pref("plugins/darkroom/hide_default_presets",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/show_guides_in_ui",
                                   _("show the guides widget in modules UI"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/show_guides_in_ui"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id71), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id71), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("show the guides widget in modules UI"));
    wrapup_pref("plugins/darkroom/show_guides_in_ui",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/single_module",
                                   _("expand a single processing module at a time"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/single_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id82), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id82), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this option toggles the behavior of shift clicking in darkroom mode"));
    wrapup_pref("darkroom/ui/single_module",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/single_module_group_only",
                                   _("only collapse modules in current group"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/single_module_group_only"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id83), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id83), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if only expanding a single module at a time, only collapse other modules in the current group - ignore modules in other groups"));
    wrapup_pref("darkroom/ui/single_module_group_only",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/activate_expand",
                                   _("expand the module when it is activated, and collapse it when disabled"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/activate_expand"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id84), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id84), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this option allows to expand or collapse automatically the module when it is enabled or disabled."));
    wrapup_pref("darkroom/ui/activate_expand",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/scroll_to_module",
                                   _("scroll processing modules to the top when expanded"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/scroll_to_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id86), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id86), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when this option is enabled then darktable will try to scroll the module to the top of the visible list"));
    wrapup_pref("darkroom/ui/scroll_to_module",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/panel_swap",
                                   _("swap the utility and processing modules panels"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/panel_swap"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id100), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id100), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("move the list of processing modules to the left of the screen"));
    wrapup_pref("plugins/darkroom/panel_swap",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/hide_header_buttons",
                                   _("show right-side buttons in processing module headers"));

    widget = dt_gui_preferences_enum(NULL, "darkroom/ui/hide_header_buttons");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id107), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id107), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "always"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when the mouse is not over a module, the multi-instance, reset and preset buttons can be hidden:\n - 'always': always show all buttons,\n - 'active': only show the buttons when the mouse is over the module,\n - 'dim': buttons are dimmed when mouse is away,\n - 'auto': hide the buttons when the panel is narrow,\n - 'fade': fade out all buttons when panel narrows,\n - 'fit': hide all the buttons if the module name doesn't fit,\n - 'smooth': fade out all buttons in one header simultaneously,\n - 'glide': gradually hide individual buttons as needed"));
    wrapup_pref("darkroom/ui/hide_header_buttons",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/show_mask_indicator",
                                   _("show mask indicator in module headers"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/show_mask_indicator"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id108), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id108), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, an icon will be shown in the header of any processing modules that have a mask applied"));
    wrapup_pref("darkroom/ui/show_mask_indicator",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/rename_new_instance",
                                   _("prompt for name on addition of new instance"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/rename_new_instance"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id109), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id109), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, a rename prompt will be present for each new module instance (either new instance or duplicate)"));
    wrapup_pref("darkroom/ui/rename_new_instance",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/auto_module_name_update",
                                   _("automatically update module name"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/auto_module_name_update"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id110), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id110), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled, the module name will be automatically updated to match a preset name or a preset instance name if present."));
    wrapup_pref("darkroom/ui/auto_module_name_update",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "processing",
                                 _("processing"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("image processing"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/export/force_lcms2",
                                   _("always use LittleCMS 2 to apply output color profile"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/export/force_lcms2"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id90), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id90), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this is slower than the default."));
    wrapup_pref("plugins/lighttable/export/force_lcms2",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/export/pixel_interpolator_warp",
                                   _("pixel interpolator (warp)"));

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/export/pixel_interpolator_warp");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id95), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id95), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "bicubic"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("pixel interpolator used in modules for rotation, lens correction, liquify, cropping and final scaling (bilinear, bicubic, lanczos2)."));
    wrapup_pref("plugins/lighttable/export/pixel_interpolator_warp",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/export/pixel_interpolator",
                                   _("pixel interpolator (scaling)"));

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/export/pixel_interpolator");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id96), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id96), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "lanczos3"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("pixel interpolator used for scaling (bilinear, bicubic, lanczos2, lanczos3)."));
    wrapup_pref("plugins/lighttable/export/pixel_interpolator",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/lut3d/def_path",
                                   _("LUT 3D root folder"));

    widget = gtk_file_chooser_button_new(_("select directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
    gtk_file_chooser_button_set_width_chars(GTK_FILE_CHOOSER_BUTTON(widget), 20);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/lut3d/def_path");
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(widget), setting);
    g_free(setting);
    g_signal_connect(G_OBJECT(widget), "selection-changed", G_CALLBACK(preferences_changed_callback_id19), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id19), widget);
    gchar *default_path = dt_conf_expand_default_dir("$(home)");
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), default_path);
    g_free(default_path);
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this folder (and sub-folders) contains LUT files used by LUT 3D module. (restart required)"));
    wrapup_pref("plugins/darkroom/lut3d/def_path",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id19);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/segments/def_path",
                                   _("raster mask files root folder"));

    widget = gtk_file_chooser_button_new(_("select directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
    gtk_file_chooser_button_set_width_chars(GTK_FILE_CHOOSER_BUTTON(widget), 20);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/segments/def_path");
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(widget), setting);
    g_free(setting);
    g_signal_connect(G_OBJECT(widget), "selection-changed", G_CALLBACK(preferences_changed_callback_id20), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id20), widget);
    gchar *default_path = dt_conf_expand_default_dir("$(home)");
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), default_path);
    g_free(default_path);
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this folder (and sub-folders) contains PFM files used by the raster mask import module. (restart required)"));
    wrapup_pref("plugins/darkroom/segments/def_path",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id20);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/workflow",
                                   _("auto-apply pixel workflow defaults"));

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/workflow");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id103), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id103), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "scene-referred (sigmoid)"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("scene-referred workflow is based on linear modules and will auto-apply filmic or sigmoid, color calibration and exposure,\ndisplay-referred workflow is based on Lab modules and will auto-apply base curve, white balance and the legacy module pipe order."));
    wrapup_pref("plugins/darkroom/workflow",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/basecurve/auto_apply_percamera_presets",
                                   _("auto-apply per camera basecurve presets"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/basecurve/auto_apply_percamera_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id104), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id104), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("use the per-camera basecurve by default instead of the generic manufacturer one if there is one available. (restart required)\nthis option is taken into account when the \"auto-apply pixel workflow defaults\" is set to \"display-referred\".\nto prevent auto-apply basecurve presets \"auto-apply pixel workflow defaults\" should be set to \"none\""));
    wrapup_pref("plugins/darkroom/basecurve/auto_apply_percamera_presets",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ui/detect_mono_exif",
                                   _("detect monochrome previews"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ui/detect_mono_exif"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id105), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id105), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("many monochrome images can be identified via EXIF and preview data. beware: this slows down imports and reading of EXIF data"));
    wrapup_pref("ui/detect_mono_exif",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/show_warnings",
                                   _("show warning messages"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/show_warnings"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id106), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id106), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("display messages in modules to warn beginner users when non-standard and possibly harmful settings are used in the pipeline.\nthese messages can be false-positive and should be disregarded if you know what you are doing. this option will hide them all the time."));
    wrapup_pref("plugins/darkroom/show_warnings",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("CPU / memory"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "resourcelevel",
                                   _("darktable resources"));

    widget = dt_gui_preferences_enum(NULL, "resourcelevel");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id34), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id34), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "default"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("defines how much darktable may take from your system resources:\n - 'default': darktable takes ~50% of your systems resources, which is enough to be performant.\n - 'small': should be used if you are simultaneously running applications taking large parts of your systems memory or OpenCL/GL applications like games or Hugin.\n - 'large': is the best option if you are not running other applications at the same time as darktable and want it to take most of your systems resources for performance."));
    wrapup_pref("resourcelevel",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("OpenCL GPU acceleration"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "opencl",
                                   _("activate OpenCL support"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("opencl"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id40), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id40), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if found, use OpenCL runtime on your system to speed up processing by using your graphics card(s).\ncan be switched on and off at any time."));
    if(!dt_capabilities_check("opencl"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("opencl",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "opencl_scheduling_profile",
                                   _("OpenCL scheduling profile"));

    widget = dt_gui_preferences_enum(NULL, "opencl_scheduling_profile");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id41), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id41), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "default"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines how preview and full pixelpipe tasks are scheduled on OpenCL enabled systems:\n - 'default': GPU processes full and CPU processes preview pipe (adaptable by config parameters),\n - 'multiple GPUs': process both pixelpipes in parallel on two different GPUs,\n - 'very fast GPU': process both pixelpipes sequentially on the GPU."));
    if(!dt_capabilities_check("opencl"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("opencl_scheduling_profile",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "opencl_tune_headroom",
                                   _("tuned GPU memory"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("opencl_tune_headroom"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id42), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id42), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if enabled on a system with multiple OpenCL devices you may specify a safety margin per device (headroom, default is 600MB)"));
    if(!dt_capabilities_check("multiopencl"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("opencl_tune_headroom",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("OpenCL drivers"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_intelropenclhdgraphics",
                                   _("Intel GPU"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_intelropenclhdgraphics"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id43), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id43), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("Intel(R) OpenCL Graphics for all supported platforms (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_intelropenclhdgraphics",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_nvidiacuda",
                                   _("Nvidia CUDA"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_nvidiacuda"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id44), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id44), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("Nvidia CUDA based OpenCL (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_nvidiacuda",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_amdacceleratedparallelprocessing",
                                   _("AMD ROCm"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_amdacceleratedparallelprocessing"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id45), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id45), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("AMD Accelerated Parallel Processing (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_amdacceleratedparallelprocessing",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_rusticl",
                                   _("RustiCL"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_rusticl"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id46), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id46), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("RustiCL Mesa OpenCL. if you want to use this, you should disable the vendor driver"));
    if(!dt_capabilities_check("nonapple"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_rusticl",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_apple",
                                   _("Apple"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_apple"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id47), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id47), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("Apple OpenCL (vendor provided)"));
    if(!dt_capabilities_check("apple"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_apple",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_openclon12",
                                   _("Microsoft OpenCLOn12"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_openclon12"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id48), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id48), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("Microsoft OpenCLOn12, only use this if the vendor provided driver does not work or there is none provided."));
    if(!dt_capabilities_check("windows"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("clplatform_openclon12",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "clplatform_other",
                                   _("other platforms"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_other"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id49), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id49), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if set, all unspecified platforms are accepted. only do this if no vendor driver is available"));
    wrapup_pref("clplatform_other",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "security",
                                 _("security"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_remove",
                                   _("ask before removing images from the library"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_remove"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id50), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id50), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before removing image information from the library"));
    wrapup_pref("ask_before_remove",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_delete",
                                   _("ask before deleting images from disk"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_delete"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id51), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id51), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is deleted"));
    wrapup_pref("ask_before_delete",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_discard",
                                   _("ask before discarding history stack"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_discard"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id52), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id52), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before history stack is discarded on any image"));
    wrapup_pref("ask_before_discard",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "send_to_trash",
                                   _("try to use trash when deleting images"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("send_to_trash"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id53), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id53), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("send files to trash instead of permanently deleting files on system that supports it"));
    wrapup_pref("send_to_trash",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_move",
                                   _("ask before moving images from film roll folder"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_move"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id54), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id54), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is moved."));
    wrapup_pref("ask_before_move",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_copy",
                                   _("ask before copying images to new film roll folder"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_copy"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id55), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id55), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is copied."));
    wrapup_pref("ask_before_copy",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ask_before_rmdir",
                                   _("ask before removing empty folders"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_rmdir"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id56), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id56), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before removing any empty folder. this can happen after moving or deleting images."));
    wrapup_pref("ask_before_rmdir",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/tagging/ask_before_delete_tag",
                                   _("ask before deleting a tag"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/tagging/ask_before_delete_tag"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id76), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id76), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    wrapup_pref("plugins/lighttable/tagging/ask_before_delete_tag",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/style/ask_before_delete_style",
                                   _("ask before deleting a style"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/style/ask_before_delete_style"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id77), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id77), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    wrapup_pref("plugins/lighttable/style/ask_before_delete_style",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/preset/ask_before_delete_preset",
                                   _("ask before deleting a preset"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/preset/ask_before_delete_preset"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id78), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id78), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("will ask for confirmation before deleting or overwriting a preset"));
    wrapup_pref("plugins/lighttable/preset/ask_before_delete_preset",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/export/ask_before_export_overwrite",
                                   _("ask before exporting in overwrite mode"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/export/ask_before_export_overwrite"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id79), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id79), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("will ask for confirmation before exporting files in overwrite mode"));
    wrapup_pref("plugins/lighttable/export/ask_before_export_overwrite",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("other"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/pwstorage/pwstorage_backend",
                                   _("password storage backend to use"));

    widget = dt_gui_preferences_enum(NULL, "plugins/pwstorage/pwstorage_backend");
    if(!dt_capabilities_check("windows_credentials"))
      dt_bauhaus_combobox_remove_at(widget, 5);
    if(!dt_capabilities_check("apple_keychain"))
      dt_bauhaus_combobox_remove_at(widget, 4);
    if(!dt_capabilities_check("kwallet"))
      dt_bauhaus_combobox_remove_at(widget, 3);
    if(!dt_capabilities_check("libsecret"))
      dt_bauhaus_combobox_remove_at(widget, 2);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id97), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id97), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "auto"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("the storage backend for password storage: auto, none, libsecret, kwallet, apple_keychain, windows_credentials"));
    wrapup_pref("plugins/pwstorage/pwstorage_backend",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/imageio/storage/export/auto_login",
                                   _("auto login to storage server"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/imageio/storage/export/auto_login"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id98), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id98), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("automatically login to the configured storage server. this requires that a password storage backend is set."));
    wrapup_pref("plugins/imageio/storage/export/auto_login",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/audio_player",
                                   _("executable for playing audio files"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/audio_player");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id18), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id18), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "aplay");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("this external program is used to play audio files some cameras record to keep notes for images"));
    wrapup_pref("plugins/lighttable/audio_player",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id18);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "storage",
                                 _("storage"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("database"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "database/multiple_workspace",
                                   _("allow for multiple workspaces"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("database/multiple_workspace"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id32), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id32), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("allow multiple workspaces which can be selected at startup"));
    wrapup_pref("database/multiple_workspace",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "database/create_snapshot",
                                   _("create database snapshot"));

    widget = dt_gui_preferences_enum(NULL, "database/create_snapshot");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id33), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id33), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "once a week"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("database snapshots are created right before closing darktable. options allow you to choose how often to make snapshots:\n - 'never': simply don't do snapshots. that way the only snapshots done are mandatory version-upgrade snapshots\n - 'once a month': create snapshot if a month has passed since last snapshot\n - 'once a week': create snapshot if 7 days had passed since last snapshot\n - 'once a day': create snapshot if over 24h passed since last snapshot\n - 'on close': create snapshot every time darktable is closed"));
    wrapup_pref("database/create_snapshot",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "database/keep_snapshots",
                                   _("how many snapshots to keep"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("database/keep_snapshots") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id1), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id1), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("after successfully creating snapshot, how many older snapshots to keep (excluding mandatory version update ones). enter -1 to keep all snapshots\nkeep in mind that snapshots do take some space and you only need the most recent one for successful restore"));
    wrapup_pref("database/keep_snapshots",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id1);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("XMP sidecar files"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "write_sidecar_files",
                                   _("create XMP files"));

    widget = dt_gui_preferences_enum(NULL, "write_sidecar_files");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id35), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id35), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "on import"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("XMP sidecar files hold information about all your development steps to allow flawless re-importing of image files.\n\ndepending on the selected mode sidecar files will be created:\n - 'never': all development information will be stored only in the library database\n - 'on import': immediately after importing the image\n - 'after edit': after any user change on the image or adding tags."));
    wrapup_pref("write_sidecar_files",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "compress_xmp_tags",
                                   _("store XMP tags in compressed format"));

    widget = dt_gui_preferences_enum(NULL, "compress_xmp_tags");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id36), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id36), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "only large entries"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("entries in XMP tags can get rather large and may exceed the available space to store the history stack in output files.\nthis option allows XMP tags to be compressed and save space."));
    wrapup_pref("compress_xmp_tags",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "autosave_interval",
                                   _("auto-save interval"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("autosave_interval") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id3), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id3), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("automatically save history while developing using the given interval (in seconds); set to zero to disable auto-saving. auto-saving might be disabled on slow drives."));
    wrapup_pref("autosave_interval",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id3);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "run_crawler_on_start",
                                   _("look for updated XMP files on startup"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("run_crawler_on_start"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id102), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id102), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("check file modification times of all XMP files on startup to check if any got updated in the meantime"));
    wrapup_pref("run_crawler_on_start",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  }
  {
    GtkWidget *widget, *label, *viewport, *labelev;
    GtkWidget *grid = create_tab(stack,
                                 "miscellaneous",
                                 _("miscellaneous"));
    int line = 0;
    char tooltip[1024];
  
    {
      GtkWidget *seclabel = gtk_label_new(_("interface"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "show_splash_screen",
                                   _("show splash screen at startup"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("show_splash_screen"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id28), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id28), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("display a small window showing the progress of darktable startup before the main window appears"));
    wrapup_pref("show_splash_screen",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/load_defaults",
                                   _("load default shortcuts at startup"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/load_defaults"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id29), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id29), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("load default shortcuts before user settings. switch off to prevent deleted defaults returning"));
    wrapup_pref("accel/load_defaults",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "bauhaus/zoom_step",
                                   _("scale slider step with min/max"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("bauhaus/zoom_step"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id30), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id30), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("vary slider step size with min/max range"));
    wrapup_pref("bauhaus/zoom_step",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "bauhaus/marker_shape",
                                   _("marker shape"));

    widget = dt_gui_preferences_enum(NULL, "bauhaus/marker_shape");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id31), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id31), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "triangle"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("the shape of the slider marker"));
    wrapup_pref("bauhaus/marker_shape",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "modules/default_presets_first",
                                   _("sort built-in presets first"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("modules/default_presets_first"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id69), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id69), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("whether to show built-in presets first before user's presets in presets menu."));
    wrapup_pref("modules/default_presets_first",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/sidebar_scroll_default",
                                   _("mouse wheel scrolls modules side panel by default"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/sidebar_scroll_default"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id87), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id87), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when enabled, use mouse wheel to scroll modules side panel.  use ctrl+alt to use mouse wheel for data entry.  when disabled, this behavior is reversed"));
    wrapup_pref("darkroom/ui/sidebar_scroll_default",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "panel_scrollbars_always_visible",
                                   _("always show panels' scrollbars"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("panel_scrollbars_always_visible"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id89), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id89), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("defines whether the panel scrollbars should be always visible or activated only depending on the content. (restart required)"));
    wrapup_pref("panel_scrollbars_always_visible",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "darkroom/ui/transition_duration",
                                   _("duration of the UI transitions in ms"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    max = 1000;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("darkroom/ui/transition_duration") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id17), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id17), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(250 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("how long the transitions take (in ms) for expanding or collapsing modules and other UI elements"));
    wrapup_pref("darkroom/ui/transition_duration",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id17);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/darkroom/histogram/panel_position",
                                   _("position of the scopes module"));

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/histogram/panel_position");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id99), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id99), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "right"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("position the scopes at the top-left or top-right of the screen"));
    wrapup_pref("plugins/darkroom/histogram/panel_position",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "ui_last/display_profile_source",
                                   _("method to use for getting the display profile"));

    widget = dt_gui_preferences_enum(NULL, "ui_last/display_profile_source");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id101), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id101), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "all"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("this option allows to force a specific means of getting the current display profile.\nthis is useful when one alternative gives wrong results"));
    wrapup_pref("ui_last/display_profile_source",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/midi/devices",
                                   _("order or exclude MIDI devices"));

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/midi/devices");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id21), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id21), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_widget_set_tooltip_text(widget, _("comma-separated list of device name fragments that if matched load MIDI device at id given by location in list\nor if preceded by '-' prevent matching devices from loading. add encoding and number of knobs like 'BeatStep:63:16'"));
    if(!dt_capabilities_check("midi"))
    {
      setup_not_available(&widget, labelev);
    }
    wrapup_pref("plugins/midi/devices",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id21);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("tags"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "omit_tag_hierarchy",
                                   _("omit hierarchy in simple tag lists"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("omit_tag_hierarchy"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id37), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id37), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when creating an XMP sidecar file the hierarchical tags are also added as a simple list\nof non-hierarchical ones to make them visible to some other programs.\nwhen this option is checked darktable will only include their last part\nand ignore the rest. so 'foo|bar|baz' will only add 'baz'."));
    wrapup_pref("omit_tag_hierarchy",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("shortcuts with multiple instances"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/prefer_focused",
                                   _("prefer focused instance"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_focused"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id22), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id22), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("where multiple instances of a module are present, apply shortcuts to the instance that has focus\nif none are focused, the preferences below control rules that are followed (in order) to decide which module instance shortcuts will be applied to.\nnote: blending shortcuts always apply to the focused instance"));
    wrapup_pref("accel/prefer_focused",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/prefer_expanded",
                                   _("prefer expanded instances"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_expanded"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id23), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id23), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("if instances of the module are expanded, ignore collapsed instances"));
    wrapup_pref("accel/prefer_expanded",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/prefer_enabled",
                                   _("prefer enabled instances"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_enabled"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id24), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id24), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rule, if instances of the module are active, ignore inactive instances"));
    wrapup_pref("accel/prefer_enabled",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/prefer_unmasked",
                                   _("prefer unmasked instances"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_unmasked"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id25), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id25), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rules, if instances of the module are unmasked, ignore masked instances"));
    wrapup_pref("accel/prefer_unmasked",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/select_order",
                                   _("selection order"));

    widget = dt_gui_preferences_enum(NULL, "accel/select_order");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id26), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id26), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "last instance"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rules, apply the shortcut based on its position in the pixelpipe"));
    wrapup_pref("accel/select_order",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "accel/assign_instance",
                                   _("allow visual assignment to specific instances"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/assign_instance"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id27), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id27), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("when multiple instances are present on an image this allows shortcuts to be visually assigned to those specific instances\notherwise shortcuts will always be assigned to the preferred instance"));
    wrapup_pref("accel/assign_instance",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("map / geolocalization view"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/metadata_view/pretty_location",
                                   _("pretty print the image location"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/metadata_view/pretty_location"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id80), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id80), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("show a more readable representation of the location in the image information module"));
    wrapup_pref("plugins/lighttable/metadata_view/pretty_location",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_true);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("slideshow view"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "slideshow_delay",
                                   _("waiting time between each image in slideshow"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("slideshow_delay") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id2), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id2), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(5 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    wrapup_pref("slideshow_delay",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id2);
  }
  }

  g_object_unref(widget_group);
}
GtkWidget *dt_prefs_init_dialog_collect(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/tagging/no_uncategorized",
                                   _("do not set the 'uncategorized' entry for tags"));

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/tagging/no_uncategorized"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id38), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id38), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("do not set the 'uncategorized' entry for tags which do not have children"));
    wrapup_pref("plugins/lighttable/tagging/no_uncategorized",
                grid, labelev, labdef, label, widget, &line,
                click_widget_toggle_false);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/tagging/case_sensitivity",
                                   _("tags case sensitivity"));

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/tagging/case_sensitivity");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id39), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id39), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "insensitive"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("tags case sensitivity. without the Sqlite ICU extension, insensitivity works only for the 26 latin letters"));
    wrapup_pref("plugins/lighttable/tagging/case_sensitivity",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/collect/history_max",
                                   _("number of collections to be stored"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 50;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/collect/history_max") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id5), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id5), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("the number of recent collections to store and show in this list"));
    wrapup_pref("plugins/lighttable/collect/history_max",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id5);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "show_folder_levels",
                                   _("number of folder levels to show in lists"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 5;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("show_folder_levels") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id6), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id6), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(1 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("the number of folder levels to show in film roll names, starting from the right"));
    wrapup_pref("show_folder_levels",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id6);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/collect/filmroll_sort",
                                   _("sort film rolls by"));

    widget = dt_gui_preferences_enum(NULL, "plugins/collect/filmroll_sort");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id57), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id57), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "import time"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("sets the collections-list order for film rolls"));
    wrapup_pref("plugins/collect/filmroll_sort",
                grid, labelev, labdef, label, widget, &line,
                click_widget_enum);
  }
  g_object_unref(widget_group);
  dt_gui_dialog_add(GTK_DIALOG(dialog), grid);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_recentcollect(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/recentcollect/max_items",
                                   _("number of collections to be stored"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 50;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/recentcollect/max_items") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id4), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id4), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("the number of recent collections to store and show in this list"));
    wrapup_pref("plugins/lighttable/recentcollect/max_items",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id4);
  }
  g_object_unref(widget_group);
  dt_gui_dialog_add(GTK_DIALOG(dialog), grid);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_import(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  g_object_unref(widget_group);
  dt_gui_dialog_add(GTK_DIALOG(dialog), grid);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_tagging(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/tagging/confidence",
                                   _("suggested tags level of confidence"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    max = 100;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/tagging/confidence") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id14), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id14), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(50 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("level of confidence to include the tag in the suggestions list, 0: all associated tags, 99: 99% matching associated tags, 100: no matching tag to show only recent tags (faster)"));
    wrapup_pref("plugins/lighttable/tagging/confidence",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id14);
  }
  {
    GtkWidget *labdef = setup_pref(&label,
                                   &labelev,
                                   "plugins/lighttable/tagging/nb_recent_tags",
                                   _("number of recently attached tags"));

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = -1;
    max = 1000;
    const float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/tagging/nb_recent_tags") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id15), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id15), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(20 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_widget_set_tooltip_text(widget, _("number of recently attached tags which are included in the suggestions list. the value `-1' disables the recent list"));
    wrapup_pref("plugins/lighttable/tagging/nb_recent_tags",
                grid, labelev, labdef, label, widget, &line,
                click_widget_id15);
  }
  g_object_unref(widget_group);
  dt_gui_dialog_add(GTK_DIALOG(dialog), grid);
  return grid;
}

#endif
