// Copyright 2021 Woodpecker Authors
// Copyright 2011 Drone.IO Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.32.1
// source: woodpecker.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StepState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StepUuid      string                 `protobuf:"bytes,1,opt,name=step_uuid,json=stepUuid,proto3" json:"step_uuid,omitempty"`
	Started       int64                  `protobuf:"varint,2,opt,name=started,proto3" json:"started,omitempty"`
	Finished      int64                  `protobuf:"varint,3,opt,name=finished,proto3" json:"finished,omitempty"`
	Exited        bool                   `protobuf:"varint,4,opt,name=exited,proto3" json:"exited,omitempty"`
	ExitCode      int32                  `protobuf:"varint,5,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	Error         string                 `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StepState) Reset() {
	*x = StepState{}
	mi := &file_woodpecker_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StepState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StepState) ProtoMessage() {}

func (x *StepState) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StepState.ProtoReflect.Descriptor instead.
func (*StepState) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{0}
}

func (x *StepState) GetStepUuid() string {
	if x != nil {
		return x.StepUuid
	}
	return ""
}

func (x *StepState) GetStarted() int64 {
	if x != nil {
		return x.Started
	}
	return 0
}

func (x *StepState) GetFinished() int64 {
	if x != nil {
		return x.Finished
	}
	return 0
}

func (x *StepState) GetExited() bool {
	if x != nil {
		return x.Exited
	}
	return false
}

func (x *StepState) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *StepState) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type WorkflowState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Started       int64                  `protobuf:"varint,4,opt,name=started,proto3" json:"started,omitempty"`
	Finished      int64                  `protobuf:"varint,5,opt,name=finished,proto3" json:"finished,omitempty"`
	Error         string                 `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkflowState) Reset() {
	*x = WorkflowState{}
	mi := &file_woodpecker_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkflowState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowState) ProtoMessage() {}

func (x *WorkflowState) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowState.ProtoReflect.Descriptor instead.
func (*WorkflowState) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{1}
}

func (x *WorkflowState) GetStarted() int64 {
	if x != nil {
		return x.Started
	}
	return 0
}

func (x *WorkflowState) GetFinished() int64 {
	if x != nil {
		return x.Finished
	}
	return 0
}

func (x *WorkflowState) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type LogEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StepUuid      string                 `protobuf:"bytes,1,opt,name=step_uuid,json=stepUuid,proto3" json:"step_uuid,omitempty"`
	Time          int64                  `protobuf:"varint,2,opt,name=time,proto3" json:"time,omitempty"`
	Line          int32                  `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	Type          int32                  `protobuf:"varint,4,opt,name=type,proto3" json:"type,omitempty"` // 0 = stdout, 1 = stderr, 2 = exit-code, 3 = metadata, 4 = progress
	Data          []byte                 `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry) Reset() {
	*x = LogEntry{}
	mi := &file_woodpecker_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry) ProtoMessage() {}

func (x *LogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry.ProtoReflect.Descriptor instead.
func (*LogEntry) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{2}
}

func (x *LogEntry) GetStepUuid() string {
	if x != nil {
		return x.StepUuid
	}
	return ""
}

func (x *LogEntry) GetTime() int64 {
	if x != nil {
		return x.Time
	}
	return 0
}

func (x *LogEntry) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *LogEntry) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *LogEntry) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type Filter struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Labels        map[string]string      `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Filter) Reset() {
	*x = Filter{}
	mi := &file_woodpecker_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{3}
}

func (x *Filter) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type Workflow struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Timeout       int64                  `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	Payload       []byte                 `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Workflow) Reset() {
	*x = Workflow{}
	mi := &file_woodpecker_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workflow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workflow) ProtoMessage() {}

func (x *Workflow) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workflow.ProtoReflect.Descriptor instead.
func (*Workflow) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{4}
}

func (x *Workflow) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Workflow) GetTimeout() int64 {
	if x != nil {
		return x.Timeout
	}
	return 0
}

func (x *Workflow) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

type NextRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Filter        *Filter                `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NextRequest) Reset() {
	*x = NextRequest{}
	mi := &file_woodpecker_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextRequest) ProtoMessage() {}

func (x *NextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextRequest.ProtoReflect.Descriptor instead.
func (*NextRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{5}
}

func (x *NextRequest) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

type InitRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	State         *WorkflowState         `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InitRequest) Reset() {
	*x = InitRequest{}
	mi := &file_woodpecker_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitRequest) ProtoMessage() {}

func (x *InitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitRequest.ProtoReflect.Descriptor instead.
func (*InitRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{6}
}

func (x *InitRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *InitRequest) GetState() *WorkflowState {
	if x != nil {
		return x.State
	}
	return nil
}

type WaitRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WaitRequest) Reset() {
	*x = WaitRequest{}
	mi := &file_woodpecker_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WaitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WaitRequest) ProtoMessage() {}

func (x *WaitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WaitRequest.ProtoReflect.Descriptor instead.
func (*WaitRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{7}
}

func (x *WaitRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type DoneRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	State         *WorkflowState         `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DoneRequest) Reset() {
	*x = DoneRequest{}
	mi := &file_woodpecker_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DoneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoneRequest) ProtoMessage() {}

func (x *DoneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoneRequest.ProtoReflect.Descriptor instead.
func (*DoneRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{8}
}

func (x *DoneRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DoneRequest) GetState() *WorkflowState {
	if x != nil {
		return x.State
	}
	return nil
}

type ExtendRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExtendRequest) Reset() {
	*x = ExtendRequest{}
	mi := &file_woodpecker_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtendRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtendRequest) ProtoMessage() {}

func (x *ExtendRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtendRequest.ProtoReflect.Descriptor instead.
func (*ExtendRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{9}
}

func (x *ExtendRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type UpdateRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	State         *StepState             `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateRequest) Reset() {
	*x = UpdateRequest{}
	mi := &file_woodpecker_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRequest) ProtoMessage() {}

func (x *UpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRequest.ProtoReflect.Descriptor instead.
func (*UpdateRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UpdateRequest) GetState() *StepState {
	if x != nil {
		return x.State
	}
	return nil
}

type LogRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	LogEntries    []*LogEntry            `protobuf:"bytes,1,rep,name=logEntries,proto3" json:"logEntries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogRequest) Reset() {
	*x = LogRequest{}
	mi := &file_woodpecker_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogRequest) ProtoMessage() {}

func (x *LogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogRequest.ProtoReflect.Descriptor instead.
func (*LogRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{11}
}

func (x *LogRequest) GetLogEntries() []*LogEntry {
	if x != nil {
		return x.LogEntries
	}
	return nil
}

type Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Empty) Reset() {
	*x = Empty{}
	mi := &file_woodpecker_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{12}
}

type ReportHealthRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        string                 `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReportHealthRequest) Reset() {
	*x = ReportHealthRequest{}
	mi := &file_woodpecker_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportHealthRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportHealthRequest) ProtoMessage() {}

func (x *ReportHealthRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportHealthRequest.ProtoReflect.Descriptor instead.
func (*ReportHealthRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{13}
}

func (x *ReportHealthRequest) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

type AgentInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Platform      string                 `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	Capacity      int32                  `protobuf:"varint,2,opt,name=capacity,proto3" json:"capacity,omitempty"`
	Backend       string                 `protobuf:"bytes,3,opt,name=backend,proto3" json:"backend,omitempty"`
	Version       string                 `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	CustomLabels  map[string]string      `protobuf:"bytes,5,rep,name=customLabels,proto3" json:"customLabels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AgentInfo) Reset() {
	*x = AgentInfo{}
	mi := &file_woodpecker_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentInfo) ProtoMessage() {}

func (x *AgentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentInfo.ProtoReflect.Descriptor instead.
func (*AgentInfo) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{14}
}

func (x *AgentInfo) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *AgentInfo) GetCapacity() int32 {
	if x != nil {
		return x.Capacity
	}
	return 0
}

func (x *AgentInfo) GetBackend() string {
	if x != nil {
		return x.Backend
	}
	return ""
}

func (x *AgentInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AgentInfo) GetCustomLabels() map[string]string {
	if x != nil {
		return x.CustomLabels
	}
	return nil
}

type RegisterAgentRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Info          *AgentInfo             `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterAgentRequest) Reset() {
	*x = RegisterAgentRequest{}
	mi := &file_woodpecker_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterAgentRequest) ProtoMessage() {}

func (x *RegisterAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterAgentRequest.ProtoReflect.Descriptor instead.
func (*RegisterAgentRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{15}
}

func (x *RegisterAgentRequest) GetInfo() *AgentInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

type VersionResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GrpcVersion   int32                  `protobuf:"varint,1,opt,name=grpc_version,json=grpcVersion,proto3" json:"grpc_version,omitempty"`
	ServerVersion string                 `protobuf:"bytes,2,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VersionResponse) Reset() {
	*x = VersionResponse{}
	mi := &file_woodpecker_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponse) ProtoMessage() {}

func (x *VersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponse.ProtoReflect.Descriptor instead.
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{16}
}

func (x *VersionResponse) GetGrpcVersion() int32 {
	if x != nil {
		return x.GrpcVersion
	}
	return 0
}

func (x *VersionResponse) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

type NextResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Workflow      *Workflow              `protobuf:"bytes,1,opt,name=workflow,proto3" json:"workflow,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NextResponse) Reset() {
	*x = NextResponse{}
	mi := &file_woodpecker_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextResponse) ProtoMessage() {}

func (x *NextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextResponse.ProtoReflect.Descriptor instead.
func (*NextResponse) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{17}
}

func (x *NextResponse) GetWorkflow() *Workflow {
	if x != nil {
		return x.Workflow
	}
	return nil
}

type RegisterAgentResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	AgentId       int64                  `protobuf:"varint,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterAgentResponse) Reset() {
	*x = RegisterAgentResponse{}
	mi := &file_woodpecker_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterAgentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterAgentResponse) ProtoMessage() {}

func (x *RegisterAgentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterAgentResponse.ProtoReflect.Descriptor instead.
func (*RegisterAgentResponse) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{18}
}

func (x *RegisterAgentResponse) GetAgentId() int64 {
	if x != nil {
		return x.AgentId
	}
	return 0
}

type AuthRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	AgentToken    string                 `protobuf:"bytes,1,opt,name=agent_token,json=agentToken,proto3" json:"agent_token,omitempty"`
	AgentId       int64                  `protobuf:"varint,2,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthRequest) Reset() {
	*x = AuthRequest{}
	mi := &file_woodpecker_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthRequest) ProtoMessage() {}

func (x *AuthRequest) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthRequest.ProtoReflect.Descriptor instead.
func (*AuthRequest) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{19}
}

func (x *AuthRequest) GetAgentToken() string {
	if x != nil {
		return x.AgentToken
	}
	return ""
}

func (x *AuthRequest) GetAgentId() int64 {
	if x != nil {
		return x.AgentId
	}
	return 0
}

type AuthResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Status        string                 `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	AgentId       int64                  `protobuf:"varint,2,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	AccessToken   string                 `protobuf:"bytes,3,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AuthResponse) Reset() {
	*x = AuthResponse{}
	mi := &file_woodpecker_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthResponse) ProtoMessage() {}

func (x *AuthResponse) ProtoReflect() protoreflect.Message {
	mi := &file_woodpecker_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthResponse.ProtoReflect.Descriptor instead.
func (*AuthResponse) Descriptor() ([]byte, []int) {
	return file_woodpecker_proto_rawDescGZIP(), []int{20}
}

func (x *AuthResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *AuthResponse) GetAgentId() int64 {
	if x != nil {
		return x.AgentId
	}
	return 0
}

func (x *AuthResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

var File_woodpecker_proto protoreflect.FileDescriptor

const file_woodpecker_proto_rawDesc = "" +
	"\n" +
	"\x10woodpecker.proto\x12\x05proto\"\xa9\x01\n" +
	"\tStepState\x12\x1b\n" +
	"\tstep_uuid\x18\x01 \x01(\tR\bstepUuid\x12\x18\n" +
	"\astarted\x18\x02 \x01(\x03R\astarted\x12\x1a\n" +
	"\bfinished\x18\x03 \x01(\x03R\bfinished\x12\x16\n" +
	"\x06exited\x18\x04 \x01(\bR\x06exited\x12\x1b\n" +
	"\texit_code\x18\x05 \x01(\x05R\bexitCode\x12\x14\n" +
	"\x05error\x18\x06 \x01(\tR\x05error\"[\n" +
	"\rWorkflowState\x12\x18\n" +
	"\astarted\x18\x04 \x01(\x03R\astarted\x12\x1a\n" +
	"\bfinished\x18\x05 \x01(\x03R\bfinished\x12\x14\n" +
	"\x05error\x18\x06 \x01(\tR\x05error\"w\n" +
	"\bLogEntry\x12\x1b\n" +
	"\tstep_uuid\x18\x01 \x01(\tR\bstepUuid\x12\x12\n" +
	"\x04time\x18\x02 \x01(\x03R\x04time\x12\x12\n" +
	"\x04line\x18\x03 \x01(\x05R\x04line\x12\x12\n" +
	"\x04type\x18\x04 \x01(\x05R\x04type\x12\x12\n" +
	"\x04data\x18\x05 \x01(\fR\x04data\"v\n" +
	"\x06Filter\x121\n" +
	"\x06labels\x18\x01 \x03(\v2\x19.proto.Filter.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"N\n" +
	"\bWorkflow\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x18\n" +
	"\atimeout\x18\x02 \x01(\x03R\atimeout\x12\x18\n" +
	"\apayload\x18\x03 \x01(\fR\apayload\"4\n" +
	"\vNextRequest\x12%\n" +
	"\x06filter\x18\x01 \x01(\v2\r.proto.FilterR\x06filter\"I\n" +
	"\vInitRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12*\n" +
	"\x05state\x18\x02 \x01(\v2\x14.proto.WorkflowStateR\x05state\"\x1d\n" +
	"\vWaitRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"I\n" +
	"\vDoneRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12*\n" +
	"\x05state\x18\x02 \x01(\v2\x14.proto.WorkflowStateR\x05state\"\x1f\n" +
	"\rExtendRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"G\n" +
	"\rUpdateRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12&\n" +
	"\x05state\x18\x02 \x01(\v2\x10.proto.StepStateR\x05state\"=\n" +
	"\n" +
	"LogRequest\x12/\n" +
	"\n" +
	"logEntries\x18\x01 \x03(\v2\x0f.proto.LogEntryR\n" +
	"logEntries\"\a\n" +
	"\x05Empty\"-\n" +
	"\x13ReportHealthRequest\x12\x16\n" +
	"\x06status\x18\x01 \x01(\tR\x06status\"\x80\x02\n" +
	"\tAgentInfo\x12\x1a\n" +
	"\bplatform\x18\x01 \x01(\tR\bplatform\x12\x1a\n" +
	"\bcapacity\x18\x02 \x01(\x05R\bcapacity\x12\x18\n" +
	"\abackend\x18\x03 \x01(\tR\abackend\x12\x18\n" +
	"\aversion\x18\x04 \x01(\tR\aversion\x12F\n" +
	"\fcustomLabels\x18\x05 \x03(\v2\".proto.AgentInfo.CustomLabelsEntryR\fcustomLabels\x1a?\n" +
	"\x11CustomLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"<\n" +
	"\x14RegisterAgentRequest\x12$\n" +
	"\x04info\x18\x01 \x01(\v2\x10.proto.AgentInfoR\x04info\"[\n" +
	"\x0fVersionResponse\x12!\n" +
	"\fgrpc_version\x18\x01 \x01(\x05R\vgrpcVersion\x12%\n" +
	"\x0eserver_version\x18\x02 \x01(\tR\rserverVersion\";\n" +
	"\fNextResponse\x12+\n" +
	"\bworkflow\x18\x01 \x01(\v2\x0f.proto.WorkflowR\bworkflow\"2\n" +
	"\x15RegisterAgentResponse\x12\x19\n" +
	"\bagent_id\x18\x01 \x01(\x03R\aagentId\"I\n" +
	"\vAuthRequest\x12\x1f\n" +
	"\vagent_token\x18\x01 \x01(\tR\n" +
	"agentToken\x12\x19\n" +
	"\bagent_id\x18\x02 \x01(\x03R\aagentId\"d\n" +
	"\fAuthResponse\x12\x16\n" +
	"\x06status\x18\x01 \x01(\tR\x06status\x12\x19\n" +
	"\bagent_id\x18\x02 \x01(\x03R\aagentId\x12!\n" +
	"\faccess_token\x18\x03 \x01(\tR\vaccessToken2\xbb\x04\n" +
	"\n" +
	"Woodpecker\x121\n" +
	"\aVersion\x12\f.proto.Empty\x1a\x16.proto.VersionResponse\"\x00\x121\n" +
	"\x04Next\x12\x12.proto.NextRequest\x1a\x13.proto.NextResponse\"\x00\x12*\n" +
	"\x04Init\x12\x12.proto.InitRequest\x1a\f.proto.Empty\"\x00\x12*\n" +
	"\x04Wait\x12\x12.proto.WaitRequest\x1a\f.proto.Empty\"\x00\x12*\n" +
	"\x04Done\x12\x12.proto.DoneRequest\x1a\f.proto.Empty\"\x00\x12.\n" +
	"\x06Extend\x12\x14.proto.ExtendRequest\x1a\f.proto.Empty\"\x00\x12.\n" +
	"\x06Update\x12\x14.proto.UpdateRequest\x1a\f.proto.Empty\"\x00\x12(\n" +
	"\x03Log\x12\x11.proto.LogRequest\x1a\f.proto.Empty\"\x00\x12L\n" +
	"\rRegisterAgent\x12\x1b.proto.RegisterAgentRequest\x1a\x1c.proto.RegisterAgentResponse\"\x00\x12/\n" +
	"\x0fUnregisterAgent\x12\f.proto.Empty\x1a\f.proto.Empty\"\x00\x12:\n" +
	"\fReportHealth\x12\x1a.proto.ReportHealthRequest\x1a\f.proto.Empty\"\x002C\n" +
	"\x0eWoodpeckerAuth\x121\n" +
	"\x04Auth\x12\x12.proto.AuthRequest\x1a\x13.proto.AuthResponse\"\x00B7Z5go.woodpecker-ci.org/woodpecker/v3/pipeline/rpc/protob\x06proto3"

var (
	file_woodpecker_proto_rawDescOnce sync.Once
	file_woodpecker_proto_rawDescData []byte
)

func file_woodpecker_proto_rawDescGZIP() []byte {
	file_woodpecker_proto_rawDescOnce.Do(func() {
		file_woodpecker_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_woodpecker_proto_rawDesc), len(file_woodpecker_proto_rawDesc)))
	})
	return file_woodpecker_proto_rawDescData
}

var file_woodpecker_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_woodpecker_proto_goTypes = []any{
	(*StepState)(nil),             // 0: proto.StepState
	(*WorkflowState)(nil),         // 1: proto.WorkflowState
	(*LogEntry)(nil),              // 2: proto.LogEntry
	(*Filter)(nil),                // 3: proto.Filter
	(*Workflow)(nil),              // 4: proto.Workflow
	(*NextRequest)(nil),           // 5: proto.NextRequest
	(*InitRequest)(nil),           // 6: proto.InitRequest
	(*WaitRequest)(nil),           // 7: proto.WaitRequest
	(*DoneRequest)(nil),           // 8: proto.DoneRequest
	(*ExtendRequest)(nil),         // 9: proto.ExtendRequest
	(*UpdateRequest)(nil),         // 10: proto.UpdateRequest
	(*LogRequest)(nil),            // 11: proto.LogRequest
	(*Empty)(nil),                 // 12: proto.Empty
	(*ReportHealthRequest)(nil),   // 13: proto.ReportHealthRequest
	(*AgentInfo)(nil),             // 14: proto.AgentInfo
	(*RegisterAgentRequest)(nil),  // 15: proto.RegisterAgentRequest
	(*VersionResponse)(nil),       // 16: proto.VersionResponse
	(*NextResponse)(nil),          // 17: proto.NextResponse
	(*RegisterAgentResponse)(nil), // 18: proto.RegisterAgentResponse
	(*AuthRequest)(nil),           // 19: proto.AuthRequest
	(*AuthResponse)(nil),          // 20: proto.AuthResponse
	nil,                           // 21: proto.Filter.LabelsEntry
	nil,                           // 22: proto.AgentInfo.CustomLabelsEntry
}
var file_woodpecker_proto_depIdxs = []int32{
	21, // 0: proto.Filter.labels:type_name -> proto.Filter.LabelsEntry
	3,  // 1: proto.NextRequest.filter:type_name -> proto.Filter
	1,  // 2: proto.InitRequest.state:type_name -> proto.WorkflowState
	1,  // 3: proto.DoneRequest.state:type_name -> proto.WorkflowState
	0,  // 4: proto.UpdateRequest.state:type_name -> proto.StepState
	2,  // 5: proto.LogRequest.logEntries:type_name -> proto.LogEntry
	22, // 6: proto.AgentInfo.customLabels:type_name -> proto.AgentInfo.CustomLabelsEntry
	14, // 7: proto.RegisterAgentRequest.info:type_name -> proto.AgentInfo
	4,  // 8: proto.NextResponse.workflow:type_name -> proto.Workflow
	12, // 9: proto.Woodpecker.Version:input_type -> proto.Empty
	5,  // 10: proto.Woodpecker.Next:input_type -> proto.NextRequest
	6,  // 11: proto.Woodpecker.Init:input_type -> proto.InitRequest
	7,  // 12: proto.Woodpecker.Wait:input_type -> proto.WaitRequest
	8,  // 13: proto.Woodpecker.Done:input_type -> proto.DoneRequest
	9,  // 14: proto.Woodpecker.Extend:input_type -> proto.ExtendRequest
	10, // 15: proto.Woodpecker.Update:input_type -> proto.UpdateRequest
	11, // 16: proto.Woodpecker.Log:input_type -> proto.LogRequest
	15, // 17: proto.Woodpecker.RegisterAgent:input_type -> proto.RegisterAgentRequest
	12, // 18: proto.Woodpecker.UnregisterAgent:input_type -> proto.Empty
	13, // 19: proto.Woodpecker.ReportHealth:input_type -> proto.ReportHealthRequest
	19, // 20: proto.WoodpeckerAuth.Auth:input_type -> proto.AuthRequest
	16, // 21: proto.Woodpecker.Version:output_type -> proto.VersionResponse
	17, // 22: proto.Woodpecker.Next:output_type -> proto.NextResponse
	12, // 23: proto.Woodpecker.Init:output_type -> proto.Empty
	12, // 24: proto.Woodpecker.Wait:output_type -> proto.Empty
	12, // 25: proto.Woodpecker.Done:output_type -> proto.Empty
	12, // 26: proto.Woodpecker.Extend:output_type -> proto.Empty
	12, // 27: proto.Woodpecker.Update:output_type -> proto.Empty
	12, // 28: proto.Woodpecker.Log:output_type -> proto.Empty
	18, // 29: proto.Woodpecker.RegisterAgent:output_type -> proto.RegisterAgentResponse
	12, // 30: proto.Woodpecker.UnregisterAgent:output_type -> proto.Empty
	12, // 31: proto.Woodpecker.ReportHealth:output_type -> proto.Empty
	20, // 32: proto.WoodpeckerAuth.Auth:output_type -> proto.AuthResponse
	21, // [21:33] is the sub-list for method output_type
	9,  // [9:21] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_woodpecker_proto_init() }
func file_woodpecker_proto_init() {
	if File_woodpecker_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_woodpecker_proto_rawDesc), len(file_woodpecker_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_woodpecker_proto_goTypes,
		DependencyIndexes: file_woodpecker_proto_depIdxs,
		MessageInfos:      file_woodpecker_proto_msgTypes,
	}.Build()
	File_woodpecker_proto = out.File
	file_woodpecker_proto_goTypes = nil
	file_woodpecker_proto_depIdxs = nil
}
