/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureMirrorClampToEdge.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTTextureMirrorClampToEdgePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTTextureMirrorClampToEdgePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureMirrorClampToEdgePrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureMirrorClampToEdgePrototype>(vm)) JSEXTTextureMirrorClampToEdgePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureMirrorClampToEdgePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureMirrorClampToEdgePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureMirrorClampToEdgePrototype, JSEXTTextureMirrorClampToEdgePrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSEXTTextureMirrorClampToEdgePrototypeTableValues {
    HashTableValue { "MIRROR_CLAMP_TO_EDGE_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8743 } },
};

const ClassInfo JSEXTTextureMirrorClampToEdgePrototype::s_info = { "EXTTextureMirrorClampToEdge"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureMirrorClampToEdgePrototype) };

void JSEXTTextureMirrorClampToEdgePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureMirrorClampToEdge::info(), JSEXTTextureMirrorClampToEdgePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTTextureMirrorClampToEdge::s_info = { "EXTTextureMirrorClampToEdge"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureMirrorClampToEdge) };

JSEXTTextureMirrorClampToEdge::JSEXTTextureMirrorClampToEdge(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureMirrorClampToEdge>&& impl)
    : JSDOMWrapper<EXTTextureMirrorClampToEdge>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTTextureMirrorClampToEdge>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTTextureMirrorClampToEdge::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTTextureMirrorClampToEdgePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTTextureMirrorClampToEdgePrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTTextureMirrorClampToEdge::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTTextureMirrorClampToEdge>(vm, globalObject);
}

void JSEXTTextureMirrorClampToEdge::destroy(JSC::JSCell* cell)
{
    JSEXTTextureMirrorClampToEdge* thisObject = static_cast<JSEXTTextureMirrorClampToEdge*>(cell);
    thisObject->JSEXTTextureMirrorClampToEdge::~JSEXTTextureMirrorClampToEdge();
}

JSC::GCClient::IsoSubspace* JSEXTTextureMirrorClampToEdge::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTTextureMirrorClampToEdge, UseCustomHeapCellType::No>(vm, "JSEXTTextureMirrorClampToEdge"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTTextureMirrorClampToEdge.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTTextureMirrorClampToEdge = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTTextureMirrorClampToEdge.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTTextureMirrorClampToEdge = std::forward<decltype(space)>(space); }
    );
}

void JSEXTTextureMirrorClampToEdge::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTTextureMirrorClampToEdge*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTTextureMirrorClampToEdgeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTTextureMirrorClampToEdge = jsCast<JSEXTTextureMirrorClampToEdge*>(handle.slot()->asCell());
    auto& owner = jsEXTTextureMirrorClampToEdge->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTTextureMirrorClampToEdge"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTTextureMirrorClampToEdgeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureMirrorClampToEdge = static_cast<JSEXTTextureMirrorClampToEdge*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTTextureMirrorClampToEdge->protectedWrapped().ptr(), jsEXTTextureMirrorClampToEdge);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureMirrorClampToEdge@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27EXTTextureMirrorClampToEdgeE[]; }
#endif
template<std::same_as<EXTTextureMirrorClampToEdge> T>
static inline void verifyVTable(EXTTextureMirrorClampToEdge* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTTextureMirrorClampToEdge@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27EXTTextureMirrorClampToEdgeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTTextureMirrorClampToEdge has subclasses. If EXTTextureMirrorClampToEdge has subclasses that get passed
        // to toJS() we currently require EXTTextureMirrorClampToEdge you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTTextureMirrorClampToEdge>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTTextureMirrorClampToEdge>(impl.ptr());
#endif
    return createWrapper<EXTTextureMirrorClampToEdge>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTTextureMirrorClampToEdge& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTTextureMirrorClampToEdge* JSEXTTextureMirrorClampToEdge::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureMirrorClampToEdge*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
