#include "soapH.h"

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap *soap, struct soap_clist *p)
{
	(void)soap; /* appease -Wall -Werror */
	if (!p->ptr)
		return SOAP_OK;
	switch (p->type)
	{
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<struct SOAP_ENV__Detail*>(p->ptr), struct SOAP_ENV__Detail);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<struct SOAP_ENV__Detail*>(p->ptr), struct SOAP_ENV__Detail);
		break;
#endif
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<std::string*>(p->ptr), std::string);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<std::string*>(p->ptr), std::string);
		break;
	case SOAP_TYPE_vbox__IPCIDeviceAttachment:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IPCIDeviceAttachment*>(p->ptr), vbox__IPCIDeviceAttachment);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IPCIDeviceAttachment*>(p->ptr), vbox__IPCIDeviceAttachment);
		break;
	case SOAP_TYPE_vbox__IVRDEServerInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IVRDEServerInfo*>(p->ptr), vbox__IVRDEServerInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IVRDEServerInfo*>(p->ptr), vbox__IVRDEServerInfo);
		break;
	case SOAP_TYPE_vbox__IHostDrivePartition:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IHostDrivePartition*>(p->ptr), vbox__IHostDrivePartition);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IHostDrivePartition*>(p->ptr), vbox__IHostDrivePartition);
		break;
	case SOAP_TYPE_vbox__IGuestOSType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IGuestOSType*>(p->ptr), vbox__IGuestOSType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IGuestOSType*>(p->ptr), vbox__IGuestOSType);
		break;
	case SOAP_TYPE_vbox__IAdditionsFacility:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IAdditionsFacility*>(p->ptr), vbox__IAdditionsFacility);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IAdditionsFacility*>(p->ptr), vbox__IAdditionsFacility);
		break;
	case SOAP_TYPE_vbox__IMediumAttachment:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<vbox__IMediumAttachment*>(p->ptr), vbox__IMediumAttachment);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<vbox__IMediumAttachment*>(p->ptr), vbox__IMediumAttachment);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetResultCode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultCode*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultCode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultCode*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultCode);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetResultCodeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultCodeResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultCodeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultCodeResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultCodeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetResultDetail:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultDetail*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultDetail);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultDetail*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultDetail);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetResultDetailResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultDetailResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultDetailResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetResultDetailResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetResultDetailResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceID*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceID*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceID);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceIDResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceIDResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetInterfaceIDResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetComponent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetComponent*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetComponent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetComponent*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetComponent);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetComponentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetComponentResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetComponentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetComponentResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetComponentResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetText:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetText*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetText);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetText*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetText);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetTextResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetTextResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetTextResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetTextResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetTextResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetNext:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetNext*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetNext);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetNext*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetNext);
		break;
	case SOAP_TYPE__vbox__IVirtualBoxErrorInfo_USCOREgetNextResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetNextResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetNextResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBoxErrorInfo_USCOREgetNextResponse*>(p->ptr), _vbox__IVirtualBoxErrorInfo_USCOREgetNextResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkName);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkName);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetEnabled*>(p->ptr), _vbox__INATNetwork_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetEnabled*>(p->ptr), _vbox__INATNetwork_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetEnabled*>(p->ptr), _vbox__INATNetwork_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetEnabled*>(p->ptr), _vbox__INATNetwork_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNetwork*>(p->ptr), _vbox__INATNetwork_USCOREgetNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNetwork*>(p->ptr), _vbox__INATNetwork_USCOREgetNetwork);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNetworkResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNetwork*>(p->ptr), _vbox__INATNetwork_USCOREsetNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNetwork*>(p->ptr), _vbox__INATNetwork_USCOREsetNetwork);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNetworkResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetGateway:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetGateway*>(p->ptr), _vbox__INATNetwork_USCOREgetGateway);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetGateway*>(p->ptr), _vbox__INATNetwork_USCOREgetGateway);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetGatewayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetGatewayResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetGatewayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetGatewayResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetGatewayResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetIPv6Enabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6Enabled*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6Enabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6Enabled*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6Enabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetIPv6EnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6EnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6EnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6EnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6EnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetIPv6Enabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6Enabled*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6Enabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6Enabled*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6Enabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetIPv6EnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6EnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6EnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6EnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6EnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetIPv6Prefix:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6Prefix*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6Prefix);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6Prefix*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6Prefix);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetIPv6PrefixResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6PrefixResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6PrefixResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetIPv6PrefixResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetIPv6PrefixResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetIPv6Prefix:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6Prefix*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6Prefix);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6Prefix*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6Prefix);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetIPv6PrefixResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6PrefixResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6PrefixResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetIPv6PrefixResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetIPv6PrefixResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabled*>(p->ptr), _vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabled*>(p->ptr), _vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetAdvertiseDefaultIPv6RouteEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabled*>(p->ptr), _vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabled*>(p->ptr), _vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabled);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabledResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetAdvertiseDefaultIPv6RouteEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNeedDhcpServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNeedDhcpServer*>(p->ptr), _vbox__INATNetwork_USCOREgetNeedDhcpServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNeedDhcpServer*>(p->ptr), _vbox__INATNetwork_USCOREgetNeedDhcpServer);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNeedDhcpServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNeedDhcpServerResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNeedDhcpServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNeedDhcpServerResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNeedDhcpServerResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNeedDhcpServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNeedDhcpServer*>(p->ptr), _vbox__INATNetwork_USCOREsetNeedDhcpServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNeedDhcpServer*>(p->ptr), _vbox__INATNetwork_USCOREsetNeedDhcpServer);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNeedDhcpServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNeedDhcpServerResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNeedDhcpServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNeedDhcpServerResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNeedDhcpServerResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetEventSource*>(p->ptr), _vbox__INATNetwork_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetEventSource*>(p->ptr), _vbox__INATNetwork_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetEventSourceResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetEventSourceResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetPortForwardRules4:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules4*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules4);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules4*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules4);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetPortForwardRules4Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules4Response*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules4Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules4Response*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules4Response);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLocalMappings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalMappings*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalMappings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalMappings*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalMappings);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLocalMappingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalMappingsResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalMappingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalMappingsResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalMappingsResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLocalhostReachable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalhostReachable*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalhostReachable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalhostReachable*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalhostReachable);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLocalhostReachableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalhostReachableResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalhostReachableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLocalhostReachableResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetLocalhostReachableResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetLocalhostReachable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetLocalhostReachable*>(p->ptr), _vbox__INATNetwork_USCOREsetLocalhostReachable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetLocalhostReachable*>(p->ptr), _vbox__INATNetwork_USCOREsetLocalhostReachable);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetLocalhostReachableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetLocalhostReachableResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetLocalhostReachableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetLocalhostReachableResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetLocalhostReachableResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetForwardBroadcast:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetForwardBroadcast*>(p->ptr), _vbox__INATNetwork_USCOREgetForwardBroadcast);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetForwardBroadcast*>(p->ptr), _vbox__INATNetwork_USCOREgetForwardBroadcast);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetForwardBroadcastResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetForwardBroadcastResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetForwardBroadcastResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetForwardBroadcastResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetForwardBroadcastResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetForwardBroadcast:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetForwardBroadcast*>(p->ptr), _vbox__INATNetwork_USCOREsetForwardBroadcast);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetForwardBroadcast*>(p->ptr), _vbox__INATNetwork_USCOREsetForwardBroadcast);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetForwardBroadcastResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetForwardBroadcastResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetForwardBroadcastResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetForwardBroadcastResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetForwardBroadcastResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNatMTU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMTU*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMTU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMTU*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMTU);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNatMTUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMTUResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMTUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMTUResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMTUResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNatMTU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMTU*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMTU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMTU*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMTU);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNatMTUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMTUResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMTUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMTUResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMTUResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNatMRU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMRU*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMRU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMRU*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMRU);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetNatMRUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMRUResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMRUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetNatMRUResponse*>(p->ptr), _vbox__INATNetwork_USCOREgetNatMRUResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNatMRU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMRU*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMRU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMRU*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMRU);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetNatMRUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMRUResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMRUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetNatMRUResponse*>(p->ptr), _vbox__INATNetwork_USCOREsetNatMRUResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLoopbackIp6:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLoopbackIp6*>(p->ptr), _vbox__INATNetwork_USCOREgetLoopbackIp6);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLoopbackIp6*>(p->ptr), _vbox__INATNetwork_USCOREgetLoopbackIp6);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetLoopbackIp6Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetLoopbackIp6Response*>(p->ptr), _vbox__INATNetwork_USCOREgetLoopbackIp6Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetLoopbackIp6Response*>(p->ptr), _vbox__INATNetwork_USCOREgetLoopbackIp6Response);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetLoopbackIp6:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetLoopbackIp6*>(p->ptr), _vbox__INATNetwork_USCOREsetLoopbackIp6);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetLoopbackIp6*>(p->ptr), _vbox__INATNetwork_USCOREsetLoopbackIp6);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREsetLoopbackIp6Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREsetLoopbackIp6Response*>(p->ptr), _vbox__INATNetwork_USCOREsetLoopbackIp6Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREsetLoopbackIp6Response*>(p->ptr), _vbox__INATNetwork_USCOREsetLoopbackIp6Response);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetPortForwardRules6:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules6*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules6);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules6*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules6);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREgetPortForwardRules6Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules6Response*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules6Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREgetPortForwardRules6Response*>(p->ptr), _vbox__INATNetwork_USCOREgetPortForwardRules6Response);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREaddLocalMapping:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREaddLocalMapping*>(p->ptr), _vbox__INATNetwork_USCOREaddLocalMapping);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREaddLocalMapping*>(p->ptr), _vbox__INATNetwork_USCOREaddLocalMapping);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREaddLocalMappingResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREaddLocalMappingResponse*>(p->ptr), _vbox__INATNetwork_USCOREaddLocalMappingResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREaddLocalMappingResponse*>(p->ptr), _vbox__INATNetwork_USCOREaddLocalMappingResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREaddPortForwardRule:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREaddPortForwardRule*>(p->ptr), _vbox__INATNetwork_USCOREaddPortForwardRule);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREaddPortForwardRule*>(p->ptr), _vbox__INATNetwork_USCOREaddPortForwardRule);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREaddPortForwardRuleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREaddPortForwardRuleResponse*>(p->ptr), _vbox__INATNetwork_USCOREaddPortForwardRuleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREaddPortForwardRuleResponse*>(p->ptr), _vbox__INATNetwork_USCOREaddPortForwardRuleResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREremovePortForwardRule:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREremovePortForwardRule*>(p->ptr), _vbox__INATNetwork_USCOREremovePortForwardRule);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREremovePortForwardRule*>(p->ptr), _vbox__INATNetwork_USCOREremovePortForwardRule);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREremovePortForwardRuleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREremovePortForwardRuleResponse*>(p->ptr), _vbox__INATNetwork_USCOREremovePortForwardRuleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREremovePortForwardRuleResponse*>(p->ptr), _vbox__INATNetwork_USCOREremovePortForwardRuleResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREstart:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREstart*>(p->ptr), _vbox__INATNetwork_USCOREstart);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREstart*>(p->ptr), _vbox__INATNetwork_USCOREstart);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREstartResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREstartResponse*>(p->ptr), _vbox__INATNetwork_USCOREstartResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREstartResponse*>(p->ptr), _vbox__INATNetwork_USCOREstartResponse);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREstop:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREstop*>(p->ptr), _vbox__INATNetwork_USCOREstop);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREstop*>(p->ptr), _vbox__INATNetwork_USCOREstop);
		break;
	case SOAP_TYPE__vbox__INATNetwork_USCOREstopResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INATNetwork_USCOREstopResponse*>(p->ptr), _vbox__INATNetwork_USCOREstopResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INATNetwork_USCOREstopResponse*>(p->ptr), _vbox__INATNetwork_USCOREstopResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkName);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkName);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetEnabled*>(p->ptr), _vbox__ICloudNetwork_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetEnabled*>(p->ptr), _vbox__ICloudNetwork_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetEnabled*>(p->ptr), _vbox__ICloudNetwork_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetEnabled*>(p->ptr), _vbox__ICloudNetwork_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetProvider:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProvider*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProvider);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProvider*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProvider);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetProviderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProviderResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProviderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProviderResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProviderResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetProvider:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProvider*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProvider);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProvider*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProvider);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetProviderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProviderResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProviderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProviderResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProviderResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetProfile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProfile*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProfile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProfile*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProfile);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetProfileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProfileResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProfileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetProfileResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetProfileResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetProfile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProfile*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProfile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProfile*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProfile);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetProfileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProfileResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProfileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetProfileResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetProfileResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetNetworkId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkId*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkId*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkId);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREgetNetworkIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkIdResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREgetNetworkIdResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREgetNetworkIdResponse);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetNetworkId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkId*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkId*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkId);
		break;
	case SOAP_TYPE__vbox__ICloudNetwork_USCOREsetNetworkIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkIdResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICloudNetwork_USCOREsetNetworkIdResponse*>(p->ptr), _vbox__ICloudNetwork_USCOREsetNetworkIdResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkName*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkName);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkName*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkName);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkNameResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetEnabled*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetEnabled*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetEnabledResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetEnabled*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetEnabled*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetEnabledResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetNetworkMask:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkMask*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkMask);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkMask*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkMask);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetNetworkMaskResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkMaskResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetNetworkMaskResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetNetworkMask:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkMask*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkMask);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkMask*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkMask);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetNetworkMaskResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkMaskResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkMaskResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetNetworkMaskResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetNetworkMaskResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetHostIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetHostIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetHostIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetHostIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetHostIP);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetHostIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetHostIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetHostIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetHostIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetHostIPResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetLowerIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetLowerIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetLowerIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetLowerIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetLowerIP);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetLowerIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetLowerIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetLowerIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetLowerIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetLowerIPResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetLowerIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetLowerIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetLowerIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetLowerIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetLowerIP);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetLowerIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetLowerIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetLowerIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetLowerIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetLowerIPResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetUpperIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetUpperIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetUpperIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetUpperIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetUpperIP);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetUpperIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetUpperIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetUpperIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetUpperIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetUpperIPResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetUpperIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetUpperIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetUpperIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetUpperIP*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetUpperIP);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetUpperIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetUpperIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetUpperIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetUpperIPResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetUpperIPResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetId*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetId*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetIdResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREgetIdResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetId*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetId*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetId);
		break;
	case SOAP_TYPE__vbox__IHostOnlyNetwork_USCOREsetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetIdResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostOnlyNetwork_USCOREsetIdResponse*>(p->ptr), _vbox__IHostOnlyNetwork_USCOREsetIdResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetEventSource*>(p->ptr), _vbox__IDHCPServer_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetEventSource*>(p->ptr), _vbox__IDHCPServer_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetEnabled*>(p->ptr), _vbox__IDHCPServer_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetEnabled*>(p->ptr), _vbox__IDHCPServer_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetEnabledResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetEnabledResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREsetEnabled*>(p->ptr), _vbox__IDHCPServer_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREsetEnabled*>(p->ptr), _vbox__IDHCPServer_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREsetEnabledResponse*>(p->ptr), _vbox__IDHCPServer_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREsetEnabledResponse*>(p->ptr), _vbox__IDHCPServer_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetIPAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetIPAddress*>(p->ptr), _vbox__IDHCPServer_USCOREgetIPAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetIPAddress*>(p->ptr), _vbox__IDHCPServer_USCOREgetIPAddress);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetIPAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetIPAddressResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetIPAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetIPAddressResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetIPAddressResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetNetworkMask:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkMask*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkMask);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkMask*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkMask);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetNetworkMaskResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkMaskResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkMaskResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkName*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkName*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkName);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetLowerIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetLowerIP*>(p->ptr), _vbox__IDHCPServer_USCOREgetLowerIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetLowerIP*>(p->ptr), _vbox__IDHCPServer_USCOREgetLowerIP);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetLowerIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetLowerIPResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetLowerIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetLowerIPResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetLowerIPResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetUpperIP:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetUpperIP*>(p->ptr), _vbox__IDHCPServer_USCOREgetUpperIP);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetUpperIP*>(p->ptr), _vbox__IDHCPServer_USCOREgetUpperIP);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetUpperIPResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetUpperIPResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetUpperIPResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetUpperIPResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetUpperIPResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetGlobalConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetGlobalConfig*>(p->ptr), _vbox__IDHCPServer_USCOREgetGlobalConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetGlobalConfig*>(p->ptr), _vbox__IDHCPServer_USCOREgetGlobalConfig);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetGlobalConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetGlobalConfigResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetGlobalConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetGlobalConfigResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetGlobalConfigResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetGroupConfigs:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetGroupConfigs*>(p->ptr), _vbox__IDHCPServer_USCOREgetGroupConfigs);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetGroupConfigs*>(p->ptr), _vbox__IDHCPServer_USCOREgetGroupConfigs);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetGroupConfigsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetGroupConfigsResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetGroupConfigsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetGroupConfigsResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetGroupConfigsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetIndividualConfigs:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetIndividualConfigs*>(p->ptr), _vbox__IDHCPServer_USCOREgetIndividualConfigs);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetIndividualConfigs*>(p->ptr), _vbox__IDHCPServer_USCOREgetIndividualConfigs);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetIndividualConfigsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetIndividualConfigsResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetIndividualConfigsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetIndividualConfigsResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetIndividualConfigsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREsetConfiguration:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREsetConfiguration*>(p->ptr), _vbox__IDHCPServer_USCOREsetConfiguration);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREsetConfiguration*>(p->ptr), _vbox__IDHCPServer_USCOREsetConfiguration);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREsetConfigurationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREsetConfigurationResponse*>(p->ptr), _vbox__IDHCPServer_USCOREsetConfigurationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREsetConfigurationResponse*>(p->ptr), _vbox__IDHCPServer_USCOREsetConfigurationResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREstart:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREstart*>(p->ptr), _vbox__IDHCPServer_USCOREstart);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREstart*>(p->ptr), _vbox__IDHCPServer_USCOREstart);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREstartResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREstartResponse*>(p->ptr), _vbox__IDHCPServer_USCOREstartResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREstartResponse*>(p->ptr), _vbox__IDHCPServer_USCOREstartResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREstop:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREstop*>(p->ptr), _vbox__IDHCPServer_USCOREstop);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREstop*>(p->ptr), _vbox__IDHCPServer_USCOREstop);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREstopResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREstopResponse*>(p->ptr), _vbox__IDHCPServer_USCOREstopResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREstopResponse*>(p->ptr), _vbox__IDHCPServer_USCOREstopResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCORErestart:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCORErestart*>(p->ptr), _vbox__IDHCPServer_USCORErestart);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCORErestart*>(p->ptr), _vbox__IDHCPServer_USCORErestart);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCORErestartResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCORErestartResponse*>(p->ptr), _vbox__IDHCPServer_USCORErestartResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCORErestartResponse*>(p->ptr), _vbox__IDHCPServer_USCORErestartResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREfindLeaseByMAC:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREfindLeaseByMAC*>(p->ptr), _vbox__IDHCPServer_USCOREfindLeaseByMAC);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREfindLeaseByMAC*>(p->ptr), _vbox__IDHCPServer_USCOREfindLeaseByMAC);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREfindLeaseByMACResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREfindLeaseByMACResponse*>(p->ptr), _vbox__IDHCPServer_USCOREfindLeaseByMACResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREfindLeaseByMACResponse*>(p->ptr), _vbox__IDHCPServer_USCOREfindLeaseByMACResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetConfig*>(p->ptr), _vbox__IDHCPServer_USCOREgetConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetConfig*>(p->ptr), _vbox__IDHCPServer_USCOREgetConfig);
		break;
	case SOAP_TYPE__vbox__IDHCPServer_USCOREgetConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPServer_USCOREgetConfigResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPServer_USCOREgetConfigResponse*>(p->ptr), _vbox__IDHCPServer_USCOREgetConfigResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetScope:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetScope*>(p->ptr), _vbox__IDHCPConfig_USCOREgetScope);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetScope*>(p->ptr), _vbox__IDHCPConfig_USCOREgetScope);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetScopeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetScopeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetScopeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetScopeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetScopeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetMinLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMinLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMinLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMinLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMinLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetMinLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMinLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMinLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMinLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMinLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetMinLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMinLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMinLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMinLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMinLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetMinLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMinLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMinLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMinLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMinLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetDefaultLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetDefaultLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetDefaultLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetDefaultLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetDefaultLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetDefaultLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetDefaultLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetDefaultLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetDefaultLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetDefaultLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetDefaultLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetDefaultLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetDefaultLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetDefaultLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetDefaultLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetDefaultLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetDefaultLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetDefaultLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetDefaultLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetDefaultLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetMaxLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMaxLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMaxLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMaxLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMaxLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetMaxLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMaxLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMaxLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetMaxLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetMaxLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetMaxLeaseTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMaxLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMaxLeaseTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMaxLeaseTime*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMaxLeaseTime);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetMaxLeaseTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMaxLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMaxLeaseTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetMaxLeaseTimeResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetMaxLeaseTimeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetForcedOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetForcedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetForcedOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetForcedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetForcedOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetForcedOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetForcedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetForcedOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetForcedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetForcedOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetForcedOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetForcedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREsetForcedOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetForcedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREsetForcedOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetForcedOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetForcedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetForcedOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetForcedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetForcedOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetSuppressedOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetSuppressedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetSuppressedOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetSuppressedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetSuppressedOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetSuppressedOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetSuppressedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetSuppressedOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetSuppressedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetSuppressedOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetSuppressedOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetSuppressedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREsetSuppressedOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetSuppressedOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREsetSuppressedOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetSuppressedOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetSuppressedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetSuppressedOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetSuppressedOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetSuppressedOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetOption:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetOption*>(p->ptr), _vbox__IDHCPConfig_USCOREsetOption);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetOption*>(p->ptr), _vbox__IDHCPConfig_USCOREsetOption);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREsetOptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREsetOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetOptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREsetOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREsetOptionResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremoveOption:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveOption*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveOption);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveOption*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveOption);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremoveOptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveOptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveOptionResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremoveAllOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveAllOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveAllOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveAllOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveAllOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremoveAllOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveAllOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveAllOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveAllOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveAllOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetOption:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetOption*>(p->ptr), _vbox__IDHCPConfig_USCOREgetOption);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetOption*>(p->ptr), _vbox__IDHCPConfig_USCOREgetOption);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetOptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetOptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetOptionResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetOptionResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetAllOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetAllOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetAllOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetAllOptions*>(p->ptr), _vbox__IDHCPConfig_USCOREgetAllOptions);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREgetAllOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREgetAllOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetAllOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREgetAllOptionsResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREgetAllOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremove*>(p->ptr), _vbox__IDHCPConfig_USCOREremove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremove*>(p->ptr), _vbox__IDHCPConfig_USCOREremove);
		break;
	case SOAP_TYPE__vbox__IDHCPConfig_USCOREremoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPConfig_USCOREremoveResponse*>(p->ptr), _vbox__IDHCPConfig_USCOREremoveResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetInclusive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetInclusive*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetInclusive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetInclusive*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetInclusive);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetInclusiveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetInclusiveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetInclusiveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetInclusiveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetInclusiveResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetInclusive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetInclusive*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetInclusive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetInclusive*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetInclusive);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetInclusiveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetInclusiveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetInclusiveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetInclusiveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetInclusiveResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetType*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetType*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetTypeResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetTypeResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetType*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetType*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetType);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetTypeResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetTypeResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetValue:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetValue*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetValue);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetValue*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetValue);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREgetValueResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetValueResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetValueResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREgetValueResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREgetValueResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetValue:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetValue*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetValue);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetValue*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetValue);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREsetValueResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetValueResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetValueResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREsetValueResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREsetValueResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREremove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREremove*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREremove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREremove*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREremove);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupCondition_USCOREremoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREremoveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREremoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupCondition_USCOREremoveResponse*>(p->ptr), _vbox__IDHCPGroupCondition_USCOREremoveResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetName*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetName*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetNameResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetNameResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREsetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREsetName*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREsetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREsetName*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREsetName);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREsetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREsetNameResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREsetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREsetNameResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREsetNameResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREgetConditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetConditions*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetConditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetConditions*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetConditions);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREgetConditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetConditionsResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetConditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREgetConditionsResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREgetConditionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREaddCondition:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREaddCondition*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREaddCondition);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREaddCondition*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREaddCondition);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREaddConditionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREaddConditionResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREaddConditionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREaddConditionResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREaddConditionResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREremoveAllConditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREremoveAllConditions*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREremoveAllConditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREremoveAllConditions*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREremoveAllConditions);
		break;
	case SOAP_TYPE__vbox__IDHCPGroupConfig_USCOREremoveAllConditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREremoveAllConditionsResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREremoveAllConditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPGroupConfig_USCOREremoveAllConditionsResponse*>(p->ptr), _vbox__IDHCPGroupConfig_USCOREremoveAllConditionsResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetMACAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMACAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMACAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMACAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMACAddress);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetMACAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMACAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMACAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMACAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMACAddressResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetMachineId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMachineId*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMachineId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMachineId*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMachineId);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetMachineIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMachineIdResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMachineIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetMachineIdResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetMachineIdResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetSlot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetSlot*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetSlot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetSlot*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetSlot);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetSlotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetSlotResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetSlotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetSlotResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetSlotResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetFixedAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetFixedAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetFixedAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetFixedAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetFixedAddress);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREgetFixedAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetFixedAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetFixedAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREgetFixedAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREgetFixedAddressResponse);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREsetFixedAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREsetFixedAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREsetFixedAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREsetFixedAddress*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREsetFixedAddress);
		break;
	case SOAP_TYPE__vbox__IDHCPIndividualConfig_USCOREsetFixedAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREsetFixedAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREsetFixedAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDHCPIndividualConfig_USCOREsetFixedAddressResponse*>(p->ptr), _vbox__IDHCPIndividualConfig_USCOREsetFixedAddressResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersion*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersion*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersion);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetVersionNormalized:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionNormalized*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionNormalized);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionNormalized*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionNormalized);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetVersionNormalizedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionNormalizedResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionNormalizedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetVersionNormalizedResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetVersionNormalizedResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetRevision:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetRevision*>(p->ptr), _vbox__IVirtualBox_USCOREgetRevision);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetRevision*>(p->ptr), _vbox__IVirtualBox_USCOREgetRevision);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetRevisionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetRevisionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetRevisionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetRevisionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetRevisionResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPackageType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPackageType*>(p->ptr), _vbox__IVirtualBox_USCOREgetPackageType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPackageType*>(p->ptr), _vbox__IVirtualBox_USCOREgetPackageType);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPackageTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPackageTypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPackageTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPackageTypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPackageTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetAPIVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIVersion*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIVersion*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIVersion);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetAPIVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIVersionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIVersionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIVersionResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetAPIRevision:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIRevision*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIRevision);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIRevision*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIRevision);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetAPIRevisionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIRevisionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIRevisionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetAPIRevisionResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetAPIRevisionResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHomeFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHomeFolder*>(p->ptr), _vbox__IVirtualBox_USCOREgetHomeFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHomeFolder*>(p->ptr), _vbox__IVirtualBox_USCOREgetHomeFolder);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHomeFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHomeFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHomeFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHomeFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHomeFolderResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSettingsFilePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSettingsFilePath*>(p->ptr), _vbox__IVirtualBox_USCOREgetSettingsFilePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSettingsFilePath*>(p->ptr), _vbox__IVirtualBox_USCOREgetSettingsFilePath);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSettingsFilePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSettingsFilePathResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSettingsFilePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSettingsFilePathResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSettingsFilePathResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHost:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHost*>(p->ptr), _vbox__IVirtualBox_USCOREgetHost);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHost*>(p->ptr), _vbox__IVirtualBox_USCOREgetHost);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHostResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSystemProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSystemProperties*>(p->ptr), _vbox__IVirtualBox_USCOREgetSystemProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSystemProperties*>(p->ptr), _vbox__IVirtualBox_USCOREgetSystemProperties);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSystemPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSystemPropertiesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSystemPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSystemPropertiesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSystemPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachines:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachines*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachines);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachines*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachines);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachinesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachineGroups:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineGroups*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineGroups);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineGroups*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineGroups);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachineGroupsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineGroupsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineGroupsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineGroupsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineGroupsResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHardDisks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHardDisks*>(p->ptr), _vbox__IVirtualBox_USCOREgetHardDisks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHardDisks*>(p->ptr), _vbox__IVirtualBox_USCOREgetHardDisks);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHardDisksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHardDisksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHardDisksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHardDisksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHardDisksResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetDVDImages:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetDVDImages*>(p->ptr), _vbox__IVirtualBox_USCOREgetDVDImages);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetDVDImages*>(p->ptr), _vbox__IVirtualBox_USCOREgetDVDImages);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetDVDImagesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetDVDImagesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetDVDImagesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetDVDImagesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetDVDImagesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetFloppyImages:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetFloppyImages*>(p->ptr), _vbox__IVirtualBox_USCOREgetFloppyImages);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetFloppyImages*>(p->ptr), _vbox__IVirtualBox_USCOREgetFloppyImages);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetFloppyImagesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetFloppyImagesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetFloppyImagesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetFloppyImagesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetFloppyImagesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetProgressOperations:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetProgressOperations*>(p->ptr), _vbox__IVirtualBox_USCOREgetProgressOperations);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetProgressOperations*>(p->ptr), _vbox__IVirtualBox_USCOREgetProgressOperations);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetProgressOperationsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetProgressOperationsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetProgressOperationsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetProgressOperationsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetProgressOperationsResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypes*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypes*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypes);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSFamilies:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSFamilies*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSFamilies);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSFamilies*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSFamilies);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSFamiliesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSFamiliesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSFamiliesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSFamiliesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSFamiliesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSharedFolders:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSharedFolders*>(p->ptr), _vbox__IVirtualBox_USCOREgetSharedFolders);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSharedFolders*>(p->ptr), _vbox__IVirtualBox_USCOREgetSharedFolders);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetSharedFoldersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSharedFoldersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetSharedFoldersResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPerformanceCollector:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPerformanceCollector*>(p->ptr), _vbox__IVirtualBox_USCOREgetPerformanceCollector);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPerformanceCollector*>(p->ptr), _vbox__IVirtualBox_USCOREgetPerformanceCollector);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPerformanceCollectorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPerformanceCollectorResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPerformanceCollectorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPerformanceCollectorResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPerformanceCollectorResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetDHCPServers:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetDHCPServers*>(p->ptr), _vbox__IVirtualBox_USCOREgetDHCPServers);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetDHCPServers*>(p->ptr), _vbox__IVirtualBox_USCOREgetDHCPServers);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetDHCPServersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetDHCPServersResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetDHCPServersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetDHCPServersResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetDHCPServersResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetNATNetworks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetNATNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetNATNetworks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetNATNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetNATNetworks);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetNATNetworksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetNATNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetNATNetworksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetNATNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetNATNetworksResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetEventSource*>(p->ptr), _vbox__IVirtualBox_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetEventSource*>(p->ptr), _vbox__IVirtualBox_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetInternalNetworks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetInternalNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetInternalNetworks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetInternalNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetInternalNetworks);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetInternalNetworksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetInternalNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetInternalNetworksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetInternalNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetInternalNetworksResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHostOnlyNetworks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostOnlyNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostOnlyNetworks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostOnlyNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostOnlyNetworks);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetHostOnlyNetworksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostOnlyNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostOnlyNetworksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetHostOnlyNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetHostOnlyNetworksResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGenericNetworkDrivers:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGenericNetworkDrivers*>(p->ptr), _vbox__IVirtualBox_USCOREgetGenericNetworkDrivers);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGenericNetworkDrivers*>(p->ptr), _vbox__IVirtualBox_USCOREgetGenericNetworkDrivers);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGenericNetworkDriversResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGenericNetworkDriversResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGenericNetworkDriversResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGenericNetworkDriversResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGenericNetworkDriversResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetCloudNetworks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudNetworks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudNetworks*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudNetworks);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetCloudNetworksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudNetworksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudNetworksResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudNetworksResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetCloudProviderManager:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudProviderManager*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudProviderManager);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudProviderManager*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudProviderManager);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetCloudProviderManagerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudProviderManagerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudProviderManagerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetCloudProviderManagerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetCloudProviderManagerResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcomposeMachineFilename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcomposeMachineFilename*>(p->ptr), _vbox__IVirtualBox_USCOREcomposeMachineFilename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcomposeMachineFilename*>(p->ptr), _vbox__IVirtualBox_USCOREcomposeMachineFilename);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcomposeMachineFilenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcomposeMachineFilenameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcomposeMachineFilenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcomposeMachineFilenameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcomposeMachineFilenameResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPlatformProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPlatformProperties*>(p->ptr), _vbox__IVirtualBox_USCOREgetPlatformProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPlatformProperties*>(p->ptr), _vbox__IVirtualBox_USCOREgetPlatformProperties);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetPlatformPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetPlatformPropertiesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPlatformPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetPlatformPropertiesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetPlatformPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMachine*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMachine*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMachine);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMachineResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREopenMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREopenMachine*>(p->ptr), _vbox__IVirtualBox_USCOREopenMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREopenMachine*>(p->ptr), _vbox__IVirtualBox_USCOREopenMachine);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREopenMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREopenMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREopenMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREopenMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREopenMachineResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREregisterMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREregisterMachine*>(p->ptr), _vbox__IVirtualBox_USCOREregisterMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREregisterMachine*>(p->ptr), _vbox__IVirtualBox_USCOREregisterMachine);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREregisterMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREregisterMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREregisterMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREregisterMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREregisterMachineResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindMachine*>(p->ptr), _vbox__IVirtualBox_USCOREfindMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindMachine*>(p->ptr), _vbox__IVirtualBox_USCOREfindMachine);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindMachineResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindMachineResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachinesByGroups:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesByGroups*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesByGroups);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesByGroups*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesByGroups);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachinesByGroupsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesByGroupsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesByGroupsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachinesByGroupsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachinesByGroupsResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachineStates:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineStates*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineStates);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineStates*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineStates);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetMachineStatesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineStatesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineStatesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetMachineStatesResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetMachineStatesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateAppliance:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateAppliance*>(p->ptr), _vbox__IVirtualBox_USCOREcreateAppliance);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateAppliance*>(p->ptr), _vbox__IVirtualBox_USCOREcreateAppliance);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateApplianceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateApplianceResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateApplianceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateApplianceResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateApplianceResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateUnattendedInstaller:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateUnattendedInstaller*>(p->ptr), _vbox__IVirtualBox_USCOREcreateUnattendedInstaller);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateUnattendedInstaller*>(p->ptr), _vbox__IVirtualBox_USCOREcreateUnattendedInstaller);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateUnattendedInstallerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateUnattendedInstallerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateUnattendedInstallerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateUnattendedInstallerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateUnattendedInstallerResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMedium*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMedium*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMedium);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMediumResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateMediumResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateMediumResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREopenMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREopenMedium*>(p->ptr), _vbox__IVirtualBox_USCOREopenMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREopenMedium*>(p->ptr), _vbox__IVirtualBox_USCOREopenMedium);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREopenMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREopenMediumResponse*>(p->ptr), _vbox__IVirtualBox_USCOREopenMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREopenMediumResponse*>(p->ptr), _vbox__IVirtualBox_USCOREopenMediumResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSType*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSType*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSType);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSTypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyId*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyId*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyId);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSSubtypesByFamilyIdResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtype:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtype*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtype);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtype*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtype);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtypeResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetGuestOSDescsBySubtypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateSharedFolder*>(p->ptr), _vbox__IVirtualBox_USCOREcreateSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateSharedFolder*>(p->ptr), _vbox__IVirtualBox_USCOREcreateSharedFolder);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveSharedFolder*>(p->ptr), _vbox__IVirtualBox_USCOREremoveSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveSharedFolder*>(p->ptr), _vbox__IVirtualBox_USCOREremoveSharedFolder);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetExtraDataKeys:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataKeys*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataKeys);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataKeys*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataKeys);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetExtraDataKeysResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataKeysResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataKeysResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataKeysResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataKeysResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetExtraData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraData*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraData*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraData);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetExtraDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetExtraDataResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetExtraDataResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREsetExtraData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREsetExtraData*>(p->ptr), _vbox__IVirtualBox_USCOREsetExtraData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREsetExtraData*>(p->ptr), _vbox__IVirtualBox_USCOREsetExtraData);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREsetExtraDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREsetExtraDataResponse*>(p->ptr), _vbox__IVirtualBox_USCOREsetExtraDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREsetExtraDataResponse*>(p->ptr), _vbox__IVirtualBox_USCOREsetExtraDataResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREsetSettingsSecret:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREsetSettingsSecret*>(p->ptr), _vbox__IVirtualBox_USCOREsetSettingsSecret);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREsetSettingsSecret*>(p->ptr), _vbox__IVirtualBox_USCOREsetSettingsSecret);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREsetSettingsSecretResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREsetSettingsSecretResponse*>(p->ptr), _vbox__IVirtualBox_USCOREsetSettingsSecretResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREsetSettingsSecretResponse*>(p->ptr), _vbox__IVirtualBox_USCOREsetSettingsSecretResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateDHCPServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateDHCPServer*>(p->ptr), _vbox__IVirtualBox_USCOREcreateDHCPServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateDHCPServer*>(p->ptr), _vbox__IVirtualBox_USCOREcreateDHCPServer);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateDHCPServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateDHCPServerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateDHCPServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateDHCPServerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateDHCPServerResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindDHCPServerByNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindDHCPServerByNetworkName*>(p->ptr), _vbox__IVirtualBox_USCOREfindDHCPServerByNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindDHCPServerByNetworkName*>(p->ptr), _vbox__IVirtualBox_USCOREfindDHCPServerByNetworkName);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindDHCPServerByNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindDHCPServerByNetworkNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindDHCPServerByNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindDHCPServerByNetworkNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindDHCPServerByNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveDHCPServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveDHCPServer*>(p->ptr), _vbox__IVirtualBox_USCOREremoveDHCPServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveDHCPServer*>(p->ptr), _vbox__IVirtualBox_USCOREremoveDHCPServer);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveDHCPServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveDHCPServerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveDHCPServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveDHCPServerResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveDHCPServerResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateNATNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateNATNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateNATNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateNATNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateNATNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateNATNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateNATNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateNATNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateNATNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateNATNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindNATNetworkByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindNATNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindNATNetworkByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindNATNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindNATNetworkByName);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindNATNetworkByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindNATNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindNATNetworkByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindNATNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindNATNetworkByNameResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveNATNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveNATNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveNATNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveNATNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveNATNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveNATNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveNATNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveNATNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveNATNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveNATNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateHostOnlyNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateHostOnlyNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateHostOnlyNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateHostOnlyNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateHostOnlyNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateHostOnlyNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateHostOnlyNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateHostOnlyNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateHostOnlyNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateHostOnlyNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindHostOnlyNetworkByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByName);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindHostOnlyNetworkByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByNameResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindHostOnlyNetworkById:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkById*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkById);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkById*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkById);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindHostOnlyNetworkByIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindHostOnlyNetworkByIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindHostOnlyNetworkByIdResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveHostOnlyNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveHostOnlyNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveHostOnlyNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveHostOnlyNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveHostOnlyNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveHostOnlyNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveHostOnlyNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveHostOnlyNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveHostOnlyNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveHostOnlyNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateCloudNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateCloudNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateCloudNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateCloudNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREcreateCloudNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcreateCloudNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcreateCloudNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateCloudNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcreateCloudNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcreateCloudNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindCloudNetworkByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindCloudNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindCloudNetworkByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindCloudNetworkByName*>(p->ptr), _vbox__IVirtualBox_USCOREfindCloudNetworkByName);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindCloudNetworkByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindCloudNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindCloudNetworkByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindCloudNetworkByNameResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindCloudNetworkByNameResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveCloudNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveCloudNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveCloudNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveCloudNetwork*>(p->ptr), _vbox__IVirtualBox_USCOREremoveCloudNetwork);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREremoveCloudNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREremoveCloudNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveCloudNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREremoveCloudNetworkResponse*>(p->ptr), _vbox__IVirtualBox_USCOREremoveCloudNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcheckFirmwarePresent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcheckFirmwarePresent*>(p->ptr), _vbox__IVirtualBox_USCOREcheckFirmwarePresent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcheckFirmwarePresent*>(p->ptr), _vbox__IVirtualBox_USCOREcheckFirmwarePresent);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREcheckFirmwarePresentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREcheckFirmwarePresentResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcheckFirmwarePresentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREcheckFirmwarePresentResponse*>(p->ptr), _vbox__IVirtualBox_USCOREcheckFirmwarePresentResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindProgressById:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindProgressById*>(p->ptr), _vbox__IVirtualBox_USCOREfindProgressById);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindProgressById*>(p->ptr), _vbox__IVirtualBox_USCOREfindProgressById);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREfindProgressByIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREfindProgressByIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindProgressByIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREfindProgressByIdResponse*>(p->ptr), _vbox__IVirtualBox_USCOREfindProgressByIdResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetTrackedObject:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObject*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObject);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObject*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObject);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetTrackedObjectResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetTrackedObjectIds:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectIds*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectIds);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectIds*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectIds);
		break;
	case SOAP_TYPE__vbox__IVirtualBox_USCOREgetTrackedObjectIdsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectIdsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectIdsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualBox_USCOREgetTrackedObjectIdsResponse*>(p->ptr), _vbox__IVirtualBox_USCOREgetTrackedObjectIdsResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREgetPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREgetPath*>(p->ptr), _vbox__IVFSExplorer_USCOREgetPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREgetPath*>(p->ptr), _vbox__IVFSExplorer_USCOREgetPath);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREgetPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREgetPathResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREgetPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREgetPathResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREgetPathResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREgetType*>(p->ptr), _vbox__IVFSExplorer_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREgetType*>(p->ptr), _vbox__IVFSExplorer_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREgetTypeResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREgetTypeResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREupdate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREupdate*>(p->ptr), _vbox__IVFSExplorer_USCOREupdate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREupdate*>(p->ptr), _vbox__IVFSExplorer_USCOREupdate);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREupdateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREupdateResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREupdateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREupdateResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREupdateResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREcd:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREcd*>(p->ptr), _vbox__IVFSExplorer_USCOREcd);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREcd*>(p->ptr), _vbox__IVFSExplorer_USCOREcd);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREcdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREcdResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREcdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREcdResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREcdResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREcdUp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREcdUp*>(p->ptr), _vbox__IVFSExplorer_USCOREcdUp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREcdUp*>(p->ptr), _vbox__IVFSExplorer_USCOREcdUp);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREcdUpResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREcdUpResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREcdUpResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREcdUpResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREcdUpResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREentryList:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREentryList*>(p->ptr), _vbox__IVFSExplorer_USCOREentryList);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREentryList*>(p->ptr), _vbox__IVFSExplorer_USCOREentryList);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREentryListResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREentryListResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREentryListResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREentryListResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREentryListResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREexists:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREexists*>(p->ptr), _vbox__IVFSExplorer_USCOREexists);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREexists*>(p->ptr), _vbox__IVFSExplorer_USCOREexists);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREexistsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREexistsResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREexistsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREexistsResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREexistsResponse);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREremove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREremove*>(p->ptr), _vbox__IVFSExplorer_USCOREremove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREremove*>(p->ptr), _vbox__IVFSExplorer_USCOREremove);
		break;
	case SOAP_TYPE__vbox__IVFSExplorer_USCOREremoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVFSExplorer_USCOREremoveResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREremoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVFSExplorer_USCOREremoveResponse*>(p->ptr), _vbox__IVFSExplorer_USCOREremoveResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetVersionNumber:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetVersionNumber*>(p->ptr), _vbox__ICertificate_USCOREgetVersionNumber);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetVersionNumber*>(p->ptr), _vbox__ICertificate_USCOREgetVersionNumber);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetVersionNumberResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetVersionNumberResponse*>(p->ptr), _vbox__ICertificate_USCOREgetVersionNumberResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetVersionNumberResponse*>(p->ptr), _vbox__ICertificate_USCOREgetVersionNumberResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSerialNumber:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSerialNumber*>(p->ptr), _vbox__ICertificate_USCOREgetSerialNumber);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSerialNumber*>(p->ptr), _vbox__ICertificate_USCOREgetSerialNumber);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSerialNumberResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSerialNumberResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSerialNumberResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSerialNumberResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSerialNumberResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSignatureAlgorithmOID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmOID*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmOID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmOID*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmOID);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSignatureAlgorithmOIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmOIDResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmOIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmOIDResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmOIDResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSignatureAlgorithmName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmName*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmName*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmName);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSignatureAlgorithmNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSignatureAlgorithmNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSignatureAlgorithmNameResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetIssuerName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerName*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerName*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerName);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetIssuerNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerNameResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectName*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectName*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectName);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectNameResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetFriendlyName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetFriendlyName*>(p->ptr), _vbox__ICertificate_USCOREgetFriendlyName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetFriendlyName*>(p->ptr), _vbox__ICertificate_USCOREgetFriendlyName);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetFriendlyNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetFriendlyNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetFriendlyNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetFriendlyNameResponse*>(p->ptr), _vbox__ICertificate_USCOREgetFriendlyNameResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetValidityPeriodNotBefore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotBefore*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotBefore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotBefore*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotBefore);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetValidityPeriodNotBeforeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotBeforeResponse*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotBeforeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotBeforeResponse*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotBeforeResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetValidityPeriodNotAfter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotAfter*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotAfter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotAfter*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotAfter);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetValidityPeriodNotAfterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotAfterResponse*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotAfterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetValidityPeriodNotAfterResponse*>(p->ptr), _vbox__ICertificate_USCOREgetValidityPeriodNotAfterResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetPublicKeyAlgorithmOID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmOID*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmOID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmOID*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmOID);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetPublicKeyAlgorithmOIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmOIDResponse*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmOIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmOIDResponse*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmOIDResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetPublicKeyAlgorithm:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithm*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithm);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithm*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithm);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetPublicKeyAlgorithmResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmResponse*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetPublicKeyAlgorithmResponse*>(p->ptr), _vbox__ICertificate_USCOREgetPublicKeyAlgorithmResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectPublicKey:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectPublicKey*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectPublicKey);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectPublicKey*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectPublicKey);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectPublicKeyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectPublicKeyResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectPublicKeyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectPublicKeyResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectPublicKeyResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetIssuerUniqueIdentifier:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerUniqueIdentifier*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerUniqueIdentifier);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerUniqueIdentifier*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerUniqueIdentifier);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetIssuerUniqueIdentifierResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerUniqueIdentifierResponse*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerUniqueIdentifierResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetIssuerUniqueIdentifierResponse*>(p->ptr), _vbox__ICertificate_USCOREgetIssuerUniqueIdentifierResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectUniqueIdentifier:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectUniqueIdentifier*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectUniqueIdentifier);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectUniqueIdentifier*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectUniqueIdentifier);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSubjectUniqueIdentifierResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectUniqueIdentifierResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectUniqueIdentifierResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSubjectUniqueIdentifierResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSubjectUniqueIdentifierResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetCertificateAuthority:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetCertificateAuthority*>(p->ptr), _vbox__ICertificate_USCOREgetCertificateAuthority);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetCertificateAuthority*>(p->ptr), _vbox__ICertificate_USCOREgetCertificateAuthority);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetCertificateAuthorityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetCertificateAuthorityResponse*>(p->ptr), _vbox__ICertificate_USCOREgetCertificateAuthorityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetCertificateAuthorityResponse*>(p->ptr), _vbox__ICertificate_USCOREgetCertificateAuthorityResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetKeyUsage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetKeyUsage*>(p->ptr), _vbox__ICertificate_USCOREgetKeyUsage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetKeyUsage*>(p->ptr), _vbox__ICertificate_USCOREgetKeyUsage);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetKeyUsageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetKeyUsageResponse*>(p->ptr), _vbox__ICertificate_USCOREgetKeyUsageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetKeyUsageResponse*>(p->ptr), _vbox__ICertificate_USCOREgetKeyUsageResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetExtendedKeyUsage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetExtendedKeyUsage*>(p->ptr), _vbox__ICertificate_USCOREgetExtendedKeyUsage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetExtendedKeyUsage*>(p->ptr), _vbox__ICertificate_USCOREgetExtendedKeyUsage);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetExtendedKeyUsageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetExtendedKeyUsageResponse*>(p->ptr), _vbox__ICertificate_USCOREgetExtendedKeyUsageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetExtendedKeyUsageResponse*>(p->ptr), _vbox__ICertificate_USCOREgetExtendedKeyUsageResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetRawCertData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetRawCertData*>(p->ptr), _vbox__ICertificate_USCOREgetRawCertData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetRawCertData*>(p->ptr), _vbox__ICertificate_USCOREgetRawCertData);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetRawCertDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetRawCertDataResponse*>(p->ptr), _vbox__ICertificate_USCOREgetRawCertDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetRawCertDataResponse*>(p->ptr), _vbox__ICertificate_USCOREgetRawCertDataResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSelfSigned:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSelfSigned*>(p->ptr), _vbox__ICertificate_USCOREgetSelfSigned);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSelfSigned*>(p->ptr), _vbox__ICertificate_USCOREgetSelfSigned);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetSelfSignedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetSelfSignedResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSelfSignedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetSelfSignedResponse*>(p->ptr), _vbox__ICertificate_USCOREgetSelfSignedResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetTrusted:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetTrusted*>(p->ptr), _vbox__ICertificate_USCOREgetTrusted);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetTrusted*>(p->ptr), _vbox__ICertificate_USCOREgetTrusted);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetTrustedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetTrustedResponse*>(p->ptr), _vbox__ICertificate_USCOREgetTrustedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetTrustedResponse*>(p->ptr), _vbox__ICertificate_USCOREgetTrustedResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetExpired:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetExpired*>(p->ptr), _vbox__ICertificate_USCOREgetExpired);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetExpired*>(p->ptr), _vbox__ICertificate_USCOREgetExpired);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREgetExpiredResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREgetExpiredResponse*>(p->ptr), _vbox__ICertificate_USCOREgetExpiredResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREgetExpiredResponse*>(p->ptr), _vbox__ICertificate_USCOREgetExpiredResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREisCurrentlyExpired:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREisCurrentlyExpired*>(p->ptr), _vbox__ICertificate_USCOREisCurrentlyExpired);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREisCurrentlyExpired*>(p->ptr), _vbox__ICertificate_USCOREisCurrentlyExpired);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREisCurrentlyExpiredResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREisCurrentlyExpiredResponse*>(p->ptr), _vbox__ICertificate_USCOREisCurrentlyExpiredResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREisCurrentlyExpiredResponse*>(p->ptr), _vbox__ICertificate_USCOREisCurrentlyExpiredResponse);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREqueryInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREqueryInfo*>(p->ptr), _vbox__ICertificate_USCOREqueryInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREqueryInfo*>(p->ptr), _vbox__ICertificate_USCOREqueryInfo);
		break;
	case SOAP_TYPE__vbox__ICertificate_USCOREqueryInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICertificate_USCOREqueryInfoResponse*>(p->ptr), _vbox__ICertificate_USCOREqueryInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICertificate_USCOREqueryInfoResponse*>(p->ptr), _vbox__ICertificate_USCOREqueryInfoResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetPath*>(p->ptr), _vbox__IAppliance_USCOREgetPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetPath*>(p->ptr), _vbox__IAppliance_USCOREgetPath);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetPathResponse*>(p->ptr), _vbox__IAppliance_USCOREgetPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetPathResponse*>(p->ptr), _vbox__IAppliance_USCOREgetPathResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetDisks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetDisks*>(p->ptr), _vbox__IAppliance_USCOREgetDisks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetDisks*>(p->ptr), _vbox__IAppliance_USCOREgetDisks);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetDisksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetDisksResponse*>(p->ptr), _vbox__IAppliance_USCOREgetDisksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetDisksResponse*>(p->ptr), _vbox__IAppliance_USCOREgetDisksResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetVirtualSystemDescriptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetVirtualSystemDescriptions*>(p->ptr), _vbox__IAppliance_USCOREgetVirtualSystemDescriptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetVirtualSystemDescriptions*>(p->ptr), _vbox__IAppliance_USCOREgetVirtualSystemDescriptions);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetVirtualSystemDescriptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetVirtualSystemDescriptionsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetVirtualSystemDescriptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetVirtualSystemDescriptionsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetVirtualSystemDescriptionsResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetMachines:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetMachines*>(p->ptr), _vbox__IAppliance_USCOREgetMachines);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetMachines*>(p->ptr), _vbox__IAppliance_USCOREgetMachines);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetMachinesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetMachinesResponse*>(p->ptr), _vbox__IAppliance_USCOREgetMachinesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetMachinesResponse*>(p->ptr), _vbox__IAppliance_USCOREgetMachinesResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetCertificate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetCertificate*>(p->ptr), _vbox__IAppliance_USCOREgetCertificate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetCertificate*>(p->ptr), _vbox__IAppliance_USCOREgetCertificate);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetCertificateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetCertificateResponse*>(p->ptr), _vbox__IAppliance_USCOREgetCertificateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetCertificateResponse*>(p->ptr), _vbox__IAppliance_USCOREgetCertificateResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREread*>(p->ptr), _vbox__IAppliance_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREread*>(p->ptr), _vbox__IAppliance_USCOREread);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREreadResponse*>(p->ptr), _vbox__IAppliance_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREreadResponse*>(p->ptr), _vbox__IAppliance_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREinterpret:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREinterpret*>(p->ptr), _vbox__IAppliance_USCOREinterpret);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREinterpret*>(p->ptr), _vbox__IAppliance_USCOREinterpret);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREinterpretResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREinterpretResponse*>(p->ptr), _vbox__IAppliance_USCOREinterpretResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREinterpretResponse*>(p->ptr), _vbox__IAppliance_USCOREinterpretResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREimportMachines:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREimportMachines*>(p->ptr), _vbox__IAppliance_USCOREimportMachines);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREimportMachines*>(p->ptr), _vbox__IAppliance_USCOREimportMachines);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREimportMachinesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREimportMachinesResponse*>(p->ptr), _vbox__IAppliance_USCOREimportMachinesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREimportMachinesResponse*>(p->ptr), _vbox__IAppliance_USCOREimportMachinesResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREcreateVFSExplorer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREcreateVFSExplorer*>(p->ptr), _vbox__IAppliance_USCOREcreateVFSExplorer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREcreateVFSExplorer*>(p->ptr), _vbox__IAppliance_USCOREcreateVFSExplorer);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREcreateVFSExplorerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREcreateVFSExplorerResponse*>(p->ptr), _vbox__IAppliance_USCOREcreateVFSExplorerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREcreateVFSExplorerResponse*>(p->ptr), _vbox__IAppliance_USCOREcreateVFSExplorerResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREwrite:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREwrite*>(p->ptr), _vbox__IAppliance_USCOREwrite);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREwrite*>(p->ptr), _vbox__IAppliance_USCOREwrite);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREwriteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREwriteResponse*>(p->ptr), _vbox__IAppliance_USCOREwriteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREwriteResponse*>(p->ptr), _vbox__IAppliance_USCOREwriteResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetWarnings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetWarnings*>(p->ptr), _vbox__IAppliance_USCOREgetWarnings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetWarnings*>(p->ptr), _vbox__IAppliance_USCOREgetWarnings);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetWarningsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetWarningsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetWarningsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetWarningsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetWarningsResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetPasswordIds:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetPasswordIds*>(p->ptr), _vbox__IAppliance_USCOREgetPasswordIds);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetPasswordIds*>(p->ptr), _vbox__IAppliance_USCOREgetPasswordIds);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetPasswordIdsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetPasswordIdsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetPasswordIdsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetPasswordIdsResponse*>(p->ptr), _vbox__IAppliance_USCOREgetPasswordIdsResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetMediumIdsForPasswordId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetMediumIdsForPasswordId*>(p->ptr), _vbox__IAppliance_USCOREgetMediumIdsForPasswordId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetMediumIdsForPasswordId*>(p->ptr), _vbox__IAppliance_USCOREgetMediumIdsForPasswordId);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREgetMediumIdsForPasswordIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREgetMediumIdsForPasswordIdResponse*>(p->ptr), _vbox__IAppliance_USCOREgetMediumIdsForPasswordIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREgetMediumIdsForPasswordIdResponse*>(p->ptr), _vbox__IAppliance_USCOREgetMediumIdsForPasswordIdResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREaddPasswords:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREaddPasswords*>(p->ptr), _vbox__IAppliance_USCOREaddPasswords);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREaddPasswords*>(p->ptr), _vbox__IAppliance_USCOREaddPasswords);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREaddPasswordsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREaddPasswordsResponse*>(p->ptr), _vbox__IAppliance_USCOREaddPasswordsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREaddPasswordsResponse*>(p->ptr), _vbox__IAppliance_USCOREaddPasswordsResponse);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREcreateVirtualSystemDescriptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREcreateVirtualSystemDescriptions*>(p->ptr), _vbox__IAppliance_USCOREcreateVirtualSystemDescriptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREcreateVirtualSystemDescriptions*>(p->ptr), _vbox__IAppliance_USCOREcreateVirtualSystemDescriptions);
		break;
	case SOAP_TYPE__vbox__IAppliance_USCOREcreateVirtualSystemDescriptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IAppliance_USCOREcreateVirtualSystemDescriptionsResponse*>(p->ptr), _vbox__IAppliance_USCOREcreateVirtualSystemDescriptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IAppliance_USCOREcreateVirtualSystemDescriptionsResponse*>(p->ptr), _vbox__IAppliance_USCOREcreateVirtualSystemDescriptionsResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetCount*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetCount*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetCount);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetCountResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetCountResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetCountResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescription*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescription*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescription);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetDescriptionByType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionByType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionByType);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetDescriptionByTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionByTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetDescriptionByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetDescriptionByTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREremoveDescriptionByType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREremoveDescriptionByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREremoveDescriptionByType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREremoveDescriptionByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREremoveDescriptionByType);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREremoveDescriptionByTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREremoveDescriptionByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREremoveDescriptionByTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREremoveDescriptionByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREremoveDescriptionByTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetValuesByType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetValuesByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetValuesByType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetValuesByType*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetValuesByType);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREgetValuesByTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetValuesByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetValuesByTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREgetValuesByTypeResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREgetValuesByTypeResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREsetFinalValues:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREsetFinalValues*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREsetFinalValues);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREsetFinalValues*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREsetFinalValues);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREsetFinalValuesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREsetFinalValuesResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREsetFinalValuesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREsetFinalValuesResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREsetFinalValuesResponse);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREaddDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREaddDescription*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREaddDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREaddDescription*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREaddDescription);
		break;
	case SOAP_TYPE__vbox__IVirtualSystemDescription_USCOREaddDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREaddDescriptionResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREaddDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IVirtualSystemDescription_USCOREaddDescriptionResponse*>(p->ptr), _vbox__IVirtualSystemDescription_USCOREaddDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetMachine*>(p->ptr), _vbox__IUnattended_USCOREgetMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetMachine*>(p->ptr), _vbox__IUnattended_USCOREgetMachine);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetMachineResponse*>(p->ptr), _vbox__IUnattended_USCOREgetMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetMachineResponse*>(p->ptr), _vbox__IUnattended_USCOREgetMachineResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetMachine*>(p->ptr), _vbox__IUnattended_USCOREsetMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetMachine*>(p->ptr), _vbox__IUnattended_USCOREsetMachine);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetMachineResponse*>(p->ptr), _vbox__IUnattended_USCOREsetMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetMachineResponse*>(p->ptr), _vbox__IUnattended_USCOREsetMachineResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUser:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUser*>(p->ptr), _vbox__IUnattended_USCOREgetUser);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUser*>(p->ptr), _vbox__IUnattended_USCOREgetUser);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUserResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUserResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUserResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUser:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUser*>(p->ptr), _vbox__IUnattended_USCOREsetUser);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUser*>(p->ptr), _vbox__IUnattended_USCOREsetUser);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUserResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUserResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUserResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUserPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUserPassword*>(p->ptr), _vbox__IUnattended_USCOREgetUserPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUserPassword*>(p->ptr), _vbox__IUnattended_USCOREgetUserPassword);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUserPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUserPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUserPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUserPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUserPassword*>(p->ptr), _vbox__IUnattended_USCOREsetUserPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUserPassword*>(p->ptr), _vbox__IUnattended_USCOREsetUserPassword);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUserPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUserPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUserPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAdminPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAdminPassword*>(p->ptr), _vbox__IUnattended_USCOREgetAdminPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAdminPassword*>(p->ptr), _vbox__IUnattended_USCOREgetAdminPassword);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAdminPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAdminPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAdminPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAdminPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAdminPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAdminPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAdminPassword*>(p->ptr), _vbox__IUnattended_USCOREsetAdminPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAdminPassword*>(p->ptr), _vbox__IUnattended_USCOREsetAdminPassword);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAdminPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAdminPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAdminPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAdminPasswordResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAdminPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetFullUserName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetFullUserName*>(p->ptr), _vbox__IUnattended_USCOREgetFullUserName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetFullUserName*>(p->ptr), _vbox__IUnattended_USCOREgetFullUserName);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetFullUserNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetFullUserNameResponse*>(p->ptr), _vbox__IUnattended_USCOREgetFullUserNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetFullUserNameResponse*>(p->ptr), _vbox__IUnattended_USCOREgetFullUserNameResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetFullUserName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetFullUserName*>(p->ptr), _vbox__IUnattended_USCOREsetFullUserName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetFullUserName*>(p->ptr), _vbox__IUnattended_USCOREsetFullUserName);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetFullUserNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetFullUserNameResponse*>(p->ptr), _vbox__IUnattended_USCOREsetFullUserNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetFullUserNameResponse*>(p->ptr), _vbox__IUnattended_USCOREsetFullUserNameResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProductKey:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProductKey*>(p->ptr), _vbox__IUnattended_USCOREgetProductKey);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProductKey*>(p->ptr), _vbox__IUnattended_USCOREgetProductKey);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProductKeyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetProductKey:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetProductKey*>(p->ptr), _vbox__IUnattended_USCOREsetProductKey);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetProductKey*>(p->ptr), _vbox__IUnattended_USCOREsetProductKey);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetProductKeyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetProductKeyResponse*>(p->ptr), _vbox__IUnattended_USCOREsetProductKeyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetProductKeyResponse*>(p->ptr), _vbox__IUnattended_USCOREsetProductKeyResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAdditionsIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAdditionsIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetAdditionsIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAdditionsIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetAdditionsIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAdditionsIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAdditionsIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAdditionsIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAdditionsIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAdditionsIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAdditionsIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAdditionsIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetAdditionsIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAdditionsIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetAdditionsIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAdditionsIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAdditionsIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAdditionsIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAdditionsIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAdditionsIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallGuestAdditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallGuestAdditions*>(p->ptr), _vbox__IUnattended_USCOREgetInstallGuestAdditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallGuestAdditions*>(p->ptr), _vbox__IUnattended_USCOREgetInstallGuestAdditions);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallGuestAdditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallGuestAdditionsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallGuestAdditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallGuestAdditionsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallGuestAdditionsResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallGuestAdditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallGuestAdditions*>(p->ptr), _vbox__IUnattended_USCOREsetInstallGuestAdditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallGuestAdditions*>(p->ptr), _vbox__IUnattended_USCOREsetInstallGuestAdditions);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallGuestAdditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallGuestAdditionsResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallGuestAdditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallGuestAdditionsResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallGuestAdditionsResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProductKeyRequired:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyRequired*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyRequired);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyRequired*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyRequired);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProductKeyRequiredResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyRequiredResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyRequiredResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProductKeyRequiredResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProductKeyRequiredResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetValidationKitIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetValidationKitIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetValidationKitIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetValidationKitIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetValidationKitIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetValidationKitIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetValidationKitIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetValidationKitIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetValidationKitIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetValidationKitIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetValidationKitIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetValidationKitIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetValidationKitIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetValidationKitIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetValidationKitIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetValidationKitIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetValidationKitIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetValidationKitIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetValidationKitIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetValidationKitIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallTestExecService:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallTestExecService*>(p->ptr), _vbox__IUnattended_USCOREgetInstallTestExecService);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallTestExecService*>(p->ptr), _vbox__IUnattended_USCOREgetInstallTestExecService);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallTestExecServiceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallTestExecServiceResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallTestExecServiceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallTestExecServiceResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallTestExecServiceResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallTestExecService:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallTestExecService*>(p->ptr), _vbox__IUnattended_USCOREsetInstallTestExecService);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallTestExecService*>(p->ptr), _vbox__IUnattended_USCOREsetInstallTestExecService);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallTestExecServiceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallTestExecServiceResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallTestExecServiceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallTestExecServiceResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallTestExecServiceResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUserPayloadIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUserPayloadIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetUserPayloadIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUserPayloadIsoPath*>(p->ptr), _vbox__IUnattended_USCOREgetUserPayloadIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetUserPayloadIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetUserPayloadIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserPayloadIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetUserPayloadIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetUserPayloadIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUserPayloadIsoPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUserPayloadIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetUserPayloadIsoPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUserPayloadIsoPath*>(p->ptr), _vbox__IUnattended_USCOREsetUserPayloadIsoPath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetUserPayloadIsoPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetUserPayloadIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserPayloadIsoPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetUserPayloadIsoPathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetUserPayloadIsoPathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallUserPayload:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallUserPayload*>(p->ptr), _vbox__IUnattended_USCOREgetInstallUserPayload);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallUserPayload*>(p->ptr), _vbox__IUnattended_USCOREgetInstallUserPayload);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetInstallUserPayloadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetInstallUserPayloadResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallUserPayloadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetInstallUserPayloadResponse*>(p->ptr), _vbox__IUnattended_USCOREgetInstallUserPayloadResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallUserPayload:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallUserPayload*>(p->ptr), _vbox__IUnattended_USCOREsetInstallUserPayload);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallUserPayload*>(p->ptr), _vbox__IUnattended_USCOREsetInstallUserPayload);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetInstallUserPayloadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetInstallUserPayloadResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallUserPayloadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetInstallUserPayloadResponse*>(p->ptr), _vbox__IUnattended_USCOREsetInstallUserPayloadResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetTimeZone:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetTimeZone*>(p->ptr), _vbox__IUnattended_USCOREgetTimeZone);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetTimeZone*>(p->ptr), _vbox__IUnattended_USCOREgetTimeZone);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetTimeZoneResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetTimeZoneResponse*>(p->ptr), _vbox__IUnattended_USCOREgetTimeZoneResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetTimeZoneResponse*>(p->ptr), _vbox__IUnattended_USCOREgetTimeZoneResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetTimeZone:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetTimeZone*>(p->ptr), _vbox__IUnattended_USCOREsetTimeZone);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetTimeZone*>(p->ptr), _vbox__IUnattended_USCOREsetTimeZone);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetTimeZoneResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetTimeZoneResponse*>(p->ptr), _vbox__IUnattended_USCOREsetTimeZoneResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetTimeZoneResponse*>(p->ptr), _vbox__IUnattended_USCOREsetTimeZoneResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetKeyboardLayout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardLayout*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardLayout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardLayout*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardLayout);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetKeyboardLayoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardLayoutResponse*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardLayoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardLayoutResponse*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardLayoutResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetKeyboardLayout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardLayout*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardLayout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardLayout*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardLayout);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetKeyboardLayoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardLayoutResponse*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardLayoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardLayoutResponse*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardLayoutResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetKeyboardVariant:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardVariant*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardVariant);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardVariant*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardVariant);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetKeyboardVariantResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardVariantResponse*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardVariantResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetKeyboardVariantResponse*>(p->ptr), _vbox__IUnattended_USCOREgetKeyboardVariantResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetKeyboardVariant:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardVariant*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardVariant);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardVariant*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardVariant);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetKeyboardVariantResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardVariantResponse*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardVariantResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetKeyboardVariantResponse*>(p->ptr), _vbox__IUnattended_USCOREsetKeyboardVariantResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetLocale:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetLocale*>(p->ptr), _vbox__IUnattended_USCOREgetLocale);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetLocale*>(p->ptr), _vbox__IUnattended_USCOREgetLocale);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetLocaleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetLocaleResponse*>(p->ptr), _vbox__IUnattended_USCOREgetLocaleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetLocaleResponse*>(p->ptr), _vbox__IUnattended_USCOREgetLocaleResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetLocale:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetLocale*>(p->ptr), _vbox__IUnattended_USCOREsetLocale);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetLocale*>(p->ptr), _vbox__IUnattended_USCOREsetLocale);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetLocaleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetLocaleResponse*>(p->ptr), _vbox__IUnattended_USCOREsetLocaleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetLocaleResponse*>(p->ptr), _vbox__IUnattended_USCOREsetLocaleResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetLanguage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetLanguage*>(p->ptr), _vbox__IUnattended_USCOREgetLanguage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetLanguage*>(p->ptr), _vbox__IUnattended_USCOREgetLanguage);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetLanguageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetLanguageResponse*>(p->ptr), _vbox__IUnattended_USCOREgetLanguageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetLanguageResponse*>(p->ptr), _vbox__IUnattended_USCOREgetLanguageResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetLanguage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetLanguage*>(p->ptr), _vbox__IUnattended_USCOREsetLanguage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetLanguage*>(p->ptr), _vbox__IUnattended_USCOREsetLanguage);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetLanguageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetLanguageResponse*>(p->ptr), _vbox__IUnattended_USCOREsetLanguageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetLanguageResponse*>(p->ptr), _vbox__IUnattended_USCOREsetLanguageResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetCountry:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetCountry*>(p->ptr), _vbox__IUnattended_USCOREgetCountry);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetCountry*>(p->ptr), _vbox__IUnattended_USCOREgetCountry);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetCountryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetCountryResponse*>(p->ptr), _vbox__IUnattended_USCOREgetCountryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetCountryResponse*>(p->ptr), _vbox__IUnattended_USCOREgetCountryResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetCountry:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetCountry*>(p->ptr), _vbox__IUnattended_USCOREsetCountry);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetCountry*>(p->ptr), _vbox__IUnattended_USCOREsetCountry);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetCountryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetCountryResponse*>(p->ptr), _vbox__IUnattended_USCOREsetCountryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetCountryResponse*>(p->ptr), _vbox__IUnattended_USCOREsetCountryResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProxy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProxy*>(p->ptr), _vbox__IUnattended_USCOREgetProxy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProxy*>(p->ptr), _vbox__IUnattended_USCOREgetProxy);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetProxyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetProxyResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProxyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetProxyResponse*>(p->ptr), _vbox__IUnattended_USCOREgetProxyResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetProxy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetProxy*>(p->ptr), _vbox__IUnattended_USCOREsetProxy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetProxy*>(p->ptr), _vbox__IUnattended_USCOREsetProxy);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetProxyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetProxyResponse*>(p->ptr), _vbox__IUnattended_USCOREsetProxyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetProxyResponse*>(p->ptr), _vbox__IUnattended_USCOREsetProxyResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPackageSelectionAdjustments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPackageSelectionAdjustments*>(p->ptr), _vbox__IUnattended_USCOREgetPackageSelectionAdjustments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPackageSelectionAdjustments*>(p->ptr), _vbox__IUnattended_USCOREgetPackageSelectionAdjustments);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPackageSelectionAdjustmentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPackageSelectionAdjustmentsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPackageSelectionAdjustmentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPackageSelectionAdjustmentsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPackageSelectionAdjustmentsResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPackageSelectionAdjustments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPackageSelectionAdjustments*>(p->ptr), _vbox__IUnattended_USCOREsetPackageSelectionAdjustments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPackageSelectionAdjustments*>(p->ptr), _vbox__IUnattended_USCOREsetPackageSelectionAdjustments);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPackageSelectionAdjustmentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPackageSelectionAdjustmentsResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPackageSelectionAdjustmentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPackageSelectionAdjustmentsResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPackageSelectionAdjustmentsResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetHostname:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetHostname*>(p->ptr), _vbox__IUnattended_USCOREgetHostname);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetHostname*>(p->ptr), _vbox__IUnattended_USCOREgetHostname);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetHostnameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetHostnameResponse*>(p->ptr), _vbox__IUnattended_USCOREgetHostnameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetHostnameResponse*>(p->ptr), _vbox__IUnattended_USCOREgetHostnameResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetHostname:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetHostname*>(p->ptr), _vbox__IUnattended_USCOREsetHostname);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetHostname*>(p->ptr), _vbox__IUnattended_USCOREsetHostname);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetHostnameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetHostnameResponse*>(p->ptr), _vbox__IUnattended_USCOREsetHostnameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetHostnameResponse*>(p->ptr), _vbox__IUnattended_USCOREsetHostnameResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAuxiliaryBasePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAuxiliaryBasePath*>(p->ptr), _vbox__IUnattended_USCOREgetAuxiliaryBasePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAuxiliaryBasePath*>(p->ptr), _vbox__IUnattended_USCOREgetAuxiliaryBasePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAuxiliaryBasePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAuxiliaryBasePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAuxiliaryBasePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAuxiliaryBasePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAuxiliaryBasePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAuxiliaryBasePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAuxiliaryBasePath*>(p->ptr), _vbox__IUnattended_USCOREsetAuxiliaryBasePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAuxiliaryBasePath*>(p->ptr), _vbox__IUnattended_USCOREsetAuxiliaryBasePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAuxiliaryBasePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAuxiliaryBasePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAuxiliaryBasePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAuxiliaryBasePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAuxiliaryBasePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetImageIndex:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetImageIndex*>(p->ptr), _vbox__IUnattended_USCOREgetImageIndex);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetImageIndex*>(p->ptr), _vbox__IUnattended_USCOREgetImageIndex);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetImageIndexResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetImageIndexResponse*>(p->ptr), _vbox__IUnattended_USCOREgetImageIndexResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetImageIndexResponse*>(p->ptr), _vbox__IUnattended_USCOREgetImageIndexResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetImageIndex:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetImageIndex*>(p->ptr), _vbox__IUnattended_USCOREsetImageIndex);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetImageIndex*>(p->ptr), _vbox__IUnattended_USCOREsetImageIndex);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetImageIndexResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetImageIndexResponse*>(p->ptr), _vbox__IUnattended_USCOREsetImageIndexResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetImageIndexResponse*>(p->ptr), _vbox__IUnattended_USCOREsetImageIndexResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetScriptTemplatePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREgetScriptTemplatePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREgetScriptTemplatePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetScriptTemplatePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetScriptTemplatePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetScriptTemplatePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetScriptTemplatePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREsetScriptTemplatePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREsetScriptTemplatePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetScriptTemplatePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetScriptTemplatePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetScriptTemplatePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPostInstallScriptTemplatePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallScriptTemplatePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallScriptTemplatePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPostInstallScriptTemplatePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallScriptTemplatePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallScriptTemplatePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPostInstallScriptTemplatePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallScriptTemplatePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallScriptTemplatePath*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallScriptTemplatePath);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPostInstallScriptTemplatePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallScriptTemplatePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallScriptTemplatePathResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallScriptTemplatePathResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPostInstallCommand:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallCommand*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallCommand);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallCommand*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallCommand);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetPostInstallCommandResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallCommandResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallCommandResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetPostInstallCommandResponse*>(p->ptr), _vbox__IUnattended_USCOREgetPostInstallCommandResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPostInstallCommand:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallCommand*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallCommand);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallCommand*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallCommand);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetPostInstallCommandResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallCommandResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallCommandResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetPostInstallCommandResponse*>(p->ptr), _vbox__IUnattended_USCOREsetPostInstallCommandResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetExtraInstallKernelParameters:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetExtraInstallKernelParameters*>(p->ptr), _vbox__IUnattended_USCOREgetExtraInstallKernelParameters);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetExtraInstallKernelParameters*>(p->ptr), _vbox__IUnattended_USCOREgetExtraInstallKernelParameters);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetExtraInstallKernelParametersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetExtraInstallKernelParametersResponse*>(p->ptr), _vbox__IUnattended_USCOREgetExtraInstallKernelParametersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetExtraInstallKernelParametersResponse*>(p->ptr), _vbox__IUnattended_USCOREgetExtraInstallKernelParametersResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetExtraInstallKernelParameters:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetExtraInstallKernelParameters*>(p->ptr), _vbox__IUnattended_USCOREsetExtraInstallKernelParameters);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetExtraInstallKernelParameters*>(p->ptr), _vbox__IUnattended_USCOREsetExtraInstallKernelParameters);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetExtraInstallKernelParametersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetExtraInstallKernelParametersResponse*>(p->ptr), _vbox__IUnattended_USCOREsetExtraInstallKernelParametersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetExtraInstallKernelParametersResponse*>(p->ptr), _vbox__IUnattended_USCOREsetExtraInstallKernelParametersResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSTypeId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSTypeId*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSTypeId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSTypeId*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSTypeId);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSTypeIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSTypeIdResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSTypeIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSTypeIdResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSTypeIdResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSVersion*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSVersion*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSVersion);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSVersionResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSVersionResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSVersionResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSFlavor:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSFlavor*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSFlavor);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSFlavor*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSFlavor);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSFlavorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSFlavorResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSFlavorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSFlavorResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSFlavorResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSLanguages:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSLanguages*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSLanguages);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSLanguages*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSLanguages);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSLanguagesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSLanguagesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSLanguagesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSLanguagesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSLanguagesResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSHints:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSHints*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSHints);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSHints*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSHints);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedOSHintsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSHintsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSHintsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedOSHintsResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedOSHintsResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedImageNames:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageNames*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageNames);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageNames*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageNames);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedImageNamesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageNamesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageNamesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageNamesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageNamesResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedImageIndices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageIndices*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageIndices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageIndices*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageIndices);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetDetectedImageIndicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageIndicesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageIndicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetDetectedImageIndicesResponse*>(p->ptr), _vbox__IUnattended_USCOREgetDetectedImageIndicesResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetIsUnattendedInstallSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetIsUnattendedInstallSupported*>(p->ptr), _vbox__IUnattended_USCOREgetIsUnattendedInstallSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetIsUnattendedInstallSupported*>(p->ptr), _vbox__IUnattended_USCOREgetIsUnattendedInstallSupported);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetIsUnattendedInstallSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetIsUnattendedInstallSupportedResponse*>(p->ptr), _vbox__IUnattended_USCOREgetIsUnattendedInstallSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetIsUnattendedInstallSupportedResponse*>(p->ptr), _vbox__IUnattended_USCOREgetIsUnattendedInstallSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAvoidUpdatesOverNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAvoidUpdatesOverNetwork*>(p->ptr), _vbox__IUnattended_USCOREgetAvoidUpdatesOverNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAvoidUpdatesOverNetwork*>(p->ptr), _vbox__IUnattended_USCOREgetAvoidUpdatesOverNetwork);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREgetAvoidUpdatesOverNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREgetAvoidUpdatesOverNetworkResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAvoidUpdatesOverNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREgetAvoidUpdatesOverNetworkResponse*>(p->ptr), _vbox__IUnattended_USCOREgetAvoidUpdatesOverNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAvoidUpdatesOverNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAvoidUpdatesOverNetwork*>(p->ptr), _vbox__IUnattended_USCOREsetAvoidUpdatesOverNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAvoidUpdatesOverNetwork*>(p->ptr), _vbox__IUnattended_USCOREsetAvoidUpdatesOverNetwork);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREsetAvoidUpdatesOverNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREsetAvoidUpdatesOverNetworkResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAvoidUpdatesOverNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREsetAvoidUpdatesOverNetworkResponse*>(p->ptr), _vbox__IUnattended_USCOREsetAvoidUpdatesOverNetworkResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREdetectIsoOS:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREdetectIsoOS*>(p->ptr), _vbox__IUnattended_USCOREdetectIsoOS);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREdetectIsoOS*>(p->ptr), _vbox__IUnattended_USCOREdetectIsoOS);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREdetectIsoOSResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREdetectIsoOSResponse*>(p->ptr), _vbox__IUnattended_USCOREdetectIsoOSResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREdetectIsoOSResponse*>(p->ptr), _vbox__IUnattended_USCOREdetectIsoOSResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREprepare:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREprepare*>(p->ptr), _vbox__IUnattended_USCOREprepare);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREprepare*>(p->ptr), _vbox__IUnattended_USCOREprepare);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREprepareResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREprepareResponse*>(p->ptr), _vbox__IUnattended_USCOREprepareResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREprepareResponse*>(p->ptr), _vbox__IUnattended_USCOREprepareResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREconstructMedia:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREconstructMedia*>(p->ptr), _vbox__IUnattended_USCOREconstructMedia);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREconstructMedia*>(p->ptr), _vbox__IUnattended_USCOREconstructMedia);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREconstructMediaResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREconstructMediaResponse*>(p->ptr), _vbox__IUnattended_USCOREconstructMediaResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREconstructMediaResponse*>(p->ptr), _vbox__IUnattended_USCOREconstructMediaResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREreconfigureVM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREreconfigureVM*>(p->ptr), _vbox__IUnattended_USCOREreconfigureVM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREreconfigureVM*>(p->ptr), _vbox__IUnattended_USCOREreconfigureVM);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREreconfigureVMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREreconfigureVMResponse*>(p->ptr), _vbox__IUnattended_USCOREreconfigureVMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREreconfigureVMResponse*>(p->ptr), _vbox__IUnattended_USCOREreconfigureVMResponse);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREdone:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREdone*>(p->ptr), _vbox__IUnattended_USCOREdone);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREdone*>(p->ptr), _vbox__IUnattended_USCOREdone);
		break;
	case SOAP_TYPE__vbox__IUnattended_USCOREdoneResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUnattended_USCOREdoneResponse*>(p->ptr), _vbox__IUnattended_USCOREdoneResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUnattended_USCOREdoneResponse*>(p->ptr), _vbox__IUnattended_USCOREdoneResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetGraphicsControllerType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetGraphicsControllerType*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetGraphicsControllerType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetGraphicsControllerType*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetGraphicsControllerType);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetGraphicsControllerTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetGraphicsControllerTypeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetGraphicsControllerTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetGraphicsControllerTypeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetGraphicsControllerTypeResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetGraphicsControllerType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetGraphicsControllerType*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetGraphicsControllerType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetGraphicsControllerType*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetGraphicsControllerType);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetGraphicsControllerTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetGraphicsControllerTypeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetGraphicsControllerTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetGraphicsControllerTypeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetGraphicsControllerTypeResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetVRAMSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetVRAMSize*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetVRAMSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetVRAMSize*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetVRAMSize);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetVRAMSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetVRAMSizeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetVRAMSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetVRAMSizeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetVRAMSizeResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetVRAMSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetVRAMSize*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetVRAMSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetVRAMSize*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetVRAMSize);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetVRAMSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetVRAMSizeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetVRAMSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetVRAMSizeResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetVRAMSizeResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetMonitorCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetMonitorCount*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetMonitorCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetMonitorCount*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetMonitorCount);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREgetMonitorCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetMonitorCountResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetMonitorCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREgetMonitorCountResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREgetMonitorCountResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetMonitorCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetMonitorCount*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetMonitorCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetMonitorCount*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetMonitorCount);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetMonitorCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetMonitorCountResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetMonitorCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetMonitorCountResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetMonitorCountResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetFeature:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetFeature*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetFeature);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetFeature*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetFeature);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREsetFeatureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetFeatureResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetFeatureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREsetFeatureResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREsetFeatureResponse);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREisFeatureEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREisFeatureEnabled*>(p->ptr), _vbox__IGraphicsAdapter_USCOREisFeatureEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREisFeatureEnabled*>(p->ptr), _vbox__IGraphicsAdapter_USCOREisFeatureEnabled);
		break;
	case SOAP_TYPE__vbox__IGraphicsAdapter_USCOREisFeatureEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGraphicsAdapter_USCOREisFeatureEnabledResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREisFeatureEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGraphicsAdapter_USCOREisFeatureEnabledResponse*>(p->ptr), _vbox__IGraphicsAdapter_USCOREisFeatureEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetFirmwareType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetFirmwareType*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetFirmwareType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetFirmwareType*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetFirmwareType);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetFirmwareTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetFirmwareTypeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetFirmwareTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetFirmwareTypeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetFirmwareTypeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetFirmwareType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetFirmwareType*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetFirmwareType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetFirmwareType*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetFirmwareType);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetFirmwareTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetFirmwareTypeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetFirmwareTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetFirmwareTypeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetFirmwareTypeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoFadeIn:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeIn*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeIn);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeIn*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeIn);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoFadeInResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeInResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeInResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeInResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeInResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoFadeIn:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeIn*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeIn);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeIn*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeIn);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoFadeInResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeInResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeInResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeInResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeInResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoFadeOut:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeOut*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeOut);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeOut*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeOut);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoFadeOutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeOutResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeOutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoFadeOutResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoFadeOutResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoFadeOut:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeOut*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeOut);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeOut*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeOut);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoFadeOutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeOutResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeOutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoFadeOutResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoFadeOutResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoDisplayTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoDisplayTime*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoDisplayTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoDisplayTime*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoDisplayTime);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoDisplayTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoDisplayTimeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoDisplayTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoDisplayTimeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoDisplayTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoDisplayTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoDisplayTime*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoDisplayTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoDisplayTime*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoDisplayTime);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoDisplayTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoDisplayTimeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoDisplayTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoDisplayTimeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoDisplayTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoImagePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoImagePath*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoImagePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoImagePath*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoImagePath);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetLogoImagePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoImagePathResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoImagePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetLogoImagePathResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetLogoImagePathResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoImagePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoImagePath*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoImagePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoImagePath*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoImagePath);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetLogoImagePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoImagePathResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoImagePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetLogoImagePathResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetLogoImagePathResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetBootMenuMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetBootMenuMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetBootMenuMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetBootMenuMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetBootMenuMode);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetBootMenuModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetBootMenuModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetBootMenuModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetBootMenuModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetBootMenuModeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetBootMenuMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetBootMenuMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetBootMenuMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetBootMenuMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetBootMenuMode);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetBootMenuModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetBootMenuModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetBootMenuModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetBootMenuModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetBootMenuModeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetACPIEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetACPIEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetACPIEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetACPIEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetACPIEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetACPIEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetACPIEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetACPIEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetACPIEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetACPIEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetACPIEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetACPIEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetACPIEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetACPIEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetACPIEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetACPIEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetACPIEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetACPIEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetACPIEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetACPIEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetIOAPICEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetIOAPICEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetIOAPICEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetIOAPICEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetIOAPICEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetIOAPICEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetIOAPICEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetIOAPICEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetIOAPICEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetIOAPICEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetIOAPICEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetIOAPICEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetIOAPICEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetIOAPICEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetIOAPICEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetIOAPICEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetIOAPICEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetIOAPICEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetIOAPICEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetIOAPICEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetAPICMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAPICMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAPICMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAPICMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAPICMode);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetAPICModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAPICModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAPICModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAPICModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAPICModeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetAPICMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAPICMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAPICMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAPICMode*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAPICMode);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetAPICModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAPICModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAPICModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAPICModeResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAPICModeResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetTimeOffset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetTimeOffset*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetTimeOffset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetTimeOffset*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetTimeOffset);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetTimeOffsetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetTimeOffsetResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetTimeOffsetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetTimeOffsetResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetTimeOffsetResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetTimeOffset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetTimeOffset*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetTimeOffset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetTimeOffset*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetTimeOffset);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetTimeOffsetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetTimeOffsetResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetTimeOffsetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetTimeOffsetResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetTimeOffsetResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetPXEDebugEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetPXEDebugEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetPXEDebugEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetPXEDebugEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetPXEDebugEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetPXEDebugEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetPXEDebugEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetPXEDebugEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetPXEDebugEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetPXEDebugEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetPXEDebugEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetPXEDebugEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetPXEDebugEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetPXEDebugEnabled*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetPXEDebugEnabled);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetPXEDebugEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetPXEDebugEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetPXEDebugEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetPXEDebugEnabledResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetPXEDebugEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndian:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndian*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndian);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndian*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndian);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndianResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndianResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndianResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndianResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetSMBIOSUuidLittleEndianResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndian:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndian*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndian);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndian*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndian);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndianResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndianResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndianResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndianResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetSMBIOSUuidLittleEndianResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetAutoSerialNumGen:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAutoSerialNumGen*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAutoSerialNumGen);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAutoSerialNumGen*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAutoSerialNumGen);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREgetAutoSerialNumGenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAutoSerialNumGenResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAutoSerialNumGenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREgetAutoSerialNumGenResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREgetAutoSerialNumGenResponse);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetAutoSerialNumGen:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAutoSerialNumGen*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAutoSerialNumGen);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAutoSerialNumGen*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAutoSerialNumGen);
		break;
	case SOAP_TYPE__vbox__IFirmwareSettings_USCOREsetAutoSerialNumGenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAutoSerialNumGenResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAutoSerialNumGenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFirmwareSettings_USCOREsetAutoSerialNumGenResponse*>(p->ptr), _vbox__IFirmwareSettings_USCOREsetAutoSerialNumGenResponse);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetType*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetType*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetTypeResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetTypeResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREsetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetType*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetType*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetType);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREsetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetTypeResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetTypeResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetTypeResponse);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREgetLocation:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetLocation*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetLocation);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetLocation*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetLocation);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREgetLocationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetLocationResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetLocationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREgetLocationResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREgetLocationResponse);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREsetLocation:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetLocation*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetLocation);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetLocation*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetLocation);
		break;
	case SOAP_TYPE__vbox__ITrustedPlatformModule_USCOREsetLocationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetLocationResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetLocationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ITrustedPlatformModule_USCOREsetLocationResponse*>(p->ptr), _vbox__ITrustedPlatformModule_USCOREsetLocationResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetId*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetId*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetIdResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetIdResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetFeatures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFeatures*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFeatures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFeatures*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFeatures);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetFeaturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFeaturesResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFeaturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFeaturesResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFeaturesResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetFeatures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFeatures*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFeatures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFeatures*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFeatures);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetFeaturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFeaturesResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFeaturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFeaturesResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFeaturesResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetDestination:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetDestination*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetDestination);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetDestination*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetDestination);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetDestinationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetDestinationResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetDestinationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetDestinationResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetDestinationResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetDestination:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetDestination*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetDestination);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetDestination*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetDestination);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetDestinationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetDestinationResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetDestinationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetDestinationResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetDestinationResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetFilename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFilename*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFilename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFilename*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFilename);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetFilenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFilenameResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFilenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetFilenameResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetFilenameResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetFilename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFilename*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFilename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFilename*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFilename);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetFilenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFilenameResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFilenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetFilenameResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetFilenameResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetMaxTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxTime*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxTime*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxTime);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetMaxTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxTimeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxTimeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxTimeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetMaxTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxTime*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxTime*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxTime);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetMaxTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxTimeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxTimeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxTimeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetMaxFileSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxFileSize*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxFileSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxFileSize*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxFileSize);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetMaxFileSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxFileSizeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxFileSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetMaxFileSizeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetMaxFileSizeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetMaxFileSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxFileSize*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxFileSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxFileSize*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxFileSize);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetMaxFileSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxFileSizeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxFileSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetMaxFileSizeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetMaxFileSizeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetOptions*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetOptions*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetOptions);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetOptionsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetOptionsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetOptions*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetOptions*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetOptions);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetOptionsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetOptionsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetOptionsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioCodec:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioCodec);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioCodec);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioCodecResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioCodecResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioCodecResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioCodec:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioCodec);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioCodec);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioCodecResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioCodecResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioCodecResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioRateControlMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioRateControlMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioRateControlMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioRateControlModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioRateControlModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioRateControlModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioRateControlMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioRateControlMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioRateControlMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioRateControlModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioRateControlModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioRateControlModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioDeadline:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioDeadline);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioDeadline);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioDeadlineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioDeadlineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioDeadlineResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioDeadline:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioDeadline);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioDeadline);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioDeadlineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioDeadlineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioDeadlineResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioHz:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioHz*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioHz);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioHz*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioHz);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioHzResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioHzResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioHzResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioHzResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioHzResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioHz:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioHz*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioHz);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioHz*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioHz);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioHzResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioHzResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioHzResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioHzResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioHzResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioBits:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioBits*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioBits);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioBits*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioBits);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioBitsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioBitsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioBitsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioBitsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioBitsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioBits:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioBits*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioBits);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioBits*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioBits);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioBitsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioBitsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioBitsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioBitsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioBitsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioChannels:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioChannels*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioChannels);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioChannels*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioChannels);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetAudioChannelsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioChannelsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioChannelsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetAudioChannelsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetAudioChannelsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioChannels:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioChannels*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioChannels);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioChannels*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioChannels);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetAudioChannelsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioChannelsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioChannelsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetAudioChannelsResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetAudioChannelsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoCodec:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoCodec);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoCodec);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoCodecResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoCodecResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoCodecResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoCodec:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoCodec);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoCodec*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoCodec);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoCodecResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoCodecResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoCodecResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoCodecResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoDeadline:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoDeadline);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoDeadline);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoDeadlineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoDeadlineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoDeadlineResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoDeadline:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoDeadline);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoDeadline*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoDeadline);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoDeadlineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoDeadlineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoDeadlineResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoDeadlineResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoWidth:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoWidth*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoWidth);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoWidth*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoWidth);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoWidthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoWidthResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoWidthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoWidthResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoWidthResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoWidth:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoWidth*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoWidth);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoWidth*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoWidth);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoWidthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoWidthResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoWidthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoWidthResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoWidthResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoHeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoHeight*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoHeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoHeight*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoHeight);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoHeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoHeightResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoHeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoHeightResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoHeightResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoHeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoHeight*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoHeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoHeight*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoHeight);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoHeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoHeightResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoHeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoHeightResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoHeightResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoRate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRate*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRate*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRate);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoRateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoRate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRate*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRate*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRate);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoRateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoRateControlMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateControlMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateControlMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoRateControlModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateControlModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoRateControlModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoRateControlMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateControlMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateControlMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateControlMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoRateControlModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateControlModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoRateControlModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoRateControlModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoFPS:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoFPS*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoFPS);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoFPS*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoFPS);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoFPSResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoFPSResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoFPSResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoFPSResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoFPSResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoFPS:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoFPS*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoFPS);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoFPS*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoFPS);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoFPSResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoFPSResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoFPSResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoFPSResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoFPSResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoScalingMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoScalingMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoScalingMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoScalingMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoScalingMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREgetVideoScalingModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoScalingModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoScalingModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREgetVideoScalingModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREgetVideoScalingModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoScalingMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoScalingMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoScalingMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoScalingMode*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoScalingMode);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREsetVideoScalingModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoScalingModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoScalingModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREsetVideoScalingModeResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREsetVideoScalingModeResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREisFeatureEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREisFeatureEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREisFeatureEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREisFeatureEnabled*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREisFeatureEnabled);
		break;
	case SOAP_TYPE__vbox__IRecordingScreenSettings_USCOREisFeatureEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREisFeatureEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREisFeatureEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingScreenSettings_USCOREisFeatureEnabledResponse*>(p->ptr), _vbox__IRecordingScreenSettings_USCOREisFeatureEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetPaused:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetPaused*>(p->ptr), _vbox__IRecordingSettings_USCOREgetPaused);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetPaused*>(p->ptr), _vbox__IRecordingSettings_USCOREgetPaused);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetPausedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetPausedResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetPausedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetPausedResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetPausedResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREsetPaused:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREsetPaused*>(p->ptr), _vbox__IRecordingSettings_USCOREsetPaused);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREsetPaused*>(p->ptr), _vbox__IRecordingSettings_USCOREsetPaused);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREsetPausedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREsetPausedResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREsetPausedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREsetPausedResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREsetPausedResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetEnabled*>(p->ptr), _vbox__IRecordingSettings_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetEnabled*>(p->ptr), _vbox__IRecordingSettings_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetEnabledResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetEnabledResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREsetEnabled*>(p->ptr), _vbox__IRecordingSettings_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREsetEnabled*>(p->ptr), _vbox__IRecordingSettings_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREsetEnabledResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREsetEnabledResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetScreens:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreens*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreens);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreens*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreens);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetScreensResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreensResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreensResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreensResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreensResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetProgress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetProgress*>(p->ptr), _vbox__IRecordingSettings_USCOREgetProgress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetProgress*>(p->ptr), _vbox__IRecordingSettings_USCOREgetProgress);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetProgressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetProgressResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetProgressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetProgressResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetProgressResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetScreenSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreenSettings*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreenSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreenSettings*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreenSettings);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREgetScreenSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreenSettingsResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreenSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREgetScreenSettingsResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREgetScreenSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREstart:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREstart*>(p->ptr), _vbox__IRecordingSettings_USCOREstart);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREstart*>(p->ptr), _vbox__IRecordingSettings_USCOREstart);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREstartResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREstartResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREstartResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREstartResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREstartResponse);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREresume:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREresume*>(p->ptr), _vbox__IRecordingSettings_USCOREresume);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREresume*>(p->ptr), _vbox__IRecordingSettings_USCOREresume);
		break;
	case SOAP_TYPE__vbox__IRecordingSettings_USCOREresumeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IRecordingSettings_USCOREresumeResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREresumeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IRecordingSettings_USCOREresumeResponse*>(p->ptr), _vbox__IRecordingSettings_USCOREresumeResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetBus*>(p->ptr), _vbox__IPCIAddress_USCOREgetBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetBus*>(p->ptr), _vbox__IPCIAddress_USCOREgetBus);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetBusResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetBusResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetBusResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetBus*>(p->ptr), _vbox__IPCIAddress_USCOREsetBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetBus*>(p->ptr), _vbox__IPCIAddress_USCOREsetBus);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetBusResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetBusResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetBusResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevice*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevice*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevice);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetDeviceResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetDeviceResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevice*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevice*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevice);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetDeviceResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetDeviceResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetDevFunction:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevFunction*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevFunction);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevFunction*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevFunction);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREgetDevFunctionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevFunctionResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevFunctionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREgetDevFunctionResponse*>(p->ptr), _vbox__IPCIAddress_USCOREgetDevFunctionResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetDevFunction:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevFunction*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevFunction);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevFunction*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevFunction);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREsetDevFunctionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevFunctionResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevFunctionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREsetDevFunctionResponse*>(p->ptr), _vbox__IPCIAddress_USCOREsetDevFunctionResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREasLong:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREasLong*>(p->ptr), _vbox__IPCIAddress_USCOREasLong);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREasLong*>(p->ptr), _vbox__IPCIAddress_USCOREasLong);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREasLongResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREasLongResponse*>(p->ptr), _vbox__IPCIAddress_USCOREasLongResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREasLongResponse*>(p->ptr), _vbox__IPCIAddress_USCOREasLongResponse);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREfromLong:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREfromLong*>(p->ptr), _vbox__IPCIAddress_USCOREfromLong);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREfromLong*>(p->ptr), _vbox__IPCIAddress_USCOREfromLong);
		break;
	case SOAP_TYPE__vbox__IPCIAddress_USCOREfromLongResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPCIAddress_USCOREfromLongResponse*>(p->ptr), _vbox__IPCIAddress_USCOREfromLongResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPCIAddress_USCOREfromLongResponse*>(p->ptr), _vbox__IPCIAddress_USCOREfromLongResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREgetSecureBootEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREgetSecureBootEnabled*>(p->ptr), _vbox__IUefiVariableStore_USCOREgetSecureBootEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREgetSecureBootEnabled*>(p->ptr), _vbox__IUefiVariableStore_USCOREgetSecureBootEnabled);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREgetSecureBootEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREgetSecureBootEnabledResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREgetSecureBootEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREgetSecureBootEnabledResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREgetSecureBootEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREsetSecureBootEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREsetSecureBootEnabled*>(p->ptr), _vbox__IUefiVariableStore_USCOREsetSecureBootEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREsetSecureBootEnabled*>(p->ptr), _vbox__IUefiVariableStore_USCOREsetSecureBootEnabled);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREsetSecureBootEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREsetSecureBootEnabledResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREsetSecureBootEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREsetSecureBootEnabledResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREsetSecureBootEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddVariable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddVariable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddVariable);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddVariableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddVariableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddVariableResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREdeleteVariable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREdeleteVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREdeleteVariable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREdeleteVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREdeleteVariable);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREdeleteVariableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREdeleteVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREdeleteVariableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREdeleteVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREdeleteVariableResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREchangeVariable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREchangeVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREchangeVariable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREchangeVariable*>(p->ptr), _vbox__IUefiVariableStore_USCOREchangeVariable);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREchangeVariableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREchangeVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREchangeVariableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREchangeVariableResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREchangeVariableResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREqueryVariableByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariableByName*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariableByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariableByName*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariableByName);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREqueryVariableByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariableByNameResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariableByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariableByNameResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariableByNameResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREqueryVariables:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariables*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariables);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariables*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariables);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREqueryVariablesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariablesResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariablesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREqueryVariablesResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREqueryVariablesResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollOraclePlatformKey:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollOraclePlatformKey*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollOraclePlatformKey);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollOraclePlatformKey*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollOraclePlatformKey);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollOraclePlatformKeyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollOraclePlatformKeyResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollOraclePlatformKeyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollOraclePlatformKeyResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollOraclePlatformKeyResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollPlatformKey:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollPlatformKey*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollPlatformKey);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollPlatformKey*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollPlatformKey);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollPlatformKeyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollPlatformKeyResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollPlatformKeyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollPlatformKeyResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollPlatformKeyResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddKek:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddKek*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddKek);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddKek*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddKek);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddKekResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddKekResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddKekResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddKekResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddKekResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToDb:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDb*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDb);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDb*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDb);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToDbResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToDbx:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbx*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbx);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbx*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbx);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToDbxResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbxResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbxResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToDbxResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToDbxResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollDefaultMsSignatures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollDefaultMsSignatures*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollDefaultMsSignatures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollDefaultMsSignatures*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollDefaultMsSignatures);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREenrollDefaultMsSignaturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollDefaultMsSignaturesResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollDefaultMsSignaturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREenrollDefaultMsSignaturesResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREenrollDefaultMsSignaturesResponse);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToMok:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToMok*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToMok);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToMok*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToMok);
		break;
	case SOAP_TYPE__vbox__IUefiVariableStore_USCOREaddSignatureToMokResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToMokResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToMokResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUefiVariableStore_USCOREaddSignatureToMokResponse*>(p->ptr), _vbox__IUefiVariableStore_USCOREaddSignatureToMokResponse);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetNonVolatileStorageFile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetNonVolatileStorageFile*>(p->ptr), _vbox__INvramStore_USCOREgetNonVolatileStorageFile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetNonVolatileStorageFile*>(p->ptr), _vbox__INvramStore_USCOREgetNonVolatileStorageFile);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetNonVolatileStorageFileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetNonVolatileStorageFileResponse*>(p->ptr), _vbox__INvramStore_USCOREgetNonVolatileStorageFileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetNonVolatileStorageFileResponse*>(p->ptr), _vbox__INvramStore_USCOREgetNonVolatileStorageFileResponse);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetUefiVariableStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetUefiVariableStore*>(p->ptr), _vbox__INvramStore_USCOREgetUefiVariableStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetUefiVariableStore*>(p->ptr), _vbox__INvramStore_USCOREgetUefiVariableStore);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetUefiVariableStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetUefiVariableStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREgetUefiVariableStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetUefiVariableStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREgetUefiVariableStoreResponse);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetKeyId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetKeyId*>(p->ptr), _vbox__INvramStore_USCOREgetKeyId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetKeyId*>(p->ptr), _vbox__INvramStore_USCOREgetKeyId);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetKeyIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetKeyIdResponse*>(p->ptr), _vbox__INvramStore_USCOREgetKeyIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetKeyIdResponse*>(p->ptr), _vbox__INvramStore_USCOREgetKeyIdResponse);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetKeyStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetKeyStore*>(p->ptr), _vbox__INvramStore_USCOREgetKeyStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetKeyStore*>(p->ptr), _vbox__INvramStore_USCOREgetKeyStore);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREgetKeyStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREgetKeyStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREgetKeyStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREgetKeyStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREgetKeyStoreResponse);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREinitUefiVariableStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREinitUefiVariableStore*>(p->ptr), _vbox__INvramStore_USCOREinitUefiVariableStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREinitUefiVariableStore*>(p->ptr), _vbox__INvramStore_USCOREinitUefiVariableStore);
		break;
	case SOAP_TYPE__vbox__INvramStore_USCOREinitUefiVariableStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INvramStore_USCOREinitUefiVariableStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREinitUefiVariableStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INvramStore_USCOREinitUefiVariableStoreResponse*>(p->ptr), _vbox__INvramStore_USCOREinitUefiVariableStoreResponse);
		break;
	case SOAP_TYPE__vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IResourceStore_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetArchitecture:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetArchitecture*>(p->ptr), _vbox__IPlatform_USCOREgetArchitecture);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetArchitecture*>(p->ptr), _vbox__IPlatform_USCOREgetArchitecture);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetArchitectureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetArchitectureResponse*>(p->ptr), _vbox__IPlatform_USCOREgetArchitectureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetArchitectureResponse*>(p->ptr), _vbox__IPlatform_USCOREgetArchitectureResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetArchitecture:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetArchitecture*>(p->ptr), _vbox__IPlatform_USCOREsetArchitecture);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetArchitecture*>(p->ptr), _vbox__IPlatform_USCOREsetArchitecture);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetArchitectureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetArchitectureResponse*>(p->ptr), _vbox__IPlatform_USCOREsetArchitectureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetArchitectureResponse*>(p->ptr), _vbox__IPlatform_USCOREsetArchitectureResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetProperties*>(p->ptr), _vbox__IPlatform_USCOREgetProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetProperties*>(p->ptr), _vbox__IPlatform_USCOREgetProperties);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetPropertiesResponse*>(p->ptr), _vbox__IPlatform_USCOREgetPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetPropertiesResponse*>(p->ptr), _vbox__IPlatform_USCOREgetPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetX86:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetX86*>(p->ptr), _vbox__IPlatform_USCOREgetX86);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetX86*>(p->ptr), _vbox__IPlatform_USCOREgetX86);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetX86Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetX86Response*>(p->ptr), _vbox__IPlatform_USCOREgetX86Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetX86Response*>(p->ptr), _vbox__IPlatform_USCOREgetX86Response);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetARM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetARM*>(p->ptr), _vbox__IPlatform_USCOREgetARM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetARM*>(p->ptr), _vbox__IPlatform_USCOREgetARM);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetARMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetARMResponse*>(p->ptr), _vbox__IPlatform_USCOREgetARMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetARMResponse*>(p->ptr), _vbox__IPlatform_USCOREgetARMResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetChipsetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetChipsetType*>(p->ptr), _vbox__IPlatform_USCOREgetChipsetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetChipsetType*>(p->ptr), _vbox__IPlatform_USCOREgetChipsetType);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetChipsetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetChipsetTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREgetChipsetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetChipsetTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREgetChipsetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetChipsetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetChipsetType*>(p->ptr), _vbox__IPlatform_USCOREsetChipsetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetChipsetType*>(p->ptr), _vbox__IPlatform_USCOREsetChipsetType);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetChipsetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetChipsetTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREsetChipsetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetChipsetTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREsetChipsetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetIommuType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetIommuType*>(p->ptr), _vbox__IPlatform_USCOREgetIommuType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetIommuType*>(p->ptr), _vbox__IPlatform_USCOREgetIommuType);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetIommuTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetIommuTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREgetIommuTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetIommuTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREgetIommuTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetIommuType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetIommuType*>(p->ptr), _vbox__IPlatform_USCOREsetIommuType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetIommuType*>(p->ptr), _vbox__IPlatform_USCOREsetIommuType);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetIommuTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetIommuTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREsetIommuTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetIommuTypeResponse*>(p->ptr), _vbox__IPlatform_USCOREsetIommuTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetRTCUseUTC:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetRTCUseUTC*>(p->ptr), _vbox__IPlatform_USCOREgetRTCUseUTC);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetRTCUseUTC*>(p->ptr), _vbox__IPlatform_USCOREgetRTCUseUTC);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREgetRTCUseUTCResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREgetRTCUseUTCResponse*>(p->ptr), _vbox__IPlatform_USCOREgetRTCUseUTCResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREgetRTCUseUTCResponse*>(p->ptr), _vbox__IPlatform_USCOREgetRTCUseUTCResponse);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetRTCUseUTC:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetRTCUseUTC*>(p->ptr), _vbox__IPlatform_USCOREsetRTCUseUTC);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetRTCUseUTC*>(p->ptr), _vbox__IPlatform_USCOREsetRTCUseUTC);
		break;
	case SOAP_TYPE__vbox__IPlatform_USCOREsetRTCUseUTCResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatform_USCOREsetRTCUseUTCResponse*>(p->ptr), _vbox__IPlatform_USCOREsetRTCUseUTCResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatform_USCOREsetRTCUseUTCResponse*>(p->ptr), _vbox__IPlatform_USCOREsetRTCUseUTCResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetHPETEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetHPETEnabled*>(p->ptr), _vbox__IPlatformX86_USCOREgetHPETEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetHPETEnabled*>(p->ptr), _vbox__IPlatformX86_USCOREgetHPETEnabled);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetHPETEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetHPETEnabledResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetHPETEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetHPETEnabledResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetHPETEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetHPETEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetHPETEnabled*>(p->ptr), _vbox__IPlatformX86_USCOREsetHPETEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetHPETEnabled*>(p->ptr), _vbox__IPlatformX86_USCOREsetHPETEnabled);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetHPETEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetHPETEnabledResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetHPETEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetHPETEnabledResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetHPETEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUProperty*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUProperty*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetCPUProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUProperty*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUProperty*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetCPUPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinal:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinal*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinal);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinal*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinal);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinalResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinalResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinalResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinalResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafByOrdinalResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUIDLeaf:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeaf);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeaf);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetCPUIDLeafResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetCPUIDLeafResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetCPUIDLeaf:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUIDLeaf);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUIDLeaf);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetCPUIDLeafResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUIDLeafResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetCPUIDLeafResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREremoveCPUIDLeaf:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREremoveCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREremoveCPUIDLeaf);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREremoveCPUIDLeaf*>(p->ptr), _vbox__IPlatformX86_USCOREremoveCPUIDLeaf);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREremoveCPUIDLeafResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREremoveCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREremoveCPUIDLeafResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREremoveCPUIDLeafResponse*>(p->ptr), _vbox__IPlatformX86_USCOREremoveCPUIDLeafResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREremoveAllCPUIDLeaves:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREremoveAllCPUIDLeaves*>(p->ptr), _vbox__IPlatformX86_USCOREremoveAllCPUIDLeaves);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREremoveAllCPUIDLeaves*>(p->ptr), _vbox__IPlatformX86_USCOREremoveAllCPUIDLeaves);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREremoveAllCPUIDLeavesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREremoveAllCPUIDLeavesResponse*>(p->ptr), _vbox__IPlatformX86_USCOREremoveAllCPUIDLeavesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREremoveAllCPUIDLeavesResponse*>(p->ptr), _vbox__IPlatformX86_USCOREremoveAllCPUIDLeavesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetHWVirtExProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetHWVirtExProperty*>(p->ptr), _vbox__IPlatformX86_USCOREgetHWVirtExProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetHWVirtExProperty*>(p->ptr), _vbox__IPlatformX86_USCOREgetHWVirtExProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREgetHWVirtExPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREgetHWVirtExPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetHWVirtExPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREgetHWVirtExPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREgetHWVirtExPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetHWVirtExProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetHWVirtExProperty*>(p->ptr), _vbox__IPlatformX86_USCOREsetHWVirtExProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetHWVirtExProperty*>(p->ptr), _vbox__IPlatformX86_USCOREsetHWVirtExProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformX86_USCOREsetHWVirtExPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformX86_USCOREsetHWVirtExPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetHWVirtExPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformX86_USCOREsetHWVirtExPropertyResponse*>(p->ptr), _vbox__IPlatformX86_USCOREsetHWVirtExPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformARM_USCOREgetCPUProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformARM_USCOREgetCPUProperty*>(p->ptr), _vbox__IPlatformARM_USCOREgetCPUProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformARM_USCOREgetCPUProperty*>(p->ptr), _vbox__IPlatformARM_USCOREgetCPUProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformARM_USCOREgetCPUPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformARM_USCOREgetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformARM_USCOREgetCPUPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformARM_USCOREgetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformARM_USCOREgetCPUPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformARM_USCOREsetCPUProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformARM_USCOREsetCPUProperty*>(p->ptr), _vbox__IPlatformARM_USCOREsetCPUProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformARM_USCOREsetCPUProperty*>(p->ptr), _vbox__IPlatformARM_USCOREsetCPUProperty);
		break;
	case SOAP_TYPE__vbox__IPlatformARM_USCOREsetCPUPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformARM_USCOREsetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformARM_USCOREsetCPUPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformARM_USCOREsetCPUPropertyResponse*>(p->ptr), _vbox__IPlatformARM_USCOREsetCPUPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParent*>(p->ptr), _vbox__IMachine_USCOREgetParent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParent*>(p->ptr), _vbox__IMachine_USCOREgetParent);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParentResponse*>(p->ptr), _vbox__IMachine_USCOREgetParentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParentResponse*>(p->ptr), _vbox__IMachine_USCOREgetParentResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIcon:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIcon*>(p->ptr), _vbox__IMachine_USCOREgetIcon);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIcon*>(p->ptr), _vbox__IMachine_USCOREgetIcon);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIconResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIconResponse*>(p->ptr), _vbox__IMachine_USCOREgetIconResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIconResponse*>(p->ptr), _vbox__IMachine_USCOREgetIconResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIcon:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIcon*>(p->ptr), _vbox__IMachine_USCOREsetIcon);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIcon*>(p->ptr), _vbox__IMachine_USCOREsetIcon);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIconResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIconResponse*>(p->ptr), _vbox__IMachine_USCOREsetIconResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIconResponse*>(p->ptr), _vbox__IMachine_USCOREsetIconResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAccessible:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAccessible*>(p->ptr), _vbox__IMachine_USCOREgetAccessible);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAccessible*>(p->ptr), _vbox__IMachine_USCOREgetAccessible);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAccessibleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAccessibleResponse*>(p->ptr), _vbox__IMachine_USCOREgetAccessibleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAccessibleResponse*>(p->ptr), _vbox__IMachine_USCOREgetAccessibleResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAccessError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAccessError*>(p->ptr), _vbox__IMachine_USCOREgetAccessError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAccessError*>(p->ptr), _vbox__IMachine_USCOREgetAccessError);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAccessErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAccessErrorResponse*>(p->ptr), _vbox__IMachine_USCOREgetAccessErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAccessErrorResponse*>(p->ptr), _vbox__IMachine_USCOREgetAccessErrorResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetName*>(p->ptr), _vbox__IMachine_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetName*>(p->ptr), _vbox__IMachine_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetName*>(p->ptr), _vbox__IMachine_USCOREsetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetName*>(p->ptr), _vbox__IMachine_USCOREsetName);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetNameResponse*>(p->ptr), _vbox__IMachine_USCOREsetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetNameResponse*>(p->ptr), _vbox__IMachine_USCOREsetNameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDescription*>(p->ptr), _vbox__IMachine_USCOREgetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDescription*>(p->ptr), _vbox__IMachine_USCOREgetDescription);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IMachine_USCOREgetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IMachine_USCOREgetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDescription*>(p->ptr), _vbox__IMachine_USCOREsetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDescription*>(p->ptr), _vbox__IMachine_USCOREsetDescription);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDescriptionResponse*>(p->ptr), _vbox__IMachine_USCOREsetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDescriptionResponse*>(p->ptr), _vbox__IMachine_USCOREsetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetId*>(p->ptr), _vbox__IMachine_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetId*>(p->ptr), _vbox__IMachine_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGroups:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGroups*>(p->ptr), _vbox__IMachine_USCOREgetGroups);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGroups*>(p->ptr), _vbox__IMachine_USCOREgetGroups);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGroupsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGroupsResponse*>(p->ptr), _vbox__IMachine_USCOREgetGroupsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGroupsResponse*>(p->ptr), _vbox__IMachine_USCOREgetGroupsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGroups:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGroups*>(p->ptr), _vbox__IMachine_USCOREsetGroups);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGroups*>(p->ptr), _vbox__IMachine_USCOREsetGroups);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGroupsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGroupsResponse*>(p->ptr), _vbox__IMachine_USCOREsetGroupsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGroupsResponse*>(p->ptr), _vbox__IMachine_USCOREsetGroupsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetOSTypeId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetOSTypeId*>(p->ptr), _vbox__IMachine_USCOREgetOSTypeId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetOSTypeId*>(p->ptr), _vbox__IMachine_USCOREgetOSTypeId);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetOSTypeIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetOSTypeIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetOSTypeIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetOSTypeIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetOSTypeIdResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetOSTypeId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetOSTypeId*>(p->ptr), _vbox__IMachine_USCOREsetOSTypeId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetOSTypeId*>(p->ptr), _vbox__IMachine_USCOREsetOSTypeId);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetOSTypeIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetOSTypeIdResponse*>(p->ptr), _vbox__IMachine_USCOREsetOSTypeIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetOSTypeIdResponse*>(p->ptr), _vbox__IMachine_USCOREsetOSTypeIdResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetHardwareVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetHardwareVersion*>(p->ptr), _vbox__IMachine_USCOREgetHardwareVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetHardwareVersion*>(p->ptr), _vbox__IMachine_USCOREgetHardwareVersion);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetHardwareVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetHardwareVersionResponse*>(p->ptr), _vbox__IMachine_USCOREgetHardwareVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetHardwareVersionResponse*>(p->ptr), _vbox__IMachine_USCOREgetHardwareVersionResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHardwareVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHardwareVersion*>(p->ptr), _vbox__IMachine_USCOREsetHardwareVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHardwareVersion*>(p->ptr), _vbox__IMachine_USCOREsetHardwareVersion);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHardwareVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHardwareVersionResponse*>(p->ptr), _vbox__IMachine_USCOREsetHardwareVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHardwareVersionResponse*>(p->ptr), _vbox__IMachine_USCOREsetHardwareVersionResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetHardwareUUID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetHardwareUUID*>(p->ptr), _vbox__IMachine_USCOREgetHardwareUUID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetHardwareUUID*>(p->ptr), _vbox__IMachine_USCOREgetHardwareUUID);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetHardwareUUIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetHardwareUUIDResponse*>(p->ptr), _vbox__IMachine_USCOREgetHardwareUUIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetHardwareUUIDResponse*>(p->ptr), _vbox__IMachine_USCOREgetHardwareUUIDResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHardwareUUID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHardwareUUID*>(p->ptr), _vbox__IMachine_USCOREsetHardwareUUID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHardwareUUID*>(p->ptr), _vbox__IMachine_USCOREsetHardwareUUID);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHardwareUUIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHardwareUUIDResponse*>(p->ptr), _vbox__IMachine_USCOREsetHardwareUUIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHardwareUUIDResponse*>(p->ptr), _vbox__IMachine_USCOREsetHardwareUUIDResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUCount*>(p->ptr), _vbox__IMachine_USCOREgetCPUCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUCount*>(p->ptr), _vbox__IMachine_USCOREgetCPUCount);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUCountResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUCountResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUCountResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUCount*>(p->ptr), _vbox__IMachine_USCOREsetCPUCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUCount*>(p->ptr), _vbox__IMachine_USCOREsetCPUCount);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUCountResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUCountResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUCountResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUHotPlugEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUHotPlugEnabled*>(p->ptr), _vbox__IMachine_USCOREgetCPUHotPlugEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUHotPlugEnabled*>(p->ptr), _vbox__IMachine_USCOREgetCPUHotPlugEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUHotPlugEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUHotPlugEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUHotPlugEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUHotPlugEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUHotPlugEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUHotPlugEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUHotPlugEnabled*>(p->ptr), _vbox__IMachine_USCOREsetCPUHotPlugEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUHotPlugEnabled*>(p->ptr), _vbox__IMachine_USCOREsetCPUHotPlugEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUHotPlugEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUHotPlugEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUHotPlugEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUHotPlugEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUHotPlugEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUExecutionCap:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUExecutionCap*>(p->ptr), _vbox__IMachine_USCOREgetCPUExecutionCap);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUExecutionCap*>(p->ptr), _vbox__IMachine_USCOREgetCPUExecutionCap);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUExecutionCapResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUExecutionCapResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUExecutionCapResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUExecutionCapResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUExecutionCapResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUExecutionCap:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUExecutionCap*>(p->ptr), _vbox__IMachine_USCOREsetCPUExecutionCap);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUExecutionCap*>(p->ptr), _vbox__IMachine_USCOREsetCPUExecutionCap);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUExecutionCapResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUExecutionCapResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUExecutionCapResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUExecutionCapResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUExecutionCapResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUIDPortabilityLevel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUIDPortabilityLevel*>(p->ptr), _vbox__IMachine_USCOREgetCPUIDPortabilityLevel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUIDPortabilityLevel*>(p->ptr), _vbox__IMachine_USCOREgetCPUIDPortabilityLevel);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUIDPortabilityLevelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUIDPortabilityLevelResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUIDPortabilityLevelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUIDPortabilityLevelResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUIDPortabilityLevelResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUIDPortabilityLevel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUIDPortabilityLevel*>(p->ptr), _vbox__IMachine_USCOREsetCPUIDPortabilityLevel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUIDPortabilityLevel*>(p->ptr), _vbox__IMachine_USCOREsetCPUIDPortabilityLevel);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUIDPortabilityLevelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUIDPortabilityLevelResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUIDPortabilityLevelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUIDPortabilityLevelResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUIDPortabilityLevelResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMemorySize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMemorySize*>(p->ptr), _vbox__IMachine_USCOREgetMemorySize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMemorySize*>(p->ptr), _vbox__IMachine_USCOREgetMemorySize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMemorySizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMemorySizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetMemorySizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMemorySizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetMemorySizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetMemorySize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetMemorySize*>(p->ptr), _vbox__IMachine_USCOREsetMemorySize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetMemorySize*>(p->ptr), _vbox__IMachine_USCOREsetMemorySize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetMemorySizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetMemorySizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetMemorySizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetMemorySizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetMemorySizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMemoryBalloonSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMemoryBalloonSize*>(p->ptr), _vbox__IMachine_USCOREgetMemoryBalloonSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMemoryBalloonSize*>(p->ptr), _vbox__IMachine_USCOREgetMemoryBalloonSize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMemoryBalloonSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetMemoryBalloonSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetMemoryBalloonSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetMemoryBalloonSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetMemoryBalloonSize*>(p->ptr), _vbox__IMachine_USCOREsetMemoryBalloonSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetMemoryBalloonSize*>(p->ptr), _vbox__IMachine_USCOREsetMemoryBalloonSize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetMemoryBalloonSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetMemoryBalloonSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetMemoryBalloonSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPageFusionEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPageFusionEnabled*>(p->ptr), _vbox__IMachine_USCOREgetPageFusionEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPageFusionEnabled*>(p->ptr), _vbox__IMachine_USCOREgetPageFusionEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPageFusionEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPageFusionEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetPageFusionEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPageFusionEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetPageFusionEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetPageFusionEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetPageFusionEnabled*>(p->ptr), _vbox__IMachine_USCOREsetPageFusionEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetPageFusionEnabled*>(p->ptr), _vbox__IMachine_USCOREsetPageFusionEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetPageFusionEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetPageFusionEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetPageFusionEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetPageFusionEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetPageFusionEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGraphicsAdapter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGraphicsAdapter*>(p->ptr), _vbox__IMachine_USCOREgetGraphicsAdapter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGraphicsAdapter*>(p->ptr), _vbox__IMachine_USCOREgetGraphicsAdapter);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGraphicsAdapterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGraphicsAdapterResponse*>(p->ptr), _vbox__IMachine_USCOREgetGraphicsAdapterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGraphicsAdapterResponse*>(p->ptr), _vbox__IMachine_USCOREgetGraphicsAdapterResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPlatform:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPlatform*>(p->ptr), _vbox__IMachine_USCOREgetPlatform);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPlatform*>(p->ptr), _vbox__IMachine_USCOREgetPlatform);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPlatformResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPlatformResponse*>(p->ptr), _vbox__IMachine_USCOREgetPlatformResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPlatformResponse*>(p->ptr), _vbox__IMachine_USCOREgetPlatformResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetFirmwareSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetFirmwareSettings*>(p->ptr), _vbox__IMachine_USCOREgetFirmwareSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetFirmwareSettings*>(p->ptr), _vbox__IMachine_USCOREgetFirmwareSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetFirmwareSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetFirmwareSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetFirmwareSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetFirmwareSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetFirmwareSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTrustedPlatformModule:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTrustedPlatformModule*>(p->ptr), _vbox__IMachine_USCOREgetTrustedPlatformModule);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTrustedPlatformModule*>(p->ptr), _vbox__IMachine_USCOREgetTrustedPlatformModule);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTrustedPlatformModuleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTrustedPlatformModuleResponse*>(p->ptr), _vbox__IMachine_USCOREgetTrustedPlatformModuleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTrustedPlatformModuleResponse*>(p->ptr), _vbox__IMachine_USCOREgetTrustedPlatformModuleResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetNonVolatileStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetNonVolatileStore*>(p->ptr), _vbox__IMachine_USCOREgetNonVolatileStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetNonVolatileStore*>(p->ptr), _vbox__IMachine_USCOREgetNonVolatileStore);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetNonVolatileStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetNonVolatileStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetNonVolatileStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetNonVolatileStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetNonVolatileStoreResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetRecordingSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetRecordingSettings*>(p->ptr), _vbox__IMachine_USCOREgetRecordingSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetRecordingSettings*>(p->ptr), _vbox__IMachine_USCOREgetRecordingSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetRecordingSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetRecordingSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetRecordingSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetRecordingSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetRecordingSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPointingHIDType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPointingHIDType*>(p->ptr), _vbox__IMachine_USCOREgetPointingHIDType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPointingHIDType*>(p->ptr), _vbox__IMachine_USCOREgetPointingHIDType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPointingHIDTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPointingHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetPointingHIDTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPointingHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetPointingHIDTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetPointingHIDType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetPointingHIDType*>(p->ptr), _vbox__IMachine_USCOREsetPointingHIDType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetPointingHIDType*>(p->ptr), _vbox__IMachine_USCOREsetPointingHIDType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetPointingHIDTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetPointingHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetPointingHIDTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetPointingHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetPointingHIDTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetKeyboardHIDType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetKeyboardHIDType*>(p->ptr), _vbox__IMachine_USCOREgetKeyboardHIDType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetKeyboardHIDType*>(p->ptr), _vbox__IMachine_USCOREgetKeyboardHIDType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetKeyboardHIDTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetKeyboardHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetKeyboardHIDTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetKeyboardHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetKeyboardHIDTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetKeyboardHIDType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetKeyboardHIDType*>(p->ptr), _vbox__IMachine_USCOREsetKeyboardHIDType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetKeyboardHIDType*>(p->ptr), _vbox__IMachine_USCOREsetKeyboardHIDType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetKeyboardHIDTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetKeyboardHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetKeyboardHIDTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetKeyboardHIDTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetKeyboardHIDTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSnapshotFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotFolder*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotFolder*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotFolder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSnapshotFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotFolderResponse*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotFolderResponse*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotFolderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetSnapshotFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetSnapshotFolder*>(p->ptr), _vbox__IMachine_USCOREsetSnapshotFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetSnapshotFolder*>(p->ptr), _vbox__IMachine_USCOREsetSnapshotFolder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetSnapshotFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetSnapshotFolderResponse*>(p->ptr), _vbox__IMachine_USCOREsetSnapshotFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetSnapshotFolderResponse*>(p->ptr), _vbox__IMachine_USCOREsetSnapshotFolderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVRDEServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVRDEServer*>(p->ptr), _vbox__IMachine_USCOREgetVRDEServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVRDEServer*>(p->ptr), _vbox__IMachine_USCOREgetVRDEServer);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVRDEServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVRDEServerResponse*>(p->ptr), _vbox__IMachine_USCOREgetVRDEServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVRDEServerResponse*>(p->ptr), _vbox__IMachine_USCOREgetVRDEServerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabled*>(p->ptr), _vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabled*>(p->ptr), _vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetEmulatedUSBCardReaderEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabled*>(p->ptr), _vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabled*>(p->ptr), _vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetEmulatedUSBCardReaderEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachments*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachments*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachments);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachmentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllers:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllers*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllers);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllers*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllers);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllersResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllersResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllersResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBDeviceFilters:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBDeviceFilters*>(p->ptr), _vbox__IMachine_USCOREgetUSBDeviceFilters);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBDeviceFilters*>(p->ptr), _vbox__IMachine_USCOREgetUSBDeviceFilters);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBDeviceFiltersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBDeviceFiltersResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBDeviceFiltersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBDeviceFiltersResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBDeviceFiltersResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAudioSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAudioSettings*>(p->ptr), _vbox__IMachine_USCOREgetAudioSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAudioSettings*>(p->ptr), _vbox__IMachine_USCOREgetAudioSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAudioSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAudioSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetAudioSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAudioSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetAudioSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllers:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllers*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllers);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllers*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllers);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllersResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllersResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllersResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsFilePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsFilePath*>(p->ptr), _vbox__IMachine_USCOREgetSettingsFilePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsFilePath*>(p->ptr), _vbox__IMachine_USCOREgetSettingsFilePath);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsFilePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsFilePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsFilePathResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsAuxFilePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsAuxFilePath*>(p->ptr), _vbox__IMachine_USCOREgetSettingsAuxFilePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsAuxFilePath*>(p->ptr), _vbox__IMachine_USCOREgetSettingsAuxFilePath);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsAuxFilePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsAuxFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsAuxFilePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsAuxFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsAuxFilePathResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsModified:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsModified*>(p->ptr), _vbox__IMachine_USCOREgetSettingsModified);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsModified*>(p->ptr), _vbox__IMachine_USCOREgetSettingsModified);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSettingsModifiedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSettingsModifiedResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsModifiedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSettingsModifiedResponse*>(p->ptr), _vbox__IMachine_USCOREgetSettingsModifiedResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionState*>(p->ptr), _vbox__IMachine_USCOREgetSessionState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionState*>(p->ptr), _vbox__IMachine_USCOREgetSessionState);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionStateResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionStateResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionStateResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionName*>(p->ptr), _vbox__IMachine_USCOREgetSessionName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionName*>(p->ptr), _vbox__IMachine_USCOREgetSessionName);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionNameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionPID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionPID*>(p->ptr), _vbox__IMachine_USCOREgetSessionPID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionPID*>(p->ptr), _vbox__IMachine_USCOREgetSessionPID);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSessionPIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSessionPIDResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionPIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSessionPIDResponse*>(p->ptr), _vbox__IMachine_USCOREgetSessionPIDResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetState*>(p->ptr), _vbox__IMachine_USCOREgetState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetState*>(p->ptr), _vbox__IMachine_USCOREgetState);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLastStateChange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLastStateChange*>(p->ptr), _vbox__IMachine_USCOREgetLastStateChange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLastStateChange*>(p->ptr), _vbox__IMachine_USCOREgetLastStateChange);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLastStateChangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLastStateChangeResponse*>(p->ptr), _vbox__IMachine_USCOREgetLastStateChangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLastStateChangeResponse*>(p->ptr), _vbox__IMachine_USCOREgetLastStateChangeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateFilePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateFilePath*>(p->ptr), _vbox__IMachine_USCOREgetStateFilePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateFilePath*>(p->ptr), _vbox__IMachine_USCOREgetStateFilePath);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateFilePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateFilePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateFilePathResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogFolder*>(p->ptr), _vbox__IMachine_USCOREgetLogFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogFolder*>(p->ptr), _vbox__IMachine_USCOREgetLogFolder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogFolderResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogFolderResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogFolderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCurrentSnapshot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCurrentSnapshot*>(p->ptr), _vbox__IMachine_USCOREgetCurrentSnapshot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCurrentSnapshot*>(p->ptr), _vbox__IMachine_USCOREgetCurrentSnapshot);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCurrentSnapshotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCurrentSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREgetCurrentSnapshotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCurrentSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREgetCurrentSnapshotResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSnapshotCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotCount*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotCount*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotCount);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSnapshotCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotCountResponse*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSnapshotCountResponse*>(p->ptr), _vbox__IMachine_USCOREgetSnapshotCountResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCurrentStateModified:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCurrentStateModified*>(p->ptr), _vbox__IMachine_USCOREgetCurrentStateModified);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCurrentStateModified*>(p->ptr), _vbox__IMachine_USCOREgetCurrentStateModified);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCurrentStateModifiedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCurrentStateModifiedResponse*>(p->ptr), _vbox__IMachine_USCOREgetCurrentStateModifiedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCurrentStateModifiedResponse*>(p->ptr), _vbox__IMachine_USCOREgetCurrentStateModifiedResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSharedFolders:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSharedFolders*>(p->ptr), _vbox__IMachine_USCOREgetSharedFolders);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSharedFolders*>(p->ptr), _vbox__IMachine_USCOREgetSharedFolders);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSharedFoldersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IMachine_USCOREgetSharedFoldersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IMachine_USCOREgetSharedFoldersResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetClipboardMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetClipboardMode*>(p->ptr), _vbox__IMachine_USCOREgetClipboardMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetClipboardMode*>(p->ptr), _vbox__IMachine_USCOREgetClipboardMode);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetClipboardModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetClipboardModeResponse*>(p->ptr), _vbox__IMachine_USCOREgetClipboardModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetClipboardModeResponse*>(p->ptr), _vbox__IMachine_USCOREgetClipboardModeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetClipboardMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetClipboardMode*>(p->ptr), _vbox__IMachine_USCOREsetClipboardMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetClipboardMode*>(p->ptr), _vbox__IMachine_USCOREsetClipboardMode);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetClipboardModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetClipboardModeResponse*>(p->ptr), _vbox__IMachine_USCOREsetClipboardModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetClipboardModeResponse*>(p->ptr), _vbox__IMachine_USCOREsetClipboardModeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetClipboardFileTransfersEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetClipboardFileTransfersEnabled*>(p->ptr), _vbox__IMachine_USCOREgetClipboardFileTransfersEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetClipboardFileTransfersEnabled*>(p->ptr), _vbox__IMachine_USCOREgetClipboardFileTransfersEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetClipboardFileTransfersEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetClipboardFileTransfersEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetClipboardFileTransfersEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetClipboardFileTransfersEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetClipboardFileTransfersEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetClipboardFileTransfersEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetClipboardFileTransfersEnabled*>(p->ptr), _vbox__IMachine_USCOREsetClipboardFileTransfersEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetClipboardFileTransfersEnabled*>(p->ptr), _vbox__IMachine_USCOREsetClipboardFileTransfersEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetClipboardFileTransfersEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetClipboardFileTransfersEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetClipboardFileTransfersEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetClipboardFileTransfersEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetClipboardFileTransfersEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDnDMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDnDMode*>(p->ptr), _vbox__IMachine_USCOREgetDnDMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDnDMode*>(p->ptr), _vbox__IMachine_USCOREgetDnDMode);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDnDModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDnDModeResponse*>(p->ptr), _vbox__IMachine_USCOREgetDnDModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDnDModeResponse*>(p->ptr), _vbox__IMachine_USCOREgetDnDModeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDnDMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDnDMode*>(p->ptr), _vbox__IMachine_USCOREsetDnDMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDnDMode*>(p->ptr), _vbox__IMachine_USCOREsetDnDMode);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDnDModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDnDModeResponse*>(p->ptr), _vbox__IMachine_USCOREsetDnDModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDnDModeResponse*>(p->ptr), _vbox__IMachine_USCOREsetDnDModeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterEnabled*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterEnabled*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterEnabled*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterEnabled*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterPort:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPort*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPort);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPort*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPort);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterPortResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPortResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPortResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterPort:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPort*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPort);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPort*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPort);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterPortResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPortResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPortResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPortResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPortResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterAddress*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterAddress*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterAddress);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterAddressResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterAddressResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterAddressResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterAddress*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterAddress*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterAddress);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterAddressResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterAddressResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterAddressResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPassword*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPassword*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPassword);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTeleporterPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTeleporterPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREgetTeleporterPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPassword*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPassword*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPassword);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTeleporterPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTeleporterPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREsetTeleporterPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParavirtProvider:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREgetParavirtProvider);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREgetParavirtProvider);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParavirtProviderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREgetParavirtProviderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREgetParavirtProviderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetParavirtProvider:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREsetParavirtProvider);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREsetParavirtProvider);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetParavirtProviderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREsetParavirtProviderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREsetParavirtProviderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIOCacheEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheEnabled*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheEnabled*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIOCacheEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIOCacheEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheEnabled*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheEnabled*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIOCacheEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIOCacheSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheSize*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheSize*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheSize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetIOCacheSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheSizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetIOCacheSizeResponse*>(p->ptr), _vbox__IMachine_USCOREgetIOCacheSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIOCacheSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheSize*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheSize*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheSize);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetIOCacheSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheSizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetIOCacheSizeResponse*>(p->ptr), _vbox__IMachine_USCOREsetIOCacheSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPCIDeviceAssignments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPCIDeviceAssignments*>(p->ptr), _vbox__IMachine_USCOREgetPCIDeviceAssignments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPCIDeviceAssignments*>(p->ptr), _vbox__IMachine_USCOREgetPCIDeviceAssignments);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetPCIDeviceAssignmentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetPCIDeviceAssignmentsResponse*>(p->ptr), _vbox__IMachine_USCOREgetPCIDeviceAssignmentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetPCIDeviceAssignmentsResponse*>(p->ptr), _vbox__IMachine_USCOREgetPCIDeviceAssignmentsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetBandwidthControl:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetBandwidthControl*>(p->ptr), _vbox__IMachine_USCOREgetBandwidthControl);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetBandwidthControl*>(p->ptr), _vbox__IMachine_USCOREgetBandwidthControl);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetBandwidthControlResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetBandwidthControlResponse*>(p->ptr), _vbox__IMachine_USCOREgetBandwidthControlResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetBandwidthControlResponse*>(p->ptr), _vbox__IMachine_USCOREgetBandwidthControlResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTracingEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTracingEnabled*>(p->ptr), _vbox__IMachine_USCOREgetTracingEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTracingEnabled*>(p->ptr), _vbox__IMachine_USCOREgetTracingEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTracingEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTracingEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetTracingEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTracingEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetTracingEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTracingEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTracingEnabled*>(p->ptr), _vbox__IMachine_USCOREsetTracingEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTracingEnabled*>(p->ptr), _vbox__IMachine_USCOREsetTracingEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTracingEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTracingEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetTracingEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTracingEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetTracingEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTracingConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTracingConfig*>(p->ptr), _vbox__IMachine_USCOREgetTracingConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTracingConfig*>(p->ptr), _vbox__IMachine_USCOREgetTracingConfig);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetTracingConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetTracingConfigResponse*>(p->ptr), _vbox__IMachine_USCOREgetTracingConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetTracingConfigResponse*>(p->ptr), _vbox__IMachine_USCOREgetTracingConfigResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTracingConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTracingConfig*>(p->ptr), _vbox__IMachine_USCOREsetTracingConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTracingConfig*>(p->ptr), _vbox__IMachine_USCOREsetTracingConfig);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetTracingConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetTracingConfigResponse*>(p->ptr), _vbox__IMachine_USCOREsetTracingConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetTracingConfigResponse*>(p->ptr), _vbox__IMachine_USCOREsetTracingConfigResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAllowTracingToAccessVM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAllowTracingToAccessVM*>(p->ptr), _vbox__IMachine_USCOREgetAllowTracingToAccessVM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAllowTracingToAccessVM*>(p->ptr), _vbox__IMachine_USCOREgetAllowTracingToAccessVM);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAllowTracingToAccessVMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAllowTracingToAccessVMResponse*>(p->ptr), _vbox__IMachine_USCOREgetAllowTracingToAccessVMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAllowTracingToAccessVMResponse*>(p->ptr), _vbox__IMachine_USCOREgetAllowTracingToAccessVMResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAllowTracingToAccessVM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAllowTracingToAccessVM*>(p->ptr), _vbox__IMachine_USCOREsetAllowTracingToAccessVM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAllowTracingToAccessVM*>(p->ptr), _vbox__IMachine_USCOREsetAllowTracingToAccessVM);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAllowTracingToAccessVMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAllowTracingToAccessVMResponse*>(p->ptr), _vbox__IMachine_USCOREsetAllowTracingToAccessVMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAllowTracingToAccessVMResponse*>(p->ptr), _vbox__IMachine_USCOREsetAllowTracingToAccessVMResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostartEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostartEnabled*>(p->ptr), _vbox__IMachine_USCOREgetAutostartEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostartEnabled*>(p->ptr), _vbox__IMachine_USCOREgetAutostartEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostartEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostartEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostartEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostartEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostartEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostartEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostartEnabled*>(p->ptr), _vbox__IMachine_USCOREsetAutostartEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostartEnabled*>(p->ptr), _vbox__IMachine_USCOREsetAutostartEnabled);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostartEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostartEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostartEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostartEnabledResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostartEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostartDelay:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostartDelay*>(p->ptr), _vbox__IMachine_USCOREgetAutostartDelay);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostartDelay*>(p->ptr), _vbox__IMachine_USCOREgetAutostartDelay);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostartDelayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostartDelayResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostartDelayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostartDelayResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostartDelayResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostartDelay:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostartDelay*>(p->ptr), _vbox__IMachine_USCOREsetAutostartDelay);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostartDelay*>(p->ptr), _vbox__IMachine_USCOREsetAutostartDelay);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostartDelayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostartDelayResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostartDelayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostartDelayResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostartDelayResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostopType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostopType*>(p->ptr), _vbox__IMachine_USCOREgetAutostopType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostopType*>(p->ptr), _vbox__IMachine_USCOREgetAutostopType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetAutostopTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetAutostopTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostopTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetAutostopTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetAutostopTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostopType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostopType*>(p->ptr), _vbox__IMachine_USCOREsetAutostopType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostopType*>(p->ptr), _vbox__IMachine_USCOREsetAutostopType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutostopTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutostopTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostopTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutostopTypeResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutostopTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDefaultFrontend:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDefaultFrontend*>(p->ptr), _vbox__IMachine_USCOREgetDefaultFrontend);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDefaultFrontend*>(p->ptr), _vbox__IMachine_USCOREgetDefaultFrontend);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetDefaultFrontendResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetDefaultFrontendResponse*>(p->ptr), _vbox__IMachine_USCOREgetDefaultFrontendResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetDefaultFrontendResponse*>(p->ptr), _vbox__IMachine_USCOREgetDefaultFrontendResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDefaultFrontend:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDefaultFrontend*>(p->ptr), _vbox__IMachine_USCOREsetDefaultFrontend);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDefaultFrontend*>(p->ptr), _vbox__IMachine_USCOREsetDefaultFrontend);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetDefaultFrontendResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetDefaultFrontendResponse*>(p->ptr), _vbox__IMachine_USCOREsetDefaultFrontendResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetDefaultFrontendResponse*>(p->ptr), _vbox__IMachine_USCOREsetDefaultFrontendResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBProxyAvailable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBProxyAvailable*>(p->ptr), _vbox__IMachine_USCOREgetUSBProxyAvailable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBProxyAvailable*>(p->ptr), _vbox__IMachine_USCOREgetUSBProxyAvailable);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBProxyAvailableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBProxyAvailableResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBProxyAvailableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBProxyAvailableResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBProxyAvailableResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVMProcessPriority:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVMProcessPriority*>(p->ptr), _vbox__IMachine_USCOREgetVMProcessPriority);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVMProcessPriority*>(p->ptr), _vbox__IMachine_USCOREgetVMProcessPriority);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVMProcessPriorityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVMProcessPriorityResponse*>(p->ptr), _vbox__IMachine_USCOREgetVMProcessPriorityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVMProcessPriorityResponse*>(p->ptr), _vbox__IMachine_USCOREgetVMProcessPriorityResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetVMProcessPriority:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetVMProcessPriority*>(p->ptr), _vbox__IMachine_USCOREsetVMProcessPriority);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetVMProcessPriority*>(p->ptr), _vbox__IMachine_USCOREsetVMProcessPriority);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetVMProcessPriorityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetVMProcessPriorityResponse*>(p->ptr), _vbox__IMachine_USCOREsetVMProcessPriorityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetVMProcessPriorityResponse*>(p->ptr), _vbox__IMachine_USCOREsetVMProcessPriorityResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVMExecutionEngine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVMExecutionEngine*>(p->ptr), _vbox__IMachine_USCOREgetVMExecutionEngine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVMExecutionEngine*>(p->ptr), _vbox__IMachine_USCOREgetVMExecutionEngine);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetVMExecutionEngineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetVMExecutionEngineResponse*>(p->ptr), _vbox__IMachine_USCOREgetVMExecutionEngineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetVMExecutionEngineResponse*>(p->ptr), _vbox__IMachine_USCOREgetVMExecutionEngineResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetVMExecutionEngine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetVMExecutionEngine*>(p->ptr), _vbox__IMachine_USCOREsetVMExecutionEngine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetVMExecutionEngine*>(p->ptr), _vbox__IMachine_USCOREsetVMExecutionEngine);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetVMExecutionEngineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetVMExecutionEngineResponse*>(p->ptr), _vbox__IMachine_USCOREsetVMExecutionEngineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetVMExecutionEngineResponse*>(p->ptr), _vbox__IMachine_USCOREsetVMExecutionEngineResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParavirtDebug:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParavirtDebug*>(p->ptr), _vbox__IMachine_USCOREgetParavirtDebug);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParavirtDebug*>(p->ptr), _vbox__IMachine_USCOREgetParavirtDebug);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParavirtDebugResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParavirtDebugResponse*>(p->ptr), _vbox__IMachine_USCOREgetParavirtDebugResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParavirtDebugResponse*>(p->ptr), _vbox__IMachine_USCOREgetParavirtDebugResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetParavirtDebug:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetParavirtDebug*>(p->ptr), _vbox__IMachine_USCOREsetParavirtDebug);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetParavirtDebug*>(p->ptr), _vbox__IMachine_USCOREsetParavirtDebug);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetParavirtDebugResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetParavirtDebugResponse*>(p->ptr), _vbox__IMachine_USCOREsetParavirtDebugResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetParavirtDebugResponse*>(p->ptr), _vbox__IMachine_USCOREsetParavirtDebugResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUProfile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUProfile*>(p->ptr), _vbox__IMachine_USCOREgetCPUProfile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUProfile*>(p->ptr), _vbox__IMachine_USCOREgetCPUProfile);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUProfileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUProfileResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUProfileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUProfileResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUProfileResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUProfile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUProfile*>(p->ptr), _vbox__IMachine_USCOREsetCPUProfile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUProfile*>(p->ptr), _vbox__IMachine_USCOREsetCPUProfile);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetCPUProfileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetCPUProfileResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUProfileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetCPUProfileResponse*>(p->ptr), _vbox__IMachine_USCOREsetCPUProfileResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateKeyId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyId*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyId*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyId);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateKeyIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyIdResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateKeyStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyStore*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyStore*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyStore);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStateKeyStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStateKeyStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetStateKeyStoreResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogKeyId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyId*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyId*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyId);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogKeyIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyIdResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyIdResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogKeyStore:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyStore*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyStore);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyStore*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyStore);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetLogKeyStoreResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyStoreResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetLogKeyStoreResponse*>(p->ptr), _vbox__IMachine_USCOREgetLogKeyStoreResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestDebugControl:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestDebugControl*>(p->ptr), _vbox__IMachine_USCOREgetGuestDebugControl);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestDebugControl*>(p->ptr), _vbox__IMachine_USCOREgetGuestDebugControl);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestDebugControlResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestDebugControlResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestDebugControlResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestDebugControlResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestDebugControlResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORElockMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORElockMachine*>(p->ptr), _vbox__IMachine_USCORElockMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORElockMachine*>(p->ptr), _vbox__IMachine_USCORElockMachine);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORElockMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORElockMachineResponse*>(p->ptr), _vbox__IMachine_USCORElockMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORElockMachineResponse*>(p->ptr), _vbox__IMachine_USCORElockMachineResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORElaunchVMProcess:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORElaunchVMProcess*>(p->ptr), _vbox__IMachine_USCORElaunchVMProcess);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORElaunchVMProcess*>(p->ptr), _vbox__IMachine_USCORElaunchVMProcess);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORElaunchVMProcessResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORElaunchVMProcessResponse*>(p->ptr), _vbox__IMachine_USCORElaunchVMProcessResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORElaunchVMProcessResponse*>(p->ptr), _vbox__IMachine_USCORElaunchVMProcessResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetBootOrder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetBootOrder*>(p->ptr), _vbox__IMachine_USCOREsetBootOrder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetBootOrder*>(p->ptr), _vbox__IMachine_USCOREsetBootOrder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetBootOrderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetBootOrderResponse*>(p->ptr), _vbox__IMachine_USCOREsetBootOrderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetBootOrderResponse*>(p->ptr), _vbox__IMachine_USCOREsetBootOrderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetBootOrder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetBootOrder*>(p->ptr), _vbox__IMachine_USCOREgetBootOrder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetBootOrder*>(p->ptr), _vbox__IMachine_USCOREgetBootOrder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetBootOrderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetBootOrderResponse*>(p->ptr), _vbox__IMachine_USCOREgetBootOrderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetBootOrderResponse*>(p->ptr), _vbox__IMachine_USCOREgetBootOrderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachDevice*>(p->ptr), _vbox__IMachine_USCOREattachDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachDevice*>(p->ptr), _vbox__IMachine_USCOREattachDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREattachDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREattachDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachDeviceWithoutMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachDeviceWithoutMedium*>(p->ptr), _vbox__IMachine_USCOREattachDeviceWithoutMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachDeviceWithoutMedium*>(p->ptr), _vbox__IMachine_USCOREattachDeviceWithoutMedium);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachDeviceWithoutMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachDeviceWithoutMediumResponse*>(p->ptr), _vbox__IMachine_USCOREattachDeviceWithoutMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachDeviceWithoutMediumResponse*>(p->ptr), _vbox__IMachine_USCOREattachDeviceWithoutMediumResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdetachDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdetachDevice*>(p->ptr), _vbox__IMachine_USCOREdetachDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdetachDevice*>(p->ptr), _vbox__IMachine_USCOREdetachDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdetachDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdetachDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREdetachDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdetachDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREdetachDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREpassthroughDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREpassthroughDevice*>(p->ptr), _vbox__IMachine_USCOREpassthroughDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREpassthroughDevice*>(p->ptr), _vbox__IMachine_USCOREpassthroughDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREpassthroughDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREpassthroughDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREpassthroughDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREpassthroughDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREpassthroughDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREtemporaryEjectDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREtemporaryEjectDevice*>(p->ptr), _vbox__IMachine_USCOREtemporaryEjectDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREtemporaryEjectDevice*>(p->ptr), _vbox__IMachine_USCOREtemporaryEjectDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREtemporaryEjectDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREtemporaryEjectDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREtemporaryEjectDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREtemporaryEjectDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREtemporaryEjectDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREnonRotationalDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREnonRotationalDevice*>(p->ptr), _vbox__IMachine_USCOREnonRotationalDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREnonRotationalDevice*>(p->ptr), _vbox__IMachine_USCOREnonRotationalDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREnonRotationalDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREnonRotationalDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREnonRotationalDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREnonRotationalDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREnonRotationalDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutoDiscardForDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutoDiscardForDevice*>(p->ptr), _vbox__IMachine_USCOREsetAutoDiscardForDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutoDiscardForDevice*>(p->ptr), _vbox__IMachine_USCOREsetAutoDiscardForDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetAutoDiscardForDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetAutoDiscardForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutoDiscardForDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetAutoDiscardForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetAutoDiscardForDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHotPluggableForDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHotPluggableForDevice*>(p->ptr), _vbox__IMachine_USCOREsetHotPluggableForDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHotPluggableForDevice*>(p->ptr), _vbox__IMachine_USCOREsetHotPluggableForDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetHotPluggableForDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetHotPluggableForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetHotPluggableForDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetHotPluggableForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetHotPluggableForDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetBandwidthGroupForDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetBandwidthGroupForDevice*>(p->ptr), _vbox__IMachine_USCOREsetBandwidthGroupForDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetBandwidthGroupForDevice*>(p->ptr), _vbox__IMachine_USCOREsetBandwidthGroupForDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetBandwidthGroupForDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetBandwidthGroupForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetBandwidthGroupForDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetBandwidthGroupForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetBandwidthGroupForDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetNoBandwidthGroupForDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetNoBandwidthGroupForDevice*>(p->ptr), _vbox__IMachine_USCOREsetNoBandwidthGroupForDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetNoBandwidthGroupForDevice*>(p->ptr), _vbox__IMachine_USCOREsetNoBandwidthGroupForDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetNoBandwidthGroupForDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetNoBandwidthGroupForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetNoBandwidthGroupForDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetNoBandwidthGroupForDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREsetNoBandwidthGroupForDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREunmountMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREunmountMedium*>(p->ptr), _vbox__IMachine_USCOREunmountMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREunmountMedium*>(p->ptr), _vbox__IMachine_USCOREunmountMedium);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREunmountMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREunmountMediumResponse*>(p->ptr), _vbox__IMachine_USCOREunmountMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREunmountMediumResponse*>(p->ptr), _vbox__IMachine_USCOREunmountMediumResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREmountMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREmountMedium*>(p->ptr), _vbox__IMachine_USCOREmountMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREmountMedium*>(p->ptr), _vbox__IMachine_USCOREmountMedium);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREmountMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREmountMediumResponse*>(p->ptr), _vbox__IMachine_USCOREmountMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREmountMediumResponse*>(p->ptr), _vbox__IMachine_USCOREmountMediumResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMedium*>(p->ptr), _vbox__IMachine_USCOREgetMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMedium*>(p->ptr), _vbox__IMachine_USCOREgetMedium);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachmentsOfController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsOfController*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsOfController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsOfController*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsOfController);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachmentsOfControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsOfControllerResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsOfControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentsOfControllerResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentsOfControllerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachment:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachment*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachment);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachment*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachment);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetMediumAttachmentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetMediumAttachmentResponse*>(p->ptr), _vbox__IMachine_USCOREgetMediumAttachmentResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachHostPCIDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachHostPCIDevice*>(p->ptr), _vbox__IMachine_USCOREattachHostPCIDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachHostPCIDevice*>(p->ptr), _vbox__IMachine_USCOREattachHostPCIDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREattachHostPCIDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREattachHostPCIDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREattachHostPCIDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREattachHostPCIDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREattachHostPCIDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdetachHostPCIDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdetachHostPCIDevice*>(p->ptr), _vbox__IMachine_USCOREdetachHostPCIDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdetachHostPCIDevice*>(p->ptr), _vbox__IMachine_USCOREdetachHostPCIDevice);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdetachHostPCIDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdetachHostPCIDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREdetachHostPCIDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdetachHostPCIDeviceResponse*>(p->ptr), _vbox__IMachine_USCOREdetachHostPCIDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetNetworkAdapter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetNetworkAdapter*>(p->ptr), _vbox__IMachine_USCOREgetNetworkAdapter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetNetworkAdapter*>(p->ptr), _vbox__IMachine_USCOREgetNetworkAdapter);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetNetworkAdapterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetNetworkAdapterResponse*>(p->ptr), _vbox__IMachine_USCOREgetNetworkAdapterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetNetworkAdapterResponse*>(p->ptr), _vbox__IMachine_USCOREgetNetworkAdapterResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddStorageController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddStorageController*>(p->ptr), _vbox__IMachine_USCOREaddStorageController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddStorageController*>(p->ptr), _vbox__IMachine_USCOREaddStorageController);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddStorageControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddStorageControllerResponse*>(p->ptr), _vbox__IMachine_USCOREaddStorageControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddStorageControllerResponse*>(p->ptr), _vbox__IMachine_USCOREaddStorageControllerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllerByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByName*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByName*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByName);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllerByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByNameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllerByInstance:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByInstance*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByInstance);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByInstance*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByInstance);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetStorageControllerByInstanceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByInstanceResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByInstanceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetStorageControllerByInstanceResponse*>(p->ptr), _vbox__IMachine_USCOREgetStorageControllerByInstanceResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveStorageController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveStorageController*>(p->ptr), _vbox__IMachine_USCOREremoveStorageController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveStorageController*>(p->ptr), _vbox__IMachine_USCOREremoveStorageController);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveStorageControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveStorageControllerResponse*>(p->ptr), _vbox__IMachine_USCOREremoveStorageControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveStorageControllerResponse*>(p->ptr), _vbox__IMachine_USCOREremoveStorageControllerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetStorageControllerBootable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetStorageControllerBootable*>(p->ptr), _vbox__IMachine_USCOREsetStorageControllerBootable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetStorageControllerBootable*>(p->ptr), _vbox__IMachine_USCOREsetStorageControllerBootable);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetStorageControllerBootableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetStorageControllerBootableResponse*>(p->ptr), _vbox__IMachine_USCOREsetStorageControllerBootableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetStorageControllerBootableResponse*>(p->ptr), _vbox__IMachine_USCOREsetStorageControllerBootableResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddUSBController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddUSBController*>(p->ptr), _vbox__IMachine_USCOREaddUSBController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddUSBController*>(p->ptr), _vbox__IMachine_USCOREaddUSBController);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddUSBControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddUSBControllerResponse*>(p->ptr), _vbox__IMachine_USCOREaddUSBControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddUSBControllerResponse*>(p->ptr), _vbox__IMachine_USCOREaddUSBControllerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveUSBController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveUSBController*>(p->ptr), _vbox__IMachine_USCOREremoveUSBController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveUSBController*>(p->ptr), _vbox__IMachine_USCOREremoveUSBController);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveUSBControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveUSBControllerResponse*>(p->ptr), _vbox__IMachine_USCOREremoveUSBControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveUSBControllerResponse*>(p->ptr), _vbox__IMachine_USCOREremoveUSBControllerResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllerByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerByName*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerByName*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerByName);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllerByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerByNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerByNameResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerByNameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllerCountByType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerCountByType*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerCountByType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerCountByType*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerCountByType);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetUSBControllerCountByTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerCountByTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerCountByTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetUSBControllerCountByTypeResponse*>(p->ptr), _vbox__IMachine_USCOREgetUSBControllerCountByTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSerialPort:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSerialPort*>(p->ptr), _vbox__IMachine_USCOREgetSerialPort);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSerialPort*>(p->ptr), _vbox__IMachine_USCOREgetSerialPort);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetSerialPortResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetSerialPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetSerialPortResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetSerialPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetSerialPortResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParallelPort:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParallelPort*>(p->ptr), _vbox__IMachine_USCOREgetParallelPort);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParallelPort*>(p->ptr), _vbox__IMachine_USCOREgetParallelPort);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetParallelPortResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetParallelPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetParallelPortResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetParallelPortResponse*>(p->ptr), _vbox__IMachine_USCOREgetParallelPortResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetExtraDataKeys:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataKeys*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataKeys);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataKeys*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataKeys);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetExtraDataKeysResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataKeysResponse*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataKeysResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataKeysResponse*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataKeysResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetExtraData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetExtraData*>(p->ptr), _vbox__IMachine_USCOREgetExtraData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetExtraData*>(p->ptr), _vbox__IMachine_USCOREgetExtraData);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetExtraDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataResponse*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetExtraDataResponse*>(p->ptr), _vbox__IMachine_USCOREgetExtraDataResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetExtraData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetExtraData*>(p->ptr), _vbox__IMachine_USCOREsetExtraData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetExtraData*>(p->ptr), _vbox__IMachine_USCOREsetExtraData);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetExtraDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetExtraDataResponse*>(p->ptr), _vbox__IMachine_USCOREsetExtraDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetExtraDataResponse*>(p->ptr), _vbox__IMachine_USCOREsetExtraDataResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetSettingsFilePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetSettingsFilePath*>(p->ptr), _vbox__IMachine_USCOREsetSettingsFilePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetSettingsFilePath*>(p->ptr), _vbox__IMachine_USCOREsetSettingsFilePath);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetSettingsFilePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetSettingsFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREsetSettingsFilePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetSettingsFilePathResponse*>(p->ptr), _vbox__IMachine_USCOREsetSettingsFilePathResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsaveSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsaveSettings*>(p->ptr), _vbox__IMachine_USCOREsaveSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsaveSettings*>(p->ptr), _vbox__IMachine_USCOREsaveSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsaveSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsaveSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREsaveSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsaveSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREsaveSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdiscardSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdiscardSettings*>(p->ptr), _vbox__IMachine_USCOREdiscardSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdiscardSettings*>(p->ptr), _vbox__IMachine_USCOREdiscardSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdiscardSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdiscardSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREdiscardSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdiscardSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREdiscardSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREunregister:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREunregister*>(p->ptr), _vbox__IMachine_USCOREunregister);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREunregister*>(p->ptr), _vbox__IMachine_USCOREunregister);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREunregisterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREunregisterResponse*>(p->ptr), _vbox__IMachine_USCOREunregisterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREunregisterResponse*>(p->ptr), _vbox__IMachine_USCOREunregisterResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteConfig*>(p->ptr), _vbox__IMachine_USCOREdeleteConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteConfig*>(p->ptr), _vbox__IMachine_USCOREdeleteConfig);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteConfigResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteConfigResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteConfigResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREexportTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREexportTo*>(p->ptr), _vbox__IMachine_USCOREexportTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREexportTo*>(p->ptr), _vbox__IMachine_USCOREexportTo);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREexportToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREexportToResponse*>(p->ptr), _vbox__IMachine_USCOREexportToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREexportToResponse*>(p->ptr), _vbox__IMachine_USCOREexportToResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREfindSnapshot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREfindSnapshot*>(p->ptr), _vbox__IMachine_USCOREfindSnapshot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREfindSnapshot*>(p->ptr), _vbox__IMachine_USCOREfindSnapshot);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREfindSnapshotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREfindSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREfindSnapshotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREfindSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREfindSnapshotResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcreateSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcreateSharedFolder*>(p->ptr), _vbox__IMachine_USCOREcreateSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcreateSharedFolder*>(p->ptr), _vbox__IMachine_USCOREcreateSharedFolder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcreateSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IMachine_USCOREcreateSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IMachine_USCOREcreateSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveSharedFolder*>(p->ptr), _vbox__IMachine_USCOREremoveSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveSharedFolder*>(p->ptr), _vbox__IMachine_USCOREremoveSharedFolder);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IMachine_USCOREremoveSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IMachine_USCOREremoveSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcanShowConsoleWindow:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcanShowConsoleWindow*>(p->ptr), _vbox__IMachine_USCOREcanShowConsoleWindow);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcanShowConsoleWindow*>(p->ptr), _vbox__IMachine_USCOREcanShowConsoleWindow);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcanShowConsoleWindowResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcanShowConsoleWindowResponse*>(p->ptr), _vbox__IMachine_USCOREcanShowConsoleWindowResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcanShowConsoleWindowResponse*>(p->ptr), _vbox__IMachine_USCOREcanShowConsoleWindowResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREshowConsoleWindow:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREshowConsoleWindow*>(p->ptr), _vbox__IMachine_USCOREshowConsoleWindow);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREshowConsoleWindow*>(p->ptr), _vbox__IMachine_USCOREshowConsoleWindow);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREshowConsoleWindowResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREshowConsoleWindowResponse*>(p->ptr), _vbox__IMachine_USCOREshowConsoleWindowResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREshowConsoleWindowResponse*>(p->ptr), _vbox__IMachine_USCOREshowConsoleWindowResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestProperty*>(p->ptr), _vbox__IMachine_USCOREgetGuestProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestProperty*>(p->ptr), _vbox__IMachine_USCOREgetGuestProperty);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestPropertyValue:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyValue*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyValue);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyValue*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyValue);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestPropertyValueResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyValueResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyValueResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyValueResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyValueResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestPropertyTimestamp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyTimestamp*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyTimestamp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyTimestamp*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyTimestamp);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetGuestPropertyTimestampResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyTimestampResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyTimestampResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetGuestPropertyTimestampResponse*>(p->ptr), _vbox__IMachine_USCOREgetGuestPropertyTimestampResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGuestProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGuestProperty*>(p->ptr), _vbox__IMachine_USCOREsetGuestProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGuestProperty*>(p->ptr), _vbox__IMachine_USCOREsetGuestProperty);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGuestPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGuestPropertyValue:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyValue*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyValue);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyValue*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyValue);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsetGuestPropertyValueResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyValueResponse*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyValueResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsetGuestPropertyValueResponse*>(p->ptr), _vbox__IMachine_USCOREsetGuestPropertyValueResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteGuestProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteGuestProperty*>(p->ptr), _vbox__IMachine_USCOREdeleteGuestProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteGuestProperty*>(p->ptr), _vbox__IMachine_USCOREdeleteGuestProperty);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteGuestPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteGuestPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteGuestPropertyResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteGuestPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREenumerateGuestProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREenumerateGuestProperties*>(p->ptr), _vbox__IMachine_USCOREenumerateGuestProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREenumerateGuestProperties*>(p->ptr), _vbox__IMachine_USCOREenumerateGuestProperties);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREenumerateGuestPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREenumerateGuestPropertiesResponse*>(p->ptr), _vbox__IMachine_USCOREenumerateGuestPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREenumerateGuestPropertiesResponse*>(p->ptr), _vbox__IMachine_USCOREenumerateGuestPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREquerySavedGuestScreenInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREquerySavedGuestScreenInfo*>(p->ptr), _vbox__IMachine_USCOREquerySavedGuestScreenInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREquerySavedGuestScreenInfo*>(p->ptr), _vbox__IMachine_USCOREquerySavedGuestScreenInfo);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREquerySavedGuestScreenInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREquerySavedGuestScreenInfoResponse*>(p->ptr), _vbox__IMachine_USCOREquerySavedGuestScreenInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREquerySavedGuestScreenInfoResponse*>(p->ptr), _vbox__IMachine_USCOREquerySavedGuestScreenInfoResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadSavedThumbnailToArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadSavedThumbnailToArray*>(p->ptr), _vbox__IMachine_USCOREreadSavedThumbnailToArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadSavedThumbnailToArray*>(p->ptr), _vbox__IMachine_USCOREreadSavedThumbnailToArray);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadSavedThumbnailToArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadSavedThumbnailToArrayResponse*>(p->ptr), _vbox__IMachine_USCOREreadSavedThumbnailToArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadSavedThumbnailToArrayResponse*>(p->ptr), _vbox__IMachine_USCOREreadSavedThumbnailToArrayResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREquerySavedScreenshotInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREquerySavedScreenshotInfo*>(p->ptr), _vbox__IMachine_USCOREquerySavedScreenshotInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREquerySavedScreenshotInfo*>(p->ptr), _vbox__IMachine_USCOREquerySavedScreenshotInfo);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREquerySavedScreenshotInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREquerySavedScreenshotInfoResponse*>(p->ptr), _vbox__IMachine_USCOREquerySavedScreenshotInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREquerySavedScreenshotInfoResponse*>(p->ptr), _vbox__IMachine_USCOREquerySavedScreenshotInfoResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadSavedScreenshotToArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadSavedScreenshotToArray*>(p->ptr), _vbox__IMachine_USCOREreadSavedScreenshotToArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadSavedScreenshotToArray*>(p->ptr), _vbox__IMachine_USCOREreadSavedScreenshotToArray);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadSavedScreenshotToArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadSavedScreenshotToArrayResponse*>(p->ptr), _vbox__IMachine_USCOREreadSavedScreenshotToArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadSavedScreenshotToArrayResponse*>(p->ptr), _vbox__IMachine_USCOREreadSavedScreenshotToArrayResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREhotPlugCPU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREhotPlugCPU*>(p->ptr), _vbox__IMachine_USCOREhotPlugCPU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREhotPlugCPU*>(p->ptr), _vbox__IMachine_USCOREhotPlugCPU);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREhotPlugCPUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREhotPlugCPUResponse*>(p->ptr), _vbox__IMachine_USCOREhotPlugCPUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREhotPlugCPUResponse*>(p->ptr), _vbox__IMachine_USCOREhotPlugCPUResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREhotUnplugCPU:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREhotUnplugCPU*>(p->ptr), _vbox__IMachine_USCOREhotUnplugCPU);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREhotUnplugCPU*>(p->ptr), _vbox__IMachine_USCOREhotUnplugCPU);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREhotUnplugCPUResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREhotUnplugCPUResponse*>(p->ptr), _vbox__IMachine_USCOREhotUnplugCPUResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREhotUnplugCPUResponse*>(p->ptr), _vbox__IMachine_USCOREhotUnplugCPUResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUStatus*>(p->ptr), _vbox__IMachine_USCOREgetCPUStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUStatus*>(p->ptr), _vbox__IMachine_USCOREgetCPUStatus);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetCPUStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetCPUStatusResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetCPUStatusResponse*>(p->ptr), _vbox__IMachine_USCOREgetCPUStatusResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEffectiveParavirtProvider:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEffectiveParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREgetEffectiveParavirtProvider);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEffectiveParavirtProvider*>(p->ptr), _vbox__IMachine_USCOREgetEffectiveParavirtProvider);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEffectiveParavirtProviderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEffectiveParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREgetEffectiveParavirtProviderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEffectiveParavirtProviderResponse*>(p->ptr), _vbox__IMachine_USCOREgetEffectiveParavirtProviderResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREqueryLogFilename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREqueryLogFilename*>(p->ptr), _vbox__IMachine_USCOREqueryLogFilename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREqueryLogFilename*>(p->ptr), _vbox__IMachine_USCOREqueryLogFilename);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREqueryLogFilenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREqueryLogFilenameResponse*>(p->ptr), _vbox__IMachine_USCOREqueryLogFilenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREqueryLogFilenameResponse*>(p->ptr), _vbox__IMachine_USCOREqueryLogFilenameResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadLog:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadLog*>(p->ptr), _vbox__IMachine_USCOREreadLog);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadLog*>(p->ptr), _vbox__IMachine_USCOREreadLog);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREreadLogResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREreadLogResponse*>(p->ptr), _vbox__IMachine_USCOREreadLogResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREreadLogResponse*>(p->ptr), _vbox__IMachine_USCOREreadLogResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcloneTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcloneTo*>(p->ptr), _vbox__IMachine_USCOREcloneTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcloneTo*>(p->ptr), _vbox__IMachine_USCOREcloneTo);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcloneToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcloneToResponse*>(p->ptr), _vbox__IMachine_USCOREcloneToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcloneToResponse*>(p->ptr), _vbox__IMachine_USCOREcloneToResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREmoveTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREmoveTo*>(p->ptr), _vbox__IMachine_USCOREmoveTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREmoveTo*>(p->ptr), _vbox__IMachine_USCOREmoveTo);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREmoveToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREmoveToResponse*>(p->ptr), _vbox__IMachine_USCOREmoveToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREmoveToResponse*>(p->ptr), _vbox__IMachine_USCOREmoveToResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsaveState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsaveState*>(p->ptr), _vbox__IMachine_USCOREsaveState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsaveState*>(p->ptr), _vbox__IMachine_USCOREsaveState);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREsaveStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREsaveStateResponse*>(p->ptr), _vbox__IMachine_USCOREsaveStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREsaveStateResponse*>(p->ptr), _vbox__IMachine_USCOREsaveStateResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREadoptSavedState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREadoptSavedState*>(p->ptr), _vbox__IMachine_USCOREadoptSavedState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREadoptSavedState*>(p->ptr), _vbox__IMachine_USCOREadoptSavedState);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREadoptSavedStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREadoptSavedStateResponse*>(p->ptr), _vbox__IMachine_USCOREadoptSavedStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREadoptSavedStateResponse*>(p->ptr), _vbox__IMachine_USCOREadoptSavedStateResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdiscardSavedState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdiscardSavedState*>(p->ptr), _vbox__IMachine_USCOREdiscardSavedState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdiscardSavedState*>(p->ptr), _vbox__IMachine_USCOREdiscardSavedState);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdiscardSavedStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdiscardSavedStateResponse*>(p->ptr), _vbox__IMachine_USCOREdiscardSavedStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdiscardSavedStateResponse*>(p->ptr), _vbox__IMachine_USCOREdiscardSavedStateResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREtakeSnapshot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREtakeSnapshot*>(p->ptr), _vbox__IMachine_USCOREtakeSnapshot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREtakeSnapshot*>(p->ptr), _vbox__IMachine_USCOREtakeSnapshot);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREtakeSnapshotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREtakeSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREtakeSnapshotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREtakeSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREtakeSnapshotResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshot*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshot*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshot);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshotAndAllChildren:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotAndAllChildren*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotAndAllChildren);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotAndAllChildren*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotAndAllChildren);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshotAndAllChildrenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotAndAllChildrenResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotAndAllChildrenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotAndAllChildrenResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotAndAllChildrenResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshotRange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotRange*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotRange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotRange*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotRange);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREdeleteSnapshotRangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotRangeResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotRangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREdeleteSnapshotRangeResponse*>(p->ptr), _vbox__IMachine_USCOREdeleteSnapshotRangeResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORErestoreSnapshot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORErestoreSnapshot*>(p->ptr), _vbox__IMachine_USCORErestoreSnapshot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORErestoreSnapshot*>(p->ptr), _vbox__IMachine_USCORErestoreSnapshot);
		break;
	case SOAP_TYPE__vbox__IMachine_USCORErestoreSnapshotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCORErestoreSnapshotResponse*>(p->ptr), _vbox__IMachine_USCORErestoreSnapshotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCORErestoreSnapshotResponse*>(p->ptr), _vbox__IMachine_USCORErestoreSnapshotResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREapplyDefaults:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREapplyDefaults*>(p->ptr), _vbox__IMachine_USCOREapplyDefaults);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREapplyDefaults*>(p->ptr), _vbox__IMachine_USCOREapplyDefaults);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREapplyDefaultsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREapplyDefaultsResponse*>(p->ptr), _vbox__IMachine_USCOREapplyDefaultsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREapplyDefaultsResponse*>(p->ptr), _vbox__IMachine_USCOREapplyDefaultsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREchangeEncryption:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREchangeEncryption*>(p->ptr), _vbox__IMachine_USCOREchangeEncryption);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREchangeEncryption*>(p->ptr), _vbox__IMachine_USCOREchangeEncryption);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREchangeEncryptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREchangeEncryptionResponse*>(p->ptr), _vbox__IMachine_USCOREchangeEncryptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREchangeEncryptionResponse*>(p->ptr), _vbox__IMachine_USCOREchangeEncryptionResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEncryptionSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEncryptionSettings*>(p->ptr), _vbox__IMachine_USCOREgetEncryptionSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEncryptionSettings*>(p->ptr), _vbox__IMachine_USCOREgetEncryptionSettings);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREgetEncryptionSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREgetEncryptionSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetEncryptionSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREgetEncryptionSettingsResponse*>(p->ptr), _vbox__IMachine_USCOREgetEncryptionSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcheckEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcheckEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREcheckEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcheckEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREcheckEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREcheckEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREcheckEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREcheckEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREcheckEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREcheckEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddEncryptionPasswords:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswords*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswords);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswords*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswords);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREaddEncryptionPasswordsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswordsResponse*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswordsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREaddEncryptionPasswordsResponse*>(p->ptr), _vbox__IMachine_USCOREaddEncryptionPasswordsResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREremoveEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveEncryptionPassword*>(p->ptr), _vbox__IMachine_USCOREremoveEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREremoveEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREremoveEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREremoveEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREremoveEncryptionPasswordResponse*>(p->ptr), _vbox__IMachine_USCOREremoveEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREclearAllEncryptionPasswords:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREclearAllEncryptionPasswords*>(p->ptr), _vbox__IMachine_USCOREclearAllEncryptionPasswords);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREclearAllEncryptionPasswords*>(p->ptr), _vbox__IMachine_USCOREclearAllEncryptionPasswords);
		break;
	case SOAP_TYPE__vbox__IMachine_USCOREclearAllEncryptionPasswordsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMachine_USCOREclearAllEncryptionPasswordsResponse*>(p->ptr), _vbox__IMachine_USCOREclearAllEncryptionPasswordsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMachine_USCOREclearAllEncryptionPasswordsResponse*>(p->ptr), _vbox__IMachine_USCOREclearAllEncryptionPasswordsResponse);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREgetWebcams:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREgetWebcams*>(p->ptr), _vbox__IEmulatedUSB_USCOREgetWebcams);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREgetWebcams*>(p->ptr), _vbox__IEmulatedUSB_USCOREgetWebcams);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREgetWebcamsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREgetWebcamsResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREgetWebcamsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREgetWebcamsResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREgetWebcamsResponse);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREwebcamAttach:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamAttach*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamAttach);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamAttach*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamAttach);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREwebcamAttachResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamAttachResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamAttachResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamAttachResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamAttachResponse);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREwebcamDetach:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamDetach*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamDetach);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamDetach*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamDetach);
		break;
	case SOAP_TYPE__vbox__IEmulatedUSB_USCOREwebcamDetachResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamDetachResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamDetachResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IEmulatedUSB_USCOREwebcamDetachResponse*>(p->ptr), _vbox__IEmulatedUSB_USCOREwebcamDetachResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetMachine*>(p->ptr), _vbox__IConsole_USCOREgetMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetMachine*>(p->ptr), _vbox__IConsole_USCOREgetMachine);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetMachineResponse*>(p->ptr), _vbox__IConsole_USCOREgetMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetMachineResponse*>(p->ptr), _vbox__IConsole_USCOREgetMachineResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetState*>(p->ptr), _vbox__IConsole_USCOREgetState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetState*>(p->ptr), _vbox__IConsole_USCOREgetState);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetStateResponse*>(p->ptr), _vbox__IConsole_USCOREgetStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetStateResponse*>(p->ptr), _vbox__IConsole_USCOREgetStateResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetGuest*>(p->ptr), _vbox__IConsole_USCOREgetGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetGuest*>(p->ptr), _vbox__IConsole_USCOREgetGuest);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetGuestResponse*>(p->ptr), _vbox__IConsole_USCOREgetGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetGuestResponse*>(p->ptr), _vbox__IConsole_USCOREgetGuestResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetKeyboard:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetKeyboard*>(p->ptr), _vbox__IConsole_USCOREgetKeyboard);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetKeyboard*>(p->ptr), _vbox__IConsole_USCOREgetKeyboard);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetKeyboardResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetKeyboardResponse*>(p->ptr), _vbox__IConsole_USCOREgetKeyboardResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetKeyboardResponse*>(p->ptr), _vbox__IConsole_USCOREgetKeyboardResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetMouse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetMouse*>(p->ptr), _vbox__IConsole_USCOREgetMouse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetMouse*>(p->ptr), _vbox__IConsole_USCOREgetMouse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetMouseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetMouseResponse*>(p->ptr), _vbox__IConsole_USCOREgetMouseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetMouseResponse*>(p->ptr), _vbox__IConsole_USCOREgetMouseResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDisplay:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDisplay*>(p->ptr), _vbox__IConsole_USCOREgetDisplay);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDisplay*>(p->ptr), _vbox__IConsole_USCOREgetDisplay);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDisplayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDisplayResponse*>(p->ptr), _vbox__IConsole_USCOREgetDisplayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDisplayResponse*>(p->ptr), _vbox__IConsole_USCOREgetDisplayResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDebugger:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDebugger*>(p->ptr), _vbox__IConsole_USCOREgetDebugger);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDebugger*>(p->ptr), _vbox__IConsole_USCOREgetDebugger);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDebuggerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDebuggerResponse*>(p->ptr), _vbox__IConsole_USCOREgetDebuggerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDebuggerResponse*>(p->ptr), _vbox__IConsole_USCOREgetDebuggerResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetUSBDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetUSBDevices*>(p->ptr), _vbox__IConsole_USCOREgetUSBDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetUSBDevices*>(p->ptr), _vbox__IConsole_USCOREgetUSBDevices);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetUSBDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetUSBDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetUSBDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetUSBDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetUSBDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetRemoteUSBDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetRemoteUSBDevices*>(p->ptr), _vbox__IConsole_USCOREgetRemoteUSBDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetRemoteUSBDevices*>(p->ptr), _vbox__IConsole_USCOREgetRemoteUSBDevices);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetRemoteUSBDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetRemoteUSBDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetRemoteUSBDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetRemoteUSBDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetRemoteUSBDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetSharedFolders:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetSharedFolders*>(p->ptr), _vbox__IConsole_USCOREgetSharedFolders);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetSharedFolders*>(p->ptr), _vbox__IConsole_USCOREgetSharedFolders);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetSharedFoldersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IConsole_USCOREgetSharedFoldersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetSharedFoldersResponse*>(p->ptr), _vbox__IConsole_USCOREgetSharedFoldersResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetVRDEServerInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetVRDEServerInfo*>(p->ptr), _vbox__IConsole_USCOREgetVRDEServerInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetVRDEServerInfo*>(p->ptr), _vbox__IConsole_USCOREgetVRDEServerInfo);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetVRDEServerInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetVRDEServerInfoResponse*>(p->ptr), _vbox__IConsole_USCOREgetVRDEServerInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetVRDEServerInfoResponse*>(p->ptr), _vbox__IConsole_USCOREgetVRDEServerInfoResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetEventSource*>(p->ptr), _vbox__IConsole_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetEventSource*>(p->ptr), _vbox__IConsole_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IConsole_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IConsole_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetAttachedPCIDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetAttachedPCIDevices*>(p->ptr), _vbox__IConsole_USCOREgetAttachedPCIDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetAttachedPCIDevices*>(p->ptr), _vbox__IConsole_USCOREgetAttachedPCIDevices);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetAttachedPCIDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetAttachedPCIDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetAttachedPCIDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetAttachedPCIDevicesResponse*>(p->ptr), _vbox__IConsole_USCOREgetAttachedPCIDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetUseHostClipboard:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetUseHostClipboard*>(p->ptr), _vbox__IConsole_USCOREgetUseHostClipboard);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetUseHostClipboard*>(p->ptr), _vbox__IConsole_USCOREgetUseHostClipboard);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetUseHostClipboardResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetUseHostClipboardResponse*>(p->ptr), _vbox__IConsole_USCOREgetUseHostClipboardResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetUseHostClipboardResponse*>(p->ptr), _vbox__IConsole_USCOREgetUseHostClipboardResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREsetUseHostClipboard:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREsetUseHostClipboard*>(p->ptr), _vbox__IConsole_USCOREsetUseHostClipboard);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREsetUseHostClipboard*>(p->ptr), _vbox__IConsole_USCOREsetUseHostClipboard);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREsetUseHostClipboardResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREsetUseHostClipboardResponse*>(p->ptr), _vbox__IConsole_USCOREsetUseHostClipboardResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREsetUseHostClipboardResponse*>(p->ptr), _vbox__IConsole_USCOREsetUseHostClipboardResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetEmulatedUSB:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetEmulatedUSB*>(p->ptr), _vbox__IConsole_USCOREgetEmulatedUSB);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetEmulatedUSB*>(p->ptr), _vbox__IConsole_USCOREgetEmulatedUSB);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetEmulatedUSBResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetEmulatedUSBResponse*>(p->ptr), _vbox__IConsole_USCOREgetEmulatedUSBResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetEmulatedUSBResponse*>(p->ptr), _vbox__IConsole_USCOREgetEmulatedUSBResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerUp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerUp*>(p->ptr), _vbox__IConsole_USCOREpowerUp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerUp*>(p->ptr), _vbox__IConsole_USCOREpowerUp);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerUpResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerUpResponse*>(p->ptr), _vbox__IConsole_USCOREpowerUpResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerUpResponse*>(p->ptr), _vbox__IConsole_USCOREpowerUpResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerUpPaused:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerUpPaused*>(p->ptr), _vbox__IConsole_USCOREpowerUpPaused);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerUpPaused*>(p->ptr), _vbox__IConsole_USCOREpowerUpPaused);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerUpPausedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerUpPausedResponse*>(p->ptr), _vbox__IConsole_USCOREpowerUpPausedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerUpPausedResponse*>(p->ptr), _vbox__IConsole_USCOREpowerUpPausedResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerDown:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerDown*>(p->ptr), _vbox__IConsole_USCOREpowerDown);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerDown*>(p->ptr), _vbox__IConsole_USCOREpowerDown);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerDownResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerDownResponse*>(p->ptr), _vbox__IConsole_USCOREpowerDownResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerDownResponse*>(p->ptr), _vbox__IConsole_USCOREpowerDownResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREreset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREreset*>(p->ptr), _vbox__IConsole_USCOREreset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREreset*>(p->ptr), _vbox__IConsole_USCOREreset);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREresetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREresetResponse*>(p->ptr), _vbox__IConsole_USCOREresetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREresetResponse*>(p->ptr), _vbox__IConsole_USCOREresetResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpause:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpause*>(p->ptr), _vbox__IConsole_USCOREpause);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpause*>(p->ptr), _vbox__IConsole_USCOREpause);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpauseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpauseResponse*>(p->ptr), _vbox__IConsole_USCOREpauseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpauseResponse*>(p->ptr), _vbox__IConsole_USCOREpauseResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREresume:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREresume*>(p->ptr), _vbox__IConsole_USCOREresume);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREresume*>(p->ptr), _vbox__IConsole_USCOREresume);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREresumeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREresumeResponse*>(p->ptr), _vbox__IConsole_USCOREresumeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREresumeResponse*>(p->ptr), _vbox__IConsole_USCOREresumeResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerButton:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerButton*>(p->ptr), _vbox__IConsole_USCOREpowerButton);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerButton*>(p->ptr), _vbox__IConsole_USCOREpowerButton);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREpowerButtonResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREpowerButtonResponse*>(p->ptr), _vbox__IConsole_USCOREpowerButtonResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREpowerButtonResponse*>(p->ptr), _vbox__IConsole_USCOREpowerButtonResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREsleepButton:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREsleepButton*>(p->ptr), _vbox__IConsole_USCOREsleepButton);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREsleepButton*>(p->ptr), _vbox__IConsole_USCOREsleepButton);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREsleepButtonResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREsleepButtonResponse*>(p->ptr), _vbox__IConsole_USCOREsleepButtonResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREsleepButtonResponse*>(p->ptr), _vbox__IConsole_USCOREsleepButtonResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetPowerButtonHandled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetPowerButtonHandled*>(p->ptr), _vbox__IConsole_USCOREgetPowerButtonHandled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetPowerButtonHandled*>(p->ptr), _vbox__IConsole_USCOREgetPowerButtonHandled);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetPowerButtonHandledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetPowerButtonHandledResponse*>(p->ptr), _vbox__IConsole_USCOREgetPowerButtonHandledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetPowerButtonHandledResponse*>(p->ptr), _vbox__IConsole_USCOREgetPowerButtonHandledResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetGuestEnteredACPIMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetGuestEnteredACPIMode*>(p->ptr), _vbox__IConsole_USCOREgetGuestEnteredACPIMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetGuestEnteredACPIMode*>(p->ptr), _vbox__IConsole_USCOREgetGuestEnteredACPIMode);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetGuestEnteredACPIModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetGuestEnteredACPIModeResponse*>(p->ptr), _vbox__IConsole_USCOREgetGuestEnteredACPIModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetGuestEnteredACPIModeResponse*>(p->ptr), _vbox__IConsole_USCOREgetGuestEnteredACPIModeResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDeviceActivity:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDeviceActivity*>(p->ptr), _vbox__IConsole_USCOREgetDeviceActivity);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDeviceActivity*>(p->ptr), _vbox__IConsole_USCOREgetDeviceActivity);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREgetDeviceActivityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREgetDeviceActivityResponse*>(p->ptr), _vbox__IConsole_USCOREgetDeviceActivityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREgetDeviceActivityResponse*>(p->ptr), _vbox__IConsole_USCOREgetDeviceActivityResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREattachUSBDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREattachUSBDevice*>(p->ptr), _vbox__IConsole_USCOREattachUSBDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREattachUSBDevice*>(p->ptr), _vbox__IConsole_USCOREattachUSBDevice);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREattachUSBDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREattachUSBDeviceResponse*>(p->ptr), _vbox__IConsole_USCOREattachUSBDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREattachUSBDeviceResponse*>(p->ptr), _vbox__IConsole_USCOREattachUSBDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREdetachUSBDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREdetachUSBDevice*>(p->ptr), _vbox__IConsole_USCOREdetachUSBDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREdetachUSBDevice*>(p->ptr), _vbox__IConsole_USCOREdetachUSBDevice);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREdetachUSBDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREdetachUSBDeviceResponse*>(p->ptr), _vbox__IConsole_USCOREdetachUSBDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREdetachUSBDeviceResponse*>(p->ptr), _vbox__IConsole_USCOREdetachUSBDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREfindUSBDeviceByAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByAddress*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByAddress*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByAddress);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREfindUSBDeviceByAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByAddressResponse*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByAddressResponse*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByAddressResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREfindUSBDeviceById:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceById*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceById);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceById*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceById);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREfindUSBDeviceByIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByIdResponse*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREfindUSBDeviceByIdResponse*>(p->ptr), _vbox__IConsole_USCOREfindUSBDeviceByIdResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREcreateSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREcreateSharedFolder*>(p->ptr), _vbox__IConsole_USCOREcreateSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREcreateSharedFolder*>(p->ptr), _vbox__IConsole_USCOREcreateSharedFolder);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREcreateSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IConsole_USCOREcreateSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREcreateSharedFolderResponse*>(p->ptr), _vbox__IConsole_USCOREcreateSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREremoveSharedFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREremoveSharedFolder*>(p->ptr), _vbox__IConsole_USCOREremoveSharedFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREremoveSharedFolder*>(p->ptr), _vbox__IConsole_USCOREremoveSharedFolder);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREremoveSharedFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IConsole_USCOREremoveSharedFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREremoveSharedFolderResponse*>(p->ptr), _vbox__IConsole_USCOREremoveSharedFolderResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREteleport:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREteleport*>(p->ptr), _vbox__IConsole_USCOREteleport);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREteleport*>(p->ptr), _vbox__IConsole_USCOREteleport);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREteleportResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREteleportResponse*>(p->ptr), _vbox__IConsole_USCOREteleportResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREteleportResponse*>(p->ptr), _vbox__IConsole_USCOREteleportResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREaddEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPassword*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPassword*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREaddEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswordResponse*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswordResponse*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREaddEncryptionPasswords:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswords*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswords);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswords*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswords);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREaddEncryptionPasswordsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswordsResponse*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswordsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREaddEncryptionPasswordsResponse*>(p->ptr), _vbox__IConsole_USCOREaddEncryptionPasswordsResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREremoveEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREremoveEncryptionPassword*>(p->ptr), _vbox__IConsole_USCOREremoveEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREremoveEncryptionPassword*>(p->ptr), _vbox__IConsole_USCOREremoveEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREremoveEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREremoveEncryptionPasswordResponse*>(p->ptr), _vbox__IConsole_USCOREremoveEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREremoveEncryptionPasswordResponse*>(p->ptr), _vbox__IConsole_USCOREremoveEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREclearAllEncryptionPasswords:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREclearAllEncryptionPasswords*>(p->ptr), _vbox__IConsole_USCOREclearAllEncryptionPasswords);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREclearAllEncryptionPasswords*>(p->ptr), _vbox__IConsole_USCOREclearAllEncryptionPasswords);
		break;
	case SOAP_TYPE__vbox__IConsole_USCOREclearAllEncryptionPasswordsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IConsole_USCOREclearAllEncryptionPasswordsResponse*>(p->ptr), _vbox__IConsole_USCOREclearAllEncryptionPasswordsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IConsole_USCOREclearAllEncryptionPasswordsResponse*>(p->ptr), _vbox__IConsole_USCOREclearAllEncryptionPasswordsResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetShortName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetShortName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetShortName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetShortName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetShortName);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetShortNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetShortNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetShortNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetShortNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetShortNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetId*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetId*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIdResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIdResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetNetworkName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkName*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkName);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetNetworkNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkNameResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetDHCPEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetDHCPEnabled*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetDHCPEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetDHCPEnabled*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetDHCPEnabled);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetDHCPEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetDHCPEnabledResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetDHCPEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetDHCPEnabledResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetDHCPEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPAddress*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPAddress*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPAddress);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPAddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPAddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPAddressResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetNetworkMask:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkMask*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkMask);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkMask*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkMask);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetNetworkMaskResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkMaskResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetNetworkMaskResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetNetworkMaskResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6Supported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6Supported*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6Supported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6Supported*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6Supported);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6SupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6SupportedResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6SupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6SupportedResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6SupportedResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6Address:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6Address*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6Address);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6Address*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6Address);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6AddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6AddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6AddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6AddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6AddressResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLength:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLength*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLength);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLength*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLength);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLengthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLengthResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLengthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLengthResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetIPV6NetworkMaskPrefixLengthResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetHardwareAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetHardwareAddress*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetHardwareAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetHardwareAddress*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetHardwareAddress);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetHardwareAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetHardwareAddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetHardwareAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetHardwareAddressResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetHardwareAddressResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetMediumType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetMediumType*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetMediumType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetMediumType*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetMediumType);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetMediumTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetMediumTypeResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetMediumTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetMediumTypeResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetMediumTypeResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetStatus*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetStatus*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetStatus);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetStatusResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetStatusResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetStatusResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetInterfaceType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetInterfaceType*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetInterfaceType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetInterfaceType*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetInterfaceType);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetInterfaceTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetInterfaceTypeResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetInterfaceTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetInterfaceTypeResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetInterfaceTypeResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetWireless:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetWireless*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetWireless);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetWireless*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetWireless);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREgetWirelessResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetWirelessResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetWirelessResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREgetWirelessResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREgetWirelessResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableStaticIPConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfig*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfig*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfig);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableStaticIPConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6Response*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6Response*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableStaticIPConfigV6Response);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableDynamicIPConfig:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableDynamicIPConfig*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableDynamicIPConfig);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableDynamicIPConfig*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableDynamicIPConfig);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREenableDynamicIPConfigResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableDynamicIPConfigResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableDynamicIPConfigResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREenableDynamicIPConfigResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREenableDynamicIPConfigResponse);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREDHCPRediscover:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREDHCPRediscover*>(p->ptr), _vbox__IHostNetworkInterface_USCOREDHCPRediscover);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREDHCPRediscover*>(p->ptr), _vbox__IHostNetworkInterface_USCOREDHCPRediscover);
		break;
	case SOAP_TYPE__vbox__IHostNetworkInterface_USCOREDHCPRediscoverResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostNetworkInterface_USCOREDHCPRediscoverResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREDHCPRediscoverResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostNetworkInterface_USCOREDHCPRediscoverResponse*>(p->ptr), _vbox__IHostNetworkInterface_USCOREDHCPRediscoverResponse);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetName*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetName*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetNameResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetNameResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetPath*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetPath*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetPath);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetPathResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetPathResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetPathResponse);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetAlias:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetAlias*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetAlias);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetAlias*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetAlias);
		break;
	case SOAP_TYPE__vbox__IHostVideoInputDevice_USCOREgetAliasResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetAliasResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetAliasResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostVideoInputDevice_USCOREgetAliasResponse*>(p->ptr), _vbox__IHostVideoInputDevice_USCOREgetAliasResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetName*>(p->ptr), _vbox__IUpdateAgent_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetName*>(p->ptr), _vbox__IUpdateAgent_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetNameResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetNameResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEventSource*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEventSource*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetOrder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetOrder*>(p->ptr), _vbox__IUpdateAgent_USCOREgetOrder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetOrder*>(p->ptr), _vbox__IUpdateAgent_USCOREgetOrder);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetOrderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetOrderResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetOrderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetOrderResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetOrderResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetDependsOn:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDependsOn*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDependsOn);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDependsOn*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDependsOn);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetDependsOnResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDependsOnResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDependsOnResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDependsOnResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDependsOnResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetVersion*>(p->ptr), _vbox__IUpdateAgent_USCOREgetVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetVersion*>(p->ptr), _vbox__IUpdateAgent_USCOREgetVersion);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetVersionResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetVersionResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetVersionResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetDownloadUrl:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDownloadUrl*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDownloadUrl);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDownloadUrl*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDownloadUrl);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetDownloadUrlResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDownloadUrlResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDownloadUrlResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetDownloadUrlResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetDownloadUrlResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetWebUrl:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetWebUrl*>(p->ptr), _vbox__IUpdateAgent_USCOREgetWebUrl);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetWebUrl*>(p->ptr), _vbox__IUpdateAgent_USCOREgetWebUrl);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetWebUrlResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetWebUrlResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetWebUrlResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetWebUrlResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetWebUrlResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetReleaseNotes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetReleaseNotes*>(p->ptr), _vbox__IUpdateAgent_USCOREgetReleaseNotes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetReleaseNotes*>(p->ptr), _vbox__IUpdateAgent_USCOREgetReleaseNotes);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetReleaseNotesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetReleaseNotesResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetReleaseNotesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetReleaseNotesResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetReleaseNotesResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEnabled*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEnabled*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEnabledResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetEnabledResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetEnabled*>(p->ptr), _vbox__IUpdateAgent_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetEnabled*>(p->ptr), _vbox__IUpdateAgent_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetEnabledResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetEnabledResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetHidden:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetHidden*>(p->ptr), _vbox__IUpdateAgent_USCOREgetHidden);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetHidden*>(p->ptr), _vbox__IUpdateAgent_USCOREgetHidden);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetHiddenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetHiddenResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetHiddenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetHiddenResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetHiddenResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetState*>(p->ptr), _vbox__IUpdateAgent_USCOREgetState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetState*>(p->ptr), _vbox__IUpdateAgent_USCOREgetState);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetStateResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetStateResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetStateResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetCheckFrequency:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckFrequency*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckFrequency);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckFrequency*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckFrequency);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetCheckFrequencyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckFrequencyResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckFrequencyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckFrequencyResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckFrequencyResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetCheckFrequency:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetCheckFrequency*>(p->ptr), _vbox__IUpdateAgent_USCOREsetCheckFrequency);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetCheckFrequency*>(p->ptr), _vbox__IUpdateAgent_USCOREsetCheckFrequency);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetCheckFrequencyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetCheckFrequencyResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetCheckFrequencyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetCheckFrequencyResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetCheckFrequencyResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetChannel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetChannel*>(p->ptr), _vbox__IUpdateAgent_USCOREgetChannel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetChannel*>(p->ptr), _vbox__IUpdateAgent_USCOREgetChannel);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetChannelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetChannelResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetChannelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetChannelResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetChannelResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetChannel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetChannel*>(p->ptr), _vbox__IUpdateAgent_USCOREsetChannel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetChannel*>(p->ptr), _vbox__IUpdateAgent_USCOREsetChannel);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetChannelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetChannelResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetChannelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetChannelResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetChannelResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetRepositoryURL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetRepositoryURL*>(p->ptr), _vbox__IUpdateAgent_USCOREgetRepositoryURL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetRepositoryURL*>(p->ptr), _vbox__IUpdateAgent_USCOREgetRepositoryURL);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetRepositoryURLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetRepositoryURLResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetRepositoryURLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetRepositoryURLResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetRepositoryURLResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetRepositoryURL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetRepositoryURL*>(p->ptr), _vbox__IUpdateAgent_USCOREsetRepositoryURL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetRepositoryURL*>(p->ptr), _vbox__IUpdateAgent_USCOREsetRepositoryURL);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREsetRepositoryURLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREsetRepositoryURLResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetRepositoryURLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREsetRepositoryURLResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREsetRepositoryURLResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetLastCheckDate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetLastCheckDate*>(p->ptr), _vbox__IUpdateAgent_USCOREgetLastCheckDate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetLastCheckDate*>(p->ptr), _vbox__IUpdateAgent_USCOREgetLastCheckDate);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetLastCheckDateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetLastCheckDateResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetLastCheckDateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetLastCheckDateResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetLastCheckDateResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetCheckCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckCount*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckCount*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckCount);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetCheckCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckCountResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetCheckCountResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetCheckCountResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetIsCheckNeeded:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetIsCheckNeeded*>(p->ptr), _vbox__IUpdateAgent_USCOREgetIsCheckNeeded);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetIsCheckNeeded*>(p->ptr), _vbox__IUpdateAgent_USCOREgetIsCheckNeeded);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetIsCheckNeededResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetIsCheckNeededResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetIsCheckNeededResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetIsCheckNeededResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetIsCheckNeededResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetSupportedChannels:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetSupportedChannels*>(p->ptr), _vbox__IUpdateAgent_USCOREgetSupportedChannels);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetSupportedChannels*>(p->ptr), _vbox__IUpdateAgent_USCOREgetSupportedChannels);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREgetSupportedChannelsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREgetSupportedChannelsResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetSupportedChannelsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREgetSupportedChannelsResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREgetSupportedChannelsResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREcheckFor:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREcheckFor*>(p->ptr), _vbox__IUpdateAgent_USCOREcheckFor);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREcheckFor*>(p->ptr), _vbox__IUpdateAgent_USCOREcheckFor);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREcheckForResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREcheckForResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREcheckForResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREcheckForResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREcheckForResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREdownload:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREdownload*>(p->ptr), _vbox__IUpdateAgent_USCOREdownload);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREdownload*>(p->ptr), _vbox__IUpdateAgent_USCOREdownload);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREdownloadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREdownloadResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREdownloadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREdownloadResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREdownloadResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREinstall:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREinstall*>(p->ptr), _vbox__IUpdateAgent_USCOREinstall);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREinstall*>(p->ptr), _vbox__IUpdateAgent_USCOREinstall);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCOREinstallResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCOREinstallResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREinstallResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCOREinstallResponse*>(p->ptr), _vbox__IUpdateAgent_USCOREinstallResponse);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCORErollback:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCORErollback*>(p->ptr), _vbox__IUpdateAgent_USCORErollback);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCORErollback*>(p->ptr), _vbox__IUpdateAgent_USCORErollback);
		break;
	case SOAP_TYPE__vbox__IUpdateAgent_USCORErollbackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IUpdateAgent_USCORErollbackResponse*>(p->ptr), _vbox__IUpdateAgent_USCORErollbackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IUpdateAgent_USCORErollbackResponse*>(p->ptr), _vbox__IUpdateAgent_USCORErollbackResponse);
		break;
	case SOAP_TYPE__vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IHostUpdateAgent_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetDrivePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetDrivePath*>(p->ptr), _vbox__IHostDrive_USCOREgetDrivePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetDrivePath*>(p->ptr), _vbox__IHostDrive_USCOREgetDrivePath);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetDrivePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetDrivePathResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetDrivePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetDrivePathResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetDrivePathResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetPartitioningType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitioningType*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitioningType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitioningType*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitioningType);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetPartitioningTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitioningTypeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitioningTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitioningTypeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitioningTypeResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetUuid:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetUuid*>(p->ptr), _vbox__IHostDrive_USCOREgetUuid);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetUuid*>(p->ptr), _vbox__IHostDrive_USCOREgetUuid);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetUuidResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetUuidResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetUuidResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetUuidResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetUuidResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetSectorSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetSectorSize*>(p->ptr), _vbox__IHostDrive_USCOREgetSectorSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetSectorSize*>(p->ptr), _vbox__IHostDrive_USCOREgetSectorSize);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetSectorSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetSectorSizeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetSectorSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetSectorSizeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetSectorSizeResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetSize*>(p->ptr), _vbox__IHostDrive_USCOREgetSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetSize*>(p->ptr), _vbox__IHostDrive_USCOREgetSize);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetSizeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetSizeResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetSizeResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetModel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetModel*>(p->ptr), _vbox__IHostDrive_USCOREgetModel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetModel*>(p->ptr), _vbox__IHostDrive_USCOREgetModel);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetModelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetModelResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetModelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetModelResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetModelResponse);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetPartitions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitions*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitions*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitions);
		break;
	case SOAP_TYPE__vbox__IHostDrive_USCOREgetPartitionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitionsResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostDrive_USCOREgetPartitionsResponse*>(p->ptr), _vbox__IHostDrive_USCOREgetPartitionsResponse);
		break;
	case SOAP_TYPE__vbox__IHostX86_USCOREgetProcessorCPUIDLeaf:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostX86_USCOREgetProcessorCPUIDLeaf*>(p->ptr), _vbox__IHostX86_USCOREgetProcessorCPUIDLeaf);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostX86_USCOREgetProcessorCPUIDLeaf*>(p->ptr), _vbox__IHostX86_USCOREgetProcessorCPUIDLeaf);
		break;
	case SOAP_TYPE__vbox__IHostX86_USCOREgetProcessorCPUIDLeafResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHostX86_USCOREgetProcessorCPUIDLeafResponse*>(p->ptr), _vbox__IHostX86_USCOREgetProcessorCPUIDLeafResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHostX86_USCOREgetProcessorCPUIDLeafResponse*>(p->ptr), _vbox__IHostX86_USCOREgetProcessorCPUIDLeafResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetArchitecture:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetArchitecture*>(p->ptr), _vbox__IHost_USCOREgetArchitecture);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetArchitecture*>(p->ptr), _vbox__IHost_USCOREgetArchitecture);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetArchitectureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetArchitectureResponse*>(p->ptr), _vbox__IHost_USCOREgetArchitectureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetArchitectureResponse*>(p->ptr), _vbox__IHost_USCOREgetArchitectureResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetX86:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetX86*>(p->ptr), _vbox__IHost_USCOREgetX86);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetX86*>(p->ptr), _vbox__IHost_USCOREgetX86);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetX86Response:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetX86Response*>(p->ptr), _vbox__IHost_USCOREgetX86Response);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetX86Response*>(p->ptr), _vbox__IHost_USCOREgetX86Response);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetDVDDrives:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetDVDDrives*>(p->ptr), _vbox__IHost_USCOREgetDVDDrives);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetDVDDrives*>(p->ptr), _vbox__IHost_USCOREgetDVDDrives);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetDVDDrivesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetDVDDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetDVDDrivesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetDVDDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetDVDDrivesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetFloppyDrives:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetFloppyDrives*>(p->ptr), _vbox__IHost_USCOREgetFloppyDrives);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetFloppyDrives*>(p->ptr), _vbox__IHost_USCOREgetFloppyDrives);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetFloppyDrivesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetFloppyDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetFloppyDrivesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetFloppyDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetFloppyDrivesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetAudioDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetAudioDevices*>(p->ptr), _vbox__IHost_USCOREgetAudioDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetAudioDevices*>(p->ptr), _vbox__IHost_USCOREgetAudioDevices);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetAudioDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetAudioDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetAudioDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetAudioDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetAudioDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUSBDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUSBDevices*>(p->ptr), _vbox__IHost_USCOREgetUSBDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUSBDevices*>(p->ptr), _vbox__IHost_USCOREgetUSBDevices);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUSBDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUSBDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetUSBDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUSBDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetUSBDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUSBDeviceFilters:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUSBDeviceFilters*>(p->ptr), _vbox__IHost_USCOREgetUSBDeviceFilters);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUSBDeviceFilters*>(p->ptr), _vbox__IHost_USCOREgetUSBDeviceFilters);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUSBDeviceFiltersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUSBDeviceFiltersResponse*>(p->ptr), _vbox__IHost_USCOREgetUSBDeviceFiltersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUSBDeviceFiltersResponse*>(p->ptr), _vbox__IHost_USCOREgetUSBDeviceFiltersResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetNetworkInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetNetworkInterfaces*>(p->ptr), _vbox__IHost_USCOREgetNetworkInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetNetworkInterfaces*>(p->ptr), _vbox__IHost_USCOREgetNetworkInterfaces);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetNetworkInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetNetworkInterfacesResponse*>(p->ptr), _vbox__IHost_USCOREgetNetworkInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetNetworkInterfacesResponse*>(p->ptr), _vbox__IHost_USCOREgetNetworkInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetNameServers:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetNameServers*>(p->ptr), _vbox__IHost_USCOREgetNameServers);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetNameServers*>(p->ptr), _vbox__IHost_USCOREgetNameServers);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetNameServersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetNameServersResponse*>(p->ptr), _vbox__IHost_USCOREgetNameServersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetNameServersResponse*>(p->ptr), _vbox__IHost_USCOREgetNameServersResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetDomainName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetDomainName*>(p->ptr), _vbox__IHost_USCOREgetDomainName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetDomainName*>(p->ptr), _vbox__IHost_USCOREgetDomainName);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetDomainNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetDomainNameResponse*>(p->ptr), _vbox__IHost_USCOREgetDomainNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetDomainNameResponse*>(p->ptr), _vbox__IHost_USCOREgetDomainNameResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetSearchStrings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetSearchStrings*>(p->ptr), _vbox__IHost_USCOREgetSearchStrings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetSearchStrings*>(p->ptr), _vbox__IHost_USCOREgetSearchStrings);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetSearchStringsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetSearchStringsResponse*>(p->ptr), _vbox__IHost_USCOREgetSearchStringsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetSearchStringsResponse*>(p->ptr), _vbox__IHost_USCOREgetSearchStringsResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorCount);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorCountResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorOnlineCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCount);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorOnlineCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCountResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorCoreCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorCoreCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorCoreCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorCoreCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorCoreCount);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorCoreCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorCoreCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorCoreCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorCoreCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorCoreCountResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorOnlineCoreCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCoreCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCoreCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCoreCount*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCoreCount);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorOnlineCoreCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCoreCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCoreCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorOnlineCoreCountResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorOnlineCoreCountResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetHostDrives:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetHostDrives*>(p->ptr), _vbox__IHost_USCOREgetHostDrives);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetHostDrives*>(p->ptr), _vbox__IHost_USCOREgetHostDrives);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetHostDrivesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetHostDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetHostDrivesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetHostDrivesResponse*>(p->ptr), _vbox__IHost_USCOREgetHostDrivesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetMemorySize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetMemorySize*>(p->ptr), _vbox__IHost_USCOREgetMemorySize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetMemorySize*>(p->ptr), _vbox__IHost_USCOREgetMemorySize);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetMemorySizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetMemorySizeResponse*>(p->ptr), _vbox__IHost_USCOREgetMemorySizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetMemorySizeResponse*>(p->ptr), _vbox__IHost_USCOREgetMemorySizeResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetMemoryAvailable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetMemoryAvailable*>(p->ptr), _vbox__IHost_USCOREgetMemoryAvailable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetMemoryAvailable*>(p->ptr), _vbox__IHost_USCOREgetMemoryAvailable);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetMemoryAvailableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetMemoryAvailableResponse*>(p->ptr), _vbox__IHost_USCOREgetMemoryAvailableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetMemoryAvailableResponse*>(p->ptr), _vbox__IHost_USCOREgetMemoryAvailableResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetOperatingSystem:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetOperatingSystem*>(p->ptr), _vbox__IHost_USCOREgetOperatingSystem);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetOperatingSystem*>(p->ptr), _vbox__IHost_USCOREgetOperatingSystem);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetOperatingSystemResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetOperatingSystemResponse*>(p->ptr), _vbox__IHost_USCOREgetOperatingSystemResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetOperatingSystemResponse*>(p->ptr), _vbox__IHost_USCOREgetOperatingSystemResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetOSVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetOSVersion*>(p->ptr), _vbox__IHost_USCOREgetOSVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetOSVersion*>(p->ptr), _vbox__IHost_USCOREgetOSVersion);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetOSVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetOSVersionResponse*>(p->ptr), _vbox__IHost_USCOREgetOSVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetOSVersionResponse*>(p->ptr), _vbox__IHost_USCOREgetOSVersionResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUTCTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUTCTime*>(p->ptr), _vbox__IHost_USCOREgetUTCTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUTCTime*>(p->ptr), _vbox__IHost_USCOREgetUTCTime);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUTCTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUTCTimeResponse*>(p->ptr), _vbox__IHost_USCOREgetUTCTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUTCTimeResponse*>(p->ptr), _vbox__IHost_USCOREgetUTCTimeResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetVideoInputDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetVideoInputDevices*>(p->ptr), _vbox__IHost_USCOREgetVideoInputDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetVideoInputDevices*>(p->ptr), _vbox__IHost_USCOREgetVideoInputDevices);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetVideoInputDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetVideoInputDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetVideoInputDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetVideoInputDevicesResponse*>(p->ptr), _vbox__IHost_USCOREgetVideoInputDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateHost:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateHost*>(p->ptr), _vbox__IHost_USCOREgetUpdateHost);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateHost*>(p->ptr), _vbox__IHost_USCOREgetUpdateHost);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateHostResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateHostResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateHostResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateHostResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateHostResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateExtPack:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateExtPack*>(p->ptr), _vbox__IHost_USCOREgetUpdateExtPack);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateExtPack*>(p->ptr), _vbox__IHost_USCOREgetUpdateExtPack);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateExtPackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateExtPackResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateExtPackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateExtPackResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateExtPackResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateGuestAdditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateGuestAdditions*>(p->ptr), _vbox__IHost_USCOREgetUpdateGuestAdditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateGuestAdditions*>(p->ptr), _vbox__IHost_USCOREgetUpdateGuestAdditions);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetUpdateGuestAdditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetUpdateGuestAdditionsResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateGuestAdditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetUpdateGuestAdditionsResponse*>(p->ptr), _vbox__IHost_USCOREgetUpdateGuestAdditionsResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorSpeed:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorSpeed*>(p->ptr), _vbox__IHost_USCOREgetProcessorSpeed);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorSpeed*>(p->ptr), _vbox__IHost_USCOREgetProcessorSpeed);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorSpeedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorSpeedResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorSpeedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorSpeedResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorSpeedResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorFeature:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorFeature*>(p->ptr), _vbox__IHost_USCOREgetProcessorFeature);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorFeature*>(p->ptr), _vbox__IHost_USCOREgetProcessorFeature);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorFeatureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorFeatureResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorFeatureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorFeatureResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorFeatureResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorDescription*>(p->ptr), _vbox__IHost_USCOREgetProcessorDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorDescription*>(p->ptr), _vbox__IHost_USCOREgetProcessorDescription);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgetProcessorDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgetProcessorDescriptionResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgetProcessorDescriptionResponse*>(p->ptr), _vbox__IHost_USCOREgetProcessorDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREcreateHostOnlyNetworkInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREcreateHostOnlyNetworkInterface*>(p->ptr), _vbox__IHost_USCOREcreateHostOnlyNetworkInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREcreateHostOnlyNetworkInterface*>(p->ptr), _vbox__IHost_USCOREcreateHostOnlyNetworkInterface);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREcreateHostOnlyNetworkInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREcreateHostOnlyNetworkInterfaceResponse*>(p->ptr), _vbox__IHost_USCOREcreateHostOnlyNetworkInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREcreateHostOnlyNetworkInterfaceResponse*>(p->ptr), _vbox__IHost_USCOREcreateHostOnlyNetworkInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveHostOnlyNetworkInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveHostOnlyNetworkInterface*>(p->ptr), _vbox__IHost_USCOREremoveHostOnlyNetworkInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveHostOnlyNetworkInterface*>(p->ptr), _vbox__IHost_USCOREremoveHostOnlyNetworkInterface);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveHostOnlyNetworkInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveHostOnlyNetworkInterfaceResponse*>(p->ptr), _vbox__IHost_USCOREremoveHostOnlyNetworkInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveHostOnlyNetworkInterfaceResponse*>(p->ptr), _vbox__IHost_USCOREremoveHostOnlyNetworkInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREcreateUSBDeviceFilter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREcreateUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREcreateUSBDeviceFilter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREcreateUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREcreateUSBDeviceFilter);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREcreateUSBDeviceFilterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREcreateUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREcreateUSBDeviceFilterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREcreateUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREcreateUSBDeviceFilterResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREinsertUSBDeviceFilter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREinsertUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREinsertUSBDeviceFilter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREinsertUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREinsertUSBDeviceFilter);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREinsertUSBDeviceFilterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREinsertUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREinsertUSBDeviceFilterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREinsertUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREinsertUSBDeviceFilterResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveUSBDeviceFilter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceFilter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceFilter*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceFilter);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveUSBDeviceFilterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceFilterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceFilterResponse*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceFilterResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostDVDDrive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostDVDDrive*>(p->ptr), _vbox__IHost_USCOREfindHostDVDDrive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostDVDDrive*>(p->ptr), _vbox__IHost_USCOREfindHostDVDDrive);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostDVDDriveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostDVDDriveResponse*>(p->ptr), _vbox__IHost_USCOREfindHostDVDDriveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostDVDDriveResponse*>(p->ptr), _vbox__IHost_USCOREfindHostDVDDriveResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostFloppyDrive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostFloppyDrive*>(p->ptr), _vbox__IHost_USCOREfindHostFloppyDrive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostFloppyDrive*>(p->ptr), _vbox__IHost_USCOREfindHostFloppyDrive);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostFloppyDriveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostFloppyDriveResponse*>(p->ptr), _vbox__IHost_USCOREfindHostFloppyDriveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostFloppyDriveResponse*>(p->ptr), _vbox__IHost_USCOREfindHostFloppyDriveResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfaceByName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByName*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByName*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByName);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfaceByNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByNameResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByNameResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByNameResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfaceById:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceById*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceById);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceById*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceById);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfaceByIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByIdResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfaceByIdResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfaceByIdResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfacesOfType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfacesOfType*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfacesOfType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfacesOfType*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfacesOfType);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindHostNetworkInterfacesOfTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfacesOfTypeResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfacesOfTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindHostNetworkInterfacesOfTypeResponse*>(p->ptr), _vbox__IHost_USCOREfindHostNetworkInterfacesOfTypeResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindUSBDeviceById:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceById*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceById);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceById*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceById);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindUSBDeviceByIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByIdResponse*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByIdResponse*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByIdResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindUSBDeviceByAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByAddress*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByAddress*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByAddress);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREfindUSBDeviceByAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByAddressResponse*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREfindUSBDeviceByAddressResponse*>(p->ptr), _vbox__IHost_USCOREfindUSBDeviceByAddressResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgenerateMACAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgenerateMACAddress*>(p->ptr), _vbox__IHost_USCOREgenerateMACAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgenerateMACAddress*>(p->ptr), _vbox__IHost_USCOREgenerateMACAddress);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREgenerateMACAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREgenerateMACAddressResponse*>(p->ptr), _vbox__IHost_USCOREgenerateMACAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREgenerateMACAddressResponse*>(p->ptr), _vbox__IHost_USCOREgenerateMACAddressResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREaddUSBDeviceSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREaddUSBDeviceSource*>(p->ptr), _vbox__IHost_USCOREaddUSBDeviceSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREaddUSBDeviceSource*>(p->ptr), _vbox__IHost_USCOREaddUSBDeviceSource);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREaddUSBDeviceSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREaddUSBDeviceSourceResponse*>(p->ptr), _vbox__IHost_USCOREaddUSBDeviceSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREaddUSBDeviceSourceResponse*>(p->ptr), _vbox__IHost_USCOREaddUSBDeviceSourceResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveUSBDeviceSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceSource*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceSource*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceSource);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREremoveUSBDeviceSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceSourceResponse*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREremoveUSBDeviceSourceResponse*>(p->ptr), _vbox__IHost_USCOREremoveUSBDeviceSourceResponse);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREisExecutionEngineSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREisExecutionEngineSupported*>(p->ptr), _vbox__IHost_USCOREisExecutionEngineSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREisExecutionEngineSupported*>(p->ptr), _vbox__IHost_USCOREisExecutionEngineSupported);
		break;
	case SOAP_TYPE__vbox__IHost_USCOREisExecutionEngineSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IHost_USCOREisExecutionEngineSupportedResponse*>(p->ptr), _vbox__IHost_USCOREisExecutionEngineSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IHost_USCOREisExecutionEngineSupportedResponse*>(p->ptr), _vbox__IHost_USCOREisExecutionEngineSupportedResponse);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetName*>(p->ptr), _vbox__ICPUProfile_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetName*>(p->ptr), _vbox__ICPUProfile_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetNameResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetNameResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetFullName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetFullName*>(p->ptr), _vbox__ICPUProfile_USCOREgetFullName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetFullName*>(p->ptr), _vbox__ICPUProfile_USCOREgetFullName);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetFullNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetFullNameResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetFullNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetFullNameResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetFullNameResponse);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetArchitecture:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetArchitecture*>(p->ptr), _vbox__ICPUProfile_USCOREgetArchitecture);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetArchitecture*>(p->ptr), _vbox__ICPUProfile_USCOREgetArchitecture);
		break;
	case SOAP_TYPE__vbox__ICPUProfile_USCOREgetArchitectureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ICPUProfile_USCOREgetArchitectureResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetArchitectureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ICPUProfile_USCOREgetArchitectureResponse*>(p->ptr), _vbox__ICPUProfile_USCOREgetArchitectureResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetRawModeSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetRawModeSupported*>(p->ptr), _vbox__IPlatformProperties_USCOREgetRawModeSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetRawModeSupported*>(p->ptr), _vbox__IPlatformProperties_USCOREgetRawModeSupported);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetRawModeSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetRawModeSupportedResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetRawModeSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetRawModeSupportedResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetRawModeSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetExclusiveHwVirt:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetExclusiveHwVirt*>(p->ptr), _vbox__IPlatformProperties_USCOREgetExclusiveHwVirt);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetExclusiveHwVirt*>(p->ptr), _vbox__IPlatformProperties_USCOREgetExclusiveHwVirt);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetExclusiveHwVirtResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetExclusiveHwVirtResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetExclusiveHwVirtResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetExclusiveHwVirtResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetExclusiveHwVirtResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREsetExclusiveHwVirt:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREsetExclusiveHwVirt*>(p->ptr), _vbox__IPlatformProperties_USCOREsetExclusiveHwVirt);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREsetExclusiveHwVirt*>(p->ptr), _vbox__IPlatformProperties_USCOREsetExclusiveHwVirt);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREsetExclusiveHwVirtResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREsetExclusiveHwVirtResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREsetExclusiveHwVirtResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREsetExclusiveHwVirtResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREsetExclusiveHwVirtResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSerialPortCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSerialPortCount*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSerialPortCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSerialPortCount*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSerialPortCount);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSerialPortCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSerialPortCountResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSerialPortCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSerialPortCountResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSerialPortCountResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetParallelPortCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetParallelPortCount*>(p->ptr), _vbox__IPlatformProperties_USCOREgetParallelPortCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetParallelPortCount*>(p->ptr), _vbox__IPlatformProperties_USCOREgetParallelPortCount);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetParallelPortCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetParallelPortCountResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetParallelPortCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetParallelPortCountResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetParallelPortCountResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxBootPosition:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxBootPosition*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxBootPosition);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxBootPosition*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxBootPosition);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxBootPositionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxBootPositionResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxBootPositionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxBootPositionResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxBootPositionResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedParavirtProviders:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedParavirtProviders*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedParavirtProviders);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedParavirtProviders*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedParavirtProviders);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedParavirtProvidersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedParavirtProvidersResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedParavirtProvidersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedParavirtProvidersResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedParavirtProvidersResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedFirmwareTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGuestOSTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxControllerTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePols:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePols*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePols);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePols*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePols);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePolsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePolsResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePolsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePolsResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetAdpPromiscModePolsResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedNetworkAdapterTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedUartTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUartTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUartTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUartTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUartTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedUartTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUartTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUartTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUartTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUartTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedUSBControllerTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedAudioControllerTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedBootDevices:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedBootDevices*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedBootDevices);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedBootDevices*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedBootDevices);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedBootDevicesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedBootDevicesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedBootDevicesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedBootDevicesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedBootDevicesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedStorageBuses:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageBuses*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageBuses);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageBuses*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageBuses);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedStorageBusesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageBusesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageBusesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageBusesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageBusesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedStorageControllerTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedChipsetTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedChipsetTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedChipsetTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedChipsetTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedChipsetTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedChipsetTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedChipsetTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedChipsetTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedChipsetTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedChipsetTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedIommuTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedIommuTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedIommuTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedIommuTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedIommuTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedIommuTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedIommuTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedIommuTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedIommuTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedIommuTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedTpmTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedTpmTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedTpmTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedTpmTypes*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedTpmTypes);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedTpmTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedTpmTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedTpmTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedTpmTypesResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedTpmTypesResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxNetworkAdapters:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdapters*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdapters);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdapters*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdapters);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfType);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxNetworkAdaptersOfTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxDevicesPerPortForStorageBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMinPortCountForStorageBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxPortCountForStorageBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfStorageBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedVRAMRange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedVRAMRange*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedVRAMRange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedVRAMRange*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedVRAMRange);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedVRAMRangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedVRAMRangeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedVRAMRangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedVRAMRangeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedVRAMRangeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForType);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetSupportedGfxFeaturesForTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetDeviceTypesForStorageBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageBusForControllerType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageBusForControllerType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageBusForControllerType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageBusForControllerType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageBusForControllerType);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageBusForControllerTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageBusForControllerTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageBusForControllerTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageBusForControllerTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageBusForControllerTypeResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBus*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBus);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBusResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerTypesForBusResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapable*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapable*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapable);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapableResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapableResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetStorageControllerHotplugCapableResponse);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerType*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerType);
		break;
	case SOAP_TYPE__vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerTypeResponse*>(p->ptr), _vbox__IPlatformProperties_USCOREgetMaxInstancesOfUSBControllerTypeResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetPlatform:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetPlatform*>(p->ptr), _vbox__ISystemProperties_USCOREgetPlatform);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetPlatform*>(p->ptr), _vbox__ISystemProperties_USCOREgetPlatform);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetPlatformResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetPlatformResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetPlatformResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetPlatformResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetPlatformResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestRAM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestRAM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestRAM);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestRAMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestRAMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestRAMResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestRAM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestRAM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestRAM);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestRAMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestRAMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestRAMResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestVRAM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestVRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestVRAM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestVRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestVRAM);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestVRAMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestVRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestVRAMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestVRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestVRAMResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestVRAM:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestVRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestVRAM);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestVRAM*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestVRAM);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestVRAMResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestVRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestVRAMResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestVRAMResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestVRAMResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestCPUCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestCPUCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestCPUCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestCPUCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestCPUCount);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMinGuestCPUCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestCPUCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestCPUCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMinGuestCPUCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMinGuestCPUCountResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestCPUCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestCPUCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestCPUCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestCPUCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestCPUCount);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestCPUCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestCPUCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestCPUCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestCPUCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestCPUCountResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestMonitors:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestMonitors*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestMonitors);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestMonitors*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestMonitors);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMaxGuestMonitorsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestMonitorsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestMonitorsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMaxGuestMonitorsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMaxGuestMonitorsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetInfoVDSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetInfoVDSize*>(p->ptr), _vbox__ISystemProperties_USCOREgetInfoVDSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetInfoVDSize*>(p->ptr), _vbox__ISystemProperties_USCOREgetInfoVDSize);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetInfoVDSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetInfoVDSizeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetInfoVDSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetInfoVDSizeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetInfoVDSizeResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultMachineFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultMachineFolder*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultMachineFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultMachineFolder*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultMachineFolder);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultMachineFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultMachineFolderResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultMachineFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultMachineFolderResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultMachineFolderResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultMachineFolder:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultMachineFolder*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultMachineFolder);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultMachineFolder*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultMachineFolder);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultMachineFolderResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultMachineFolderResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultMachineFolderResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultMachineFolderResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultMachineFolderResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLoggingLevel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLoggingLevel*>(p->ptr), _vbox__ISystemProperties_USCOREgetLoggingLevel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLoggingLevel*>(p->ptr), _vbox__ISystemProperties_USCOREgetLoggingLevel);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLoggingLevelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLoggingLevelResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLoggingLevelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLoggingLevelResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLoggingLevelResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLoggingLevel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLoggingLevel*>(p->ptr), _vbox__ISystemProperties_USCOREsetLoggingLevel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLoggingLevel*>(p->ptr), _vbox__ISystemProperties_USCOREsetLoggingLevel);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLoggingLevelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLoggingLevelResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLoggingLevelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLoggingLevelResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLoggingLevelResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMediumFormats:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMediumFormats*>(p->ptr), _vbox__ISystemProperties_USCOREgetMediumFormats);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMediumFormats*>(p->ptr), _vbox__ISystemProperties_USCOREgetMediumFormats);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetMediumFormatsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetMediumFormatsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMediumFormatsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetMediumFormatsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetMediumFormatsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultHardDiskFormat:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultHardDiskFormat*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultHardDiskFormat);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultHardDiskFormat*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultHardDiskFormat);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultHardDiskFormatResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultHardDiskFormatResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultHardDiskFormatResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultHardDiskFormatResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultHardDiskFormatResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultHardDiskFormat:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultHardDiskFormat*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultHardDiskFormat);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultHardDiskFormat*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultHardDiskFormat);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultHardDiskFormatResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultHardDiskFormatResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultHardDiskFormatResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultHardDiskFormatResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultHardDiskFormatResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarning:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarning*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarning);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarning*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarning);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarningResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarningResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceWarningResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarning:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarning*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarning);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarning*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarning);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarningResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarningResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceWarningResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarning:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarning*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarning);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarning*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarning);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarningResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarningResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentWarningResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarning:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarning*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarning);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarning*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarning);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarningResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarningResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarningResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentWarningResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpaceError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceError*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceError*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceError);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpaceErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpaceErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpaceErrorResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpaceError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceError*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceError*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceError);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpaceErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpaceErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpaceErrorResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentError*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentError*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentError);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetFreeDiskSpacePercentErrorResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentError*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentError*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentError);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentErrorResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetFreeDiskSpacePercentErrorResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetVRDEAuthLibrary:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetVRDEAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREgetVRDEAuthLibrary);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetVRDEAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREgetVRDEAuthLibrary);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetVRDEAuthLibraryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetVRDEAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetVRDEAuthLibraryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetVRDEAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetVRDEAuthLibraryResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetVRDEAuthLibrary:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetVRDEAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREsetVRDEAuthLibrary);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetVRDEAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREsetVRDEAuthLibrary);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetVRDEAuthLibraryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetVRDEAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetVRDEAuthLibraryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetVRDEAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetVRDEAuthLibraryResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetWebServiceAuthLibrary:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetWebServiceAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREgetWebServiceAuthLibrary);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetWebServiceAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREgetWebServiceAuthLibrary);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetWebServiceAuthLibraryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetWebServiceAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetWebServiceAuthLibraryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetWebServiceAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetWebServiceAuthLibraryResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetWebServiceAuthLibrary:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetWebServiceAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREsetWebServiceAuthLibrary);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetWebServiceAuthLibrary*>(p->ptr), _vbox__ISystemProperties_USCOREsetWebServiceAuthLibrary);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetWebServiceAuthLibraryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetWebServiceAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetWebServiceAuthLibraryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetWebServiceAuthLibraryResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetWebServiceAuthLibraryResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultVRDEExtPack:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultVRDEExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultVRDEExtPack);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultVRDEExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultVRDEExtPack);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultVRDEExtPackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultVRDEExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultVRDEExtPackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultVRDEExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultVRDEExtPackResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultVRDEExtPack:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultVRDEExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultVRDEExtPack);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultVRDEExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultVRDEExtPack);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultVRDEExtPackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultVRDEExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultVRDEExtPackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultVRDEExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultVRDEExtPackResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultCryptoExtPack:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultCryptoExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultCryptoExtPack);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultCryptoExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultCryptoExtPack);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultCryptoExtPackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultCryptoExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultCryptoExtPackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultCryptoExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultCryptoExtPackResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultCryptoExtPack:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultCryptoExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultCryptoExtPack);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultCryptoExtPack*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultCryptoExtPack);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultCryptoExtPackResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultCryptoExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultCryptoExtPackResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultCryptoExtPackResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultCryptoExtPackResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLogHistoryCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLogHistoryCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetLogHistoryCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLogHistoryCount*>(p->ptr), _vbox__ISystemProperties_USCOREgetLogHistoryCount);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLogHistoryCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLogHistoryCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLogHistoryCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLogHistoryCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLogHistoryCountResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLogHistoryCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLogHistoryCount*>(p->ptr), _vbox__ISystemProperties_USCOREsetLogHistoryCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLogHistoryCount*>(p->ptr), _vbox__ISystemProperties_USCOREsetLogHistoryCount);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLogHistoryCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLogHistoryCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLogHistoryCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLogHistoryCountResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLogHistoryCountResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultAudioDriver:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAudioDriver*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAudioDriver);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAudioDriver*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAudioDriver);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultAudioDriverResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAudioDriverResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAudioDriverResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAudioDriverResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAudioDriverResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetAutostartDatabasePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetAutostartDatabasePath*>(p->ptr), _vbox__ISystemProperties_USCOREgetAutostartDatabasePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetAutostartDatabasePath*>(p->ptr), _vbox__ISystemProperties_USCOREgetAutostartDatabasePath);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetAutostartDatabasePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetAutostartDatabasePathResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetAutostartDatabasePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetAutostartDatabasePathResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetAutostartDatabasePathResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetAutostartDatabasePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetAutostartDatabasePath*>(p->ptr), _vbox__ISystemProperties_USCOREsetAutostartDatabasePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetAutostartDatabasePath*>(p->ptr), _vbox__ISystemProperties_USCOREsetAutostartDatabasePath);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetAutostartDatabasePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetAutostartDatabasePathResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetAutostartDatabasePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetAutostartDatabasePathResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetAutostartDatabasePathResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultAdditionsISO:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAdditionsISO*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAdditionsISO);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAdditionsISO*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAdditionsISO);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultAdditionsISOResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAdditionsISOResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAdditionsISOResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultAdditionsISOResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultAdditionsISOResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultAdditionsISO:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultAdditionsISO*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultAdditionsISO);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultAdditionsISO*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultAdditionsISO);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultAdditionsISOResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultAdditionsISOResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultAdditionsISOResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultAdditionsISOResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultAdditionsISOResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultFrontend:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultFrontend*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultFrontend);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultFrontend*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultFrontend);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultFrontendResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultFrontendResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultFrontendResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultFrontendResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultFrontendResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultFrontend:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultFrontend*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultFrontend);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultFrontend*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultFrontend);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetDefaultFrontendResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultFrontendResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultFrontendResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetDefaultFrontendResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetDefaultFrontendResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetScreenShotFormats:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetScreenShotFormats*>(p->ptr), _vbox__ISystemProperties_USCOREgetScreenShotFormats);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetScreenShotFormats*>(p->ptr), _vbox__ISystemProperties_USCOREgetScreenShotFormats);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetScreenShotFormatsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetScreenShotFormatsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetScreenShotFormatsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetScreenShotFormatsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetScreenShotFormatsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetProxyMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyMode*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyMode*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyMode);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetProxyModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyModeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyModeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyModeResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetProxyMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyMode*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyMode*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyMode);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetProxyModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyModeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyModeResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyModeResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetProxyURL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyURL*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyURL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyURL*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyURL);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetProxyURLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyURLResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyURLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetProxyURLResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetProxyURLResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetProxyURL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyURL*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyURL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyURL*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyURL);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetProxyURLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyURLResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyURLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetProxyURLResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetProxyURLResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPlatformArchitectures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPlatformArchitectures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPlatformArchitectures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPlatformArchitectures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPlatformArchitectures);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPlatformArchitecturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPlatformArchitecturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPlatformArchitecturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPlatformArchitecturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPlatformArchitecturesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedClipboardModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedClipboardModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedClipboardModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedClipboardModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedClipboardModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedClipboardModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedClipboardModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedClipboardModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedClipboardModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedClipboardModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedDnDModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedDnDModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedDnDModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedDnDModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedDnDModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedDnDModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedDnDModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedDnDModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedDnDModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedDnDModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPointingHIDTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedKeyboardHIDTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedVFSTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVFSTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVFSTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVFSTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVFSTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedVFSTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVFSTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVFSTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVFSTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVFSTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedImportOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedImportOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedImportOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedImportOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedImportOptions);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedImportOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedImportOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedImportOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedImportOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedImportOptionsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedExportOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedExportOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedExportOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedExportOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedExportOptions);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedExportOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedExportOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedExportOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedExportOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedExportOptionsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedGraphicsFeatures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedGraphicsFeatures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedGraphicsFeatures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedGraphicsFeatures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedGraphicsFeatures);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedGraphicsFeaturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedGraphicsFeaturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedGraphicsFeaturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedGraphicsFeaturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedGraphicsFeaturesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingFeatures:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingFeatures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingFeatures);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingFeatures*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingFeatures);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingFeaturesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingFeaturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingFeaturesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingFeaturesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingFeaturesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecs:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecs*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecs);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecs*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecs);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingAudioCodecsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecs:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecs*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecs);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecs*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecs);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVideoCodecsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVSModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVSModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVSModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVSModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVSModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVSModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVSModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVSModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVSModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVSModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingARCModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingARCModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingARCModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingARCModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingARCModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingARCModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingARCModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingARCModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingARCModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingARCModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedRecordingVRCModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedCloneOptions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedCloneOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedCloneOptions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedCloneOptions*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedCloneOptions);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedCloneOptionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedCloneOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedCloneOptionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedCloneOptionsResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedCloneOptionsResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedAutostopTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAutostopTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAutostopTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAutostopTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAutostopTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedAutostopTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAutostopTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAutostopTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAutostopTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAutostopTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedVMProcPriorities:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVMProcPriorities*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVMProcPriorities);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVMProcPriorities*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVMProcPriorities);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedVMProcPrioritiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVMProcPrioritiesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVMProcPrioritiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedVMProcPrioritiesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedVMProcPrioritiesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedNetworkAttachmentTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPortModes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPortModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPortModes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPortModes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPortModes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedPortModesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPortModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPortModesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedPortModesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedPortModesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypes*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypes);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetSupportedAudioDriverTypesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLanguageId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLanguageId*>(p->ptr), _vbox__ISystemProperties_USCOREgetLanguageId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLanguageId*>(p->ptr), _vbox__ISystemProperties_USCOREgetLanguageId);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetLanguageIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetLanguageIdResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLanguageIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetLanguageIdResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetLanguageIdResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLanguageId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLanguageId*>(p->ptr), _vbox__ISystemProperties_USCOREsetLanguageId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLanguageId*>(p->ptr), _vbox__ISystemProperties_USCOREsetLanguageId);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREsetLanguageIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREsetLanguageIdResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLanguageIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREsetLanguageIdResponse*>(p->ptr), _vbox__ISystemProperties_USCOREsetLanguageIdResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageController:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageController*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageController);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageController*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageController);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageControllerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageControllerResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageControllerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageControllerResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetDefaultIoCacheSettingForStorageControllerResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetCPUProfiles:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetCPUProfiles*>(p->ptr), _vbox__ISystemProperties_USCOREgetCPUProfiles);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetCPUProfiles*>(p->ptr), _vbox__ISystemProperties_USCOREgetCPUProfiles);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetCPUProfilesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetCPUProfilesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetCPUProfilesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetCPUProfilesResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetCPUProfilesResponse);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitecture:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitecture*>(p->ptr), _vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitecture);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitecture*>(p->ptr), _vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitecture);
		break;
	case SOAP_TYPE__vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitectureResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitectureResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitectureResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitectureResponse*>(p->ptr), _vbox__ISystemProperties_USCOREgetExecutionEnginesForVmCpuArchitectureResponse);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREgetFormats:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREgetFormats*>(p->ptr), _vbox__IDnDBase_USCOREgetFormats);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREgetFormats*>(p->ptr), _vbox__IDnDBase_USCOREgetFormats);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREgetFormatsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREgetFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREgetFormatsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREgetFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREgetFormatsResponse);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREisFormatSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREisFormatSupported*>(p->ptr), _vbox__IDnDBase_USCOREisFormatSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREisFormatSupported*>(p->ptr), _vbox__IDnDBase_USCOREisFormatSupported);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREisFormatSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREisFormatSupportedResponse*>(p->ptr), _vbox__IDnDBase_USCOREisFormatSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREisFormatSupportedResponse*>(p->ptr), _vbox__IDnDBase_USCOREisFormatSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREaddFormats:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREaddFormats*>(p->ptr), _vbox__IDnDBase_USCOREaddFormats);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREaddFormats*>(p->ptr), _vbox__IDnDBase_USCOREaddFormats);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREaddFormatsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREaddFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREaddFormatsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREaddFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREaddFormatsResponse);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREremoveFormats:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREremoveFormats*>(p->ptr), _vbox__IDnDBase_USCOREremoveFormats);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREremoveFormats*>(p->ptr), _vbox__IDnDBase_USCOREremoveFormats);
		break;
	case SOAP_TYPE__vbox__IDnDBase_USCOREremoveFormatsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDBase_USCOREremoveFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREremoveFormatsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDBase_USCOREremoveFormatsResponse*>(p->ptr), _vbox__IDnDBase_USCOREremoveFormatsResponse);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREdragIsPending:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREdragIsPending*>(p->ptr), _vbox__IDnDSource_USCOREdragIsPending);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREdragIsPending*>(p->ptr), _vbox__IDnDSource_USCOREdragIsPending);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREdragIsPendingResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREdragIsPendingResponse*>(p->ptr), _vbox__IDnDSource_USCOREdragIsPendingResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREdragIsPendingResponse*>(p->ptr), _vbox__IDnDSource_USCOREdragIsPendingResponse);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREdrop:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREdrop*>(p->ptr), _vbox__IDnDSource_USCOREdrop);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREdrop*>(p->ptr), _vbox__IDnDSource_USCOREdrop);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREdropResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREdropResponse*>(p->ptr), _vbox__IDnDSource_USCOREdropResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREdropResponse*>(p->ptr), _vbox__IDnDSource_USCOREdropResponse);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREreceiveData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREreceiveData*>(p->ptr), _vbox__IDnDSource_USCOREreceiveData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREreceiveData*>(p->ptr), _vbox__IDnDSource_USCOREreceiveData);
		break;
	case SOAP_TYPE__vbox__IDnDSource_USCOREreceiveDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDSource_USCOREreceiveDataResponse*>(p->ptr), _vbox__IDnDSource_USCOREreceiveDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDSource_USCOREreceiveDataResponse*>(p->ptr), _vbox__IDnDSource_USCOREreceiveDataResponse);
		break;
	case SOAP_TYPE__vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDnDSource_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREenter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREenter*>(p->ptr), _vbox__IDnDTarget_USCOREenter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREenter*>(p->ptr), _vbox__IDnDTarget_USCOREenter);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREenterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREenterResponse*>(p->ptr), _vbox__IDnDTarget_USCOREenterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREenterResponse*>(p->ptr), _vbox__IDnDTarget_USCOREenterResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREmove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREmove*>(p->ptr), _vbox__IDnDTarget_USCOREmove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREmove*>(p->ptr), _vbox__IDnDTarget_USCOREmove);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREmoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREmoveResponse*>(p->ptr), _vbox__IDnDTarget_USCOREmoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREmoveResponse*>(p->ptr), _vbox__IDnDTarget_USCOREmoveResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREleave:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREleave*>(p->ptr), _vbox__IDnDTarget_USCOREleave);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREleave*>(p->ptr), _vbox__IDnDTarget_USCOREleave);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREleaveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREleaveResponse*>(p->ptr), _vbox__IDnDTarget_USCOREleaveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREleaveResponse*>(p->ptr), _vbox__IDnDTarget_USCOREleaveResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREdrop:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREdrop*>(p->ptr), _vbox__IDnDTarget_USCOREdrop);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREdrop*>(p->ptr), _vbox__IDnDTarget_USCOREdrop);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREdropResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREdropResponse*>(p->ptr), _vbox__IDnDTarget_USCOREdropResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREdropResponse*>(p->ptr), _vbox__IDnDTarget_USCOREdropResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREsendData:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREsendData*>(p->ptr), _vbox__IDnDTarget_USCOREsendData);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREsendData*>(p->ptr), _vbox__IDnDTarget_USCOREsendData);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREsendDataResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREsendDataResponse*>(p->ptr), _vbox__IDnDTarget_USCOREsendDataResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREsendDataResponse*>(p->ptr), _vbox__IDnDTarget_USCOREsendDataResponse);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREcancel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREcancel*>(p->ptr), _vbox__IDnDTarget_USCOREcancel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREcancel*>(p->ptr), _vbox__IDnDTarget_USCOREcancel);
		break;
	case SOAP_TYPE__vbox__IDnDTarget_USCOREcancelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDnDTarget_USCOREcancelResponse*>(p->ptr), _vbox__IDnDTarget_USCOREcancelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDnDTarget_USCOREcancelResponse*>(p->ptr), _vbox__IDnDTarget_USCOREcancelResponse);
		break;
	case SOAP_TYPE__vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDnDTarget_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUser:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUser*>(p->ptr), _vbox__IGuestSession_USCOREgetUser);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUser*>(p->ptr), _vbox__IGuestSession_USCOREgetUser);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUserResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUserResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUserResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetDomain:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetDomain*>(p->ptr), _vbox__IGuestSession_USCOREgetDomain);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetDomain*>(p->ptr), _vbox__IGuestSession_USCOREgetDomain);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetDomainResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetDomainResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetDomainResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetDomainResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetDomainResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetName*>(p->ptr), _vbox__IGuestSession_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetName*>(p->ptr), _vbox__IGuestSession_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetNameResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetNameResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetId*>(p->ptr), _vbox__IGuestSession_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetId*>(p->ptr), _vbox__IGuestSession_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetIdResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetIdResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetTimeout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetTimeout*>(p->ptr), _vbox__IGuestSession_USCOREgetTimeout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetTimeout*>(p->ptr), _vbox__IGuestSession_USCOREgetTimeout);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetTimeoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetTimeoutResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetTimeoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetTimeoutResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetTimeoutResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetTimeout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetTimeout*>(p->ptr), _vbox__IGuestSession_USCOREsetTimeout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetTimeout*>(p->ptr), _vbox__IGuestSession_USCOREsetTimeout);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetTimeoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetTimeoutResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetTimeoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetTimeoutResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetTimeoutResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetProtocolVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetProtocolVersion*>(p->ptr), _vbox__IGuestSession_USCOREgetProtocolVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetProtocolVersion*>(p->ptr), _vbox__IGuestSession_USCOREgetProtocolVersion);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetProtocolVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetProtocolVersionResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetProtocolVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetProtocolVersionResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetProtocolVersionResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetStatus*>(p->ptr), _vbox__IGuestSession_USCOREgetStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetStatus*>(p->ptr), _vbox__IGuestSession_USCOREgetStatus);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetStatusResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetStatusResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetStatusResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEnvironmentChanges:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentChanges*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentChanges);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentChanges*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentChanges);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEnvironmentChangesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentChangesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentChangesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentChangesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentChangesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetEnvironmentChanges:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetEnvironmentChanges*>(p->ptr), _vbox__IGuestSession_USCOREsetEnvironmentChanges);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetEnvironmentChanges*>(p->ptr), _vbox__IGuestSession_USCOREsetEnvironmentChanges);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetEnvironmentChangesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetEnvironmentChangesResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetEnvironmentChangesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetEnvironmentChangesResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetEnvironmentChangesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEnvironmentBase:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentBase*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentBase);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentBase*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentBase);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEnvironmentBaseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentBaseResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentBaseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEnvironmentBaseResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEnvironmentBaseResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetProcesses:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetProcesses*>(p->ptr), _vbox__IGuestSession_USCOREgetProcesses);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetProcesses*>(p->ptr), _vbox__IGuestSession_USCOREgetProcesses);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetProcessesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetProcessesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetProcessesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetProcessesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetProcessesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetPathStyle:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetPathStyle*>(p->ptr), _vbox__IGuestSession_USCOREgetPathStyle);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetPathStyle*>(p->ptr), _vbox__IGuestSession_USCOREgetPathStyle);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetPathStyleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetPathStyleResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetPathStyleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetPathStyleResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetPathStyleResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetCurrentDirectory:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetCurrentDirectory*>(p->ptr), _vbox__IGuestSession_USCOREgetCurrentDirectory);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetCurrentDirectory*>(p->ptr), _vbox__IGuestSession_USCOREgetCurrentDirectory);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetCurrentDirectoryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetCurrentDirectoryResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetCurrentDirectoryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetCurrentDirectoryResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetCurrentDirectoryResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetCurrentDirectory:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetCurrentDirectory*>(p->ptr), _vbox__IGuestSession_USCOREsetCurrentDirectory);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetCurrentDirectory*>(p->ptr), _vbox__IGuestSession_USCOREsetCurrentDirectory);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsetCurrentDirectoryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsetCurrentDirectoryResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetCurrentDirectoryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsetCurrentDirectoryResponse*>(p->ptr), _vbox__IGuestSession_USCOREsetCurrentDirectoryResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUserHome:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUserHome*>(p->ptr), _vbox__IGuestSession_USCOREgetUserHome);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUserHome*>(p->ptr), _vbox__IGuestSession_USCOREgetUserHome);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUserHomeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUserHomeResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserHomeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUserHomeResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserHomeResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUserDocuments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUserDocuments*>(p->ptr), _vbox__IGuestSession_USCOREgetUserDocuments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUserDocuments*>(p->ptr), _vbox__IGuestSession_USCOREgetUserDocuments);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetUserDocumentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetUserDocumentsResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserDocumentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetUserDocumentsResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetUserDocumentsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetMountPoints:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetMountPoints*>(p->ptr), _vbox__IGuestSession_USCOREgetMountPoints);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetMountPoints*>(p->ptr), _vbox__IGuestSession_USCOREgetMountPoints);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetMountPointsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetMountPointsResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetMountPointsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetMountPointsResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetMountPointsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetDirectories:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetDirectories*>(p->ptr), _vbox__IGuestSession_USCOREgetDirectories);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetDirectories*>(p->ptr), _vbox__IGuestSession_USCOREgetDirectories);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetDirectoriesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetDirectoriesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetDirectoriesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetDirectoriesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetDirectoriesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetFiles:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetFiles*>(p->ptr), _vbox__IGuestSession_USCOREgetFiles);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetFiles*>(p->ptr), _vbox__IGuestSession_USCOREgetFiles);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetFilesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetFilesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetFilesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetFilesResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetFilesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEventSource*>(p->ptr), _vbox__IGuestSession_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEventSource*>(p->ptr), _vbox__IGuestSession_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IGuestSession_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREclose:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREclose*>(p->ptr), _vbox__IGuestSession_USCOREclose);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREclose*>(p->ptr), _vbox__IGuestSession_USCOREclose);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREcloseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREcloseResponse*>(p->ptr), _vbox__IGuestSession_USCOREcloseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREcloseResponse*>(p->ptr), _vbox__IGuestSession_USCOREcloseResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREcopyFromGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREcopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREcopyFromGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREcopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREcopyFromGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREcopyFromGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREcopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREcopyFromGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREcopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREcopyFromGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREcopyToGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREcopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREcopyToGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREcopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREcopyToGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREcopyToGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREcopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREcopyToGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREcopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREcopyToGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopy*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopy*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopy);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopyFromGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyFromGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyFromGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopyFromGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyFromGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyFromGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopyToGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyToGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyToGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCopyToGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyToGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCopyToGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCreate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreate*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreate*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreate);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCreateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCreateTemp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateTemp*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateTemp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateTemp*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateTemp);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryCreateTempResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateTempResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateTempResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryCreateTempResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryCreateTempResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryExists:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryExists*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryExists);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryExists*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryExists);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryExistsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryExistsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryExistsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryOpen:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryOpen*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryOpen);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryOpen*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryOpen);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryOpenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryOpenResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryOpenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryOpenResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryOpenResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryRemove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemove*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemove*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemove);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryRemoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryRemoveRecursive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveRecursive*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveRecursive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveRecursive*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveRecursive);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREdirectoryRemoveRecursiveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveRecursiveResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveRecursiveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREdirectoryRemoveRecursiveResponse*>(p->ptr), _vbox__IGuestSession_USCOREdirectoryRemoveRecursiveResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentScheduleSet:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleSet*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleSet);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleSet*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleSet);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentScheduleSetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleSetResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleSetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleSetResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleSetResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentScheduleUnset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleUnset*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleUnset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleUnset*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleUnset);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentScheduleUnsetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleUnsetResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleUnsetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentScheduleUnsetResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentScheduleUnsetResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentGetBaseVariable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentGetBaseVariable*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentGetBaseVariable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentGetBaseVariable*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentGetBaseVariable);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentGetBaseVariableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentGetBaseVariableResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentGetBaseVariableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentGetBaseVariableResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentGetBaseVariableResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExist:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExist*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExist);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExist*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExist);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExistResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExistResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExistResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExistResponse*>(p->ptr), _vbox__IGuestSession_USCOREenvironmentDoesBaseVariableExistResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopy*>(p->ptr), _vbox__IGuestSession_USCOREfileCopy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopy*>(p->ptr), _vbox__IGuestSession_USCOREfileCopy);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopyFromGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyFromGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyFromGuest*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyFromGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopyFromGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyFromGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyFromGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyFromGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopyToGuest:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyToGuest);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyToGuest*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyToGuest);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCopyToGuestResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyToGuestResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCopyToGuestResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCopyToGuestResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCreateTemp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCreateTemp*>(p->ptr), _vbox__IGuestSession_USCOREfileCreateTemp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCreateTemp*>(p->ptr), _vbox__IGuestSession_USCOREfileCreateTemp);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileCreateTempResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileCreateTempResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCreateTempResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileCreateTempResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileCreateTempResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileExists:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileExists*>(p->ptr), _vbox__IGuestSession_USCOREfileExists);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileExists*>(p->ptr), _vbox__IGuestSession_USCOREfileExists);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileExistsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileExistsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileExistsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileOpen:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileOpen*>(p->ptr), _vbox__IGuestSession_USCOREfileOpen);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileOpen*>(p->ptr), _vbox__IGuestSession_USCOREfileOpen);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileOpenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileOpenEx:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenEx*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenEx);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenEx*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenEx);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileOpenExResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenExResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenExResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileOpenExResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileOpenExResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileQuerySize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileQuerySize*>(p->ptr), _vbox__IGuestSession_USCOREfileQuerySize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileQuerySize*>(p->ptr), _vbox__IGuestSession_USCOREfileQuerySize);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfileQuerySizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfileQuerySizeResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileQuerySizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfileQuerySizeResponse*>(p->ptr), _vbox__IGuestSession_USCOREfileQuerySizeResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjExists:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjExists*>(p->ptr), _vbox__IGuestSession_USCOREfsObjExists);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjExists*>(p->ptr), _vbox__IGuestSession_USCOREfsObjExists);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjExistsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjExistsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjExistsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjQueryInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjQueryInfo*>(p->ptr), _vbox__IGuestSession_USCOREfsObjQueryInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjQueryInfo*>(p->ptr), _vbox__IGuestSession_USCOREfsObjQueryInfo);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjQueryInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjQueryInfoResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjQueryInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjQueryInfoResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjQueryInfoResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRemove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemove*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemove*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemove);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRemoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRemoveArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveArray);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRemoveArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRemoveArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRemoveArrayResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRename*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRename*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRename);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjRenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRenameResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjRenameResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjRenameResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjMove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMove*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMove*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMove);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjMoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjMoveArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveArray);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjMoveArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjMoveArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjMoveArrayResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjCopyArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjCopyArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjCopyArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjCopyArray*>(p->ptr), _vbox__IGuestSession_USCOREfsObjCopyArray);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjCopyArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjCopyArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjCopyArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjCopyArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjCopyArrayResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjSetACL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjSetACL*>(p->ptr), _vbox__IGuestSession_USCOREfsObjSetACL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjSetACL*>(p->ptr), _vbox__IGuestSession_USCOREfsObjSetACL);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsObjSetACLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsObjSetACLResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjSetACLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsObjSetACLResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsObjSetACLResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsQueryFreeSpace:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryFreeSpace*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryFreeSpace);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryFreeSpace*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryFreeSpace);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsQueryFreeSpaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryFreeSpaceResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryFreeSpaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryFreeSpaceResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryFreeSpaceResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsQueryInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryInfo*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryInfo*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryInfo);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREfsQueryInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryInfoResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREfsQueryInfoResponse*>(p->ptr), _vbox__IGuestSession_USCOREfsQueryInfoResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessCreate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreate*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreate*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreate);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessCreateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessCreateEx:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateEx*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateEx);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateEx*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateEx);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessCreateExResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateExResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateExResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessCreateExResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessCreateExResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessGet:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessGet*>(p->ptr), _vbox__IGuestSession_USCOREprocessGet);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessGet*>(p->ptr), _vbox__IGuestSession_USCOREprocessGet);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREprocessGetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREprocessGetResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessGetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREprocessGetResponse*>(p->ptr), _vbox__IGuestSession_USCOREprocessGetResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkCreate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkCreate*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkCreate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkCreate*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkCreate);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkCreateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkCreateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkCreateResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkCreateResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkExists:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkExists*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkExists);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkExists*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkExists);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkExistsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkExistsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkExistsResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkExistsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkRead:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkRead*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkRead);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkRead*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkRead);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREsymlinkReadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkReadResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkReadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREsymlinkReadResponse*>(p->ptr), _vbox__IGuestSession_USCOREsymlinkReadResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREwaitFor:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREwaitFor*>(p->ptr), _vbox__IGuestSession_USCOREwaitFor);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREwaitFor*>(p->ptr), _vbox__IGuestSession_USCOREwaitFor);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREwaitForResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREwaitForResponse*>(p->ptr), _vbox__IGuestSession_USCOREwaitForResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREwaitForResponse*>(p->ptr), _vbox__IGuestSession_USCOREwaitForResponse);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREwaitForArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREwaitForArray*>(p->ptr), _vbox__IGuestSession_USCOREwaitForArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREwaitForArray*>(p->ptr), _vbox__IGuestSession_USCOREwaitForArray);
		break;
	case SOAP_TYPE__vbox__IGuestSession_USCOREwaitForArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestSession_USCOREwaitForArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREwaitForArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestSession_USCOREwaitForArrayResponse*>(p->ptr), _vbox__IGuestSession_USCOREwaitForArrayResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetArguments:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetArguments*>(p->ptr), _vbox__IProcess_USCOREgetArguments);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetArguments*>(p->ptr), _vbox__IProcess_USCOREgetArguments);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetArgumentsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetArgumentsResponse*>(p->ptr), _vbox__IProcess_USCOREgetArgumentsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetArgumentsResponse*>(p->ptr), _vbox__IProcess_USCOREgetArgumentsResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetEnvironment:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetEnvironment*>(p->ptr), _vbox__IProcess_USCOREgetEnvironment);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetEnvironment*>(p->ptr), _vbox__IProcess_USCOREgetEnvironment);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetEnvironmentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetEnvironmentResponse*>(p->ptr), _vbox__IProcess_USCOREgetEnvironmentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetEnvironmentResponse*>(p->ptr), _vbox__IProcess_USCOREgetEnvironmentResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetEventSource*>(p->ptr), _vbox__IProcess_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetEventSource*>(p->ptr), _vbox__IProcess_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IProcess_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IProcess_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetExecutablePath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetExecutablePath*>(p->ptr), _vbox__IProcess_USCOREgetExecutablePath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetExecutablePath*>(p->ptr), _vbox__IProcess_USCOREgetExecutablePath);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetExecutablePathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetExecutablePathResponse*>(p->ptr), _vbox__IProcess_USCOREgetExecutablePathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetExecutablePathResponse*>(p->ptr), _vbox__IProcess_USCOREgetExecutablePathResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetExitCode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetExitCode*>(p->ptr), _vbox__IProcess_USCOREgetExitCode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetExitCode*>(p->ptr), _vbox__IProcess_USCOREgetExitCode);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetExitCodeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetExitCodeResponse*>(p->ptr), _vbox__IProcess_USCOREgetExitCodeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetExitCodeResponse*>(p->ptr), _vbox__IProcess_USCOREgetExitCodeResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetName*>(p->ptr), _vbox__IProcess_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetName*>(p->ptr), _vbox__IProcess_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetNameResponse*>(p->ptr), _vbox__IProcess_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetNameResponse*>(p->ptr), _vbox__IProcess_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetPID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetPID*>(p->ptr), _vbox__IProcess_USCOREgetPID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetPID*>(p->ptr), _vbox__IProcess_USCOREgetPID);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetPIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetPIDResponse*>(p->ptr), _vbox__IProcess_USCOREgetPIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetPIDResponse*>(p->ptr), _vbox__IProcess_USCOREgetPIDResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetStatus*>(p->ptr), _vbox__IProcess_USCOREgetStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetStatus*>(p->ptr), _vbox__IProcess_USCOREgetStatus);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREgetStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREgetStatusResponse*>(p->ptr), _vbox__IProcess_USCOREgetStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREgetStatusResponse*>(p->ptr), _vbox__IProcess_USCOREgetStatusResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwaitFor:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwaitFor*>(p->ptr), _vbox__IProcess_USCOREwaitFor);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwaitFor*>(p->ptr), _vbox__IProcess_USCOREwaitFor);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwaitForResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwaitForResponse*>(p->ptr), _vbox__IProcess_USCOREwaitForResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwaitForResponse*>(p->ptr), _vbox__IProcess_USCOREwaitForResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwaitForArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwaitForArray*>(p->ptr), _vbox__IProcess_USCOREwaitForArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwaitForArray*>(p->ptr), _vbox__IProcess_USCOREwaitForArray);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwaitForArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwaitForArrayResponse*>(p->ptr), _vbox__IProcess_USCOREwaitForArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwaitForArrayResponse*>(p->ptr), _vbox__IProcess_USCOREwaitForArrayResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREread*>(p->ptr), _vbox__IProcess_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREread*>(p->ptr), _vbox__IProcess_USCOREread);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREreadResponse*>(p->ptr), _vbox__IProcess_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREreadResponse*>(p->ptr), _vbox__IProcess_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwrite:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwrite*>(p->ptr), _vbox__IProcess_USCOREwrite);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwrite*>(p->ptr), _vbox__IProcess_USCOREwrite);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwriteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwriteResponse*>(p->ptr), _vbox__IProcess_USCOREwriteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwriteResponse*>(p->ptr), _vbox__IProcess_USCOREwriteResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwriteArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwriteArray*>(p->ptr), _vbox__IProcess_USCOREwriteArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwriteArray*>(p->ptr), _vbox__IProcess_USCOREwriteArray);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREwriteArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREwriteArrayResponse*>(p->ptr), _vbox__IProcess_USCOREwriteArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREwriteArrayResponse*>(p->ptr), _vbox__IProcess_USCOREwriteArrayResponse);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREterminate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREterminate*>(p->ptr), _vbox__IProcess_USCOREterminate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREterminate*>(p->ptr), _vbox__IProcess_USCOREterminate);
		break;
	case SOAP_TYPE__vbox__IProcess_USCOREterminateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProcess_USCOREterminateResponse*>(p->ptr), _vbox__IProcess_USCOREterminateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProcess_USCOREterminateResponse*>(p->ptr), _vbox__IProcess_USCOREterminateResponse);
		break;
	case SOAP_TYPE__vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestProcess_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetDirectoryName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetDirectoryName*>(p->ptr), _vbox__IDirectory_USCOREgetDirectoryName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetDirectoryName*>(p->ptr), _vbox__IDirectory_USCOREgetDirectoryName);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetDirectoryNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetDirectoryNameResponse*>(p->ptr), _vbox__IDirectory_USCOREgetDirectoryNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetDirectoryNameResponse*>(p->ptr), _vbox__IDirectory_USCOREgetDirectoryNameResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetEventSource*>(p->ptr), _vbox__IDirectory_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetEventSource*>(p->ptr), _vbox__IDirectory_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IDirectory_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IDirectory_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetFilter:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetFilter*>(p->ptr), _vbox__IDirectory_USCOREgetFilter);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetFilter*>(p->ptr), _vbox__IDirectory_USCOREgetFilter);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetFilterResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetFilterResponse*>(p->ptr), _vbox__IDirectory_USCOREgetFilterResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetFilterResponse*>(p->ptr), _vbox__IDirectory_USCOREgetFilterResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetId*>(p->ptr), _vbox__IDirectory_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetId*>(p->ptr), _vbox__IDirectory_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetIdResponse*>(p->ptr), _vbox__IDirectory_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetIdResponse*>(p->ptr), _vbox__IDirectory_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetStatus*>(p->ptr), _vbox__IDirectory_USCOREgetStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetStatus*>(p->ptr), _vbox__IDirectory_USCOREgetStatus);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREgetStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREgetStatusResponse*>(p->ptr), _vbox__IDirectory_USCOREgetStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREgetStatusResponse*>(p->ptr), _vbox__IDirectory_USCOREgetStatusResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREclose:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREclose*>(p->ptr), _vbox__IDirectory_USCOREclose);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREclose*>(p->ptr), _vbox__IDirectory_USCOREclose);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREcloseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREcloseResponse*>(p->ptr), _vbox__IDirectory_USCOREcloseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREcloseResponse*>(p->ptr), _vbox__IDirectory_USCOREcloseResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCORElist:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCORElist*>(p->ptr), _vbox__IDirectory_USCORElist);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCORElist*>(p->ptr), _vbox__IDirectory_USCORElist);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCORElistResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCORElistResponse*>(p->ptr), _vbox__IDirectory_USCORElistResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCORElistResponse*>(p->ptr), _vbox__IDirectory_USCORElistResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREread*>(p->ptr), _vbox__IDirectory_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREread*>(p->ptr), _vbox__IDirectory_USCOREread);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCOREreadResponse*>(p->ptr), _vbox__IDirectory_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCOREreadResponse*>(p->ptr), _vbox__IDirectory_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCORErewind:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCORErewind*>(p->ptr), _vbox__IDirectory_USCORErewind);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCORErewind*>(p->ptr), _vbox__IDirectory_USCORErewind);
		break;
	case SOAP_TYPE__vbox__IDirectory_USCORErewindResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDirectory_USCORErewindResponse*>(p->ptr), _vbox__IDirectory_USCORErewindResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDirectory_USCORErewindResponse*>(p->ptr), _vbox__IDirectory_USCORErewindResponse);
		break;
	case SOAP_TYPE__vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestDirectory_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetEventSource*>(p->ptr), _vbox__IFile_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetEventSource*>(p->ptr), _vbox__IFile_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IFile_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IFile_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetId*>(p->ptr), _vbox__IFile_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetId*>(p->ptr), _vbox__IFile_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetIdResponse*>(p->ptr), _vbox__IFile_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetIdResponse*>(p->ptr), _vbox__IFile_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetInitialSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetInitialSize*>(p->ptr), _vbox__IFile_USCOREgetInitialSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetInitialSize*>(p->ptr), _vbox__IFile_USCOREgetInitialSize);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetInitialSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetInitialSizeResponse*>(p->ptr), _vbox__IFile_USCOREgetInitialSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetInitialSizeResponse*>(p->ptr), _vbox__IFile_USCOREgetInitialSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetOffset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetOffset*>(p->ptr), _vbox__IFile_USCOREgetOffset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetOffset*>(p->ptr), _vbox__IFile_USCOREgetOffset);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetOffsetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetOffsetResponse*>(p->ptr), _vbox__IFile_USCOREgetOffsetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetOffsetResponse*>(p->ptr), _vbox__IFile_USCOREgetOffsetResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetStatus*>(p->ptr), _vbox__IFile_USCOREgetStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetStatus*>(p->ptr), _vbox__IFile_USCOREgetStatus);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetStatusResponse*>(p->ptr), _vbox__IFile_USCOREgetStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetStatusResponse*>(p->ptr), _vbox__IFile_USCOREgetStatusResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetFilename:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetFilename*>(p->ptr), _vbox__IFile_USCOREgetFilename);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetFilename*>(p->ptr), _vbox__IFile_USCOREgetFilename);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetFilenameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetFilenameResponse*>(p->ptr), _vbox__IFile_USCOREgetFilenameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetFilenameResponse*>(p->ptr), _vbox__IFile_USCOREgetFilenameResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetCreationMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetCreationMode*>(p->ptr), _vbox__IFile_USCOREgetCreationMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetCreationMode*>(p->ptr), _vbox__IFile_USCOREgetCreationMode);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetCreationModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetCreationModeResponse*>(p->ptr), _vbox__IFile_USCOREgetCreationModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetCreationModeResponse*>(p->ptr), _vbox__IFile_USCOREgetCreationModeResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetOpenAction:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetOpenAction*>(p->ptr), _vbox__IFile_USCOREgetOpenAction);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetOpenAction*>(p->ptr), _vbox__IFile_USCOREgetOpenAction);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetOpenActionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetOpenActionResponse*>(p->ptr), _vbox__IFile_USCOREgetOpenActionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetOpenActionResponse*>(p->ptr), _vbox__IFile_USCOREgetOpenActionResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetAccessMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetAccessMode*>(p->ptr), _vbox__IFile_USCOREgetAccessMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetAccessMode*>(p->ptr), _vbox__IFile_USCOREgetAccessMode);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREgetAccessModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREgetAccessModeResponse*>(p->ptr), _vbox__IFile_USCOREgetAccessModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREgetAccessModeResponse*>(p->ptr), _vbox__IFile_USCOREgetAccessModeResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREclose:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREclose*>(p->ptr), _vbox__IFile_USCOREclose);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREclose*>(p->ptr), _vbox__IFile_USCOREclose);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREcloseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREcloseResponse*>(p->ptr), _vbox__IFile_USCOREcloseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREcloseResponse*>(p->ptr), _vbox__IFile_USCOREcloseResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREqueryInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREqueryInfo*>(p->ptr), _vbox__IFile_USCOREqueryInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREqueryInfo*>(p->ptr), _vbox__IFile_USCOREqueryInfo);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREqueryInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREqueryInfoResponse*>(p->ptr), _vbox__IFile_USCOREqueryInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREqueryInfoResponse*>(p->ptr), _vbox__IFile_USCOREqueryInfoResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREquerySize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREquerySize*>(p->ptr), _vbox__IFile_USCOREquerySize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREquerySize*>(p->ptr), _vbox__IFile_USCOREquerySize);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREquerySizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREquerySizeResponse*>(p->ptr), _vbox__IFile_USCOREquerySizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREquerySizeResponse*>(p->ptr), _vbox__IFile_USCOREquerySizeResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREread*>(p->ptr), _vbox__IFile_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREread*>(p->ptr), _vbox__IFile_USCOREread);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREreadResponse*>(p->ptr), _vbox__IFile_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREreadResponse*>(p->ptr), _vbox__IFile_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREreadAt:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREreadAt*>(p->ptr), _vbox__IFile_USCOREreadAt);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREreadAt*>(p->ptr), _vbox__IFile_USCOREreadAt);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREreadAtResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREreadAtResponse*>(p->ptr), _vbox__IFile_USCOREreadAtResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREreadAtResponse*>(p->ptr), _vbox__IFile_USCOREreadAtResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREseek:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREseek*>(p->ptr), _vbox__IFile_USCOREseek);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREseek*>(p->ptr), _vbox__IFile_USCOREseek);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREseekResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREseekResponse*>(p->ptr), _vbox__IFile_USCOREseekResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREseekResponse*>(p->ptr), _vbox__IFile_USCOREseekResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREsetACL:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREsetACL*>(p->ptr), _vbox__IFile_USCOREsetACL);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREsetACL*>(p->ptr), _vbox__IFile_USCOREsetACL);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREsetACLResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREsetACLResponse*>(p->ptr), _vbox__IFile_USCOREsetACLResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREsetACLResponse*>(p->ptr), _vbox__IFile_USCOREsetACLResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREsetSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREsetSize*>(p->ptr), _vbox__IFile_USCOREsetSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREsetSize*>(p->ptr), _vbox__IFile_USCOREsetSize);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREsetSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREsetSizeResponse*>(p->ptr), _vbox__IFile_USCOREsetSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREsetSizeResponse*>(p->ptr), _vbox__IFile_USCOREsetSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREwrite:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREwrite*>(p->ptr), _vbox__IFile_USCOREwrite);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREwrite*>(p->ptr), _vbox__IFile_USCOREwrite);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREwriteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREwriteResponse*>(p->ptr), _vbox__IFile_USCOREwriteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREwriteResponse*>(p->ptr), _vbox__IFile_USCOREwriteResponse);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREwriteAt:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREwriteAt*>(p->ptr), _vbox__IFile_USCOREwriteAt);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREwriteAt*>(p->ptr), _vbox__IFile_USCOREwriteAt);
		break;
	case SOAP_TYPE__vbox__IFile_USCOREwriteAtResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFile_USCOREwriteAtResponse*>(p->ptr), _vbox__IFile_USCOREwriteAtResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFile_USCOREwriteAtResponse*>(p->ptr), _vbox__IFile_USCOREwriteAtResponse);
		break;
	case SOAP_TYPE__vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFile_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetFreeSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetFreeSize*>(p->ptr), _vbox__IFsInfo_USCOREgetFreeSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetFreeSize*>(p->ptr), _vbox__IFsInfo_USCOREgetFreeSize);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetFreeSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetFreeSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetFreeSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetFreeSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetFreeSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetTotalSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetTotalSize*>(p->ptr), _vbox__IFsInfo_USCOREgetTotalSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetTotalSize*>(p->ptr), _vbox__IFsInfo_USCOREgetTotalSize);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetTotalSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetTotalSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetTotalSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetTotalSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetTotalSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetBlockSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetBlockSize*>(p->ptr), _vbox__IFsInfo_USCOREgetBlockSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetBlockSize*>(p->ptr), _vbox__IFsInfo_USCOREgetBlockSize);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetBlockSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetBlockSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetBlockSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetBlockSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetBlockSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSectorSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSectorSize*>(p->ptr), _vbox__IFsInfo_USCOREgetSectorSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSectorSize*>(p->ptr), _vbox__IFsInfo_USCOREgetSectorSize);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSectorSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSectorSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSectorSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSectorSizeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSectorSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSerialNumber:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSerialNumber*>(p->ptr), _vbox__IFsInfo_USCOREgetSerialNumber);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSerialNumber*>(p->ptr), _vbox__IFsInfo_USCOREgetSerialNumber);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSerialNumberResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSerialNumberResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSerialNumberResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSerialNumberResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSerialNumberResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsRemote:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsRemote*>(p->ptr), _vbox__IFsInfo_USCOREgetIsRemote);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsRemote*>(p->ptr), _vbox__IFsInfo_USCOREgetIsRemote);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsRemoteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsRemoteResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsRemoteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsRemoteResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsRemoteResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsCaseSensitive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCaseSensitive*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCaseSensitive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCaseSensitive*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCaseSensitive);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsCaseSensitiveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCaseSensitiveResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCaseSensitiveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCaseSensitiveResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCaseSensitiveResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsReadOnly:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsReadOnly*>(p->ptr), _vbox__IFsInfo_USCOREgetIsReadOnly);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsReadOnly*>(p->ptr), _vbox__IFsInfo_USCOREgetIsReadOnly);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsReadOnlyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsReadOnlyResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsReadOnlyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsReadOnlyResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsReadOnlyResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsCompressed:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCompressed*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCompressed);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCompressed*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCompressed);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetIsCompressedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCompressedResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCompressedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetIsCompressedResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetIsCompressedResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSupportsFileCompression:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSupportsFileCompression*>(p->ptr), _vbox__IFsInfo_USCOREgetSupportsFileCompression);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSupportsFileCompression*>(p->ptr), _vbox__IFsInfo_USCOREgetSupportsFileCompression);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetSupportsFileCompressionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetSupportsFileCompressionResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSupportsFileCompressionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetSupportsFileCompressionResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetSupportsFileCompressionResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetMaxComponent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetMaxComponent*>(p->ptr), _vbox__IFsInfo_USCOREgetMaxComponent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetMaxComponent*>(p->ptr), _vbox__IFsInfo_USCOREgetMaxComponent);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetMaxComponentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetMaxComponentResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetMaxComponentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetMaxComponentResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetMaxComponentResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetType*>(p->ptr), _vbox__IFsInfo_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetType*>(p->ptr), _vbox__IFsInfo_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetTypeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetTypeResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetLabel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetLabel*>(p->ptr), _vbox__IFsInfo_USCOREgetLabel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetLabel*>(p->ptr), _vbox__IFsInfo_USCOREgetLabel);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetLabelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetLabelResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetLabelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetLabelResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetLabelResponse);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetMountPoint:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetMountPoint*>(p->ptr), _vbox__IFsInfo_USCOREgetMountPoint);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetMountPoint*>(p->ptr), _vbox__IFsInfo_USCOREgetMountPoint);
		break;
	case SOAP_TYPE__vbox__IFsInfo_USCOREgetMountPointResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsInfo_USCOREgetMountPointResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetMountPointResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsInfo_USCOREgetMountPointResponse*>(p->ptr), _vbox__IFsInfo_USCOREgetMountPointResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetType*>(p->ptr), _vbox__IFsObjInfo_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetType*>(p->ptr), _vbox__IFsObjInfo_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetTypeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetTypeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetFileAttributes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetFileAttributes*>(p->ptr), _vbox__IFsObjInfo_USCOREgetFileAttributes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetFileAttributes*>(p->ptr), _vbox__IFsObjInfo_USCOREgetFileAttributes);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetFileAttributesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetFileAttributesResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetFileAttributesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetFileAttributesResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetFileAttributesResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetObjectSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetObjectSize*>(p->ptr), _vbox__IFsObjInfo_USCOREgetObjectSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetObjectSize*>(p->ptr), _vbox__IFsObjInfo_USCOREgetObjectSize);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetObjectSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetObjectSizeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetObjectSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetObjectSizeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetObjectSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetAllocatedSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAllocatedSize*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAllocatedSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAllocatedSize*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAllocatedSize);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetAllocatedSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAllocatedSizeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAllocatedSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAllocatedSizeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAllocatedSizeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetAccessTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAccessTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAccessTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAccessTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAccessTime);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetAccessTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAccessTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAccessTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetAccessTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetAccessTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetBirthTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetBirthTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetBirthTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetBirthTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetBirthTime);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetBirthTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetBirthTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetBirthTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetBirthTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetBirthTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetChangeTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetChangeTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetChangeTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetChangeTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetChangeTime);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetChangeTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetChangeTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetChangeTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetChangeTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetChangeTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetModificationTime:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetModificationTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetModificationTime);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetModificationTime*>(p->ptr), _vbox__IFsObjInfo_USCOREgetModificationTime);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetModificationTimeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetModificationTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetModificationTimeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetModificationTimeResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetModificationTimeResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUID*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUID*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUID);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUIDResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUIDResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUIDResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUserName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserName);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUserNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserNameResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGID:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGID*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGID);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGID*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGID);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGIDResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGIDResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGIDResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGIDResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGIDResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGroupName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGroupName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGroupName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGroupName*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGroupName);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGroupNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGroupNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGroupNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGroupNameResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGroupNameResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetNodeId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeId*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeId*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeId);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetNodeIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetNodeIdDevice:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdDevice*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdDevice);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdDevice*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdDevice);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetNodeIdDeviceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdDeviceResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdDeviceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetNodeIdDeviceResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetNodeIdDeviceResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetHardLinks:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetHardLinks*>(p->ptr), _vbox__IFsObjInfo_USCOREgetHardLinks);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetHardLinks*>(p->ptr), _vbox__IFsObjInfo_USCOREgetHardLinks);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetHardLinksResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetHardLinksResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetHardLinksResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetHardLinksResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetHardLinksResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetDeviceNumber:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetDeviceNumber*>(p->ptr), _vbox__IFsObjInfo_USCOREgetDeviceNumber);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetDeviceNumber*>(p->ptr), _vbox__IFsObjInfo_USCOREgetDeviceNumber);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetDeviceNumberResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetDeviceNumberResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetDeviceNumberResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetDeviceNumberResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetDeviceNumberResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGenerationId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGenerationId*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGenerationId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGenerationId*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGenerationId);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetGenerationIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGenerationIdResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGenerationIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetGenerationIdResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetGenerationIdResponse);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUserFlags:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserFlags*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserFlags);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserFlags*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserFlags);
		break;
	case SOAP_TYPE__vbox__IFsObjInfo_USCOREgetUserFlagsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserFlagsResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserFlagsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFsObjInfo_USCOREgetUserFlagsResponse*>(p->ptr), _vbox__IFsObjInfo_USCOREgetUserFlagsResponse);
		break;
	case SOAP_TYPE__vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFsInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces*>(p->ptr), _vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfaces);
		break;
	case SOAP_TYPE__vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse*>(p->ptr), _vbox__IGuestFsObjInfo_USCOREgetMidlDoesNotLikeEmptyInterfacesResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetOSTypeId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetOSTypeId*>(p->ptr), _vbox__IGuest_USCOREgetOSTypeId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetOSTypeId*>(p->ptr), _vbox__IGuest_USCOREgetOSTypeId);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetOSTypeIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetOSTypeIdResponse*>(p->ptr), _vbox__IGuest_USCOREgetOSTypeIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetOSTypeIdResponse*>(p->ptr), _vbox__IGuest_USCOREgetOSTypeIdResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsRunLevel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRunLevel*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRunLevel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRunLevel*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRunLevel);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsRunLevelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRunLevelResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRunLevelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRunLevelResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRunLevelResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsVersion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsVersion*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsVersion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsVersion*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsVersion);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsVersionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsVersionResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsVersionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsVersionResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsVersionResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsRevision:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRevision*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRevision);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRevision*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRevision);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsRevisionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRevisionResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRevisionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsRevisionResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsRevisionResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetDnDSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetDnDSource*>(p->ptr), _vbox__IGuest_USCOREgetDnDSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetDnDSource*>(p->ptr), _vbox__IGuest_USCOREgetDnDSource);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetDnDSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetDnDSourceResponse*>(p->ptr), _vbox__IGuest_USCOREgetDnDSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetDnDSourceResponse*>(p->ptr), _vbox__IGuest_USCOREgetDnDSourceResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetDnDTarget:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetDnDTarget*>(p->ptr), _vbox__IGuest_USCOREgetDnDTarget);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetDnDTarget*>(p->ptr), _vbox__IGuest_USCOREgetDnDTarget);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetDnDTargetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetDnDTargetResponse*>(p->ptr), _vbox__IGuest_USCOREgetDnDTargetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetDnDTargetResponse*>(p->ptr), _vbox__IGuest_USCOREgetDnDTargetResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetEventSource*>(p->ptr), _vbox__IGuest_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetEventSource*>(p->ptr), _vbox__IGuest_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IGuest_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IGuest_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetFacilities:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetFacilities*>(p->ptr), _vbox__IGuest_USCOREgetFacilities);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetFacilities*>(p->ptr), _vbox__IGuest_USCOREgetFacilities);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetFacilitiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetFacilitiesResponse*>(p->ptr), _vbox__IGuest_USCOREgetFacilitiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetFacilitiesResponse*>(p->ptr), _vbox__IGuest_USCOREgetFacilitiesResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetSessions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetSessions*>(p->ptr), _vbox__IGuest_USCOREgetSessions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetSessions*>(p->ptr), _vbox__IGuest_USCOREgetSessions);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetSessionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetSessionsResponse*>(p->ptr), _vbox__IGuest_USCOREgetSessionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetSessionsResponse*>(p->ptr), _vbox__IGuest_USCOREgetSessionsResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetMemoryBalloonSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetMemoryBalloonSize*>(p->ptr), _vbox__IGuest_USCOREgetMemoryBalloonSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetMemoryBalloonSize*>(p->ptr), _vbox__IGuest_USCOREgetMemoryBalloonSize);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetMemoryBalloonSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IGuest_USCOREgetMemoryBalloonSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IGuest_USCOREgetMemoryBalloonSizeResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetMemoryBalloonSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetMemoryBalloonSize*>(p->ptr), _vbox__IGuest_USCOREsetMemoryBalloonSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetMemoryBalloonSize*>(p->ptr), _vbox__IGuest_USCOREsetMemoryBalloonSize);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetMemoryBalloonSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IGuest_USCOREsetMemoryBalloonSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetMemoryBalloonSizeResponse*>(p->ptr), _vbox__IGuest_USCOREsetMemoryBalloonSizeResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetStatisticsUpdateInterval:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetStatisticsUpdateInterval*>(p->ptr), _vbox__IGuest_USCOREgetStatisticsUpdateInterval);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetStatisticsUpdateInterval*>(p->ptr), _vbox__IGuest_USCOREgetStatisticsUpdateInterval);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetStatisticsUpdateIntervalResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetStatisticsUpdateIntervalResponse*>(p->ptr), _vbox__IGuest_USCOREgetStatisticsUpdateIntervalResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetStatisticsUpdateIntervalResponse*>(p->ptr), _vbox__IGuest_USCOREgetStatisticsUpdateIntervalResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetStatisticsUpdateInterval:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetStatisticsUpdateInterval*>(p->ptr), _vbox__IGuest_USCOREsetStatisticsUpdateInterval);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetStatisticsUpdateInterval*>(p->ptr), _vbox__IGuest_USCOREsetStatisticsUpdateInterval);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetStatisticsUpdateIntervalResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetStatisticsUpdateIntervalResponse*>(p->ptr), _vbox__IGuest_USCOREsetStatisticsUpdateIntervalResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetStatisticsUpdateIntervalResponse*>(p->ptr), _vbox__IGuest_USCOREsetStatisticsUpdateIntervalResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREinternalGetStatistics:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREinternalGetStatistics*>(p->ptr), _vbox__IGuest_USCOREinternalGetStatistics);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREinternalGetStatistics*>(p->ptr), _vbox__IGuest_USCOREinternalGetStatistics);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREinternalGetStatisticsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREinternalGetStatisticsResponse*>(p->ptr), _vbox__IGuest_USCOREinternalGetStatisticsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREinternalGetStatisticsResponse*>(p->ptr), _vbox__IGuest_USCOREinternalGetStatisticsResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetFacilityStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetFacilityStatus*>(p->ptr), _vbox__IGuest_USCOREgetFacilityStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetFacilityStatus*>(p->ptr), _vbox__IGuest_USCOREgetFacilityStatus);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetFacilityStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetFacilityStatusResponse*>(p->ptr), _vbox__IGuest_USCOREgetFacilityStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetFacilityStatusResponse*>(p->ptr), _vbox__IGuest_USCOREgetFacilityStatusResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsStatus*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsStatus*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsStatus);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREgetAdditionsStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsStatusResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREgetAdditionsStatusResponse*>(p->ptr), _vbox__IGuest_USCOREgetAdditionsStatusResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetCredentials:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetCredentials*>(p->ptr), _vbox__IGuest_USCOREsetCredentials);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetCredentials*>(p->ptr), _vbox__IGuest_USCOREsetCredentials);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREsetCredentialsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREsetCredentialsResponse*>(p->ptr), _vbox__IGuest_USCOREsetCredentialsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREsetCredentialsResponse*>(p->ptr), _vbox__IGuest_USCOREsetCredentialsResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREcreateSession:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREcreateSession*>(p->ptr), _vbox__IGuest_USCOREcreateSession);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREcreateSession*>(p->ptr), _vbox__IGuest_USCOREcreateSession);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREcreateSessionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREcreateSessionResponse*>(p->ptr), _vbox__IGuest_USCOREcreateSessionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREcreateSessionResponse*>(p->ptr), _vbox__IGuest_USCOREcreateSessionResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREfindSession:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREfindSession*>(p->ptr), _vbox__IGuest_USCOREfindSession);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREfindSession*>(p->ptr), _vbox__IGuest_USCOREfindSession);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREfindSessionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREfindSessionResponse*>(p->ptr), _vbox__IGuest_USCOREfindSessionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREfindSessionResponse*>(p->ptr), _vbox__IGuest_USCOREfindSessionResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREshutdown:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREshutdown*>(p->ptr), _vbox__IGuest_USCOREshutdown);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREshutdown*>(p->ptr), _vbox__IGuest_USCOREshutdown);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREshutdownResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREshutdownResponse*>(p->ptr), _vbox__IGuest_USCOREshutdownResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREshutdownResponse*>(p->ptr), _vbox__IGuest_USCOREshutdownResponse);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREupdateGuestAdditions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREupdateGuestAdditions*>(p->ptr), _vbox__IGuest_USCOREupdateGuestAdditions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREupdateGuestAdditions*>(p->ptr), _vbox__IGuest_USCOREupdateGuestAdditions);
		break;
	case SOAP_TYPE__vbox__IGuest_USCOREupdateGuestAdditionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuest_USCOREupdateGuestAdditionsResponse*>(p->ptr), _vbox__IGuest_USCOREupdateGuestAdditionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuest_USCOREupdateGuestAdditionsResponse*>(p->ptr), _vbox__IGuest_USCOREupdateGuestAdditionsResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetId*>(p->ptr), _vbox__IProgress_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetId*>(p->ptr), _vbox__IProgress_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetIdResponse*>(p->ptr), _vbox__IProgress_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetIdResponse*>(p->ptr), _vbox__IProgress_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetDescription*>(p->ptr), _vbox__IProgress_USCOREgetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetDescription*>(p->ptr), _vbox__IProgress_USCOREgetDescription);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IProgress_USCOREgetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IProgress_USCOREgetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetInitiator:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetInitiator*>(p->ptr), _vbox__IProgress_USCOREgetInitiator);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetInitiator*>(p->ptr), _vbox__IProgress_USCOREgetInitiator);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetInitiatorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetInitiatorResponse*>(p->ptr), _vbox__IProgress_USCOREgetInitiatorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetInitiatorResponse*>(p->ptr), _vbox__IProgress_USCOREgetInitiatorResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCancelable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCancelable*>(p->ptr), _vbox__IProgress_USCOREgetCancelable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCancelable*>(p->ptr), _vbox__IProgress_USCOREgetCancelable);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCancelableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCancelableResponse*>(p->ptr), _vbox__IProgress_USCOREgetCancelableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCancelableResponse*>(p->ptr), _vbox__IProgress_USCOREgetCancelableResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetPercent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetPercent*>(p->ptr), _vbox__IProgress_USCOREgetPercent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetPercent*>(p->ptr), _vbox__IProgress_USCOREgetPercent);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetPercentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetPercentResponse*>(p->ptr), _vbox__IProgress_USCOREgetPercentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetPercentResponse*>(p->ptr), _vbox__IProgress_USCOREgetPercentResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetTimeRemaining:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetTimeRemaining*>(p->ptr), _vbox__IProgress_USCOREgetTimeRemaining);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetTimeRemaining*>(p->ptr), _vbox__IProgress_USCOREgetTimeRemaining);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetTimeRemainingResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetTimeRemainingResponse*>(p->ptr), _vbox__IProgress_USCOREgetTimeRemainingResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetTimeRemainingResponse*>(p->ptr), _vbox__IProgress_USCOREgetTimeRemainingResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCompleted:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCompleted*>(p->ptr), _vbox__IProgress_USCOREgetCompleted);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCompleted*>(p->ptr), _vbox__IProgress_USCOREgetCompleted);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCompletedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCompletedResponse*>(p->ptr), _vbox__IProgress_USCOREgetCompletedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCompletedResponse*>(p->ptr), _vbox__IProgress_USCOREgetCompletedResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCanceled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCanceled*>(p->ptr), _vbox__IProgress_USCOREgetCanceled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCanceled*>(p->ptr), _vbox__IProgress_USCOREgetCanceled);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetCanceledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetCanceledResponse*>(p->ptr), _vbox__IProgress_USCOREgetCanceledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetCanceledResponse*>(p->ptr), _vbox__IProgress_USCOREgetCanceledResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetResultCode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetResultCode*>(p->ptr), _vbox__IProgress_USCOREgetResultCode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetResultCode*>(p->ptr), _vbox__IProgress_USCOREgetResultCode);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetResultCodeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetResultCodeResponse*>(p->ptr), _vbox__IProgress_USCOREgetResultCodeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetResultCodeResponse*>(p->ptr), _vbox__IProgress_USCOREgetResultCodeResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetErrorInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetErrorInfo*>(p->ptr), _vbox__IProgress_USCOREgetErrorInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetErrorInfo*>(p->ptr), _vbox__IProgress_USCOREgetErrorInfo);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetErrorInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetErrorInfoResponse*>(p->ptr), _vbox__IProgress_USCOREgetErrorInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetErrorInfoResponse*>(p->ptr), _vbox__IProgress_USCOREgetErrorInfoResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationCount*>(p->ptr), _vbox__IProgress_USCOREgetOperationCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationCount*>(p->ptr), _vbox__IProgress_USCOREgetOperationCount);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationCountResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationCountResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationCountResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperation:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperation*>(p->ptr), _vbox__IProgress_USCOREgetOperation);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperation*>(p->ptr), _vbox__IProgress_USCOREgetOperation);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationDescription*>(p->ptr), _vbox__IProgress_USCOREgetOperationDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationDescription*>(p->ptr), _vbox__IProgress_USCOREgetOperationDescription);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationDescriptionResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationDescriptionResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationPercent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationPercent*>(p->ptr), _vbox__IProgress_USCOREgetOperationPercent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationPercent*>(p->ptr), _vbox__IProgress_USCOREgetOperationPercent);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationPercentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationPercentResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationPercentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationPercentResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationPercentResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationWeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationWeight*>(p->ptr), _vbox__IProgress_USCOREgetOperationWeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationWeight*>(p->ptr), _vbox__IProgress_USCOREgetOperationWeight);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetOperationWeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetOperationWeightResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationWeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetOperationWeightResponse*>(p->ptr), _vbox__IProgress_USCOREgetOperationWeightResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetTimeout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetTimeout*>(p->ptr), _vbox__IProgress_USCOREgetTimeout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetTimeout*>(p->ptr), _vbox__IProgress_USCOREgetTimeout);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetTimeoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetTimeoutResponse*>(p->ptr), _vbox__IProgress_USCOREgetTimeoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetTimeoutResponse*>(p->ptr), _vbox__IProgress_USCOREgetTimeoutResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREsetTimeout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREsetTimeout*>(p->ptr), _vbox__IProgress_USCOREsetTimeout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREsetTimeout*>(p->ptr), _vbox__IProgress_USCOREsetTimeout);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREsetTimeoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREsetTimeoutResponse*>(p->ptr), _vbox__IProgress_USCOREsetTimeoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREsetTimeoutResponse*>(p->ptr), _vbox__IProgress_USCOREsetTimeoutResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetEventSource*>(p->ptr), _vbox__IProgress_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetEventSource*>(p->ptr), _vbox__IProgress_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IProgress_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IProgress_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREwaitForCompletion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREwaitForCompletion*>(p->ptr), _vbox__IProgress_USCOREwaitForCompletion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREwaitForCompletion*>(p->ptr), _vbox__IProgress_USCOREwaitForCompletion);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREwaitForCompletionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREwaitForCompletionResponse*>(p->ptr), _vbox__IProgress_USCOREwaitForCompletionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREwaitForCompletionResponse*>(p->ptr), _vbox__IProgress_USCOREwaitForCompletionResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREwaitForOperationCompletion:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREwaitForOperationCompletion*>(p->ptr), _vbox__IProgress_USCOREwaitForOperationCompletion);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREwaitForOperationCompletion*>(p->ptr), _vbox__IProgress_USCOREwaitForOperationCompletion);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREwaitForOperationCompletionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREwaitForOperationCompletionResponse*>(p->ptr), _vbox__IProgress_USCOREwaitForOperationCompletionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREwaitForOperationCompletionResponse*>(p->ptr), _vbox__IProgress_USCOREwaitForOperationCompletionResponse);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREcancel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREcancel*>(p->ptr), _vbox__IProgress_USCOREcancel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREcancel*>(p->ptr), _vbox__IProgress_USCOREcancel);
		break;
	case SOAP_TYPE__vbox__IProgress_USCOREcancelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IProgress_USCOREcancelResponse*>(p->ptr), _vbox__IProgress_USCOREcancelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IProgress_USCOREcancelResponse*>(p->ptr), _vbox__IProgress_USCOREcancelResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetId*>(p->ptr), _vbox__ISnapshot_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetId*>(p->ptr), _vbox__ISnapshot_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetIdResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetIdResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetName*>(p->ptr), _vbox__ISnapshot_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetName*>(p->ptr), _vbox__ISnapshot_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetNameResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetNameResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREsetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREsetName*>(p->ptr), _vbox__ISnapshot_USCOREsetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREsetName*>(p->ptr), _vbox__ISnapshot_USCOREsetName);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREsetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREsetNameResponse*>(p->ptr), _vbox__ISnapshot_USCOREsetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREsetNameResponse*>(p->ptr), _vbox__ISnapshot_USCOREsetNameResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetDescription*>(p->ptr), _vbox__ISnapshot_USCOREgetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetDescription*>(p->ptr), _vbox__ISnapshot_USCOREgetDescription);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetDescriptionResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetDescriptionResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREsetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREsetDescription*>(p->ptr), _vbox__ISnapshot_USCOREsetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREsetDescription*>(p->ptr), _vbox__ISnapshot_USCOREsetDescription);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREsetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREsetDescriptionResponse*>(p->ptr), _vbox__ISnapshot_USCOREsetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREsetDescriptionResponse*>(p->ptr), _vbox__ISnapshot_USCOREsetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetTimeStamp:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetTimeStamp*>(p->ptr), _vbox__ISnapshot_USCOREgetTimeStamp);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetTimeStamp*>(p->ptr), _vbox__ISnapshot_USCOREgetTimeStamp);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetTimeStampResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetTimeStampResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetTimeStampResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetTimeStampResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetTimeStampResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetOnline:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetOnline*>(p->ptr), _vbox__ISnapshot_USCOREgetOnline);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetOnline*>(p->ptr), _vbox__ISnapshot_USCOREgetOnline);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetOnlineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetOnlineResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetOnlineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetOnlineResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetOnlineResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetMachine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetMachine*>(p->ptr), _vbox__ISnapshot_USCOREgetMachine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetMachine*>(p->ptr), _vbox__ISnapshot_USCOREgetMachine);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetMachineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetMachineResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetMachineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetMachineResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetMachineResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetParent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetParent*>(p->ptr), _vbox__ISnapshot_USCOREgetParent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetParent*>(p->ptr), _vbox__ISnapshot_USCOREgetParent);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetParentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetParentResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetParentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetParentResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetParentResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetChildren:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetChildren*>(p->ptr), _vbox__ISnapshot_USCOREgetChildren);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetChildren*>(p->ptr), _vbox__ISnapshot_USCOREgetChildren);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetChildrenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenResponse);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetChildrenCount:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenCount*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenCount);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenCount*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenCount);
		break;
	case SOAP_TYPE__vbox__ISnapshot_USCOREgetChildrenCountResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenCountResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenCountResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISnapshot_USCOREgetChildrenCountResponse*>(p->ptr), _vbox__ISnapshot_USCOREgetChildrenCountResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetId*>(p->ptr), _vbox__IMedium_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetId*>(p->ptr), _vbox__IMedium_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetIdResponse*>(p->ptr), _vbox__IMedium_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetIdResponse*>(p->ptr), _vbox__IMedium_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetDescription*>(p->ptr), _vbox__IMedium_USCOREgetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetDescription*>(p->ptr), _vbox__IMedium_USCOREgetDescription);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IMedium_USCOREgetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetDescriptionResponse*>(p->ptr), _vbox__IMedium_USCOREgetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetDescription:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetDescription*>(p->ptr), _vbox__IMedium_USCOREsetDescription);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetDescription*>(p->ptr), _vbox__IMedium_USCOREsetDescription);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetDescriptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetDescriptionResponse*>(p->ptr), _vbox__IMedium_USCOREsetDescriptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetDescriptionResponse*>(p->ptr), _vbox__IMedium_USCOREsetDescriptionResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetState*>(p->ptr), _vbox__IMedium_USCOREgetState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetState*>(p->ptr), _vbox__IMedium_USCOREgetState);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetStateResponse*>(p->ptr), _vbox__IMedium_USCOREgetStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetStateResponse*>(p->ptr), _vbox__IMedium_USCOREgetStateResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetVariant:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetVariant*>(p->ptr), _vbox__IMedium_USCOREgetVariant);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetVariant*>(p->ptr), _vbox__IMedium_USCOREgetVariant);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetVariantResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetVariantResponse*>(p->ptr), _vbox__IMedium_USCOREgetVariantResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetVariantResponse*>(p->ptr), _vbox__IMedium_USCOREgetVariantResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLocation:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLocation*>(p->ptr), _vbox__IMedium_USCOREgetLocation);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLocation*>(p->ptr), _vbox__IMedium_USCOREgetLocation);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLocationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLocationResponse*>(p->ptr), _vbox__IMedium_USCOREgetLocationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLocationResponse*>(p->ptr), _vbox__IMedium_USCOREgetLocationResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetLocation:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetLocation*>(p->ptr), _vbox__IMedium_USCOREsetLocation);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetLocation*>(p->ptr), _vbox__IMedium_USCOREsetLocation);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetLocationResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetLocationResponse*>(p->ptr), _vbox__IMedium_USCOREsetLocationResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetLocationResponse*>(p->ptr), _vbox__IMedium_USCOREsetLocationResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetName*>(p->ptr), _vbox__IMedium_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetName*>(p->ptr), _vbox__IMedium_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetNameResponse*>(p->ptr), _vbox__IMedium_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetNameResponse*>(p->ptr), _vbox__IMedium_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetDeviceType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetDeviceType*>(p->ptr), _vbox__IMedium_USCOREgetDeviceType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetDeviceType*>(p->ptr), _vbox__IMedium_USCOREgetDeviceType);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetDeviceTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetDeviceTypeResponse*>(p->ptr), _vbox__IMedium_USCOREgetDeviceTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetDeviceTypeResponse*>(p->ptr), _vbox__IMedium_USCOREgetDeviceTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetHostDrive:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetHostDrive*>(p->ptr), _vbox__IMedium_USCOREgetHostDrive);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetHostDrive*>(p->ptr), _vbox__IMedium_USCOREgetHostDrive);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetHostDriveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetHostDriveResponse*>(p->ptr), _vbox__IMedium_USCOREgetHostDriveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetHostDriveResponse*>(p->ptr), _vbox__IMedium_USCOREgetHostDriveResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetSize*>(p->ptr), _vbox__IMedium_USCOREgetSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetSize*>(p->ptr), _vbox__IMedium_USCOREgetSize);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetSizeResponse*>(p->ptr), _vbox__IMedium_USCOREgetSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetSizeResponse*>(p->ptr), _vbox__IMedium_USCOREgetSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetFormat:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetFormat*>(p->ptr), _vbox__IMedium_USCOREgetFormat);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetFormat*>(p->ptr), _vbox__IMedium_USCOREgetFormat);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetFormatResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetFormatResponse*>(p->ptr), _vbox__IMedium_USCOREgetFormatResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetFormatResponse*>(p->ptr), _vbox__IMedium_USCOREgetFormatResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetMediumFormat:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetMediumFormat*>(p->ptr), _vbox__IMedium_USCOREgetMediumFormat);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetMediumFormat*>(p->ptr), _vbox__IMedium_USCOREgetMediumFormat);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetMediumFormatResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetMediumFormatResponse*>(p->ptr), _vbox__IMedium_USCOREgetMediumFormatResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetMediumFormatResponse*>(p->ptr), _vbox__IMedium_USCOREgetMediumFormatResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetType*>(p->ptr), _vbox__IMedium_USCOREgetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetType*>(p->ptr), _vbox__IMedium_USCOREgetType);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetTypeResponse*>(p->ptr), _vbox__IMedium_USCOREgetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetTypeResponse*>(p->ptr), _vbox__IMedium_USCOREgetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetType*>(p->ptr), _vbox__IMedium_USCOREsetType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetType*>(p->ptr), _vbox__IMedium_USCOREsetType);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetTypeResponse*>(p->ptr), _vbox__IMedium_USCOREsetTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetTypeResponse*>(p->ptr), _vbox__IMedium_USCOREsetTypeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetAllowedTypes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetAllowedTypes*>(p->ptr), _vbox__IMedium_USCOREgetAllowedTypes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetAllowedTypes*>(p->ptr), _vbox__IMedium_USCOREgetAllowedTypes);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetAllowedTypesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetAllowedTypesResponse*>(p->ptr), _vbox__IMedium_USCOREgetAllowedTypesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetAllowedTypesResponse*>(p->ptr), _vbox__IMedium_USCOREgetAllowedTypesResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetParent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetParent*>(p->ptr), _vbox__IMedium_USCOREgetParent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetParent*>(p->ptr), _vbox__IMedium_USCOREgetParent);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetParentResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetParentResponse*>(p->ptr), _vbox__IMedium_USCOREgetParentResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetParentResponse*>(p->ptr), _vbox__IMedium_USCOREgetParentResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetChildren:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetChildren*>(p->ptr), _vbox__IMedium_USCOREgetChildren);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetChildren*>(p->ptr), _vbox__IMedium_USCOREgetChildren);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetChildrenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetChildrenResponse*>(p->ptr), _vbox__IMedium_USCOREgetChildrenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetChildrenResponse*>(p->ptr), _vbox__IMedium_USCOREgetChildrenResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetBase:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetBase*>(p->ptr), _vbox__IMedium_USCOREgetBase);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetBase*>(p->ptr), _vbox__IMedium_USCOREgetBase);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetBaseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetBaseResponse*>(p->ptr), _vbox__IMedium_USCOREgetBaseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetBaseResponse*>(p->ptr), _vbox__IMedium_USCOREgetBaseResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetReadOnly:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetReadOnly*>(p->ptr), _vbox__IMedium_USCOREgetReadOnly);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetReadOnly*>(p->ptr), _vbox__IMedium_USCOREgetReadOnly);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetReadOnlyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetReadOnlyResponse*>(p->ptr), _vbox__IMedium_USCOREgetReadOnlyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetReadOnlyResponse*>(p->ptr), _vbox__IMedium_USCOREgetReadOnlyResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLogicalSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLogicalSize*>(p->ptr), _vbox__IMedium_USCOREgetLogicalSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLogicalSize*>(p->ptr), _vbox__IMedium_USCOREgetLogicalSize);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLogicalSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLogicalSizeResponse*>(p->ptr), _vbox__IMedium_USCOREgetLogicalSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLogicalSizeResponse*>(p->ptr), _vbox__IMedium_USCOREgetLogicalSizeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetAutoReset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetAutoReset*>(p->ptr), _vbox__IMedium_USCOREgetAutoReset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetAutoReset*>(p->ptr), _vbox__IMedium_USCOREgetAutoReset);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetAutoResetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetAutoResetResponse*>(p->ptr), _vbox__IMedium_USCOREgetAutoResetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetAutoResetResponse*>(p->ptr), _vbox__IMedium_USCOREgetAutoResetResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetAutoReset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetAutoReset*>(p->ptr), _vbox__IMedium_USCOREsetAutoReset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetAutoReset*>(p->ptr), _vbox__IMedium_USCOREsetAutoReset);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetAutoResetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetAutoResetResponse*>(p->ptr), _vbox__IMedium_USCOREsetAutoResetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetAutoResetResponse*>(p->ptr), _vbox__IMedium_USCOREsetAutoResetResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLastAccessError:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLastAccessError*>(p->ptr), _vbox__IMedium_USCOREgetLastAccessError);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLastAccessError*>(p->ptr), _vbox__IMedium_USCOREgetLastAccessError);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetLastAccessErrorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetLastAccessErrorResponse*>(p->ptr), _vbox__IMedium_USCOREgetLastAccessErrorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetLastAccessErrorResponse*>(p->ptr), _vbox__IMedium_USCOREgetLastAccessErrorResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetMachineIds:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetMachineIds*>(p->ptr), _vbox__IMedium_USCOREgetMachineIds);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetMachineIds*>(p->ptr), _vbox__IMedium_USCOREgetMachineIds);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetMachineIdsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetMachineIdsResponse*>(p->ptr), _vbox__IMedium_USCOREgetMachineIdsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetMachineIdsResponse*>(p->ptr), _vbox__IMedium_USCOREgetMachineIdsResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetIds:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetIds*>(p->ptr), _vbox__IMedium_USCOREsetIds);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetIds*>(p->ptr), _vbox__IMedium_USCOREsetIds);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetIdsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetIdsResponse*>(p->ptr), _vbox__IMedium_USCOREsetIdsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetIdsResponse*>(p->ptr), _vbox__IMedium_USCOREsetIdsResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORErefreshState:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORErefreshState*>(p->ptr), _vbox__IMedium_USCORErefreshState);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORErefreshState*>(p->ptr), _vbox__IMedium_USCORErefreshState);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORErefreshStateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORErefreshStateResponse*>(p->ptr), _vbox__IMedium_USCORErefreshStateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORErefreshStateResponse*>(p->ptr), _vbox__IMedium_USCORErefreshStateResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetSnapshotIds:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetSnapshotIds*>(p->ptr), _vbox__IMedium_USCOREgetSnapshotIds);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetSnapshotIds*>(p->ptr), _vbox__IMedium_USCOREgetSnapshotIds);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetSnapshotIdsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetSnapshotIdsResponse*>(p->ptr), _vbox__IMedium_USCOREgetSnapshotIdsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetSnapshotIdsResponse*>(p->ptr), _vbox__IMedium_USCOREgetSnapshotIdsResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORElockRead:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORElockRead*>(p->ptr), _vbox__IMedium_USCORElockRead);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORElockRead*>(p->ptr), _vbox__IMedium_USCORElockRead);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORElockReadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORElockReadResponse*>(p->ptr), _vbox__IMedium_USCORElockReadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORElockReadResponse*>(p->ptr), _vbox__IMedium_USCORElockReadResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORElockWrite:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORElockWrite*>(p->ptr), _vbox__IMedium_USCORElockWrite);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORElockWrite*>(p->ptr), _vbox__IMedium_USCORElockWrite);
		break;
	case SOAP_TYPE__vbox__IMedium_USCORElockWriteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCORElockWriteResponse*>(p->ptr), _vbox__IMedium_USCORElockWriteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCORElockWriteResponse*>(p->ptr), _vbox__IMedium_USCORElockWriteResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREclose:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREclose*>(p->ptr), _vbox__IMedium_USCOREclose);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREclose*>(p->ptr), _vbox__IMedium_USCOREclose);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcloseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcloseResponse*>(p->ptr), _vbox__IMedium_USCOREcloseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcloseResponse*>(p->ptr), _vbox__IMedium_USCOREcloseResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetProperty*>(p->ptr), _vbox__IMedium_USCOREgetProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetProperty*>(p->ptr), _vbox__IMedium_USCOREgetProperty);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetPropertyResponse*>(p->ptr), _vbox__IMedium_USCOREgetPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetPropertyResponse*>(p->ptr), _vbox__IMedium_USCOREgetPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetProperty*>(p->ptr), _vbox__IMedium_USCOREsetProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetProperty*>(p->ptr), _vbox__IMedium_USCOREsetProperty);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetPropertyResponse*>(p->ptr), _vbox__IMedium_USCOREsetPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetPropertyResponse*>(p->ptr), _vbox__IMedium_USCOREsetPropertyResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetProperties*>(p->ptr), _vbox__IMedium_USCOREgetProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetProperties*>(p->ptr), _vbox__IMedium_USCOREgetProperties);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetPropertiesResponse*>(p->ptr), _vbox__IMedium_USCOREgetPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetPropertiesResponse*>(p->ptr), _vbox__IMedium_USCOREgetPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetProperties*>(p->ptr), _vbox__IMedium_USCOREsetProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetProperties*>(p->ptr), _vbox__IMedium_USCOREsetProperties);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREsetPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREsetPropertiesResponse*>(p->ptr), _vbox__IMedium_USCOREsetPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREsetPropertiesResponse*>(p->ptr), _vbox__IMedium_USCOREsetPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcreateBaseStorage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcreateBaseStorage*>(p->ptr), _vbox__IMedium_USCOREcreateBaseStorage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcreateBaseStorage*>(p->ptr), _vbox__IMedium_USCOREcreateBaseStorage);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcreateBaseStorageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcreateBaseStorageResponse*>(p->ptr), _vbox__IMedium_USCOREcreateBaseStorageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcreateBaseStorageResponse*>(p->ptr), _vbox__IMedium_USCOREcreateBaseStorageResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREdeleteStorage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREdeleteStorage*>(p->ptr), _vbox__IMedium_USCOREdeleteStorage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREdeleteStorage*>(p->ptr), _vbox__IMedium_USCOREdeleteStorage);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREdeleteStorageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREdeleteStorageResponse*>(p->ptr), _vbox__IMedium_USCOREdeleteStorageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREdeleteStorageResponse*>(p->ptr), _vbox__IMedium_USCOREdeleteStorageResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcreateDiffStorage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcreateDiffStorage*>(p->ptr), _vbox__IMedium_USCOREcreateDiffStorage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcreateDiffStorage*>(p->ptr), _vbox__IMedium_USCOREcreateDiffStorage);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcreateDiffStorageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcreateDiffStorageResponse*>(p->ptr), _vbox__IMedium_USCOREcreateDiffStorageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcreateDiffStorageResponse*>(p->ptr), _vbox__IMedium_USCOREcreateDiffStorageResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREmergeTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREmergeTo*>(p->ptr), _vbox__IMedium_USCOREmergeTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREmergeTo*>(p->ptr), _vbox__IMedium_USCOREmergeTo);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREmergeToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREmergeToResponse*>(p->ptr), _vbox__IMedium_USCOREmergeToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREmergeToResponse*>(p->ptr), _vbox__IMedium_USCOREmergeToResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcloneTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcloneTo*>(p->ptr), _vbox__IMedium_USCOREcloneTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcloneTo*>(p->ptr), _vbox__IMedium_USCOREcloneTo);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcloneToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcloneToResponse*>(p->ptr), _vbox__IMedium_USCOREcloneToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcloneToResponse*>(p->ptr), _vbox__IMedium_USCOREcloneToResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcloneToBase:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcloneToBase*>(p->ptr), _vbox__IMedium_USCOREcloneToBase);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcloneToBase*>(p->ptr), _vbox__IMedium_USCOREcloneToBase);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcloneToBaseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcloneToBaseResponse*>(p->ptr), _vbox__IMedium_USCOREcloneToBaseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcloneToBaseResponse*>(p->ptr), _vbox__IMedium_USCOREcloneToBaseResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREmoveTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREmoveTo*>(p->ptr), _vbox__IMedium_USCOREmoveTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREmoveTo*>(p->ptr), _vbox__IMedium_USCOREmoveTo);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREmoveToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREmoveToResponse*>(p->ptr), _vbox__IMedium_USCOREmoveToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREmoveToResponse*>(p->ptr), _vbox__IMedium_USCOREmoveToResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcompact:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcompact*>(p->ptr), _vbox__IMedium_USCOREcompact);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcompact*>(p->ptr), _vbox__IMedium_USCOREcompact);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcompactResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcompactResponse*>(p->ptr), _vbox__IMedium_USCOREcompactResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcompactResponse*>(p->ptr), _vbox__IMedium_USCOREcompactResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREresize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREresize*>(p->ptr), _vbox__IMedium_USCOREresize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREresize*>(p->ptr), _vbox__IMedium_USCOREresize);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREresizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREresizeResponse*>(p->ptr), _vbox__IMedium_USCOREresizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREresizeResponse*>(p->ptr), _vbox__IMedium_USCOREresizeResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREreset:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREreset*>(p->ptr), _vbox__IMedium_USCOREreset);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREreset*>(p->ptr), _vbox__IMedium_USCOREreset);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREresetResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREresetResponse*>(p->ptr), _vbox__IMedium_USCOREresetResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREresetResponse*>(p->ptr), _vbox__IMedium_USCOREresetResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREchangeEncryption:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREchangeEncryption*>(p->ptr), _vbox__IMedium_USCOREchangeEncryption);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREchangeEncryption*>(p->ptr), _vbox__IMedium_USCOREchangeEncryption);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREchangeEncryptionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREchangeEncryptionResponse*>(p->ptr), _vbox__IMedium_USCOREchangeEncryptionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREchangeEncryptionResponse*>(p->ptr), _vbox__IMedium_USCOREchangeEncryptionResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetEncryptionSettings:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetEncryptionSettings*>(p->ptr), _vbox__IMedium_USCOREgetEncryptionSettings);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetEncryptionSettings*>(p->ptr), _vbox__IMedium_USCOREgetEncryptionSettings);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREgetEncryptionSettingsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREgetEncryptionSettingsResponse*>(p->ptr), _vbox__IMedium_USCOREgetEncryptionSettingsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREgetEncryptionSettingsResponse*>(p->ptr), _vbox__IMedium_USCOREgetEncryptionSettingsResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcheckEncryptionPassword:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcheckEncryptionPassword*>(p->ptr), _vbox__IMedium_USCOREcheckEncryptionPassword);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcheckEncryptionPassword*>(p->ptr), _vbox__IMedium_USCOREcheckEncryptionPassword);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREcheckEncryptionPasswordResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREcheckEncryptionPasswordResponse*>(p->ptr), _vbox__IMedium_USCOREcheckEncryptionPasswordResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREcheckEncryptionPasswordResponse*>(p->ptr), _vbox__IMedium_USCOREcheckEncryptionPasswordResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREopenForIO:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREopenForIO*>(p->ptr), _vbox__IMedium_USCOREopenForIO);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREopenForIO*>(p->ptr), _vbox__IMedium_USCOREopenForIO);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREopenForIOResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREopenForIOResponse*>(p->ptr), _vbox__IMedium_USCOREopenForIOResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREopenForIOResponse*>(p->ptr), _vbox__IMedium_USCOREopenForIOResponse);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREresizeAndCloneTo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREresizeAndCloneTo*>(p->ptr), _vbox__IMedium_USCOREresizeAndCloneTo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREresizeAndCloneTo*>(p->ptr), _vbox__IMedium_USCOREresizeAndCloneTo);
		break;
	case SOAP_TYPE__vbox__IMedium_USCOREresizeAndCloneToResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMedium_USCOREresizeAndCloneToResponse*>(p->ptr), _vbox__IMedium_USCOREresizeAndCloneToResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMedium_USCOREresizeAndCloneToResponse*>(p->ptr), _vbox__IMedium_USCOREresizeAndCloneToResponse);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetId*>(p->ptr), _vbox__IMediumFormat_USCOREgetId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetId*>(p->ptr), _vbox__IMediumFormat_USCOREgetId);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetIdResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetIdResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetIdResponse);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetName:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetName*>(p->ptr), _vbox__IMediumFormat_USCOREgetName);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetName*>(p->ptr), _vbox__IMediumFormat_USCOREgetName);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetNameResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetNameResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetNameResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetNameResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetNameResponse);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetCapabilities:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetCapabilities*>(p->ptr), _vbox__IMediumFormat_USCOREgetCapabilities);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetCapabilities*>(p->ptr), _vbox__IMediumFormat_USCOREgetCapabilities);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREgetCapabilitiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREgetCapabilitiesResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetCapabilitiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREgetCapabilitiesResponse*>(p->ptr), _vbox__IMediumFormat_USCOREgetCapabilitiesResponse);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREdescribeFileExtensions:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeFileExtensions*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeFileExtensions);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeFileExtensions*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeFileExtensions);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREdescribeFileExtensionsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeFileExtensionsResponse*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeFileExtensionsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeFileExtensionsResponse*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeFileExtensionsResponse);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREdescribeProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeProperties*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREdescribeProperties*>(p->ptr), _vbox__IMediumFormat_USCOREdescribeProperties);
		break;
	case SOAP_TYPE__vbox__IMediumFormat_USCOREdescribePropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumFormat_USCOREdescribePropertiesResponse*>(p->ptr), _vbox__IMediumFormat_USCOREdescribePropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumFormat_USCOREdescribePropertiesResponse*>(p->ptr), _vbox__IMediumFormat_USCOREdescribePropertiesResponse);
		break;
	case SOAP_TYPE__vbox__IDataStream_USCOREgetReadSize:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDataStream_USCOREgetReadSize*>(p->ptr), _vbox__IDataStream_USCOREgetReadSize);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDataStream_USCOREgetReadSize*>(p->ptr), _vbox__IDataStream_USCOREgetReadSize);
		break;
	case SOAP_TYPE__vbox__IDataStream_USCOREgetReadSizeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDataStream_USCOREgetReadSizeResponse*>(p->ptr), _vbox__IDataStream_USCOREgetReadSizeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDataStream_USCOREgetReadSizeResponse*>(p->ptr), _vbox__IDataStream_USCOREgetReadSizeResponse);
		break;
	case SOAP_TYPE__vbox__IDataStream_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDataStream_USCOREread*>(p->ptr), _vbox__IDataStream_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDataStream_USCOREread*>(p->ptr), _vbox__IDataStream_USCOREread);
		break;
	case SOAP_TYPE__vbox__IDataStream_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDataStream_USCOREreadResponse*>(p->ptr), _vbox__IDataStream_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDataStream_USCOREreadResponse*>(p->ptr), _vbox__IDataStream_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetMedium:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetMedium*>(p->ptr), _vbox__IMediumIO_USCOREgetMedium);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetMedium*>(p->ptr), _vbox__IMediumIO_USCOREgetMedium);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetMediumResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetMediumResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetMediumResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetMediumResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetMediumResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetWritable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetWritable*>(p->ptr), _vbox__IMediumIO_USCOREgetWritable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetWritable*>(p->ptr), _vbox__IMediumIO_USCOREgetWritable);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetWritableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetWritableResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetWritableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetWritableResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetWritableResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetExplorer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetExplorer*>(p->ptr), _vbox__IMediumIO_USCOREgetExplorer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetExplorer*>(p->ptr), _vbox__IMediumIO_USCOREgetExplorer);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREgetExplorerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREgetExplorerResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetExplorerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREgetExplorerResponse*>(p->ptr), _vbox__IMediumIO_USCOREgetExplorerResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREread:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREread*>(p->ptr), _vbox__IMediumIO_USCOREread);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREread*>(p->ptr), _vbox__IMediumIO_USCOREread);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREreadResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREreadResponse*>(p->ptr), _vbox__IMediumIO_USCOREreadResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREreadResponse*>(p->ptr), _vbox__IMediumIO_USCOREreadResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREwrite:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREwrite*>(p->ptr), _vbox__IMediumIO_USCOREwrite);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREwrite*>(p->ptr), _vbox__IMediumIO_USCOREwrite);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREwriteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREwriteResponse*>(p->ptr), _vbox__IMediumIO_USCOREwriteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREwriteResponse*>(p->ptr), _vbox__IMediumIO_USCOREwriteResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREformatFAT:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREformatFAT*>(p->ptr), _vbox__IMediumIO_USCOREformatFAT);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREformatFAT*>(p->ptr), _vbox__IMediumIO_USCOREformatFAT);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREformatFATResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREformatFATResponse*>(p->ptr), _vbox__IMediumIO_USCOREformatFATResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREformatFATResponse*>(p->ptr), _vbox__IMediumIO_USCOREformatFATResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREinitializePartitionTable:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREinitializePartitionTable*>(p->ptr), _vbox__IMediumIO_USCOREinitializePartitionTable);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREinitializePartitionTable*>(p->ptr), _vbox__IMediumIO_USCOREinitializePartitionTable);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREinitializePartitionTableResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREinitializePartitionTableResponse*>(p->ptr), _vbox__IMediumIO_USCOREinitializePartitionTableResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREinitializePartitionTableResponse*>(p->ptr), _vbox__IMediumIO_USCOREinitializePartitionTableResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREconvertToStream:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREconvertToStream*>(p->ptr), _vbox__IMediumIO_USCOREconvertToStream);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREconvertToStream*>(p->ptr), _vbox__IMediumIO_USCOREconvertToStream);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREconvertToStreamResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREconvertToStreamResponse*>(p->ptr), _vbox__IMediumIO_USCOREconvertToStreamResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREconvertToStreamResponse*>(p->ptr), _vbox__IMediumIO_USCOREconvertToStreamResponse);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREclose:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREclose*>(p->ptr), _vbox__IMediumIO_USCOREclose);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREclose*>(p->ptr), _vbox__IMediumIO_USCOREclose);
		break;
	case SOAP_TYPE__vbox__IMediumIO_USCOREcloseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMediumIO_USCOREcloseResponse*>(p->ptr), _vbox__IMediumIO_USCOREcloseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMediumIO_USCOREcloseResponse*>(p->ptr), _vbox__IMediumIO_USCOREcloseResponse);
		break;
	case SOAP_TYPE__vbox__IToken_USCOREabandon:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IToken_USCOREabandon*>(p->ptr), _vbox__IToken_USCOREabandon);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IToken_USCOREabandon*>(p->ptr), _vbox__IToken_USCOREabandon);
		break;
	case SOAP_TYPE__vbox__IToken_USCOREabandonResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IToken_USCOREabandonResponse*>(p->ptr), _vbox__IToken_USCOREabandonResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IToken_USCOREabandonResponse*>(p->ptr), _vbox__IToken_USCOREabandonResponse);
		break;
	case SOAP_TYPE__vbox__IToken_USCOREdummy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IToken_USCOREdummy*>(p->ptr), _vbox__IToken_USCOREdummy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IToken_USCOREdummy*>(p->ptr), _vbox__IToken_USCOREdummy);
		break;
	case SOAP_TYPE__vbox__IToken_USCOREdummyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IToken_USCOREdummyResponse*>(p->ptr), _vbox__IToken_USCOREdummyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IToken_USCOREdummyResponse*>(p->ptr), _vbox__IToken_USCOREdummyResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREgetKeyboardLEDs:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREgetKeyboardLEDs*>(p->ptr), _vbox__IKeyboard_USCOREgetKeyboardLEDs);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREgetKeyboardLEDs*>(p->ptr), _vbox__IKeyboard_USCOREgetKeyboardLEDs);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREgetKeyboardLEDsResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREgetKeyboardLEDsResponse*>(p->ptr), _vbox__IKeyboard_USCOREgetKeyboardLEDsResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREgetKeyboardLEDsResponse*>(p->ptr), _vbox__IKeyboard_USCOREgetKeyboardLEDsResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREgetEventSource*>(p->ptr), _vbox__IKeyboard_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREgetEventSource*>(p->ptr), _vbox__IKeyboard_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IKeyboard_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IKeyboard_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputScancode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputScancode*>(p->ptr), _vbox__IKeyboard_USCOREputScancode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputScancode*>(p->ptr), _vbox__IKeyboard_USCOREputScancode);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputScancodeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputScancodeResponse*>(p->ptr), _vbox__IKeyboard_USCOREputScancodeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputScancodeResponse*>(p->ptr), _vbox__IKeyboard_USCOREputScancodeResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputScancodes:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputScancodes*>(p->ptr), _vbox__IKeyboard_USCOREputScancodes);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputScancodes*>(p->ptr), _vbox__IKeyboard_USCOREputScancodes);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputScancodesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputScancodesResponse*>(p->ptr), _vbox__IKeyboard_USCOREputScancodesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputScancodesResponse*>(p->ptr), _vbox__IKeyboard_USCOREputScancodesResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputCAD:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputCAD*>(p->ptr), _vbox__IKeyboard_USCOREputCAD);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputCAD*>(p->ptr), _vbox__IKeyboard_USCOREputCAD);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputCADResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputCADResponse*>(p->ptr), _vbox__IKeyboard_USCOREputCADResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputCADResponse*>(p->ptr), _vbox__IKeyboard_USCOREputCADResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREreleaseKeys:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREreleaseKeys*>(p->ptr), _vbox__IKeyboard_USCOREreleaseKeys);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREreleaseKeys*>(p->ptr), _vbox__IKeyboard_USCOREreleaseKeys);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREreleaseKeysResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREreleaseKeysResponse*>(p->ptr), _vbox__IKeyboard_USCOREreleaseKeysResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREreleaseKeysResponse*>(p->ptr), _vbox__IKeyboard_USCOREreleaseKeysResponse);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputUsageCode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputUsageCode*>(p->ptr), _vbox__IKeyboard_USCOREputUsageCode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputUsageCode*>(p->ptr), _vbox__IKeyboard_USCOREputUsageCode);
		break;
	case SOAP_TYPE__vbox__IKeyboard_USCOREputUsageCodeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IKeyboard_USCOREputUsageCodeResponse*>(p->ptr), _vbox__IKeyboard_USCOREputUsageCodeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IKeyboard_USCOREputUsageCodeResponse*>(p->ptr), _vbox__IKeyboard_USCOREputUsageCodeResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetVisible:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetVisible*>(p->ptr), _vbox__IMousePointerShape_USCOREgetVisible);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetVisible*>(p->ptr), _vbox__IMousePointerShape_USCOREgetVisible);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetVisibleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetVisibleResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetVisibleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetVisibleResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetVisibleResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetAlpha:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetAlpha*>(p->ptr), _vbox__IMousePointerShape_USCOREgetAlpha);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetAlpha*>(p->ptr), _vbox__IMousePointerShape_USCOREgetAlpha);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetAlphaResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetAlphaResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetAlphaResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetAlphaResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetAlphaResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHotX:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotX*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotX);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotX*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotX);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHotXResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotXResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotXResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotXResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotXResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHotY:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotY*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotY);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotY*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotY);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHotYResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotYResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotYResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHotYResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHotYResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetWidth:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetWidth*>(p->ptr), _vbox__IMousePointerShape_USCOREgetWidth);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetWidth*>(p->ptr), _vbox__IMousePointerShape_USCOREgetWidth);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetWidthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetWidthResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetWidthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetWidthResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetWidthResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHeight*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHeight*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHeight);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetHeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHeightResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetHeightResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetHeightResponse);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetShape:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetShape*>(p->ptr), _vbox__IMousePointerShape_USCOREgetShape);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetShape*>(p->ptr), _vbox__IMousePointerShape_USCOREgetShape);
		break;
	case SOAP_TYPE__vbox__IMousePointerShape_USCOREgetShapeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMousePointerShape_USCOREgetShapeResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetShapeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMousePointerShape_USCOREgetShapeResponse*>(p->ptr), _vbox__IMousePointerShape_USCOREgetShapeResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetAbsoluteSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetAbsoluteSupported*>(p->ptr), _vbox__IMouse_USCOREgetAbsoluteSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetAbsoluteSupported*>(p->ptr), _vbox__IMouse_USCOREgetAbsoluteSupported);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetAbsoluteSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetAbsoluteSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetAbsoluteSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetAbsoluteSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetAbsoluteSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetRelativeSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetRelativeSupported*>(p->ptr), _vbox__IMouse_USCOREgetRelativeSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetRelativeSupported*>(p->ptr), _vbox__IMouse_USCOREgetRelativeSupported);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetRelativeSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetRelativeSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetRelativeSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetRelativeSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetRelativeSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetTouchScreenSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetTouchScreenSupported*>(p->ptr), _vbox__IMouse_USCOREgetTouchScreenSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetTouchScreenSupported*>(p->ptr), _vbox__IMouse_USCOREgetTouchScreenSupported);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetTouchScreenSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetTouchScreenSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetTouchScreenSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetTouchScreenSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetTouchScreenSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetTouchPadSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetTouchPadSupported*>(p->ptr), _vbox__IMouse_USCOREgetTouchPadSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetTouchPadSupported*>(p->ptr), _vbox__IMouse_USCOREgetTouchPadSupported);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetTouchPadSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetTouchPadSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetTouchPadSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetTouchPadSupportedResponse*>(p->ptr), _vbox__IMouse_USCOREgetTouchPadSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetNeedsHostCursor:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetNeedsHostCursor*>(p->ptr), _vbox__IMouse_USCOREgetNeedsHostCursor);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetNeedsHostCursor*>(p->ptr), _vbox__IMouse_USCOREgetNeedsHostCursor);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetNeedsHostCursorResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetNeedsHostCursorResponse*>(p->ptr), _vbox__IMouse_USCOREgetNeedsHostCursorResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetNeedsHostCursorResponse*>(p->ptr), _vbox__IMouse_USCOREgetNeedsHostCursorResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetPointerShape:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetPointerShape*>(p->ptr), _vbox__IMouse_USCOREgetPointerShape);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetPointerShape*>(p->ptr), _vbox__IMouse_USCOREgetPointerShape);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetPointerShapeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetPointerShapeResponse*>(p->ptr), _vbox__IMouse_USCOREgetPointerShapeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetPointerShapeResponse*>(p->ptr), _vbox__IMouse_USCOREgetPointerShapeResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetEventSource:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetEventSource*>(p->ptr), _vbox__IMouse_USCOREgetEventSource);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetEventSource*>(p->ptr), _vbox__IMouse_USCOREgetEventSource);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREgetEventSourceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IMouse_USCOREgetEventSourceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREgetEventSourceResponse*>(p->ptr), _vbox__IMouse_USCOREgetEventSourceResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputMouseEvent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputMouseEvent*>(p->ptr), _vbox__IMouse_USCOREputMouseEvent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputMouseEvent*>(p->ptr), _vbox__IMouse_USCOREputMouseEvent);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputMouseEventResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputMouseEventResponse*>(p->ptr), _vbox__IMouse_USCOREputMouseEventResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputMouseEventResponse*>(p->ptr), _vbox__IMouse_USCOREputMouseEventResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputMouseEventAbsolute:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputMouseEventAbsolute*>(p->ptr), _vbox__IMouse_USCOREputMouseEventAbsolute);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputMouseEventAbsolute*>(p->ptr), _vbox__IMouse_USCOREputMouseEventAbsolute);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputMouseEventAbsoluteResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputMouseEventAbsoluteResponse*>(p->ptr), _vbox__IMouse_USCOREputMouseEventAbsoluteResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputMouseEventAbsoluteResponse*>(p->ptr), _vbox__IMouse_USCOREputMouseEventAbsoluteResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputEventMultiTouch:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouch*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouch);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouch*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouch);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputEventMultiTouchResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchResponse*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchResponse*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchResponse);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputEventMultiTouchString:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchString*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchString);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchString*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchString);
		break;
	case SOAP_TYPE__vbox__IMouse_USCOREputEventMultiTouchStringResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchStringResponse*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchStringResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IMouse_USCOREputEventMultiTouchStringResponse*>(p->ptr), _vbox__IMouse_USCOREputEventMultiTouchStringResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetWidth:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetWidth*>(p->ptr), _vbox__IFramebuffer_USCOREgetWidth);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetWidth*>(p->ptr), _vbox__IFramebuffer_USCOREgetWidth);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetWidthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetWidthResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetWidthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetWidthResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetWidthResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetHeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeight*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeight*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeight);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetHeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetBitsPerPixel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetBitsPerPixel*>(p->ptr), _vbox__IFramebuffer_USCOREgetBitsPerPixel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetBitsPerPixel*>(p->ptr), _vbox__IFramebuffer_USCOREgetBitsPerPixel);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetBitsPerPixelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetBitsPerPixelResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetBitsPerPixelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetBitsPerPixelResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetBitsPerPixelResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetBytesPerLine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetBytesPerLine*>(p->ptr), _vbox__IFramebuffer_USCOREgetBytesPerLine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetBytesPerLine*>(p->ptr), _vbox__IFramebuffer_USCOREgetBytesPerLine);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetBytesPerLineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetBytesPerLineResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetBytesPerLineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetBytesPerLineResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetBytesPerLineResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetPixelFormat:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetPixelFormat*>(p->ptr), _vbox__IFramebuffer_USCOREgetPixelFormat);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetPixelFormat*>(p->ptr), _vbox__IFramebuffer_USCOREgetPixelFormat);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetPixelFormatResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetPixelFormatResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetPixelFormatResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetPixelFormatResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetPixelFormatResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetHeightReduction:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightReduction*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightReduction);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightReduction*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightReduction);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetHeightReductionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightReductionResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightReductionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetHeightReductionResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetHeightReductionResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetOverlay:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetOverlay*>(p->ptr), _vbox__IFramebuffer_USCOREgetOverlay);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetOverlay*>(p->ptr), _vbox__IFramebuffer_USCOREgetOverlay);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetOverlayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetOverlayResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetOverlayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetOverlayResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetOverlayResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetCapabilities:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetCapabilities*>(p->ptr), _vbox__IFramebuffer_USCOREgetCapabilities);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetCapabilities*>(p->ptr), _vbox__IFramebuffer_USCOREgetCapabilities);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREgetCapabilitiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREgetCapabilitiesResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetCapabilitiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREgetCapabilitiesResponse*>(p->ptr), _vbox__IFramebuffer_USCOREgetCapabilitiesResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyUpdate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdate*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdate*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdate);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyUpdateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyUpdateImage:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateImage*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateImage);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateImage*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateImage);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyUpdateImageResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateImageResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateImageResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyUpdateImageResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyUpdateImageResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyChange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyChange*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyChange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyChange*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyChange);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotifyChangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyChangeResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyChangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotifyChangeResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotifyChangeResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREvideoModeSupported:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREvideoModeSupported*>(p->ptr), _vbox__IFramebuffer_USCOREvideoModeSupported);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREvideoModeSupported*>(p->ptr), _vbox__IFramebuffer_USCOREvideoModeSupported);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREvideoModeSupportedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREvideoModeSupportedResponse*>(p->ptr), _vbox__IFramebuffer_USCOREvideoModeSupportedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREvideoModeSupportedResponse*>(p->ptr), _vbox__IFramebuffer_USCOREvideoModeSupportedResponse);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotify3DEvent:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotify3DEvent*>(p->ptr), _vbox__IFramebuffer_USCOREnotify3DEvent);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotify3DEvent*>(p->ptr), _vbox__IFramebuffer_USCOREnotify3DEvent);
		break;
	case SOAP_TYPE__vbox__IFramebuffer_USCOREnotify3DEventResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebuffer_USCOREnotify3DEventResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotify3DEventResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebuffer_USCOREnotify3DEventResponse*>(p->ptr), _vbox__IFramebuffer_USCOREnotify3DEventResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetX:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetX*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetX);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetX*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetX);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetXResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetXResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetXResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetXResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetXResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetY:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetY*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetY);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetY*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetY);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetYResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetYResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetYResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetYResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetYResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetVisible:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetVisible*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetVisible);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetVisible*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetVisible);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetVisibleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetVisibleResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetVisibleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetVisibleResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetVisibleResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREsetVisible:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetVisible*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetVisible);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetVisible*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetVisible);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREsetVisibleResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetVisibleResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetVisibleResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetVisibleResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetVisibleResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetAlpha:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetAlpha*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetAlpha);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetAlpha*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetAlpha);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREgetAlphaResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetAlphaResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetAlphaResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREgetAlphaResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREgetAlphaResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREsetAlpha:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetAlpha*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetAlpha);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetAlpha*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetAlpha);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREsetAlphaResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetAlphaResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetAlphaResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREsetAlphaResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREsetAlphaResponse);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREmove:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREmove*>(p->ptr), _vbox__IFramebufferOverlay_USCOREmove);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREmove*>(p->ptr), _vbox__IFramebufferOverlay_USCOREmove);
		break;
	case SOAP_TYPE__vbox__IFramebufferOverlay_USCOREmoveResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IFramebufferOverlay_USCOREmoveResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREmoveResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IFramebufferOverlay_USCOREmoveResponse*>(p->ptr), _vbox__IFramebufferOverlay_USCOREmoveResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetScreenId:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetScreenId*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetScreenId);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetScreenId*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetScreenId);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetScreenIdResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetScreenIdResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetScreenIdResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetScreenIdResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetScreenIdResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatus:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatus*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatus);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatus*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatus);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatusResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatusResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatusResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatusResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetGuestMonitorStatusResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetPrimary:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetPrimary*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetPrimary);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetPrimary*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetPrimary);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetPrimaryResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetPrimaryResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetPrimaryResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetPrimaryResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetPrimaryResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOrigin:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOrigin*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOrigin);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOrigin*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOrigin);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOriginResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOriginX:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginX*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginX);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginX*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginX);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOriginXResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginXResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginXResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginXResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginXResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOriginY:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginY*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginY);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginY*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginY);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetOriginYResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginYResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginYResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetOriginYResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetOriginYResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetWidth:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetWidth*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetWidth);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetWidth*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetWidth);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetWidthResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetWidthResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetWidthResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetWidthResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetWidthResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetHeight:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetHeight*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetHeight);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetHeight*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetHeight);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetHeightResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetHeightResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetHeightResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetHeightResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetHeightResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetBitsPerPixel:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetBitsPerPixel*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetBitsPerPixel);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetBitsPerPixel*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetBitsPerPixel);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetBitsPerPixelResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetBitsPerPixelResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetBitsPerPixelResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetBitsPerPixelResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetBitsPerPixelResponse);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetExtendedInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetExtendedInfo*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetExtendedInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetExtendedInfo*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetExtendedInfo);
		break;
	case SOAP_TYPE__vbox__IGuestScreenInfo_USCOREgetExtendedInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetExtendedInfoResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetExtendedInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IGuestScreenInfo_USCOREgetExtendedInfoResponse*>(p->ptr), _vbox__IGuestScreenInfo_USCOREgetExtendedInfoResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetGuestScreenLayout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetGuestScreenLayout*>(p->ptr), _vbox__IDisplay_USCOREgetGuestScreenLayout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetGuestScreenLayout*>(p->ptr), _vbox__IDisplay_USCOREgetGuestScreenLayout);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetGuestScreenLayoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetGuestScreenLayoutResponse*>(p->ptr), _vbox__IDisplay_USCOREgetGuestScreenLayoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetGuestScreenLayoutResponse*>(p->ptr), _vbox__IDisplay_USCOREgetGuestScreenLayoutResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetScreenResolution:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetScreenResolution*>(p->ptr), _vbox__IDisplay_USCOREgetScreenResolution);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetScreenResolution*>(p->ptr), _vbox__IDisplay_USCOREgetScreenResolution);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetScreenResolutionResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetScreenResolutionResponse*>(p->ptr), _vbox__IDisplay_USCOREgetScreenResolutionResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetScreenResolutionResponse*>(p->ptr), _vbox__IDisplay_USCOREgetScreenResolutionResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREattachFramebuffer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREattachFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREattachFramebuffer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREattachFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREattachFramebuffer);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREattachFramebufferResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREattachFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREattachFramebufferResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREattachFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREattachFramebufferResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREdetachFramebuffer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREdetachFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREdetachFramebuffer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREdetachFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREdetachFramebuffer);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREdetachFramebufferResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREdetachFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREdetachFramebufferResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREdetachFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREdetachFramebufferResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREqueryFramebuffer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREqueryFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREqueryFramebuffer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREqueryFramebuffer*>(p->ptr), _vbox__IDisplay_USCOREqueryFramebuffer);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREqueryFramebufferResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREqueryFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREqueryFramebufferResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREqueryFramebufferResponse*>(p->ptr), _vbox__IDisplay_USCOREqueryFramebufferResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetVideoModeHint:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetVideoModeHint*>(p->ptr), _vbox__IDisplay_USCOREsetVideoModeHint);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetVideoModeHint*>(p->ptr), _vbox__IDisplay_USCOREsetVideoModeHint);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetVideoModeHintResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetVideoModeHintResponse*>(p->ptr), _vbox__IDisplay_USCOREsetVideoModeHintResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetVideoModeHintResponse*>(p->ptr), _vbox__IDisplay_USCOREsetVideoModeHintResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetVideoModeHint:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetVideoModeHint*>(p->ptr), _vbox__IDisplay_USCOREgetVideoModeHint);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetVideoModeHint*>(p->ptr), _vbox__IDisplay_USCOREgetVideoModeHint);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREgetVideoModeHintResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREgetVideoModeHintResponse*>(p->ptr), _vbox__IDisplay_USCOREgetVideoModeHintResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREgetVideoModeHintResponse*>(p->ptr), _vbox__IDisplay_USCOREgetVideoModeHintResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetSeamlessMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetSeamlessMode*>(p->ptr), _vbox__IDisplay_USCOREsetSeamlessMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetSeamlessMode*>(p->ptr), _vbox__IDisplay_USCOREsetSeamlessMode);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetSeamlessModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetSeamlessModeResponse*>(p->ptr), _vbox__IDisplay_USCOREsetSeamlessModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetSeamlessModeResponse*>(p->ptr), _vbox__IDisplay_USCOREsetSeamlessModeResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREtakeScreenShotToArray:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREtakeScreenShotToArray*>(p->ptr), _vbox__IDisplay_USCOREtakeScreenShotToArray);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREtakeScreenShotToArray*>(p->ptr), _vbox__IDisplay_USCOREtakeScreenShotToArray);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREtakeScreenShotToArrayResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREtakeScreenShotToArrayResponse*>(p->ptr), _vbox__IDisplay_USCOREtakeScreenShotToArrayResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREtakeScreenShotToArrayResponse*>(p->ptr), _vbox__IDisplay_USCOREtakeScreenShotToArrayResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREinvalidateAndUpdate:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdate*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdate);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdate*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdate);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREinvalidateAndUpdateResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateResponse*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateResponse*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREinvalidateAndUpdateScreen:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateScreen*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateScreen);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateScreen*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateScreen);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREinvalidateAndUpdateScreenResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateScreenResponse*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateScreenResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREinvalidateAndUpdateScreenResponse*>(p->ptr), _vbox__IDisplay_USCOREinvalidateAndUpdateScreenResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREviewportChanged:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREviewportChanged*>(p->ptr), _vbox__IDisplay_USCOREviewportChanged);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREviewportChanged*>(p->ptr), _vbox__IDisplay_USCOREviewportChanged);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREviewportChangedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREviewportChangedResponse*>(p->ptr), _vbox__IDisplay_USCOREviewportChangedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREviewportChangedResponse*>(p->ptr), _vbox__IDisplay_USCOREviewportChangedResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREnotifyScaleFactorChange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREnotifyScaleFactorChange*>(p->ptr), _vbox__IDisplay_USCOREnotifyScaleFactorChange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREnotifyScaleFactorChange*>(p->ptr), _vbox__IDisplay_USCOREnotifyScaleFactorChange);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREnotifyScaleFactorChangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREnotifyScaleFactorChangeResponse*>(p->ptr), _vbox__IDisplay_USCOREnotifyScaleFactorChangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREnotifyScaleFactorChangeResponse*>(p->ptr), _vbox__IDisplay_USCOREnotifyScaleFactorChangeResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChange:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChange*>(p->ptr), _vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChange);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChange*>(p->ptr), _vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChange);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChangeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChangeResponse*>(p->ptr), _vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChangeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChangeResponse*>(p->ptr), _vbox__IDisplay_USCOREnotifyHiDPIOutputPolicyChangeResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetScreenLayout:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetScreenLayout*>(p->ptr), _vbox__IDisplay_USCOREsetScreenLayout);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetScreenLayout*>(p->ptr), _vbox__IDisplay_USCOREsetScreenLayout);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREsetScreenLayoutResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREsetScreenLayoutResponse*>(p->ptr), _vbox__IDisplay_USCOREsetScreenLayoutResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREsetScreenLayoutResponse*>(p->ptr), _vbox__IDisplay_USCOREsetScreenLayoutResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREdetachScreens:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREdetachScreens*>(p->ptr), _vbox__IDisplay_USCOREdetachScreens);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREdetachScreens*>(p->ptr), _vbox__IDisplay_USCOREdetachScreens);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREdetachScreensResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREdetachScreensResponse*>(p->ptr), _vbox__IDisplay_USCOREdetachScreensResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREdetachScreensResponse*>(p->ptr), _vbox__IDisplay_USCOREdetachScreensResponse);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREcreateGuestScreenInfo:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREcreateGuestScreenInfo*>(p->ptr), _vbox__IDisplay_USCOREcreateGuestScreenInfo);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREcreateGuestScreenInfo*>(p->ptr), _vbox__IDisplay_USCOREcreateGuestScreenInfo);
		break;
	case SOAP_TYPE__vbox__IDisplay_USCOREcreateGuestScreenInfoResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IDisplay_USCOREcreateGuestScreenInfoResponse*>(p->ptr), _vbox__IDisplay_USCOREcreateGuestScreenInfoResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IDisplay_USCOREcreateGuestScreenInfoResponse*>(p->ptr), _vbox__IDisplay_USCOREcreateGuestScreenInfoResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetAdapterType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAdapterType*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAdapterType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAdapterType*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAdapterType);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetAdapterTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAdapterTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAdapterTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAdapterTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAdapterTypeResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetAdapterType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAdapterType*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAdapterType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAdapterType*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAdapterType);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetAdapterTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAdapterTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAdapterTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAdapterTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAdapterTypeResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetSlot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetSlot*>(p->ptr), _vbox__INetworkAdapter_USCOREgetSlot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetSlot*>(p->ptr), _vbox__INetworkAdapter_USCOREgetSlot);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetSlotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetSlotResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetSlotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetSlotResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetSlotResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetMACAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetMACAddress*>(p->ptr), _vbox__INetworkAdapter_USCOREgetMACAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetMACAddress*>(p->ptr), _vbox__INetworkAdapter_USCOREgetMACAddress);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetMACAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetMACAddressResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetMACAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetMACAddressResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetMACAddressResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetMACAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetMACAddress*>(p->ptr), _vbox__INetworkAdapter_USCOREsetMACAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetMACAddress*>(p->ptr), _vbox__INetworkAdapter_USCOREsetMACAddress);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetMACAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetMACAddressResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetMACAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetMACAddressResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetMACAddressResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetAttachmentType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAttachmentType*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAttachmentType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAttachmentType*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAttachmentType);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetAttachmentTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAttachmentTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAttachmentTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetAttachmentTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetAttachmentTypeResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetAttachmentType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAttachmentType*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAttachmentType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAttachmentType*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAttachmentType);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetAttachmentTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAttachmentTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAttachmentTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetAttachmentTypeResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetAttachmentTypeResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBridgedInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBridgedInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBridgedInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBridgedInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBridgedInterface);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBridgedInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBridgedInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBridgedInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBridgedInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBridgedInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBridgedInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBridgedInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBridgedInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBridgedInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBridgedInterface);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBridgedInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBridgedInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBridgedInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBridgedInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBridgedInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetHostOnlyInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyInterface);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetHostOnlyInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetHostOnlyInterface:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyInterface);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyInterface*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyInterface);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetHostOnlyInterfaceResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyInterfaceResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyInterfaceResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyInterfaceResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetHostOnlyNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetHostOnlyNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetHostOnlyNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetHostOnlyNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetHostOnlyNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetHostOnlyNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetHostOnlyNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetHostOnlyNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetInternalNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetInternalNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetInternalNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetInternalNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetInternalNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetInternalNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetInternalNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetInternalNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetInternalNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetInternalNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetInternalNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetInternalNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetInternalNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetInternalNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetInternalNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetInternalNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetInternalNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetInternalNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetInternalNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetInternalNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetNATNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetNATNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetNATNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetNATNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetNATNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetNATNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetNATNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetNATNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetNATNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetNATNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetNATNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetNATNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetGenericDriver:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetGenericDriver*>(p->ptr), _vbox__INetworkAdapter_USCOREgetGenericDriver);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetGenericDriver*>(p->ptr), _vbox__INetworkAdapter_USCOREgetGenericDriver);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetGenericDriverResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetGenericDriverResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetGenericDriverResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetGenericDriverResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetGenericDriverResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetGenericDriver:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetGenericDriver*>(p->ptr), _vbox__INetworkAdapter_USCOREsetGenericDriver);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetGenericDriver*>(p->ptr), _vbox__INetworkAdapter_USCOREsetGenericDriver);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetGenericDriverResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetGenericDriverResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetGenericDriverResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetGenericDriverResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetGenericDriverResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetCloudNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCloudNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCloudNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCloudNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCloudNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetCloudNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCloudNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCloudNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCloudNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCloudNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetCloudNetwork:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCloudNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCloudNetwork);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCloudNetwork*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCloudNetwork);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetCloudNetworkResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCloudNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCloudNetworkResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCloudNetworkResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCloudNetworkResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetCableConnected:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCableConnected*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCableConnected);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCableConnected*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCableConnected);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetCableConnectedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCableConnectedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCableConnectedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetCableConnectedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetCableConnectedResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetCableConnected:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCableConnected*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCableConnected);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCableConnected*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCableConnected);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetCableConnectedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCableConnectedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCableConnectedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetCableConnectedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetCableConnectedResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetLineSpeed:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetLineSpeed*>(p->ptr), _vbox__INetworkAdapter_USCOREgetLineSpeed);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetLineSpeed*>(p->ptr), _vbox__INetworkAdapter_USCOREgetLineSpeed);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetLineSpeedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetLineSpeedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetLineSpeedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetLineSpeedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetLineSpeedResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetLineSpeed:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetLineSpeed*>(p->ptr), _vbox__INetworkAdapter_USCOREsetLineSpeed);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetLineSpeed*>(p->ptr), _vbox__INetworkAdapter_USCOREsetLineSpeed);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetLineSpeedResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetLineSpeedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetLineSpeedResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetLineSpeedResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetLineSpeedResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetPromiscModePolicy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPromiscModePolicy*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPromiscModePolicy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPromiscModePolicy*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPromiscModePolicy);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetPromiscModePolicyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPromiscModePolicyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPromiscModePolicyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPromiscModePolicyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPromiscModePolicyResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetPromiscModePolicy:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPromiscModePolicy*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPromiscModePolicy);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPromiscModePolicy*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPromiscModePolicy);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetPromiscModePolicyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPromiscModePolicyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPromiscModePolicyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPromiscModePolicyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPromiscModePolicyResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetTraceEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceEnabled);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetTraceEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetTraceEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceEnabled*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceEnabled);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetTraceEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceEnabledResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceEnabledResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetTraceFile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceFile*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceFile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceFile*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceFile);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetTraceFileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceFileResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceFileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetTraceFileResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetTraceFileResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetTraceFile:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceFile*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceFile);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceFile*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceFile);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetTraceFileResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceFileResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceFileResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetTraceFileResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetTraceFileResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetNATEngine:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATEngine*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATEngine);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATEngine*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATEngine);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetNATEngineResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATEngineResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATEngineResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetNATEngineResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetNATEngineResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBootPriority:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBootPriority*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBootPriority);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBootPriority*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBootPriority);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBootPriorityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBootPriorityResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBootPriorityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBootPriorityResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBootPriorityResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBootPriority:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBootPriority*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBootPriority);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBootPriority*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBootPriority);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBootPriorityResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBootPriorityResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBootPriorityResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBootPriorityResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBootPriorityResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBandwidthGroup:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBandwidthGroup*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBandwidthGroup);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBandwidthGroup*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBandwidthGroup);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetBandwidthGroupResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBandwidthGroupResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBandwidthGroupResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetBandwidthGroupResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetBandwidthGroupResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBandwidthGroup:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBandwidthGroup*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBandwidthGroup);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBandwidthGroup*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBandwidthGroup);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetBandwidthGroupResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBandwidthGroupResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBandwidthGroupResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetBandwidthGroupResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetBandwidthGroupResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetProperty*>(p->ptr), _vbox__INetworkAdapter_USCOREgetProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetProperty*>(p->ptr), _vbox__INetworkAdapter_USCOREgetProperty);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPropertyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPropertyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPropertyResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetProperty:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetProperty*>(p->ptr), _vbox__INetworkAdapter_USCOREsetProperty);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetProperty*>(p->ptr), _vbox__INetworkAdapter_USCOREsetProperty);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREsetPropertyResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPropertyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPropertyResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREsetPropertyResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREsetPropertyResponse);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetProperties:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetProperties*>(p->ptr), _vbox__INetworkAdapter_USCOREgetProperties);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetProperties*>(p->ptr), _vbox__INetworkAdapter_USCOREgetProperties);
		break;
	case SOAP_TYPE__vbox__INetworkAdapter_USCOREgetPropertiesResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPropertiesResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPropertiesResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__INetworkAdapter_USCOREgetPropertiesResponse*>(p->ptr), _vbox__INetworkAdapter_USCOREgetPropertiesResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetSlot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetSlot*>(p->ptr), _vbox__ISerialPort_USCOREgetSlot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetSlot*>(p->ptr), _vbox__ISerialPort_USCOREgetSlot);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetSlotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetSlotResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetSlotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetSlotResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetSlotResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetEnabled*>(p->ptr), _vbox__ISerialPort_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetEnabled*>(p->ptr), _vbox__ISerialPort_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetEnabledResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetEnabledResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetEnabled*>(p->ptr), _vbox__ISerialPort_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetEnabled*>(p->ptr), _vbox__ISerialPort_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetEnabledResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetEnabledResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetIOAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetIOAddress*>(p->ptr), _vbox__ISerialPort_USCOREgetIOAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetIOAddress*>(p->ptr), _vbox__ISerialPort_USCOREgetIOAddress);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetIOAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetIOAddressResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetIOAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetIOAddressResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetIOAddressResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetIOAddress:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetIOAddress*>(p->ptr), _vbox__ISerialPort_USCOREsetIOAddress);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetIOAddress*>(p->ptr), _vbox__ISerialPort_USCOREsetIOAddress);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetIOAddressResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetIOAddressResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetIOAddressResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetIOAddressResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetIOAddressResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetIRQ:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetIRQ*>(p->ptr), _vbox__ISerialPort_USCOREgetIRQ);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetIRQ*>(p->ptr), _vbox__ISerialPort_USCOREgetIRQ);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetIRQResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetIRQResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetIRQResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetIRQResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetIRQResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetIRQ:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetIRQ*>(p->ptr), _vbox__ISerialPort_USCOREsetIRQ);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetIRQ*>(p->ptr), _vbox__ISerialPort_USCOREsetIRQ);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetIRQResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetIRQResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetIRQResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetIRQResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetIRQResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetHostMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetHostMode*>(p->ptr), _vbox__ISerialPort_USCOREgetHostMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetHostMode*>(p->ptr), _vbox__ISerialPort_USCOREgetHostMode);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetHostModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetHostModeResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetHostModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetHostModeResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetHostModeResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetHostMode:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetHostMode*>(p->ptr), _vbox__ISerialPort_USCOREsetHostMode);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetHostMode*>(p->ptr), _vbox__ISerialPort_USCOREsetHostMode);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetHostModeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetHostModeResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetHostModeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetHostModeResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetHostModeResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetServer*>(p->ptr), _vbox__ISerialPort_USCOREgetServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetServer*>(p->ptr), _vbox__ISerialPort_USCOREgetServer);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetServerResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetServerResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetServerResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetServer:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetServer*>(p->ptr), _vbox__ISerialPort_USCOREsetServer);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetServer*>(p->ptr), _vbox__ISerialPort_USCOREsetServer);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetServerResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetServerResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetServerResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetServerResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetServerResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetPath*>(p->ptr), _vbox__ISerialPort_USCOREgetPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetPath*>(p->ptr), _vbox__ISerialPort_USCOREgetPath);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetPathResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetPathResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetPathResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetPath:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetPath*>(p->ptr), _vbox__ISerialPort_USCOREsetPath);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetPath*>(p->ptr), _vbox__ISerialPort_USCOREsetPath);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetPathResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetPathResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetPathResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetPathResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetPathResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetUartType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetUartType*>(p->ptr), _vbox__ISerialPort_USCOREgetUartType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetUartType*>(p->ptr), _vbox__ISerialPort_USCOREgetUartType);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREgetUartTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREgetUartTypeResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetUartTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREgetUartTypeResponse*>(p->ptr), _vbox__ISerialPort_USCOREgetUartTypeResponse);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetUartType:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetUartType*>(p->ptr), _vbox__ISerialPort_USCOREsetUartType);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetUartType*>(p->ptr), _vbox__ISerialPort_USCOREsetUartType);
		break;
	case SOAP_TYPE__vbox__ISerialPort_USCOREsetUartTypeResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__ISerialPort_USCOREsetUartTypeResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetUartTypeResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__ISerialPort_USCOREsetUartTypeResponse*>(p->ptr), _vbox__ISerialPort_USCOREsetUartTypeResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetSlot:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetSlot*>(p->ptr), _vbox__IParallelPort_USCOREgetSlot);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetSlot*>(p->ptr), _vbox__IParallelPort_USCOREgetSlot);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetSlotResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetSlotResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetSlotResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetSlotResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetSlotResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetEnabled*>(p->ptr), _vbox__IParallelPort_USCOREgetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetEnabled*>(p->ptr), _vbox__IParallelPort_USCOREgetEnabled);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetEnabledResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetEnabledResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREsetEnabled:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREsetEnabled*>(p->ptr), _vbox__IParallelPort_USCOREsetEnabled);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREsetEnabled*>(p->ptr), _vbox__IParallelPort_USCOREsetEnabled);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREsetEnabledResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREsetEnabledResponse*>(p->ptr), _vbox__IParallelPort_USCOREsetEnabledResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREsetEnabledResponse*>(p->ptr), _vbox__IParallelPort_USCOREsetEnabledResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetIOBase:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetIOBase*>(p->ptr), _vbox__IParallelPort_USCOREgetIOBase);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetIOBase*>(p->ptr), _vbox__IParallelPort_USCOREgetIOBase);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetIOBaseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetIOBaseResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetIOBaseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetIOBaseResponse*>(p->ptr), _vbox__IParallelPort_USCOREgetIOBaseResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREsetIOBase:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREsetIOBase*>(p->ptr), _vbox__IParallelPort_USCOREsetIOBase);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREsetIOBase*>(p->ptr), _vbox__IParallelPort_USCOREsetIOBase);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREsetIOBaseResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREsetIOBaseResponse*>(p->ptr), _vbox__IParallelPort_USCOREsetIOBaseResponse);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREsetIOBaseResponse*>(p->ptr), _vbox__IParallelPort_USCOREsetIOBaseResponse);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetIRQ:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallelPort_USCOREgetIRQ*>(p->ptr), _vbox__IParallelPort_USCOREgetIRQ);
		else
			SOAP_DELETE_ARRAY(soap, static_cast<_vbox__IParallelPort_USCOREgetIRQ*>(p->ptr), _vbox__IParallelPort_USCOREgetIRQ);
		break;
	case SOAP_TYPE__vbox__IParallelPort_USCOREgetIRQResponse:
		if (p->size < 0)
			SOAP_DELETE(soap, static_cast<_vbox__IParallel