/** @file
 * VirtualBox API class wrapper code for IVirtualBox.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_VIRTUALBOX

#include "VirtualBoxWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VirtualBoxWrap)

//
// IVirtualBox properties
//

STDMETHODIMP VirtualBoxWrap::COMGETTER(Version)(BSTR *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "VirtualBox::getVersion", aVersion));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        BSTROutConverter TmpVersion(aVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(TmpVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,TmpVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%ls hrc=%Rhrc\n", this, "VirtualBox::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(VersionNormalized)(BSTR *aVersionNormalized)
{
    LogRelFlow(("{%p} %s: enter aVersionNormalized=%p\n", this, "VirtualBox::getVersionNormalized", aVersionNormalized));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersionNormalized);
        BSTROutConverter TmpVersionNormalized(aVersionNormalized);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSIONNORMALIZED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersionNormalized(TmpVersionNormalized.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSIONNORMALIZED_RETURN(this, hrc, 0 /*normal*/,TmpVersionNormalized.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSIONNORMALIZED_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_VERSIONNORMALIZED_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersionNormalized=%ls hrc=%Rhrc\n", this, "VirtualBox::getVersionNormalized", *aVersionNormalized, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(Revision)(ULONG *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "VirtualBox::getRevision", aRevision));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(aRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,*aRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%RU32 hrc=%Rhrc\n", this, "VirtualBox::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(PackageType)(BSTR *aPackageType)
{
    LogRelFlow(("{%p} %s: enter aPackageType=%p\n", this, "VirtualBox::getPackageType", aPackageType));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPackageType);
        BSTROutConverter TmpPackageType(aPackageType);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PACKAGETYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPackageType(TmpPackageType.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PACKAGETYPE_RETURN(this, hrc, 0 /*normal*/,TmpPackageType.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PACKAGETYPE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PACKAGETYPE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPackageType=%ls hrc=%Rhrc\n", this, "VirtualBox::getPackageType", *aPackageType, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(APIVersion)(BSTR *aAPIVersion)
{
    LogRelFlow(("{%p} %s: enter aAPIVersion=%p\n", this, "VirtualBox::getAPIVersion", aAPIVersion));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAPIVersion);
        BSTROutConverter TmpAPIVersion(aAPIVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAPIVersion(TmpAPIVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIVERSION_RETURN(this, hrc, 0 /*normal*/,TmpAPIVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAPIVersion=%ls hrc=%Rhrc\n", this, "VirtualBox::getAPIVersion", *aAPIVersion, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(APIRevision)(LONG64 *aAPIRevision)
{
    LogRelFlow(("{%p} %s: enter aAPIRevision=%p\n", this, "VirtualBox::getAPIRevision", aAPIRevision));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAPIRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIREVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAPIRevision(aAPIRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIREVISION_RETURN(this, hrc, 0 /*normal*/,*aAPIRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIREVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aAPIRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_APIREVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aAPIRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAPIRevision=%RI64 hrc=%Rhrc\n", this, "VirtualBox::getAPIRevision", *aAPIRevision, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(HomeFolder)(BSTR *aHomeFolder)
{
    LogRelFlow(("{%p} %s: enter aHomeFolder=%p\n", this, "VirtualBox::getHomeFolder", aHomeFolder));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHomeFolder);
        BSTROutConverter TmpHomeFolder(aHomeFolder);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOMEFOLDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHomeFolder(TmpHomeFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOMEFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpHomeFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOMEFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOMEFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHomeFolder=%ls hrc=%Rhrc\n", this, "VirtualBox::getHomeFolder", *aHomeFolder, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(SettingsFilePath)(BSTR *aSettingsFilePath)
{
    LogRelFlow(("{%p} %s: enter aSettingsFilePath=%p\n", this, "VirtualBox::getSettingsFilePath", aSettingsFilePath));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSettingsFilePath);
        BSTROutConverter TmpSettingsFilePath(aSettingsFilePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SETTINGSFILEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSettingsFilePath(TmpSettingsFilePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SETTINGSFILEPATH_RETURN(this, hrc, 0 /*normal*/,TmpSettingsFilePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SETTINGSFILEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SETTINGSFILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSettingsFilePath=%ls hrc=%Rhrc\n", this, "VirtualBox::getSettingsFilePath", *aSettingsFilePath, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(Host)(IHost **aHost)
{
    LogRelFlow(("{%p} %s: enter aHost=%p\n", this, "VirtualBox::getHost", aHost));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHost);
        ComTypeOutConverter<IHost> TmpHost(aHost);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHost(TmpHost.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOST_RETURN(this, hrc, 0 /*normal*/,(void *)TmpHost.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOST_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOST_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHost=%p hrc=%Rhrc\n", this, "VirtualBox::getHost", *aHost, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(SystemProperties)(ISystemProperties **aSystemProperties)
{
    LogRelFlow(("{%p} %s: enter aSystemProperties=%p\n", this, "VirtualBox::getSystemProperties", aSystemProperties));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSystemProperties);
        ComTypeOutConverter<ISystemProperties> TmpSystemProperties(aSystemProperties);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SYSTEMPROPERTIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSystemProperties(TmpSystemProperties.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SYSTEMPROPERTIES_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSystemProperties.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SYSTEMPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SYSTEMPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSystemProperties=%p hrc=%Rhrc\n", this, "VirtualBox::getSystemProperties", *aSystemProperties, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(Machines)(ComSafeArrayOut(IMachine *, aMachines))
{
    LogRelFlow(("{%p} %s: enter aMachines=%p\n", this, "VirtualBox::getMachines", aMachines));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachines);
        ArrayComTypeOutConverter<IMachine> TmpMachines(ComSafeArrayOutArg(aMachines));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachines(TmpMachines.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMachines.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachines=%zu hrc=%Rhrc\n", this, "VirtualBox::getMachines", ComSafeArraySize(*aMachines), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(MachineGroups)(ComSafeArrayOut(BSTR, aMachineGroups))
{
    LogRelFlow(("{%p} %s: enter aMachineGroups=%p\n", this, "VirtualBox::getMachineGroups", aMachineGroups));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachineGroups);
        ArrayBSTROutConverter TmpMachineGroups(ComSafeArrayOutArg(aMachineGroups));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINEGROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachineGroups(TmpMachineGroups.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINEGROUPS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMachineGroups.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINEGROUPS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_MACHINEGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachineGroups=%zu hrc=%Rhrc\n", this, "VirtualBox::getMachineGroups", ComSafeArraySize(*aMachineGroups), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(HardDisks)(ComSafeArrayOut(IMedium *, aHardDisks))
{
    LogRelFlow(("{%p} %s: enter aHardDisks=%p\n", this, "VirtualBox::getHardDisks", aHardDisks));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHardDisks);
        ArrayComTypeOutConverter<IMedium> TmpHardDisks(ComSafeArrayOutArg(aHardDisks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HARDDISKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHardDisks(TmpHardDisks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HARDDISKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpHardDisks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HARDDISKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HARDDISKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHardDisks=%zu hrc=%Rhrc\n", this, "VirtualBox::getHardDisks", ComSafeArraySize(*aHardDisks), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(DVDImages)(ComSafeArrayOut(IMedium *, aDVDImages))
{
    LogRelFlow(("{%p} %s: enter aDVDImages=%p\n", this, "VirtualBox::getDVDImages", aDVDImages));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDVDImages);
        ArrayComTypeOutConverter<IMedium> TmpDVDImages(ComSafeArrayOutArg(aDVDImages));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DVDIMAGES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDVDImages(TmpDVDImages.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DVDIMAGES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDVDImages.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DVDIMAGES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DVDIMAGES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDVDImages=%zu hrc=%Rhrc\n", this, "VirtualBox::getDVDImages", ComSafeArraySize(*aDVDImages), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(FloppyImages)(ComSafeArrayOut(IMedium *, aFloppyImages))
{
    LogRelFlow(("{%p} %s: enter aFloppyImages=%p\n", this, "VirtualBox::getFloppyImages", aFloppyImages));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFloppyImages);
        ArrayComTypeOutConverter<IMedium> TmpFloppyImages(ComSafeArrayOutArg(aFloppyImages));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_FLOPPYIMAGES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFloppyImages(TmpFloppyImages.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_FLOPPYIMAGES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFloppyImages.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_FLOPPYIMAGES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_FLOPPYIMAGES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFloppyImages=%zu hrc=%Rhrc\n", this, "VirtualBox::getFloppyImages", ComSafeArraySize(*aFloppyImages), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(ProgressOperations)(ComSafeArrayOut(IProgress *, aProgressOperations))
{
    LogRelFlow(("{%p} %s: enter aProgressOperations=%p\n", this, "VirtualBox::getProgressOperations", aProgressOperations));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgressOperations);
        ArrayComTypeOutConverter<IProgress> TmpProgressOperations(ComSafeArrayOutArg(aProgressOperations));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PROGRESSOPERATIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProgressOperations(TmpProgressOperations.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PROGRESSOPERATIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpProgressOperations.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PROGRESSOPERATIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PROGRESSOPERATIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProgressOperations=%zu hrc=%Rhrc\n", this, "VirtualBox::getProgressOperations", ComSafeArraySize(*aProgressOperations), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(GuestOSTypes)(ComSafeArrayOut(IGuestOSType *, aGuestOSTypes))
{
    LogRelFlow(("{%p} %s: enter aGuestOSTypes=%p\n", this, "VirtualBox::getGuestOSTypes", aGuestOSTypes));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestOSTypes);
        ArrayComTypeOutConverter<IGuestOSType> TmpGuestOSTypes(ComSafeArrayOutArg(aGuestOSTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestOSTypes(TmpGuestOSTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGuestOSTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestOSTypes=%zu hrc=%Rhrc\n", this, "VirtualBox::getGuestOSTypes", ComSafeArraySize(*aGuestOSTypes), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(GuestOSFamilies)(ComSafeArrayOut(BSTR, aGuestOSFamilies))
{
    LogRelFlow(("{%p} %s: enter aGuestOSFamilies=%p\n", this, "VirtualBox::getGuestOSFamilies", aGuestOSFamilies));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestOSFamilies);
        ArrayBSTROutConverter TmpGuestOSFamilies(ComSafeArrayOutArg(aGuestOSFamilies));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSFAMILIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestOSFamilies(TmpGuestOSFamilies.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSFAMILIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGuestOSFamilies.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSFAMILIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GUESTOSFAMILIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestOSFamilies=%zu hrc=%Rhrc\n", this, "VirtualBox::getGuestOSFamilies", ComSafeArraySize(*aGuestOSFamilies), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(SharedFolders)(ComSafeArrayOut(ISharedFolder *, aSharedFolders))
{
    LogRelFlow(("{%p} %s: enter aSharedFolders=%p\n", this, "VirtualBox::getSharedFolders", aSharedFolders));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSharedFolders);
        ArrayComTypeOutConverter<ISharedFolder> TmpSharedFolders(ComSafeArrayOutArg(aSharedFolders));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SHAREDFOLDERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSharedFolders(TmpSharedFolders.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SHAREDFOLDERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSharedFolders.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SHAREDFOLDERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_SHAREDFOLDERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSharedFolders=%zu hrc=%Rhrc\n", this, "VirtualBox::getSharedFolders", ComSafeArraySize(*aSharedFolders), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(PerformanceCollector)(IPerformanceCollector **aPerformanceCollector)
{
    LogRelFlow(("{%p} %s: enter aPerformanceCollector=%p\n", this, "VirtualBox::getPerformanceCollector", aPerformanceCollector));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPerformanceCollector);
        ComTypeOutConverter<IPerformanceCollector> TmpPerformanceCollector(aPerformanceCollector);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PERFORMANCECOLLECTOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPerformanceCollector(TmpPerformanceCollector.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PERFORMANCECOLLECTOR_RETURN(this, hrc, 0 /*normal*/,(void *)TmpPerformanceCollector.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PERFORMANCECOLLECTOR_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_PERFORMANCECOLLECTOR_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPerformanceCollector=%p hrc=%Rhrc\n", this, "VirtualBox::getPerformanceCollector", *aPerformanceCollector, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(DHCPServers)(ComSafeArrayOut(IDHCPServer *, aDHCPServers))
{
    LogRelFlow(("{%p} %s: enter aDHCPServers=%p\n", this, "VirtualBox::getDHCPServers", aDHCPServers));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDHCPServers);
        ArrayComTypeOutConverter<IDHCPServer> TmpDHCPServers(ComSafeArrayOutArg(aDHCPServers));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DHCPSERVERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDHCPServers(TmpDHCPServers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DHCPSERVERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDHCPServers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DHCPSERVERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_DHCPSERVERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDHCPServers=%zu hrc=%Rhrc\n", this, "VirtualBox::getDHCPServers", ComSafeArraySize(*aDHCPServers), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(NATNetworks)(ComSafeArrayOut(INATNetwork *, aNATNetworks))
{
    LogRelFlow(("{%p} %s: enter aNATNetworks=%p\n", this, "VirtualBox::getNATNetworks", aNATNetworks));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNATNetworks);
        ArrayComTypeOutConverter<INATNetwork> TmpNATNetworks(ComSafeArrayOutArg(aNATNetworks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_NATNETWORKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNATNetworks(TmpNATNetworks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_NATNETWORKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpNATNetworks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_NATNETWORKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_NATNETWORKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNATNetworks=%zu hrc=%Rhrc\n", this, "VirtualBox::getNATNetworks", ComSafeArraySize(*aNATNetworks), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "VirtualBox::getEventSource", aEventSource));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "VirtualBox::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(ExtensionPackManager)(IExtPackManager **aExtensionPackManager)
{
    LogRelFlow(("{%p} %s: enter aExtensionPackManager=%p\n", this, "VirtualBox::getExtensionPackManager", aExtensionPackManager));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExtensionPackManager);
        ComTypeOutConverter<IExtPackManager> TmpExtensionPackManager(aExtensionPackManager);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EXTENSIONPACKMANAGER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtensionPackManager(TmpExtensionPackManager.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EXTENSIONPACKMANAGER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpExtensionPackManager.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EXTENSIONPACKMANAGER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_EXTENSIONPACKMANAGER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExtensionPackManager=%p hrc=%Rhrc\n", this, "VirtualBox::getExtensionPackManager", *aExtensionPackManager, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalNetworks)(ComSafeArrayOut(BSTR, aInternalNetworks))
{
    LogRelFlow(("{%p} %s: enter aInternalNetworks=%p\n", this, "VirtualBox::getInternalNetworks", aInternalNetworks));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInternalNetworks);
        ArrayBSTROutConverter TmpInternalNetworks(ComSafeArrayOutArg(aInternalNetworks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_INTERNALNETWORKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInternalNetworks(TmpInternalNetworks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_INTERNALNETWORKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpInternalNetworks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_INTERNALNETWORKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_INTERNALNETWORKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInternalNetworks=%zu hrc=%Rhrc\n", this, "VirtualBox::getInternalNetworks", ComSafeArraySize(*aInternalNetworks), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(HostOnlyNetworks)(ComSafeArrayOut(IHostOnlyNetwork *, aHostOnlyNetworks))
{
    LogRelFlow(("{%p} %s: enter aHostOnlyNetworks=%p\n", this, "VirtualBox::getHostOnlyNetworks", aHostOnlyNetworks));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostOnlyNetworks);
        ArrayComTypeOutConverter<IHostOnlyNetwork> TmpHostOnlyNetworks(ComSafeArrayOutArg(aHostOnlyNetworks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOSTONLYNETWORKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostOnlyNetworks(TmpHostOnlyNetworks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOSTONLYNETWORKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpHostOnlyNetworks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOSTONLYNETWORKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_HOSTONLYNETWORKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostOnlyNetworks=%zu hrc=%Rhrc\n", this, "VirtualBox::getHostOnlyNetworks", ComSafeArraySize(*aHostOnlyNetworks), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(GenericNetworkDrivers)(ComSafeArrayOut(BSTR, aGenericNetworkDrivers))
{
    LogRelFlow(("{%p} %s: enter aGenericNetworkDrivers=%p\n", this, "VirtualBox::getGenericNetworkDrivers", aGenericNetworkDrivers));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGenericNetworkDrivers);
        ArrayBSTROutConverter TmpGenericNetworkDrivers(ComSafeArrayOutArg(aGenericNetworkDrivers));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GENERICNETWORKDRIVERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGenericNetworkDrivers(TmpGenericNetworkDrivers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GENERICNETWORKDRIVERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGenericNetworkDrivers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GENERICNETWORKDRIVERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_GENERICNETWORKDRIVERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGenericNetworkDrivers=%zu hrc=%Rhrc\n", this, "VirtualBox::getGenericNetworkDrivers", ComSafeArraySize(*aGenericNetworkDrivers), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(CloudNetworks)(ComSafeArrayOut(ICloudNetwork *, aCloudNetworks))
{
    LogRelFlow(("{%p} %s: enter aCloudNetworks=%p\n", this, "VirtualBox::getCloudNetworks", aCloudNetworks));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCloudNetworks);
        ArrayComTypeOutConverter<ICloudNetwork> TmpCloudNetworks(ComSafeArrayOutArg(aCloudNetworks));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDNETWORKS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCloudNetworks(TmpCloudNetworks.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDNETWORKS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpCloudNetworks.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDNETWORKS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDNETWORKS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCloudNetworks=%zu hrc=%Rhrc\n", this, "VirtualBox::getCloudNetworks", ComSafeArraySize(*aCloudNetworks), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(CloudProviderManager)(ICloudProviderManager **aCloudProviderManager)
{
    LogRelFlow(("{%p} %s: enter aCloudProviderManager=%p\n", this, "VirtualBox::getCloudProviderManager", aCloudProviderManager));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCloudProviderManager);
        ComTypeOutConverter<ICloudProviderManager> TmpCloudProviderManager(aCloudProviderManager);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDPROVIDERMANAGER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCloudProviderManager(TmpCloudProviderManager.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDPROVIDERMANAGER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpCloudProviderManager.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDPROVIDERMANAGER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GET_CLOUDPROVIDERMANAGER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCloudProviderManager=%p hrc=%Rhrc\n", this, "VirtualBox::getCloudProviderManager", *aCloudProviderManager, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute1IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute2IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute3IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute4IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute5IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute6IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute7IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute8IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute9IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute10IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute11IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::COMGETTER(InternalAndReservedAttribute12IVirtualBox)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IVirtualBox methods
//

STDMETHODIMP VirtualBoxWrap::ComposeMachineFilename(IN_BSTR aName,
                                                    IN_BSTR aGroup,
                                                    IN_BSTR aCreateFlags,
                                                    IN_BSTR aBaseFolder,
                                                    BSTR *aFile)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aGroup=%ls aCreateFlags=%ls aBaseFolder=%ls aFile=%p\n", this, "VirtualBox::composeMachineFilename", aName, aGroup, aCreateFlags, aBaseFolder, aFile));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFile);


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpGroup(aGroup);
        BSTRInConverter TmpCreateFlags(aCreateFlags);
        BSTRInConverter TmpBaseFolder(aBaseFolder);
        BSTROutConverter TmpFile(aFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_COMPOSEMACHINEFILENAME_ENTER(this, TmpName.str().c_str(), TmpGroup.str().c_str(), TmpCreateFlags.str().c_str(), TmpBaseFolder.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = composeMachineFilename(TmpName.str(),
                                         TmpGroup.str(),
                                         TmpCreateFlags.str(),
                                         TmpBaseFolder.str(),
                                         TmpFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_COMPOSEMACHINEFILENAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpGroup.str().c_str(), TmpCreateFlags.str().c_str(), TmpBaseFolder.str().c_str(), TmpFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_COMPOSEMACHINEFILENAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_COMPOSEMACHINEFILENAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFile=%ls hrc=%Rhrc\n", this, "VirtualBox::composeMachineFilename", *aFile, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetPlatformProperties(PlatformArchitecture_T aArchitecture,
                                                   IPlatformProperties **aProperties)
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%RU32 aProperties=%p\n", this, "VirtualBox::getPlatformProperties", aArchitecture, aProperties));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProperties);


        
        ComTypeOutConverter<IPlatformProperties> TmpProperties(aProperties);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETPLATFORMPROPERTIES_ENTER(this, aArchitecture);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlatformProperties(aArchitecture,
                                        TmpProperties.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETPLATFORMPROPERTIES_RETURN(this, hrc, 0 /*normal*/, aArchitecture, (void *)TmpProperties.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETPLATFORMPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, aArchitecture, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETPLATFORMPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, aArchitecture, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProperties=%p hrc=%Rhrc\n", this, "VirtualBox::getPlatformProperties", *aProperties, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateMachine(IN_BSTR aSettingsFile,
                                           IN_BSTR aName,
                                           PlatformArchitecture_T aPlatform,
                                           ComSafeArrayIn(IN_BSTR, aGroups),
                                           IN_BSTR aOsTypeId,
                                           IN_BSTR aFlags,
                                           IN_BSTR aCipher,
                                           IN_BSTR aPasswordId,
                                           IN_BSTR aPassword,
                                           IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aSettingsFile=%ls aName=%ls aPlatform=%RU32 aGroups=%zu aOsTypeId=%ls aFlags=%ls aCipher=%ls aPasswordId=%ls aPassword=%ls aMachine=%p\n", this, "VirtualBox::createMachine", aSettingsFile, aName, aPlatform, aGroups, aOsTypeId, aFlags, aCipher, aPasswordId, aPassword, aMachine));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);


        BSTRInConverter TmpSettingsFile(aSettingsFile);
        BSTRInConverter TmpName(aName);
        
        ArrayBSTRInConverter TmpGroups(ComSafeArrayInArg(aGroups));
        BSTRInConverter TmpOsTypeId(aOsTypeId);
        BSTRInConverter TmpFlags(aFlags);
        BSTRInConverter TmpCipher(aCipher);
        BSTRInConverter TmpPasswordId(aPasswordId);
        BSTRInConverter TmpPassword(aPassword);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMACHINE_ENTER(this, TmpSettingsFile.str().c_str(), TmpName.str().c_str(), aPlatform, (uint32_t)TmpGroups.array().size(), NULL /*for now*/, TmpOsTypeId.str().c_str(), TmpFlags.str().c_str(), TmpCipher.str().c_str(), TmpPasswordId.str().c_str(), TmpPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createMachine(TmpSettingsFile.str(),
                                TmpName.str(),
                                aPlatform,
                                TmpGroups.array(),
                                TmpOsTypeId.str(),
                                TmpFlags.str(),
                                TmpCipher.str(),
                                TmpPasswordId.str(),
                                TmpPassword.str(),
                                TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMACHINE_RETURN(this, hrc, 0 /*normal*/, TmpSettingsFile.str().c_str(), TmpName.str().c_str(), aPlatform, (uint32_t)TmpGroups.array().size(), NULL /*for now*/, TmpOsTypeId.str().c_str(), TmpFlags.str().c_str(), TmpCipher.str().c_str(), TmpPasswordId.str().c_str(), TmpPassword.str().c_str(), (void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aPlatform, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aPlatform, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMachine=%p hrc=%Rhrc\n", this, "VirtualBox::createMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::OpenMachine(IN_BSTR aSettingsFile,
                                         IN_BSTR aPassword,
                                         IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aSettingsFile=%ls aPassword=%ls aMachine=%p\n", this, "VirtualBox::openMachine", aSettingsFile, aPassword, aMachine));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);


        BSTRInConverter TmpSettingsFile(aSettingsFile);
        BSTRInConverter TmpPassword(aPassword);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMACHINE_ENTER(this, TmpSettingsFile.str().c_str(), TmpPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = openMachine(TmpSettingsFile.str(),
                              TmpPassword.str(),
                              TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMACHINE_RETURN(this, hrc, 0 /*normal*/, TmpSettingsFile.str().c_str(), TmpPassword.str().c_str(), (void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMachine=%p hrc=%Rhrc\n", this, "VirtualBox::openMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RegisterMachine(IMachine *aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "VirtualBox::registerMachine", aMachine));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REGISTERMACHINE_ENTER(this, (void *)TmpMachine.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = registerMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REGISTERMACHINE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REGISTERMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REGISTERMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::registerMachine", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindMachine(IN_BSTR aNameOrId,
                                         IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aNameOrId=%ls aMachine=%p\n", this, "VirtualBox::findMachine", aNameOrId, aMachine));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);


        BSTRInConverter TmpNameOrId(aNameOrId);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDMACHINE_ENTER(this, TmpNameOrId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findMachine(TmpNameOrId.str(),
                              TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDMACHINE_RETURN(this, hrc, 0 /*normal*/, TmpNameOrId.str().c_str(), (void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDMACHINE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDMACHINE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMachine=%p hrc=%Rhrc\n", this, "VirtualBox::findMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetMachinesByGroups(ComSafeArrayIn(IN_BSTR, aGroups),
                                                 ComSafeArrayOut(IMachine *, aMachines))
{
    LogRelFlow(("{%p} %s: enter aGroups=%zu aMachines=%p\n", this, "VirtualBox::getMachinesByGroups", aGroups, aMachines));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachines);


        ArrayBSTRInConverter TmpGroups(ComSafeArrayInArg(aGroups));
        ArrayComTypeOutConverter<IMachine> TmpMachines(ComSafeArrayOutArg(aMachines));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESBYGROUPS_ENTER(this, (uint32_t)TmpGroups.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachinesByGroups(TmpGroups.array(),
                                      TmpMachines.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESBYGROUPS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpGroups.array().size(), NULL /*for now*/, (uint32_t)TmpMachines.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESBYGROUPS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESBYGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMachines=%zu hrc=%Rhrc\n", this, "VirtualBox::getMachinesByGroups", ComSafeArraySize(*aMachines), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetMachineStates(ComSafeArrayIn(IMachine *, aMachines),
                                              ComSafeArrayOut(MachineState_T, aStates))
{
    LogRelFlow(("{%p} %s: enter aMachines=%zu aStates=%p\n", this, "VirtualBox::getMachineStates", aMachines, aStates));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStates);


        ArrayComTypeInConverter<IMachine> TmpMachines(ComSafeArrayInArg(aMachines));
        ArrayOutConverter<MachineState_T> TmpStates(ComSafeArrayOutArg(aStates));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESTATES_ENTER(this, (uint32_t)TmpMachines.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachineStates(TmpMachines.array(),
                                   TmpStates.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESTATES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpMachines.array().size(), NULL /*for now*/, (uint32_t)TmpStates.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESTATES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETMACHINESTATES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStates=%zu hrc=%Rhrc\n", this, "VirtualBox::getMachineStates", ComSafeArraySize(*aStates), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateAppliance(IAppliance **aAppliance)
{
    LogRelFlow(("{%p} %s: enter aAppliance=%p\n", this, "VirtualBox::createAppliance", aAppliance));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAppliance);


        ComTypeOutConverter<IAppliance> TmpAppliance(aAppliance);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEAPPLIANCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createAppliance(TmpAppliance.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEAPPLIANCE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpAppliance.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEAPPLIANCE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEAPPLIANCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAppliance=%p hrc=%Rhrc\n", this, "VirtualBox::createAppliance", *aAppliance, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateUnattendedInstaller(IUnattended **aUnattended)
{
    LogRelFlow(("{%p} %s: enter aUnattended=%p\n", this, "VirtualBox::createUnattendedInstaller", aUnattended));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUnattended);


        ComTypeOutConverter<IUnattended> TmpUnattended(aUnattended);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEUNATTENDEDINSTALLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createUnattendedInstaller(TmpUnattended.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEUNATTENDEDINSTALLER_RETURN(this, hrc, 0 /*normal*/, (void *)TmpUnattended.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEUNATTENDEDINSTALLER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEUNATTENDEDINSTALLER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aUnattended=%p hrc=%Rhrc\n", this, "VirtualBox::createUnattendedInstaller", *aUnattended, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateMedium(IN_BSTR aFormat,
                                          IN_BSTR aLocation,
                                          AccessMode_T aAccessMode,
                                          DeviceType_T aADeviceTypeType,
                                          IMedium **aMedium)
{
    LogRelFlow(("{%p} %s: enter aFormat=%ls aLocation=%ls aAccessMode=%RU32 aADeviceTypeType=%RU32 aMedium=%p\n", this, "VirtualBox::createMedium", aFormat, aLocation, aAccessMode, aADeviceTypeType, aMedium));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedium);


        BSTRInConverter TmpFormat(aFormat);
        BSTRInConverter TmpLocation(aLocation);
        
        
        ComTypeOutConverter<IMedium> TmpMedium(aMedium);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMEDIUM_ENTER(this, TmpFormat.str().c_str(), TmpLocation.str().c_str(), aAccessMode, aADeviceTypeType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createMedium(TmpFormat.str(),
                               TmpLocation.str(),
                               aAccessMode,
                               aADeviceTypeType,
                               TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), TmpLocation.str().c_str(), aAccessMode, aADeviceTypeType, (void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aAccessMode, aADeviceTypeType, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aAccessMode, aADeviceTypeType, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMedium=%p hrc=%Rhrc\n", this, "VirtualBox::createMedium", *aMedium, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::OpenMedium(IN_BSTR aLocation,
                                        DeviceType_T aDeviceType,
                                        AccessMode_T aAccessMode,
                                        BOOL aForceNewUuid,
                                        IMedium **aMedium)
{
    LogRelFlow(("{%p} %s: enter aLocation=%ls aDeviceType=%RU32 aAccessMode=%RU32 aForceNewUuid=%RTbool aMedium=%p\n", this, "VirtualBox::openMedium", aLocation, aDeviceType, aAccessMode, aForceNewUuid, aMedium));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedium);


        BSTRInConverter TmpLocation(aLocation);
        
        
        
        ComTypeOutConverter<IMedium> TmpMedium(aMedium);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMEDIUM_ENTER(this, TmpLocation.str().c_str(), aDeviceType, aAccessMode, aForceNewUuid != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = openMedium(TmpLocation.str(),
                             aDeviceType,
                             aAccessMode,
                             aForceNewUuid != FALSE,
                             TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMEDIUM_RETURN(this, hrc, 0 /*normal*/, TmpLocation.str().c_str(), aDeviceType, aAccessMode, aForceNewUuid != FALSE, (void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMEDIUM_RETURN(this, hrc, 1 /*hrc exception*/, 0, aDeviceType, aAccessMode, aForceNewUuid != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_OPENMEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aDeviceType, aAccessMode, aForceNewUuid != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMedium=%p hrc=%Rhrc\n", this, "VirtualBox::openMedium", *aMedium, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetGuestOSType(IN_BSTR aId,
                                            IGuestOSType **aType)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aType=%p\n", this, "VirtualBox::getGuestOSType", aId, aType));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);


        BSTRInConverter TmpId(aId);
        ComTypeOutConverter<IGuestOSType> TmpType(aType);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSTYPE_ENTER(this, TmpId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestOSType(TmpId.str(),
                                 TmpType.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSTYPE_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str(), (void *)TmpType.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSTYPE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aType=%p hrc=%Rhrc\n", this, "VirtualBox::getGuestOSType", *aType, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetGuestOSSubtypesByFamilyId(IN_BSTR aFamily,
                                                          ComSafeArrayOut(BSTR, aOSsubtypes))
{
    LogRelFlow(("{%p} %s: enter aFamily=%ls aOSsubtypes=%p\n", this, "VirtualBox::getGuestOSSubtypesByFamilyId", aFamily, aOSsubtypes));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSsubtypes);


        BSTRInConverter TmpFamily(aFamily);
        ArrayBSTROutConverter TmpOSsubtypes(ComSafeArrayOutArg(aOSsubtypes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSSUBTYPESBYFAMILYID_ENTER(this, TmpFamily.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestOSSubtypesByFamilyId(TmpFamily.str(),
                                               TmpOSsubtypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSSUBTYPESBYFAMILYID_RETURN(this, hrc, 0 /*normal*/, TmpFamily.str().c_str(), (uint32_t)TmpOSsubtypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSSUBTYPESBYFAMILYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSSUBTYPESBYFAMILYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aOSsubtypes=%zu hrc=%Rhrc\n", this, "VirtualBox::getGuestOSSubtypesByFamilyId", ComSafeArraySize(*aOSsubtypes), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetGuestOSDescsBySubtype(IN_BSTR aOSSubtype,
                                                      ComSafeArrayOut(BSTR, aGuestOSDescs))
{
    LogRelFlow(("{%p} %s: enter aOSSubtype=%ls aGuestOSDescs=%p\n", this, "VirtualBox::getGuestOSDescsBySubtype", aOSSubtype, aGuestOSDescs));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestOSDescs);


        BSTRInConverter TmpOSSubtype(aOSSubtype);
        ArrayBSTROutConverter TmpGuestOSDescs(ComSafeArrayOutArg(aGuestOSDescs));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSDESCSBYSUBTYPE_ENTER(this, TmpOSSubtype.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestOSDescsBySubtype(TmpOSSubtype.str(),
                                           TmpGuestOSDescs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSDESCSBYSUBTYPE_RETURN(this, hrc, 0 /*normal*/, TmpOSSubtype.str().c_str(), (uint32_t)TmpGuestOSDescs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSDESCSBYSUBTYPE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETGUESTOSDESCSBYSUBTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestOSDescs=%zu hrc=%Rhrc\n", this, "VirtualBox::getGuestOSDescsBySubtype", ComSafeArraySize(*aGuestOSDescs), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateSharedFolder(IN_BSTR aName,
                                                IN_BSTR aHostPath,
                                                BOOL aWritable,
                                                BOOL aAutomount,
                                                IN_BSTR aAutoMountPoint)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aHostPath=%ls aWritable=%RTbool aAutomount=%RTbool aAutoMountPoint=%ls\n", this, "VirtualBox::createSharedFolder", aName, aHostPath, aWritable, aAutomount, aAutoMountPoint));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpHostPath(aHostPath);
        
        
        BSTRInConverter TmpAutoMountPoint(aAutoMountPoint);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATESHAREDFOLDER_ENTER(this, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createSharedFolder(TmpName.str(),
                                     TmpHostPath.str(),
                                     aWritable != FALSE,
                                     aAutomount != FALSE,
                                     TmpAutoMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::createSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RemoveSharedFolder(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "VirtualBox::removeSharedFolder", aName));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVESHAREDFOLDER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeSharedFolder(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::removeSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetExtraDataKeys(ComSafeArrayOut(BSTR, aKeys))
{
    LogRelFlow(("{%p} %s: enter aKeys=%p\n", this, "VirtualBox::getExtraDataKeys", aKeys));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeys);


        ArrayBSTROutConverter TmpKeys(ComSafeArrayOutArg(aKeys));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATAKEYS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtraDataKeys(TmpKeys.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATAKEYS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpKeys.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATAKEYS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATAKEYS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aKeys=%zu hrc=%Rhrc\n", this, "VirtualBox::getExtraDataKeys", ComSafeArraySize(*aKeys), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetExtraData(IN_BSTR aKey,
                                          BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "VirtualBox::getExtraData", aKey, aValue));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATA_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtraData(TmpKey.str(),
                               TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATA_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETEXTRADATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "VirtualBox::getExtraData", *aValue, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::SetExtraData(IN_BSTR aKey,
                                          IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%ls\n", this, "VirtualBox::setExtraData", aKey, aValue));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpKey(aKey);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETEXTRADATA_ENTER(this, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setExtraData(TmpKey.str(),
                               TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETEXTRADATA_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETEXTRADATA_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETEXTRADATA_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::setExtraData", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::SetSettingsSecret(IN_BSTR aPassword)
{
    LogRelFlow(("{%p} %s: enter aPassword=%ls\n", this, "VirtualBox::setSettingsSecret", aPassword));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPassword(aPassword);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETSETTINGSSECRET_ENTER(this, TmpPassword.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSettingsSecret(TmpPassword.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETSETTINGSSECRET_RETURN(this, hrc, 0 /*normal*/, TmpPassword.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETSETTINGSSECRET_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_SETSETTINGSSECRET_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::setSettingsSecret", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateDHCPServer(IN_BSTR aName,
                                              IDHCPServer **aServer)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aServer=%p\n", this, "VirtualBox::createDHCPServer", aName, aServer));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aServer);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IDHCPServer> TmpServer(aServer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEDHCPSERVER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createDHCPServer(TmpName.str(),
                                   TmpServer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEDHCPSERVER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpServer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEDHCPSERVER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEDHCPSERVER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aServer=%p hrc=%Rhrc\n", this, "VirtualBox::createDHCPServer", *aServer, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindDHCPServerByNetworkName(IN_BSTR aName,
                                                         IDHCPServer **aServer)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aServer=%p\n", this, "VirtualBox::findDHCPServerByNetworkName", aName, aServer));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aServer);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IDHCPServer> TmpServer(aServer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDDHCPSERVERBYNETWORKNAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findDHCPServerByNetworkName(TmpName.str(),
                                              TmpServer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDDHCPSERVERBYNETWORKNAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpServer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDDHCPSERVERBYNETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDDHCPSERVERBYNETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aServer=%p hrc=%Rhrc\n", this, "VirtualBox::findDHCPServerByNetworkName", *aServer, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RemoveDHCPServer(IDHCPServer *aServer)
{
    LogRelFlow(("{%p} %s: enter aServer=%p\n", this, "VirtualBox::removeDHCPServer", aServer));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IDHCPServer> TmpServer(aServer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEDHCPSERVER_ENTER(this, (void *)TmpServer.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeDHCPServer(TmpServer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEDHCPSERVER_RETURN(this, hrc, 0 /*normal*/, (void *)TmpServer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEDHCPSERVER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEDHCPSERVER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::removeDHCPServer", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateNATNetwork(IN_BSTR aNetworkName,
                                              INATNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::createNATNetwork", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<INATNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATENATNETWORK_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createNATNetwork(TmpNetworkName.str(),
                                   TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATENATNETWORK_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATENATNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATENATNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::createNATNetwork", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindNATNetworkByName(IN_BSTR aNetworkName,
                                                  INATNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::findNATNetworkByName", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<INATNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDNATNETWORKBYNAME_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findNATNetworkByName(TmpNetworkName.str(),
                                       TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDNATNETWORKBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDNATNETWORKBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDNATNETWORKBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::findNATNetworkByName", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RemoveNATNetwork(INATNetwork *aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%p\n", this, "VirtualBox::removeNATNetwork", aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<INATNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVENATNETWORK_ENTER(this, (void *)TmpNetwork.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeNATNetwork(TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVENATNETWORK_RETURN(this, hrc, 0 /*normal*/, (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVENATNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVENATNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::removeNATNetwork", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateHostOnlyNetwork(IN_BSTR aNetworkName,
                                                   IHostOnlyNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::createHostOnlyNetwork", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<IHostOnlyNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEHOSTONLYNETWORK_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createHostOnlyNetwork(TmpNetworkName.str(),
                                        TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEHOSTONLYNETWORK_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEHOSTONLYNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATEHOSTONLYNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::createHostOnlyNetwork", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindHostOnlyNetworkByName(IN_BSTR aNetworkName,
                                                       IHostOnlyNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::findHostOnlyNetworkByName", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<IHostOnlyNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYNAME_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostOnlyNetworkByName(TmpNetworkName.str(),
                                            TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::findHostOnlyNetworkByName", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindHostOnlyNetworkById(IN_BSTR aId,
                                                     IHostOnlyNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aNetwork=%p\n", this, "VirtualBox::findHostOnlyNetworkById", aId, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IHostOnlyNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYID_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostOnlyNetworkById(TmpId.uuid(),
                                          TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYID_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDHOSTONLYNETWORKBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::findHostOnlyNetworkById", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RemoveHostOnlyNetwork(IHostOnlyNetwork *aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%p\n", this, "VirtualBox::removeHostOnlyNetwork", aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IHostOnlyNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEHOSTONLYNETWORK_ENTER(this, (void *)TmpNetwork.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeHostOnlyNetwork(TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEHOSTONLYNETWORK_RETURN(this, hrc, 0 /*normal*/, (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEHOSTONLYNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVEHOSTONLYNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::removeHostOnlyNetwork", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CreateCloudNetwork(IN_BSTR aNetworkName,
                                                ICloudNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::createCloudNetwork", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<ICloudNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATECLOUDNETWORK_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createCloudNetwork(TmpNetworkName.str(),
                                     TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATECLOUDNETWORK_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATECLOUDNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CREATECLOUDNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::createCloudNetwork", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindCloudNetworkByName(IN_BSTR aNetworkName,
                                                    ICloudNetwork **aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls aNetwork=%p\n", this, "VirtualBox::findCloudNetworkByName", aNetworkName, aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);


        BSTRInConverter TmpNetworkName(aNetworkName);
        ComTypeOutConverter<ICloudNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDCLOUDNETWORKBYNAME_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findCloudNetworkByName(TmpNetworkName.str(),
                                         TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDCLOUDNETWORKBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpNetworkName.str().c_str(), (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDCLOUDNETWORKBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDCLOUDNETWORKBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetwork=%p hrc=%Rhrc\n", this, "VirtualBox::findCloudNetworkByName", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::RemoveCloudNetwork(ICloudNetwork *aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%p\n", this, "VirtualBox::removeCloudNetwork", aNetwork));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<ICloudNetwork> TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVECLOUDNETWORK_ENTER(this, (void *)TmpNetwork.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeCloudNetwork(TmpNetwork.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVECLOUDNETWORK_RETURN(this, hrc, 0 /*normal*/, (void *)TmpNetwork.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVECLOUDNETWORK_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_REMOVECLOUDNETWORK_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBox::removeCloudNetwork", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::CheckFirmwarePresent(PlatformArchitecture_T aPlatformArchitecture,
                                                  FirmwareType_T aFirmwareType,
                                                  IN_BSTR aVersion,
                                                  BSTR *aUrl,
                                                  BSTR *aFile,
                                                  BOOL *aResult)
{
    LogRelFlow(("{%p} %s: enter aPlatformArchitecture=%RU32 aFirmwareType=%RU32 aVersion=%ls aUrl=%p aFile=%p aResult=%p\n", this, "VirtualBox::checkFirmwarePresent", aPlatformArchitecture, aFirmwareType, aVersion, aUrl, aFile, aResult));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUrl);
        CheckComArgOutPointerValidThrow(aFile);
        CheckComArgOutPointerValidThrow(aResult);


        
        
        BSTRInConverter TmpVersion(aVersion);
        BSTROutConverter TmpUrl(aUrl);
        BSTROutConverter TmpFile(aFile);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CHECKFIRMWAREPRESENT_ENTER(this, aPlatformArchitecture, aFirmwareType, TmpVersion.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = checkFirmwarePresent(aPlatformArchitecture,
                                       aFirmwareType,
                                       TmpVersion.str(),
                                       TmpUrl.str(),
                                       TmpFile.str(),
                                       aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CHECKFIRMWAREPRESENT_RETURN(this, hrc, 0 /*normal*/, aPlatformArchitecture, aFirmwareType, TmpVersion.str().c_str(), TmpUrl.str().c_str(), TmpFile.str().c_str(), *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CHECKFIRMWAREPRESENT_RETURN(this, hrc, 1 /*hrc exception*/, aPlatformArchitecture, aFirmwareType, 0, 0, 0, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_CHECKFIRMWAREPRESENT_RETURN(this, hrc, 9 /*unhandled exception*/, aPlatformArchitecture, aFirmwareType, 0, 0, 0, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUrl=%ls *aFile=%ls aResult=%RTbool hrc=%Rhrc\n", this, "VirtualBox::checkFirmwarePresent", *aUrl, *aFile, *aResult, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::FindProgressById(IN_BSTR aId,
                                              IProgress **aProgressObject)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aProgressObject=%p\n", this, "VirtualBox::findProgressById", aId, aProgressObject));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgressObject);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IProgress> TmpProgressObject(aProgressObject);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDPROGRESSBYID_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findProgressById(TmpId.uuid(),
                                   TmpProgressObject.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDPROGRESSBYID_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpProgressObject.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDPROGRESSBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_FINDPROGRESSBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgressObject=%p hrc=%Rhrc\n", this, "VirtualBox::findProgressById", *aProgressObject, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetTrackedObject(IN_BSTR aTrObjId,
                                              IUnknown **aPIface,
                                              TrackedObjectState_T *aState,
                                              LONG64 *aCreationTime,
                                              LONG64 *aDeletionTime)
{
    LogRelFlow(("{%p} %s: enter aTrObjId=%ls aPIface=%p aState=%p aCreationTime=%p aDeletionTime=%p\n", this, "VirtualBox::getTrackedObject", aTrObjId, aPIface, aState, aCreationTime, aDeletionTime));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPIface);
        CheckComArgOutPointerValidThrow(aState);
        CheckComArgOutPointerValidThrow(aCreationTime);
        CheckComArgOutPointerValidThrow(aDeletionTime);


        BSTRInConverter TmpTrObjId(aTrObjId);
        ComTypeOutConverter<IUnknown> TmpPIface(aPIface);
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECT_ENTER(this, TmpTrObjId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTrackedObject(TmpTrObjId.str(),
                                   TmpPIface.ptr(),
                                   aState,
                                   aCreationTime,
                                   aDeletionTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECT_RETURN(this, hrc, 0 /*normal*/, TmpTrObjId.str().c_str(), (void *)TmpPIface.ptr(), *aState, *aCreationTime, *aDeletionTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, *aState, *aCreationTime, *aDeletionTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, *aState, *aCreationTime, *aDeletionTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPIface=%p *aState=%RU32 *aCreationTime=%RI64 *aDeletionTime=%RI64 hrc=%Rhrc\n", this, "VirtualBox::getTrackedObject", *aPIface, *aState, *aCreationTime, *aDeletionTime, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::GetTrackedObjectIds(IN_BSTR aName,
                                                 ComSafeArrayOut(BSTR, aObjIdsList))
{
    LogRelFlow(("{%p} %s: enter aName=%ls aObjIdsList=%p\n", this, "VirtualBox::getTrackedObjectIds", aName, aObjIdsList));

    i_callHook(__FUNCTION__);
    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aObjIdsList);


        BSTRInConverter TmpName(aName);
        ArrayBSTROutConverter TmpObjIdsList(ComSafeArrayOutArg(aObjIdsList));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECTIDS_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTrackedObjectIds(TmpName.str(),
                                      TmpObjIdsList.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECTIDS_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (uint32_t)TmpObjIdsList.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECTIDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOX_GETTRACKEDOBJECTIDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aObjIdsList=%zu hrc=%Rhrc\n", this, "VirtualBox::getTrackedObjectIds", ComSafeArraySize(*aObjIdsList), hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod1IVirtualBox()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod2IVirtualBox()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod3IVirtualBox()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod4IVirtualBox()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod5IVirtualBox()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxWrap::InternalAndReservedMethod6IVirtualBox()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VirtualBoxWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VirtualBoxWrap, IVirtualBox)
#endif // VBOX_WITH_XPCOM
