/** @file
 * VirtualBox API class wrapper code for IUSBDeviceFilters.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_USBDEVICEFILTERS

#include "USBDeviceFiltersWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(USBDeviceFiltersWrap)

//
// IUSBDeviceFilters properties
//

STDMETHODIMP USBDeviceFiltersWrap::COMGETTER(DeviceFilters)(ComSafeArrayOut(IUSBDeviceFilter *, aDeviceFilters))
{
    LogRelFlow(("{%p} %s: enter aDeviceFilters=%p\n", this, "USBDeviceFilters::getDeviceFilters", aDeviceFilters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDeviceFilters);
        ArrayComTypeOutConverter<IUSBDeviceFilter> TmpDeviceFilters(ComSafeArrayOutArg(aDeviceFilters));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_GET_DEVICEFILTERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceFilters(TmpDeviceFilters.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_GET_DEVICEFILTERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDeviceFilters.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_GET_DEVICEFILTERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_GET_DEVICEFILTERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDeviceFilters=%zu hrc=%Rhrc\n", this, "USBDeviceFilters::getDeviceFilters", ComSafeArraySize(*aDeviceFilters), hrc));
    return hrc;
}

STDMETHODIMP USBDeviceFiltersWrap::COMGETTER(InternalAndReservedAttribute1IUSBDeviceFilters)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBDeviceFiltersWrap::COMGETTER(InternalAndReservedAttribute2IUSBDeviceFilters)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUSBDeviceFilters methods
//

STDMETHODIMP USBDeviceFiltersWrap::CreateDeviceFilter(IN_BSTR aName,
                                                      IUSBDeviceFilter **aFilter)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aFilter=%p\n", this, "USBDeviceFilters::createDeviceFilter", aName, aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilter);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IUSBDeviceFilter> TmpFilter(aFilter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_CREATEDEVICEFILTER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createDeviceFilter(TmpName.str(),
                                     TmpFilter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_CREATEDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpFilter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_CREATEDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_CREATEDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFilter=%p hrc=%Rhrc\n", this, "USBDeviceFilters::createDeviceFilter", *aFilter, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceFiltersWrap::InsertDeviceFilter(ULONG aPosition,
                                                      IUSBDeviceFilter *aFilter)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32 aFilter=%p\n", this, "USBDeviceFilters::insertDeviceFilter", aPosition, aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ComTypeInConverter<IUSBDeviceFilter> TmpFilter(aFilter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_INSERTDEVICEFILTER_ENTER(this, aPosition, (void *)TmpFilter.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = insertDeviceFilter(aPosition,
                                     TmpFilter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_INSERTDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, aPosition, (void *)TmpFilter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_INSERTDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_INSERTDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "USBDeviceFilters::insertDeviceFilter", hrc));
    return hrc;
}

STDMETHODIMP USBDeviceFiltersWrap::RemoveDeviceFilter(ULONG aPosition,
                                                      IUSBDeviceFilter **aFilter)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32 aFilter=%p\n", this, "USBDeviceFilters::removeDeviceFilter", aPosition, aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilter);


        
        ComTypeOutConverter<IUSBDeviceFilter> TmpFilter(aFilter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_REMOVEDEVICEFILTER_ENTER(this, aPosition);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeDeviceFilter(aPosition,
                                     TmpFilter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_REMOVEDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, aPosition, (void *)TmpFilter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_REMOVEDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICEFILTERS_REMOVEDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFilter=%p hrc=%Rhrc\n", this, "USBDeviceFilters::removeDeviceFilter", *aFilter, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceFiltersWrap::InternalAndReservedMethod1IUSBDeviceFilters()
{
    return E_NOTIMPL;
}

STDMETHODIMP USBDeviceFiltersWrap::InternalAndReservedMethod2IUSBDeviceFilters()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBDeviceFiltersWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(USBDeviceFiltersWrap, IUSBDeviceFilters)
#endif // VBOX_WITH_XPCOM
