/** @file
 * VirtualBox API class wrapper code for IPlatformX86.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PLATFORMX86

#include "PlatformX86Wrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PlatformX86Wrap)

//
// IPlatformX86 properties
//

STDMETHODIMP PlatformX86Wrap::COMGETTER(HPETEnabled)(BOOL *aHPETEnabled)
{
    LogRelFlow(("{%p} %s: enter aHPETEnabled=%p\n", this, "PlatformX86::getHPETEnabled", aHPETEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHPETEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GET_HPETENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHPETEnabled(aHPETEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GET_HPETENABLED_RETURN(this, hrc, 0 /*normal*/,*aHPETEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GET_HPETENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aHPETEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GET_HPETENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aHPETEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHPETEnabled=%RTbool hrc=%Rhrc\n", this, "PlatformX86::getHPETEnabled", *aHPETEnabled, hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::COMSETTER(HPETEnabled)(BOOL aHPETEnabled)
{
    LogRelFlow(("{%p} %s: enter aHPETEnabled=%RTbool\n", this, "PlatformX86::setHPETEnabled", aHPETEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SET_HPETENABLED_ENTER(this, aHPETEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHPETEnabled(aHPETEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SET_HPETENABLED_RETURN(this, hrc, 0 /*normal*/,aHPETEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SET_HPETENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aHPETEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SET_HPETENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aHPETEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::setHPETEnabled", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute1IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute2IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute3IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute4IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute5IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute6IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute7IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute8IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute9IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute10IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute11IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute12IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute13IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute14IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute15IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::COMGETTER(InternalAndReservedAttribute16IPlatformX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPlatformX86 methods
//

STDMETHODIMP PlatformX86Wrap::GetCPUProperty(CPUPropertyTypeX86_T aProperty,
                                             BOOL *aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%p\n", this, "PlatformX86::getCPUProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUPROPERTY_ENTER(this, aProperty);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUProperty(aProperty,
                                 aValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, *aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%RTbool hrc=%Rhrc\n", this, "PlatformX86::getCPUProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::SetCPUProperty(CPUPropertyTypeX86_T aProperty,
                                             BOOL aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%RTbool\n", this, "PlatformX86::setCPUProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUPROPERTY_ENTER(this, aProperty, aValue != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUProperty(aProperty,
                                 aValue != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::setCPUProperty", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::GetCPUIDLeafByOrdinal(ULONG aOrdinal,
                                                    ULONG *aIdx,
                                                    ULONG *aIdxSub,
                                                    ULONG *aValEax,
                                                    ULONG *aValEbx,
                                                    ULONG *aValEcx,
                                                    ULONG *aValEdx)
{
    LogRelFlow(("{%p} %s: enter aOrdinal=%RU32 aIdx=%p aIdxSub=%p aValEax=%p aValEbx=%p aValEcx=%p aValEdx=%p\n", this, "PlatformX86::getCPUIDLeafByOrdinal", aOrdinal, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIdx);
        CheckComArgOutPointerValidThrow(aIdxSub);
        CheckComArgOutPointerValidThrow(aValEax);
        CheckComArgOutPointerValidThrow(aValEbx);
        CheckComArgOutPointerValidThrow(aValEcx);
        CheckComArgOutPointerValidThrow(aValEdx);


        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAFBYORDINAL_ENTER(this, aOrdinal);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUIDLeafByOrdinal(aOrdinal,
                                        aIdx,
                                        aIdxSub,
                                        aValEax,
                                        aValEbx,
                                        aValEcx,
                                        aValEdx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAFBYORDINAL_RETURN(this, hrc, 0 /*normal*/, aOrdinal, *aIdx, *aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAFBYORDINAL_RETURN(this, hrc, 1 /*hrc exception*/, aOrdinal, *aIdx, *aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAFBYORDINAL_RETURN(this, hrc, 9 /*unhandled exception*/, aOrdinal, *aIdx, *aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIdx=%RU32 *aIdxSub=%RU32 *aValEax=%RU32 *aValEbx=%RU32 *aValEcx=%RU32 *aValEdx=%RU32 hrc=%Rhrc\n", this, "PlatformX86::getCPUIDLeafByOrdinal", *aIdx, *aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx, hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::GetCPUIDLeaf(ULONG aIdx,
                                           ULONG aIdxSub,
                                           ULONG *aValEax,
                                           ULONG *aValEbx,
                                           ULONG *aValEcx,
                                           ULONG *aValEdx)
{
    LogRelFlow(("{%p} %s: enter aIdx=%RU32 aIdxSub=%RU32 aValEax=%p aValEbx=%p aValEcx=%p aValEdx=%p\n", this, "PlatformX86::getCPUIDLeaf", aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValEax);
        CheckComArgOutPointerValidThrow(aValEbx);
        CheckComArgOutPointerValidThrow(aValEcx);
        CheckComArgOutPointerValidThrow(aValEdx);


        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAF_ENTER(this, aIdx, aIdxSub);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUIDLeaf(aIdx,
                               aIdxSub,
                               aValEax,
                               aValEbx,
                               aValEcx,
                               aValEdx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAF_RETURN(this, hrc, 0 /*normal*/, aIdx, aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAF_RETURN(this, hrc, 1 /*hrc exception*/, aIdx, aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETCPUIDLEAF_RETURN(this, hrc, 9 /*unhandled exception*/, aIdx, aIdxSub, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValEax=%RU32 *aValEbx=%RU32 *aValEcx=%RU32 *aValEdx=%RU32 hrc=%Rhrc\n", this, "PlatformX86::getCPUIDLeaf", *aValEax, *aValEbx, *aValEcx, *aValEdx, hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::SetCPUIDLeaf(ULONG aIdx,
                                           ULONG aIdxSub,
                                           ULONG aValEax,
                                           ULONG aValEbx,
                                           ULONG aValEcx,
                                           ULONG aValEdx)
{
    LogRelFlow(("{%p} %s: enter aIdx=%RU32 aIdxSub=%RU32 aValEax=%RU32 aValEbx=%RU32 aValEcx=%RU32 aValEdx=%RU32\n", this, "PlatformX86::setCPUIDLeaf", aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUIDLEAF_ENTER(this, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCPUIDLeaf(aIdx,
                               aIdxSub,
                               aValEax,
                               aValEbx,
                               aValEcx,
                               aValEdx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUIDLEAF_RETURN(this, hrc, 0 /*normal*/, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUIDLEAF_RETURN(this, hrc, 1 /*hrc exception*/, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETCPUIDLEAF_RETURN(this, hrc, 9 /*unhandled exception*/, aIdx, aIdxSub, aValEax, aValEbx, aValEcx, aValEdx);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::setCPUIDLeaf", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::RemoveCPUIDLeaf(ULONG aIdx,
                                              ULONG aIdxSub)
{
    LogRelFlow(("{%p} %s: enter aIdx=%RU32 aIdxSub=%RU32\n", this, "PlatformX86::removeCPUIDLeaf", aIdx, aIdxSub));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVECPUIDLEAF_ENTER(this, aIdx, aIdxSub);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeCPUIDLeaf(aIdx,
                                  aIdxSub);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVECPUIDLEAF_RETURN(this, hrc, 0 /*normal*/, aIdx, aIdxSub);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVECPUIDLEAF_RETURN(this, hrc, 1 /*hrc exception*/, aIdx, aIdxSub);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVECPUIDLEAF_RETURN(this, hrc, 9 /*unhandled exception*/, aIdx, aIdxSub);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::removeCPUIDLeaf", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::RemoveAllCPUIDLeaves()
{
    LogRelFlow(("{%p} %s: enter\n", this, "PlatformX86::removeAllCPUIDLeaves"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVEALLCPUIDLEAVES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeAllCPUIDLeaves();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVEALLCPUIDLEAVES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVEALLCPUIDLEAVES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_REMOVEALLCPUIDLEAVES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::removeAllCPUIDLeaves", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::GetHWVirtExProperty(HWVirtExPropertyType_T aProperty,
                                                  BOOL *aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%p\n", this, "PlatformX86::getHWVirtExProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETHWVIRTEXPROPERTY_ENTER(this, aProperty);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHWVirtExProperty(aProperty,
                                      aValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETHWVIRTEXPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETHWVIRTEXPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, *aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_GETHWVIRTEXPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, *aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%RTbool hrc=%Rhrc\n", this, "PlatformX86::getHWVirtExProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::SetHWVirtExProperty(HWVirtExPropertyType_T aProperty,
                                                  BOOL aValue)
{
    LogRelFlow(("{%p} %s: enter aProperty=%RU32 aValue=%RTbool\n", this, "PlatformX86::setHWVirtExProperty", aProperty, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETHWVIRTEXPROPERTY_ENTER(this, aProperty, aValue != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHWVirtExProperty(aProperty,
                                      aValue != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETHWVIRTEXPROPERTY_RETURN(this, hrc, 0 /*normal*/, aProperty, aValue != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETHWVIRTEXPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, aProperty, aValue != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMX86_SETHWVIRTEXPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, aProperty, aValue != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformX86::setHWVirtExProperty", hrc));
    return hrc;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod1IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod2IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod3IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod4IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod5IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod6IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod7IPlatformX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformX86Wrap::InternalAndReservedMethod8IPlatformX86()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PlatformX86Wrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PlatformX86Wrap, IPlatformX86)
#endif // VBOX_WITH_XPCOM
