/** @file
 * VirtualBox API class wrapper code for IHostVideoInputDevice.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTVIDEOINPUTDEVICE

#include "HostVideoInputDeviceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostVideoInputDeviceWrap)

//
// IHostVideoInputDevice properties
//

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "HostVideoInputDevice::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "HostVideoInputDevice::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(Path)(BSTR *aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%p\n", this, "HostVideoInputDevice::getPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPath);
        BSTROutConverter TmpPath(aPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_PATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPath=%ls hrc=%Rhrc\n", this, "HostVideoInputDevice::getPath", *aPath, hrc));
    return hrc;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(Alias)(BSTR *aAlias)
{
    LogRelFlow(("{%p} %s: enter aAlias=%p\n", this, "HostVideoInputDevice::getAlias", aAlias));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAlias);
        BSTROutConverter TmpAlias(aAlias);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_ALIAS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAlias(TmpAlias.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_ALIAS_RETURN(this, hrc, 0 /*normal*/,TmpAlias.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_ALIAS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTVIDEOINPUTDEVICE_GET_ALIAS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAlias=%ls hrc=%Rhrc\n", this, "HostVideoInputDevice::getAlias", *aAlias, hrc));
    return hrc;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(InternalAndReservedAttribute1IHostVideoInputDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(InternalAndReservedAttribute2IHostVideoInputDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(InternalAndReservedAttribute3IHostVideoInputDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostVideoInputDeviceWrap::COMGETTER(InternalAndReservedAttribute4IHostVideoInputDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IHostVideoInputDevice methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostVideoInputDeviceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostVideoInputDeviceWrap, IHostVideoInputDevice)
#endif // VBOX_WITH_XPCOM
