#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.screenshot"), aligned (sizeof(void *) > 8 ? sizeof(void *) : 8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[961]; const double alignment; void * const ptr;}  screenshot_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\344\000\000\000\000\000\000\050\007\000\000\000"
  "\000\000\000\000\001\000\000\000\002\000\000\000\004\000\000\000"
  "\004\000\000\000\004\000\000\000\006\000\000\000\202\213\223\025"
  "\005\000\000\000\344\000\000\000\012\000\166\000\360\000\000\000"
  "\172\003\000\000\113\120\220\013\003\000\000\000\172\003\000\000"
  "\004\000\114\000\200\003\000\000\204\003\000\000\150\034\114\237"
  "\006\000\000\000\204\003\000\000\006\000\114\000\214\003\000\000"
  "\220\003\000\000\324\265\002\000\377\377\377\377\220\003\000\000"
  "\001\000\114\000\224\003\000\000\230\003\000\000\171\254\003\011"
  "\002\000\000\000\230\003\000\000\010\000\114\000\240\003\000\000"
  "\244\003\000\000\006\210\263\034\004\000\000\000\244\003\000\000"
  "\013\000\114\000\260\003\000\000\264\003\000\000\260\267\044\060"
  "\001\000\000\000\264\003\000\000\006\000\114\000\274\003\000\000"
  "\300\003\000\000\147\141\154\154\145\162\171\056\165\151\000\000"
  "\131\014\000\000\001\000\000\000\170\332\325\127\301\156\332\100"
  "\020\075\047\137\261\335\123\253\312\001\023\105\252\052\343\250"
  "\211\324\134\252\136\332\073\032\166\007\274\141\331\165\167\307"
  "\001\372\365\135\143\032\260\061\140\244\244\121\157\006\277\175"
  "\363\170\063\363\154\222\333\345\134\263\047\164\136\131\063\344"
  "\361\125\237\337\246\227\211\062\204\156\002\002\323\313\213\304"
  "\341\257\102\071\364\114\253\361\220\117\151\366\221\157\117\134"
  "\137\015\372\274\127\302\354\370\021\005\061\241\301\373\041\177"
  "\240\331\027\371\130\170\232\243\041\316\224\034\162\057\034\242"
  "\361\231\245\221\260\205\241\021\154\001\201\340\042\311\235\315"
  "\321\321\212\031\230\343\220\027\171\370\304\323\353\176\322\373"
  "\173\247\015\246\355\242\204\305\307\121\071\114\061\122\046\110"
  "\250\352\305\047\130\075\141\136\303\167\240\367\352\067\362\364"
  "\004\361\023\350\002\233\174\111\257\162\357\134\037\027\112\122"
  "\326\321\307\233\176\067\043\007\375\377\314\311\301\247\356\136"
  "\336\331\145\145\342\024\264\106\267\032\111\005\332\116\303\100"
  "\206\211\077\340\237\165\052\334\002\012\363\316\323\060\370\244"
  "\004\350\343\322\306\326\111\164\321\272\075\245\302\006\132\144"
  "\112\313\362\252\105\341\203\123\262\222\110\060\326\030\257\045"
  "\355\127\160\166\021\371\034\204\062\123\236\326\015\150\101\013"
  "\253\213\271\331\036\150\052\252\151\152\123\365\043\127\346\256"
  "\040\012\026\264\356\362\106\145\113\367\003\112\221\172\012\215"
  "\372\012\332\343\116\335\344\135\024\261\071\110\144\317\040\266"
  "\310\320\060\211\023\050\064\215\232\105\230\362\254\060\042\103"
  "\061\103\311\242\350\120\115\020\201\013\010\175\264\141\342\351"
  "\117\127\140\363\047\267\034\334\131\244\043\151\265\107\264\063"
  "\162\025\055\210\131\360\371\120\031\215\023\212\200\010\104\266"
  "\267\016\155\170\262\371\063\374\272\245\170\255\134\322\333\351"
  "\344\211\256\176\203\061\352\252\241\272\274\034\034\154\343\022"
  "\264\232\232\116\152\165\105\112\016\214\327\260\036\342\041\137"
  "\241\347\351\217\147\113\331\172\063\330\173\145\130\256\226\250"
  "\375\207\317\057\152\152\377\074\123\343\227\064\365\276\234\317"
  "\335\135\071\064\316\374\174\007\357\101\213\042\174\205\214\062"
  "\144\246\230\217\321\061\073\141\133\152\337\141\312\105\265\217"
  "\335\166\102\072\130\204\370\226\041\364\310\272\003\247\136\271"
  "\127\233\034\035\234\327\325\301\113\166\365\110\000\156\324\375"
  "\243\060\152\076\362\337\062\214\342\327\014\243\370\165\303\350"
  "\173\333\362\274\151\012\235\025\355\065\135\165\125\373\157\124"
  "\122\256\237\372\067\247\136\023\112\232\021\255\362\020\016\150"
  "\144\003\135\023\263\225\262\025\222\364\166\376\066\374\001\026"
  "\021\363\110\000\050\165\165\141\171\051\157\162\147\057\000\000"
  "\006\000\000\000\164\157\164\145\155\057\000\000\004\000\000\000"
  "\057\000\000\000\001\000\000\000\160\154\165\147\151\156\163\057"
  "\005\000\000\000\163\143\162\145\145\156\163\150\157\164\057\000"
  "\000\000\000\000\147\156\157\155\145\057\000\000\002\000\000\000"
  "" };

static GStaticResource static_resource = { screenshot_resource_data.data, sizeof (screenshot_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_MODULE_EXPORT
GResource *screenshot_get_resource (void);
GResource *screenshot_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER)

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(screenshotresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(screenshotresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(screenshotresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(screenshotresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void screenshotresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void screenshotresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
