const char title_lua[] =
"local ffi = require('ffi')\n"
"ffi.cdef[[\n"
"    void title_update();\n"
"    const char *title_get();\n"
"    void title_set_interpretor_name(const char *);\n"
"    const char *title_get_interpretor_name();\n"
"    void title_set_script_name(const char *);\n"
"    const char *title_get_script_name();\n"
"    void title_set_custom(const char *);\n"
"    const char *title_get_custom();\n"
"    void title_set_status(const char *);\n"
"    const char *title_get_status();\n"
"]]\n"
"\n"
"local title = {}\n"
"\n"
"function title.update(kv)\n"
"\tif type(kv) == 'string' then kv = {custom_title = kv} end\n"
"    if type(kv) ~= 'table' then return end\n"
"    if kv.interpretor_name ~= nil then\n"
"        ffi.C.title_set_interpretor_name(tostring(kv.interpretor_name))\n"
"    end\n"
"    if kv.script_name ~= nil then\n"
"        ffi.C.title_set_script_name(tostring(kv.script_name))\n"
"    end\n"
"    if kv.status ~= nil then\n"
"        ffi.C.title_set_status(tostring(kv.status))\n"
"    end\n"
"    if kv.custom_title ~= nil then\n"
"        ffi.C.title_set_custom(tostring(kv.custom_title))\n"
"    end\n"
"    if not kv.__defer_update then\n"
"        ffi.C.title_update()\n"
"    end\n"
"end\n"
"\n"
"function title.get()\n"
"\tlocal function S(s) return s~=nil and ffi.string(s) or nil end\n"
"    return S(ffi.C.title_get()), {\n"
"        interpretor_name = S(ffi.C.title_get_interpretor_name()),\n"
"        script_name = S(ffi.C.title_get_script_name()),\n"
"        status = S(ffi.C.title_get_status()),\n"
"        custom_title = S(ffi.C.title_get_custom())\n"
"    }\n"
"end\n"
"\n"
"return title\n"
""
;
