#ifndef _REAPER_PLUGIN_FUNCTIONS_H_
#define _REAPER_PLUGIN_FUNCTIONS_H_

// REAPER API functions
// Generated by REAPER v7.40

/*
*  Copyright 2006 and later, Cockos Incorporated
*
*  This software is provided 'as-is', without any express or implied
*  warranty.  In no event will the authors be held liable for any damages
*  arising from the use of this software.
*
*  Permission is granted to anyone to use this software for any purpose,
*  including commercial applications, and to alter it and redistribute it
*  freely, subject to the following restrictions:
*
*  1. The origin of this software must not be misrepresented; you must not
*     claim that you wrote the original software. If you use this software
*     in a product, an acknowledgment in the product documentation would be
*     appreciated but is not required.
*  2. Altered source versions must be plainly marked as such, and must not be
*     misrepresented as being the original software.
*  3. This notice may not be removed or altered from any source distribution.
*/

// Note: the C++ pure virtual interfaces used require the MSVC-compatible C++ ABI on Win32.  Sorry, mingw users.
//
// Reaper extensions: see http://www.cockos.com/reaper/sdk/plugin/plugin.php and reaper_plugin.h.
// The API functions in this header can be retrieved using reaper_plugin_info_t.GetFunc().
//
// VST plugins: see http://www.cockos.com/reaper/sdk/vst/vst_ext.php
// The API functions in this header can be retrieved using audioMasterCallback.
//
// Because the API is dynamic, callers should never assume a function exists.
// Check that a non-NULL function pointer was returned before using it (unless
// loaded functions are verified using REAPERAPI_LoadAPI(), see note below).

//   1) most source files should just #include "reaper_plugin_functions.h" as is.
//   2) one file should #define REAPERAPI_IMPLEMENT before including this file.
//   3) the plug-in should call REAPERAPI_LoadAPI(rec->GetFunc) from REAPER_PLUGIN_ENTRYPOINT
//      and check the return value for errors (REAPERAPI_LoadAPI will return 0 on success).

//   By default, all functions listed in this file are loaded. This means that an older version
//   of REAPER may not succeed in loading, and also it may bloat your plug-in. If you wish to only load
//   needed functions, #define REAPERAPI_MINIMAL and various #define REAPERAPI_WANT_<functionname> lines
//   before including this file. You must put these definitions where REAPERAPI_IMPLEMENT is defined
//   and you can optionally put them elsewhere (to detect needed REAPERAPI_WANT_xxx lines at compile-
//   time rather than link-time).
//   
#if !defined(_LICE_H) && !defined(REAPERAPI_NO_LICE)
typedef unsigned int LICE_pixel;
typedef unsigned char LICE_pixel_chan;
class LICE_IBitmap;
class LICE_IFont;
#endif

class WDL_VirtualWnd_BGCfg;
class AudioAccessor;
class joystick_device;

// easiest to include reaper_plugin.h before reaper_plugin_functions.h in your application code.
// if not, you may need to edit this path.
#ifndef _REAPER_PLUGIN_H_
#include "reaper_plugin.h"
#endif

#ifdef REAPERAPI_DEF
#undef REAPERAPI_DEF
#endif
#ifdef REAPERAPI_IMPLEMENT
  #define REAPERAPI_DEF
#else
  #define REAPERAPI_DEF extern
#endif

#ifndef REAPERAPI_FUNCNAME
  #define REAPERAPI_FUNCNAME(x) x
#endif


#if defined(REAPERAPI_WANT___mergesort) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// __mergesort
// __mergesort is a stable sorting function with an API similar to qsort().
// HOWEVER, it requires some temporary space, equal to the size of the data being sorted, so you can pass it as the last parameter,
// or NULL and it will allocate and free space internally.

  void (*REAPERAPI_FUNCNAME(__mergesort))(void* base, size_t nmemb, size_t size, int (*cmpfunc)(const void*,const void*), void* tmpspace);
#endif

#if defined(REAPERAPI_WANT_AddCustomizableMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddCustomizableMenu
// menuidstr is some unique identifying string (must be a persistent pointer)
// menuname is for main menus only (displayed in a menu bar somewhere), NULL otherwise
// kbdsecname is the name of the KbdSectionInfo registered by this plugin, or NULL for the main actions section

  bool (*REAPERAPI_FUNCNAME(AddCustomizableMenu))(const char* menuidstr, const char* menuname, const char* kbdsecname, bool addtomainmenu);
#endif

#if defined(REAPERAPI_WANT_AddExtensionsMainMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddExtensionsMainMenu
// Add an Extensions main menu, which the extension can populate/modify with plugin_register("hookcustommenu")

  bool (*REAPERAPI_FUNCNAME(AddExtensionsMainMenu))();
#endif

#if defined(REAPERAPI_WANT_AddMediaItemToTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddMediaItemToTrack
// creates a new media item.

  MediaItem* (*REAPERAPI_FUNCNAME(AddMediaItemToTrack))(MediaTrack* tr);
#endif

#if defined(REAPERAPI_WANT_AddProjectMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddProjectMarker
// Returns the index of the created marker/region, or -1 on failure. Supply wantidx>=0 if you want a particular index number, but you'll get a different index number a region and wantidx is already in use.

  int (*REAPERAPI_FUNCNAME(AddProjectMarker))(ReaProject* proj, bool isrgn, double pos, double rgnend, const char* name, int wantidx);
#endif

#if defined(REAPERAPI_WANT_AddProjectMarker2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddProjectMarker2
// Returns the index of the created marker/region, or -1 on failure. Supply wantidx>=0 if you want a particular index number, but you'll get a different index number a region and wantidx is already in use. color should be 0 (default color), or ColorToNative(r,g,b)|0x1000000

  int (*REAPERAPI_FUNCNAME(AddProjectMarker2))(ReaProject* proj, bool isrgn, double pos, double rgnend, const char* name, int wantidx, int color);
#endif

#if defined(REAPERAPI_WANT_AddRemoveReaScript) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddRemoveReaScript
// Add a ReaScript (return the new command ID, or 0 if failed) or remove a ReaScript (return >0 on success). Use commit==true when adding/removing a single script. When bulk adding/removing n scripts, you can optimize the n-1 first calls with commit==false and commit==true for the last call.

  int (*REAPERAPI_FUNCNAME(AddRemoveReaScript))(bool add, int sectionID, const char* scriptfn, bool commit);
#endif

#if defined(REAPERAPI_WANT_AddTakeToMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddTakeToMediaItem
// creates a new take in an item

  MediaItem_Take* (*REAPERAPI_FUNCNAME(AddTakeToMediaItem))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_AddTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AddTempoTimeSigMarker
// Deprecated. Use SetTempoTimeSigMarker with ptidx=-1.

  bool (*REAPERAPI_FUNCNAME(AddTempoTimeSigMarker))(ReaProject* proj, double timepos, double bpm, int timesig_num, int timesig_denom, bool lineartempochange);
#endif

#if defined(REAPERAPI_WANT_adjustZoom) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// adjustZoom
// forceset=0,doupd=true,centermode=-1 for default

  void (*REAPERAPI_FUNCNAME(adjustZoom))(double amt, int forceset, bool doupd, int centermode);
#endif

#if defined(REAPERAPI_WANT_AdvancePlaybackPosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AdvancePlaybackPosition
// Steps through audio blocks for project. opos is start of current block in seconds, *npos should be set to start of estimated next block, will be updated with new start. loopcnt should be set to GetPlayLoopCnt initially, will be updated if discontinuity. max_spls may be updated to shorter block length if discontinuity. sflags should be 0 initially and is the running state used internally. returns 1 if looped sel, 2 if looped project, 4 if loopendskip, 8 if smoothseek, 16 if fade audition (all during this block).  Typically called with code something like:
// 
//   int asflags = 0;
//   INT64 lc = GetPlayLoopCnt(proj, NULL);
//   double oldpos = GetPlayPosition2Ex(proj);
//   loop:
//     double nextpos = old_pos + len / srate;
//     int thislen = len;
//     int ret = AdvancePlaybackPosition(proj, old_pos, &nextpos, &lc, srate, &thislen, &asflags);
//     oldpos = nextpos;
//   goto loop
// 

  int (*REAPERAPI_FUNCNAME(AdvancePlaybackPosition))(ReaProject* proj, double opos, double* npos, WDL_INT64* loopcnt, double srate, int* max_spls, int* sflags);
#endif

#if defined(REAPERAPI_WANT_AnyTrackSolo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AnyTrackSolo

  bool (*REAPERAPI_FUNCNAME(AnyTrackSolo))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_APIExists) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// APIExists
// Returns true if function_name exists in the REAPER API

  bool (*REAPERAPI_FUNCNAME(APIExists))(const char* function_name);
#endif

#if defined(REAPERAPI_WANT_APITest) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// APITest
// Displays a message window if the API was successfully called.

  void (*REAPERAPI_FUNCNAME(APITest))();
#endif

#if defined(REAPERAPI_WANT_ApplyNudge) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ApplyNudge
// nudgeflag: &1=set to value (otherwise nudge by value), &2=snap
// nudgewhat: 0=position, 1=left trim, 2=left edge, 3=right edge, 4=contents, 5=duplicate, 6=edit cursor
// nudgeunit: 0=ms, 1=seconds, 2=grid, 3=256th notes, ..., 15=whole notes, 16=measures.beats (1.15 = 1 measure + 1.5 beats), 17=samples, 18=frames, 19=pixels, 20=item lengths, 21=item selections
// value: amount to nudge by, or value to set to
// reverse: in nudge mode, nudges left (otherwise ignored)
// copies: in nudge duplicate mode, number of copies (otherwise ignored)

  bool (*REAPERAPI_FUNCNAME(ApplyNudge))(ReaProject* project, int nudgeflag, int nudgewhat, int nudgeunits, double value, bool reverse, int copies);
#endif

#if defined(REAPERAPI_WANT_ArmCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ArmCommand
// arms a command (or disarms if 0 passed) in section sectionname (empty string for main)

  void (*REAPERAPI_FUNCNAME(ArmCommand))(int cmd, const char* sectionname);
#endif

#if defined(REAPERAPI_WANT_Audio_Init) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Audio_Init
// open all audio and MIDI devices, if not open

  void (*REAPERAPI_FUNCNAME(Audio_Init))();
#endif

#if defined(REAPERAPI_WANT_Audio_IsPreBuffer) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Audio_IsPreBuffer
// is in pre-buffer? threadsafe

  int (*REAPERAPI_FUNCNAME(Audio_IsPreBuffer))();
#endif

#if defined(REAPERAPI_WANT_Audio_IsRunning) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Audio_IsRunning
// is audio running at all? threadsafe

  int (*REAPERAPI_FUNCNAME(Audio_IsRunning))();
#endif

#if defined(REAPERAPI_WANT_Audio_Quit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Audio_Quit
// close all audio and MIDI devices, if open

  void (*REAPERAPI_FUNCNAME(Audio_Quit))();
#endif

#if defined(REAPERAPI_WANT_Audio_RegHardwareHook) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Audio_RegHardwareHook
// return >0 on success

  int (*REAPERAPI_FUNCNAME(Audio_RegHardwareHook))(bool isAdd, audio_hook_register_t* reg);
#endif

#if defined(REAPERAPI_WANT_AudioAccessorStateChanged) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AudioAccessorStateChanged
// Returns true if the underlying samples (track or media item take) have changed, but does not update the audio accessor, so the user can selectively call AudioAccessorValidateState only when needed. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, DestroyAudioAccessor, GetAudioAccessorEndTime, GetAudioAccessorSamples.

  bool (*REAPERAPI_FUNCNAME(AudioAccessorStateChanged))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_AudioAccessorUpdate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AudioAccessorUpdate
// Force the accessor to reload its state from the underlying track or media item take. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorEndTime, GetAudioAccessorSamples.

  void (*REAPERAPI_FUNCNAME(AudioAccessorUpdate))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_AudioAccessorValidateState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// AudioAccessorValidateState
// Validates the current state of the audio accessor -- must ONLY call this from the main thread. Returns true if the state changed.

  bool (*REAPERAPI_FUNCNAME(AudioAccessorValidateState))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_BypassFxAllTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// BypassFxAllTracks
// -1 = bypass all if not all bypassed,otherwise unbypass all

  void (*REAPERAPI_FUNCNAME(BypassFxAllTracks))(int bypass);
#endif

#if defined(REAPERAPI_WANT_CalcMediaSrcLoudness) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CalcMediaSrcLoudness
// Calculates loudness statistics of media via dry run render. Statistics will be displayed to the user; call GetSetProjectInfo_String("RENDER_STATS") to retrieve via API. Returns 1 if loudness was calculated successfully, -1 if user canceled the dry run render.

  int (*REAPERAPI_FUNCNAME(CalcMediaSrcLoudness))(PCM_source* mediasource);
#endif

#if defined(REAPERAPI_WANT_CalculateNormalization) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CalculateNormalization
// Calculate normalize adjustment for source media. normalizeTo: 0=LUFS-I, 1=RMS-I, 2=peak, 3=true peak, 4=LUFS-M max, 5=LUFS-S max. normalizeTarget: dBFS or LUFS value. normalizeStart, normalizeEnd: time bounds within source media for normalization calculation. If normalizationStart=0 and normalizationEnd=0, the full duration of the media will be used for the calculation.

  double (*REAPERAPI_FUNCNAME(CalculateNormalization))(PCM_source* source, int normalizeTo, double normalizeTarget, double normalizeStart, double normalizeEnd);
#endif

#if defined(REAPERAPI_WANT_CalculatePeaks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CalculatePeaks

  int (*REAPERAPI_FUNCNAME(CalculatePeaks))(PCM_source_transfer_t* srcBlock, PCM_source_peaktransfer_t* pksBlock);
#endif

#if defined(REAPERAPI_WANT_CalculatePeaksFloatSrcPtr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CalculatePeaksFloatSrcPtr
// NOTE: source samples field is a pointer to floats instead

  int (*REAPERAPI_FUNCNAME(CalculatePeaksFloatSrcPtr))(PCM_source_transfer_t* srcBlock, PCM_source_peaktransfer_t* pksBlock);
#endif

#if defined(REAPERAPI_WANT_ClearAllRecArmed) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ClearAllRecArmed

  void (*REAPERAPI_FUNCNAME(ClearAllRecArmed))();
#endif

#if defined(REAPERAPI_WANT_ClearConsole) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ClearConsole
// Clear the ReaScript console. See ShowConsoleMsg

  void (*REAPERAPI_FUNCNAME(ClearConsole))();
#endif

#if defined(REAPERAPI_WANT_ClearPeakCache) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ClearPeakCache
// resets the global peak caches

  void (*REAPERAPI_FUNCNAME(ClearPeakCache))();
#endif

#if defined(REAPERAPI_WANT_ColorFromNative) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ColorFromNative
// Extract RGB values from an OS dependent color. See ColorToNative.

  void (*REAPERAPI_FUNCNAME(ColorFromNative))(int col, int* rOut, int* gOut, int* bOut);
#endif

#if defined(REAPERAPI_WANT_ColorToNative) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ColorToNative
// Make an OS dependent color from RGB values (e.g. RGB() macro on Windows). r,g and b are in [0..255]. See ColorFromNative.

  int (*REAPERAPI_FUNCNAME(ColorToNative))(int r, int g, int b);
#endif

#if defined(REAPERAPI_WANT_CountActionShortcuts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountActionShortcuts
// Returns the number of shortcuts that exist for the given command ID.
// see GetActionShortcutDesc, DeleteActionShortcut, DoActionShortcutDialog.

  int (*REAPERAPI_FUNCNAME(CountActionShortcuts))(KbdSectionInfo* section, int cmdID);
#endif

#if defined(REAPERAPI_WANT_CountAutomationItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountAutomationItems
// Returns the number of automation items on this envelope. See GetSetAutomationItemInfo

  int (*REAPERAPI_FUNCNAME(CountAutomationItems))(TrackEnvelope* env);
#endif

#if defined(REAPERAPI_WANT_CountEnvelopePoints) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountEnvelopePoints
// Returns the number of points in the envelope. See CountEnvelopePointsEx.

  int (*REAPERAPI_FUNCNAME(CountEnvelopePoints))(TrackEnvelope* envelope);
#endif

#if defined(REAPERAPI_WANT_CountEnvelopePointsEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountEnvelopePointsEx
// Returns the number of points in the envelope.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See GetEnvelopePointEx, SetEnvelopePointEx, InsertEnvelopePointEx, DeleteEnvelopePointEx.

  int (*REAPERAPI_FUNCNAME(CountEnvelopePointsEx))(TrackEnvelope* envelope, int autoitem_idx);
#endif

#if defined(REAPERAPI_WANT_CountMediaItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountMediaItems
// count the number of items in the project (proj=0 for active project)

  int (*REAPERAPI_FUNCNAME(CountMediaItems))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_CountProjectMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountProjectMarkers
// num_markersOut and num_regionsOut may be NULL.

  int (*REAPERAPI_FUNCNAME(CountProjectMarkers))(ReaProject* proj, int* num_markersOut, int* num_regionsOut);
#endif

#if defined(REAPERAPI_WANT_CountSelectedMediaItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountSelectedMediaItems
// Discouraged, because GetSelectedMediaItem can be inefficient if media items are added, rearranged, or deleted in between calls. Instead see CountMediaItems, GetMediaItem, IsMediaItemSelected.

  int (*REAPERAPI_FUNCNAME(CountSelectedMediaItems))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_CountSelectedTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountSelectedTracks
// Count the number of selected tracks in the project (proj=0 for active project). This function ignores the master track, see CountSelectedTracks2.

  int (*REAPERAPI_FUNCNAME(CountSelectedTracks))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_CountSelectedTracks2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountSelectedTracks2
// Count the number of selected tracks in the project (proj=0 for active project).

  int (*REAPERAPI_FUNCNAME(CountSelectedTracks2))(ReaProject* proj, bool wantmaster);
#endif

#if defined(REAPERAPI_WANT_CountTakeEnvelopes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTakeEnvelopes
// See GetTakeEnvelope

  int (*REAPERAPI_FUNCNAME(CountTakeEnvelopes))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_CountTakes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTakes
// count the number of takes in the item

  int (*REAPERAPI_FUNCNAME(CountTakes))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_CountTCPFXParms) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTCPFXParms
// Count the number of FX parameter knobs displayed on the track control panel.

  int (*REAPERAPI_FUNCNAME(CountTCPFXParms))(ReaProject* project, MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_CountTempoTimeSigMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTempoTimeSigMarkers
// Count the number of tempo/time signature markers in the project. See GetTempoTimeSigMarker, SetTempoTimeSigMarker, AddTempoTimeSigMarker.

  int (*REAPERAPI_FUNCNAME(CountTempoTimeSigMarkers))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_CountTrackEnvelopes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTrackEnvelopes
// see GetTrackEnvelope

  int (*REAPERAPI_FUNCNAME(CountTrackEnvelopes))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_CountTrackMediaItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTrackMediaItems
// count the number of items in the track

  int (*REAPERAPI_FUNCNAME(CountTrackMediaItems))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_CountTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CountTracks
// count the number of tracks in the project (proj=0 for active project)

  int (*REAPERAPI_FUNCNAME(CountTracks))(ReaProject* projOptional);
#endif

#if defined(REAPERAPI_WANT_CreateLocalOscHandler) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateLocalOscHandler
// callback is a function pointer: void (*callback)(void* obj, const char* msg, int msglen), which handles OSC messages sent from REAPER. The function return is a local osc handler. See SendLocalOscMessage, DestroyOscHandler.

  void* (*REAPERAPI_FUNCNAME(CreateLocalOscHandler))(void* obj, void* callback);
#endif

#if defined(REAPERAPI_WANT_CreateMIDIInput) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateMIDIInput
// Can only reliably create midi access for devices not already opened in prefs/MIDI, suitable for control surfaces etc.

  midi_Input* (*REAPERAPI_FUNCNAME(CreateMIDIInput))(int dev);
#endif

#if defined(REAPERAPI_WANT_CreateMIDIOutput) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateMIDIOutput
// Can only reliably create midi access for devices not already opened in prefs/MIDI, suitable for control surfaces etc. If streamMode is set, msoffset100 points to a persistent variable that can change and reflects added delay to output in 100ths of a millisecond.

  midi_Output* (*REAPERAPI_FUNCNAME(CreateMIDIOutput))(int dev, bool streamMode, int* msoffset100);
#endif

#if defined(REAPERAPI_WANT_CreateNewMIDIItemInProj) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateNewMIDIItemInProj
// Create a new MIDI media item, containing no MIDI events. Time is in seconds unless qn is set.

  MediaItem* (*REAPERAPI_FUNCNAME(CreateNewMIDIItemInProj))(MediaTrack* track, double starttime, double endtime, const bool* qnInOptional);
#endif

#if defined(REAPERAPI_WANT_CreateTakeAudioAccessor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateTakeAudioAccessor
// Create an audio accessor object for this take. Must only call from the main thread. See CreateTrackAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorEndTime, GetAudioAccessorSamples.

  AudioAccessor* (*REAPERAPI_FUNCNAME(CreateTakeAudioAccessor))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_CreateTrackAudioAccessor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateTrackAudioAccessor
// Create an audio accessor object for this track. Must only call from the main thread. See CreateTakeAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorEndTime, GetAudioAccessorSamples.

  AudioAccessor* (*REAPERAPI_FUNCNAME(CreateTrackAudioAccessor))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_CreateTrackSend) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CreateTrackSend
// Create a send/receive (desttrInOptional!=NULL), or a hardware output (desttrInOptional==NULL) with default properties, return >=0 on success (== new send/receive index). See RemoveTrackSend, GetSetTrackSendInfo, GetTrackSendInfo_Value, SetTrackSendInfo_Value.

  int (*REAPERAPI_FUNCNAME(CreateTrackSend))(MediaTrack* tr, MediaTrack* desttrInOptional);
#endif

#if defined(REAPERAPI_WANT_CrossfadeEditor_OnCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CrossfadeEditor_OnCommand
// Run a command from the Crossfade Editor section of the actions list.

  void (*REAPERAPI_FUNCNAME(CrossfadeEditor_OnCommand))(int command);
#endif

#if defined(REAPERAPI_WANT_CrossfadeEditor_Show) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CrossfadeEditor_Show
// Show or hide the Crossfade Editor window

  void (*REAPERAPI_FUNCNAME(CrossfadeEditor_Show))(bool show);
#endif

#if defined(REAPERAPI_WANT_CSurf_FlushUndo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_FlushUndo
// call this to force flushing of the undo states after using CSurf_On*Change()

  void (*REAPERAPI_FUNCNAME(CSurf_FlushUndo))(bool force);
#endif

#if defined(REAPERAPI_WANT_CSurf_GetTouchState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_GetTouchState

  bool (*REAPERAPI_FUNCNAME(CSurf_GetTouchState))(MediaTrack* trackid, int isPan);
#endif

#if defined(REAPERAPI_WANT_CSurf_GoEnd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_GoEnd

  void (*REAPERAPI_FUNCNAME(CSurf_GoEnd))();
#endif

#if defined(REAPERAPI_WANT_CSurf_GoStart) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_GoStart

  void (*REAPERAPI_FUNCNAME(CSurf_GoStart))();
#endif

#if defined(REAPERAPI_WANT_CSurf_NumTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_NumTracks

  int (*REAPERAPI_FUNCNAME(CSurf_NumTracks))(bool mcpView);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnArrow) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnArrow

  void (*REAPERAPI_FUNCNAME(CSurf_OnArrow))(int whichdir, bool wantzoom);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnFwd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnFwd

  void (*REAPERAPI_FUNCNAME(CSurf_OnFwd))(int seekplay);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnFXChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnFXChange

  bool (*REAPERAPI_FUNCNAME(CSurf_OnFXChange))(MediaTrack* trackid, int en);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnInputMonitorChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnInputMonitorChange

  int (*REAPERAPI_FUNCNAME(CSurf_OnInputMonitorChange))(MediaTrack* trackid, int monitor);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnInputMonitorChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnInputMonitorChangeEx

  int (*REAPERAPI_FUNCNAME(CSurf_OnInputMonitorChangeEx))(MediaTrack* trackid, int monitor, bool allowgang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnMuteChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnMuteChange

  bool (*REAPERAPI_FUNCNAME(CSurf_OnMuteChange))(MediaTrack* trackid, int mute);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnMuteChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnMuteChangeEx

  bool (*REAPERAPI_FUNCNAME(CSurf_OnMuteChangeEx))(MediaTrack* trackid, int mute, bool allowgang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnOscControlMessage) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnOscControlMessage

  void (*REAPERAPI_FUNCNAME(CSurf_OnOscControlMessage))(const char* msg, const float* arg);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnOscControlMessage2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnOscControlMessage2

  void (*REAPERAPI_FUNCNAME(CSurf_OnOscControlMessage2))(const char* msg, const float* arg, const char* argstr);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnPanChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnPanChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnPanChange))(MediaTrack* trackid, double pan, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnPanChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnPanChangeEx

  double (*REAPERAPI_FUNCNAME(CSurf_OnPanChangeEx))(MediaTrack* trackid, double pan, bool relative, bool allowGang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnPause) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnPause

  void (*REAPERAPI_FUNCNAME(CSurf_OnPause))();
#endif

#if defined(REAPERAPI_WANT_CSurf_OnPlay) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnPlay

  void (*REAPERAPI_FUNCNAME(CSurf_OnPlay))();
#endif

#if defined(REAPERAPI_WANT_CSurf_OnPlayRateChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnPlayRateChange

  void (*REAPERAPI_FUNCNAME(CSurf_OnPlayRateChange))(double playrate);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRecArmChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRecArmChange

  bool (*REAPERAPI_FUNCNAME(CSurf_OnRecArmChange))(MediaTrack* trackid, int recarm);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRecArmChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRecArmChangeEx

  bool (*REAPERAPI_FUNCNAME(CSurf_OnRecArmChangeEx))(MediaTrack* trackid, int recarm, bool allowgang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRecord) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRecord

  void (*REAPERAPI_FUNCNAME(CSurf_OnRecord))();
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRecvPanChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRecvPanChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnRecvPanChange))(MediaTrack* trackid, int recv_index, double pan, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRecvVolumeChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRecvVolumeChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnRecvVolumeChange))(MediaTrack* trackid, int recv_index, double volume, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRew) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRew

  void (*REAPERAPI_FUNCNAME(CSurf_OnRew))(int seekplay);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnRewFwd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnRewFwd

  void (*REAPERAPI_FUNCNAME(CSurf_OnRewFwd))(int seekplay, int dir);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnScroll) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnScroll

  void (*REAPERAPI_FUNCNAME(CSurf_OnScroll))(int xdir, int ydir);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnSelectedChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnSelectedChange

  bool (*REAPERAPI_FUNCNAME(CSurf_OnSelectedChange))(MediaTrack* trackid, int selected);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnSendPanChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnSendPanChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnSendPanChange))(MediaTrack* trackid, int send_index, double pan, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnSendVolumeChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnSendVolumeChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnSendVolumeChange))(MediaTrack* trackid, int send_index, double volume, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnSoloChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnSoloChange

  bool (*REAPERAPI_FUNCNAME(CSurf_OnSoloChange))(MediaTrack* trackid, int solo);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnSoloChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnSoloChangeEx

  bool (*REAPERAPI_FUNCNAME(CSurf_OnSoloChangeEx))(MediaTrack* trackid, int solo, bool allowgang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnStop) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnStop

  void (*REAPERAPI_FUNCNAME(CSurf_OnStop))();
#endif

#if defined(REAPERAPI_WANT_CSurf_OnTempoChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnTempoChange

  void (*REAPERAPI_FUNCNAME(CSurf_OnTempoChange))(double bpm);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnTrackSelection) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnTrackSelection

  void (*REAPERAPI_FUNCNAME(CSurf_OnTrackSelection))(MediaTrack* trackid);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnVolumeChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnVolumeChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnVolumeChange))(MediaTrack* trackid, double volume, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnVolumeChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnVolumeChangeEx

  double (*REAPERAPI_FUNCNAME(CSurf_OnVolumeChangeEx))(MediaTrack* trackid, double volume, bool relative, bool allowGang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnWidthChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnWidthChange

  double (*REAPERAPI_FUNCNAME(CSurf_OnWidthChange))(MediaTrack* trackid, double width, bool relative);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnWidthChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnWidthChangeEx

  double (*REAPERAPI_FUNCNAME(CSurf_OnWidthChangeEx))(MediaTrack* trackid, double width, bool relative, bool allowGang);
#endif

#if defined(REAPERAPI_WANT_CSurf_OnZoom) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_OnZoom

  void (*REAPERAPI_FUNCNAME(CSurf_OnZoom))(int xdir, int ydir);
#endif

#if defined(REAPERAPI_WANT_CSurf_ResetAllCachedVolPanStates) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_ResetAllCachedVolPanStates

  void (*REAPERAPI_FUNCNAME(CSurf_ResetAllCachedVolPanStates))();
#endif

#if defined(REAPERAPI_WANT_CSurf_ScrubAmt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_ScrubAmt

  void (*REAPERAPI_FUNCNAME(CSurf_ScrubAmt))(double amt);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetAutoMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetAutoMode

  void (*REAPERAPI_FUNCNAME(CSurf_SetAutoMode))(int mode, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetPlayState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetPlayState

  void (*REAPERAPI_FUNCNAME(CSurf_SetPlayState))(bool play, bool pause, bool rec, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetRepeatState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetRepeatState

  void (*REAPERAPI_FUNCNAME(CSurf_SetRepeatState))(bool rep, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfaceMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfaceMute

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfaceMute))(MediaTrack* trackid, bool mute, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfacePan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfacePan

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfacePan))(MediaTrack* trackid, double pan, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfaceRecArm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfaceRecArm

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfaceRecArm))(MediaTrack* trackid, bool recarm, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfaceSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfaceSelected

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfaceSelected))(MediaTrack* trackid, bool selected, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfaceSolo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfaceSolo

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfaceSolo))(MediaTrack* trackid, bool solo, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetSurfaceVolume) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetSurfaceVolume

  void (*REAPERAPI_FUNCNAME(CSurf_SetSurfaceVolume))(MediaTrack* trackid, double volume, IReaperControlSurface* ignoresurf);
#endif

#if defined(REAPERAPI_WANT_CSurf_SetTrackListChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_SetTrackListChange

  void (*REAPERAPI_FUNCNAME(CSurf_SetTrackListChange))();
#endif

#if defined(REAPERAPI_WANT_CSurf_TrackFromID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_TrackFromID

  MediaTrack* (*REAPERAPI_FUNCNAME(CSurf_TrackFromID))(int idx, bool mcpView);
#endif

#if defined(REAPERAPI_WANT_CSurf_TrackToID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// CSurf_TrackToID

  int (*REAPERAPI_FUNCNAME(CSurf_TrackToID))(MediaTrack* track, bool mcpView);
#endif

#if defined(REAPERAPI_WANT_DB2SLIDER) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DB2SLIDER

  double (*REAPERAPI_FUNCNAME(DB2SLIDER))(double x);
#endif

#if defined(REAPERAPI_WANT_DeleteActionShortcut) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteActionShortcut
// Delete the specific shortcut for the given command ID.
// See CountActionShortcuts, GetActionShortcutDesc, DoActionShortcutDialog.

  bool (*REAPERAPI_FUNCNAME(DeleteActionShortcut))(KbdSectionInfo* section, int cmdID, int shortcutidx);
#endif

#if defined(REAPERAPI_WANT_DeleteEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteEnvelopePointEx
// Delete an envelope point. If setting multiple points at once, set noSort=true, and call Envelope_SortPoints when done.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See CountEnvelopePointsEx, GetEnvelopePointEx, SetEnvelopePointEx, InsertEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(DeleteEnvelopePointEx))(TrackEnvelope* envelope, int autoitem_idx, int ptidx);
#endif

#if defined(REAPERAPI_WANT_DeleteEnvelopePointRange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteEnvelopePointRange
// Delete a range of envelope points. See DeleteEnvelopePointRangeEx, DeleteEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(DeleteEnvelopePointRange))(TrackEnvelope* envelope, double time_start, double time_end);
#endif

#if defined(REAPERAPI_WANT_DeleteEnvelopePointRangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteEnvelopePointRangeEx
// Delete a range of envelope points. autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.

  bool (*REAPERAPI_FUNCNAME(DeleteEnvelopePointRangeEx))(TrackEnvelope* envelope, int autoitem_idx, double time_start, double time_end);
#endif

#if defined(REAPERAPI_WANT_DeleteExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteExtState
// Delete the extended state value for a specific section and key. persist=true means the value should remain deleted the next time REAPER is opened. See SetExtState, GetExtState, HasExtState.

  void (*REAPERAPI_FUNCNAME(DeleteExtState))(const char* section, const char* key, bool persist);
#endif

#if defined(REAPERAPI_WANT_DeleteProjectMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteProjectMarker
// Delete a marker.  proj==NULL for the active project.

  bool (*REAPERAPI_FUNCNAME(DeleteProjectMarker))(ReaProject* proj, int markrgnindexnumber, bool isrgn);
#endif

#if defined(REAPERAPI_WANT_DeleteProjectMarkerByIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteProjectMarkerByIndex
// Differs from DeleteProjectMarker only in that markrgnidx is 0 for the first marker/region, 1 for the next, etc (see EnumProjectMarkers3), rather than representing the displayed marker/region ID number (see SetProjectMarker4).

  bool (*REAPERAPI_FUNCNAME(DeleteProjectMarkerByIndex))(ReaProject* proj, int markrgnidx);
#endif

#if defined(REAPERAPI_WANT_DeleteTakeMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteTakeMarker
// Delete a take marker. Note that idx will change for all following take markers. See GetNumTakeMarkers, GetTakeMarker, SetTakeMarker

  bool (*REAPERAPI_FUNCNAME(DeleteTakeMarker))(MediaItem_Take* take, int idx);
#endif

#if defined(REAPERAPI_WANT_DeleteTakeStretchMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteTakeStretchMarkers
// Deletes one or more stretch markers. Returns number of stretch markers deleted.

  int (*REAPERAPI_FUNCNAME(DeleteTakeStretchMarkers))(MediaItem_Take* take, int idx, const int* countInOptional);
#endif

#if defined(REAPERAPI_WANT_DeleteTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteTempoTimeSigMarker
// Delete a tempo/time signature marker.

  bool (*REAPERAPI_FUNCNAME(DeleteTempoTimeSigMarker))(ReaProject* project, int markerindex);
#endif

#if defined(REAPERAPI_WANT_DeleteTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteTrack
// deletes a track

  void (*REAPERAPI_FUNCNAME(DeleteTrack))(MediaTrack* tr);
#endif

#if defined(REAPERAPI_WANT_DeleteTrackMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DeleteTrackMediaItem

  bool (*REAPERAPI_FUNCNAME(DeleteTrackMediaItem))(MediaTrack* tr, MediaItem* it);
#endif

#if defined(REAPERAPI_WANT_DestroyAudioAccessor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DestroyAudioAccessor
// Destroy an audio accessor. Must only call from the main thread. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorEndTime, GetAudioAccessorSamples. 

  void (*REAPERAPI_FUNCNAME(DestroyAudioAccessor))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_DestroyLocalOscHandler) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DestroyLocalOscHandler
// See CreateLocalOscHandler, SendLocalOscMessage.

  void (*REAPERAPI_FUNCNAME(DestroyLocalOscHandler))(void* local_osc_handler);
#endif

#if defined(REAPERAPI_WANT_DoActionShortcutDialog) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DoActionShortcutDialog
// Open the action shortcut dialog to edit or add a shortcut for the given command ID. If (shortcutidx >= 0 && shortcutidx < CountActionShortcuts()), that specific shortcut will be replaced, otherwise a new shortcut will be added.
// See CountActionShortcuts, GetActionShortcutDesc, DeleteActionShortcut.

  bool (*REAPERAPI_FUNCNAME(DoActionShortcutDialog))(HWND hwnd, KbdSectionInfo* section, int cmdID, int shortcutidx);
#endif

#if defined(REAPERAPI_WANT_Dock_UpdateDockID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Dock_UpdateDockID
// updates preference for docker window ident_str to be in dock whichDock on next open

  void (*REAPERAPI_FUNCNAME(Dock_UpdateDockID))(const char* ident_str, int whichDock);
#endif

#if defined(REAPERAPI_WANT_DockGetPosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockGetPosition
// -1=not found, 0=bottom, 1=left, 2=top, 3=right, 4=floating

  int (*REAPERAPI_FUNCNAME(DockGetPosition))(int whichDock);
#endif

#if defined(REAPERAPI_WANT_DockIsChildOfDock) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockIsChildOfDock
// returns dock index that contains hwnd, or -1

  int (*REAPERAPI_FUNCNAME(DockIsChildOfDock))(HWND hwnd, bool* isFloatingDockerOut);
#endif

#if defined(REAPERAPI_WANT_DockWindowActivate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowActivate

  void (*REAPERAPI_FUNCNAME(DockWindowActivate))(HWND hwnd);
#endif

#if defined(REAPERAPI_WANT_DockWindowAdd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowAdd

  void (*REAPERAPI_FUNCNAME(DockWindowAdd))(HWND hwnd, const char* name, int pos, bool allowShow);
#endif

#if defined(REAPERAPI_WANT_DockWindowAddEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowAddEx

  void (*REAPERAPI_FUNCNAME(DockWindowAddEx))(HWND hwnd, const char* name, const char* identstr, bool allowShow);
#endif

#if defined(REAPERAPI_WANT_DockWindowRefresh) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowRefresh

  void (*REAPERAPI_FUNCNAME(DockWindowRefresh))();
#endif

#if defined(REAPERAPI_WANT_DockWindowRefreshForHWND) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowRefreshForHWND

  void (*REAPERAPI_FUNCNAME(DockWindowRefreshForHWND))(HWND hwnd);
#endif

#if defined(REAPERAPI_WANT_DockWindowRemove) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DockWindowRemove

  void (*REAPERAPI_FUNCNAME(DockWindowRemove))(HWND hwnd);
#endif

#if defined(REAPERAPI_WANT_DuplicateCustomizableMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// DuplicateCustomizableMenu
// Populate destmenu with all the entries and submenus found in srcmenu

  bool (*REAPERAPI_FUNCNAME(DuplicateCustomizableMenu))(void* srcmenu, void* destmenu);
#endif

#if defined(REAPERAPI_WANT_EditTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EditTempoTimeSigMarker
// Open the tempo/time signature marker editor dialog.

  bool (*REAPERAPI_FUNCNAME(EditTempoTimeSigMarker))(ReaProject* project, int markerindex);
#endif

#if defined(REAPERAPI_WANT_EnsureNotCompletelyOffscreen) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnsureNotCompletelyOffscreen
// call with a saved window rect for your window and it'll correct any positioning info.

  void (*REAPERAPI_FUNCNAME(EnsureNotCompletelyOffscreen))(RECT* rInOut);
#endif

#if defined(REAPERAPI_WANT_EnumerateFiles) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumerateFiles
// List the files in the "path" directory. Returns NULL/nil when all files have been listed. Use fileindex = -1 to force re-read of directory (invalidate cache). See EnumerateSubdirectories

  const char* (*REAPERAPI_FUNCNAME(EnumerateFiles))(const char* path, int fileindex);
#endif

#if defined(REAPERAPI_WANT_EnumerateSubdirectories) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumerateSubdirectories
// List the subdirectories in the "path" directory. Use subdirindex = -1 to force re-read of directory (invalidate cache). Returns NULL/nil when all subdirectories have been listed. See EnumerateFiles

  const char* (*REAPERAPI_FUNCNAME(EnumerateSubdirectories))(const char* path, int subdirindex);
#endif

#if defined(REAPERAPI_WANT_EnumInstalledFX) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumInstalledFX
// Enumerates installed FX. Returns true if successful, sets nameOut and identOut to name and ident of FX at index.

  bool (*REAPERAPI_FUNCNAME(EnumInstalledFX))(int index, const char** nameOut, const char** identOut);
#endif

#if defined(REAPERAPI_WANT_EnumPitchShiftModes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumPitchShiftModes
// Start querying modes at 0, returns FALSE when no more modes possible, sets strOut to NULL if a mode is currently unsupported

  bool (*REAPERAPI_FUNCNAME(EnumPitchShiftModes))(int mode, const char** strOut);
#endif

#if defined(REAPERAPI_WANT_EnumPitchShiftSubModes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumPitchShiftSubModes
// Returns submode name, or NULL

  const char* (*REAPERAPI_FUNCNAME(EnumPitchShiftSubModes))(int mode, int submode);
#endif

#if defined(REAPERAPI_WANT_EnumProjectMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumProjectMarkers

  int (*REAPERAPI_FUNCNAME(EnumProjectMarkers))(int idx, bool* isrgnOut, double* posOut, double* rgnendOut, const char** nameOut, int* markrgnindexnumberOut);
#endif

#if defined(REAPERAPI_WANT_EnumProjectMarkers2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumProjectMarkers2

  int (*REAPERAPI_FUNCNAME(EnumProjectMarkers2))(ReaProject* proj, int idx, bool* isrgnOut, double* posOut, double* rgnendOut, const char** nameOut, int* markrgnindexnumberOut);
#endif

#if defined(REAPERAPI_WANT_EnumProjectMarkers3) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumProjectMarkers3

  int (*REAPERAPI_FUNCNAME(EnumProjectMarkers3))(ReaProject* proj, int idx, bool* isrgnOut, double* posOut, double* rgnendOut, const char** nameOut, int* markrgnindexnumberOut, int* colorOut);
#endif

#if defined(REAPERAPI_WANT_EnumProjects) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumProjects
// idx=-1 for current project,projfn can be NULL if not interested in filename. use idx 0x40000000 for currently rendering project, if any.

  ReaProject* (*REAPERAPI_FUNCNAME(EnumProjects))(int idx, char* projfnOutOptional, int projfnOutOptional_sz);
#endif

#if defined(REAPERAPI_WANT_EnumProjExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumProjExtState
// Enumerate the data stored with the project for a specific extname. Returns false when there is no more data. See SetProjExtState, GetProjExtState.

  bool (*REAPERAPI_FUNCNAME(EnumProjExtState))(ReaProject* proj, const char* extname, int idx, char* keyOutOptional, int keyOutOptional_sz, char* valOutOptional, int valOutOptional_sz);
#endif

#if defined(REAPERAPI_WANT_EnumRegionRenderMatrix) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumRegionRenderMatrix
// Enumerate which tracks will be rendered within this region when using the region render matrix. When called with rendertrack==0, the function returns the first track that will be rendered (which may be the master track); rendertrack==1 will return the next track rendered, and so on. The function returns NULL when there are no more tracks that will be rendered within this region.

  MediaTrack* (*REAPERAPI_FUNCNAME(EnumRegionRenderMatrix))(ReaProject* proj, int regionindex, int rendertrack);
#endif

#if defined(REAPERAPI_WANT_EnumTrackMIDIProgramNames) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumTrackMIDIProgramNames
// returns false if there are no plugins on the track that support MIDI programs,or if all programs have been enumerated

  bool (*REAPERAPI_FUNCNAME(EnumTrackMIDIProgramNames))(int track, int programNumber, char* programName, int programName_sz);
#endif

#if defined(REAPERAPI_WANT_EnumTrackMIDIProgramNamesEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// EnumTrackMIDIProgramNamesEx
// returns false if there are no plugins on the track that support MIDI programs,or if all programs have been enumerated

  bool (*REAPERAPI_FUNCNAME(EnumTrackMIDIProgramNamesEx))(ReaProject* proj, MediaTrack* track, int programNumber, char* programName, int programName_sz);
#endif

#if defined(REAPERAPI_WANT_Envelope_Evaluate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_Evaluate
// Get the effective envelope value at a given time position. samplesRequested is how long the caller expects until the next call to Envelope_Evaluate (often, the buffer block size). The return value is how many samples beyond that time position that the returned values are valid. dVdS is the change in value per sample (first derivative), ddVdS is the second derivative, dddVdS is the third derivative. See GetEnvelopeScalingMode.

  int (*REAPERAPI_FUNCNAME(Envelope_Evaluate))(TrackEnvelope* envelope, double time, double samplerate, int samplesRequested, double* valueOut, double* dVdSOut, double* ddVdSOut, double* dddVdSOut);
#endif

#if defined(REAPERAPI_WANT_Envelope_FormatValue) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_FormatValue
// Formats the value of an envelope to a user-readable form

  void (*REAPERAPI_FUNCNAME(Envelope_FormatValue))(TrackEnvelope* env, double value, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_Envelope_GetParentTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_GetParentTake
// If take envelope, gets the take from the envelope. If FX, indexOut set to FX index, index2Out set to parameter index, otherwise -1.

  MediaItem_Take* (*REAPERAPI_FUNCNAME(Envelope_GetParentTake))(TrackEnvelope* env, int* indexOut, int* index2Out);
#endif

#if defined(REAPERAPI_WANT_Envelope_GetParentTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_GetParentTrack
// If track envelope, gets the track from the envelope. If FX, indexOut set to FX index, index2Out set to parameter index, otherwise -1.

  MediaTrack* (*REAPERAPI_FUNCNAME(Envelope_GetParentTrack))(TrackEnvelope* env, int* indexOut, int* index2Out);
#endif

#if defined(REAPERAPI_WANT_Envelope_SortPoints) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_SortPoints
// Sort envelope points by time. See SetEnvelopePoint, InsertEnvelopePoint.

  bool (*REAPERAPI_FUNCNAME(Envelope_SortPoints))(TrackEnvelope* envelope);
#endif

#if defined(REAPERAPI_WANT_Envelope_SortPointsEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Envelope_SortPointsEx
// Sort envelope points by time. autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc. See SetEnvelopePoint, InsertEnvelopePoint.

  bool (*REAPERAPI_FUNCNAME(Envelope_SortPointsEx))(TrackEnvelope* envelope, int autoitem_idx);
#endif

#if defined(REAPERAPI_WANT_ExecProcess) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ExecProcess
// Executes command line, returns NULL on total failure, otherwise the return value, a newline, and then the output of the command. If timeoutmsec is 0, command will be allowed to run indefinitely (recommended for large amounts of returned output). timeoutmsec is -1 for no wait/terminate, -2 for no wait and minimize

  const char* (*REAPERAPI_FUNCNAME(ExecProcess))(const char* cmdline, int timeoutmsec);
#endif

#if defined(REAPERAPI_WANT_file_exists) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// file_exists
// returns true if path points to a valid, readable file

  bool (*REAPERAPI_FUNCNAME(file_exists))(const char* path);
#endif

#if defined(REAPERAPI_WANT_FindTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// FindTempoTimeSigMarker
// Find the tempo/time signature marker that falls at or before this time position (the marker that is in effect as of this time position).

  int (*REAPERAPI_FUNCNAME(FindTempoTimeSigMarker))(ReaProject* project, double time);
#endif

#if defined(REAPERAPI_WANT_format_timestr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// format_timestr
// Format tpos (which is time in seconds) as hh:mm:ss.sss. See format_timestr_pos, format_timestr_len.

  void (*REAPERAPI_FUNCNAME(format_timestr))(double tpos, char* buf, int buf_sz);
#endif

#if defined(REAPERAPI_WANT_format_timestr_len) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// format_timestr_len
// time formatting mode overrides: -1=proj default.
// 0=time
// 1=measures.beats + time
// 2=measures.beats
// 3=seconds
// 4=samples
// 5=h:m:s:f
// offset is start of where the length will be calculated from

  void (*REAPERAPI_FUNCNAME(format_timestr_len))(double tpos, char* buf, int buf_sz, double offset, int modeoverride);
#endif

#if defined(REAPERAPI_WANT_format_timestr_pos) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// format_timestr_pos
// time formatting mode overrides: -1=proj default.
// 0=time
// 1=measures.beats + time
// 2=measures.beats
// 3=seconds
// 4=samples
// 5=h:m:s:f
// 

  void (*REAPERAPI_FUNCNAME(format_timestr_pos))(double tpos, char* buf, int buf_sz, int modeoverride);
#endif

#if defined(REAPERAPI_WANT_FreeHeapPtr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// FreeHeapPtr
// free heap memory returned from a Reaper API function

  void (*REAPERAPI_FUNCNAME(FreeHeapPtr))(void* ptr);
#endif

#if defined(REAPERAPI_WANT_genGuid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// genGuid

  void (*REAPERAPI_FUNCNAME(genGuid))(GUID* g);
#endif

#if defined(REAPERAPI_WANT_get_config_var) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// get_config_var
// gets ini configuration variable by name, raw, returns size of variable in szOut and pointer to variable. special values queryable are also:
//   __numcpu (int) cpu count.
//   __fx_loadstate_ctx (char): 0 if unknown, or during FX state loading: 'u' (instantiating via undo), 'U' (updating via undo), 'P' (loading preset). __langpack_filename can query langpack filename. If empty or <> then no langpack loaded; if relative pathname, then langpack is not yet loaded.

  void* (*REAPERAPI_FUNCNAME(get_config_var))(const char* name, int* szOut);
#endif

#if defined(REAPERAPI_WANT_get_config_var_string) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// get_config_var_string
// gets ini configuration variable value as string

  bool (*REAPERAPI_FUNCNAME(get_config_var_string))(const char* name, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_get_ini_file) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// get_ini_file
// Get reaper.ini full filename.

  const char* (*REAPERAPI_FUNCNAME(get_ini_file))();
#endif

#if defined(REAPERAPI_WANT_get_midi_config_var) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// get_midi_config_var
// Deprecated.

  void* (*REAPERAPI_FUNCNAME(get_midi_config_var))(const char* name, int* szOut);
#endif

#if defined(REAPERAPI_WANT_GetActionShortcutDesc) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetActionShortcutDesc
// Get the text description of a specific shortcut for the given command ID.
// See CountActionShortcuts,DeleteActionShortcut,DoActionShortcutDialog.

  bool (*REAPERAPI_FUNCNAME(GetActionShortcutDesc))(KbdSectionInfo* section, int cmdID, int shortcutidx, char* descOut, int descOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetActiveTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetActiveTake
// get the active take in this item

  MediaItem_Take* (*REAPERAPI_FUNCNAME(GetActiveTake))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetAllProjectPlayStates) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAllProjectPlayStates
// returns the bitwise OR of all project play states (1=playing, 2=pause, 4=recording)

  int (*REAPERAPI_FUNCNAME(GetAllProjectPlayStates))(ReaProject* ignoreProject);
#endif

#if defined(REAPERAPI_WANT_GetAppVersion) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAppVersion
// Returns app version which may include an OS/arch signifier, such as: "6.17" (windows 32-bit), "6.17/x64" (windows 64-bit), "6.17/OSX64" (macOS 64-bit Intel), "6.17/OSX" (macOS 32-bit), "6.17/macOS-arm64", "6.17/linux-x86_64", "6.17/linux-i686", "6.17/linux-aarch64", "6.17/linux-armv7l", etc

  const char* (*REAPERAPI_FUNCNAME(GetAppVersion))();
#endif

#if defined(REAPERAPI_WANT_GetArmedCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetArmedCommand
// gets the currently armed command and section name (returns 0 if nothing armed). section name is empty-string for main section.

  int (*REAPERAPI_FUNCNAME(GetArmedCommand))(char* secOut, int secOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetAudioAccessorEndTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAudioAccessorEndTime
// Get the end time of the audio that can be returned from this accessor. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorSamples.

  double (*REAPERAPI_FUNCNAME(GetAudioAccessorEndTime))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_GetAudioAccessorHash) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAudioAccessorHash
// Deprecated. See AudioAccessorStateChanged instead.

  void (*REAPERAPI_FUNCNAME(GetAudioAccessorHash))(AudioAccessor* accessor, char* hashNeed128);
#endif

#if defined(REAPERAPI_WANT_GetAudioAccessorSamples) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAudioAccessorSamples
// Get a block of samples from the audio accessor. Samples are extracted immediately pre-FX, and returned interleaved (first sample of first channel, first sample of second channel...). Returns 0 if no audio, 1 if audio, -1 on error. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorStartTime, GetAudioAccessorEndTime.// 
// 
// This function has special handling in Python, and only returns two objects, the API function return value, and the sample buffer. Example usage:
// 
// <code>tr = RPR_GetTrack(0, 0)
// aa = RPR_CreateTrackAudioAccessor(tr)
// buf = list([0]*2*1024) # 2 channels, 1024 samples each, initialized to zero
// pos = 0.0
// (ret, buf) = GetAudioAccessorSamples(aa, 44100, 2, pos, 1024, buf)
// # buf now holds the first 2*1024 audio samples from the track.
// # typically GetAudioAccessorSamples() would be called within a loop, increasing pos each time.
// </code>

  int (*REAPERAPI_FUNCNAME(GetAudioAccessorSamples))(AudioAccessor* accessor, int samplerate, int numchannels, double starttime_sec, int numsamplesperchannel, double* samplebuffer);
#endif

#if defined(REAPERAPI_WANT_GetAudioAccessorStartTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAudioAccessorStartTime
// Get the start time of the audio that can be returned from this accessor. See CreateTakeAudioAccessor, CreateTrackAudioAccessor, DestroyAudioAccessor, AudioAccessorStateChanged, GetAudioAccessorEndTime, GetAudioAccessorSamples.

  double (*REAPERAPI_FUNCNAME(GetAudioAccessorStartTime))(AudioAccessor* accessor);
#endif

#if defined(REAPERAPI_WANT_GetAudioDeviceInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetAudioDeviceInfo
// get information about the currently open audio device. attribute can be MODE, IDENT_IN, IDENT_OUT, BSIZE, SRATE, BPS. returns false if unknown attribute or device not open.

  bool (*REAPERAPI_FUNCNAME(GetAudioDeviceInfo))(const char* attribute, char* descOut, int descOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetColorTheme) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetColorTheme
// Deprecated, see GetColorThemeStruct.

  INT_PTR (*REAPERAPI_FUNCNAME(GetColorTheme))(int idx, int defval);
#endif

#if defined(REAPERAPI_WANT_GetColorThemeStruct) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetColorThemeStruct
// returns the whole color theme (icontheme.h) and the size

  void* (*REAPERAPI_FUNCNAME(GetColorThemeStruct))(int* szOut);
#endif

#if defined(REAPERAPI_WANT_GetConfigWantsDock) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetConfigWantsDock
// gets the dock ID desired by ident_str, if any

  int (*REAPERAPI_FUNCNAME(GetConfigWantsDock))(const char* ident_str);
#endif

#if defined(REAPERAPI_WANT_GetContextMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetContextMenu
// gets context menus. submenu 0:trackctl, 1:mediaitems, 2:ruler, 3:empty track area

  HMENU (*REAPERAPI_FUNCNAME(GetContextMenu))(int idx);
#endif

#if defined(REAPERAPI_WANT_GetCurrentProjectInLoadSave) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetCurrentProjectInLoadSave
// returns current project if in load/save (usually only used from project_config_extension_t)

  ReaProject* (*REAPERAPI_FUNCNAME(GetCurrentProjectInLoadSave))();
#endif

#if defined(REAPERAPI_WANT_GetCursorContext) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetCursorContext
// return the current cursor context: 0 if track panels, 1 if items, 2 if envelopes, otherwise unknown

  int (*REAPERAPI_FUNCNAME(GetCursorContext))();
#endif

#if defined(REAPERAPI_WANT_GetCursorContext2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetCursorContext2
// 0 if track panels, 1 if items, 2 if envelopes, otherwise unknown (unlikely when want_last_valid is true)

  int (*REAPERAPI_FUNCNAME(GetCursorContext2))(bool want_last_valid);
#endif

#if defined(REAPERAPI_WANT_GetCursorPosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetCursorPosition
// edit cursor position

  double (*REAPERAPI_FUNCNAME(GetCursorPosition))();
#endif

#if defined(REAPERAPI_WANT_GetCursorPositionEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetCursorPositionEx
// edit cursor position

  double (*REAPERAPI_FUNCNAME(GetCursorPositionEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetDisplayedMediaItemColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetDisplayedMediaItemColor
// see GetDisplayedMediaItemColor2.

  int (*REAPERAPI_FUNCNAME(GetDisplayedMediaItemColor))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetDisplayedMediaItemColor2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetDisplayedMediaItemColor2
// Returns the custom take, item, or track color that is used (according to the user preference) to color the media item. The returned color is OS dependent|0x01000000 (i.e. ColorToNative(r,g,b)|0x01000000), so a return of zero means "no color", not black.

  int (*REAPERAPI_FUNCNAME(GetDisplayedMediaItemColor2))(MediaItem* item, MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopeInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopeInfo_Value
// Gets an envelope numerical-value attribute:
// I_TCPY : int : Y offset of envelope relative to parent track (may be separate lane or overlap with track contents)
// I_TCPH : int : visible height of envelope
// I_TCPY_USED : int : Y offset of envelope relative to parent track, exclusive of padding
// I_TCPH_USED : int : visible height of envelope, exclusive of padding
// P_TRACK : MediaTrack * : parent track pointer (if any)
// P_DESTTRACK : MediaTrack * : destination track pointer, if on a send
// P_ITEM : MediaItem * : parent item pointer (if any)
// P_TAKE : MediaItem_Take * : parent take pointer (if any)
// I_SEND_IDX : int : 1-based index of send in P_TRACK, or 0 if not a send
// I_HWOUT_IDX : int : 1-based index of hardware output in P_TRACK or 0 if not a hardware output
// I_RECV_IDX : int : 1-based index of receive in P_DESTTRACK or 0 if not a send/receive
// 

  double (*REAPERAPI_FUNCNAME(GetEnvelopeInfo_Value))(TrackEnvelope* env, const char* parmname);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopeName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopeName

  bool (*REAPERAPI_FUNCNAME(GetEnvelopeName))(TrackEnvelope* env, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopePoint
// Get the attributes of an envelope point. See GetEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(GetEnvelopePoint))(TrackEnvelope* envelope, int ptidx, double* timeOut, double* valueOut, int* shapeOut, double* tensionOut, bool* selectedOut);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopePointByTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopePointByTime
// Returns the envelope point at or immediately prior to the given time position. See GetEnvelopePointByTimeEx.

  int (*REAPERAPI_FUNCNAME(GetEnvelopePointByTime))(TrackEnvelope* envelope, double time);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopePointByTimeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopePointByTimeEx
// Returns the envelope point at or immediately prior to the given time position.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See GetEnvelopePointEx, SetEnvelopePointEx, InsertEnvelopePointEx, DeleteEnvelopePointEx.

  int (*REAPERAPI_FUNCNAME(GetEnvelopePointByTimeEx))(TrackEnvelope* envelope, int autoitem_idx, double time);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopePointEx
// Get the attributes of an envelope point.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See CountEnvelopePointsEx, SetEnvelopePointEx, InsertEnvelopePointEx, DeleteEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(GetEnvelopePointEx))(TrackEnvelope* envelope, int autoitem_idx, int ptidx, double* timeOut, double* valueOut, int* shapeOut, double* tensionOut, bool* selectedOut);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopeScalingMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopeScalingMode
// Returns the envelope scaling mode: 0=no scaling, 1=fader scaling. All API functions deal with raw envelope point values, to convert raw from/to scaled values see ScaleFromEnvelopeMode, ScaleToEnvelopeMode.

  int (*REAPERAPI_FUNCNAME(GetEnvelopeScalingMode))(TrackEnvelope* env);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopeStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopeStateChunk
// Gets the RPPXML state of an envelope, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(GetEnvelopeStateChunk))(TrackEnvelope* env, char* strNeedBig, int strNeedBig_sz, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_GetEnvelopeUIState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetEnvelopeUIState
// gets information on the UI state of an envelope: returns &1 if automation/modulation is playing back, &2 if automation is being actively written, &4 if the envelope recently had an effective automation mode change

  int (*REAPERAPI_FUNCNAME(GetEnvelopeUIState))(TrackEnvelope* env);
#endif

#if defined(REAPERAPI_WANT_GetExePath) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetExePath
// returns path of REAPER.exe (not including EXE), i.e. C:\Program Files\REAPER

  const char* (*REAPERAPI_FUNCNAME(GetExePath))();
#endif

#if defined(REAPERAPI_WANT_GetExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetExtState
// Get the extended state value for a specific section and key. See SetExtState, DeleteExtState, HasExtState.

  const char* (*REAPERAPI_FUNCNAME(GetExtState))(const char* section, const char* key);
#endif

#if defined(REAPERAPI_WANT_GetFocusedFX) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetFocusedFX
// This function is deprecated (returns GetFocusedFX2()&3), see GetTouchedOrFocusedFX.

  int (*REAPERAPI_FUNCNAME(GetFocusedFX))(int* tracknumberOut, int* itemnumberOut, int* fxnumberOut);
#endif

#if defined(REAPERAPI_WANT_GetFocusedFX2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetFocusedFX2
// Return value has 1 set if track FX, 2 if take/item FX, 4 set if FX is no longer focused but still open. tracknumber==0 means the master track, 1 means track 1, etc. itemnumber is zero-based (or -1 if not an item). For interpretation of fxnumber, see GetLastTouchedFX. Deprecated, see GetTouchedOrFocusedFX

  int (*REAPERAPI_FUNCNAME(GetFocusedFX2))(int* tracknumberOut, int* itemnumberOut, int* fxnumberOut);
#endif

#if defined(REAPERAPI_WANT_GetFreeDiskSpaceForRecordPath) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetFreeDiskSpaceForRecordPath
// returns free disk space in megabytes, pathIdx 0 for normal, 1 for alternate.

  int (*REAPERAPI_FUNCNAME(GetFreeDiskSpaceForRecordPath))(ReaProject* proj, int pathidx);
#endif

#if defined(REAPERAPI_WANT_GetFXEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetFXEnvelope
// Returns the FX parameter envelope. If the envelope does not exist and create=true, the envelope will be created. If the envelope already exists and is bypassed and create=true, then the envelope will be unbypassed.

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetFXEnvelope))(MediaTrack* track, int fxindex, int parameterindex, bool create);
#endif

#if defined(REAPERAPI_WANT_GetGlobalAutomationOverride) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetGlobalAutomationOverride
// return -1=no override, 0=trim/read, 1=read, 2=touch, 3=write, 4=latch, 5=bypass

  int (*REAPERAPI_FUNCNAME(GetGlobalAutomationOverride))();
#endif

#if defined(REAPERAPI_WANT_GetHZoomLevel) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetHZoomLevel
// returns pixels/second

  double (*REAPERAPI_FUNCNAME(GetHZoomLevel))();
#endif

#if defined(REAPERAPI_WANT_GetIconThemePointer) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetIconThemePointer
// returns a named icontheme entry

  void* (*REAPERAPI_FUNCNAME(GetIconThemePointer))(const char* name);
#endif

#if defined(REAPERAPI_WANT_GetIconThemePointerForDPI) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetIconThemePointerForDPI
// returns a named icontheme entry for a given DPI-scaling (256=1:1). Note: the return value should not be stored, it should be queried at each paint! Querying name=NULL returns the start of the structure

  void* (*REAPERAPI_FUNCNAME(GetIconThemePointerForDPI))(const char* name, int dpisc);
#endif

#if defined(REAPERAPI_WANT_GetIconThemeStruct) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetIconThemeStruct
// returns a pointer to the icon theme (icontheme.h) and the size of that struct

  void* (*REAPERAPI_FUNCNAME(GetIconThemeStruct))(int* szOut);
#endif

#if defined(REAPERAPI_WANT_GetInputActivityLevel) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetInputActivityLevel
// returns approximate input level if available, 0-511 mono inputs, |1024 for stereo pairs, 4096+devidx*32 for MIDI devices

  double (*REAPERAPI_FUNCNAME(GetInputActivityLevel))(int input_id);
#endif

#if defined(REAPERAPI_WANT_GetInputChannelName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetInputChannelName

  const char* (*REAPERAPI_FUNCNAME(GetInputChannelName))(int channelIndex);
#endif

#if defined(REAPERAPI_WANT_GetInputOutputLatency) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetInputOutputLatency
// Gets the audio device input/output latency in samples

  void (*REAPERAPI_FUNCNAME(GetInputOutputLatency))(int* inputlatencyOut, int* outputLatencyOut);
#endif

#if defined(REAPERAPI_WANT_GetItemEditingTime2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetItemEditingTime2
// returns time of relevant edit, set which_item to the pcm_source (if applicable), flags (if specified) will be set to 1 for edge resizing, 2 for fade change, 4 for item move, 8 for item slip edit (edit cursor time or start of item)

  double (*REAPERAPI_FUNCNAME(GetItemEditingTime2))(PCM_source** which_itemOut, int* flagsOut);
#endif

#if defined(REAPERAPI_WANT_GetItemFromPoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetItemFromPoint
// Returns the first item at the screen coordinates specified. If allow_locked is false, locked items are ignored. If takeOutOptional specified, returns the take hit. See GetThingFromPoint.

  MediaItem* (*REAPERAPI_FUNCNAME(GetItemFromPoint))(int screen_x, int screen_y, bool allow_locked, MediaItem_Take** takeOutOptional);
#endif

#if defined(REAPERAPI_WANT_GetItemProjectContext) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetItemProjectContext

  ReaProject* (*REAPERAPI_FUNCNAME(GetItemProjectContext))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetItemStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetItemStateChunk
// Gets the RPPXML state of an item, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(GetItemStateChunk))(MediaItem* item, char* strNeedBig, int strNeedBig_sz, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_GetLastColorThemeFile) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetLastColorThemeFile

  const char* (*REAPERAPI_FUNCNAME(GetLastColorThemeFile))();
#endif

#if defined(REAPERAPI_WANT_GetLastMarkerAndCurRegion) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetLastMarkerAndCurRegion
// Get the last project marker before time, and/or the project region that includes time. markeridx and regionidx are returned not necessarily as the displayed marker/region index, but as the index that can be passed to EnumProjectMarkers. Either or both of markeridx and regionidx may be NULL. See EnumProjectMarkers.

  void (*REAPERAPI_FUNCNAME(GetLastMarkerAndCurRegion))(ReaProject* proj, double time, int* markeridxOut, int* regionidxOut);
#endif

#if defined(REAPERAPI_WANT_GetLastTouchedFX) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetLastTouchedFX
// Returns true if the last touched FX parameter is valid, false otherwise. The low word of tracknumber is the 1-based track index -- 0 means the master track, 1 means track 1, etc. If the high word of tracknumber is nonzero, it refers to the 1-based item index (1 is the first item on the track, etc). For track FX, the low 24 bits of fxnumber refer to the FX index in the chain, and if the next 8 bits are 01, then the FX is record FX. For item FX, the low word defines the FX index in the chain, and the high word defines the take number. Deprecated, see GetTouchedOrFocusedFX.

  bool (*REAPERAPI_FUNCNAME(GetLastTouchedFX))(int* tracknumberOut, int* fxnumberOut, int* paramnumberOut);
#endif

#if defined(REAPERAPI_WANT_GetLastTouchedTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetLastTouchedTrack

  MediaTrack* (*REAPERAPI_FUNCNAME(GetLastTouchedTrack))();
#endif

#if defined(REAPERAPI_WANT_GetMainHwnd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMainHwnd

  HWND (*REAPERAPI_FUNCNAME(GetMainHwnd))();
#endif

#if defined(REAPERAPI_WANT_GetMasterMuteSoloFlags) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMasterMuteSoloFlags
// &1=master mute,&2=master solo. This is deprecated as you can just query the master track as well.

  int (*REAPERAPI_FUNCNAME(GetMasterMuteSoloFlags))();
#endif

#if defined(REAPERAPI_WANT_GetMasterTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMasterTrack

  MediaTrack* (*REAPERAPI_FUNCNAME(GetMasterTrack))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetMasterTrackVisibility) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMasterTrackVisibility
// returns &1 if the master track is visible in the TCP, &2 if NOT visible in the mixer. See SetMasterTrackVisibility.

  int (*REAPERAPI_FUNCNAME(GetMasterTrackVisibility))();
#endif

#if defined(REAPERAPI_WANT_GetMaxMidiInputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMaxMidiInputs
// returns max dev for midi inputs/outputs

  int (*REAPERAPI_FUNCNAME(GetMaxMidiInputs))();
#endif

#if defined(REAPERAPI_WANT_GetMaxMidiOutputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMaxMidiOutputs

  int (*REAPERAPI_FUNCNAME(GetMaxMidiOutputs))();
#endif

#if defined(REAPERAPI_WANT_GetMediaFileMetadata) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaFileMetadata
// Get text-based metadata from a media file for a given identifier. Call with identifier="" to list all identifiers contained in the file, separated by newlines. May return "[Binary data]" for metadata that REAPER doesn't handle.

  int (*REAPERAPI_FUNCNAME(GetMediaFileMetadata))(PCM_source* mediaSource, const char* identifier, char* bufOutNeedBig, int bufOutNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_GetMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItem
// get an item from a project by item count (zero-based) (proj=0 for active project)

  MediaItem* (*REAPERAPI_FUNCNAME(GetMediaItem))(ReaProject* proj, int itemidx);
#endif

#if defined(REAPERAPI_WANT_GetMediaItem_Track) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItem_Track
// Get parent track of media item

  MediaTrack* (*REAPERAPI_FUNCNAME(GetMediaItem_Track))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemInfo_Value
// Get media item numerical-value attributes.
// B_MUTE : bool * : muted (item solo overrides). setting this value will clear C_MUTE_SOLO.
// B_MUTE_ACTUAL : bool * : muted (ignores solo). setting this value will not affect C_MUTE_SOLO.
// C_LANEPLAYS : char * : on fixed lane tracks, 0=this item lane does not play, 1=this item lane plays exclusively, 2=this item lane plays and other lanes also play, -1=this item is on a non-visible, non-playing lane on a formerly fixed-lane track (read-only)
// C_MUTE_SOLO : char * : solo override (-1=soloed, 0=no override, 1=unsoloed). note that this API does not automatically unsolo other items when soloing (nor clear the unsolos when clearing the last soloed item), it must be done by the caller via action or via this API.
// B_LOOPSRC : bool * : loop source
// B_ALLTAKESPLAY : bool * : all takes play
// B_UISEL : bool * : selected in arrange view
// C_BEATATTACHMODE : char * : item timebase, -1=track or project default, 1=beats (position, length, rate), 2=beats (position only). for auto-stretch timebase: C_BEATATTACHMODE=1, C_AUTOSTRETCH=1
// C_AUTOSTRETCH: : char * : auto-stretch at project tempo changes, 1=enabled, requires C_BEATATTACHMODE=1
// C_LOCK : char * : locked, &1=locked
// D_VOL : double * : item volume,  0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_POSITION : double * : item position in seconds
// D_LENGTH : double * : item length in seconds
// D_SNAPOFFSET : double * : item snap offset in seconds
// D_FADEINLEN : double * : item manual fadein length in seconds
// D_FADEOUTLEN : double * : item manual fadeout length in seconds
// D_FADEINDIR : double * : item fadein curvature, -1..1
// D_FADEOUTDIR : double * : item fadeout curvature, -1..1
// D_FADEINLEN_AUTO : double * : item auto-fadein length in seconds, -1=no auto-fadein
// D_FADEOUTLEN_AUTO : double * : item auto-fadeout length in seconds, -1=no auto-fadeout
// C_FADEINSHAPE : int * : fadein shape, 0..6, 0=linear
// C_FADEOUTSHAPE : int * : fadeout shape, 0..6, 0=linear
// I_GROUPID : int * : group ID, 0=no group
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_CURTAKE : int * : active take number
// IP_ITEMNUMBER : int : item number on this track (read-only, returns the item number directly)
// F_FREEMODE_Y : float * : free item positioning or fixed lane Y-position. 0=top of track, 1.0=bottom of track
// F_FREEMODE_H : float * : free item positioning or fixed lane height. 0.5=half the track height, 1.0=full track height
// I_FIXEDLANE : int * : fixed lane of item (fine to call with setNewValue, but returned value is read-only)
// B_FIXEDLANE_HIDDEN : bool * : true if displaying only one fixed lane and this item is in a different lane (read-only)
// P_TRACK : MediaTrack * : (read-only)
// 

  double (*REAPERAPI_FUNCNAME(GetMediaItemInfo_Value))(MediaItem* item, const char* parmname);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemNumTakes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemNumTakes

  int (*REAPERAPI_FUNCNAME(GetMediaItemNumTakes))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTake

  MediaItem_Take* (*REAPERAPI_FUNCNAME(GetMediaItemTake))(MediaItem* item, int tk);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTake_Item) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTake_Item
// Get parent item of media item take

  MediaItem* (*REAPERAPI_FUNCNAME(GetMediaItemTake_Item))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTake_Peaks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTake_Peaks
// Gets block of peak samples to buf. Note that the peak samples are interleaved, but in two or three blocks (maximums, then minimums, then extra). Return value has 20 bits of returned sample count, then 4 bits of output_mode (0xf00000), then a bit to signify whether extra_type was available (0x1000000). extra_type can be 115 ('s') for spectral information, which will return peak samples as integers with the low 15 bits frequency, next 14 bits tonality.

  int (*REAPERAPI_FUNCNAME(GetMediaItemTake_Peaks))(MediaItem_Take* take, double peakrate, double starttime, int numchannels, int numsamplesperchannel, int want_extra_type, double* buf);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTake_Source) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTake_Source
// Get media source of media item take

  PCM_source* (*REAPERAPI_FUNCNAME(GetMediaItemTake_Source))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTake_Track) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTake_Track
// Get parent track of media item take

  MediaTrack* (*REAPERAPI_FUNCNAME(GetMediaItemTake_Track))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTakeByGUID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTakeByGUID

  MediaItem_Take* (*REAPERAPI_FUNCNAME(GetMediaItemTakeByGUID))(ReaProject* project, const GUID* guid);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTakeInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTakeInfo_Value
// Get media item take numerical-value attributes.
// D_STARTOFFS : double * : start offset in source media, in seconds
// D_VOL : double * : take volume, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc, negative if take polarity is flipped
// D_PAN : double * : take pan, -1..1
// D_PANLAW : double * : take pan law, -1=default, 0.5=-6dB, 1.0=+0dB, etc
// D_PLAYRATE : double * : take playback rate, 0.5=half speed, 1=normal, 2=double speed, etc
// D_PITCH : double * : take pitch adjustment in semitones, -12=one octave down, 0=normal, +12=one octave up, etc
// B_PPITCH : bool * : preserve pitch when changing playback rate
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CHANMODE : int * : channel mode, 0=normal, 1=reverse stereo, 2=downmix, 3=left, 4=right
// I_PITCHMODE : int * : pitch shifter mode, -1=project default, otherwise high 2 bytes=shifter, low 2 bytes=parameter
// I_STRETCHFLAGS : int * : stretch marker flags (&7 mask for mode override: 0=default, 1=balanced, 2/3/6=tonal, 4=transient, 5=no pre-echo)
// F_STRETCHFADESIZE : float * : stretch marker fade size in seconds (0.0025 default)
// I_RECPASSID : int * : record pass ID
// I_TAKEFX_NCH : int * : number of internal audio channels for per-take FX to use (OK to call with setNewValue, but the returned value is read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// IP_SPECEDIT:CNT : int : spectral edit count (read-only)
// IP_SPECEDIT:DELETE:x : int : read or write this key to remove the spectral edit specified
// IP_SPECEDIT:ADD : int : read or write this key to add a new spectral edit (returns index)
// IP_SPECEDIT:SORT : int : read or write this key to re-sort spectral edits (be sure to do this following a position change or insert of new edit)
// I_SPECEDIT:FFT_SIZE : int * : FFT size used by spectral edits for this take
// D_SPECEDIT:x:POSITION : double * : position of spectral edit start (changing this requires a resort of spectral edits)
// D_SPECEDIT:x:LENGTH : double * : length of spectral edit
// F_SPECEDIT:x:GAIN : float * : gain of spectral edit
// F_SPECEDIT:x:FADE_IN : float * : fade-in size 0..1
// F_SPECEDIT:x:FADE_OUT : float * : fade-out size 0..1
// F_SPECEDIT:x:FADE_LOW : float * : fade-lf size 0..1
// F_SPECEDIT:x:FADE_HI : float * : fade-hf size 0..1
// I_SPECEDIT:x:CHAN : int * : channel index, -1 for omni
// I_SPECEDIT:x:FLAGS : int * : flags, &1=bypassed, &2=solo
// F_SPECEDIT:x:GATE_THRESH : float * : gate threshold
// F_SPECEDIT:x:GATE_FLOOR : float * : gate floor
// F_SPECEDIT:x:COMP_THRESH : float * : comp threshold
// F_SPECEDIT:x:COMP_RATIO : float * : comp ratio
// B_SPECEDIT:x:SELECTED : bool * : selection state
// I_SPECEDIT:x:TOPFREQ_CNT : int * : (read-only) number of top frequency-points
// I_SPECEDIT:x:TOPFREQ_ADD:pos:val : int * : reading or writing will insert top frequency-point with position/value pair, returns index
// I_SPECEDIT:x:TOPFREQ_DEL:y : int * : reading or writing will delete top frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:TOPFREQ_POS:y : float * : (read-only) get position of top frequency-point y
// F_SPECEDIT:x:TOPFREQ_FREQ:y : float * : (read-only) get frequency of top frequency-point y
// I_SPECEDIT:x:BOTFREQ_CNT : int * : number of bottom frequency-points
// I_SPECEDIT:x:BOTFREQ_ADD:pos:val : int * : reading or writing will insert bottom frequency-point with position/value pair, returns index
// I_SPECEDIT:x:BOTFREQ_DEL:y : int * : reading or writing will delete bottom frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:BOTFREQ_POS:y : float * : (read-only) get position of bottom frequency-point y
// F_SPECEDIT:x:BOTFREQ_FREQ:y : float * : (read-only) get frequency of bottom frequency-point y
// IP_TAKENUMBER : int : take number (read-only, returns the take number directly)
// P_TRACK : pointer to MediaTrack (read-only)
// P_ITEM : pointer to MediaItem (read-only)
// P_SOURCE : PCM_source *. Note that if setting this, you should first retrieve the old source, set the new, THEN delete the old.
// 

  double (*REAPERAPI_FUNCNAME(GetMediaItemTakeInfo_Value))(MediaItem_Take* take, const char* parmname);
#endif

#if defined(REAPERAPI_WANT_GetMediaItemTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaItemTrack

  MediaTrack* (*REAPERAPI_FUNCNAME(GetMediaItemTrack))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceFileName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceFileName
// Copies the media source filename to filenamebuf. Note that in-project MIDI media sources have no associated filename. See GetMediaSourceParent.

  void (*REAPERAPI_FUNCNAME(GetMediaSourceFileName))(PCM_source* source, char* filenamebufOut, int filenamebufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceLength) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceLength
// Returns the length of the source media. If the media source is beat-based, the length will be in quarter notes, otherwise it will be in seconds.

  double (*REAPERAPI_FUNCNAME(GetMediaSourceLength))(PCM_source* source, bool* lengthIsQNOut);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceNumChannels) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceNumChannels
// Returns the number of channels in the source media.

  int (*REAPERAPI_FUNCNAME(GetMediaSourceNumChannels))(PCM_source* source);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceParent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceParent
// Returns the parent source, or NULL if src is the root source. This can be used to retrieve the parent properties of sections or reversed sources for example.

  PCM_source* (*REAPERAPI_FUNCNAME(GetMediaSourceParent))(PCM_source* src);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceSampleRate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceSampleRate
// Returns the sample rate. MIDI source media will return zero.

  int (*REAPERAPI_FUNCNAME(GetMediaSourceSampleRate))(PCM_source* source);
#endif

#if defined(REAPERAPI_WANT_GetMediaSourceType) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaSourceType
// copies the media source type ("WAV", "MIDI", etc) to typebuf

  void (*REAPERAPI_FUNCNAME(GetMediaSourceType))(PCM_source* source, char* typebufOut, int typebufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetMediaTrackInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMediaTrackInfo_Value
// Get track numerical-value attributes.
// B_MUTE : bool * : muted
// B_PHASE : bool * : track phase inverted
// B_RECMON_IN_EFFECT : bool * : record monitoring in effect (current audio-thread playback state, read-only)
// IP_TRACKNUMBER : int : track number 1-based, 0=not found, -1=master track (read-only, returns the int directly)
// I_SOLO : int * : soloed, 0=not soloed, 1=soloed, 2=soloed in place, 5=safe soloed, 6=safe soloed in place
// B_SOLO_DEFEAT : bool * : when set, if anything else is soloed and this track is not muted, this track acts soloed
// I_FXEN : int * : fx enabled, 0=bypassed, !0=fx active
// I_RECARM : int * : record armed, 0=not record armed, 1=record armed
// I_RECINPUT : int * : record input, <0=no input. if 4096 set, input is MIDI and low 5 bits represent channel (0=all, 1-16=only chan), next 6 bits represent physical input (63=all, 62=VKB). If 4096 is not set, low 10 bits (0..1023) are input start channel (ReaRoute/Loopback start at 512). If 2048 is set, input is multichannel input (using track channel count), or if 1024 is set, input is stereo input, otherwise input is mono.
// I_RECMODE : int * : record mode, 0=input, 1=stereo out, 2=none, 3=stereo out w/latency compensation, 4=midi output, 5=mono out, 6=mono out w/ latency compensation, 7=midi overdub, 8=midi replace
// I_RECMODE_FLAGS : int * : record mode flags, &3=output recording mode (0=post fader, 1=pre-fx, 2=post-fx/pre-fader)
// I_RECMON : int * : record monitoring, 0=off, 1=normal, 2=not when playing (tape style)
// I_RECMONITEMS : int * : monitor items while recording, 0=off, 1=on
// B_AUTO_RECARM : bool * : automatically set record arm when selected (does not immediately affect recarm state, script should set directly if desired)
// I_VUMODE : int * : track vu mode, &1:disabled, &30==0:stereo peaks, &30==2:multichannel peaks, &30==4:stereo RMS, &30==8:combined RMS, &30==12:LUFS-M, &30==16:LUFS-S (readout=max), &30==20:LUFS-S (readout=current), &32:LUFS calculation on channels 1+2 only
// I_AUTOMODE : int * : track automation mode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch
// I_NCHAN : int * : number of track channels, 2-128, even numbers only
// I_SELECTED : int * : track selected, 0=unselected, 1=selected
// I_WNDH : int * : current TCP window height in pixels including envelopes (read-only)
// I_TCPH : int * : current TCP window height in pixels not including envelopes (read-only)
// I_TCPY : int * : current TCP window Y-position in pixels relative to top of arrange view (read-only)
// I_MCPX : int * : current MCP X-position in pixels relative to mixer container (read-only)
// I_MCPY : int * : current MCP Y-position in pixels relative to mixer container (read-only)
// I_MCPW : int * : current MCP width in pixels (read-only)
// I_MCPH : int * : current MCP height in pixels (read-only)
// I_FOLDERDEPTH : int * : folder depth change, 0=normal, 1=track is a folder parent, -1=track is the last in the innermost folder, -2=track is the last in the innermost and next-innermost folders, etc
// I_FOLDERCOMPACT : int * : folder collapsed state (only valid on folders), 0=normal, 1=collapsed, 2=fully collapsed
// I_MIDIHWOUT : int * : track midi hardware output index, <0=disabled, low 5 bits are which channels (0=all, 1-16), next 5 bits are output device index (0-31)
// I_MIDI_INPUT_CHANMAP : int * : -1 maps to source channel, otherwise 1-16 to map to MIDI channel
// I_MIDI_CTL_CHAN : int * : -1 no link, 0-15 link to MIDI volume/pan on channel, 16 link to MIDI volume/pan on all channels
// I_MIDI_TRACKSEL_FLAG : int * : MIDI editor track list options: &1=expand media items, &2=exclude from list, &4=auto-pruned
// I_PERFFLAGS : int * : track performance flags, &1=no media buffering, &2=no anticipative FX
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_HEIGHTOVERRIDE : int * : custom height override for TCP window, 0 for none, otherwise size in pixels
// I_SPACER : int * : 1=TCP track spacer above this trackB_HEIGHTLOCK : bool * : track height lock (must set I_HEIGHTOVERRIDE before locking)
// D_VOL : double * : trim volume of track, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_PAN : double * : trim pan of track, -1..1
// D_WIDTH : double * : width of track, -1..1
// D_DUALPANL : double * : dualpan position 1, -1..1, only if I_PANMODE==6
// D_DUALPANR : double * : dualpan position 2, -1..1, only if I_PANMODE==6
// I_PANMODE : int * : pan mode, 0=classic 3.x, 3=new balance, 5=stereo pan, 6=dual pan
// D_PANLAW : double * : pan law of track, <0=project default, 0.5=-6dB, 0.707..=-3dB, 1=+0dB, 1.414..=-3dB with gain compensation, 2=-6dB with gain compensation, etc
// I_PANLAW_FLAGS : int * : pan law flags, 0=sine taper, 1=hybrid taper with deprecated behavior when gain compensation enabled, 2=linear taper, 3=hybrid taper
// P_ENV:<envchunkname or P_ENV:{GUID... : TrackEnvelope * : (read-only) chunkname can be <VOLENV, <PANENV, etc; GUID is the stringified envelope GUID.
// B_SHOWINMIXER : bool * : track control panel visible in mixer (do not use on master track)
// B_SHOWINTCP : bool * : track control panel visible in arrange view (do not use on master track)
// B_MAINSEND : bool * : track sends audio to parent
// C_MAINSEND_OFFS : char * : channel offset of track send to parent
// C_MAINSEND_NCH : char * : channel count of track send to parent (0=use all child track channels, 1=use one channel only)
// I_FREEMODE : int * : 1=track free item positioning enabled, 2=track fixed lanes enabled (call UpdateTimeline() after changing)
// I_NUMFIXEDLANES : int * : number of track fixed lanes (fine to call with setNewValue, but returned value is read-only)
// C_LANESCOLLAPSED : char * : fixed lane collapse state (1=lanes collapsed, 2=track displays as non-fixed-lanes but hidden lanes exist)
// C_LANESETTINGS : char * : fixed lane settings (&1=auto-remove empty lanes at bottom, &2=do not auto-comp new recording, &4=newly recorded lanes play exclusively (else add lanes in layers), &8=big lanes (else small lanes), &16=add new recording at bottom (else record into first available lane), &32=hide lane buttons
// C_LANEPLAYS:N : char * :  on fixed lane tracks, 0=lane N does not play, 1=lane N plays exclusively, 2=lane N plays and other lanes also play (fine to call with setNewValue, but returned value is read-only)
// C_ALLLANESPLAY : char * : on fixed lane tracks, 0=no lanes play, 1=all lanes play, 2=some lanes play (fine to call with setNewValue 0 or 1, but returned value is read-only)
// C_BEATATTACHMODE : char * : track timebase, -1=project default, 0=time, 1=beats (position, length, rate), 2=beats (position only)
// F_MCP_FXSEND_SCALE : float * : scale of fx+send area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_FXPARM_SCALE : float * : scale of fx parameter area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_SENDRGN_SCALE : float * : scale of send area as proportion of the fx+send total area (0=minimum allowed, 1=maximum allowed)
// F_TCP_FXPARM_SCALE : float * : scale of TCP parameter area when TCP FX are embedded (0=min allowed, default, 1=max allowed)
// I_PLAY_OFFSET_FLAG : int * : track media playback offset state, &1=bypassed, &2=offset value is measured in samples (otherwise measured in seconds)
// D_PLAY_OFFSET : double * : track media playback offset, units depend on I_PLAY_OFFSET_FLAG
// P_PARTRACK : MediaTrack * : parent track (read-only)
// P_PROJECT : ReaProject * : parent project (read-only)
// 

  double (*REAPERAPI_FUNCNAME(GetMediaTrackInfo_Value))(MediaTrack* tr, const char* parmname);
#endif

#if defined(REAPERAPI_WANT_GetMIDIInputName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMIDIInputName
// returns true if device present

  bool (*REAPERAPI_FUNCNAME(GetMIDIInputName))(int dev, char* nameout, int nameout_sz);
#endif

#if defined(REAPERAPI_WANT_GetMIDIOutputName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMIDIOutputName
// returns true if device present

  bool (*REAPERAPI_FUNCNAME(GetMIDIOutputName))(int dev, char* nameout, int nameout_sz);
#endif

#if defined(REAPERAPI_WANT_GetMixerScroll) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMixerScroll
// Get the leftmost track visible in the mixer

  MediaTrack* (*REAPERAPI_FUNCNAME(GetMixerScroll))();
#endif

#if defined(REAPERAPI_WANT_GetMouseModifier) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMouseModifier
// Get the current mouse modifier assignment for a specific modifier key assignment, in a specific context.
// action will be filled in with the command ID number for a built-in mouse modifier
// or built-in REAPER command ID, or the custom action ID string.
// Note: the action string may have a space and 'c' or 'm' appended to it to specify command ID vs mouse modifier ID.
// See SetMouseModifier for more information.
// 

  void (*REAPERAPI_FUNCNAME(GetMouseModifier))(const char* context, int modifier_flag, char* actionOut, int actionOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetMousePosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetMousePosition
// get mouse position in screen coordinates

  void (*REAPERAPI_FUNCNAME(GetMousePosition))(int* xOut, int* yOut);
#endif

#if defined(REAPERAPI_WANT_GetNumAudioInputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumAudioInputs
// Return number of normal audio hardware inputs available

  int (*REAPERAPI_FUNCNAME(GetNumAudioInputs))();
#endif

#if defined(REAPERAPI_WANT_GetNumAudioOutputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumAudioOutputs
// Return number of normal audio hardware outputs available

  int (*REAPERAPI_FUNCNAME(GetNumAudioOutputs))();
#endif

#if defined(REAPERAPI_WANT_GetNumMIDIInputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumMIDIInputs
// returns max number of real midi hardware inputs

  int (*REAPERAPI_FUNCNAME(GetNumMIDIInputs))();
#endif

#if defined(REAPERAPI_WANT_GetNumMIDIOutputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumMIDIOutputs
// returns max number of real midi hardware outputs

  int (*REAPERAPI_FUNCNAME(GetNumMIDIOutputs))();
#endif

#if defined(REAPERAPI_WANT_GetNumTakeMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumTakeMarkers
// Returns number of take markers. See GetTakeMarker, SetTakeMarker, DeleteTakeMarker

  int (*REAPERAPI_FUNCNAME(GetNumTakeMarkers))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetNumTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetNumTracks
// Returns number of tracks in current project, see CountTracks()

  int (*REAPERAPI_FUNCNAME(GetNumTracks))();
#endif

#if defined(REAPERAPI_WANT_GetOS) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetOS
// Returns "Win32", "Win64", "OSX32", "OSX64", "macOS-arm64", or "Other".

  const char* (*REAPERAPI_FUNCNAME(GetOS))();
#endif

#if defined(REAPERAPI_WANT_GetOutputChannelName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetOutputChannelName

  const char* (*REAPERAPI_FUNCNAME(GetOutputChannelName))(int channelIndex);
#endif

#if defined(REAPERAPI_WANT_GetOutputLatency) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetOutputLatency
// returns output latency in seconds

  double (*REAPERAPI_FUNCNAME(GetOutputLatency))();
#endif

#if defined(REAPERAPI_WANT_GetParentTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetParentTrack

  MediaTrack* (*REAPERAPI_FUNCNAME(GetParentTrack))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_GetPeakFileName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPeakFileName
// get the peak file name for a given file (can be either filename.reapeaks,or a hashed filename in another path)

  void (*REAPERAPI_FUNCNAME(GetPeakFileName))(const char* fn, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetPeakFileNameEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPeakFileNameEx
// get the peak file name for a given file (can be either filename.reapeaks,or a hashed filename in another path)

  void (*REAPERAPI_FUNCNAME(GetPeakFileNameEx))(const char* fn, char* buf, int buf_sz, bool forWrite);
#endif

#if defined(REAPERAPI_WANT_GetPeakFileNameEx2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPeakFileNameEx2
// Like GetPeakFileNameEx, but you can specify peaksfileextension such as ".reapeaks"

  void (*REAPERAPI_FUNCNAME(GetPeakFileNameEx2))(const char* fn, char* buf, int buf_sz, bool forWrite, const char* peaksfileextension);
#endif

#if defined(REAPERAPI_WANT_GetPeaksBitmap) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPeaksBitmap
// see note in reaper_plugin.h about PCM_source_peaktransfer_t::samplerate

  void* (*REAPERAPI_FUNCNAME(GetPeaksBitmap))(PCM_source_peaktransfer_t* pks, double maxamp, int w, int h, LICE_IBitmap* bmp);
#endif

#if defined(REAPERAPI_WANT_GetPlayLoopCnt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayLoopCnt
// Queries the playback loopcnt for project. if render_skip_loopcnt is non-NULL, sets to either -1 or the loopcnt for a skipped render-pass (used during 2nd-pass rendering).

  WDL_INT64 (*REAPERAPI_FUNCNAME(GetPlayLoopCnt))(ReaProject* proj, WDL_INT64* render_skip_loopcnt);
#endif

#if defined(REAPERAPI_WANT_GetPlayPosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayPosition
// returns latency-compensated actual-what-you-hear position

  double (*REAPERAPI_FUNCNAME(GetPlayPosition))();
#endif

#if defined(REAPERAPI_WANT_GetPlayPosition2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayPosition2
// returns position of next audio block being processed

  double (*REAPERAPI_FUNCNAME(GetPlayPosition2))();
#endif

#if defined(REAPERAPI_WANT_GetPlayPosition2Ex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayPosition2Ex
// returns position of next audio block being processed

  double (*REAPERAPI_FUNCNAME(GetPlayPosition2Ex))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetPlayPositionEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayPositionEx
// returns latency-compensated actual-what-you-hear position

  double (*REAPERAPI_FUNCNAME(GetPlayPositionEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetPlayState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayState
// &1=playing, &2=paused, &4=is recording

  int (*REAPERAPI_FUNCNAME(GetPlayState))();
#endif

#if defined(REAPERAPI_WANT_GetPlayStateEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPlayStateEx
// &1=playing, &2=paused, &4=is recording

  int (*REAPERAPI_FUNCNAME(GetPlayStateEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetPreferredDiskReadMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPreferredDiskReadMode
// Gets user configured preferred disk read mode. mode/nb/bs are all parameters that should be passed to WDL_FileRead, see for more information.

  void (*REAPERAPI_FUNCNAME(GetPreferredDiskReadMode))(int* mode, int* nb, int* bs);
#endif

#if defined(REAPERAPI_WANT_GetPreferredDiskReadModePeak) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPreferredDiskReadModePeak
// Gets user configured preferred disk read mode for use when building peaks. mode/nb/bs are all parameters that should be passed to WDL_FileRead, see for more information.

  void (*REAPERAPI_FUNCNAME(GetPreferredDiskReadModePeak))(int* mode, int* nb, int* bs);
#endif

#if defined(REAPERAPI_WANT_GetPreferredDiskWriteMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetPreferredDiskWriteMode
// Gets user configured preferred disk write mode. nb will receive two values, the initial and maximum write buffer counts. mode/nb/bs are all parameters that should be passed to WDL_FileWrite, see for more information. 

  void (*REAPERAPI_FUNCNAME(GetPreferredDiskWriteMode))(int* mode, int* nb, int* bs);
#endif

#if defined(REAPERAPI_WANT_GetProjectLength) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectLength
// returns length of project (maximum of end of media item, markers, end of regions, tempo map

  double (*REAPERAPI_FUNCNAME(GetProjectLength))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetProjectName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectName

  void (*REAPERAPI_FUNCNAME(GetProjectName))(ReaProject* proj, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetProjectPath) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectPath
// Get the project recording path.

  void (*REAPERAPI_FUNCNAME(GetProjectPath))(char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetProjectPathEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectPathEx
// Get the project recording path.

  void (*REAPERAPI_FUNCNAME(GetProjectPathEx))(ReaProject* proj, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetProjectStateChangeCount) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectStateChangeCount
// returns an integer that changes when the project state changes

  int (*REAPERAPI_FUNCNAME(GetProjectStateChangeCount))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetProjectTimeOffset) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectTimeOffset
// Gets project time offset in seconds (project settings - project start time). If rndframe is true, the offset is rounded to a multiple of the project frame size.

  double (*REAPERAPI_FUNCNAME(GetProjectTimeOffset))(ReaProject* proj, bool rndframe);
#endif

#if defined(REAPERAPI_WANT_GetProjectTimeSignature) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectTimeSignature
// deprecated

  void (*REAPERAPI_FUNCNAME(GetProjectTimeSignature))(double* bpmOut, double* bpiOut);
#endif

#if defined(REAPERAPI_WANT_GetProjectTimeSignature2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjectTimeSignature2
// Gets basic time signature (beats per minute, numerator of time signature in bpi)
// this does not reflect tempo envelopes but is purely what is set in the project settings.

  void (*REAPERAPI_FUNCNAME(GetProjectTimeSignature2))(ReaProject* proj, double* bpmOut, double* bpiOut);
#endif

#if defined(REAPERAPI_WANT_GetProjExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetProjExtState
// Get the value previously associated with this extname and key, the last time the project was saved. See SetProjExtState, EnumProjExtState.

  int (*REAPERAPI_FUNCNAME(GetProjExtState))(ReaProject* proj, const char* extname, const char* key, char* valOutNeedBig, int valOutNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_GetResourcePath) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetResourcePath
// returns path where ini files are stored, other things are in subdirectories.

  const char* (*REAPERAPI_FUNCNAME(GetResourcePath))();
#endif

#if defined(REAPERAPI_WANT_GetSelectedEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSelectedEnvelope
// get the currently selected envelope, returns NULL/nil if no envelope is selected

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetSelectedEnvelope))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetSelectedMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSelectedMediaItem
// Discouraged, because GetSelectedMediaItem can be inefficient if media items are added, rearranged, or deleted in between calls. Instead see CountMediaItems, GetMediaItem, IsMediaItemSelected.

  MediaItem* (*REAPERAPI_FUNCNAME(GetSelectedMediaItem))(ReaProject* proj, int selitem);
#endif

#if defined(REAPERAPI_WANT_GetSelectedTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSelectedTrack
// Get a selected track from a project (proj=0 for active project) by selected track count (zero-based). This function ignores the master track, see GetSelectedTrack2.

  MediaTrack* (*REAPERAPI_FUNCNAME(GetSelectedTrack))(ReaProject* proj, int seltrackidx);
#endif

#if defined(REAPERAPI_WANT_GetSelectedTrack2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSelectedTrack2
// Get a selected track from a project (proj=0 for active project) by selected track count (zero-based).

  MediaTrack* (*REAPERAPI_FUNCNAME(GetSelectedTrack2))(ReaProject* proj, int seltrackidx, bool wantmaster);
#endif

#if defined(REAPERAPI_WANT_GetSelectedTrackEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSelectedTrackEnvelope
// get the currently selected track envelope, returns NULL/nil if no envelope is selected

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetSelectedTrackEnvelope))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_GetSet_ArrangeView2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSet_ArrangeView2
// Gets or sets the arrange view start/end time for screen coordinates. use screen_x_start=screen_x_end=0 to use the full arrange view's start/end time

  void (*REAPERAPI_FUNCNAME(GetSet_ArrangeView2))(ReaProject* proj, bool isSet, int screen_x_start, int screen_x_end, double* start_timeInOut, double* end_timeInOut);
#endif

#if defined(REAPERAPI_WANT_GetSet_LoopTimeRange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSet_LoopTimeRange

  void (*REAPERAPI_FUNCNAME(GetSet_LoopTimeRange))(bool isSet, bool isLoop, double* startOut, double* endOut, bool allowautoseek);
#endif

#if defined(REAPERAPI_WANT_GetSet_LoopTimeRange2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSet_LoopTimeRange2

  void (*REAPERAPI_FUNCNAME(GetSet_LoopTimeRange2))(ReaProject* proj, bool isSet, bool isLoop, double* startOut, double* endOut, bool allowautoseek);
#endif

#if defined(REAPERAPI_WANT_GetSetAutomationItemInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetAutomationItemInfo
// Get or set automation item information. autoitem_idx=0 for the first automation item on an envelope, 1 for the second item, etc. desc can be any of the following:
// D_POOL_ID : double * : automation item pool ID (as an integer); edits are propagated to all other automation items that share a pool ID
// D_POSITION : double * : automation item timeline position in seconds
// D_LENGTH : double * : automation item length in seconds
// D_STARTOFFS : double * : automation item start offset in seconds
// D_PLAYRATE : double * : automation item playback rate
// D_BASELINE : double * : automation item baseline value in the range [0,1]
// D_AMPLITUDE : double * : automation item amplitude in the range [-1,1]
// D_LOOPSRC : double * : nonzero if the automation item contents are looped
// D_UISEL : double * : nonzero if the automation item is selected in the arrange view
// D_POOL_QNLEN : double * : automation item pooled source length in quarter notes (setting will affect all pooled instances)
// 

  double (*REAPERAPI_FUNCNAME(GetSetAutomationItemInfo))(TrackEnvelope* env, int autoitem_idx, const char* desc, double value, bool is_set);
#endif

#if defined(REAPERAPI_WANT_GetSetAutomationItemInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetAutomationItemInfo_String
// Get or set automation item information. autoitem_idx=0 for the first automation item on an envelope, 1 for the second item, etc. returns true on success. desc can be any of the following:
// P_POOL_NAME : char * : name of the underlying automation item pool
// P_POOL_EXT:xyz : char * : extension-specific persistent data
// 

  bool (*REAPERAPI_FUNCNAME(GetSetAutomationItemInfo_String))(TrackEnvelope* env, int autoitem_idx, const char* desc, char* valuestrNeedBig, bool is_set);
#endif

#if defined(REAPERAPI_WANT_GetSetEnvelopeInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetEnvelopeInfo_String
// Gets/sets an attribute string:
// ACTIVE : active state (bool as a string "0" or "1")
// ARM : armed state (bool...)
// VISIBLE : visible state (bool...)
// SHOWLANE : show envelope in separate lane (bool...)
// GUID : (read-only) GUID as a string {xyz-....}
// P_EXT:xyz : extension-specific persistent data
// Note that when writing some of these attributes you will need to manually update the arrange and/or track panels, see TrackList_AdjustWindows

  bool (*REAPERAPI_FUNCNAME(GetSetEnvelopeInfo_String))(TrackEnvelope* env, const char* parmname, char* stringNeedBig, bool setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetEnvelopeState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetEnvelopeState
// deprecated -- see SetEnvelopeStateChunk, GetEnvelopeStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetEnvelopeState))(TrackEnvelope* env, char* str, int str_sz);
#endif

#if defined(REAPERAPI_WANT_GetSetEnvelopeState2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetEnvelopeState2
// deprecated -- see SetEnvelopeStateChunk, GetEnvelopeStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetEnvelopeState2))(TrackEnvelope* env, char* str, int str_sz, bool isundo);
#endif

#if defined(REAPERAPI_WANT_GetSetItemState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetItemState
// deprecated -- see SetItemStateChunk, GetItemStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetItemState))(MediaItem* item, char* str, int str_sz);
#endif

#if defined(REAPERAPI_WANT_GetSetItemState2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetItemState2
// deprecated -- see SetItemStateChunk, GetItemStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetItemState2))(MediaItem* item, char* str, int str_sz, bool isundo);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaItemInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaItemInfo
// P_TRACK : MediaTrack * : (read-only)
// B_MUTE : bool * : muted (item solo overrides). setting this value will clear C_MUTE_SOLO.
// B_MUTE_ACTUAL : bool * : muted (ignores solo). setting this value will not affect C_MUTE_SOLO.
// C_LANEPLAYS : char * : on fixed lane tracks, 0=this item lane does not play, 1=this item lane plays exclusively, 2=this item lane plays and other lanes also play, -1=this item is on a non-visible, non-playing lane on a formerly fixed-lane track (read-only)
// C_MUTE_SOLO : char * : solo override (-1=soloed, 0=no override, 1=unsoloed). note that this API does not automatically unsolo other items when soloing (nor clear the unsolos when clearing the last soloed item), it must be done by the caller via action or via this API.
// B_LOOPSRC : bool * : loop source
// B_ALLTAKESPLAY : bool * : all takes play
// B_UISEL : bool * : selected in arrange view
// C_BEATATTACHMODE : char * : item timebase, -1=track or project default, 1=beats (position, length, rate), 2=beats (position only). for auto-stretch timebase: C_BEATATTACHMODE=1, C_AUTOSTRETCH=1
// C_AUTOSTRETCH: : char * : auto-stretch at project tempo changes, 1=enabled, requires C_BEATATTACHMODE=1
// C_LOCK : char * : locked, &1=locked
// D_VOL : double * : item volume,  0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_POSITION : double * : item position in seconds
// D_LENGTH : double * : item length in seconds
// D_SNAPOFFSET : double * : item snap offset in seconds
// D_FADEINLEN : double * : item manual fadein length in seconds
// D_FADEOUTLEN : double * : item manual fadeout length in seconds
// D_FADEINDIR : double * : item fadein curvature, -1..1
// D_FADEOUTDIR : double * : item fadeout curvature, -1..1
// D_FADEINLEN_AUTO : double * : item auto-fadein length in seconds, -1=no auto-fadein
// D_FADEOUTLEN_AUTO : double * : item auto-fadeout length in seconds, -1=no auto-fadeout
// C_FADEINSHAPE : int * : fadein shape, 0..6, 0=linear
// C_FADEOUTSHAPE : int * : fadeout shape, 0..6, 0=linear
// I_GROUPID : int * : group ID, 0=no group
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_CURTAKE : int * : active take number
// IP_ITEMNUMBER : int : item number on this track (read-only, returns the item number directly)
// F_FREEMODE_Y : float * : free item positioning or fixed lane Y-position. 0=top of track, 1.0=bottom of track
// F_FREEMODE_H : float * : free item positioning or fixed lane height. 0.5=half the track height, 1.0=full track height
// I_FIXEDLANE : int * : fixed lane of item (fine to call with setNewValue, but returned value is read-only)
// B_FIXEDLANE_HIDDEN : bool * : true if displaying only one fixed lane and this item is in a different lane (read-only)
// P_NOTES : char * : item note text (do not write to returned pointer, use setNewValue to update)
// P_EXT:xyz : char * : extension-specific persistent data
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// 

  void* (*REAPERAPI_FUNCNAME(GetSetMediaItemInfo))(MediaItem* item, const char* parmname, void* setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaItemInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaItemInfo_String
// Gets/sets an item attribute string:
// P_NOTES : char * : item note text (do not write to returned pointer, use setNewValue to update)
// P_EXT:xyz : char * : extension-specific persistent data
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// 

  bool (*REAPERAPI_FUNCNAME(GetSetMediaItemInfo_String))(MediaItem* item, const char* parmname, char* stringNeedBig, bool setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaItemTakeInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaItemTakeInfo
// P_TRACK : pointer to MediaTrack (read-only)
// P_ITEM : pointer to MediaItem (read-only)
// P_SOURCE : PCM_source *. Note that if setting this, you should first retrieve the old source, set the new, THEN delete the old.
// P_NAME : char * : take name
// P_EXT:xyz : char * : extension-specific persistent data
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// D_STARTOFFS : double * : start offset in source media, in seconds
// D_VOL : double * : take volume, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc, negative if take polarity is flipped
// D_PAN : double * : take pan, -1..1
// D_PANLAW : double * : take pan law, -1=default, 0.5=-6dB, 1.0=+0dB, etc
// D_PLAYRATE : double * : take playback rate, 0.5=half speed, 1=normal, 2=double speed, etc
// D_PITCH : double * : take pitch adjustment in semitones, -12=one octave down, 0=normal, +12=one octave up, etc
// B_PPITCH : bool * : preserve pitch when changing playback rate
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CHANMODE : int * : channel mode, 0=normal, 1=reverse stereo, 2=downmix, 3=left, 4=right
// I_PITCHMODE : int * : pitch shifter mode, -1=project default, otherwise high 2 bytes=shifter, low 2 bytes=parameter
// I_STRETCHFLAGS : int * : stretch marker flags (&7 mask for mode override: 0=default, 1=balanced, 2/3/6=tonal, 4=transient, 5=no pre-echo)
// F_STRETCHFADESIZE : float * : stretch marker fade size in seconds (0.0025 default)
// I_RECPASSID : int * : record pass ID
// I_TAKEFX_NCH : int * : number of internal audio channels for per-take FX to use (OK to call with setNewValue, but the returned value is read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// IP_SPECEDIT:CNT : int : spectral edit count (read-only)
// IP_SPECEDIT:DELETE:x : int : read or write this key to remove the spectral edit specified
// IP_SPECEDIT:ADD : int : read or write this key to add a new spectral edit (returns index)
// IP_SPECEDIT:SORT : int : read or write this key to re-sort spectral edits (be sure to do this following a position change or insert of new edit)
// I_SPECEDIT:FFT_SIZE : int * : FFT size used by spectral edits for this take
// D_SPECEDIT:x:POSITION : double * : position of spectral edit start (changing this requires a resort of spectral edits)
// D_SPECEDIT:x:LENGTH : double * : length of spectral edit
// F_SPECEDIT:x:GAIN : float * : gain of spectral edit
// F_SPECEDIT:x:FADE_IN : float * : fade-in size 0..1
// F_SPECEDIT:x:FADE_OUT : float * : fade-out size 0..1
// F_SPECEDIT:x:FADE_LOW : float * : fade-lf size 0..1
// F_SPECEDIT:x:FADE_HI : float * : fade-hf size 0..1
// I_SPECEDIT:x:CHAN : int * : channel index, -1 for omni
// I_SPECEDIT:x:FLAGS : int * : flags, &1=bypassed, &2=solo
// F_SPECEDIT:x:GATE_THRESH : float * : gate threshold
// F_SPECEDIT:x:GATE_FLOOR : float * : gate floor
// F_SPECEDIT:x:COMP_THRESH : float * : comp threshold
// F_SPECEDIT:x:COMP_RATIO : float * : comp ratio
// B_SPECEDIT:x:SELECTED : bool * : selection state
// I_SPECEDIT:x:TOPFREQ_CNT : int * : (read-only) number of top frequency-points
// I_SPECEDIT:x:TOPFREQ_ADD:pos:val : int * : reading or writing will insert top frequency-point with position/value pair, returns index
// I_SPECEDIT:x:TOPFREQ_DEL:y : int * : reading or writing will delete top frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:TOPFREQ_POS:y : float * : (read-only) get position of top frequency-point y
// F_SPECEDIT:x:TOPFREQ_FREQ:y : float * : (read-only) get frequency of top frequency-point y
// I_SPECEDIT:x:BOTFREQ_CNT : int * : number of bottom frequency-points
// I_SPECEDIT:x:BOTFREQ_ADD:pos:val : int * : reading or writing will insert bottom frequency-point with position/value pair, returns index
// I_SPECEDIT:x:BOTFREQ_DEL:y : int * : reading or writing will delete bottom frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:BOTFREQ_POS:y : float * : (read-only) get position of bottom frequency-point y
// F_SPECEDIT:x:BOTFREQ_FREQ:y : float * : (read-only) get frequency of bottom frequency-point y
// IP_TAKENUMBER : int : take number (read-only, returns the take number directly)
// 

  void* (*REAPERAPI_FUNCNAME(GetSetMediaItemTakeInfo))(MediaItem_Take* tk, const char* parmname, void* setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaItemTakeInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaItemTakeInfo_String
// Gets/sets a take attribute string:
// P_NAME : char * : take name
// P_EXT:xyz : char * : extension-specific persistent data
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// 

  bool (*REAPERAPI_FUNCNAME(GetSetMediaItemTakeInfo_String))(MediaItem_Take* tk, const char* parmname, char* stringNeedBig, bool setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaTrackInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaTrackInfo
// Get or set track attributes.
// P_PARTRACK : MediaTrack * : parent track (read-only)
// P_PROJECT : ReaProject * : parent project (read-only)
// P_NAME : char * : track name (on master returns NULL)
// P_ICON : const char * : track icon (full filename, or relative to resource_path/data/track_icons)
// P_LANENAME:n : char * : lane name (returns NULL for non-fixed-lane-tracks)
// P_MCP_LAYOUT : const char * : layout name
// P_RAZOREDITS : const char * : list of razor edit areas, as space-separated triples of start time, end time, and envelope GUID string.
//   Example: "0.0 1.0 \"\" 0.0 1.0 "{xyz-...}"
// P_RAZOREDITS_EXT : const char * : list of razor edit areas, as comma-separated sets of space-separated tuples of start time, end time, optional: envelope GUID string, fixed/fipm top y-position, fixed/fipm bottom y-position.
//   Example: "0.0 1.0,0.0 1.0 "{xyz-...}",1.0 2.0 "" 0.25 0.75"
// P_TCP_LAYOUT : const char * : layout name
// P_EXT:xyz : char * : extension-specific persistent data
// P_UI_RECT:tcp.mute : char * : read-only, allows querying screen position + size of track WALTER elements (tcp.size queries screen position and size of entire TCP, etc).
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// B_MUTE : bool * : muted
// B_PHASE : bool * : track phase inverted
// B_RECMON_IN_EFFECT : bool * : record monitoring in effect (current audio-thread playback state, read-only)
// IP_TRACKNUMBER : int : track number 1-based, 0=not found, -1=master track (read-only, returns the int directly)
// I_SOLO : int * : soloed, 0=not soloed, 1=soloed, 2=soloed in place, 5=safe soloed, 6=safe soloed in place
// B_SOLO_DEFEAT : bool * : when set, if anything else is soloed and this track is not muted, this track acts soloed
// I_FXEN : int * : fx enabled, 0=bypassed, !0=fx active
// I_RECARM : int * : record armed, 0=not record armed, 1=record armed
// I_RECINPUT : int * : record input, <0=no input. if 4096 set, input is MIDI and low 5 bits represent channel (0=all, 1-16=only chan), next 6 bits represent physical input (63=all, 62=VKB). If 4096 is not set, low 10 bits (0..1023) are input start channel (ReaRoute/Loopback start at 512). If 2048 is set, input is multichannel input (using track channel count), or if 1024 is set, input is stereo input, otherwise input is mono.
// I_RECMODE : int * : record mode, 0=input, 1=stereo out, 2=none, 3=stereo out w/latency compensation, 4=midi output, 5=mono out, 6=mono out w/ latency compensation, 7=midi overdub, 8=midi replace
// I_RECMODE_FLAGS : int * : record mode flags, &3=output recording mode (0=post fader, 1=pre-fx, 2=post-fx/pre-fader)
// I_RECMON : int * : record monitoring, 0=off, 1=normal, 2=not when playing (tape style)
// I_RECMONITEMS : int * : monitor items while recording, 0=off, 1=on
// B_AUTO_RECARM : bool * : automatically set record arm when selected (does not immediately affect recarm state, script should set directly if desired)
// I_VUMODE : int * : track vu mode, &1:disabled, &30==0:stereo peaks, &30==2:multichannel peaks, &30==4:stereo RMS, &30==8:combined RMS, &30==12:LUFS-M, &30==16:LUFS-S (readout=max), &30==20:LUFS-S (readout=current), &32:LUFS calculation on channels 1+2 only
// I_AUTOMODE : int * : track automation mode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch
// I_NCHAN : int * : number of track channels, 2-128, even numbers only
// I_SELECTED : int * : track selected, 0=unselected, 1=selected
// I_WNDH : int * : current TCP window height in pixels including envelopes (read-only)
// I_TCPH : int * : current TCP window height in pixels not including envelopes (read-only)
// I_TCPY : int * : current TCP window Y-position in pixels relative to top of arrange view (read-only)
// I_MCPX : int * : current MCP X-position in pixels relative to mixer container (read-only)
// I_MCPY : int * : current MCP Y-position in pixels relative to mixer container (read-only)
// I_MCPW : int * : current MCP width in pixels (read-only)
// I_MCPH : int * : current MCP height in pixels (read-only)
// I_FOLDERDEPTH : int * : folder depth change, 0=normal, 1=track is a folder parent, -1=track is the last in the innermost folder, -2=track is the last in the innermost and next-innermost folders, etc
// I_FOLDERCOMPACT : int * : folder collapsed state (only valid on folders), 0=normal, 1=collapsed, 2=fully collapsed
// I_MIDIHWOUT : int * : track midi hardware output index, <0=disabled, low 5 bits are which channels (0=all, 1-16), next 5 bits are output device index (0-31)
// I_MIDI_INPUT_CHANMAP : int * : -1 maps to source channel, otherwise 1-16 to map to MIDI channel
// I_MIDI_CTL_CHAN : int * : -1 no link, 0-15 link to MIDI volume/pan on channel, 16 link to MIDI volume/pan on all channels
// I_MIDI_TRACKSEL_FLAG : int * : MIDI editor track list options: &1=expand media items, &2=exclude from list, &4=auto-pruned
// I_PERFFLAGS : int * : track performance flags, &1=no media buffering, &2=no anticipative FX
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_HEIGHTOVERRIDE : int * : custom height override for TCP window, 0 for none, otherwise size in pixels
// I_SPACER : int * : 1=TCP track spacer above this trackB_HEIGHTLOCK : bool * : track height lock (must set I_HEIGHTOVERRIDE before locking)
// D_VOL : double * : trim volume of track, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_PAN : double * : trim pan of track, -1..1
// D_WIDTH : double * : width of track, -1..1
// D_DUALPANL : double * : dualpan position 1, -1..1, only if I_PANMODE==6
// D_DUALPANR : double * : dualpan position 2, -1..1, only if I_PANMODE==6
// I_PANMODE : int * : pan mode, 0=classic 3.x, 3=new balance, 5=stereo pan, 6=dual pan
// D_PANLAW : double * : pan law of track, <0=project default, 0.5=-6dB, 0.707..=-3dB, 1=+0dB, 1.414..=-3dB with gain compensation, 2=-6dB with gain compensation, etc
// I_PANLAW_FLAGS : int * : pan law flags, 0=sine taper, 1=hybrid taper with deprecated behavior when gain compensation enabled, 2=linear taper, 3=hybrid taper
// P_ENV:<envchunkname or P_ENV:{GUID... : TrackEnvelope * : (read-only) chunkname can be <VOLENV, <PANENV, etc; GUID is the stringified envelope GUID.
// B_SHOWINMIXER : bool * : track control panel visible in mixer (do not use on master track)
// B_SHOWINTCP : bool * : track control panel visible in arrange view (do not use on master track)
// B_MAINSEND : bool * : track sends audio to parent
// C_MAINSEND_OFFS : char * : channel offset of track send to parent
// C_MAINSEND_NCH : char * : channel count of track send to parent (0=use all child track channels, 1=use one channel only)
// I_FREEMODE : int * : 1=track free item positioning enabled, 2=track fixed lanes enabled (call UpdateTimeline() after changing)
// I_NUMFIXEDLANES : int * : number of track fixed lanes (fine to call with setNewValue, but returned value is read-only)
// C_LANESCOLLAPSED : char * : fixed lane collapse state (1=lanes collapsed, 2=track displays as non-fixed-lanes but hidden lanes exist)
// C_LANESETTINGS : char * : fixed lane settings (&1=auto-remove empty lanes at bottom, &2=do not auto-comp new recording, &4=newly recorded lanes play exclusively (else add lanes in layers), &8=big lanes (else small lanes), &16=add new recording at bottom (else record into first available lane), &32=hide lane buttons
// C_LANEPLAYS:N : char * :  on fixed lane tracks, 0=lane N does not play, 1=lane N plays exclusively, 2=lane N plays and other lanes also play (fine to call with setNewValue, but returned value is read-only)
// C_ALLLANESPLAY : char * : on fixed lane tracks, 0=no lanes play, 1=all lanes play, 2=some lanes play (fine to call with setNewValue 0 or 1, but returned value is read-only)
// C_BEATATTACHMODE : char * : track timebase, -1=project default, 0=time, 1=beats (position, length, rate), 2=beats (position only)
// F_MCP_FXSEND_SCALE : float * : scale of fx+send area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_FXPARM_SCALE : float * : scale of fx parameter area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_SENDRGN_SCALE : float * : scale of send area as proportion of the fx+send total area (0=minimum allowed, 1=maximum allowed)
// F_TCP_FXPARM_SCALE : float * : scale of TCP parameter area when TCP FX are embedded (0=min allowed, default, 1=max allowed)
// I_PLAY_OFFSET_FLAG : int * : track media playback offset state, &1=bypassed, &2=offset value is measured in samples (otherwise measured in seconds)
// D_PLAY_OFFSET : double * : track media playback offset, units depend on I_PLAY_OFFSET_FLAG
// 

  void* (*REAPERAPI_FUNCNAME(GetSetMediaTrackInfo))(MediaTrack* tr, const char* parmname, void* setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetMediaTrackInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetMediaTrackInfo_String
// Get or set track string attributes.
// P_NAME : char * : track name (on master returns NULL)
// P_ICON : const char * : track icon (full filename, or relative to resource_path/data/track_icons)
// P_LANENAME:n : char * : lane name (returns NULL for non-fixed-lane-tracks)
// P_MCP_LAYOUT : const char * : layout name
// P_RAZOREDITS : const char * : list of razor edit areas, as space-separated triples of start time, end time, and envelope GUID string.
//   Example: "0.0 1.0 \"\" 0.0 1.0 "{xyz-...}"
// P_RAZOREDITS_EXT : const char * : list of razor edit areas, as comma-separated sets of space-separated tuples of start time, end time, optional: envelope GUID string, fixed/fipm top y-position, fixed/fipm bottom y-position.
//   Example: "0.0 1.0,0.0 1.0 "{xyz-...}",1.0 2.0 "" 0.25 0.75"
// P_TCP_LAYOUT : const char * : layout name
// P_EXT:xyz : char * : extension-specific persistent data
// P_UI_RECT:tcp.mute : char * : read-only, allows querying screen position + size of track WALTER elements (tcp.size queries screen position and size of entire TCP, etc).
// GUID : GUID * : 16-byte GUID, can query or update. If using a _String() function, GUID is a string {xyz-...}.
// 

  bool (*REAPERAPI_FUNCNAME(GetSetMediaTrackInfo_String))(MediaTrack* tr, const char* parmname, char* stringNeedBig, bool setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetObjectState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetObjectState
// get or set the state of a {track,item,envelope} as an RPPXML chunk
// str="" to get the chunk string returned (must call FreeHeapPtr when done)
// supply str to set the state (returns zero)

  char* (*REAPERAPI_FUNCNAME(GetSetObjectState))(void* obj, const char* str);
#endif

#if defined(REAPERAPI_WANT_GetSetObjectState2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetObjectState2
// get or set the state of a {track,item,envelope} as an RPPXML chunk
// str="" to get the chunk string returned (must call FreeHeapPtr when done)
// supply str to set the state (returns zero)
// set isundo if the state will be used for undo purposes (which may allow REAPER to get the state more efficiently

  char* (*REAPERAPI_FUNCNAME(GetSetObjectState2))(void* obj, const char* str, bool isundo);
#endif

#if defined(REAPERAPI_WANT_GetSetProjectAuthor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetProjectAuthor
// deprecated, see GetSetProjectInfo_String with desc="PROJECT_AUTHOR"

  void (*REAPERAPI_FUNCNAME(GetSetProjectAuthor))(ReaProject* proj, bool set, char* author, int author_sz);
#endif

#if defined(REAPERAPI_WANT_GetSetProjectGrid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetProjectGrid
// Get or set the arrange view grid division. 0.25=quarter note, 1.0/3.0=half note triplet, etc. swingmode can be 1 for swing enabled, swingamt is -1..1. swingmode can be 3 for measure-grid. Returns grid configuration flags

  int (*REAPERAPI_FUNCNAME(GetSetProjectGrid))(ReaProject* project, bool set, double* divisionInOutOptional, int* swingmodeInOutOptional, double* swingamtInOutOptional);
#endif

#if defined(REAPERAPI_WANT_GetSetProjectInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetProjectInfo
// Get or set project information.
// RENDER_SETTINGS : (&(1|2)==0)=master mix, &1=stems+master mix, &2=stems only, &4=multichannel tracks to multichannel files, &8=use render matrix, &16=tracks with only mono media to mono files, &32=selected media items, &64=selected media items via master, &128=selected tracks via master, &256=embed transients if format supports, &512=embed metadata if format supports, &1024=embed take markers if format supports, &2048=2nd pass render, &4096=render razor edits, &8192=pre-fader stems (not if via master), &16384=only stem channels sent to parent, &32768=preserve source metadata if possible, &(1<<16)=preserve source start offset if possible, &(2<<16)=preserve source media sample rate if possible, &(4<<16)=if rendering selected items or razor edits, render as a single file, &(8<<16)=parallel render via master
// RENDER_BOUNDSFLAG : 0=custom time bounds, 1=entire project, 2=time selection, 3=all project regions, 4=selected media items, 5=selected project regions, 6=all project markers, 7=selected project markers
// RENDER_CHANNELS : number of channels in rendered file
// RENDER_SRATE : sample rate of rendered file (or 0 for project sample rate)
// RENDER_STARTPOS : render start time when RENDER_BOUNDSFLAG=0
// RENDER_ENDPOS : render end time when RENDER_BOUNDSFLAG=0
// RENDER_TAILFLAG : apply render tail setting when rendering: &1=custom time bounds, &2=entire project, &4=time selection, &8=all project markers/regions, &16=selected media items, &32=selected project markers/regions
// RENDER_TAILMS : tail length in ms to render (only used if RENDER_BOUNDSFLAG and RENDER_TAILFLAG are set)
// RENDER_ADDTOPROJ : &1=add rendered files to project, &2=do not render files that are likely silent
// RENDER_DITHER : &1=dither, &2=noise shaping, &4=dither stems, &8=noise shaping on stems
// RENDER_NORMALIZE: &1=enable normalization, (&14==0)=LUFS-I, (&14==2)=RMS, (&14==4)=peak, (&14==6)=true peak, (&14==8)=LUFS-M max, (&14==10)=LUFS-S max, &16=adjust mono media -3dB, &(16|(8<<16))=adjust mono media +3dB, (&(32|4096)==32)=normalize as if files play together, (&(32|4096)==4096)=normalize to loudest file, (&(32|4096)==(32|4096))=normalize as if files play together (common gain), &64=enable brickwall limit, &128=brickwall limit true peak, (&(256|2048)==256)=only normalize files that are too loud, (&(256|2048)==2048)=only normalize files that are too quiet, &512=apply fade-in, &1024=apply fade-out, &16384=trim starting silence, &32768=trim ending silence, &(1<<16)=pad start with silence, &(2<<16)=pad end with silence, &(4<<16)=disable all render postprocessing, &(32<<16)=limit as if files play together
// RENDER_NORMALIZE_TARGET: render normalization target (0.5 means -6.02dB, requires RENDER_NORMALIZE&1)
// RENDER_BRICKWALL: render brickwall limit (0.5 means -6.02dB, requires RENDER_NORMALIZE&64)
// RENDER_FADEIN: render fade-in (0.001 means 1 ms, requires RENDER_NORMALIZE&512)
// RENDER_FADEOUT: render fade-out (0.001 means 1 ms, requires RENDER_NORMALIZE&1024)
// RENDER_FADEINSHAPE: render fade-in shape
// RENDER_FADEOUTSHAPE: render fade-out shape
// RENDER_PADSTART: pad render start with silence (0.001 means 1ms, requires RENDER_NORMALIZE&(1<<16))
// RENDER_PADEND: pad render end with silence (0.001 means 1ms, requires RENDER_NORMALIZE&(2<<16))
// RENDER_TRIMSTART: trim render start threshold (0.5 means -6.02dB, requires RENDER_NORMALIZE&16384)
// RENDER_TRIMEND: trim render end threshold (0.5 means -6.02dB, requires RENDER_NORMALIZE&32768)
// PROJECT_SRATE : sample rate (ignored unless PROJECT_SRATE_USE set)
// PROJECT_SRATE_USE : set to 1 if project sample rate is used
// 

  double (*REAPERAPI_FUNCNAME(GetSetProjectInfo))(ReaProject* project, const char* desc, double value, bool is_set);
#endif

#if defined(REAPERAPI_WANT_GetSetProjectInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetProjectInfo_String
// Get or set project information.
// PROJECT_NAME : project file name (read-only, is_set will be ignored)
// PROJECT_TITLE : title field from Project Settings/Notes dialog
// PROJECT_AUTHOR : author field from Project Settings/Notes dialog
// TRACK_GROUP_NAME:X : track group name, X should be 1..64
// MARKER_GUID:X : get the GUID (unique ID) of the marker or region with index X, where X is the index passed to EnumProjectMarkers, not necessarily the displayed number (read-only)
// MARKER_INDEX_FROM_GUID:{GUID} : get the GUID index of the marker or region with GUID {GUID} (read-only)
// OPENCOPY_CFGIDX : integer for the configuration of format to use when creating copies/applying FX. 0=wave (auto-depth), 1=APPLYFX_FORMAT, 2=RECORD_FORMAT
// RECORD_PATH : recording directory -- may be blank or a relative path, to get the effective path see GetProjectPathEx()
// RECORD_PATH_SECONDARY : secondary recording directory
// RECORD_FORMAT : base64-encoded sink configuration (see project files, etc). Callers can also pass a simple 4-byte string (non-base64-encoded), e.g. "evaw" or "l3pm", to use default settings for that sink type.
// APPLYFX_FORMAT : base64-encoded sink configuration (see project files, etc). Used only if RECFMT_OPENCOPY is set to 1. Callers can also pass a simple 4-byte string (non-base64-encoded), e.g. "evaw" or "l3pm", to use default settings for that sink type.
// RECTAG : project recording tag wildcard ($rectag). Can be used in Preferences/Audio/Recording to auto-name recorded files.
// RENDER_FILE : render directory
// RENDER_PATTERN : render file name (may contain wildcards)
// RENDER_METADATA : get or set the metadata saved with the project (not metadata embedded in project media). Example, ID3 album name metadata: valuestr="ID3:TALB" to get, valuestr="ID3:TALB|my album name" to set. Call with valuestr="" and is_set=false to get a semicolon-separated list of defined project metadata identifiers.
// RENDER_TARGETS : semicolon separated list of files that would be written if the project is rendered using the most recent render settings
// RENDER_STATS : (read-only) semicolon separated list of statistics for the most recently rendered files. call with valuestr="XXX" to run an action (for example, "42437"=dry run render selected items) before returning statistics.
// RENDER_FORMAT : base64-encoded sink configuration (see project files, etc). Callers can also pass a simple 4-byte string (non-base64-encoded), e.g. "evaw" or "l3pm", to use default settings for that sink type.
// RENDER_FORMAT2 : base64-encoded secondary sink configuration. Callers can also pass a simple 4-byte string (non-base64-encoded), e.g. "evaw" or "l3pm", to use default settings for that sink type, or "" to disable secondary render.
// 

  bool (*REAPERAPI_FUNCNAME(GetSetProjectInfo_String))(ReaProject* project, const char* desc, char* valuestrNeedBig, bool is_set);
#endif

#if defined(REAPERAPI_WANT_GetSetProjectNotes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetProjectNotes
// gets or sets project notes, notesNeedBig_sz is ignored when setting

  void (*REAPERAPI_FUNCNAME(GetSetProjectNotes))(ReaProject* proj, bool set, char* notesNeedBig, int notesNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_GetSetRepeat) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetRepeat
// -1 == query,0=clear,1=set,>1=toggle . returns new value

  int (*REAPERAPI_FUNCNAME(GetSetRepeat))(int val);
#endif

#if defined(REAPERAPI_WANT_GetSetRepeatEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetRepeatEx
// -1 == query,0=clear,1=set,>1=toggle . returns new value

  int (*REAPERAPI_FUNCNAME(GetSetRepeatEx))(ReaProject* proj, int val);
#endif

#if defined(REAPERAPI_WANT_GetSetTempoTimeSigMarkerFlag) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTempoTimeSigMarkerFlag
// Gets or sets the attribute flag of a tempo/time signature marker. flag &1=sets time signature and starts new measure, &2=does not set tempo, &4=allow previous partial measure if starting new measure, &8=set new metronome pattern if starting new measure, &16=reset ruler grid if starting new measure

  int (*REAPERAPI_FUNCNAME(GetSetTempoTimeSigMarkerFlag))(ReaProject* project, int point_index, int flag, bool is_set);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackGroupMembership) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackGroupMembership
// Gets or modifies the group membership for a track. Returns group state prior to call (each bit represents one of the 32 group numbers). if setmask has bits set, those bits in setvalue will be applied to group. Group can be one of:
// MEDIA_EDIT_LEAD
// MEDIA_EDIT_FOLLOW
// VOLUME_LEAD
// VOLUME_FOLLOW
// VOLUME_VCA_LEAD
// VOLUME_VCA_FOLLOW
// PAN_LEAD
// PAN_FOLLOW
// WIDTH_LEAD
// WIDTH_FOLLOW
// MUTE_LEAD
// MUTE_FOLLOW
// SOLO_LEAD
// SOLO_FOLLOW
// RECARM_LEAD
// RECARM_FOLLOW
// POLARITY_LEAD
// POLARITY_FOLLOW
// AUTOMODE_LEAD
// AUTOMODE_FOLLOW
// VOLUME_REVERSE
// PAN_REVERSE
// WIDTH_REVERSE
// NO_LEAD_WHEN_FOLLOW
// VOLUME_VCA_FOLLOW_ISPREFX
// 
// Note: REAPER v6.11 and earlier used _MASTER and _SLAVE rather than _LEAD and _FOLLOW, which is deprecated but still supported (scripts that must support v6.11 and earlier can use the deprecated strings).
// 

  unsigned int (*REAPERAPI_FUNCNAME(GetSetTrackGroupMembership))(MediaTrack* tr, const char* groupname, unsigned int setmask, unsigned int setvalue);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackGroupMembershipEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackGroupMembershipEx
// Gets or modifies 32 bits (at offset, where 0 is the low 32 bits of the grouping) of the group membership for a track. Returns group state prior to call. if setmask has bits set, those bits in setvalue will be applied to group. Group can be one of:
// MEDIA_EDIT_LEAD
// MEDIA_EDIT_FOLLOW
// VOLUME_LEAD
// VOLUME_FOLLOW
// VOLUME_VCA_LEAD
// VOLUME_VCA_FOLLOW
// PAN_LEAD
// PAN_FOLLOW
// WIDTH_LEAD
// WIDTH_FOLLOW
// MUTE_LEAD
// MUTE_FOLLOW
// SOLO_LEAD
// SOLO_FOLLOW
// RECARM_LEAD
// RECARM_FOLLOW
// POLARITY_LEAD
// POLARITY_FOLLOW
// AUTOMODE_LEAD
// AUTOMODE_FOLLOW
// VOLUME_REVERSE
// PAN_REVERSE
// WIDTH_REVERSE
// NO_LEAD_WHEN_FOLLOW
// VOLUME_VCA_FOLLOW_ISPREFX
// 
// Note: REAPER v6.11 and earlier used _MASTER and _SLAVE rather than _LEAD and _FOLLOW, which is deprecated but still supported (scripts that must support v6.11 and earlier can use the deprecated strings).
// 

  unsigned int (*REAPERAPI_FUNCNAME(GetSetTrackGroupMembershipEx))(MediaTrack* tr, const char* groupname, int offset, unsigned int setmask, unsigned int setvalue);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackGroupMembershipHigh) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackGroupMembershipHigh
// Gets or modifies the group membership for a track. Returns group state prior to call (each bit represents one of the high 32 group numbers). if setmask has bits set, those bits in setvalue will be applied to group. Group can be one of:
// MEDIA_EDIT_LEAD
// MEDIA_EDIT_FOLLOW
// VOLUME_LEAD
// VOLUME_FOLLOW
// VOLUME_VCA_LEAD
// VOLUME_VCA_FOLLOW
// PAN_LEAD
// PAN_FOLLOW
// WIDTH_LEAD
// WIDTH_FOLLOW
// MUTE_LEAD
// MUTE_FOLLOW
// SOLO_LEAD
// SOLO_FOLLOW
// RECARM_LEAD
// RECARM_FOLLOW
// POLARITY_LEAD
// POLARITY_FOLLOW
// AUTOMODE_LEAD
// AUTOMODE_FOLLOW
// VOLUME_REVERSE
// PAN_REVERSE
// WIDTH_REVERSE
// NO_LEAD_WHEN_FOLLOW
// VOLUME_VCA_FOLLOW_ISPREFX
// 
// Note: REAPER v6.11 and earlier used _MASTER and _SLAVE rather than _LEAD and _FOLLOW, which is deprecated but still supported (scripts that must support v6.11 and earlier can use the deprecated strings).
// 

  unsigned int (*REAPERAPI_FUNCNAME(GetSetTrackGroupMembershipHigh))(MediaTrack* tr, const char* groupname, unsigned int setmask, unsigned int setvalue);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackMIDISupportFile) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackMIDISupportFile
// Get or set the filename for storage of various track MIDI characteristics. 0=MIDI colormap image file, 1 or 2=MIDI bank/program select file (2=set new default). If fn != NULL, a new track MIDI storage file will be set; otherwise the existing track MIDI storage file will be returned. 

  const char* (*REAPERAPI_FUNCNAME(GetSetTrackMIDISupportFile))(ReaProject* proj, MediaTrack* track, int which, const char* filename);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackSendInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackSendInfo
// Get or set send/receive/hardware output attributes.
// category is <0 for receives, 0=sends, >0 for hardware outputs
//  sendidx is 0..n (to enumerate, iterate over sendidx until it returns NULL)
// parameter names:
// P_DESTTRACK : MediaTrack * : destination track, only applies for sends/recvs (read-only)
// P_SRCTRACK : MediaTrack * : source track, only applies for sends/recvs (read-only)
// P_ENV:<envchunkname : TrackEnvelope * : call with :<VOLENV, :<PANENV, etc appended (read-only)
// P_EXT:xyz : char * : extension-specific persistent data
// B_MUTE : bool *
// B_PHASE : bool * : true to flip phase
// B_MONO : bool *
// D_VOL : double * : 1.0 = +0dB etc
// D_PAN : double * : -1..+1
// D_PANLAW : double * : 1.0=+0.0db, 0.5=-6dB, -1.0 = projdef etc
// I_SENDMODE : int * : 0=post-fader, 1=pre-fx, 2=post-fx (deprecated), 3=post-fx
// I_AUTOMODE : int * : automation mode (-1=use track automode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch)
// I_SRCCHAN : int * : -1 for no audio send. Low 10 bits specify channel offset, and higher bits specify channel count. (srcchan>>10) == 0 for stereo, 1 for mono, 2 for 4 channel, 3 for 6 channel, etc.
// I_DSTCHAN : int * : low 10 bits are destination index, &1024 set to mix to mono.
// I_MIDIFLAGS : int * : low 5 bits=source channel 0=all, 1-16, 31=MIDI send disabled, next 5 bits=dest channel, 0=orig, 1-16=chan. &1024 for faders-send MIDI vol/pan. (>>14)&255 = src bus (0 for all, 1 for normal, 2+). (>>22)&255=destination bus (0 for all, 1 for normal, 2+)
// See CreateTrackSend, RemoveTrackSend.

  void* (*REAPERAPI_FUNCNAME(GetSetTrackSendInfo))(MediaTrack* tr, int category, int sendidx, const char* parmname, void* setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackSendInfo_String) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackSendInfo_String
// Gets/sets a send attribute string:
// P_EXT:xyz : char * : extension-specific persistent data
// 

  bool (*REAPERAPI_FUNCNAME(GetSetTrackSendInfo_String))(MediaTrack* tr, int category, int sendidx, const char* parmname, char* stringNeedBig, bool setNewValue);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackState
// deprecated -- see SetTrackStateChunk, GetTrackStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetTrackState))(MediaTrack* track, char* str, int str_sz);
#endif

#if defined(REAPERAPI_WANT_GetSetTrackState2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSetTrackState2
// deprecated -- see SetTrackStateChunk, GetTrackStateChunk

  bool (*REAPERAPI_FUNCNAME(GetSetTrackState2))(MediaTrack* track, char* str, int str_sz, bool isundo);
#endif

#if defined(REAPERAPI_WANT_GetSubProjectFromSource) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetSubProjectFromSource

  ReaProject* (*REAPERAPI_FUNCNAME(GetSubProjectFromSource))(PCM_source* src);
#endif

#if defined(REAPERAPI_WANT_GetTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTake
// get a take from an item by take count (zero-based)

  MediaItem_Take* (*REAPERAPI_FUNCNAME(GetTake))(MediaItem* item, int takeidx);
#endif

#if defined(REAPERAPI_WANT_GetTakeEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeEnvelope

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetTakeEnvelope))(MediaItem_Take* take, int envidx);
#endif

#if defined(REAPERAPI_WANT_GetTakeEnvelopeByName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeEnvelopeByName

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetTakeEnvelopeByName))(MediaItem_Take* take, const char* envname);
#endif

#if defined(REAPERAPI_WANT_GetTakeMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeMarker
// Get information about a take marker. Returns the position in media item source time, or -1 if the take marker does not exist. See GetNumTakeMarkers, SetTakeMarker, DeleteTakeMarker

  double (*REAPERAPI_FUNCNAME(GetTakeMarker))(MediaItem_Take* take, int idx, char* nameOut, int nameOut_sz, int* colorOutOptional);
#endif

#if defined(REAPERAPI_WANT_GetTakeName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeName
// returns NULL if the take is not valid

  const char* (*REAPERAPI_FUNCNAME(GetTakeName))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetTakeNumStretchMarkers) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeNumStretchMarkers
// Returns number of stretch markers in take

  int (*REAPERAPI_FUNCNAME(GetTakeNumStretchMarkers))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_GetTakeStretchMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeStretchMarker
// Gets information on a stretch marker, idx is 0..n. Returns -1 if stretch marker not valid. posOut will be set to position in item, srcposOutOptional will be set to source media position. Returns index. if input index is -1, the following marker is found using position (or source position if position is -1). If position/source position are used to find marker position, their values are not updated.

  int (*REAPERAPI_FUNCNAME(GetTakeStretchMarker))(MediaItem_Take* take, int idx, double* posOut, double* srcposOutOptional);
#endif

#if defined(REAPERAPI_WANT_GetTakeStretchMarkerSlope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTakeStretchMarkerSlope
// See SetTakeStretchMarkerSlope

  double (*REAPERAPI_FUNCNAME(GetTakeStretchMarkerSlope))(MediaItem_Take* take, int idx);
#endif

#if defined(REAPERAPI_WANT_GetTCPFXParm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTCPFXParm
// Get information about a specific FX parameter knob (see CountTCPFXParms).

  bool (*REAPERAPI_FUNCNAME(GetTCPFXParm))(ReaProject* project, MediaTrack* track, int index, int* fxindexOut, int* parmidxOut);
#endif

#if defined(REAPERAPI_WANT_GetTempoMatchPlayRate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTempoMatchPlayRate
// finds the playrate and target length to insert this item stretched to a round power-of-2 number of bars, between 1/8 and 256

  bool (*REAPERAPI_FUNCNAME(GetTempoMatchPlayRate))(PCM_source* source, double srcscale, double position, double mult, double* rateOut, double* targetlenOut);
#endif

#if defined(REAPERAPI_WANT_GetTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTempoTimeSigMarker
// Get information about a tempo/time signature marker. See CountTempoTimeSigMarkers, SetTempoTimeSigMarker, AddTempoTimeSigMarker.

  bool (*REAPERAPI_FUNCNAME(GetTempoTimeSigMarker))(ReaProject* proj, int ptidx, double* timeposOut, int* measureposOut, double* beatposOut, double* bpmOut, int* timesig_numOut, int* timesig_denomOut, bool* lineartempoOut);
#endif

#if defined(REAPERAPI_WANT_GetThemeColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetThemeColor
// Returns the theme color specified, or -1 on failure. If the low bit of flags is set, the color as originally specified by the theme (before any transformations) is returned, otherwise the current (possibly transformed and modified) color is returned. See SetThemeColor for a list of valid ini_key.

  int (*REAPERAPI_FUNCNAME(GetThemeColor))(const char* ini_key, int flagsOptional);
#endif

#if defined(REAPERAPI_WANT_GetThingFromPoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetThingFromPoint
// Hit tests a point in screen coordinates. Updates infoOut with information such as "arrange", "fx_chain", "fx_0" (first FX in chain, floating), "spacer_0" (spacer before first track). If a track panel is hit, string will begin with "tcp" or "mcp" or "tcp.mute" etc (future versions may append additional information). May return NULL with valid info string to indicate non-track thing.

  MediaTrack* (*REAPERAPI_FUNCNAME(GetThingFromPoint))(int screen_x, int screen_y, char* infoOut, int infoOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetToggleCommandState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetToggleCommandState
// See GetToggleCommandStateEx.

  int (*REAPERAPI_FUNCNAME(GetToggleCommandState))(int command_id);
#endif

#if defined(REAPERAPI_WANT_GetToggleCommandState2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetToggleCommandState2
// See GetToggleCommandStateEx.

  int (*REAPERAPI_FUNCNAME(GetToggleCommandState2))(KbdSectionInfo* section, int command_id);
#endif

#if defined(REAPERAPI_WANT_GetToggleCommandStateEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetToggleCommandStateEx
// For the main action context, the MIDI editor, or the media explorer, returns the toggle state of the action. 0=off, 1=on, -1=NA because the action does not have on/off states. For the MIDI editor, the action state for the most recently focused window will be returned.

  int (*REAPERAPI_FUNCNAME(GetToggleCommandStateEx))(int section_id, int command_id);
#endif

#if defined(REAPERAPI_WANT_GetToggleCommandStateThroughHooks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetToggleCommandStateThroughHooks
// Returns the state of an action via extension plugins' hooks.

  int (*REAPERAPI_FUNCNAME(GetToggleCommandStateThroughHooks))(KbdSectionInfo* section, int command_id);
#endif

#if defined(REAPERAPI_WANT_GetTooltipWindow) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTooltipWindow
// gets a tooltip window,in case you want to ask it for font information. Can return NULL.

  HWND (*REAPERAPI_FUNCNAME(GetTooltipWindow))();
#endif

#if defined(REAPERAPI_WANT_GetTouchedOrFocusedFX) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTouchedOrFocusedFX
// mode can be 0 to query last touched parameter, or 1 to query currently focused FX. Returns false if failed. If successful, trackIdxOut will be track index (-1 is master track, 0 is first track). itemidxOut will be 0-based item index if an item, or -1 if not an item. takeidxOut will be 0-based take index. fxidxOut will be FX index, potentially with 0x2000000 set to signify container-addressing, or with 0x1000000 set to signify record-input FX. parmOut will be set to the parameter index if querying last-touched. parmOut will have 1 set if querying focused state and FX is no longer focused but still open.

  bool (*REAPERAPI_FUNCNAME(GetTouchedOrFocusedFX))(int mode, int* trackidxOut, int* itemidxOut, int* takeidxOut, int* fxidxOut, int* parmOut);
#endif

#if defined(REAPERAPI_WANT_GetTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrack
// get a track from a project by track count (zero-based) (proj=0 for active project)

  MediaTrack* (*REAPERAPI_FUNCNAME(GetTrack))(ReaProject* proj, int trackidx);
#endif

#if defined(REAPERAPI_WANT_GetTrackAutomationMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackAutomationMode
// return the track mode, regardless of global override

  int (*REAPERAPI_FUNCNAME(GetTrackAutomationMode))(MediaTrack* tr);
#endif

#if defined(REAPERAPI_WANT_GetTrackColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackColor
// Returns the track custom color as OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). Black is returned as 0x1000000, no color setting is returned as 0.

  int (*REAPERAPI_FUNCNAME(GetTrackColor))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_GetTrackDepth) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackDepth

  int (*REAPERAPI_FUNCNAME(GetTrackDepth))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_GetTrackEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackEnvelope

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetTrackEnvelope))(MediaTrack* track, int envidx);
#endif

#if defined(REAPERAPI_WANT_GetTrackEnvelopeByChunkName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackEnvelopeByChunkName
// Gets a built-in track envelope by configuration chunk name, like "<VOLENV", or GUID string, like "{B577250D-146F-B544-9B34-F24FBE488F1F}".
// 

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetTrackEnvelopeByChunkName))(MediaTrack* tr, const char* cfgchunkname_or_guid);
#endif

#if defined(REAPERAPI_WANT_GetTrackEnvelopeByName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackEnvelopeByName

  TrackEnvelope* (*REAPERAPI_FUNCNAME(GetTrackEnvelopeByName))(MediaTrack* track, const char* envname);
#endif

#if defined(REAPERAPI_WANT_GetTrackFromPoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackFromPoint
// Returns the track from the screen coordinates specified. If the screen coordinates refer to a window associated to the track (such as FX), the track will be returned. infoOutOptional will be set to 1 if it is likely an envelope, 2 if it is likely a track FX. For a free item positioning or fixed lane track, the second byte of infoOutOptional will be set to the (approximate, for fipm tracks) item lane underneath the mouse. See GetThingFromPoint.

  MediaTrack* (*REAPERAPI_FUNCNAME(GetTrackFromPoint))(int screen_x, int screen_y, int* infoOutOptional);
#endif

#if defined(REAPERAPI_WANT_GetTrackGUID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackGUID

  GUID* (*REAPERAPI_FUNCNAME(GetTrackGUID))(MediaTrack* tr);
#endif

#if defined(REAPERAPI_WANT_GetTrackInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackInfo
// gets track info (returns name).
// track index, -1=master, 0..n, or cast a MediaTrack* to int
// if flags is non-NULL, will be set to:
// &1=folder
// &2=selected
// &4=has fx enabled
// &8=muted
// &16=soloed
// &32=SIP'd (with &16)
// &64=rec armed
// &128=rec monitoring on
// &256=rec monitoring auto
// &512=hide from TCP
// &1024=hide from MCP

  const char* (*REAPERAPI_FUNCNAME(GetTrackInfo))(INT_PTR track, int* flags);
#endif

#if defined(REAPERAPI_WANT_GetTrackMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackMediaItem

  MediaItem* (*REAPERAPI_FUNCNAME(GetTrackMediaItem))(MediaTrack* tr, int itemidx);
#endif

#if defined(REAPERAPI_WANT_GetTrackMIDILyrics) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackMIDILyrics
// Get all MIDI lyrics on the track. Lyrics will be returned as one string with tabs between each word. flag&1: double tabs at the end of each measure and triple tabs when skipping measures, flag&2: each lyric is preceded by its beat position in the project (example with flag=2: "1.1.2\tLyric for measure 1 beat 2\t2.1.1\tLyric for measure 2 beat 1	"). See SetTrackMIDILyrics

  bool (*REAPERAPI_FUNCNAME(GetTrackMIDILyrics))(MediaTrack* track, int flag, char* bufOutWantNeedBig, int* bufOutWantNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_GetTrackMIDINoteName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackMIDINoteName
// see GetTrackMIDINoteNameEx

  const char* (*REAPERAPI_FUNCNAME(GetTrackMIDINoteName))(int track, int pitch, int chan);
#endif

#if defined(REAPERAPI_WANT_GetTrackMIDINoteNameEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackMIDINoteNameEx
// Get note/CC name. pitch 128 for CC0 name, 129 for CC1 name, etc. See SetTrackMIDINoteNameEx

  const char* (*REAPERAPI_FUNCNAME(GetTrackMIDINoteNameEx))(ReaProject* proj, MediaTrack* track, int pitch, int chan);
#endif

#if defined(REAPERAPI_WANT_GetTrackMIDINoteRange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackMIDINoteRange

  void (*REAPERAPI_FUNCNAME(GetTrackMIDINoteRange))(ReaProject* proj, MediaTrack* track, int* note_loOut, int* note_hiOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackName
// Returns "MASTER" for master track, "Track N" if track has no name.

  bool (*REAPERAPI_FUNCNAME(GetTrackName))(MediaTrack* track, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetTrackNumMediaItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackNumMediaItems

  int (*REAPERAPI_FUNCNAME(GetTrackNumMediaItems))(MediaTrack* tr);
#endif

#if defined(REAPERAPI_WANT_GetTrackNumSends) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackNumSends
// returns number of sends/receives/hardware outputs - category is <0 for receives, 0=sends, >0 for hardware outputs

  int (*REAPERAPI_FUNCNAME(GetTrackNumSends))(MediaTrack* tr, int category);
#endif

#if defined(REAPERAPI_WANT_GetTrackReceiveName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackReceiveName
// See GetTrackSendName.

  bool (*REAPERAPI_FUNCNAME(GetTrackReceiveName))(MediaTrack* track, int recv_index, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetTrackReceiveUIMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackReceiveUIMute
// See GetTrackSendUIMute.

  bool (*REAPERAPI_FUNCNAME(GetTrackReceiveUIMute))(MediaTrack* track, int recv_index, bool* muteOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackReceiveUIVolPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackReceiveUIVolPan
// See GetTrackSendUIVolPan.

  bool (*REAPERAPI_FUNCNAME(GetTrackReceiveUIVolPan))(MediaTrack* track, int recv_index, double* volumeOut, double* panOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackSendInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackSendInfo_Value
// Get send/receive/hardware output numerical-value attributes.
// category is <0 for receives, 0=sends, >0 for hardware outputs
// parameter names:
// B_MUTE : bool *
// B_PHASE : bool * : true to flip phase
// B_MONO : bool *
// D_VOL : double * : 1.0 = +0dB etc
// D_PAN : double * : -1..+1
// D_PANLAW : double * : 1.0=+0.0db, 0.5=-6dB, -1.0 = projdef etc
// I_SENDMODE : int * : 0=post-fader, 1=pre-fx, 2=post-fx (deprecated), 3=post-fx
// I_AUTOMODE : int * : automation mode (-1=use track automode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch)
// I_SRCCHAN : int * : -1 for no audio send. Low 10 bits specify channel offset, and higher bits specify channel count. (srcchan>>10) == 0 for stereo, 1 for mono, 2 for 4 channel, 3 for 6 channel, etc.
// I_DSTCHAN : int * : low 10 bits are destination index, &1024 set to mix to mono.
// I_MIDIFLAGS : int * : low 5 bits=source channel 0=all, 1-16, 31=MIDI send disabled, next 5 bits=dest channel, 0=orig, 1-16=chan. &1024 for faders-send MIDI vol/pan. (>>14)&255 = src bus (0 for all, 1 for normal, 2+). (>>22)&255=destination bus (0 for all, 1 for normal, 2+)
// P_DESTTRACK : MediaTrack * : destination track, only applies for sends/recvs (read-only)
// P_SRCTRACK : MediaTrack * : source track, only applies for sends/recvs (read-only)
// P_ENV:<envchunkname : TrackEnvelope * : call with :<VOLENV, :<PANENV, etc appended (read-only)
// See CreateTrackSend, RemoveTrackSend, GetTrackNumSends.

  double (*REAPERAPI_FUNCNAME(GetTrackSendInfo_Value))(MediaTrack* tr, int category, int sendidx, const char* parmname);
#endif

#if defined(REAPERAPI_WANT_GetTrackSendName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackSendName
// send_idx>=0 for hw ouputs, >=nb_of_hw_ouputs for sends. See GetTrackReceiveName.

  bool (*REAPERAPI_FUNCNAME(GetTrackSendName))(MediaTrack* track, int send_index, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_GetTrackSendUIMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackSendUIMute
// send_idx>=0 for hw ouputs, >=nb_of_hw_ouputs for sends. See GetTrackReceiveUIMute.

  bool (*REAPERAPI_FUNCNAME(GetTrackSendUIMute))(MediaTrack* track, int send_index, bool* muteOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackSendUIVolPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackSendUIVolPan
// send_idx>=0 for hw ouputs, >=nb_of_hw_ouputs for sends. See GetTrackReceiveUIVolPan.

  bool (*REAPERAPI_FUNCNAME(GetTrackSendUIVolPan))(MediaTrack* track, int send_index, double* volumeOut, double* panOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackState
// Gets track state, returns track name.
// flags will be set to:
// &1=folder
// &2=selected
// &4=has fx enabled
// &8=muted
// &16=soloed
// &32=SIP'd (with &16)
// &64=rec armed
// &128=rec monitoring on
// &256=rec monitoring auto
// &512=hide from TCP
// &1024=hide from MCP

  const char* (*REAPERAPI_FUNCNAME(GetTrackState))(MediaTrack* track, int* flagsOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackStateChunk
// Gets the RPPXML state of a track, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(GetTrackStateChunk))(MediaTrack* track, char* strNeedBig, int strNeedBig_sz, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_GetTrackUIMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackUIMute

  bool (*REAPERAPI_FUNCNAME(GetTrackUIMute))(MediaTrack* track, bool* muteOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackUIPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackUIPan

  bool (*REAPERAPI_FUNCNAME(GetTrackUIPan))(MediaTrack* track, double* pan1Out, double* pan2Out, int* panmodeOut);
#endif

#if defined(REAPERAPI_WANT_GetTrackUIVolPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetTrackUIVolPan

  bool (*REAPERAPI_FUNCNAME(GetTrackUIVolPan))(MediaTrack* track, double* volumeOut, double* panOut);
#endif

#if defined(REAPERAPI_WANT_GetUnderrunTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetUnderrunTime
// retrieves the last timestamps of audio xrun (yellow-flash, if available), media xrun (red-flash), and the current time stamp (all milliseconds)

  void (*REAPERAPI_FUNCNAME(GetUnderrunTime))(unsigned int* audio_xrunOut, unsigned int* media_xrunOut, unsigned int* curtimeOut);
#endif

#if defined(REAPERAPI_WANT_GetUserFileNameForRead) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetUserFileNameForRead
// returns true if the user selected a valid file, false if the user canceled the dialog

  bool (*REAPERAPI_FUNCNAME(GetUserFileNameForRead))(char* filenameNeed4096, const char* title, const char* defext);
#endif

#if defined(REAPERAPI_WANT_GetUserInputs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GetUserInputs
// Get values from the user.
// If a caption begins with *, for example "*password", the edit field will not display the input text.
// Maximum fields is 16. Values are returned as a comma-separated string. Returns false if the user canceled the dialog. You can supply special extra information via additional caption fields: extrawidth=XXX to increase text field width, separator=X to use a different separator for returned fields.

  bool (*REAPERAPI_FUNCNAME(GetUserInputs))(const char* title, int num_inputs, const char* captions_csv, char* retvals_csv, int retvals_csv_sz);
#endif

#if defined(REAPERAPI_WANT_GoToMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GoToMarker
// Go to marker. If use_timeline_order==true, marker_index 1 refers to the first marker on the timeline.  If use_timeline_order==false, marker_index 1 refers to the first marker with the user-editable index of 1.

  void (*REAPERAPI_FUNCNAME(GoToMarker))(ReaProject* proj, int marker_index, bool use_timeline_order);
#endif

#if defined(REAPERAPI_WANT_GoToRegion) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GoToRegion
// Seek to region after current region finishes playing (smooth seek). If use_timeline_order==true, region_index 1 refers to the first region on the timeline.  If use_timeline_order==false, region_index 1 refers to the first region with the user-editable index of 1.

  void (*REAPERAPI_FUNCNAME(GoToRegion))(ReaProject* proj, int region_index, bool use_timeline_order);
#endif

#if defined(REAPERAPI_WANT_GR_SelectColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GR_SelectColor
// Runs the system color chooser dialog.  Returns 0 if the user cancels the dialog.

  int (*REAPERAPI_FUNCNAME(GR_SelectColor))(HWND hwnd, int* colorOut);
#endif

#if defined(REAPERAPI_WANT_GSC_mainwnd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// GSC_mainwnd
// this is just like win32 GetSysColor() but can have overrides.

  int (*REAPERAPI_FUNCNAME(GSC_mainwnd))(int t);
#endif

#if defined(REAPERAPI_WANT_guidToString) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// guidToString
// dest should be at least 64 chars long to be safe

  void (*REAPERAPI_FUNCNAME(guidToString))(const GUID* g, char* destNeed64);
#endif

#if defined(REAPERAPI_WANT_HasExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// HasExtState
// Returns true if there exists an extended state value for a specific section and key. See SetExtState, GetExtState, DeleteExtState.

  bool (*REAPERAPI_FUNCNAME(HasExtState))(const char* section, const char* key);
#endif

#if defined(REAPERAPI_WANT_HasTrackMIDIPrograms) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// HasTrackMIDIPrograms
// returns name of track plugin that is supplying MIDI programs,or NULL if there is none

  const char* (*REAPERAPI_FUNCNAME(HasTrackMIDIPrograms))(int track);
#endif

#if defined(REAPERAPI_WANT_HasTrackMIDIProgramsEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// HasTrackMIDIProgramsEx
// returns name of track plugin that is supplying MIDI programs,or NULL if there is none

  const char* (*REAPERAPI_FUNCNAME(HasTrackMIDIProgramsEx))(ReaProject* proj, MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_Help_Set) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Help_Set

  void (*REAPERAPI_FUNCNAME(Help_Set))(const char* helpstring, bool is_temporary_help);
#endif

#if defined(REAPERAPI_WANT_HiresPeaksFromSource) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// HiresPeaksFromSource

  void (*REAPERAPI_FUNCNAME(HiresPeaksFromSource))(PCM_source* src, PCM_source_peaktransfer_t* block);
#endif

#if defined(REAPERAPI_WANT_image_resolve_fn) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// image_resolve_fn

  void (*REAPERAPI_FUNCNAME(image_resolve_fn))(const char* in, char* out, int out_sz);
#endif

#if defined(REAPERAPI_WANT_InsertAutomationItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertAutomationItem
// Insert a new automation item. pool_id < 0 collects existing envelope points into the automation item; if pool_id is >= 0 the automation item will be a new instance of that pool (which will be created as an empty instance if it does not exist). Returns the index of the item, suitable for passing to other automation item API functions. See GetSetAutomationItemInfo.

  int (*REAPERAPI_FUNCNAME(InsertAutomationItem))(TrackEnvelope* env, int pool_id, double position, double length);
#endif

#if defined(REAPERAPI_WANT_InsertEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertEnvelopePoint
// Insert an envelope point. If setting multiple points at once, set noSort=true, and call Envelope_SortPoints when done. See InsertEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(InsertEnvelopePoint))(TrackEnvelope* envelope, double time, double value, int shape, double tension, bool selected, bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_InsertEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertEnvelopePointEx
// Insert an envelope point. If setting multiple points at once, set noSort=true, and call Envelope_SortPoints when done.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See CountEnvelopePointsEx, GetEnvelopePointEx, SetEnvelopePointEx, DeleteEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(InsertEnvelopePointEx))(TrackEnvelope* envelope, int autoitem_idx, double time, double value, int shape, double tension, bool selected, bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_InsertMedia) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertMedia
// mode: 0=add to current track, 1=add new track, 3=add to selected items as takes, &4=stretch/loop to fit time sel, &8=try to match tempo 1x, &16=try to match tempo 0.5x, &32=try to match tempo 2x, &64=don't preserve pitch when matching tempo, &128=no loop/section if startpct/endpct set, &256=force loop regardless of global preference for looping imported items, &512=use high word as absolute track index if mode&3==0 or mode&2048, &1024=insert into reasamplomatic on a new track (add 1 to insert on last selected track), &2048=insert into open reasamplomatic instance (add 512 to use high word as absolute track index), &4096=move to source preferred position (BWF start offset), &8192=reverse. &16384=apply ripple according to project setting

  int (*REAPERAPI_FUNCNAME(InsertMedia))(const char* file, int mode);
#endif

#if defined(REAPERAPI_WANT_InsertMediaSection) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertMediaSection
// See InsertMedia.

  int (*REAPERAPI_FUNCNAME(InsertMediaSection))(const char* file, int mode, double startpct, double endpct, double pitchshift);
#endif

#if defined(REAPERAPI_WANT_InsertTrackAtIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertTrackAtIndex
// inserts a track at idx,of course this will be clamped to 0..GetNumTracks(). wantDefaults=TRUE for default envelopes/FX,otherwise no enabled fx/env. Superseded, see InsertTrackInProject 

  void (*REAPERAPI_FUNCNAME(InsertTrackAtIndex))(int idx, bool wantDefaults);
#endif

#if defined(REAPERAPI_WANT_InsertTrackInProject) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// InsertTrackInProject
// inserts a track in project proj at idx, this will be clamped to 0..CountTracks(proj). flags&1 for default envelopes/FX, otherwise no enabled fx/envelopes will be added.

  void (*REAPERAPI_FUNCNAME(InsertTrackInProject))(ReaProject* proj, int idx, int flags);
#endif

#if defined(REAPERAPI_WANT_IsInRealTimeAudio) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsInRealTimeAudio
// are we in a realtime audio thread (between OnAudioBuffer calls,not in some worker/anticipative FX thread)? threadsafe

  int (*REAPERAPI_FUNCNAME(IsInRealTimeAudio))();
#endif

#if defined(REAPERAPI_WANT_IsItemTakeActiveForPlayback) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsItemTakeActiveForPlayback
// get whether a take will be played (active take, unmuted, etc)

  bool (*REAPERAPI_FUNCNAME(IsItemTakeActiveForPlayback))(MediaItem* item, MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_IsMediaExtension) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsMediaExtension
// Tests a file extension (i.e. "wav" or "mid") to see if it's a media extension.
// If wantOthers is set, then "RPP", "TXT" and other project-type formats will also pass.

  bool (*REAPERAPI_FUNCNAME(IsMediaExtension))(const char* ext, bool wantOthers);
#endif

#if defined(REAPERAPI_WANT_IsMediaItemSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsMediaItemSelected

  bool (*REAPERAPI_FUNCNAME(IsMediaItemSelected))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_IsProjectDirty) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsProjectDirty
// Is the project dirty (needing save)? Always returns 0 if 'undo/prompt to save' is disabled in preferences.

  int (*REAPERAPI_FUNCNAME(IsProjectDirty))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_IsREAPER) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsREAPER
// Returns true if dealing with REAPER, returns false for ReaMote, etc

  bool (*REAPERAPI_FUNCNAME(IsREAPER))();
#endif

#if defined(REAPERAPI_WANT_IsTrackSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsTrackSelected

  bool (*REAPERAPI_FUNCNAME(IsTrackSelected))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_IsTrackVisible) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsTrackVisible
// If mixer==true, returns true if the track is visible in the mixer.  If mixer==false, returns true if the track is visible in the track control panel.

  bool (*REAPERAPI_FUNCNAME(IsTrackVisible))(MediaTrack* track, bool mixer);
#endif

#if defined(REAPERAPI_WANT_IsWindowTextField) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// IsWindowTextField
// Returns true if window is a text field or should behave as such (jsfx editor, hooked via hwnd_info, etc)

  bool (*REAPERAPI_FUNCNAME(IsWindowTextField))(HWND hwnd);
#endif

#if defined(REAPERAPI_WANT_joystick_create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_create
// creates a joystick device

  joystick_device* (*REAPERAPI_FUNCNAME(joystick_create))(const GUID* guid);
#endif

#if defined(REAPERAPI_WANT_joystick_destroy) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_destroy
// destroys a joystick device

  void (*REAPERAPI_FUNCNAME(joystick_destroy))(joystick_device* device);
#endif

#if defined(REAPERAPI_WANT_joystick_enum) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_enum
// enumerates installed devices, returns GUID as a string

  const char* (*REAPERAPI_FUNCNAME(joystick_enum))(int index, const char** namestrOutOptional);
#endif

#if defined(REAPERAPI_WANT_joystick_getaxis) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_getaxis
// returns axis value (-1..1)

  double (*REAPERAPI_FUNCNAME(joystick_getaxis))(joystick_device* dev, int axis);
#endif

#if defined(REAPERAPI_WANT_joystick_getbuttonmask) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_getbuttonmask
// returns button pressed mask, 1=first button, 2=second...

  unsigned int (*REAPERAPI_FUNCNAME(joystick_getbuttonmask))(joystick_device* dev);
#endif

#if defined(REAPERAPI_WANT_joystick_getinfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_getinfo
// returns button count

  int (*REAPERAPI_FUNCNAME(joystick_getinfo))(joystick_device* dev, int* axesOutOptional, int* povsOutOptional);
#endif

#if defined(REAPERAPI_WANT_joystick_getpov) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_getpov
// returns POV value (usually 0..655.35, or 655.35 on error)

  double (*REAPERAPI_FUNCNAME(joystick_getpov))(joystick_device* dev, int pov);
#endif

#if defined(REAPERAPI_WANT_joystick_update) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// joystick_update
// Updates joystick state from hardware, returns true if successful (joystick_get* will not be valid until joystick_update() is called successfully)

  bool (*REAPERAPI_FUNCNAME(joystick_update))(joystick_device* dev);
#endif

#if defined(REAPERAPI_WANT_kbd_enumerateActions) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_enumerateActions

  int (*REAPERAPI_FUNCNAME(kbd_enumerateActions))(KbdSectionInfo* section, int idx, const char** nameOut);
#endif

#if defined(REAPERAPI_WANT_kbd_formatKeyName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_formatKeyName

  void (*REAPERAPI_FUNCNAME(kbd_formatKeyName))(ACCEL* ac, char* s);
#endif

#if defined(REAPERAPI_WANT_kbd_getCommandName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_getCommandName
// Get the string of a key assigned to command "cmd" in a section.
// This function is poorly named as it doesn't return the command's name, see kbd_getTextFromCmd.

  void (*REAPERAPI_FUNCNAME(kbd_getCommandName))(int cmd, char* s, KbdSectionInfo* section);
#endif

#if defined(REAPERAPI_WANT_kbd_getTextFromCmd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_getTextFromCmd

  const char* (*REAPERAPI_FUNCNAME(kbd_getTextFromCmd))(int cmd, KbdSectionInfo* section);
#endif

#if defined(REAPERAPI_WANT_KBD_OnMainActionEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// KBD_OnMainActionEx
// val/valhw are used for midi stuff.
// val=[0..127] and valhw=-1 (midi CC),
// valhw >=0 (midi pitch (valhw | val<<7)),
// relmode absolute (0) or 1/2/3 for relative adjust modes

  int (*REAPERAPI_FUNCNAME(KBD_OnMainActionEx))(int cmd, int val, int valhw, int relmode, HWND hwnd, ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_kbd_OnMidiEvent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_OnMidiEvent
// can be called from anywhere (threadsafe)

  void (*REAPERAPI_FUNCNAME(kbd_OnMidiEvent))(MIDI_event_t* evt, int dev_index);
#endif

#if defined(REAPERAPI_WANT_kbd_OnMidiList) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_OnMidiList
// can be called from anywhere (threadsafe)

  void (*REAPERAPI_FUNCNAME(kbd_OnMidiList))(MIDI_eventlist* list, int dev_index);
#endif

#if defined(REAPERAPI_WANT_kbd_ProcessActionsMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_ProcessActionsMenu

  void (*REAPERAPI_FUNCNAME(kbd_ProcessActionsMenu))(HMENU menu, KbdSectionInfo* section);
#endif

#if defined(REAPERAPI_WANT_kbd_processMidiEventActionEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_processMidiEventActionEx

  bool (*REAPERAPI_FUNCNAME(kbd_processMidiEventActionEx))(MIDI_event_t* evt, KbdSectionInfo* section, HWND hwndCtx);
#endif

#if defined(REAPERAPI_WANT_kbd_reprocessMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_reprocessMenu
// Reprocess a menu recursively, setting key assignments to what their command IDs are mapped to.

  void (*REAPERAPI_FUNCNAME(kbd_reprocessMenu))(HMENU menu, KbdSectionInfo* section);
#endif

#if defined(REAPERAPI_WANT_kbd_RunCommandThroughHooks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_RunCommandThroughHooks
// actioncommandID may get modified

  bool (*REAPERAPI_FUNCNAME(kbd_RunCommandThroughHooks))(KbdSectionInfo* section, const int* actionCommandID, const int* val, const int* valhw, const int* relmode, HWND hwnd);
#endif

#if defined(REAPERAPI_WANT_kbd_translateAccelerator) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// kbd_translateAccelerator
// Pass in the HWND to receive commands, a MSG of a key command,  and a valid section,
// and kbd_translateAccelerator() will process it looking for any keys bound to it, and send the messages off.
// Returns 1 if processed, 0 if no key binding found.

  int (*REAPERAPI_FUNCNAME(kbd_translateAccelerator))(HWND hwnd, MSG* msg, KbdSectionInfo* section);
#endif

#ifndef REAPERAPI_NO_LICE
#if defined(REAPERAPI_WANT_LICE__Destroy) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__Destroy

  void (*REAPERAPI_FUNCNAME(LICE__Destroy))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__DestroyFont) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__DestroyFont

  void (*REAPERAPI_FUNCNAME(LICE__DestroyFont))(LICE_IFont* font);
#endif

#if defined(REAPERAPI_WANT_LICE__DrawText) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__DrawText

  int (*REAPERAPI_FUNCNAME(LICE__DrawText))(LICE_IFont* font, LICE_IBitmap* bm, const char* str, int strcnt, RECT* rect, UINT dtFlags);
#endif

#if defined(REAPERAPI_WANT_LICE__GetBits) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__GetBits

  void* (*REAPERAPI_FUNCNAME(LICE__GetBits))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__GetDC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__GetDC

  HDC (*REAPERAPI_FUNCNAME(LICE__GetDC))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__GetHeight) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__GetHeight

  int (*REAPERAPI_FUNCNAME(LICE__GetHeight))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__GetRowSpan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__GetRowSpan

  int (*REAPERAPI_FUNCNAME(LICE__GetRowSpan))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__GetWidth) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__GetWidth

  int (*REAPERAPI_FUNCNAME(LICE__GetWidth))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__IsFlipped) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__IsFlipped

  bool (*REAPERAPI_FUNCNAME(LICE__IsFlipped))(LICE_IBitmap* bm);
#endif

#if defined(REAPERAPI_WANT_LICE__resize) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__resize

  bool (*REAPERAPI_FUNCNAME(LICE__resize))(LICE_IBitmap* bm, int w, int h);
#endif

#if defined(REAPERAPI_WANT_LICE__SetBkColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__SetBkColor

  LICE_pixel (*REAPERAPI_FUNCNAME(LICE__SetBkColor))(LICE_IFont* font, LICE_pixel color);
#endif

#if defined(REAPERAPI_WANT_LICE__SetFromHFont) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__SetFromHFont
// font must REMAIN valid,unless LICE_FONT_FLAG_PRECALCALL is set

  void (*REAPERAPI_FUNCNAME(LICE__SetFromHFont))(LICE_IFont* font, HFONT hfont, int flags);
#endif

#if defined(REAPERAPI_WANT_LICE__SetTextColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__SetTextColor

  LICE_pixel (*REAPERAPI_FUNCNAME(LICE__SetTextColor))(LICE_IFont* font, LICE_pixel color);
#endif

#if defined(REAPERAPI_WANT_LICE__SetTextCombineMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE__SetTextCombineMode

  void (*REAPERAPI_FUNCNAME(LICE__SetTextCombineMode))(LICE_IFont* ifont, int mode, float alpha);
#endif

#if defined(REAPERAPI_WANT_LICE_Arc) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Arc

  void (*REAPERAPI_FUNCNAME(LICE_Arc))(LICE_IBitmap* dest, float cx, float cy, float r, float minAngle, float maxAngle, LICE_pixel color, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_Blit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Blit

  void (*REAPERAPI_FUNCNAME(LICE_Blit))(LICE_IBitmap* dest, LICE_IBitmap* src, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_Blur) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Blur

  void (*REAPERAPI_FUNCNAME(LICE_Blur))(LICE_IBitmap* dest, LICE_IBitmap* src, int dstx, int dsty, int srcx, int srcy, int srcw, int srch);
#endif

#if defined(REAPERAPI_WANT_LICE_BorderedRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_BorderedRect

  void (*REAPERAPI_FUNCNAME(LICE_BorderedRect))(LICE_IBitmap* dest, int x, int y, int w, int h, LICE_pixel bgcolor, LICE_pixel fgcolor, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_Circle) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Circle

  void (*REAPERAPI_FUNCNAME(LICE_Circle))(LICE_IBitmap* dest, float cx, float cy, float r, LICE_pixel color, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_Clear) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Clear

  void (*REAPERAPI_FUNCNAME(LICE_Clear))(LICE_IBitmap* dest, LICE_pixel color);
#endif

#if defined(REAPERAPI_WANT_LICE_ClearRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_ClearRect

  void (*REAPERAPI_FUNCNAME(LICE_ClearRect))(LICE_IBitmap* dest, int x, int y, int w, int h, LICE_pixel mask, LICE_pixel orbits);
#endif

#if defined(REAPERAPI_WANT_LICE_ClipLine) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_ClipLine
// Returns false if the line is entirely offscreen.

  bool (*REAPERAPI_FUNCNAME(LICE_ClipLine))(int* pX1Out, int* pY1Out, int* pX2Out, int* pY2Out, int xLo, int yLo, int xHi, int yHi);
#endif

#if defined(REAPERAPI_WANT_LICE_CombinePixels) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_CombinePixels

  LICE_pixel (*REAPERAPI_FUNCNAME(LICE_CombinePixels))(LICE_pixel dest, LICE_pixel src, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_Copy) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Copy

  void (*REAPERAPI_FUNCNAME(LICE_Copy))(LICE_IBitmap* dest, LICE_IBitmap* src);
#endif

#if defined(REAPERAPI_WANT_LICE_CreateBitmap) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_CreateBitmap
// create a new bitmap. this is like calling new LICE_MemBitmap (mode=0) or new LICE_SysBitmap (mode=1).

  LICE_IBitmap* (*REAPERAPI_FUNCNAME(LICE_CreateBitmap))(int mode, int w, int h);
#endif

#if defined(REAPERAPI_WANT_LICE_CreateFont) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_CreateFont

  LICE_IFont* (*REAPERAPI_FUNCNAME(LICE_CreateFont))();
#endif

#if defined(REAPERAPI_WANT_LICE_DrawCBezier) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_DrawCBezier

  void (*REAPERAPI_FUNCNAME(LICE_DrawCBezier))(LICE_IBitmap* dest, double xstart, double ystart, double xctl1, double yctl1, double xctl2, double yctl2, double xend, double yend, LICE_pixel color, float alpha, int mode, bool aa, double tol);
#endif

#if defined(REAPERAPI_WANT_LICE_DrawChar) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_DrawChar

  void (*REAPERAPI_FUNCNAME(LICE_DrawChar))(LICE_IBitmap* bm, int x, int y, char c, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_DrawGlyph) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_DrawGlyph

  void (*REAPERAPI_FUNCNAME(LICE_DrawGlyph))(LICE_IBitmap* dest, int x, int y, LICE_pixel color, LICE_pixel_chan* alphas, int glyph_w, int glyph_h, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_DrawRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_DrawRect

  void (*REAPERAPI_FUNCNAME(LICE_DrawRect))(LICE_IBitmap* dest, int x, int y, int w, int h, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_DrawText) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_DrawText

  void (*REAPERAPI_FUNCNAME(LICE_DrawText))(LICE_IBitmap* bm, int x, int y, const char* string, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_FillCBezier) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillCBezier

  void (*REAPERAPI_FUNCNAME(LICE_FillCBezier))(LICE_IBitmap* dest, double xstart, double ystart, double xctl1, double yctl1, double xctl2, double yctl2, double xend, double yend, int yfill, LICE_pixel color, float alpha, int mode, bool aa, double tol);
#endif

#if defined(REAPERAPI_WANT_LICE_FillCircle) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillCircle

  void (*REAPERAPI_FUNCNAME(LICE_FillCircle))(LICE_IBitmap* dest, float cx, float cy, float r, LICE_pixel color, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_FillConvexPolygon) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillConvexPolygon

  void (*REAPERAPI_FUNCNAME(LICE_FillConvexPolygon))(LICE_IBitmap* dest, int* x, int* y, int npoints, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_FillRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillRect

  void (*REAPERAPI_FUNCNAME(LICE_FillRect))(LICE_IBitmap* dest, int x, int y, int w, int h, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_FillTrapezoid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillTrapezoid

  void (*REAPERAPI_FUNCNAME(LICE_FillTrapezoid))(LICE_IBitmap* dest, int x1a, int x1b, int y1, int x2a, int x2b, int y2, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_FillTriangle) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_FillTriangle

  void (*REAPERAPI_FUNCNAME(LICE_FillTriangle))(LICE_IBitmap* dest, int x1, int y1, int x2, int y2, int x3, int y3, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_GetPixel) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_GetPixel

  LICE_pixel (*REAPERAPI_FUNCNAME(LICE_GetPixel))(LICE_IBitmap* bm, int x, int y);
#endif

#if defined(REAPERAPI_WANT_LICE_GradRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_GradRect

  void (*REAPERAPI_FUNCNAME(LICE_GradRect))(LICE_IBitmap* dest, int dstx, int dsty, int dstw, int dsth, float ir, float ig, float ib, float ia, float drdx, float dgdx, float dbdx, float dadx, float drdy, float dgdy, float dbdy, float dady, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_Line) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_Line

  void (*REAPERAPI_FUNCNAME(LICE_Line))(LICE_IBitmap* dest, float x1, float y1, float x2, float y2, LICE_pixel color, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_LineInt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_LineInt

  void (*REAPERAPI_FUNCNAME(LICE_LineInt))(LICE_IBitmap* dest, int x1, int y1, int x2, int y2, LICE_pixel color, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_LoadPNG) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_LoadPNG

  LICE_IBitmap* (*REAPERAPI_FUNCNAME(LICE_LoadPNG))(const char* filename, LICE_IBitmap* bmp);
#endif

#if defined(REAPERAPI_WANT_LICE_LoadPNGFromResource) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_LoadPNGFromResource

  LICE_IBitmap* (*REAPERAPI_FUNCNAME(LICE_LoadPNGFromResource))(HINSTANCE hInst, const char* resid, LICE_IBitmap* bmp);
#endif

#if defined(REAPERAPI_WANT_LICE_MeasureText) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_MeasureText

  void (*REAPERAPI_FUNCNAME(LICE_MeasureText))(const char* string, int* w, int* h);
#endif

#if defined(REAPERAPI_WANT_LICE_MultiplyAddRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_MultiplyAddRect

  void (*REAPERAPI_FUNCNAME(LICE_MultiplyAddRect))(LICE_IBitmap* dest, int x, int y, int w, int h, float rsc, float gsc, float bsc, float asc, float radd, float gadd, float badd, float aadd);
#endif

#if defined(REAPERAPI_WANT_LICE_PutPixel) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_PutPixel

  void (*REAPERAPI_FUNCNAME(LICE_PutPixel))(LICE_IBitmap* bm, int x, int y, LICE_pixel color, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_RotatedBlit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_RotatedBlit
// these coordinates are offset from the center of the image,in source pixel coordinates

  void (*REAPERAPI_FUNCNAME(LICE_RotatedBlit))(LICE_IBitmap* dest, LICE_IBitmap* src, int dstx, int dsty, int dstw, int dsth, float srcx, float srcy, float srcw, float srch, float angle, bool cliptosourcerect, float alpha, int mode, float rotxcent, float rotycent);
#endif

#if defined(REAPERAPI_WANT_LICE_RoundRect) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_RoundRect

  void (*REAPERAPI_FUNCNAME(LICE_RoundRect))(LICE_IBitmap* drawbm, float xpos, float ypos, float w, float h, int cornerradius, LICE_pixel col, float alpha, int mode, bool aa);
#endif

#if defined(REAPERAPI_WANT_LICE_ScaledBlit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_ScaledBlit

  void (*REAPERAPI_FUNCNAME(LICE_ScaledBlit))(LICE_IBitmap* dest, LICE_IBitmap* src, int dstx, int dsty, int dstw, int dsth, float srcx, float srcy, float srcw, float srch, float alpha, int mode);
#endif

#if defined(REAPERAPI_WANT_LICE_SimpleFill) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_SimpleFill

  void (*REAPERAPI_FUNCNAME(LICE_SimpleFill))(LICE_IBitmap* dest, int x, int y, LICE_pixel newcolor, LICE_pixel comparemask, LICE_pixel keepmask);
#endif

#if defined(REAPERAPI_WANT_LICE_ThickFLine) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LICE_ThickFLine
// always AA. wid is not affected by scaling (1 is always normal line, 2 is always 2 physical pixels, etc)

  void (*REAPERAPI_FUNCNAME(LICE_ThickFLine))(LICE_IBitmap* dest, double x1, double y1, double x2, double y2, LICE_pixel color, float alpha, int mode, int wid);
#endif

#endif // !REAPERAPI_NO_LICE
#if defined(REAPERAPI_WANT_LocalizeString) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// LocalizeString
// Returns a localized version of src_string, in section section. flags can have 1 set to only localize if sprintf-style formatting matches the original.

  const char* (*REAPERAPI_FUNCNAME(LocalizeString))(const char* src_string, const char* section, int flagsOptional);
#endif

#if defined(REAPERAPI_WANT_Loop_OnArrow) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Loop_OnArrow
// Move the loop selection left or right. Returns true if snap is enabled.

  bool (*REAPERAPI_FUNCNAME(Loop_OnArrow))(ReaProject* project, int direction);
#endif

#if defined(REAPERAPI_WANT_Main_OnCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_OnCommand
// See Main_OnCommandEx.

  void (*REAPERAPI_FUNCNAME(Main_OnCommand))(int command, int flag);
#endif

#if defined(REAPERAPI_WANT_Main_OnCommandEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_OnCommandEx
// Performs an action belonging to the main action section. To perform non-native actions (ReaScripts, custom or extension plugins' actions) safely, see NamedCommandLookup().

  void (*REAPERAPI_FUNCNAME(Main_OnCommandEx))(int command, int flag, ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Main_openProject) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_openProject
// opens a project. will prompt the user to save unless name is prefixed with 'noprompt:'. If name is prefixed with 'template:', project file will be loaded as a template.
// If passed a .RTrackTemplate file, adds the template to the existing project.

  void (*REAPERAPI_FUNCNAME(Main_openProject))(const char* name);
#endif

#if defined(REAPERAPI_WANT_Main_SaveProject) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_SaveProject
// Save the project.

  void (*REAPERAPI_FUNCNAME(Main_SaveProject))(ReaProject* proj, bool forceSaveAsInOptional);
#endif

#if defined(REAPERAPI_WANT_Main_SaveProjectEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_SaveProjectEx
// Save the project. options: &1=save selected tracks as track template, &2=include media with track template, &4=include envelopes with track template, &8=if not saving template, set as the new project filename for this ReaProject. See Main_openProject, Main_SaveProject.

  void (*REAPERAPI_FUNCNAME(Main_SaveProjectEx))(ReaProject* proj, const char* filename, int options);
#endif

#if defined(REAPERAPI_WANT_Main_UpdateLoopInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Main_UpdateLoopInfo

  void (*REAPERAPI_FUNCNAME(Main_UpdateLoopInfo))(int ignoremask);
#endif

#if defined(REAPERAPI_WANT_MarkProjectDirty) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MarkProjectDirty
// Marks project as dirty (needing save) if 'undo/prompt to save' is enabled in preferences.

  void (*REAPERAPI_FUNCNAME(MarkProjectDirty))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_MarkTrackItemsDirty) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MarkTrackItemsDirty
// If track is supplied, item is ignored

  void (*REAPERAPI_FUNCNAME(MarkTrackItemsDirty))(MediaTrack* track, MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_Master_GetPlayRate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Master_GetPlayRate

  double (*REAPERAPI_FUNCNAME(Master_GetPlayRate))(ReaProject* project);
#endif

#if defined(REAPERAPI_WANT_Master_GetPlayRateAtTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Master_GetPlayRateAtTime

  double (*REAPERAPI_FUNCNAME(Master_GetPlayRateAtTime))(double time_s, ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Master_GetTempo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Master_GetTempo

  double (*REAPERAPI_FUNCNAME(Master_GetTempo))();
#endif

#if defined(REAPERAPI_WANT_Master_NormalizePlayRate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Master_NormalizePlayRate
// Convert play rate to/from a value between 0 and 1, representing the position on the project playrate slider.

  double (*REAPERAPI_FUNCNAME(Master_NormalizePlayRate))(double playrate, bool isnormalized);
#endif

#if defined(REAPERAPI_WANT_Master_NormalizeTempo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Master_NormalizeTempo
// Convert the tempo to/from a value between 0 and 1, representing bpm in the range of 40-296 bpm.

  double (*REAPERAPI_FUNCNAME(Master_NormalizeTempo))(double bpm, bool isnormalized);
#endif

#if defined(REAPERAPI_WANT_MB) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MB
// type 0=OK,1=OKCANCEL,2=ABORTRETRYIGNORE,3=YESNOCANCEL,4=YESNO,5=RETRYCANCEL : ret 1=OK,2=CANCEL,3=ABORT,4=RETRY,5=IGNORE,6=YES,7=NO

  int (*REAPERAPI_FUNCNAME(MB))(const char* msg, const char* title, int type);
#endif

#if defined(REAPERAPI_WANT_MediaExplorerGetLastPlayedFileInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MediaExplorerGetLastPlayedFileInfo
// Get information about the most recently previewed Media Explorer file. filename: last played file name. filemode: &1:insert on new track, &2:insert into sampler, &8:tempo sync 1x, &16:tempo sync 0.5x, &32:tempo sync 2x, &64:do not preserve pitch when changing playrate, &128:loop selection exists, &256:time selection exists, &512:apply pitch/rate adjustment on insert, &1024:apply volume adjustment on insert, &2048:apply normalization on insert, &8192:reverse preview. startpct/endpct: time selection in [0.0, 1.0]. pitchshift/voladj/rateadj: current pitch/volume/playrate preview adjustments. srcbpm: source media tempo. extrainfo: currently unused.

  bool (*REAPERAPI_FUNCNAME(MediaExplorerGetLastPlayedFileInfo))(char* filenameOut, int filenameOut_sz, int* filemodeOut, double* selstartOut, double* selendOut, double* pitchshiftOut, double* voladjOut, double* rateadjOut, double* sourcebpmOut, char* extrainfoOut, int extrainfoOut_sz);
#endif

#if defined(REAPERAPI_WANT_MediaItemDescendsFromTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MediaItemDescendsFromTrack
// Returns 1 if the track holds the item, 2 if the track is a folder containing the track that holds the item, etc.

  int (*REAPERAPI_FUNCNAME(MediaItemDescendsFromTrack))(MediaItem* item, MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_Menu_GetHash) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Menu_GetHash
// Get a string that only changes when menu/toolbar entries are added or removed (not re-ordered). Can be used to determine if a customized menu/toolbar differs from the default, or if the default changed after a menu/toolbar was customized. flag==0: current default menu/toolbar; flag==1: current customized menu/toolbar; flag==2: default menu/toolbar at the time the current menu/toolbar was most recently customized, if it was customized in REAPER v7.08 or later.

  bool (*REAPERAPI_FUNCNAME(Menu_GetHash))(const char* menuname, int flag, char* hashOut, int hashOut_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_CountEvts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_CountEvts
// Count the number of notes, CC events, and text/sysex events in a given MIDI item.

  int (*REAPERAPI_FUNCNAME(MIDI_CountEvts))(MediaItem_Take* take, int* notecntOut, int* ccevtcntOut, int* textsyxevtcntOut);
#endif

#if defined(REAPERAPI_WANT_MIDI_DeleteCC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_DeleteCC
// Delete a MIDI CC event.

  bool (*REAPERAPI_FUNCNAME(MIDI_DeleteCC))(MediaItem_Take* take, int ccidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_DeleteEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_DeleteEvt
// Delete a MIDI event.

  bool (*REAPERAPI_FUNCNAME(MIDI_DeleteEvt))(MediaItem_Take* take, int evtidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_DeleteNote) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_DeleteNote
// Delete a MIDI note.

  bool (*REAPERAPI_FUNCNAME(MIDI_DeleteNote))(MediaItem_Take* take, int noteidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_DeleteTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_DeleteTextSysexEvt
// Delete a MIDI text or sysex event.

  bool (*REAPERAPI_FUNCNAME(MIDI_DeleteTextSysexEvt))(MediaItem_Take* take, int textsyxevtidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_DisableSort) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_DisableSort
// Disable sorting for all MIDI insert, delete, get and set functions, until MIDI_Sort is called.

  void (*REAPERAPI_FUNCNAME(MIDI_DisableSort))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_MIDI_EnumSelCC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_EnumSelCC
// Returns the index of the next selected MIDI CC event after ccidx (-1 if there are no more selected events).

  int (*REAPERAPI_FUNCNAME(MIDI_EnumSelCC))(MediaItem_Take* take, int ccidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_EnumSelEvts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_EnumSelEvts
// Returns the index of the next selected MIDI event after evtidx (-1 if there are no more selected events).

  int (*REAPERAPI_FUNCNAME(MIDI_EnumSelEvts))(MediaItem_Take* take, int evtidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_EnumSelNotes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_EnumSelNotes
// Returns the index of the next selected MIDI note after noteidx (-1 if there are no more selected events).

  int (*REAPERAPI_FUNCNAME(MIDI_EnumSelNotes))(MediaItem_Take* take, int noteidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_EnumSelTextSysexEvts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_EnumSelTextSysexEvts
// Returns the index of the next selected MIDI text/sysex event after textsyxidx (-1 if there are no more selected events).

  int (*REAPERAPI_FUNCNAME(MIDI_EnumSelTextSysexEvts))(MediaItem_Take* take, int textsyxidx);
#endif

#if defined(REAPERAPI_WANT_MIDI_eventlist_Create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_eventlist_Create
// Create a MIDI_eventlist object. The returned object must be deleted with MIDI_eventlist_destroy().

  MIDI_eventlist* (*REAPERAPI_FUNCNAME(MIDI_eventlist_Create))();
#endif

#if defined(REAPERAPI_WANT_MIDI_eventlist_Destroy) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_eventlist_Destroy
// Destroy a MIDI_eventlist object that was created using MIDI_eventlist_Create().

  void (*REAPERAPI_FUNCNAME(MIDI_eventlist_Destroy))(MIDI_eventlist* evtlist);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetAllEvts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetAllEvts
// Get all MIDI data. MIDI buffer is returned as a list of { int offset, char flag, int msglen, unsigned char msg[] }.
// offset: MIDI ticks from previous event
// flag: &1=selected &2=muted
// flag high 4 bits for CC shape: &16=linear, &32=slow start/end, &16|32=fast start, &64=fast end, &64|16=bezier
// msg: the MIDI message.
// A meta-event of type 0xF followed by 'CCBZ ' and 5 more bytes represents bezier curve data for the previous MIDI event: 1 byte for the bezier type (usually 0) and 4 bytes for the bezier tension as a float.
// For tick intervals longer than a 32 bit word can represent, zero-length meta events may be placed between valid events.
// See MIDI_SetAllEvts.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetAllEvts))(MediaItem_Take* take, char* bufOutNeedBig, int* bufOutNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetCC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetCC
// Get MIDI CC event properties.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetCC))(MediaItem_Take* take, int ccidx, bool* selectedOut, bool* mutedOut, double* ppqposOut, int* chanmsgOut, int* chanOut, int* msg2Out, int* msg3Out);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetCCShape) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetCCShape
// Get CC shape and bezier tension. See MIDI_GetCC, MIDI_SetCCShape

  bool (*REAPERAPI_FUNCNAME(MIDI_GetCCShape))(MediaItem_Take* take, int ccidx, int* shapeOut, double* beztensionOut);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetEvt
// Get MIDI event properties.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetEvt))(MediaItem_Take* take, int evtidx, bool* selectedOut, bool* mutedOut, double* ppqposOut, char* msgOut, int* msgOut_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetGrid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetGrid
// Returns the most recent MIDI editor grid size for this MIDI take, in QN. Swing is between 0 and 1. Note length is 0 if it follows the grid size.

  double (*REAPERAPI_FUNCNAME(MIDI_GetGrid))(MediaItem_Take* take, double* swingOutOptional, double* noteLenOutOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetHash) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetHash
// Get a string that only changes when the MIDI data changes. If notesonly==true, then the string changes only when the MIDI notes change. See MIDI_GetTrackHash

  bool (*REAPERAPI_FUNCNAME(MIDI_GetHash))(MediaItem_Take* take, bool notesonly, char* hashOut, int hashOut_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetNote) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetNote
// Get MIDI note properties.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetNote))(MediaItem_Take* take, int noteidx, bool* selectedOut, bool* mutedOut, double* startppqposOut, double* endppqposOut, int* chanOut, int* pitchOut, int* velOut);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetPPQPos_EndOfMeasure) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetPPQPos_EndOfMeasure
// Returns the MIDI tick (ppq) position corresponding to the end of the measure.

  double (*REAPERAPI_FUNCNAME(MIDI_GetPPQPos_EndOfMeasure))(MediaItem_Take* take, double ppqpos);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetPPQPos_StartOfMeasure) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetPPQPos_StartOfMeasure
// Returns the MIDI tick (ppq) position corresponding to the start of the measure.

  double (*REAPERAPI_FUNCNAME(MIDI_GetPPQPos_StartOfMeasure))(MediaItem_Take* take, double ppqpos);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetPPQPosFromProjQN) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetPPQPosFromProjQN
// Returns the MIDI tick (ppq) position corresponding to a specific project time in quarter notes.

  double (*REAPERAPI_FUNCNAME(MIDI_GetPPQPosFromProjQN))(MediaItem_Take* take, double projqn);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetPPQPosFromProjTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetPPQPosFromProjTime
// Returns the MIDI tick (ppq) position corresponding to a specific project time in seconds.

  double (*REAPERAPI_FUNCNAME(MIDI_GetPPQPosFromProjTime))(MediaItem_Take* take, double projtime);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetProjQNFromPPQPos) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetProjQNFromPPQPos
// Returns the project time in quarter notes corresponding to a specific MIDI tick (ppq) position.

  double (*REAPERAPI_FUNCNAME(MIDI_GetProjQNFromPPQPos))(MediaItem_Take* take, double ppqpos);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetProjTimeFromPPQPos) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetProjTimeFromPPQPos
// Returns the project time in seconds corresponding to a specific MIDI tick (ppq) position.

  double (*REAPERAPI_FUNCNAME(MIDI_GetProjTimeFromPPQPos))(MediaItem_Take* take, double ppqpos);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetRecentInputEvent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetRecentInputEvent
// Gets a recent MIDI input event from the global history. idx=0 for the most recent event, which also latches to the latest MIDI event state (to get a more recent list, calling with idx=0 is necessary). idx=1 next most recent event, returns a non-zero sequence number for the event, or zero if no more events. tsOut will be set to the timestamp in samples relative to the current position (0 is current, -48000 is one second ago, etc). devIdxOut will have the low 16 bits set to the input device index, and 0x10000 will be set if device was enabled only for control. projPosOut will be set to project position in seconds if project was playing back at time of event, otherwise -1. Large SysEx events will not be included in this event list.

  int (*REAPERAPI_FUNCNAME(MIDI_GetRecentInputEvent))(int idx, char* bufOut, int* bufOut_sz, int* tsOut, int* devIdxOut, double* projPosOut, int* projLoopCntOut);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetScale) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetScale
// Get the active scale in the media source, if any. root 0=C, 1=C#, etc. scale &0x1=root, &0x2=minor 2nd, &0x4=major 2nd, &0x8=minor 3rd, &0xF=fourth, etc.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetScale))(MediaItem_Take* take, int* rootOut, int* scaleOut, char* nameOut, int nameOut_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetTextSysexEvt
// Get MIDI meta-event properties. Allowable types are -1:sysex (msg should not include bounding F0..F7), 1-14:MIDI text event types, 15=REAPER notation event. For all other meta-messages, type is returned as -2 and msg returned as all zeroes. See MIDI_GetEvt.

  bool (*REAPERAPI_FUNCNAME(MIDI_GetTextSysexEvt))(MediaItem_Take* take, int textsyxevtidx, bool* selectedOutOptional, bool* mutedOutOptional, double* ppqposOutOptional, int* typeOutOptional, char* msgOptional, int* msgOptional_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_GetTrackHash) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_GetTrackHash
// Get a string that only changes when the MIDI data changes. If notesonly==true, then the string changes only when the MIDI notes change. See MIDI_GetHash

  bool (*REAPERAPI_FUNCNAME(MIDI_GetTrackHash))(MediaTrack* track, bool notesonly, char* hashOut, int hashOut_sz);
#endif

#if defined(REAPERAPI_WANT_midi_init) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// midi_init
// Opens MIDI devices as configured in preferences. force_reinit_input and force_reinit_output force a particular device index to close/re-open (pass -1 to not force any devices to reopen).

  void (*REAPERAPI_FUNCNAME(midi_init))(int force_reinit_input, int force_reinit_output);
#endif

#if defined(REAPERAPI_WANT_MIDI_InsertCC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_InsertCC
// Insert a new MIDI CC event.

  bool (*REAPERAPI_FUNCNAME(MIDI_InsertCC))(MediaItem_Take* take, bool selected, bool muted, double ppqpos, int chanmsg, int chan, int msg2, int msg3);
#endif

#if defined(REAPERAPI_WANT_MIDI_InsertEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_InsertEvt
// Insert a new MIDI event.

  bool (*REAPERAPI_FUNCNAME(MIDI_InsertEvt))(MediaItem_Take* take, bool selected, bool muted, double ppqpos, const char* bytestr, int bytestr_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_InsertNote) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_InsertNote
// Insert a new MIDI note. Set noSort if inserting multiple events, then call MIDI_Sort when done.

  bool (*REAPERAPI_FUNCNAME(MIDI_InsertNote))(MediaItem_Take* take, bool selected, bool muted, double startppqpos, double endppqpos, int chan, int pitch, int vel, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_InsertTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_InsertTextSysexEvt
// Insert a new MIDI text or sysex event. Allowable types are -1:sysex (msg should not include bounding F0..F7), 1-14:MIDI text event types, 15=REAPER notation event.

  bool (*REAPERAPI_FUNCNAME(MIDI_InsertTextSysexEvt))(MediaItem_Take* take, bool selected, bool muted, double ppqpos, int type, const char* bytestr, int bytestr_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_RefreshEditors) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_RefreshEditors
// Synchronously updates any open MIDI editors for MIDI take

  void (*REAPERAPI_FUNCNAME(MIDI_RefreshEditors))(MediaItem_Take* tk);
#endif

#if defined(REAPERAPI_WANT_midi_reinit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// midi_reinit
// Reset (close and re-open) all MIDI devices

  void (*REAPERAPI_FUNCNAME(midi_reinit))();
#endif

#if defined(REAPERAPI_WANT_MIDI_SelectAll) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SelectAll
// Select or deselect all MIDI content.

  void (*REAPERAPI_FUNCNAME(MIDI_SelectAll))(MediaItem_Take* take, bool select);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetAllEvts) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetAllEvts
// Set all MIDI data. MIDI buffer is passed in as a list of { int offset, char flag, int msglen, unsigned char msg[] }.
// offset: MIDI ticks from previous event
// flag: &1=selected &2=muted
// flag high 4 bits for CC shape: &16=linear, &32=slow start/end, &16|32=fast start, &64=fast end, &64|16=bezier
// msg: the MIDI message.
// A meta-event of type 0xF followed by 'CCBZ ' and 5 more bytes represents bezier curve data for the previous MIDI event: 1 byte for the bezier type (usually 0) and 4 bytes for the bezier tension as a float.
// For tick intervals longer than a 32 bit word can represent, zero-length meta events may be placed between valid events.
// See MIDI_GetAllEvts.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetAllEvts))(MediaItem_Take* take, const char* buf, int buf_sz);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetCC) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetCC
// Set MIDI CC event properties. Properties passed as NULL will not be set. set noSort if setting multiple events, then call MIDI_Sort when done.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetCC))(MediaItem_Take* take, int ccidx, const bool* selectedInOptional, const bool* mutedInOptional, const double* ppqposInOptional, const int* chanmsgInOptional, const int* chanInOptional, const int* msg2InOptional, const int* msg3InOptional, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetCCShape) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetCCShape
// Set CC shape and bezier tension. set noSort if setting multiple events, then call MIDI_Sort when done. See MIDI_SetCC, MIDI_GetCCShape

  bool (*REAPERAPI_FUNCNAME(MIDI_SetCCShape))(MediaItem_Take* take, int ccidx, int shape, double beztension, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetEvt
// Set MIDI event properties. Properties passed as NULL will not be set.  set noSort if setting multiple events, then call MIDI_Sort when done.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetEvt))(MediaItem_Take* take, int evtidx, const bool* selectedInOptional, const bool* mutedInOptional, const double* ppqposInOptional, const char* msgOptional, int msgOptional_sz, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetItemExtents) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetItemExtents
// Set the start/end positions of a media item that contains a MIDI take.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetItemExtents))(MediaItem* item, double startQN, double endQN);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetNote) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetNote
// Set MIDI note properties. Properties passed as NULL (or negative values) will not be set. Set noSort if setting multiple events, then call MIDI_Sort when done. Setting multiple note start positions at once is done more safely by deleting and re-inserting the notes.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetNote))(MediaItem_Take* take, int noteidx, const bool* selectedInOptional, const bool* mutedInOptional, const double* startppqposInOptional, const double* endppqposInOptional, const int* chanInOptional, const int* pitchInOptional, const int* velInOptional, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_SetTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_SetTextSysexEvt
// Set MIDI text or sysex event properties. Properties passed as NULL will not be set. Allowable types are -1:sysex (msg should not include bounding F0..F7), 1-14:MIDI text event types, 15=REAPER notation event. set noSort if setting multiple events, then call MIDI_Sort when done.

  bool (*REAPERAPI_FUNCNAME(MIDI_SetTextSysexEvt))(MediaItem_Take* take, int textsyxevtidx, const bool* selectedInOptional, const bool* mutedInOptional, const double* ppqposInOptional, const int* typeInOptional, const char* msgOptional, int msgOptional_sz, const bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_MIDI_Sort) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDI_Sort
// Sort MIDI events after multiple calls to MIDI_SetNote, MIDI_SetCC, etc.

  void (*REAPERAPI_FUNCNAME(MIDI_Sort))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_EnumTakes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_EnumTakes
// list the takes that are currently being edited in this MIDI editor, starting with the active take. See MIDIEditor_GetTake

  MediaItem_Take* (*REAPERAPI_FUNCNAME(MIDIEditor_EnumTakes))(HWND midieditor, int takeindex, bool editable_only);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_GetActive) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_GetActive
// get a pointer to the focused MIDI editor window
// see MIDIEditor_GetMode, MIDIEditor_OnCommand

  HWND (*REAPERAPI_FUNCNAME(MIDIEditor_GetActive))();
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_GetMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_GetMode
// get the mode of a MIDI editor (0=piano roll, 1=event list, -1=invalid editor)
// see MIDIEditor_GetActive, MIDIEditor_OnCommand

  int (*REAPERAPI_FUNCNAME(MIDIEditor_GetMode))(HWND midieditor);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_GetSetting_int) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_GetSetting_int
// Get settings from a MIDI editor. setting_desc can be:
// snap_enabled: returns 0 or 1
// active_note_row: returns 0-127
// last_clicked_cc_lane: returns 0-127=CC, 0x100|(0-31)=14-bit CC, 0x200=velocity, 0x201=pitch, 0x202=program, 0x203=channel pressure, 0x204=bank/program select, 0x205=text, 0x206=sysex, 0x207=off velocity, 0x208=notation events, 0x209=aftertouch, 0x210=media item lane
// default_note_vel: returns 0-127
// default_note_chan: returns 0-15
// default_note_len: returns default length in MIDI ticks
// scale_enabled: returns 0-1
// scale_root: returns 0-12 (0=C)
// list_cnt: if viewing list view, returns event count
// if setting_desc is unsupported, the function returns -1.
// See MIDIEditor_SetSetting_int, MIDIEditor_GetActive, MIDIEditor_GetSetting_str
// 

  int (*REAPERAPI_FUNCNAME(MIDIEditor_GetSetting_int))(HWND midieditor, const char* setting_desc);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_GetSetting_str) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_GetSetting_str
// Get settings from a MIDI editor. setting_desc can be:
// last_clicked_cc_lane: returns text description ("velocity", "pitch", etc)
// scale: returns the scale record, for example "102034050607" for a major scale
// list_X: if viewing list view, returns string describing event at row X (0-based). String will have a list of key=value pairs, e.g. 'pos=4.0 len=4.0 offvel=127 msg=90317F'. pos/len times are in QN, len/offvel may not be present if event is not a note. other keys which may be present include pos_pq/len_pq, sel, mute, ccval14, ccshape, ccbeztension.
// if setting_desc is unsupported, the function returns false.
// See MIDIEditor_GetActive, MIDIEditor_GetSetting_int
// 

  bool (*REAPERAPI_FUNCNAME(MIDIEditor_GetSetting_str))(HWND midieditor, const char* setting_desc, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_GetTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_GetTake
// get the take that is currently being edited in this MIDI editor. see MIDIEditor_EnumTakes

  MediaItem_Take* (*REAPERAPI_FUNCNAME(MIDIEditor_GetTake))(HWND midieditor);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_LastFocused_OnCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_LastFocused_OnCommand
// Send an action command to the last focused MIDI editor. Returns false if there is no MIDI editor open, or if the view mode (piano roll or event list) does not match the input.
// see MIDIEditor_OnCommand

  bool (*REAPERAPI_FUNCNAME(MIDIEditor_LastFocused_OnCommand))(int command_id, bool islistviewcommand);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_OnCommand) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_OnCommand
// Send an action command to a MIDI editor. Returns false if the supplied MIDI editor pointer is not valid (not an open MIDI editor).
// see MIDIEditor_GetActive, MIDIEditor_LastFocused_OnCommand

  bool (*REAPERAPI_FUNCNAME(MIDIEditor_OnCommand))(HWND midieditor, int command_id);
#endif

#if defined(REAPERAPI_WANT_MIDIEditor_SetSetting_int) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditor_SetSetting_int
// Set settings for a MIDI editor. setting_desc can be:
// active_note_row: 0-127
// See MIDIEditor_GetSetting_int
// 

  bool (*REAPERAPI_FUNCNAME(MIDIEditor_SetSetting_int))(HWND midieditor, const char* setting_desc, int setting);
#endif

#if defined(REAPERAPI_WANT_MIDIEditorFlagsForTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MIDIEditorFlagsForTrack
// Get or set MIDI editor settings for this track. pitchwheelrange: semitones up or down. flags &1: snap pitch lane edits to semitones if pitchwheel range is defined.

  void (*REAPERAPI_FUNCNAME(MIDIEditorFlagsForTrack))(MediaTrack* track, int* pitchwheelrangeInOut, int* flagsInOut, bool is_set);
#endif

#if defined(REAPERAPI_WANT_mkpanstr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// mkpanstr

  void (*REAPERAPI_FUNCNAME(mkpanstr))(char* strNeed64, double pan);
#endif

#if defined(REAPERAPI_WANT_mkvolpanstr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// mkvolpanstr

  void (*REAPERAPI_FUNCNAME(mkvolpanstr))(char* strNeed64, double vol, double pan);
#endif

#if defined(REAPERAPI_WANT_mkvolstr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// mkvolstr

  void (*REAPERAPI_FUNCNAME(mkvolstr))(char* strNeed64, double vol);
#endif

#if defined(REAPERAPI_WANT_MoveEditCursor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MoveEditCursor

  void (*REAPERAPI_FUNCNAME(MoveEditCursor))(double adjamt, bool dosel);
#endif

#if defined(REAPERAPI_WANT_MoveMediaItemToTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MoveMediaItemToTrack
// returns TRUE if move succeeded

  bool (*REAPERAPI_FUNCNAME(MoveMediaItemToTrack))(MediaItem* item, MediaTrack* desttr);
#endif

#if defined(REAPERAPI_WANT_MuteAllTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// MuteAllTracks

  void (*REAPERAPI_FUNCNAME(MuteAllTracks))(bool mute);
#endif

#if defined(REAPERAPI_WANT_my_getViewport) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// my_getViewport

  void (*REAPERAPI_FUNCNAME(my_getViewport))(RECT* r, const RECT* sr, bool wantWorkArea);
#endif

#if defined(REAPERAPI_WANT_NamedCommandLookup) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// NamedCommandLookup
// Get the command ID number for named command that was registered by an extension such as "_SWS_ABOUT" or "_113088d11ae641c193a2b7ede3041ad5" for a ReaScript or a custom action.

  int (*REAPERAPI_FUNCNAME(NamedCommandLookup))(const char* command_name);
#endif

#if defined(REAPERAPI_WANT_OnPauseButton) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnPauseButton
// direct way to simulate pause button hit

  void (*REAPERAPI_FUNCNAME(OnPauseButton))();
#endif

#if defined(REAPERAPI_WANT_OnPauseButtonEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnPauseButtonEx
// direct way to simulate pause button hit

  void (*REAPERAPI_FUNCNAME(OnPauseButtonEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_OnPlayButton) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnPlayButton
// direct way to simulate play button hit

  void (*REAPERAPI_FUNCNAME(OnPlayButton))();
#endif

#if defined(REAPERAPI_WANT_OnPlayButtonEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnPlayButtonEx
// direct way to simulate play button hit

  void (*REAPERAPI_FUNCNAME(OnPlayButtonEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_OnStopButton) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnStopButton
// direct way to simulate stop button hit

  void (*REAPERAPI_FUNCNAME(OnStopButton))();
#endif

#if defined(REAPERAPI_WANT_OnStopButtonEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OnStopButtonEx
// direct way to simulate stop button hit

  void (*REAPERAPI_FUNCNAME(OnStopButtonEx))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_OpenColorThemeFile) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OpenColorThemeFile

  bool (*REAPERAPI_FUNCNAME(OpenColorThemeFile))(const char* fn);
#endif

#if defined(REAPERAPI_WANT_OpenMediaExplorer) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OpenMediaExplorer
// Opens mediafn in the Media Explorer, play=true will play the file immediately (or toggle playback if mediafn was already open), =false will just select it.

  HWND (*REAPERAPI_FUNCNAME(OpenMediaExplorer))(const char* mediafn, bool play);
#endif

#if defined(REAPERAPI_WANT_OscLocalMessageToHost) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// OscLocalMessageToHost
// Send an OSC message directly to REAPER. The value argument may be NULL. The message will be matched against the default OSC patterns.

  void (*REAPERAPI_FUNCNAME(OscLocalMessageToHost))(const char* message, const double* valueInOptional);
#endif

#if defined(REAPERAPI_WANT_parse_timestr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// parse_timestr
// Parse hh:mm:ss.sss time string, return time in seconds (or 0.0 on error). See parse_timestr_pos, parse_timestr_len.

  double (*REAPERAPI_FUNCNAME(parse_timestr))(const char* buf);
#endif

#if defined(REAPERAPI_WANT_parse_timestr_len) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// parse_timestr_len
// time formatting mode overrides: -1=proj default.
// 0=time
// 1=measures.beats + time
// 2=measures.beats
// 3=seconds
// 4=samples
// 5=h:m:s:f
// 

  double (*REAPERAPI_FUNCNAME(parse_timestr_len))(const char* buf, double offset, int modeoverride);
#endif

#if defined(REAPERAPI_WANT_parse_timestr_pos) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// parse_timestr_pos
// Parse time string, time formatting mode overrides: -1=proj default.
// 0=time
// 1=measures.beats + time
// 2=measures.beats
// 3=seconds
// 4=samples
// 5=h:m:s:f
// 

  double (*REAPERAPI_FUNCNAME(parse_timestr_pos))(const char* buf, int modeoverride);
#endif

#if defined(REAPERAPI_WANT_parsepanstr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// parsepanstr

  double (*REAPERAPI_FUNCNAME(parsepanstr))(const char* str);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_Create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_Create

  PCM_sink* (*REAPERAPI_FUNCNAME(PCM_Sink_Create))(const char* filename, const char* cfg, int cfg_sz, int nch, int srate, bool buildpeaks);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_CreateEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_CreateEx

  PCM_sink* (*REAPERAPI_FUNCNAME(PCM_Sink_CreateEx))(ReaProject* proj, const char* filename, const char* cfg, int cfg_sz, int nch, int srate, bool buildpeaks);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_CreateMIDIFile) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_CreateMIDIFile

  PCM_sink* (*REAPERAPI_FUNCNAME(PCM_Sink_CreateMIDIFile))(const char* filename, const char* cfg, int cfg_sz, double bpm, int div);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_CreateMIDIFileEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_CreateMIDIFileEx

  PCM_sink* (*REAPERAPI_FUNCNAME(PCM_Sink_CreateMIDIFileEx))(ReaProject* proj, const char* filename, const char* cfg, int cfg_sz, double bpm, int div);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_Enum) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_Enum

  unsigned int (*REAPERAPI_FUNCNAME(PCM_Sink_Enum))(int idx, const char** descstrOut);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_GetExtension) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_GetExtension

  const char* (*REAPERAPI_FUNCNAME(PCM_Sink_GetExtension))(const char* data, int data_sz);
#endif

#if defined(REAPERAPI_WANT_PCM_Sink_ShowConfig) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Sink_ShowConfig

  HWND (*REAPERAPI_FUNCNAME(PCM_Sink_ShowConfig))(const char* cfg, int cfg_sz, HWND hwndParent);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_BuildPeaks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_BuildPeaks
// Calls and returns PCM_source::PeaksBuild_Begin() if mode=0, PeaksBuild_Run() if mode=1, and PeaksBuild_Finish() if mode=2. Normal use is to call PCM_Source_BuildPeaks(src,0), and if that returns nonzero, call PCM_Source_BuildPeaks(src,1) periodically until it returns zero (it returns the percentage of the file remaining), then call PCM_Source_BuildPeaks(src,2) to finalize. If PCM_Source_BuildPeaks(src,0) returns zero, then no further action is necessary.

  int (*REAPERAPI_FUNCNAME(PCM_Source_BuildPeaks))(PCM_source* src, int mode);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_CreateFromFile) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_CreateFromFile
// See PCM_Source_CreateFromFileEx.

  PCM_source* (*REAPERAPI_FUNCNAME(PCM_Source_CreateFromFile))(const char* filename);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_CreateFromFileEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_CreateFromFileEx
// Create a PCM_source from filename, and override pref of MIDI files being imported as in-project MIDI events.

  PCM_source* (*REAPERAPI_FUNCNAME(PCM_Source_CreateFromFileEx))(const char* filename, bool forcenoMidiImp);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_CreateFromSimple) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_CreateFromSimple
// Creates a PCM_source from a ISimpleMediaDecoder
// (if fn is non-null, it will open the file in dec)

  PCM_source* (*REAPERAPI_FUNCNAME(PCM_Source_CreateFromSimple))(ISimpleMediaDecoder* dec, const char* fn);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_CreateFromType) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_CreateFromType
// Create a PCM_source from a "type" (use this if you're going to load its state via LoadState/ProjectStateContext).
// Valid types include "WAVE", "MIDI", or whatever plug-ins define as well.

  PCM_source* (*REAPERAPI_FUNCNAME(PCM_Source_CreateFromType))(const char* sourcetype);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_Destroy) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_Destroy
// Deletes a PCM_source -- be sure that you remove any project reference before deleting a source

  void (*REAPERAPI_FUNCNAME(PCM_Source_Destroy))(PCM_source* src);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_GetPeaks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_GetPeaks
// Gets block of peak samples to buf. Note that the peak samples are interleaved, but in two or three blocks (maximums, then minimums, then extra). Return value has 20 bits of returned sample count, then 4 bits of output_mode (0xf00000), then a bit to signify whether extra_type was available (0x1000000). extra_type can be 115 ('s') for spectral information, which will return peak samples as integers with the low 15 bits frequency, next 14 bits tonality.

  int (*REAPERAPI_FUNCNAME(PCM_Source_GetPeaks))(PCM_source* src, double peakrate, double starttime, int numchannels, int numsamplesperchannel, int want_extra_type, double* buf);
#endif

#if defined(REAPERAPI_WANT_PCM_Source_GetSectionInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PCM_Source_GetSectionInfo
// If a section/reverse block, retrieves offset/len/reverse. return true if success

  bool (*REAPERAPI_FUNCNAME(PCM_Source_GetSectionInfo))(PCM_source* src, double* offsOut, double* lenOut, bool* revOut);
#endif

#if defined(REAPERAPI_WANT_PeakBuild_Create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PeakBuild_Create

  REAPER_PeakBuild_Interface* (*REAPERAPI_FUNCNAME(PeakBuild_Create))(PCM_source* src, const char* fn, int srate, int nch);
#endif

#if defined(REAPERAPI_WANT_PeakBuild_CreateEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PeakBuild_CreateEx
// flags&1 for FP support

  REAPER_PeakBuild_Interface* (*REAPERAPI_FUNCNAME(PeakBuild_CreateEx))(PCM_source* src, const char* fn, int srate, int nch, int flags);
#endif

#if defined(REAPERAPI_WANT_PeakGet_Create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PeakGet_Create

  REAPER_PeakGet_Interface* (*REAPERAPI_FUNCNAME(PeakGet_Create))(const char* fn, int srate, int nch);
#endif

#if defined(REAPERAPI_WANT_PitchShiftSubModeMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PitchShiftSubModeMenu
// menu to select/modify pitch shifter submode, returns new value (or old value if no item selected)

  int (*REAPERAPI_FUNCNAME(PitchShiftSubModeMenu))(HWND hwnd, int x, int y, int mode, int submode_sel);
#endif

#if defined(REAPERAPI_WANT_PlayPreview) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PlayPreview
// return nonzero on success

  int (*REAPERAPI_FUNCNAME(PlayPreview))(preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_PlayPreviewEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PlayPreviewEx
// return nonzero on success. bufflags &1=buffer source, &2=treat length changes in source as varispeed and adjust internal state accordingly if buffering. measure_align<0=play immediately, >0=align playback with measure start

  int (*REAPERAPI_FUNCNAME(PlayPreviewEx))(preview_register_t* preview, int bufflags, double measure_align);
#endif

#if defined(REAPERAPI_WANT_PlayTrackPreview) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PlayTrackPreview
// return nonzero on success,in these,m_out_chan is a track index (0-n)

  int (*REAPERAPI_FUNCNAME(PlayTrackPreview))(preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_PlayTrackPreview2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PlayTrackPreview2
// return nonzero on success,in these,m_out_chan is a track index (0-n)

  int (*REAPERAPI_FUNCNAME(PlayTrackPreview2))(ReaProject* proj, preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_PlayTrackPreview2Ex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PlayTrackPreview2Ex
// return nonzero on success,in these,m_out_chan is a track index (0-n). see PlayPreviewEx

  int (*REAPERAPI_FUNCNAME(PlayTrackPreview2Ex))(ReaProject* proj, preview_register_t* preview, int flags, double measure_align);
#endif

#if defined(REAPERAPI_WANT_plugin_getapi) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// plugin_getapi

  void* (*REAPERAPI_FUNCNAME(plugin_getapi))(const char* name);
#endif

#if defined(REAPERAPI_WANT_plugin_getFilterList) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// plugin_getFilterList
// Returns a double-NULL terminated list of importable media files, suitable for passing to GetOpenFileName() etc. Includes *.* (All files).

  const char* (*REAPERAPI_FUNCNAME(plugin_getFilterList))();
#endif

#if defined(REAPERAPI_WANT_plugin_getImportableProjectFilterList) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// plugin_getImportableProjectFilterList
// Returns a double-NULL terminated list of importable project files, suitable for passing to GetOpenFileName() etc. Includes *.* (All files).

  const char* (*REAPERAPI_FUNCNAME(plugin_getImportableProjectFilterList))();
#endif

#if defined(REAPERAPI_WANT_plugin_register) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// plugin_register
// Alias for reaper_plugin_info_t::Register, see reaper_plugin.h for documented uses.

  int (*REAPERAPI_FUNCNAME(plugin_register))(const char* name, void* infostruct);
#endif

#if defined(REAPERAPI_WANT_PluginWantsAlwaysRunFx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PluginWantsAlwaysRunFx

  void (*REAPERAPI_FUNCNAME(PluginWantsAlwaysRunFx))(int amt);
#endif

#if defined(REAPERAPI_WANT_PreventUIRefresh) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PreventUIRefresh
// adds prevent_count to the UI refresh prevention state; always add then remove the same amount, or major disfunction will occur

  void (*REAPERAPI_FUNCNAME(PreventUIRefresh))(int prevent_count);
#endif

#if defined(REAPERAPI_WANT_projectconfig_var_addr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// projectconfig_var_addr

  void* (*REAPERAPI_FUNCNAME(projectconfig_var_addr))(ReaProject* proj, int idx);
#endif

#if defined(REAPERAPI_WANT_projectconfig_var_getoffs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// projectconfig_var_getoffs
// returns offset to pass to projectconfig_var_addr() to get project-config var of name. szout gets size of object. can also query "__metronome_ptr" query project metronome PCM_source** offset

  int (*REAPERAPI_FUNCNAME(projectconfig_var_getoffs))(const char* name, int* szOut);
#endif

#if defined(REAPERAPI_WANT_PromptForAction) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// PromptForAction
// Uses the action list to choose an action. Call with session_mode=1 to create a session (init_id will be the initial action to select, or 0), then poll with session_mode=0, checking return value for user-selected action (will return 0 if no action selected yet, or -1 if the action window is no longer available). When finished, call with session_mode=-1.

  int (*REAPERAPI_FUNCNAME(PromptForAction))(int session_mode, int init_id, int section_id);
#endif

#if defined(REAPERAPI_WANT_realloc_cmd_clear) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// realloc_cmd_clear
// clears a buffer/buffer-size registration added with realloc_cmd_register_buf, and clears any later registrations, frees any allocated buffers. call after values are read from any registered pointers etc.

  void (*REAPERAPI_FUNCNAME(realloc_cmd_clear))(int tok);
#endif

#if defined(REAPERAPI_WANT_realloc_cmd_ptr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// realloc_cmd_ptr
// special use for NeedBig script API functions - reallocates a NeedBig buffer and updates its size, returns false on error

  bool (*REAPERAPI_FUNCNAME(realloc_cmd_ptr))(char** ptr, int* ptr_size, int new_size);
#endif

#if defined(REAPERAPI_WANT_realloc_cmd_register_buf) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// realloc_cmd_register_buf
// registers a buffer/buffer-size which may be reallocated by an API (ptr/ptr_size will be updated to the new values). returns a token which should be passed to realloc_cmd_clear after API call and values are read.

  int (*REAPERAPI_FUNCNAME(realloc_cmd_register_buf))(char** ptr, int* ptr_size);
#endif

#if defined(REAPERAPI_WANT_ReaperGetPitchShiftAPI) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ReaperGetPitchShiftAPI
// version must be REAPER_PITCHSHIFT_API_VER

  IReaperPitchShift* (*REAPERAPI_FUNCNAME(ReaperGetPitchShiftAPI))(int version);
#endif

#if defined(REAPERAPI_WANT_ReaScriptError) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ReaScriptError
// Causes REAPER to display the error message after the current ReaScript finishes. If called within a Lua context and errmsg has a ! prefix, script execution will be terminated.

  void (*REAPERAPI_FUNCNAME(ReaScriptError))(const char* errmsg);
#endif

#if defined(REAPERAPI_WANT_RecursiveCreateDirectory) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// RecursiveCreateDirectory
// returns positive value on success, 0 on failure.

  int (*REAPERAPI_FUNCNAME(RecursiveCreateDirectory))(const char* path, size_t ignored);
#endif

#if defined(REAPERAPI_WANT_reduce_open_files) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// reduce_open_files
// garbage-collects extra open files and closes them. if flags has 1 set, this is done incrementally (call this from a regular timer, if desired). if flags has 2 set, files are aggressively closed (they may need to be re-opened very soon). returns number of files closed by this call.

  int (*REAPERAPI_FUNCNAME(reduce_open_files))(int flags);
#endif

#if defined(REAPERAPI_WANT_RefreshToolbar) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// RefreshToolbar
// See RefreshToolbar2.

  void (*REAPERAPI_FUNCNAME(RefreshToolbar))(int command_id);
#endif

#if defined(REAPERAPI_WANT_RefreshToolbar2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// RefreshToolbar2
// Refresh the toolbar button states of a toggle action.

  void (*REAPERAPI_FUNCNAME(RefreshToolbar2))(int section_id, int command_id);
#endif

#if defined(REAPERAPI_WANT_relative_fn) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// relative_fn
// Makes a filename "in" relative to the current project, if any.

  void (*REAPERAPI_FUNCNAME(relative_fn))(const char* in, char* out, int out_sz);
#endif

#if defined(REAPERAPI_WANT_RemoveTrackSend) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// RemoveTrackSend
// Remove a send/receive/hardware output, return true on success. category is <0 for receives, 0=sends, >0 for hardware outputs. See CreateTrackSend, GetSetTrackSendInfo, GetTrackSendInfo_Value, SetTrackSendInfo_Value, GetTrackNumSends.

  bool (*REAPERAPI_FUNCNAME(RemoveTrackSend))(MediaTrack* tr, int category, int sendidx);
#endif

#if defined(REAPERAPI_WANT_RenderFileSection) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// RenderFileSection
// Not available while playing back.

  bool (*REAPERAPI_FUNCNAME(RenderFileSection))(const char* source_filename, const char* target_filename, double start_percent, double end_percent, double playrate);
#endif

#if defined(REAPERAPI_WANT_ReorderSelectedTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ReorderSelectedTracks
// Moves all selected tracks to immediately above track specified by index beforeTrackIdx, returns false if no tracks were selected. makePrevFolder=0 for normal, 1 = as child of track preceding track specified by beforeTrackIdx, 2 = if track preceding track specified by beforeTrackIdx is last track in folder, extend folder

  bool (*REAPERAPI_FUNCNAME(ReorderSelectedTracks))(int beforeTrackIdx, int makePrevFolder);
#endif

#if defined(REAPERAPI_WANT_Resample_EnumModes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Resample_EnumModes

  const char* (*REAPERAPI_FUNCNAME(Resample_EnumModes))(int mode);
#endif

#if defined(REAPERAPI_WANT_Resampler_Create) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Resampler_Create

  REAPER_Resample_Interface* (*REAPERAPI_FUNCNAME(Resampler_Create))();
#endif

#if defined(REAPERAPI_WANT_resolve_fn) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// resolve_fn
// See resolve_fn2.

  void (*REAPERAPI_FUNCNAME(resolve_fn))(const char* in, char* out, int out_sz);
#endif

#if defined(REAPERAPI_WANT_resolve_fn2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// resolve_fn2
// Resolves a filename "in" by using project settings etc. If no file found, out will be a copy of in.

  void (*REAPERAPI_FUNCNAME(resolve_fn2))(const char* in, char* out, int out_sz, const char* checkSubDirOptional);
#endif

#if defined(REAPERAPI_WANT_ResolveRenderPattern) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ResolveRenderPattern
// Resolve a render wildcard pattern into a set of nul-separated, double-nul terminated render target filenames. Returns the length of the string buffer needed for the returned file list. Call with path=NULL to suppress filtering out illegal pathnames, call with targets=NULL to get just the string buffer length.

  int (*REAPERAPI_FUNCNAME(ResolveRenderPattern))(ReaProject* project, const char* path, const char* pattern, char* targets, int targets_sz);
#endif

#if defined(REAPERAPI_WANT_ResolveWildcards) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ResolveWildcards
// Resolve a wildcard string. Any wildcards that are valid in the Big Clock can be resolved using this function. Pass in timePosition=-1 to use the current project playback position.

  void (*REAPERAPI_FUNCNAME(ResolveWildcards))(ReaProject* project, double timePosition, const char* wildcards, char* resolvedStringNeedBig, int resolvedStringNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_ReverseNamedCommandLookup) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ReverseNamedCommandLookup
// Get the named command for the given command ID. The returned string will not start with '_' (e.g. it will return "SWS_ABOUT"), it will be NULL if command_id is a native action.

  const char* (*REAPERAPI_FUNCNAME(ReverseNamedCommandLookup))(int command_id);
#endif

#if defined(REAPERAPI_WANT_ScaleFromEnvelopeMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ScaleFromEnvelopeMode
// See GetEnvelopeScalingMode.

  double (*REAPERAPI_FUNCNAME(ScaleFromEnvelopeMode))(int scaling_mode, double val);
#endif

#if defined(REAPERAPI_WANT_ScaleToEnvelopeMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ScaleToEnvelopeMode
// See GetEnvelopeScalingMode.

  double (*REAPERAPI_FUNCNAME(ScaleToEnvelopeMode))(int scaling_mode, double val);
#endif

#if defined(REAPERAPI_WANT_screenset_register) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// screenset_register

  void (*REAPERAPI_FUNCNAME(screenset_register))(char* id, void* callbackFunc, void* param);
#endif

#if defined(REAPERAPI_WANT_screenset_registerNew) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// screenset_registerNew

  void (*REAPERAPI_FUNCNAME(screenset_registerNew))(char* id, screensetNewCallbackFunc callbackFunc, void* param);
#endif

#if defined(REAPERAPI_WANT_screenset_unregister) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// screenset_unregister

  void (*REAPERAPI_FUNCNAME(screenset_unregister))(char* id);
#endif

#if defined(REAPERAPI_WANT_screenset_unregisterByParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// screenset_unregisterByParam

  void (*REAPERAPI_FUNCNAME(screenset_unregisterByParam))(void* param);
#endif

#if defined(REAPERAPI_WANT_screenset_updateLastFocus) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// screenset_updateLastFocus

  void (*REAPERAPI_FUNCNAME(screenset_updateLastFocus))(HWND prevWin);
#endif

#if defined(REAPERAPI_WANT_SectionFromUniqueID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SectionFromUniqueID

  KbdSectionInfo* (*REAPERAPI_FUNCNAME(SectionFromUniqueID))(int uniqueID);
#endif

#if defined(REAPERAPI_WANT_SelectAllMediaItems) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SelectAllMediaItems

  void (*REAPERAPI_FUNCNAME(SelectAllMediaItems))(ReaProject* proj, bool selected);
#endif

#if defined(REAPERAPI_WANT_SelectProjectInstance) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SelectProjectInstance

  void (*REAPERAPI_FUNCNAME(SelectProjectInstance))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_SendLocalOscMessage) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SendLocalOscMessage
// Send an OSC message to REAPER. See CreateLocalOscHandler, DestroyLocalOscHandler.

  void (*REAPERAPI_FUNCNAME(SendLocalOscMessage))(void* local_osc_handler, const char* msg, int msglen);
#endif

#if defined(REAPERAPI_WANT_SendMIDIMessageToHardware) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SendMIDIMessageToHardware
// Sends a MIDI message to output device specified by output. Message is sent in immediate mode. Lua example of how to pack the message string:
// sysex = { 0xF0, 0x00, 0xF7 }
// msg = ""
// for i=1, #sysex do msg = msg .. string.char(sysex[i]) end

  void (*REAPERAPI_FUNCNAME(SendMIDIMessageToHardware))(int output, const char* msg, int msg_sz);
#endif

#if defined(REAPERAPI_WANT_SetActiveTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetActiveTake
// set this take active in this media item

  void (*REAPERAPI_FUNCNAME(SetActiveTake))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_SetAutomationMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetAutomationMode
// sets all or selected tracks to mode.

  void (*REAPERAPI_FUNCNAME(SetAutomationMode))(int mode, bool onlySel);
#endif

#if defined(REAPERAPI_WANT_SetCurrentBPM) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetCurrentBPM
// set current BPM in project, set wantUndo=true to add undo point

  void (*REAPERAPI_FUNCNAME(SetCurrentBPM))(ReaProject* __proj, double bpm, bool wantUndo);
#endif

#if defined(REAPERAPI_WANT_SetCursorContext) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetCursorContext
// You must use this to change the focus programmatically. mode=0 to focus track panels, 1 to focus the arrange window, 2 to focus the arrange window and select env (or env==NULL to clear the current track/take envelope selection)

  void (*REAPERAPI_FUNCNAME(SetCursorContext))(int mode, TrackEnvelope* envInOptional);
#endif

#if defined(REAPERAPI_WANT_SetEditCurPos) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetEditCurPos

  void (*REAPERAPI_FUNCNAME(SetEditCurPos))(double time, bool moveview, bool seekplay);
#endif

#if defined(REAPERAPI_WANT_SetEditCurPos2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetEditCurPos2

  void (*REAPERAPI_FUNCNAME(SetEditCurPos2))(ReaProject* proj, double time, bool moveview, bool seekplay);
#endif

#if defined(REAPERAPI_WANT_SetEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetEnvelopePoint
// Set attributes of an envelope point. Values that are not supplied will be ignored. If setting multiple points at once, set noSort=true, and call Envelope_SortPoints when done. See SetEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(SetEnvelopePoint))(TrackEnvelope* envelope, int ptidx, double* timeInOptional, double* valueInOptional, int* shapeInOptional, double* tensionInOptional, bool* selectedInOptional, bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_SetEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetEnvelopePointEx
// Set attributes of an envelope point. Values that are not supplied will be ignored. If setting multiple points at once, set noSort=true, and call Envelope_SortPoints when done.
// autoitem_idx=-1 for the underlying envelope, 0 for the first automation item on the envelope, etc.
// For automation items, pass autoitem_idx|0x10000000 to base ptidx on the number of points in one full loop iteration,
// even if the automation item is trimmed so that not all points are visible.
// Otherwise, ptidx will be based on the number of visible points in the automation item, including all loop iterations.
// See CountEnvelopePointsEx, GetEnvelopePointEx, InsertEnvelopePointEx, DeleteEnvelopePointEx.

  bool (*REAPERAPI_FUNCNAME(SetEnvelopePointEx))(TrackEnvelope* envelope, int autoitem_idx, int ptidx, double* timeInOptional, double* valueInOptional, int* shapeInOptional, double* tensionInOptional, bool* selectedInOptional, bool* noSortInOptional);
#endif

#if defined(REAPERAPI_WANT_SetEnvelopeStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetEnvelopeStateChunk
// Sets the RPPXML state of an envelope, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(SetEnvelopeStateChunk))(TrackEnvelope* env, const char* str, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_SetExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetExtState
// Set the extended state value for a specific section and key. persist=true means the value should be stored and reloaded the next time REAPER is opened. Note that with persist=true set, the value will be encoded as a text line in an .ini file and may behaved in unexpected ways if it contains any newlines: do not pass a string with newlines to this function. To save arbitrary data persistently, use base64 encoding or similar. See GetExtState, DeleteExtState, HasExtState.

  void (*REAPERAPI_FUNCNAME(SetExtState))(const char* section, const char* key, const char* value, bool persist);
#endif

#if defined(REAPERAPI_WANT_SetGlobalAutomationOverride) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetGlobalAutomationOverride
// mode: see GetGlobalAutomationOverride

  void (*REAPERAPI_FUNCNAME(SetGlobalAutomationOverride))(int mode);
#endif

#if defined(REAPERAPI_WANT_SetItemStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetItemStateChunk
// Sets the RPPXML state of an item, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(SetItemStateChunk))(MediaItem* item, const char* str, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_SetMasterTrackVisibility) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMasterTrackVisibility
// set &1 to show the master track in the TCP, &2 to HIDE in the mixer. Returns the previous visibility state. See GetMasterTrackVisibility.

  int (*REAPERAPI_FUNCNAME(SetMasterTrackVisibility))(int flag);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemInfo_Value
// Set media item numerical-value attributes.
// B_MUTE : bool * : muted (item solo overrides). setting this value will clear C_MUTE_SOLO.
// B_MUTE_ACTUAL : bool * : muted (ignores solo). setting this value will not affect C_MUTE_SOLO.
// C_LANEPLAYS : char * : on fixed lane tracks, 0=this item lane does not play, 1=this item lane plays exclusively, 2=this item lane plays and other lanes also play, -1=this item is on a non-visible, non-playing lane on a formerly fixed-lane track (read-only)
// C_MUTE_SOLO : char * : solo override (-1=soloed, 0=no override, 1=unsoloed). note that this API does not automatically unsolo other items when soloing (nor clear the unsolos when clearing the last soloed item), it must be done by the caller via action or via this API.
// B_LOOPSRC : bool * : loop source
// B_ALLTAKESPLAY : bool * : all takes play
// B_UISEL : bool * : selected in arrange view
// C_BEATATTACHMODE : char * : item timebase, -1=track or project default, 1=beats (position, length, rate), 2=beats (position only). for auto-stretch timebase: C_BEATATTACHMODE=1, C_AUTOSTRETCH=1
// C_AUTOSTRETCH: : char * : auto-stretch at project tempo changes, 1=enabled, requires C_BEATATTACHMODE=1
// C_LOCK : char * : locked, &1=locked
// D_VOL : double * : item volume,  0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_POSITION : double * : item position in seconds
// D_LENGTH : double * : item length in seconds
// D_SNAPOFFSET : double * : item snap offset in seconds
// D_FADEINLEN : double * : item manual fadein length in seconds
// D_FADEOUTLEN : double * : item manual fadeout length in seconds
// D_FADEINDIR : double * : item fadein curvature, -1..1
// D_FADEOUTDIR : double * : item fadeout curvature, -1..1
// D_FADEINLEN_AUTO : double * : item auto-fadein length in seconds, -1=no auto-fadein
// D_FADEOUTLEN_AUTO : double * : item auto-fadeout length in seconds, -1=no auto-fadeout
// C_FADEINSHAPE : int * : fadein shape, 0..6, 0=linear
// C_FADEOUTSHAPE : int * : fadeout shape, 0..6, 0=linear
// I_GROUPID : int * : group ID, 0=no group
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_CURTAKE : int * : active take number
// IP_ITEMNUMBER : int : item number on this track (read-only, returns the item number directly)
// F_FREEMODE_Y : float * : free item positioning or fixed lane Y-position. 0=top of track, 1.0=bottom of track
// F_FREEMODE_H : float * : free item positioning or fixed lane height. 0.5=half the track height, 1.0=full track height
// I_FIXEDLANE : int * : fixed lane of item (fine to call with setNewValue, but returned value is read-only)
// B_FIXEDLANE_HIDDEN : bool * : true if displaying only one fixed lane and this item is in a different lane (read-only)
// 

  bool (*REAPERAPI_FUNCNAME(SetMediaItemInfo_Value))(MediaItem* item, const char* parmname, double newvalue);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemLength) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemLength
// Redraws the screen only if refreshUI == true.
// See UpdateArrange().

  bool (*REAPERAPI_FUNCNAME(SetMediaItemLength))(MediaItem* item, double length, bool refreshUI);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemPosition) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemPosition
// Redraws the screen only if refreshUI == true.
// See UpdateArrange().

  bool (*REAPERAPI_FUNCNAME(SetMediaItemPosition))(MediaItem* item, double position, bool refreshUI);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemSelected

  void (*REAPERAPI_FUNCNAME(SetMediaItemSelected))(MediaItem* item, bool selected);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemTake_Source) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemTake_Source
// Set media source of media item take. The old source will not be destroyed, it is the caller's responsibility to retrieve it and destroy it after. If source already exists in any project, it will be duplicated before being set. C/C++ code should not use this and instead use GetSetMediaItemTakeInfo() with P_SOURCE to manage ownership directly.

  bool (*REAPERAPI_FUNCNAME(SetMediaItemTake_Source))(MediaItem_Take* take, PCM_source* source);
#endif

#if defined(REAPERAPI_WANT_SetMediaItemTakeInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaItemTakeInfo_Value
// Set media item take numerical-value attributes.
// D_STARTOFFS : double * : start offset in source media, in seconds
// D_VOL : double * : take volume, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc, negative if take polarity is flipped
// D_PAN : double * : take pan, -1..1
// D_PANLAW : double * : take pan law, -1=default, 0.5=-6dB, 1.0=+0dB, etc
// D_PLAYRATE : double * : take playback rate, 0.5=half speed, 1=normal, 2=double speed, etc
// D_PITCH : double * : take pitch adjustment in semitones, -12=one octave down, 0=normal, +12=one octave up, etc
// B_PPITCH : bool * : preserve pitch when changing playback rate
// I_LASTY : int * : Y-position (relative to top of track) in pixels (read-only)
// I_LASTH : int * : height in pixels (read-only)
// I_CHANMODE : int * : channel mode, 0=normal, 1=reverse stereo, 2=downmix, 3=left, 4=right
// I_PITCHMODE : int * : pitch shifter mode, -1=project default, otherwise high 2 bytes=shifter, low 2 bytes=parameter
// I_STRETCHFLAGS : int * : stretch marker flags (&7 mask for mode override: 0=default, 1=balanced, 2/3/6=tonal, 4=transient, 5=no pre-echo)
// F_STRETCHFADESIZE : float * : stretch marker fade size in seconds (0.0025 default)
// I_RECPASSID : int * : record pass ID
// I_TAKEFX_NCH : int * : number of internal audio channels for per-take FX to use (OK to call with setNewValue, but the returned value is read-only)
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// IP_SPECEDIT:CNT : int : spectral edit count (read-only)
// IP_SPECEDIT:DELETE:x : int : read or write this key to remove the spectral edit specified
// IP_SPECEDIT:ADD : int : read or write this key to add a new spectral edit (returns index)
// IP_SPECEDIT:SORT : int : read or write this key to re-sort spectral edits (be sure to do this following a position change or insert of new edit)
// I_SPECEDIT:FFT_SIZE : int * : FFT size used by spectral edits for this take
// D_SPECEDIT:x:POSITION : double * : position of spectral edit start (changing this requires a resort of spectral edits)
// D_SPECEDIT:x:LENGTH : double * : length of spectral edit
// F_SPECEDIT:x:GAIN : float * : gain of spectral edit
// F_SPECEDIT:x:FADE_IN : float * : fade-in size 0..1
// F_SPECEDIT:x:FADE_OUT : float * : fade-out size 0..1
// F_SPECEDIT:x:FADE_LOW : float * : fade-lf size 0..1
// F_SPECEDIT:x:FADE_HI : float * : fade-hf size 0..1
// I_SPECEDIT:x:CHAN : int * : channel index, -1 for omni
// I_SPECEDIT:x:FLAGS : int * : flags, &1=bypassed, &2=solo
// F_SPECEDIT:x:GATE_THRESH : float * : gate threshold
// F_SPECEDIT:x:GATE_FLOOR : float * : gate floor
// F_SPECEDIT:x:COMP_THRESH : float * : comp threshold
// F_SPECEDIT:x:COMP_RATIO : float * : comp ratio
// B_SPECEDIT:x:SELECTED : bool * : selection state
// I_SPECEDIT:x:TOPFREQ_CNT : int * : (read-only) number of top frequency-points
// I_SPECEDIT:x:TOPFREQ_ADD:pos:val : int * : reading or writing will insert top frequency-point with position/value pair, returns index
// I_SPECEDIT:x:TOPFREQ_DEL:y : int * : reading or writing will delete top frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:TOPFREQ_POS:y : float * : (read-only) get position of top frequency-point y
// F_SPECEDIT:x:TOPFREQ_FREQ:y : float * : (read-only) get frequency of top frequency-point y
// I_SPECEDIT:x:BOTFREQ_CNT : int * : number of bottom frequency-points
// I_SPECEDIT:x:BOTFREQ_ADD:pos:val : int * : reading or writing will insert bottom frequency-point with position/value pair, returns index
// I_SPECEDIT:x:BOTFREQ_DEL:y : int * : reading or writing will delete bottom frequency-point y. there will always be at least one point.
// F_SPECEDIT:x:BOTFREQ_POS:y : float * : (read-only) get position of bottom frequency-point y
// F_SPECEDIT:x:BOTFREQ_FREQ:y : float * : (read-only) get frequency of bottom frequency-point y
// IP_TAKENUMBER : int : take number (read-only, returns the take number directly)
// 

  bool (*REAPERAPI_FUNCNAME(SetMediaItemTakeInfo_Value))(MediaItem_Take* take, const char* parmname, double newvalue);
#endif

#if defined(REAPERAPI_WANT_SetMediaTrackInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMediaTrackInfo_Value
// Set track numerical-value attributes.
// B_MUTE : bool * : muted
// B_PHASE : bool * : track phase inverted
// B_RECMON_IN_EFFECT : bool * : record monitoring in effect (current audio-thread playback state, read-only)
// IP_TRACKNUMBER : int : track number 1-based, 0=not found, -1=master track (read-only, returns the int directly)
// I_SOLO : int * : soloed, 0=not soloed, 1=soloed, 2=soloed in place, 5=safe soloed, 6=safe soloed in place
// B_SOLO_DEFEAT : bool * : when set, if anything else is soloed and this track is not muted, this track acts soloed
// I_FXEN : int * : fx enabled, 0=bypassed, !0=fx active
// I_RECARM : int * : record armed, 0=not record armed, 1=record armed
// I_RECINPUT : int * : record input, <0=no input. if 4096 set, input is MIDI and low 5 bits represent channel (0=all, 1-16=only chan), next 6 bits represent physical input (63=all, 62=VKB). If 4096 is not set, low 10 bits (0..1023) are input start channel (ReaRoute/Loopback start at 512). If 2048 is set, input is multichannel input (using track channel count), or if 1024 is set, input is stereo input, otherwise input is mono.
// I_RECMODE : int * : record mode, 0=input, 1=stereo out, 2=none, 3=stereo out w/latency compensation, 4=midi output, 5=mono out, 6=mono out w/ latency compensation, 7=midi overdub, 8=midi replace
// I_RECMODE_FLAGS : int * : record mode flags, &3=output recording mode (0=post fader, 1=pre-fx, 2=post-fx/pre-fader)
// I_RECMON : int * : record monitoring, 0=off, 1=normal, 2=not when playing (tape style)
// I_RECMONITEMS : int * : monitor items while recording, 0=off, 1=on
// B_AUTO_RECARM : bool * : automatically set record arm when selected (does not immediately affect recarm state, script should set directly if desired)
// I_VUMODE : int * : track vu mode, &1:disabled, &30==0:stereo peaks, &30==2:multichannel peaks, &30==4:stereo RMS, &30==8:combined RMS, &30==12:LUFS-M, &30==16:LUFS-S (readout=max), &30==20:LUFS-S (readout=current), &32:LUFS calculation on channels 1+2 only
// I_AUTOMODE : int * : track automation mode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch
// I_NCHAN : int * : number of track channels, 2-128, even numbers only
// I_SELECTED : int * : track selected, 0=unselected, 1=selected
// I_WNDH : int * : current TCP window height in pixels including envelopes (read-only)
// I_TCPH : int * : current TCP window height in pixels not including envelopes (read-only)
// I_TCPY : int * : current TCP window Y-position in pixels relative to top of arrange view (read-only)
// I_MCPX : int * : current MCP X-position in pixels relative to mixer container (read-only)
// I_MCPY : int * : current MCP Y-position in pixels relative to mixer container (read-only)
// I_MCPW : int * : current MCP width in pixels (read-only)
// I_MCPH : int * : current MCP height in pixels (read-only)
// I_FOLDERDEPTH : int * : folder depth change, 0=normal, 1=track is a folder parent, -1=track is the last in the innermost folder, -2=track is the last in the innermost and next-innermost folders, etc
// I_FOLDERCOMPACT : int * : folder collapsed state (only valid on folders), 0=normal, 1=collapsed, 2=fully collapsed
// I_MIDIHWOUT : int * : track midi hardware output index, <0=disabled, low 5 bits are which channels (0=all, 1-16), next 5 bits are output device index (0-31)
// I_MIDI_INPUT_CHANMAP : int * : -1 maps to source channel, otherwise 1-16 to map to MIDI channel
// I_MIDI_CTL_CHAN : int * : -1 no link, 0-15 link to MIDI volume/pan on channel, 16 link to MIDI volume/pan on all channels
// I_MIDI_TRACKSEL_FLAG : int * : MIDI editor track list options: &1=expand media items, &2=exclude from list, &4=auto-pruned
// I_PERFFLAGS : int * : track performance flags, &1=no media buffering, &2=no anticipative FX
// I_CUSTOMCOLOR : int * : custom color, OS dependent color|0x1000000 (i.e. ColorToNative(r,g,b)|0x1000000). If you do not |0x1000000, then it will not be used, but will store the color
// I_HEIGHTOVERRIDE : int * : custom height override for TCP window, 0 for none, otherwise size in pixels
// I_SPACER : int * : 1=TCP track spacer above this trackB_HEIGHTLOCK : bool * : track height lock (must set I_HEIGHTOVERRIDE before locking)
// D_VOL : double * : trim volume of track, 0=-inf, 0.5=-6dB, 1=+0dB, 2=+6dB, etc
// D_PAN : double * : trim pan of track, -1..1
// D_WIDTH : double * : width of track, -1..1
// D_DUALPANL : double * : dualpan position 1, -1..1, only if I_PANMODE==6
// D_DUALPANR : double * : dualpan position 2, -1..1, only if I_PANMODE==6
// I_PANMODE : int * : pan mode, 0=classic 3.x, 3=new balance, 5=stereo pan, 6=dual pan
// D_PANLAW : double * : pan law of track, <0=project default, 0.5=-6dB, 0.707..=-3dB, 1=+0dB, 1.414..=-3dB with gain compensation, 2=-6dB with gain compensation, etc
// I_PANLAW_FLAGS : int * : pan law flags, 0=sine taper, 1=hybrid taper with deprecated behavior when gain compensation enabled, 2=linear taper, 3=hybrid taper
// P_ENV:<envchunkname or P_ENV:{GUID... : TrackEnvelope * : (read-only) chunkname can be <VOLENV, <PANENV, etc; GUID is the stringified envelope GUID.
// B_SHOWINMIXER : bool * : track control panel visible in mixer (do not use on master track)
// B_SHOWINTCP : bool * : track control panel visible in arrange view (do not use on master track)
// B_MAINSEND : bool * : track sends audio to parent
// C_MAINSEND_OFFS : char * : channel offset of track send to parent
// C_MAINSEND_NCH : char * : channel count of track send to parent (0=use all child track channels, 1=use one channel only)
// I_FREEMODE : int * : 1=track free item positioning enabled, 2=track fixed lanes enabled (call UpdateTimeline() after changing)
// I_NUMFIXEDLANES : int * : number of track fixed lanes (fine to call with setNewValue, but returned value is read-only)
// C_LANESCOLLAPSED : char * : fixed lane collapse state (1=lanes collapsed, 2=track displays as non-fixed-lanes but hidden lanes exist)
// C_LANESETTINGS : char * : fixed lane settings (&1=auto-remove empty lanes at bottom, &2=do not auto-comp new recording, &4=newly recorded lanes play exclusively (else add lanes in layers), &8=big lanes (else small lanes), &16=add new recording at bottom (else record into first available lane), &32=hide lane buttons
// C_LANEPLAYS:N : char * :  on fixed lane tracks, 0=lane N does not play, 1=lane N plays exclusively, 2=lane N plays and other lanes also play (fine to call with setNewValue, but returned value is read-only)
// C_ALLLANESPLAY : char * : on fixed lane tracks, 0=no lanes play, 1=all lanes play, 2=some lanes play (fine to call with setNewValue 0 or 1, but returned value is read-only)
// C_BEATATTACHMODE : char * : track timebase, -1=project default, 0=time, 1=beats (position, length, rate), 2=beats (position only)
// F_MCP_FXSEND_SCALE : float * : scale of fx+send area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_FXPARM_SCALE : float * : scale of fx parameter area in MCP (0=minimum allowed, 1=maximum allowed)
// F_MCP_SENDRGN_SCALE : float * : scale of send area as proportion of the fx+send total area (0=minimum allowed, 1=maximum allowed)
// F_TCP_FXPARM_SCALE : float * : scale of TCP parameter area when TCP FX are embedded (0=min allowed, default, 1=max allowed)
// I_PLAY_OFFSET_FLAG : int * : track media playback offset state, &1=bypassed, &2=offset value is measured in samples (otherwise measured in seconds)
// D_PLAY_OFFSET : double * : track media playback offset, units depend on I_PLAY_OFFSET_FLAG
// 

  bool (*REAPERAPI_FUNCNAME(SetMediaTrackInfo_Value))(MediaTrack* tr, const char* parmname, double newvalue);
#endif

#if defined(REAPERAPI_WANT_SetMIDIEditorGrid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMIDIEditorGrid
// Set the MIDI editor grid division. 0.25=quarter note, 1.0/3.0=half note tripet, etc.

  void (*REAPERAPI_FUNCNAME(SetMIDIEditorGrid))(ReaProject* project, double division);
#endif

#if defined(REAPERAPI_WANT_SetMixerScroll) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMixerScroll
// Scroll the mixer so that leftmosttrack is the leftmost visible track. Returns the leftmost track after scrolling, which may be different from the passed-in track if there are not enough tracks to its right.

  MediaTrack* (*REAPERAPI_FUNCNAME(SetMixerScroll))(MediaTrack* leftmosttrack);
#endif

#if defined(REAPERAPI_WANT_SetMouseModifier) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetMouseModifier
// Set the mouse modifier assignment for a specific modifier key assignment, in a specific context.
// Context is a string like "MM_CTX_ITEM" (see reaper-mouse.ini) or "Media item left drag" (unlocalized).
// Modifier flag is a number from 0 to 15: add 1 for shift, 2 for control, 4 for alt, 8 for win.
// (macOS: add 1 for shift, 2 for command, 4 for opt, 8 for control.)
// For left-click and double-click contexts, the action can be any built-in command ID number
// or any custom action ID string. Find built-in command IDs in the REAPER actions window
// (enable "show command IDs" in the context menu), and find custom action ID strings in reaper-kb.ini.
// The action string may be a mouse modifier ID (see reaper-mouse.ini) with " m" appended to it,
// or (for click/double-click contexts) a command ID with " c" appended to it,
// or the text that appears in the mouse modifiers preferences dialog, like "Move item" (unlocalized).
// For example, SetMouseModifier("MM_CTX_ITEM", 0, "1 m") and SetMouseModifier("Media item left drag", 0, "Move item") are equivalent.
// SetMouseModifier(context, modifier_flag, -1) will reset that mouse modifier to default.
// SetMouseModifier(context, -1, -1) will reset the entire context to default.
// SetMouseModifier(-1, -1, -1) will reset all contexts to default.
// See GetMouseModifier.
// 

  void (*REAPERAPI_FUNCNAME(SetMouseModifier))(const char* context, int modifier_flag, const char* action);
#endif

#if defined(REAPERAPI_WANT_SetOnlyTrackSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetOnlyTrackSelected
// Set exactly one track selected, deselect all others

  void (*REAPERAPI_FUNCNAME(SetOnlyTrackSelected))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_SetProjectGrid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectGrid
// Set the arrange view grid division. 0.25=quarter note, 1.0/3.0=half note triplet, etc.

  void (*REAPERAPI_FUNCNAME(SetProjectGrid))(ReaProject* project, double division);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarker
// Note: this function can't clear a marker's name (an empty string will leave the name unchanged), see SetProjectMarker4.

  bool (*REAPERAPI_FUNCNAME(SetProjectMarker))(int markrgnindexnumber, bool isrgn, double pos, double rgnend, const char* name);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarker2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarker2
// Note: this function can't clear a marker's name (an empty string will leave the name unchanged), see SetProjectMarker4.

  bool (*REAPERAPI_FUNCNAME(SetProjectMarker2))(ReaProject* proj, int markrgnindexnumber, bool isrgn, double pos, double rgnend, const char* name);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarker3) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarker3
// Note: this function can't clear a marker's name (an empty string will leave the name unchanged), see SetProjectMarker4.

  bool (*REAPERAPI_FUNCNAME(SetProjectMarker3))(ReaProject* proj, int markrgnindexnumber, bool isrgn, double pos, double rgnend, const char* name, int color);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarker4) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarker4
// color should be 0 to not change, or ColorToNative(r,g,b)|0x1000000, flags&1 to clear name

  bool (*REAPERAPI_FUNCNAME(SetProjectMarker4))(ReaProject* proj, int markrgnindexnumber, bool isrgn, double pos, double rgnend, const char* name, int color, int flags);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarkerByIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarkerByIndex
// See SetProjectMarkerByIndex2.

  bool (*REAPERAPI_FUNCNAME(SetProjectMarkerByIndex))(ReaProject* proj, int markrgnidx, bool isrgn, double pos, double rgnend, int IDnumber, const char* name, int color);
#endif

#if defined(REAPERAPI_WANT_SetProjectMarkerByIndex2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjectMarkerByIndex2
// Differs from SetProjectMarker4 in that markrgnidx is 0 for the first marker/region, 1 for the next, etc (see EnumProjectMarkers3), rather than representing the displayed marker/region ID number (see SetProjectMarker3). IDnumber < 0 to ignore. Function will fail if attempting to set a duplicate ID number for a region (duplicate ID numbers for markers are OK). flags&1 to clear name. If flags&2, markers will not be re-sorted, and after making updates, you MUST call SetProjectMarkerByIndex2 with markrgnidx=-1 and flags&2 to force re-sort/UI updates.

  bool (*REAPERAPI_FUNCNAME(SetProjectMarkerByIndex2))(ReaProject* proj, int markrgnidx, bool isrgn, double pos, double rgnend, int IDnumber, const char* name, int color, int flags);
#endif

#if defined(REAPERAPI_WANT_SetProjExtState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetProjExtState
// Save a key/value pair for a specific extension, to be restored the next time this specific project is loaded. Typically extname will be the name of a reascript or extension section. If key is NULL or "", all extended data for that extname will be deleted.  If val is NULL or "", the data previously associated with that key will be deleted. Returns the size of the state for this extname. See GetProjExtState, EnumProjExtState.

  int (*REAPERAPI_FUNCNAME(SetProjExtState))(ReaProject* proj, const char* extname, const char* key, const char* value);
#endif

#if defined(REAPERAPI_WANT_SetRegionRenderMatrix) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetRegionRenderMatrix
// Add (flag > 0) or remove (flag < 0) a track from this region when using the region render matrix. If adding, flag==2 means force mono, flag==4 means force stereo, flag==N means force N/2 channels.

  void (*REAPERAPI_FUNCNAME(SetRegionRenderMatrix))(ReaProject* proj, int regionindex, MediaTrack* track, int flag);
#endif

#if defined(REAPERAPI_WANT_SetRenderLastError) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetRenderLastError
// Used by pcmsink objects to set an error to display while creating the pcmsink object.

  void (*REAPERAPI_FUNCNAME(SetRenderLastError))(const char* errorstr);
#endif

#if defined(REAPERAPI_WANT_SetTakeMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTakeMarker
// Inserts or updates a take marker. If idx<0, a take marker will be added, otherwise an existing take marker will be updated. Returns the index of the new or updated take marker (which may change if srcPos is updated). See GetNumTakeMarkers, GetTakeMarker, DeleteTakeMarker

  int (*REAPERAPI_FUNCNAME(SetTakeMarker))(MediaItem_Take* take, int idx, const char* nameIn, double* srcposInOptional, int* colorInOptional);
#endif

#if defined(REAPERAPI_WANT_SetTakeStretchMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTakeStretchMarker
// Adds or updates a stretch marker. If idx<0, stretch marker will be added. If idx>=0, stretch marker will be updated. When adding, if srcposInOptional is omitted, source position will be auto-calculated. When updating a stretch marker, if srcposInOptional is omitted, srcpos will not be modified. Position/srcposition values will be constrained to nearby stretch markers. Returns index of stretch marker, or -1 if did not insert (or marker already existed at time).

  int (*REAPERAPI_FUNCNAME(SetTakeStretchMarker))(MediaItem_Take* take, int idx, double pos, const double* srcposInOptional);
#endif

#if defined(REAPERAPI_WANT_SetTakeStretchMarkerSlope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTakeStretchMarkerSlope
// See GetTakeStretchMarkerSlope

  bool (*REAPERAPI_FUNCNAME(SetTakeStretchMarkerSlope))(MediaItem_Take* take, int idx, double slope);
#endif

#if defined(REAPERAPI_WANT_SetTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTempoTimeSigMarker
// Set parameters of a tempo/time signature marker. Provide either timepos (with measurepos=-1, beatpos=-1), or measurepos and beatpos (with timepos=-1). If timesig_num and timesig_denom are zero, the previous time signature will be used. ptidx=-1 will insert a new tempo/time signature marker. See CountTempoTimeSigMarkers, GetTempoTimeSigMarker, AddTempoTimeSigMarker.

  bool (*REAPERAPI_FUNCNAME(SetTempoTimeSigMarker))(ReaProject* proj, int ptidx, double timepos, int measurepos, double beatpos, double bpm, int timesig_num, int timesig_denom, bool lineartempo);
#endif

#if defined(REAPERAPI_WANT_SetThemeColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetThemeColor
// Temporarily updates the theme color to the color specified (or the theme default color if -1 is specified). Returns -1 on failure, otherwise returns the color (or transformed-color). Note that the UI is not updated by this, the caller should call UpdateArrange() etc as necessary. If the low bit of flags is set, any color transformations are bypassed. To read a value see GetThemeColor.

  int (*REAPERAPI_FUNCNAME(SetThemeColor))(const char* ini_key, int color, int flagsOptional);
#endif

#if defined(REAPERAPI_WANT_SetToggleCommandState) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetToggleCommandState
// Updates the toggle state of an action, returns true if succeeded. Only ReaScripts can have their toggle states changed programmatically. See RefreshToolbar2.

  bool (*REAPERAPI_FUNCNAME(SetToggleCommandState))(int section_id, int command_id, int state);
#endif

#if defined(REAPERAPI_WANT_SetTrackAutomationMode) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackAutomationMode

  void (*REAPERAPI_FUNCNAME(SetTrackAutomationMode))(MediaTrack* tr, int mode);
#endif

#if defined(REAPERAPI_WANT_SetTrackColor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackColor
// Set the custom track color, color is OS dependent (i.e. ColorToNative(r,g,b). To unset the track color, see SetMediaTrackInfo_Value I_CUSTOMCOLOR

  void (*REAPERAPI_FUNCNAME(SetTrackColor))(MediaTrack* track, int color);
#endif

#if defined(REAPERAPI_WANT_SetTrackMIDILyrics) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackMIDILyrics
// Set all MIDI lyrics on the track. Lyrics will be stuffed into any MIDI items found in range. Flag is unused at present. str is passed in as beat position, tab, text, tab (example with flag=2: "1.1.2\tLyric for measure 1 beat 2\t2.1.1\tLyric for measure 2 beat 1	"). See GetTrackMIDILyrics

  bool (*REAPERAPI_FUNCNAME(SetTrackMIDILyrics))(MediaTrack* track, int flag, const char* str);
#endif

#if defined(REAPERAPI_WANT_SetTrackMIDINoteName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackMIDINoteName
// channel < 0 assigns these note names to all channels.

  bool (*REAPERAPI_FUNCNAME(SetTrackMIDINoteName))(int track, int pitch, int chan, const char* name);
#endif

#if defined(REAPERAPI_WANT_SetTrackMIDINoteNameEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackMIDINoteNameEx
// channel < 0 assigns note name to all channels. pitch 128 assigns name for CC0, pitch 129 for CC1, etc.

  bool (*REAPERAPI_FUNCNAME(SetTrackMIDINoteNameEx))(ReaProject* proj, MediaTrack* track, int pitch, int chan, const char* name);
#endif

#if defined(REAPERAPI_WANT_SetTrackSelected) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackSelected

  void (*REAPERAPI_FUNCNAME(SetTrackSelected))(MediaTrack* track, bool selected);
#endif

#if defined(REAPERAPI_WANT_SetTrackSendInfo_Value) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackSendInfo_Value
// Set send/receive/hardware output numerical-value attributes, return true on success.
// category is <0 for receives, 0=sends, >0 for hardware outputs
// parameter names:
// B_MUTE : bool *
// B_PHASE : bool * : true to flip phase
// B_MONO : bool *
// D_VOL : double * : 1.0 = +0dB etc
// D_PAN : double * : -1..+1
// D_PANLAW : double * : 1.0=+0.0db, 0.5=-6dB, -1.0 = projdef etc
// I_SENDMODE : int * : 0=post-fader, 1=pre-fx, 2=post-fx (deprecated), 3=post-fx
// I_AUTOMODE : int * : automation mode (-1=use track automode, 0=trim/off, 1=read, 2=touch, 3=write, 4=latch)
// I_SRCCHAN : int * : -1 for no audio send. Low 10 bits specify channel offset, and higher bits specify channel count. (srcchan>>10) == 0 for stereo, 1 for mono, 2 for 4 channel, 3 for 6 channel, etc.
// I_DSTCHAN : int * : low 10 bits are destination index, &1024 set to mix to mono.
// I_MIDIFLAGS : int * : low 5 bits=source channel 0=all, 1-16, 31=MIDI send disabled, next 5 bits=dest channel, 0=orig, 1-16=chan. &1024 for faders-send MIDI vol/pan. (>>14)&255 = src bus (0 for all, 1 for normal, 2+). (>>22)&255=destination bus (0 for all, 1 for normal, 2+)
// See CreateTrackSend, RemoveTrackSend, GetTrackNumSends.

  bool (*REAPERAPI_FUNCNAME(SetTrackSendInfo_Value))(MediaTrack* tr, int category, int sendidx, const char* parmname, double newvalue);
#endif

#if defined(REAPERAPI_WANT_SetTrackSendUIPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackSendUIPan
// send_idx<0 for receives, >=0 for hw ouputs, >=nb_of_hw_ouputs for sends. isend=1 for end of edit, -1 for an instant edit (such as reset), 0 for normal tweak.

  bool (*REAPERAPI_FUNCNAME(SetTrackSendUIPan))(MediaTrack* track, int send_idx, double pan, int isend);
#endif

#if defined(REAPERAPI_WANT_SetTrackSendUIVol) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackSendUIVol
// send_idx<0 for receives, >=0 for hw ouputs, >=nb_of_hw_ouputs for sends. isend=1 for end of edit, -1 for an instant edit (such as reset), 0 for normal tweak.

  bool (*REAPERAPI_FUNCNAME(SetTrackSendUIVol))(MediaTrack* track, int send_idx, double vol, int isend);
#endif

#if defined(REAPERAPI_WANT_SetTrackStateChunk) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackStateChunk
// Sets the RPPXML state of a track, returns true if successful. Undo flag is a performance/caching hint.

  bool (*REAPERAPI_FUNCNAME(SetTrackStateChunk))(MediaTrack* track, const char* str, bool isundoOptional);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIInputMonitor) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIInputMonitor
// monitor: 0=no monitoring, 1=monitoring, 2=auto-monitoring. returns new value or -1 if error. igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  int (*REAPERAPI_FUNCNAME(SetTrackUIInputMonitor))(MediaTrack* track, int monitor, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIMute
// mute: <0 toggles, >0 sets mute, 0=unsets mute. returns new value or -1 if error. igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  int (*REAPERAPI_FUNCNAME(SetTrackUIMute))(MediaTrack* track, int mute, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIPan) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIPan
// igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  double (*REAPERAPI_FUNCNAME(SetTrackUIPan))(MediaTrack* track, double pan, bool relative, bool done, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIPolarity) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIPolarity
// polarity (AKA phase): <0 toggles, 0=normal, >0=inverted. returns new value or -1 if error.igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  int (*REAPERAPI_FUNCNAME(SetTrackUIPolarity))(MediaTrack* track, int polarity, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIRecArm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIRecArm
// recarm: <0 toggles, >0 sets recarm, 0=unsets recarm. returns new value or -1 if error. igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  int (*REAPERAPI_FUNCNAME(SetTrackUIRecArm))(MediaTrack* track, int recarm, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUISolo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUISolo
// solo: <0 toggles, 1 sets solo (default mode), 0=unsets solo, 2 sets solo (non-SIP), 4 sets solo (SIP). returns new value or -1 if error. igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  int (*REAPERAPI_FUNCNAME(SetTrackUISolo))(MediaTrack* track, int solo, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIVolume) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIVolume
// igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  double (*REAPERAPI_FUNCNAME(SetTrackUIVolume))(MediaTrack* track, double volume, bool relative, bool done, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_SetTrackUIWidth) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SetTrackUIWidth
// igngroupflags: &1 to prevent track grouping, &2 to prevent selection ganging

  double (*REAPERAPI_FUNCNAME(SetTrackUIWidth))(MediaTrack* track, double width, bool relative, bool done, int igngroupflags);
#endif

#if defined(REAPERAPI_WANT_ShowActionList) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ShowActionList

  void (*REAPERAPI_FUNCNAME(ShowActionList))(KbdSectionInfo* section, HWND callerWnd);
#endif

#if defined(REAPERAPI_WANT_ShowConsoleMsg) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ShowConsoleMsg
// Show a message to the user (also useful for debugging). Send "\n" for newline, "" to clear the console. Prefix string with "!SHOW:" and text will be added to console without opening the window. See ClearConsole

  void (*REAPERAPI_FUNCNAME(ShowConsoleMsg))(const char* msg);
#endif

#if defined(REAPERAPI_WANT_ShowMessageBox) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ShowMessageBox
// type 0=OK,1=OKCANCEL,2=ABORTRETRYIGNORE,3=YESNOCANCEL,4=YESNO,5=RETRYCANCEL : ret 1=OK,2=CANCEL,3=ABORT,4=RETRY,5=IGNORE,6=YES,7=NO

  int (*REAPERAPI_FUNCNAME(ShowMessageBox))(const char* msg, const char* title, int type);
#endif

#if defined(REAPERAPI_WANT_ShowPopupMenu) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ShowPopupMenu
// shows a context menu, valid names include: track_input, track_panel, track_area, track_routing, item, ruler, envelope, envelope_point, envelope_item. ctxOptional can be a track pointer for track_*, item pointer for item* (but is optional). for envelope_point, ctx2Optional has point index, ctx3Optional has item index (0=main envelope, 1=first AI). for envelope_item, ctx2Optional has AI index (1=first AI)

  void (*REAPERAPI_FUNCNAME(ShowPopupMenu))(const char* name, int x, int y, HWND hwndParentOptional, void* ctxOptional, int ctx2Optional, int ctx3Optional);
#endif

#if defined(REAPERAPI_WANT_SLIDER2DB) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SLIDER2DB

  double (*REAPERAPI_FUNCNAME(SLIDER2DB))(double y);
#endif

#if defined(REAPERAPI_WANT_SnapToGrid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SnapToGrid

  double (*REAPERAPI_FUNCNAME(SnapToGrid))(ReaProject* project, double time_pos);
#endif

#if defined(REAPERAPI_WANT_SoloAllTracks) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SoloAllTracks
// solo=2 for SIP

  void (*REAPERAPI_FUNCNAME(SoloAllTracks))(int solo);
#endif

#if defined(REAPERAPI_WANT_Splash_GetWnd) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Splash_GetWnd
// gets the splash window, in case you want to display a message over it. Returns NULL when the splash window is not displayed.

  HWND (*REAPERAPI_FUNCNAME(Splash_GetWnd))();
#endif

#if defined(REAPERAPI_WANT_SplitMediaItem) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// SplitMediaItem
// the original item becomes the left-hand split, the function returns the right-hand split (or NULL if the split failed)

  MediaItem* (*REAPERAPI_FUNCNAME(SplitMediaItem))(MediaItem* item, double position);
#endif

#if defined(REAPERAPI_WANT_StopPreview) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// StopPreview
// return nonzero on success

  int (*REAPERAPI_FUNCNAME(StopPreview))(preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_StopTrackPreview) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// StopTrackPreview
// return nonzero on success

  int (*REAPERAPI_FUNCNAME(StopTrackPreview))(preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_StopTrackPreview2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// StopTrackPreview2
// return nonzero on success

  int (*REAPERAPI_FUNCNAME(StopTrackPreview2))(ReaProject* proj, preview_register_t* preview);
#endif

#if defined(REAPERAPI_WANT_stringToGuid) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// stringToGuid

  void (*REAPERAPI_FUNCNAME(stringToGuid))(const char* str, GUID* g);
#endif

#if defined(REAPERAPI_WANT_StuffMIDIMessage) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// StuffMIDIMessage
// Stuffs a 3 byte MIDI message into either the Virtual MIDI Keyboard queue, or the MIDI-as-control input queue, or sends to a MIDI hardware output. mode=0 for VKB, 1 for control (actions map etc), 2 for VKB-on-current-channel; 16 for external MIDI device 0, 17 for external MIDI device 1, etc; see GetNumMIDIOutputs, GetMIDIOutputName.

  void (*REAPERAPI_FUNCNAME(StuffMIDIMessage))(int mode, int msg1, int msg2, int msg3);
#endif

#if defined(REAPERAPI_WANT_TakeFX_AddByName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_AddByName
// Adds or queries the position of a named FX in a take. See TrackFX_AddByName() for information on fxname and instantiate. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_AddByName))(MediaItem_Take* take, const char* fxname, int instantiate);
#endif

#if defined(REAPERAPI_WANT_TakeFX_CopyToTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_CopyToTake
// Copies (or moves) FX from src_take to dest_take. Can be used with src_take=dest_take to reorder. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_CopyToTake))(MediaItem_Take* src_take, int src_fx, MediaItem_Take* dest_take, int dest_fx, bool is_move);
#endif

#if defined(REAPERAPI_WANT_TakeFX_CopyToTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_CopyToTrack
// Copies (or moves) FX from src_take to dest_track. dest_fx can have 0x1000000 set to reference input FX. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_CopyToTrack))(MediaItem_Take* src_take, int src_fx, MediaTrack* dest_track, int dest_fx, bool is_move);
#endif

#if defined(REAPERAPI_WANT_TakeFX_Delete) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_Delete
// Remove a FX from take chain (returns true on success) FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_Delete))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_EndParamEdit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_EndParamEdit
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_EndParamEdit))(MediaItem_Take* take, int fx, int param);
#endif

#if defined(REAPERAPI_WANT_TakeFX_FormatParamValue) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_FormatParamValue
// Note: only works with FX that support Cockos VST extensions. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_FormatParamValue))(MediaItem_Take* take, int fx, int param, double val, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_FormatParamValueNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_FormatParamValueNormalized
// Note: only works with FX that support Cockos VST extensions. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_FormatParamValueNormalized))(MediaItem_Take* take, int fx, int param, double value, char* buf, int buf_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetChainVisible) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetChainVisible
// returns index of effect visible in chain, or -1 for chain hidden, or -2 for chain visible but no effect selected

  int (*REAPERAPI_FUNCNAME(TakeFX_GetChainVisible))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetCount) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetCount

  int (*REAPERAPI_FUNCNAME(TakeFX_GetCount))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetEnabled
// See TakeFX_SetEnabled FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetEnabled))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetEnvelope) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetEnvelope
// Returns the FX parameter envelope. If the envelope does not exist and create=true, the envelope will be created. If the envelope already exists and is bypassed and create=true, then the envelope will be unbypassed. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  TrackEnvelope* (*REAPERAPI_FUNCNAME(TakeFX_GetEnvelope))(MediaItem_Take* take, int fxindex, int parameterindex, bool create);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetFloatingWindow) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetFloatingWindow
// returns HWND of floating window for effect index, if any FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  HWND (*REAPERAPI_FUNCNAME(TakeFX_GetFloatingWindow))(MediaItem_Take* take, int index);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetFormattedParamValue) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetFormattedParamValue
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetFormattedParamValue))(MediaItem_Take* take, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetFXGUID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetFXGUID
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  GUID* (*REAPERAPI_FUNCNAME(TakeFX_GetFXGUID))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetFXName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetFXName
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetFXName))(MediaItem_Take* take, int fx, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetIOSize) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetIOSize
// Gets the number of input/output pins for FX if available, returns plug-in type or -1 on error FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_GetIOSize))(MediaItem_Take* take, int fx, int* inputPinsOut, int* outputPinsOut);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetNamedConfigParm
// gets plug-in specific named configuration value (returns true on success). see TrackFX_GetNamedConfigParm FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetNamedConfigParm))(MediaItem_Take* take, int fx, const char* parmname, char* bufOutNeedBig, int bufOutNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetNumParams) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetNumParams
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_GetNumParams))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetOffline) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetOffline
// See TakeFX_SetOffline FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetOffline))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetOpen) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetOpen
// Returns true if this FX UI is open in the FX chain window or a floating window. See TakeFX_SetOpen FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetOpen))(MediaItem_Take* take, int fx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParam
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TakeFX_GetParam))(MediaItem_Take* take, int fx, int param, double* minvalOut, double* maxvalOut);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParameterStepSizes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParameterStepSizes
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetParameterStepSizes))(MediaItem_Take* take, int fx, int param, double* stepOut, double* smallstepOut, double* largestepOut, bool* istoggleOut);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParamEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParamEx
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TakeFX_GetParamEx))(MediaItem_Take* take, int fx, int param, double* minvalOut, double* maxvalOut, double* midvalOut);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParamFromIdent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParamFromIdent
// gets the parameter index from an identifying string (:wet, :bypass, or a string returned from GetParamIdent), or -1 if unknown. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_GetParamFromIdent))(MediaItem_Take* take, int fx, const char* ident_str);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParamIdent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParamIdent
// gets an identifying string for the parameter FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetParamIdent))(MediaItem_Take* take, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParamName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParamName
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetParamName))(MediaItem_Take* take, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetParamNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetParamNormalized
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TakeFX_GetParamNormalized))(MediaItem_Take* take, int fx, int param);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetPinMappings) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetPinMappings
// gets the effective channel mapping bitmask for a particular pin. high32Out will be set to the high 32 bits. Add 0x1000000 to pin index in order to access the second 64 bits of mappings independent of the first 64 bits. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_GetPinMappings))(MediaItem_Take* take, int fx, int isoutput, int pin, int* high32Out);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetPreset) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetPreset
// Get the name of the preset currently showing in the REAPER dropdown, or the full path to a factory preset file for VST3 plug-ins (.vstpreset). See TakeFX_SetPreset. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_GetPreset))(MediaItem_Take* take, int fx, char* presetnameOut, int presetnameOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetPresetIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetPresetIndex
// Returns current preset index, or -1 if error. numberOfPresetsOut will be set to total number of presets available. See TakeFX_SetPresetByIndex FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TakeFX_GetPresetIndex))(MediaItem_Take* take, int fx, int* numberOfPresetsOut);
#endif

#if defined(REAPERAPI_WANT_TakeFX_GetUserPresetFilename) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_GetUserPresetFilename
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_GetUserPresetFilename))(MediaItem_Take* take, int fx, char* fnOut, int fnOut_sz);
#endif

#if defined(REAPERAPI_WANT_TakeFX_NavigatePresets) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_NavigatePresets
// presetmove==1 activates the next preset, presetmove==-1 activates the previous preset, etc. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_NavigatePresets))(MediaItem_Take* take, int fx, int presetmove);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetEnabled
// See TakeFX_GetEnabled FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_SetEnabled))(MediaItem_Take* take, int fx, bool enabled);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetNamedConfigParm
// gets plug-in specific named configuration value (returns true on success). see TrackFX_SetNamedConfigParm FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetNamedConfigParm))(MediaItem_Take* take, int fx, const char* parmname, const char* value);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetOffline) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetOffline
// See TakeFX_GetOffline FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_SetOffline))(MediaItem_Take* take, int fx, bool offline);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetOpen) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetOpen
// Open this FX UI. See TakeFX_GetOpen FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_SetOpen))(MediaItem_Take* take, int fx, bool open);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetParam
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetParam))(MediaItem_Take* take, int fx, int param, double val);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetParamNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetParamNormalized
//  FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetParamNormalized))(MediaItem_Take* take, int fx, int param, double value);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetPinMappings) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetPinMappings
// sets the channel mapping bitmask for a particular pin. returns false if unsupported (not all types of plug-ins support this capability). Add 0x1000000 to pin index in order to access the second 64 bits of mappings independent of the first 64 bits. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetPinMappings))(MediaItem_Take* take, int fx, int isoutput, int pin, int low32bits, int hi32bits);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetPreset) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetPreset
// Activate a preset with the name shown in the REAPER dropdown. Full paths to .vstpreset files are also supported for VST3 plug-ins. See TakeFX_GetPreset. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetPreset))(MediaItem_Take* take, int fx, const char* presetname);
#endif

#if defined(REAPERAPI_WANT_TakeFX_SetPresetByIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_SetPresetByIndex
// Sets the preset idx, or the factory preset (idx==-2), or the default user preset (idx==-1). Returns true on success. See TakeFX_GetPresetIndex. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TakeFX_SetPresetByIndex))(MediaItem_Take* take, int fx, int idx);
#endif

#if defined(REAPERAPI_WANT_TakeFX_Show) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeFX_Show
// showflag=0 for hidechain, =1 for show chain(index valid), =2 for hide floating window(index valid), =3 for show floating window (index valid) FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TakeFX_Show))(MediaItem_Take* take, int index, int showFlag);
#endif

#if defined(REAPERAPI_WANT_TakeIsMIDI) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TakeIsMIDI
// Returns true if the active take contains MIDI.

  bool (*REAPERAPI_FUNCNAME(TakeIsMIDI))(MediaItem_Take* take);
#endif

#if defined(REAPERAPI_WANT_ThemeLayout_GetLayout) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ThemeLayout_GetLayout
// Gets theme layout information. section can be 'global' for global layout override, 'seclist' to enumerate a list of layout sections, otherwise a layout section such as 'mcp', 'tcp', 'trans', etc. idx can be -1 to query the current value, -2 to get the description of the section (if not global), -3 will return the current context DPI-scaling (256=normal, 512=retina, etc), or 0..x. returns false if failed.

  bool (*REAPERAPI_FUNCNAME(ThemeLayout_GetLayout))(const char* section, int idx, char* nameOut, int nameOut_sz);
#endif

#if defined(REAPERAPI_WANT_ThemeLayout_GetParameter) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ThemeLayout_GetParameter
// returns theme layout parameter. return value is cfg-name, or nil/empty if out of range.

  const char* (*REAPERAPI_FUNCNAME(ThemeLayout_GetParameter))(int wp, const char** descOutOptional, int* valueOutOptional, int* defValueOutOptional, int* minValueOutOptional, int* maxValueOutOptional);
#endif

#if defined(REAPERAPI_WANT_ThemeLayout_RefreshAll) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ThemeLayout_RefreshAll
// Refreshes all layouts

  void (*REAPERAPI_FUNCNAME(ThemeLayout_RefreshAll))();
#endif

#if defined(REAPERAPI_WANT_ThemeLayout_SetLayout) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ThemeLayout_SetLayout
// Sets theme layout override for a particular section -- section can be 'global' or 'mcp' etc. If setting global layout, prefix a ! to the layout string to clear any per-layout overrides. Returns false if failed.

  bool (*REAPERAPI_FUNCNAME(ThemeLayout_SetLayout))(const char* section, const char*  layout);
#endif

#if defined(REAPERAPI_WANT_ThemeLayout_SetParameter) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ThemeLayout_SetParameter
// sets theme layout parameter to value. persist=true in order to have change loaded on next theme load. note that the caller should update layouts via ??? to make changes visible.

  bool (*REAPERAPI_FUNCNAME(ThemeLayout_SetParameter))(int wp, int value, bool persist);
#endif

#if defined(REAPERAPI_WANT_time_precise) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// time_precise
// Gets a precise system timestamp in seconds

  double (*REAPERAPI_FUNCNAME(time_precise))();
#endif

#if defined(REAPERAPI_WANT_TimeMap2_beatsToTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_beatsToTime
// convert a beat position (or optionally a beats+measures if measures is non-NULL) to time.

  double (*REAPERAPI_FUNCNAME(TimeMap2_beatsToTime))(ReaProject* proj, double tpos, const int* measuresInOptional);
#endif

#if defined(REAPERAPI_WANT_TimeMap2_GetDividedBpmAtTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_GetDividedBpmAtTime
// get the effective BPM at the time (seconds) position (i.e. 2x in /8 signatures)

  double (*REAPERAPI_FUNCNAME(TimeMap2_GetDividedBpmAtTime))(ReaProject* proj, double time);
#endif

#if defined(REAPERAPI_WANT_TimeMap2_GetNextChangeTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_GetNextChangeTime
// when does the next time map (tempo or time sig) change occur

  double (*REAPERAPI_FUNCNAME(TimeMap2_GetNextChangeTime))(ReaProject* proj, double time);
#endif

#if defined(REAPERAPI_WANT_TimeMap2_QNToTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_QNToTime
// converts project QN position to time.

  double (*REAPERAPI_FUNCNAME(TimeMap2_QNToTime))(ReaProject* proj, double qn);
#endif

#if defined(REAPERAPI_WANT_TimeMap2_timeToBeats) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_timeToBeats
// convert a time into beats.
// if measures is non-NULL, measures will be set to the measure count, return value will be beats since measure.
// if cml is non-NULL, will be set to current measure length in beats (i.e. time signature numerator)
// if fullbeats is non-NULL, and measures is non-NULL, fullbeats will get the full beat count (same value returned if measures is NULL).
// if cdenom is non-NULL, will be set to the current time signature denominator.

  double (*REAPERAPI_FUNCNAME(TimeMap2_timeToBeats))(ReaProject* proj, double tpos, int* measuresOutOptional, int* cmlOutOptional, double* fullbeatsOutOptional, int* cdenomOutOptional);
#endif

#if defined(REAPERAPI_WANT_TimeMap2_timeToQN) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap2_timeToQN
// converts project time position to QN position.

  double (*REAPERAPI_FUNCNAME(TimeMap2_timeToQN))(ReaProject* proj, double tpos);
#endif

#if defined(REAPERAPI_WANT_TimeMap_curFrameRate) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_curFrameRate
// Gets project framerate, and optionally whether it is drop-frame timecode

  double (*REAPERAPI_FUNCNAME(TimeMap_curFrameRate))(ReaProject* proj, bool* dropFrameOut);
#endif

#if defined(REAPERAPI_WANT_TimeMap_GetDividedBpmAtTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_GetDividedBpmAtTime
// get the effective BPM at the time (seconds) position (i.e. 2x in /8 signatures)

  double (*REAPERAPI_FUNCNAME(TimeMap_GetDividedBpmAtTime))(double time);
#endif

#if defined(REAPERAPI_WANT_TimeMap_GetMeasureInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_GetMeasureInfo
// Get the QN position and time signature information for the start of a measure. Return the time in seconds of the measure start.

  double (*REAPERAPI_FUNCNAME(TimeMap_GetMeasureInfo))(ReaProject* proj, int measure, double* qn_startOut, double* qn_endOut, int* timesig_numOut, int* timesig_denomOut, double* tempoOut);
#endif

#if defined(REAPERAPI_WANT_TimeMap_GetMetronomePattern) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_GetMetronomePattern
// Fills in a string representing the active metronome pattern. For example, in a 7/8 measure divided 3+4, the pattern might be "ABCABCD". For backwards compatibility, by default the function will return 1 for each primary beat and 2 for each non-primary beat, so "1221222" in this example, and does not support triplets. If buf is set to "EXTENDED", the function will return the full string as displayed in the pattern editor, including all beat types and triplet representations. Pass in "SET:string" with a correctly formed pattern string matching the current time signature numerator to set the click pattern. The time signature numerator can be deduced from the returned string, and the function returns the time signature denominator.

  int (*REAPERAPI_FUNCNAME(TimeMap_GetMetronomePattern))(ReaProject* proj, double time, char* pattern, int pattern_sz);
#endif

#if defined(REAPERAPI_WANT_TimeMap_GetTimeSigAtTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_GetTimeSigAtTime
// get the effective time signature and tempo

  void (*REAPERAPI_FUNCNAME(TimeMap_GetTimeSigAtTime))(ReaProject* proj, double time, int* timesig_numOut, int* timesig_denomOut, double* tempoOut);
#endif

#if defined(REAPERAPI_WANT_TimeMap_QNToMeasures) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_QNToMeasures
// Find which measure the given QN position falls in.

  int (*REAPERAPI_FUNCNAME(TimeMap_QNToMeasures))(ReaProject* proj, double qn, double* qnMeasureStartOutOptional, double* qnMeasureEndOutOptional);
#endif

#if defined(REAPERAPI_WANT_TimeMap_QNToTime) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_QNToTime
// converts project QN position to time.

  double (*REAPERAPI_FUNCNAME(TimeMap_QNToTime))(double qn);
#endif

#if defined(REAPERAPI_WANT_TimeMap_QNToTime_abs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_QNToTime_abs
// Converts project quarter note count (QN) to time. QN is counted from the start of the project, regardless of any partial measures. See TimeMap2_QNToTime

  double (*REAPERAPI_FUNCNAME(TimeMap_QNToTime_abs))(ReaProject* proj, double qn);
#endif

#if defined(REAPERAPI_WANT_TimeMap_timeToQN) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_timeToQN
// converts project QN position to time.

  double (*REAPERAPI_FUNCNAME(TimeMap_timeToQN))(double tpos);
#endif

#if defined(REAPERAPI_WANT_TimeMap_timeToQN_abs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TimeMap_timeToQN_abs
// Converts project time position to quarter note count (QN). QN is counted from the start of the project, regardless of any partial measures. See TimeMap2_timeToQN

  double (*REAPERAPI_FUNCNAME(TimeMap_timeToQN_abs))(ReaProject* proj, double tpos);
#endif

#if defined(REAPERAPI_WANT_ToggleTrackSendUIMute) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ToggleTrackSendUIMute
// send_idx<0 for receives, >=0 for hw ouputs, >=nb_of_hw_ouputs for sends.

  bool (*REAPERAPI_FUNCNAME(ToggleTrackSendUIMute))(MediaTrack* track, int send_idx);
#endif

#if defined(REAPERAPI_WANT_Track_GetPeakHoldDB) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Track_GetPeakHoldDB
// Returns meter hold state, in dB*0.01 (0 = +0dB, -0.01 = -1dB, 0.02 = +2dB, etc). If clear is set, clears the meter hold. If channel==1024 or channel==1025, returns loudness values if this is the master track or this track's VU meters are set to display loudness.

  double (*REAPERAPI_FUNCNAME(Track_GetPeakHoldDB))(MediaTrack* track, int channel, bool clear);
#endif

#if defined(REAPERAPI_WANT_Track_GetPeakInfo) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Track_GetPeakInfo
// Returns peak meter value (1.0=+0dB, 0.0=-inf) for channel. If channel==1024 or channel==1025, returns loudness values if this is the master track or this track's VU meters are set to display loudness.

  double (*REAPERAPI_FUNCNAME(Track_GetPeakInfo))(MediaTrack* track, int channel);
#endif

#if defined(REAPERAPI_WANT_TrackCtl_SetToolTip) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackCtl_SetToolTip
// displays tooltip at location, or removes if empty string

  void (*REAPERAPI_FUNCNAME(TrackCtl_SetToolTip))(const char* fmt, int xpos, int ypos, bool topmost);
#endif

#if defined(REAPERAPI_WANT_TrackFX_AddByName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_AddByName
// Adds or queries the position of a named FX from the track FX chain (recFX=false) or record input FX/monitoring FX (recFX=true, monitoring FX are on master track). Specify a negative value for instantiate to always create a new effect, 0 to only query the first instance of an effect, or a positive value to add an instance if one is not found. If instantiate is <= -1000, it is used for the insertion position (-1000 is first item in chain, -1001 is second, etc). fxname can have prefix to specify type: VST3:,VST2:,VST:,AU:,JS:, or DX:, or FXADD: which adds selected items from the currently-open FX browser, FXADD:2 to limit to 2 FX added, or FXADD:2e to only succeed if exactly 2 FX are selected. Returns -1 on failure or the new position in chain on success. FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_AddByName))(MediaTrack* track, const char* fxname, bool recFX, int instantiate);
#endif

#if defined(REAPERAPI_WANT_TrackFX_CopyToTake) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_CopyToTake
// Copies (or moves) FX from src_track to dest_take. src_fx can have 0x1000000 set to reference input FX. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_CopyToTake))(MediaTrack* src_track, int src_fx, MediaItem_Take* dest_take, int dest_fx, bool is_move);
#endif

#if defined(REAPERAPI_WANT_TrackFX_CopyToTrack) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_CopyToTrack
// Copies (or moves) FX from src_track to dest_track. Can be used with src_track=dest_track to reorder, FX indices have 0x1000000 set to reference input FX. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_CopyToTrack))(MediaTrack* src_track, int src_fx, MediaTrack* dest_track, int dest_fx, bool is_move);
#endif

#if defined(REAPERAPI_WANT_TrackFX_Delete) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_Delete
// Remove a FX from track chain (returns true on success) FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_Delete))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_EndParamEdit) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_EndParamEdit
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_EndParamEdit))(MediaTrack* track, int fx, int param);
#endif

#if defined(REAPERAPI_WANT_TrackFX_FormatParamValue) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_FormatParamValue
// Note: only works with FX that support Cockos VST extensions. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_FormatParamValue))(MediaTrack* track, int fx, int param, double val, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_FormatParamValueNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_FormatParamValueNormalized
// Note: only works with FX that support Cockos VST extensions. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_FormatParamValueNormalized))(MediaTrack* track, int fx, int param, double value, char* buf, int buf_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetByName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetByName
// Get the index of the first track FX insert that matches fxname. If the FX is not in the chain and instantiate is true, it will be inserted. See TrackFX_GetInstrument, TrackFX_GetEQ. Deprecated in favor of TrackFX_AddByName.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetByName))(MediaTrack* track, const char* fxname, bool instantiate);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetChainVisible) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetChainVisible
// returns index of effect visible in chain, or -1 for chain hidden, or -2 for chain visible but no effect selected

  int (*REAPERAPI_FUNCNAME(TrackFX_GetChainVisible))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetCount) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetCount

  int (*REAPERAPI_FUNCNAME(TrackFX_GetCount))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetEnabled
// See TrackFX_SetEnabled FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetEnabled))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetEQ) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetEQ
// Get the index of ReaEQ in the track FX chain. If ReaEQ is not in the chain and instantiate is true, it will be inserted. See TrackFX_GetInstrument, TrackFX_GetByName.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetEQ))(MediaTrack* track, bool instantiate);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetEQBandEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetEQBandEnabled
// Returns true if the EQ band is enabled.
// Returns false if the band is disabled, or if track/fxidx is not ReaEQ.
// Bandtype: -1=master gain, 0=hipass, 1=loshelf, 2=band, 3=notch, 4=hishelf, 5=lopass, 6=bandpass, 7=parallel bandpass.
// Bandidx (ignored for master gain): 0=target first band matching bandtype, 1=target 2nd band matching bandtype, etc.
// 
// See TrackFX_GetEQ, TrackFX_GetEQParam, TrackFX_SetEQParam, TrackFX_SetEQBandEnabled. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetEQBandEnabled))(MediaTrack* track, int fxidx, int bandtype, int bandidx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetEQParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetEQParam
// Returns false if track/fxidx is not ReaEQ.
// Bandtype: -1=master gain, 0=hipass, 1=loshelf, 2=band, 3=notch, 4=hishelf, 5=lopass, 6=bandpass, 7=parallel bandpass.
// Bandidx (ignored for master gain): 0=target first band matching bandtype, 1=target 2nd band matching bandtype, etc.
// Paramtype (ignored for master gain): 0=freq, 1=gain, 2=Q.
// See TrackFX_GetEQ, TrackFX_SetEQParam, TrackFX_GetEQBandEnabled, TrackFX_SetEQBandEnabled. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetEQParam))(MediaTrack* track, int fxidx, int paramidx, int* bandtypeOut, int* bandidxOut, int* paramtypeOut, double* normvalOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetFloatingWindow) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetFloatingWindow
// returns HWND of floating window for effect index, if any FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  HWND (*REAPERAPI_FUNCNAME(TrackFX_GetFloatingWindow))(MediaTrack* track, int index);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetFormattedParamValue) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetFormattedParamValue
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetFormattedParamValue))(MediaTrack* track, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetFXGUID) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetFXGUID
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  GUID* (*REAPERAPI_FUNCNAME(TrackFX_GetFXGUID))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetFXName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetFXName
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetFXName))(MediaTrack* track, int fx, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetInstrument) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetInstrument
// Get the index of the first track FX insert that is a virtual instrument, or -1 if none. See TrackFX_GetEQ, TrackFX_GetByName.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetInstrument))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetIOSize) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetIOSize
// Gets the number of input/output pins for FX if available, returns plug-in type or -1 on error FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetIOSize))(MediaTrack* track, int fx, int* inputPinsOut, int* outputPinsOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetNamedConfigParm
// gets plug-in specific named configuration value (returns true on success). 
// 
// Supported values for read:
// pdc : PDC latency
// in_pin_X : name of input pin X
// out_pin_X : name of output pin X
// fx_type : type string
// fx_ident : type-specific identifier
// fx_name : name of FX (also supported as original_name)
// GainReduction_dB : [ReaComp + other supported compressors]
// is_instrument : 1 if instrument, 0 if not (v7.40+)
// parent_container : FX ID of parent container, if any (v7.06+)
// container_count : [Container] number of FX in container
// container_item.X : FX ID of item in container (first item is container_item.0) (v7.06+)
// param.X.container_map.hint_id : unique ID of mapping (preserved if mapping order changes)
// param.X.container_map.delete : read this value in order to remove the mapping for this parameter
// container_map.add : read from this value to add a new container parameter mapping -- will return new parameter index (accessed via param.X.container_map.*)
// container_map.add.FXID.PARMIDX : read from this value to add/get container parameter mapping for FXID/PARMIDX -- will return the parameter index (accessed via param.X.container_map.*). FXID can be a full address (must be a child of the container) or a 0-based sub-index (v7.06+).
// container_map.get.FXID.PARMIDX : read from this value to get container parameter mapping for FXID/PARMIDX -- will return the parameter index (accessed via param.X.container_map.*). FXID can be a full address (must be a child of the container) or a 0-based sub-index (v7.06+).
// chain_pdc_actual : returns the actual chain latency in samples, only valid after playback has commenced, may be rounded up to block size.
// chain_pdc_reporting : returns the reported chain latency, always valid, not rounded to block size.
// 
// 
// Supported values for read/write:
// vst_chunk[_program] : base64-encoded VST-specific chunk.
// clap_chunk : base64-encoded CLAP-specific chunk.
// param.X.lfo.[active,dir,phase,speed,strength,temposync,free,shape] : parameter moduation LFO state
// param.X.acs.[active,dir,strength,attack,release,dblo,dbhi,chan,stereo,x2,y2] : parameter modulation ACS state
// param.X.plink.[active,scale,offset,effect,param,midi_bus,midi_chan,midi_msg,midi_msg2] : parameter link/MIDI link: set effect=-100 to support midi_*
// param.X.mod.[active,baseline,visible] : parameter module global settings
// param.X.learn.[midi1,midi2,osc] : first two bytes of MIDI message, or OSC string if set
// param.X.learn.mode : absolution/relative mode flag (0: Absolute, 1: 127=-1,1=+1, 2: 63=-1, 65=+1, 3: 65=-1, 1=+1, 4: toggle if nonzero)
// param.X.learn.flags : &1=selected track only, &2=soft takeover, &4=focused FX only, &8=LFO retrigger, &16=visible FX only
// param.X.container_map.fx_index : index of FX contained in container
// param.X.container_map.fx_parm : parameter index of parameter of FX contained in container
// param.X.container_map.aliased_name : name of parameter (if user-renamed, otherwise fails)
// BANDTYPEx, BANDENABLEDx : band configuration [ReaEQ]
// THRESHOLD, CEILING, TRUEPEAK : [ReaLimit]
// NUMCHANNELS, NUMSPEAKERS, RESETCHANNELS : [ReaSurroundPan]
// ITEMx : [ReaVerb] state configuration line, when writing should be followed by a write of DONE
// FILE, FILEx, -FILEx, +FILEx, -FILE* : [RS5k] file list, -/+ prefixes are write-only, when writing any, should be followed by a write of DONE
// MODE, RSMODE : [RS5k] general mode, resample mode
// VIDEO_CODE : [video processor] code
// force_auto_bypass : 0 or 1 - force auto-bypass plug-in on silence
// parallel : 0, 1 or 2 - 1=process plug-in in parallel with previous, 2=process plug-in parallel and merge MIDI
// instance_oversample_shift : instance oversampling shift amount, 0=none, 1=~96k, 2=~192k, etc. When setting requires playback stop/start to take effect
// chain_oversample_shift : chain oversampling shift amount, 0=none, 1=~96k, 2=~192k, etc. When setting requires playback stop/start to take effect
// chain_pdc_mode : chain PDC mode (0=classic, 1=new-default, 2=ignore PDC, 3=hwcomp-master)
// chain_sel : selected/visible FX in chain
// renamed_name : renamed FX instance name (empty string = not renamed)
// container_nch : number of internal channels for container
// container_nch_in : number of input pins for container
// container_nch_out : number of output pints for container
// container_nch_feedback : number of internal feedback channels enabled in container
// focused : reading returns 1 if focused. Writing a positive value to this sets the FX UI as "last focused."
// last_touched : reading returns two integers, one indicates whether FX is the last-touched FX, the second indicates which parameter was last touched. Writing a negative value ensures this plug-in is not set as last touched, otherwise the FX is set "last touched," and last touched parameter index is set to the value in the string (if valid).
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetNamedConfigParm))(MediaTrack* track, int fx, const char* parmname, char* bufOutNeedBig, int bufOutNeedBig_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetNumParams) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetNumParams
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetNumParams))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetOffline) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetOffline
// See TrackFX_SetOffline FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetOffline))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetOpen) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetOpen
// Returns true if this FX UI is open in the FX chain window or a floating window. See TrackFX_SetOpen FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetOpen))(MediaTrack* track, int fx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParam
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TrackFX_GetParam))(MediaTrack* track, int fx, int param, double* minvalOut, double* maxvalOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParameterStepSizes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParameterStepSizes
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetParameterStepSizes))(MediaTrack* track, int fx, int param, double* stepOut, double* smallstepOut, double* largestepOut, bool* istoggleOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParamEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParamEx
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TrackFX_GetParamEx))(MediaTrack* track, int fx, int param, double* minvalOut, double* maxvalOut, double* midvalOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParamFromIdent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParamFromIdent
// gets the parameter index from an identifying string (:wet, :bypass, :delta, or a string returned from GetParamIdent), or -1 if unknown. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetParamFromIdent))(MediaTrack* track, int fx, const char* ident_str);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParamIdent) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParamIdent
// gets an identifying string for the parameter FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetParamIdent))(MediaTrack* track, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParamName) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParamName
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetParamName))(MediaTrack* track, int fx, int param, char* bufOut, int bufOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetParamNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetParamNormalized
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  double (*REAPERAPI_FUNCNAME(TrackFX_GetParamNormalized))(MediaTrack* track, int fx, int param);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetPinMappings) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetPinMappings
// gets the effective channel mapping bitmask for a particular pin. high32Out will be set to the high 32 bits. Add 0x1000000 to pin index in order to access the second 64 bits of mappings independent of the first 64 bits. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetPinMappings))(MediaTrack* tr, int fx, int isoutput, int pin, int* high32Out);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetPreset) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetPreset
// Get the name of the preset currently showing in the REAPER dropdown, or the full path to a factory preset file for VST3 plug-ins (.vstpreset). See TrackFX_SetPreset. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_GetPreset))(MediaTrack* track, int fx, char* presetnameOut, int presetnameOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetPresetIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetPresetIndex
// Returns current preset index, or -1 if error. numberOfPresetsOut will be set to total number of presets available. See TrackFX_SetPresetByIndex FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetPresetIndex))(MediaTrack* track, int fx, int* numberOfPresetsOut);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetRecChainVisible) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetRecChainVisible
// returns index of effect visible in record input chain, or -1 for chain hidden, or -2 for chain visible but no effect selected

  int (*REAPERAPI_FUNCNAME(TrackFX_GetRecChainVisible))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetRecCount) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetRecCount
// returns count of record input FX. To access record input FX, use a FX indices [0x1000000..0x1000000+n). On the master track, this accesses monitoring FX rather than record input FX.

  int (*REAPERAPI_FUNCNAME(TrackFX_GetRecCount))(MediaTrack* track);
#endif

#if defined(REAPERAPI_WANT_TrackFX_GetUserPresetFilename) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_GetUserPresetFilename
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_GetUserPresetFilename))(MediaTrack* track, int fx, char* fnOut, int fnOut_sz);
#endif

#if defined(REAPERAPI_WANT_TrackFX_NavigatePresets) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_NavigatePresets
// presetmove==1 activates the next preset, presetmove==-1 activates the previous preset, etc. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_NavigatePresets))(MediaTrack* track, int fx, int presetmove);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetEnabled
// See TrackFX_GetEnabled FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_SetEnabled))(MediaTrack* track, int fx, bool enabled);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetEQBandEnabled) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetEQBandEnabled
// Enable or disable a ReaEQ band.
// Returns false if track/fxidx is not ReaEQ.
// Bandtype: -1=master gain, 0=hipass, 1=loshelf, 2=band, 3=notch, 4=hishelf, 5=lopass, 6=bandpass, 7=parallel bandpass.
// Bandidx (ignored for master gain): 0=target first band matching bandtype, 1=target 2nd band matching bandtype, etc.
// 
// See TrackFX_GetEQ, TrackFX_GetEQParam, TrackFX_SetEQParam, TrackFX_GetEQBandEnabled. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetEQBandEnabled))(MediaTrack* track, int fxidx, int bandtype, int bandidx, bool enable);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetEQParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetEQParam
// Returns false if track/fxidx is not ReaEQ. Targets a band matching bandtype.
// Bandtype: -1=master gain, 0=hipass, 1=loshelf, 2=band, 3=notch, 4=hishelf, 5=lopass, 6=bandpass, 7=parallel bandpass.
// Bandidx (ignored for master gain): 0=target first band matching bandtype, 1=target 2nd band matching bandtype, etc.
// Paramtype (ignored for master gain): 0=freq, 1=gain, 2=Q.
// See TrackFX_GetEQ, TrackFX_GetEQParam, TrackFX_GetEQBandEnabled, TrackFX_SetEQBandEnabled. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetEQParam))(MediaTrack* track, int fxidx, int bandtype, int bandidx, int paramtype, double val, bool isnorm);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetNamedConfigParm
// sets plug-in specific named configuration value (returns true on success).
// 
// Support values for write:
// vst_chunk[_program] : base64-encoded VST-specific chunk.
// clap_chunk : base64-encoded CLAP-specific chunk.
// param.X.lfo.[active,dir,phase,speed,strength,temposync,free,shape] : parameter moduation LFO state
// param.X.acs.[active,dir,strength,attack,release,dblo,dbhi,chan,stereo,x2,y2] : parameter modulation ACS state
// param.X.plink.[active,scale,offset,effect,param,midi_bus,midi_chan,midi_msg,midi_msg2] : parameter link/MIDI link: set effect=-100 to support midi_*
// param.X.mod.[active,baseline,visible] : parameter module global settings
// param.X.learn.[midi1,midi2,osc] : first two bytes of MIDI message, or OSC string if set
// param.X.learn.mode : absolution/relative mode flag (0: Absolute, 1: 127=-1,1=+1, 2: 63=-1, 65=+1, 3: 65=-1, 1=+1, 4: toggle if nonzero)
// param.X.learn.flags : &1=selected track only, &2=soft takeover, &4=focused FX only, &8=LFO retrigger, &16=visible FX only
// param.X.container_map.fx_index : index of FX contained in container
// param.X.container_map.fx_parm : parameter index of parameter of FX contained in container
// param.X.container_map.aliased_name : name of parameter (if user-renamed, otherwise fails)
// BANDTYPEx, BANDENABLEDx : band configuration [ReaEQ]
// THRESHOLD, CEILING, TRUEPEAK : [ReaLimit]
// NUMCHANNELS, NUMSPEAKERS, RESETCHANNELS : [ReaSurroundPan]
// ITEMx : [ReaVerb] state configuration line, when writing should be followed by a write of DONE
// FILE, FILEx, -FILEx, +FILEx, -FILE* : [RS5k] file list, -/+ prefixes are write-only, when writing any, should be followed by a write of DONE
// MODE, RSMODE : [RS5k] general mode, resample mode
// VIDEO_CODE : [video processor] code
// force_auto_bypass : 0 or 1 - force auto-bypass plug-in on silence
// parallel : 0, 1 or 2 - 1=process plug-in in parallel with previous, 2=process plug-in parallel and merge MIDI
// instance_oversample_shift : instance oversampling shift amount, 0=none, 1=~96k, 2=~192k, etc. When setting requires playback stop/start to take effect
// chain_oversample_shift : chain oversampling shift amount, 0=none, 1=~96k, 2=~192k, etc. When setting requires playback stop/start to take effect
// chain_pdc_mode : chain PDC mode (0=classic, 1=new-default, 2=ignore PDC, 3=hwcomp-master)
// chain_sel : selected/visible FX in chain
// renamed_name : renamed FX instance name (empty string = not renamed)
// container_nch : number of internal channels for container
// container_nch_in : number of input pins for container
// container_nch_out : number of output pints for container
// container_nch_feedback : number of internal feedback channels enabled in container
// focused : reading returns 1 if focused. Writing a positive value to this sets the FX UI as "last focused."
// last_touched : reading returns two integers, one indicates whether FX is the last-touched FX, the second indicates which parameter was last touched. Writing a negative value ensures this plug-in is not set as last touched, otherwise the FX is set "last touched," and last touched parameter index is set to the value in the string (if valid).
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetNamedConfigParm))(MediaTrack* track, int fx, const char* parmname, const char* value);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetOffline) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetOffline
// See TrackFX_GetOffline FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_SetOffline))(MediaTrack* track, int fx, bool offline);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetOpen) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetOpen
// Open this FX UI. See TrackFX_GetOpen FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_SetOpen))(MediaTrack* track, int fx, bool open);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetParam) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetParam
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetParam))(MediaTrack* track, int fx, int param, double val);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetParamNormalized) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetParamNormalized
//  FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetParamNormalized))(MediaTrack* track, int fx, int param, double value);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetPinMappings) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetPinMappings
// sets the channel mapping bitmask for a particular pin. returns false if unsupported (not all types of plug-ins support this capability). Add 0x1000000 to pin index in order to access the second 64 bits of mappings independent of the first 64 bits. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetPinMappings))(MediaTrack* tr, int fx, int isoutput, int pin, int low32bits, int hi32bits);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetPreset) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetPreset
// Activate a preset with the name shown in the REAPER dropdown. Full paths to .vstpreset files are also supported for VST3 plug-ins. See TrackFX_GetPreset. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetPreset))(MediaTrack* track, int fx, const char* presetname);
#endif

#if defined(REAPERAPI_WANT_TrackFX_SetPresetByIndex) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_SetPresetByIndex
// Sets the preset idx, or the factory preset (idx==-2), or the default user preset (idx==-1). Returns true on success. See TrackFX_GetPresetIndex. FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  bool (*REAPERAPI_FUNCNAME(TrackFX_SetPresetByIndex))(MediaTrack* track, int fx, int idx);
#endif

#if defined(REAPERAPI_WANT_TrackFX_Show) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackFX_Show
// showflag=0 for hidechain, =1 for show chain(index valid), =2 for hide floating window(index valid), =3 for show floating window (index valid) FX indices for tracks can have 0x1000000 added to them in order to reference record input FX (normal tracks) or hardware output FX (master track). FX indices can have 0x2000000 added to them, in which case they will be used to address FX in containers. To address a container, the 1-based subitem is multiplied by one plus the count of the FX chain and added to the 1-based container item index. e.g. to address the third item in the container at the second position of the track FX chain for tr, the index would be 0x2000000 + 3*(TrackFX_GetCount(tr)+1) + 2. This can be extended to sub-containers using TrackFX_GetNamedConfigParm with container_count and similar logic. In REAPER v7.06+, you can use the much more convenient method to navigate hierarchies, see TrackFX_GetNamedConfigParm with parent_container and container_item.X.

  void (*REAPERAPI_FUNCNAME(TrackFX_Show))(MediaTrack* track, int index, int showFlag);
#endif

#if defined(REAPERAPI_WANT_TrackList_AdjustWindows) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackList_AdjustWindows

  void (*REAPERAPI_FUNCNAME(TrackList_AdjustWindows))(bool isMinor);
#endif

#if defined(REAPERAPI_WANT_TrackList_UpdateAllExternalSurfaces) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// TrackList_UpdateAllExternalSurfaces

  void (*REAPERAPI_FUNCNAME(TrackList_UpdateAllExternalSurfaces))();
#endif

#if defined(REAPERAPI_WANT_Undo_BeginBlock) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_BeginBlock
// call to start a new block

  void (*REAPERAPI_FUNCNAME(Undo_BeginBlock))();
#endif

#if defined(REAPERAPI_WANT_Undo_BeginBlock2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_BeginBlock2
// call to start a new block

  void (*REAPERAPI_FUNCNAME(Undo_BeginBlock2))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Undo_CanRedo2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_CanRedo2
// returns string of next action,if able,NULL if not

  const char* (*REAPERAPI_FUNCNAME(Undo_CanRedo2))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Undo_CanUndo2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_CanUndo2
// returns string of last action,if able,NULL if not

  const char* (*REAPERAPI_FUNCNAME(Undo_CanUndo2))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Undo_DoRedo2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_DoRedo2
// nonzero if success

  int (*REAPERAPI_FUNCNAME(Undo_DoRedo2))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Undo_DoUndo2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_DoUndo2
// nonzero if success

  int (*REAPERAPI_FUNCNAME(Undo_DoUndo2))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_Undo_EndBlock) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_EndBlock
// call to end the block,with extra flags if any,and a description

  void (*REAPERAPI_FUNCNAME(Undo_EndBlock))(const char* descchange, int extraflags);
#endif

#if defined(REAPERAPI_WANT_Undo_EndBlock2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_EndBlock2
// call to end the block,with extra flags if any,and a description

  void (*REAPERAPI_FUNCNAME(Undo_EndBlock2))(ReaProject* proj, const char* descchange, int extraflags);
#endif

#if defined(REAPERAPI_WANT_Undo_OnStateChange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_OnStateChange
// limited state change to items

  void (*REAPERAPI_FUNCNAME(Undo_OnStateChange))(const char* descchange);
#endif

#if defined(REAPERAPI_WANT_Undo_OnStateChange2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_OnStateChange2
// limited state change to items

  void (*REAPERAPI_FUNCNAME(Undo_OnStateChange2))(ReaProject* proj, const char* descchange);
#endif

#if defined(REAPERAPI_WANT_Undo_OnStateChange_Item) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_OnStateChange_Item

  void (*REAPERAPI_FUNCNAME(Undo_OnStateChange_Item))(ReaProject* proj, const char* name, MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_Undo_OnStateChangeEx) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_OnStateChangeEx
// trackparm=-1 by default,or if updating one fx chain,you can specify track index

  void (*REAPERAPI_FUNCNAME(Undo_OnStateChangeEx))(const char* descchange, int whichStates, int trackparm);
#endif

#if defined(REAPERAPI_WANT_Undo_OnStateChangeEx2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// Undo_OnStateChangeEx2
// trackparm=-1 by default,or if updating one fx chain,you can specify track index

  void (*REAPERAPI_FUNCNAME(Undo_OnStateChangeEx2))(ReaProject* proj, const char* descchange, int whichStates, int trackparm);
#endif

#if defined(REAPERAPI_WANT_update_disk_counters) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// update_disk_counters
// Updates disk I/O statistics with bytes transferred since last call. notify REAPER of a write error by calling with readamt=0, writeamt=-101010110 for unknown or -101010111 for disk full

  void (*REAPERAPI_FUNCNAME(update_disk_counters))(int readamt, int writeamt);
#endif

#if defined(REAPERAPI_WANT_UpdateArrange) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// UpdateArrange
// Redraw the arrange view

  void (*REAPERAPI_FUNCNAME(UpdateArrange))();
#endif

#if defined(REAPERAPI_WANT_UpdateItemInProject) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// UpdateItemInProject

  void (*REAPERAPI_FUNCNAME(UpdateItemInProject))(MediaItem* item);
#endif

#if defined(REAPERAPI_WANT_UpdateItemLanes) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// UpdateItemLanes
// Recalculate lane arrangement for fixed lane tracks, including auto-removing empty lanes at the bottom of the track

  bool (*REAPERAPI_FUNCNAME(UpdateItemLanes))(ReaProject* proj);
#endif

#if defined(REAPERAPI_WANT_UpdateTimeline) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// UpdateTimeline
// Redraw the arrange view and ruler

  void (*REAPERAPI_FUNCNAME(UpdateTimeline))();
#endif

#if defined(REAPERAPI_WANT_ValidatePtr) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ValidatePtr
// see ValidatePtr2

  bool (*REAPERAPI_FUNCNAME(ValidatePtr))(void* pointer, const char* ctypename);
#endif

#if defined(REAPERAPI_WANT_ValidatePtr2) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ValidatePtr2
// Return true if the pointer is a valid object of the right type in proj (proj is ignored if pointer is itself a project). Supported types are: ReaProject*, MediaTrack*, MediaItem*, MediaItem_Take*, TrackEnvelope* and PCM_source*.

  bool (*REAPERAPI_FUNCNAME(ValidatePtr2))(ReaProject* proj, void* pointer, const char* ctypename);
#endif

#if defined(REAPERAPI_WANT_ViewPrefs) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// ViewPrefs
// Opens the prefs to a page, use pageByName if page is 0.

  void (*REAPERAPI_FUNCNAME(ViewPrefs))(int page, const char* pageByName);
#endif

#if defined(REAPERAPI_WANT_WDL_VirtualWnd_ScaledBlitBG) || !defined(REAPERAPI_MINIMAL)
REAPERAPI_DEF //==============================================
// WDL_VirtualWnd_ScaledBlitBG

  bool (*REAPERAPI_FUNCNAME(WDL_VirtualWnd_ScaledBlitBG))(LICE_IBitmap* dest, WDL_VirtualWnd_BGCfg* src, int destx, int desty, int destw, int desth, int clipx, int clipy, int clipw, int cliph, float alpha, int mode);
#endif

#ifdef REAPERAPI_IMPLEMENT
  int REAPERAPI_LoadAPI(void *(*getAPI)(const char *))
  {
    static const struct { void **dest; const char *name; } table[]={
      #if defined(REAPERAPI_WANT___mergesort) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(__mergesort),"__mergesort"},
      #endif
      #if defined(REAPERAPI_WANT_AddCustomizableMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddCustomizableMenu),"AddCustomizableMenu"},
      #endif
      #if defined(REAPERAPI_WANT_AddExtensionsMainMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddExtensionsMainMenu),"AddExtensionsMainMenu"},
      #endif
      #if defined(REAPERAPI_WANT_AddMediaItemToTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddMediaItemToTrack),"AddMediaItemToTrack"},
      #endif
      #if defined(REAPERAPI_WANT_AddProjectMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddProjectMarker),"AddProjectMarker"},
      #endif
      #if defined(REAPERAPI_WANT_AddProjectMarker2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddProjectMarker2),"AddProjectMarker2"},
      #endif
      #if defined(REAPERAPI_WANT_AddRemoveReaScript) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddRemoveReaScript),"AddRemoveReaScript"},
      #endif
      #if defined(REAPERAPI_WANT_AddTakeToMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddTakeToMediaItem),"AddTakeToMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_AddTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AddTempoTimeSigMarker),"AddTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_adjustZoom) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(adjustZoom),"adjustZoom"},
      #endif
      #if defined(REAPERAPI_WANT_AdvancePlaybackPosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AdvancePlaybackPosition),"AdvancePlaybackPosition"},
      #endif
      #if defined(REAPERAPI_WANT_AnyTrackSolo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AnyTrackSolo),"AnyTrackSolo"},
      #endif
      #if defined(REAPERAPI_WANT_APIExists) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(APIExists),"APIExists"},
      #endif
      #if defined(REAPERAPI_WANT_APITest) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(APITest),"APITest"},
      #endif
      #if defined(REAPERAPI_WANT_ApplyNudge) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ApplyNudge),"ApplyNudge"},
      #endif
      #if defined(REAPERAPI_WANT_ArmCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ArmCommand),"ArmCommand"},
      #endif
      #if defined(REAPERAPI_WANT_Audio_Init) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Audio_Init),"Audio_Init"},
      #endif
      #if defined(REAPERAPI_WANT_Audio_IsPreBuffer) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Audio_IsPreBuffer),"Audio_IsPreBuffer"},
      #endif
      #if defined(REAPERAPI_WANT_Audio_IsRunning) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Audio_IsRunning),"Audio_IsRunning"},
      #endif
      #if defined(REAPERAPI_WANT_Audio_Quit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Audio_Quit),"Audio_Quit"},
      #endif
      #if defined(REAPERAPI_WANT_Audio_RegHardwareHook) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Audio_RegHardwareHook),"Audio_RegHardwareHook"},
      #endif
      #if defined(REAPERAPI_WANT_AudioAccessorStateChanged) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AudioAccessorStateChanged),"AudioAccessorStateChanged"},
      #endif
      #if defined(REAPERAPI_WANT_AudioAccessorUpdate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AudioAccessorUpdate),"AudioAccessorUpdate"},
      #endif
      #if defined(REAPERAPI_WANT_AudioAccessorValidateState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(AudioAccessorValidateState),"AudioAccessorValidateState"},
      #endif
      #if defined(REAPERAPI_WANT_BypassFxAllTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(BypassFxAllTracks),"BypassFxAllTracks"},
      #endif
      #if defined(REAPERAPI_WANT_CalcMediaSrcLoudness) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CalcMediaSrcLoudness),"CalcMediaSrcLoudness"},
      #endif
      #if defined(REAPERAPI_WANT_CalculateNormalization) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CalculateNormalization),"CalculateNormalization"},
      #endif
      #if defined(REAPERAPI_WANT_CalculatePeaks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CalculatePeaks),"CalculatePeaks"},
      #endif
      #if defined(REAPERAPI_WANT_CalculatePeaksFloatSrcPtr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CalculatePeaksFloatSrcPtr),"CalculatePeaksFloatSrcPtr"},
      #endif
      #if defined(REAPERAPI_WANT_ClearAllRecArmed) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ClearAllRecArmed),"ClearAllRecArmed"},
      #endif
      #if defined(REAPERAPI_WANT_ClearConsole) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ClearConsole),"ClearConsole"},
      #endif
      #if defined(REAPERAPI_WANT_ClearPeakCache) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ClearPeakCache),"ClearPeakCache"},
      #endif
      #if defined(REAPERAPI_WANT_ColorFromNative) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ColorFromNative),"ColorFromNative"},
      #endif
      #if defined(REAPERAPI_WANT_ColorToNative) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ColorToNative),"ColorToNative"},
      #endif
      #if defined(REAPERAPI_WANT_CountActionShortcuts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountActionShortcuts),"CountActionShortcuts"},
      #endif
      #if defined(REAPERAPI_WANT_CountAutomationItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountAutomationItems),"CountAutomationItems"},
      #endif
      #if defined(REAPERAPI_WANT_CountEnvelopePoints) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountEnvelopePoints),"CountEnvelopePoints"},
      #endif
      #if defined(REAPERAPI_WANT_CountEnvelopePointsEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountEnvelopePointsEx),"CountEnvelopePointsEx"},
      #endif
      #if defined(REAPERAPI_WANT_CountMediaItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountMediaItems),"CountMediaItems"},
      #endif
      #if defined(REAPERAPI_WANT_CountProjectMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountProjectMarkers),"CountProjectMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_CountSelectedMediaItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountSelectedMediaItems),"CountSelectedMediaItems"},
      #endif
      #if defined(REAPERAPI_WANT_CountSelectedTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountSelectedTracks),"CountSelectedTracks"},
      #endif
      #if defined(REAPERAPI_WANT_CountSelectedTracks2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountSelectedTracks2),"CountSelectedTracks2"},
      #endif
      #if defined(REAPERAPI_WANT_CountTakeEnvelopes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTakeEnvelopes),"CountTakeEnvelopes"},
      #endif
      #if defined(REAPERAPI_WANT_CountTakes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTakes),"CountTakes"},
      #endif
      #if defined(REAPERAPI_WANT_CountTCPFXParms) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTCPFXParms),"CountTCPFXParms"},
      #endif
      #if defined(REAPERAPI_WANT_CountTempoTimeSigMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTempoTimeSigMarkers),"CountTempoTimeSigMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_CountTrackEnvelopes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTrackEnvelopes),"CountTrackEnvelopes"},
      #endif
      #if defined(REAPERAPI_WANT_CountTrackMediaItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTrackMediaItems),"CountTrackMediaItems"},
      #endif
      #if defined(REAPERAPI_WANT_CountTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CountTracks),"CountTracks"},
      #endif
      #if defined(REAPERAPI_WANT_CreateLocalOscHandler) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateLocalOscHandler),"CreateLocalOscHandler"},
      #endif
      #if defined(REAPERAPI_WANT_CreateMIDIInput) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateMIDIInput),"CreateMIDIInput"},
      #endif
      #if defined(REAPERAPI_WANT_CreateMIDIOutput) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateMIDIOutput),"CreateMIDIOutput"},
      #endif
      #if defined(REAPERAPI_WANT_CreateNewMIDIItemInProj) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateNewMIDIItemInProj),"CreateNewMIDIItemInProj"},
      #endif
      #if defined(REAPERAPI_WANT_CreateTakeAudioAccessor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateTakeAudioAccessor),"CreateTakeAudioAccessor"},
      #endif
      #if defined(REAPERAPI_WANT_CreateTrackAudioAccessor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateTrackAudioAccessor),"CreateTrackAudioAccessor"},
      #endif
      #if defined(REAPERAPI_WANT_CreateTrackSend) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CreateTrackSend),"CreateTrackSend"},
      #endif
      #if defined(REAPERAPI_WANT_CrossfadeEditor_OnCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CrossfadeEditor_OnCommand),"CrossfadeEditor_OnCommand"},
      #endif
      #if defined(REAPERAPI_WANT_CrossfadeEditor_Show) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CrossfadeEditor_Show),"CrossfadeEditor_Show"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_FlushUndo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_FlushUndo),"CSurf_FlushUndo"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_GetTouchState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_GetTouchState),"CSurf_GetTouchState"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_GoEnd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_GoEnd),"CSurf_GoEnd"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_GoStart) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_GoStart),"CSurf_GoStart"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_NumTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_NumTracks),"CSurf_NumTracks"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnArrow) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnArrow),"CSurf_OnArrow"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnFwd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnFwd),"CSurf_OnFwd"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnFXChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnFXChange),"CSurf_OnFXChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnInputMonitorChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnInputMonitorChange),"CSurf_OnInputMonitorChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnInputMonitorChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnInputMonitorChangeEx),"CSurf_OnInputMonitorChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnMuteChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnMuteChange),"CSurf_OnMuteChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnMuteChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnMuteChangeEx),"CSurf_OnMuteChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnOscControlMessage) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnOscControlMessage),"CSurf_OnOscControlMessage"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnOscControlMessage2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnOscControlMessage2),"CSurf_OnOscControlMessage2"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnPanChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnPanChange),"CSurf_OnPanChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnPanChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnPanChangeEx),"CSurf_OnPanChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnPause) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnPause),"CSurf_OnPause"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnPlay) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnPlay),"CSurf_OnPlay"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnPlayRateChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnPlayRateChange),"CSurf_OnPlayRateChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRecArmChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRecArmChange),"CSurf_OnRecArmChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRecArmChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRecArmChangeEx),"CSurf_OnRecArmChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRecord) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRecord),"CSurf_OnRecord"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRecvPanChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRecvPanChange),"CSurf_OnRecvPanChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRecvVolumeChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRecvVolumeChange),"CSurf_OnRecvVolumeChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRew) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRew),"CSurf_OnRew"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnRewFwd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnRewFwd),"CSurf_OnRewFwd"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnScroll) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnScroll),"CSurf_OnScroll"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnSelectedChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnSelectedChange),"CSurf_OnSelectedChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnSendPanChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnSendPanChange),"CSurf_OnSendPanChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnSendVolumeChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnSendVolumeChange),"CSurf_OnSendVolumeChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnSoloChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnSoloChange),"CSurf_OnSoloChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnSoloChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnSoloChangeEx),"CSurf_OnSoloChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnStop) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnStop),"CSurf_OnStop"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnTempoChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnTempoChange),"CSurf_OnTempoChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnTrackSelection) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnTrackSelection),"CSurf_OnTrackSelection"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnVolumeChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnVolumeChange),"CSurf_OnVolumeChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnVolumeChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnVolumeChangeEx),"CSurf_OnVolumeChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnWidthChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnWidthChange),"CSurf_OnWidthChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnWidthChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnWidthChangeEx),"CSurf_OnWidthChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_OnZoom) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_OnZoom),"CSurf_OnZoom"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_ResetAllCachedVolPanStates) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_ResetAllCachedVolPanStates),"CSurf_ResetAllCachedVolPanStates"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_ScrubAmt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_ScrubAmt),"CSurf_ScrubAmt"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetAutoMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetAutoMode),"CSurf_SetAutoMode"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetPlayState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetPlayState),"CSurf_SetPlayState"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetRepeatState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetRepeatState),"CSurf_SetRepeatState"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfaceMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfaceMute),"CSurf_SetSurfaceMute"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfacePan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfacePan),"CSurf_SetSurfacePan"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfaceRecArm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfaceRecArm),"CSurf_SetSurfaceRecArm"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfaceSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfaceSelected),"CSurf_SetSurfaceSelected"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfaceSolo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfaceSolo),"CSurf_SetSurfaceSolo"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetSurfaceVolume) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetSurfaceVolume),"CSurf_SetSurfaceVolume"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_SetTrackListChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_SetTrackListChange),"CSurf_SetTrackListChange"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_TrackFromID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_TrackFromID),"CSurf_TrackFromID"},
      #endif
      #if defined(REAPERAPI_WANT_CSurf_TrackToID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(CSurf_TrackToID),"CSurf_TrackToID"},
      #endif
      #if defined(REAPERAPI_WANT_DB2SLIDER) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DB2SLIDER),"DB2SLIDER"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteActionShortcut) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteActionShortcut),"DeleteActionShortcut"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteEnvelopePointEx),"DeleteEnvelopePointEx"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteEnvelopePointRange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteEnvelopePointRange),"DeleteEnvelopePointRange"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteEnvelopePointRangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteEnvelopePointRangeEx),"DeleteEnvelopePointRangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteExtState),"DeleteExtState"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteProjectMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteProjectMarker),"DeleteProjectMarker"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteProjectMarkerByIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteProjectMarkerByIndex),"DeleteProjectMarkerByIndex"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteTakeMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteTakeMarker),"DeleteTakeMarker"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteTakeStretchMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteTakeStretchMarkers),"DeleteTakeStretchMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteTempoTimeSigMarker),"DeleteTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteTrack),"DeleteTrack"},
      #endif
      #if defined(REAPERAPI_WANT_DeleteTrackMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DeleteTrackMediaItem),"DeleteTrackMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_DestroyAudioAccessor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DestroyAudioAccessor),"DestroyAudioAccessor"},
      #endif
      #if defined(REAPERAPI_WANT_DestroyLocalOscHandler) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DestroyLocalOscHandler),"DestroyLocalOscHandler"},
      #endif
      #if defined(REAPERAPI_WANT_DoActionShortcutDialog) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DoActionShortcutDialog),"DoActionShortcutDialog"},
      #endif
      #if defined(REAPERAPI_WANT_Dock_UpdateDockID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Dock_UpdateDockID),"Dock_UpdateDockID"},
      #endif
      #if defined(REAPERAPI_WANT_DockGetPosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockGetPosition),"DockGetPosition"},
      #endif
      #if defined(REAPERAPI_WANT_DockIsChildOfDock) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockIsChildOfDock),"DockIsChildOfDock"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowActivate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowActivate),"DockWindowActivate"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowAdd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowAdd),"DockWindowAdd"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowAddEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowAddEx),"DockWindowAddEx"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowRefresh) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowRefresh),"DockWindowRefresh"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowRefreshForHWND) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowRefreshForHWND),"DockWindowRefreshForHWND"},
      #endif
      #if defined(REAPERAPI_WANT_DockWindowRemove) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DockWindowRemove),"DockWindowRemove"},
      #endif
      #if defined(REAPERAPI_WANT_DuplicateCustomizableMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(DuplicateCustomizableMenu),"DuplicateCustomizableMenu"},
      #endif
      #if defined(REAPERAPI_WANT_EditTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EditTempoTimeSigMarker),"EditTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_EnsureNotCompletelyOffscreen) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnsureNotCompletelyOffscreen),"EnsureNotCompletelyOffscreen"},
      #endif
      #if defined(REAPERAPI_WANT_EnumerateFiles) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumerateFiles),"EnumerateFiles"},
      #endif
      #if defined(REAPERAPI_WANT_EnumerateSubdirectories) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumerateSubdirectories),"EnumerateSubdirectories"},
      #endif
      #if defined(REAPERAPI_WANT_EnumInstalledFX) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumInstalledFX),"EnumInstalledFX"},
      #endif
      #if defined(REAPERAPI_WANT_EnumPitchShiftModes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumPitchShiftModes),"EnumPitchShiftModes"},
      #endif
      #if defined(REAPERAPI_WANT_EnumPitchShiftSubModes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumPitchShiftSubModes),"EnumPitchShiftSubModes"},
      #endif
      #if defined(REAPERAPI_WANT_EnumProjectMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumProjectMarkers),"EnumProjectMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_EnumProjectMarkers2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumProjectMarkers2),"EnumProjectMarkers2"},
      #endif
      #if defined(REAPERAPI_WANT_EnumProjectMarkers3) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumProjectMarkers3),"EnumProjectMarkers3"},
      #endif
      #if defined(REAPERAPI_WANT_EnumProjects) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumProjects),"EnumProjects"},
      #endif
      #if defined(REAPERAPI_WANT_EnumProjExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumProjExtState),"EnumProjExtState"},
      #endif
      #if defined(REAPERAPI_WANT_EnumRegionRenderMatrix) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumRegionRenderMatrix),"EnumRegionRenderMatrix"},
      #endif
      #if defined(REAPERAPI_WANT_EnumTrackMIDIProgramNames) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumTrackMIDIProgramNames),"EnumTrackMIDIProgramNames"},
      #endif
      #if defined(REAPERAPI_WANT_EnumTrackMIDIProgramNamesEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(EnumTrackMIDIProgramNamesEx),"EnumTrackMIDIProgramNamesEx"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_Evaluate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_Evaluate),"Envelope_Evaluate"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_FormatValue) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_FormatValue),"Envelope_FormatValue"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_GetParentTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_GetParentTake),"Envelope_GetParentTake"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_GetParentTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_GetParentTrack),"Envelope_GetParentTrack"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_SortPoints) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_SortPoints),"Envelope_SortPoints"},
      #endif
      #if defined(REAPERAPI_WANT_Envelope_SortPointsEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Envelope_SortPointsEx),"Envelope_SortPointsEx"},
      #endif
      #if defined(REAPERAPI_WANT_ExecProcess) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ExecProcess),"ExecProcess"},
      #endif
      #if defined(REAPERAPI_WANT_file_exists) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(file_exists),"file_exists"},
      #endif
      #if defined(REAPERAPI_WANT_FindTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(FindTempoTimeSigMarker),"FindTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_format_timestr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(format_timestr),"format_timestr"},
      #endif
      #if defined(REAPERAPI_WANT_format_timestr_len) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(format_timestr_len),"format_timestr_len"},
      #endif
      #if defined(REAPERAPI_WANT_format_timestr_pos) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(format_timestr_pos),"format_timestr_pos"},
      #endif
      #if defined(REAPERAPI_WANT_FreeHeapPtr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(FreeHeapPtr),"FreeHeapPtr"},
      #endif
      #if defined(REAPERAPI_WANT_genGuid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(genGuid),"genGuid"},
      #endif
      #if defined(REAPERAPI_WANT_get_config_var) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(get_config_var),"get_config_var"},
      #endif
      #if defined(REAPERAPI_WANT_get_config_var_string) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(get_config_var_string),"get_config_var_string"},
      #endif
      #if defined(REAPERAPI_WANT_get_ini_file) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(get_ini_file),"get_ini_file"},
      #endif
      #if defined(REAPERAPI_WANT_get_midi_config_var) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(get_midi_config_var),"get_midi_config_var"},
      #endif
      #if defined(REAPERAPI_WANT_GetActionShortcutDesc) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetActionShortcutDesc),"GetActionShortcutDesc"},
      #endif
      #if defined(REAPERAPI_WANT_GetActiveTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetActiveTake),"GetActiveTake"},
      #endif
      #if defined(REAPERAPI_WANT_GetAllProjectPlayStates) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAllProjectPlayStates),"GetAllProjectPlayStates"},
      #endif
      #if defined(REAPERAPI_WANT_GetAppVersion) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAppVersion),"GetAppVersion"},
      #endif
      #if defined(REAPERAPI_WANT_GetArmedCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetArmedCommand),"GetArmedCommand"},
      #endif
      #if defined(REAPERAPI_WANT_GetAudioAccessorEndTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAudioAccessorEndTime),"GetAudioAccessorEndTime"},
      #endif
      #if defined(REAPERAPI_WANT_GetAudioAccessorHash) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAudioAccessorHash),"GetAudioAccessorHash"},
      #endif
      #if defined(REAPERAPI_WANT_GetAudioAccessorSamples) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAudioAccessorSamples),"GetAudioAccessorSamples"},
      #endif
      #if defined(REAPERAPI_WANT_GetAudioAccessorStartTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAudioAccessorStartTime),"GetAudioAccessorStartTime"},
      #endif
      #if defined(REAPERAPI_WANT_GetAudioDeviceInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetAudioDeviceInfo),"GetAudioDeviceInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetColorTheme) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetColorTheme),"GetColorTheme"},
      #endif
      #if defined(REAPERAPI_WANT_GetColorThemeStruct) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetColorThemeStruct),"GetColorThemeStruct"},
      #endif
      #if defined(REAPERAPI_WANT_GetConfigWantsDock) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetConfigWantsDock),"GetConfigWantsDock"},
      #endif
      #if defined(REAPERAPI_WANT_GetContextMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetContextMenu),"GetContextMenu"},
      #endif
      #if defined(REAPERAPI_WANT_GetCurrentProjectInLoadSave) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetCurrentProjectInLoadSave),"GetCurrentProjectInLoadSave"},
      #endif
      #if defined(REAPERAPI_WANT_GetCursorContext) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetCursorContext),"GetCursorContext"},
      #endif
      #if defined(REAPERAPI_WANT_GetCursorContext2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetCursorContext2),"GetCursorContext2"},
      #endif
      #if defined(REAPERAPI_WANT_GetCursorPosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetCursorPosition),"GetCursorPosition"},
      #endif
      #if defined(REAPERAPI_WANT_GetCursorPositionEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetCursorPositionEx),"GetCursorPositionEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetDisplayedMediaItemColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetDisplayedMediaItemColor),"GetDisplayedMediaItemColor"},
      #endif
      #if defined(REAPERAPI_WANT_GetDisplayedMediaItemColor2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetDisplayedMediaItemColor2),"GetDisplayedMediaItemColor2"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopeInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopeInfo_Value),"GetEnvelopeInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopeName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopeName),"GetEnvelopeName"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopePoint),"GetEnvelopePoint"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopePointByTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopePointByTime),"GetEnvelopePointByTime"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopePointByTimeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopePointByTimeEx),"GetEnvelopePointByTimeEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopePointEx),"GetEnvelopePointEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopeScalingMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopeScalingMode),"GetEnvelopeScalingMode"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopeStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopeStateChunk),"GetEnvelopeStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_GetEnvelopeUIState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetEnvelopeUIState),"GetEnvelopeUIState"},
      #endif
      #if defined(REAPERAPI_WANT_GetExePath) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetExePath),"GetExePath"},
      #endif
      #if defined(REAPERAPI_WANT_GetExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetExtState),"GetExtState"},
      #endif
      #if defined(REAPERAPI_WANT_GetFocusedFX) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetFocusedFX),"GetFocusedFX"},
      #endif
      #if defined(REAPERAPI_WANT_GetFocusedFX2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetFocusedFX2),"GetFocusedFX2"},
      #endif
      #if defined(REAPERAPI_WANT_GetFreeDiskSpaceForRecordPath) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetFreeDiskSpaceForRecordPath),"GetFreeDiskSpaceForRecordPath"},
      #endif
      #if defined(REAPERAPI_WANT_GetFXEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetFXEnvelope),"GetFXEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_GetGlobalAutomationOverride) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetGlobalAutomationOverride),"GetGlobalAutomationOverride"},
      #endif
      #if defined(REAPERAPI_WANT_GetHZoomLevel) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetHZoomLevel),"GetHZoomLevel"},
      #endif
      #if defined(REAPERAPI_WANT_GetIconThemePointer) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetIconThemePointer),"GetIconThemePointer"},
      #endif
      #if defined(REAPERAPI_WANT_GetIconThemePointerForDPI) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetIconThemePointerForDPI),"GetIconThemePointerForDPI"},
      #endif
      #if defined(REAPERAPI_WANT_GetIconThemeStruct) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetIconThemeStruct),"GetIconThemeStruct"},
      #endif
      #if defined(REAPERAPI_WANT_GetInputActivityLevel) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetInputActivityLevel),"GetInputActivityLevel"},
      #endif
      #if defined(REAPERAPI_WANT_GetInputChannelName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetInputChannelName),"GetInputChannelName"},
      #endif
      #if defined(REAPERAPI_WANT_GetInputOutputLatency) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetInputOutputLatency),"GetInputOutputLatency"},
      #endif
      #if defined(REAPERAPI_WANT_GetItemEditingTime2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetItemEditingTime2),"GetItemEditingTime2"},
      #endif
      #if defined(REAPERAPI_WANT_GetItemFromPoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetItemFromPoint),"GetItemFromPoint"},
      #endif
      #if defined(REAPERAPI_WANT_GetItemProjectContext) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetItemProjectContext),"GetItemProjectContext"},
      #endif
      #if defined(REAPERAPI_WANT_GetItemStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetItemStateChunk),"GetItemStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_GetLastColorThemeFile) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetLastColorThemeFile),"GetLastColorThemeFile"},
      #endif
      #if defined(REAPERAPI_WANT_GetLastMarkerAndCurRegion) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetLastMarkerAndCurRegion),"GetLastMarkerAndCurRegion"},
      #endif
      #if defined(REAPERAPI_WANT_GetLastTouchedFX) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetLastTouchedFX),"GetLastTouchedFX"},
      #endif
      #if defined(REAPERAPI_WANT_GetLastTouchedTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetLastTouchedTrack),"GetLastTouchedTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetMainHwnd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMainHwnd),"GetMainHwnd"},
      #endif
      #if defined(REAPERAPI_WANT_GetMasterMuteSoloFlags) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMasterMuteSoloFlags),"GetMasterMuteSoloFlags"},
      #endif
      #if defined(REAPERAPI_WANT_GetMasterTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMasterTrack),"GetMasterTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetMasterTrackVisibility) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMasterTrackVisibility),"GetMasterTrackVisibility"},
      #endif
      #if defined(REAPERAPI_WANT_GetMaxMidiInputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMaxMidiInputs),"GetMaxMidiInputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetMaxMidiOutputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMaxMidiOutputs),"GetMaxMidiOutputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaFileMetadata) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaFileMetadata),"GetMediaFileMetadata"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItem),"GetMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItem_Track) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItem_Track),"GetMediaItem_Track"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemInfo_Value),"GetMediaItemInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemNumTakes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemNumTakes),"GetMediaItemNumTakes"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTake),"GetMediaItemTake"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTake_Item) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTake_Item),"GetMediaItemTake_Item"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTake_Peaks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTake_Peaks),"GetMediaItemTake_Peaks"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTake_Source) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTake_Source),"GetMediaItemTake_Source"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTake_Track) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTake_Track),"GetMediaItemTake_Track"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTakeByGUID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTakeByGUID),"GetMediaItemTakeByGUID"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTakeInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTakeInfo_Value),"GetMediaItemTakeInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaItemTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaItemTrack),"GetMediaItemTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceFileName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceFileName),"GetMediaSourceFileName"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceLength) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceLength),"GetMediaSourceLength"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceNumChannels) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceNumChannels),"GetMediaSourceNumChannels"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceParent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceParent),"GetMediaSourceParent"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceSampleRate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceSampleRate),"GetMediaSourceSampleRate"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaSourceType) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaSourceType),"GetMediaSourceType"},
      #endif
      #if defined(REAPERAPI_WANT_GetMediaTrackInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMediaTrackInfo_Value),"GetMediaTrackInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_GetMIDIInputName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMIDIInputName),"GetMIDIInputName"},
      #endif
      #if defined(REAPERAPI_WANT_GetMIDIOutputName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMIDIOutputName),"GetMIDIOutputName"},
      #endif
      #if defined(REAPERAPI_WANT_GetMixerScroll) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMixerScroll),"GetMixerScroll"},
      #endif
      #if defined(REAPERAPI_WANT_GetMouseModifier) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMouseModifier),"GetMouseModifier"},
      #endif
      #if defined(REAPERAPI_WANT_GetMousePosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetMousePosition),"GetMousePosition"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumAudioInputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumAudioInputs),"GetNumAudioInputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumAudioOutputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumAudioOutputs),"GetNumAudioOutputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumMIDIInputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumMIDIInputs),"GetNumMIDIInputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumMIDIOutputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumMIDIOutputs),"GetNumMIDIOutputs"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumTakeMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumTakeMarkers),"GetNumTakeMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_GetNumTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetNumTracks),"GetNumTracks"},
      #endif
      #if defined(REAPERAPI_WANT_GetOS) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetOS),"GetOS"},
      #endif
      #if defined(REAPERAPI_WANT_GetOutputChannelName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetOutputChannelName),"GetOutputChannelName"},
      #endif
      #if defined(REAPERAPI_WANT_GetOutputLatency) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetOutputLatency),"GetOutputLatency"},
      #endif
      #if defined(REAPERAPI_WANT_GetParentTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetParentTrack),"GetParentTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetPeakFileName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPeakFileName),"GetPeakFileName"},
      #endif
      #if defined(REAPERAPI_WANT_GetPeakFileNameEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPeakFileNameEx),"GetPeakFileNameEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetPeakFileNameEx2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPeakFileNameEx2),"GetPeakFileNameEx2"},
      #endif
      #if defined(REAPERAPI_WANT_GetPeaksBitmap) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPeaksBitmap),"GetPeaksBitmap"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayLoopCnt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayLoopCnt),"GetPlayLoopCnt"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayPosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayPosition),"GetPlayPosition"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayPosition2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayPosition2),"GetPlayPosition2"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayPosition2Ex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayPosition2Ex),"GetPlayPosition2Ex"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayPositionEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayPositionEx),"GetPlayPositionEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayState),"GetPlayState"},
      #endif
      #if defined(REAPERAPI_WANT_GetPlayStateEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPlayStateEx),"GetPlayStateEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetPreferredDiskReadMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPreferredDiskReadMode),"GetPreferredDiskReadMode"},
      #endif
      #if defined(REAPERAPI_WANT_GetPreferredDiskReadModePeak) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPreferredDiskReadModePeak),"GetPreferredDiskReadModePeak"},
      #endif
      #if defined(REAPERAPI_WANT_GetPreferredDiskWriteMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetPreferredDiskWriteMode),"GetPreferredDiskWriteMode"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectLength) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectLength),"GetProjectLength"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectName),"GetProjectName"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectPath) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectPath),"GetProjectPath"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectPathEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectPathEx),"GetProjectPathEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectStateChangeCount) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectStateChangeCount),"GetProjectStateChangeCount"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectTimeOffset) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectTimeOffset),"GetProjectTimeOffset"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectTimeSignature) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectTimeSignature),"GetProjectTimeSignature"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjectTimeSignature2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjectTimeSignature2),"GetProjectTimeSignature2"},
      #endif
      #if defined(REAPERAPI_WANT_GetProjExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetProjExtState),"GetProjExtState"},
      #endif
      #if defined(REAPERAPI_WANT_GetResourcePath) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetResourcePath),"GetResourcePath"},
      #endif
      #if defined(REAPERAPI_WANT_GetSelectedEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSelectedEnvelope),"GetSelectedEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_GetSelectedMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSelectedMediaItem),"GetSelectedMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_GetSelectedTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSelectedTrack),"GetSelectedTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetSelectedTrack2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSelectedTrack2),"GetSelectedTrack2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSelectedTrackEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSelectedTrackEnvelope),"GetSelectedTrackEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_GetSet_ArrangeView2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSet_ArrangeView2),"GetSet_ArrangeView2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSet_LoopTimeRange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSet_LoopTimeRange),"GetSet_LoopTimeRange"},
      #endif
      #if defined(REAPERAPI_WANT_GetSet_LoopTimeRange2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSet_LoopTimeRange2),"GetSet_LoopTimeRange2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetAutomationItemInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetAutomationItemInfo),"GetSetAutomationItemInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetAutomationItemInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetAutomationItemInfo_String),"GetSetAutomationItemInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetEnvelopeInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetEnvelopeInfo_String),"GetSetEnvelopeInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetEnvelopeState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetEnvelopeState),"GetSetEnvelopeState"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetEnvelopeState2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetEnvelopeState2),"GetSetEnvelopeState2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetItemState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetItemState),"GetSetItemState"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetItemState2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetItemState2),"GetSetItemState2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaItemInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaItemInfo),"GetSetMediaItemInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaItemInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaItemInfo_String),"GetSetMediaItemInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaItemTakeInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaItemTakeInfo),"GetSetMediaItemTakeInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaItemTakeInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaItemTakeInfo_String),"GetSetMediaItemTakeInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaTrackInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaTrackInfo),"GetSetMediaTrackInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetMediaTrackInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetMediaTrackInfo_String),"GetSetMediaTrackInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetObjectState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetObjectState),"GetSetObjectState"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetObjectState2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetObjectState2),"GetSetObjectState2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetProjectAuthor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetProjectAuthor),"GetSetProjectAuthor"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetProjectGrid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetProjectGrid),"GetSetProjectGrid"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetProjectInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetProjectInfo),"GetSetProjectInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetProjectInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetProjectInfo_String),"GetSetProjectInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetProjectNotes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetProjectNotes),"GetSetProjectNotes"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetRepeat) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetRepeat),"GetSetRepeat"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetRepeatEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetRepeatEx),"GetSetRepeatEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTempoTimeSigMarkerFlag) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTempoTimeSigMarkerFlag),"GetSetTempoTimeSigMarkerFlag"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackGroupMembership) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackGroupMembership),"GetSetTrackGroupMembership"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackGroupMembershipEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackGroupMembershipEx),"GetSetTrackGroupMembershipEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackGroupMembershipHigh) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackGroupMembershipHigh),"GetSetTrackGroupMembershipHigh"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackMIDISupportFile) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackMIDISupportFile),"GetSetTrackMIDISupportFile"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackSendInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackSendInfo),"GetSetTrackSendInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackSendInfo_String) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackSendInfo_String),"GetSetTrackSendInfo_String"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackState),"GetSetTrackState"},
      #endif
      #if defined(REAPERAPI_WANT_GetSetTrackState2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSetTrackState2),"GetSetTrackState2"},
      #endif
      #if defined(REAPERAPI_WANT_GetSubProjectFromSource) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetSubProjectFromSource),"GetSubProjectFromSource"},
      #endif
      #if defined(REAPERAPI_WANT_GetTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTake),"GetTake"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeEnvelope),"GetTakeEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeEnvelopeByName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeEnvelopeByName),"GetTakeEnvelopeByName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeMarker),"GetTakeMarker"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeName),"GetTakeName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeNumStretchMarkers) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeNumStretchMarkers),"GetTakeNumStretchMarkers"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeStretchMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeStretchMarker),"GetTakeStretchMarker"},
      #endif
      #if defined(REAPERAPI_WANT_GetTakeStretchMarkerSlope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTakeStretchMarkerSlope),"GetTakeStretchMarkerSlope"},
      #endif
      #if defined(REAPERAPI_WANT_GetTCPFXParm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTCPFXParm),"GetTCPFXParm"},
      #endif
      #if defined(REAPERAPI_WANT_GetTempoMatchPlayRate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTempoMatchPlayRate),"GetTempoMatchPlayRate"},
      #endif
      #if defined(REAPERAPI_WANT_GetTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTempoTimeSigMarker),"GetTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_GetThemeColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetThemeColor),"GetThemeColor"},
      #endif
      #if defined(REAPERAPI_WANT_GetThingFromPoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetThingFromPoint),"GetThingFromPoint"},
      #endif
      #if defined(REAPERAPI_WANT_GetToggleCommandState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetToggleCommandState),"GetToggleCommandState"},
      #endif
      #if defined(REAPERAPI_WANT_GetToggleCommandState2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetToggleCommandState2),"GetToggleCommandState2"},
      #endif
      #if defined(REAPERAPI_WANT_GetToggleCommandStateEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetToggleCommandStateEx),"GetToggleCommandStateEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetToggleCommandStateThroughHooks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetToggleCommandStateThroughHooks),"GetToggleCommandStateThroughHooks"},
      #endif
      #if defined(REAPERAPI_WANT_GetTooltipWindow) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTooltipWindow),"GetTooltipWindow"},
      #endif
      #if defined(REAPERAPI_WANT_GetTouchedOrFocusedFX) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTouchedOrFocusedFX),"GetTouchedOrFocusedFX"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrack),"GetTrack"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackAutomationMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackAutomationMode),"GetTrackAutomationMode"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackColor),"GetTrackColor"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackDepth) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackDepth),"GetTrackDepth"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackEnvelope),"GetTrackEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackEnvelopeByChunkName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackEnvelopeByChunkName),"GetTrackEnvelopeByChunkName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackEnvelopeByName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackEnvelopeByName),"GetTrackEnvelopeByName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackFromPoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackFromPoint),"GetTrackFromPoint"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackGUID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackGUID),"GetTrackGUID"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackInfo),"GetTrackInfo"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackMediaItem),"GetTrackMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackMIDILyrics) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackMIDILyrics),"GetTrackMIDILyrics"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackMIDINoteName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackMIDINoteName),"GetTrackMIDINoteName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackMIDINoteNameEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackMIDINoteNameEx),"GetTrackMIDINoteNameEx"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackMIDINoteRange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackMIDINoteRange),"GetTrackMIDINoteRange"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackName),"GetTrackName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackNumMediaItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackNumMediaItems),"GetTrackNumMediaItems"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackNumSends) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackNumSends),"GetTrackNumSends"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackReceiveName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackReceiveName),"GetTrackReceiveName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackReceiveUIMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackReceiveUIMute),"GetTrackReceiveUIMute"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackReceiveUIVolPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackReceiveUIVolPan),"GetTrackReceiveUIVolPan"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackSendInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackSendInfo_Value),"GetTrackSendInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackSendName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackSendName),"GetTrackSendName"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackSendUIMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackSendUIMute),"GetTrackSendUIMute"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackSendUIVolPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackSendUIVolPan),"GetTrackSendUIVolPan"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackState),"GetTrackState"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackStateChunk),"GetTrackStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackUIMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackUIMute),"GetTrackUIMute"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackUIPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackUIPan),"GetTrackUIPan"},
      #endif
      #if defined(REAPERAPI_WANT_GetTrackUIVolPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetTrackUIVolPan),"GetTrackUIVolPan"},
      #endif
      #if defined(REAPERAPI_WANT_GetUnderrunTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetUnderrunTime),"GetUnderrunTime"},
      #endif
      #if defined(REAPERAPI_WANT_GetUserFileNameForRead) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetUserFileNameForRead),"GetUserFileNameForRead"},
      #endif
      #if defined(REAPERAPI_WANT_GetUserInputs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GetUserInputs),"GetUserInputs"},
      #endif
      #if defined(REAPERAPI_WANT_GoToMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GoToMarker),"GoToMarker"},
      #endif
      #if defined(REAPERAPI_WANT_GoToRegion) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GoToRegion),"GoToRegion"},
      #endif
      #if defined(REAPERAPI_WANT_GR_SelectColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GR_SelectColor),"GR_SelectColor"},
      #endif
      #if defined(REAPERAPI_WANT_GSC_mainwnd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(GSC_mainwnd),"GSC_mainwnd"},
      #endif
      #if defined(REAPERAPI_WANT_guidToString) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(guidToString),"guidToString"},
      #endif
      #if defined(REAPERAPI_WANT_HasExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(HasExtState),"HasExtState"},
      #endif
      #if defined(REAPERAPI_WANT_HasTrackMIDIPrograms) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(HasTrackMIDIPrograms),"HasTrackMIDIPrograms"},
      #endif
      #if defined(REAPERAPI_WANT_HasTrackMIDIProgramsEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(HasTrackMIDIProgramsEx),"HasTrackMIDIProgramsEx"},
      #endif
      #if defined(REAPERAPI_WANT_Help_Set) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Help_Set),"Help_Set"},
      #endif
      #if defined(REAPERAPI_WANT_HiresPeaksFromSource) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(HiresPeaksFromSource),"HiresPeaksFromSource"},
      #endif
      #if defined(REAPERAPI_WANT_image_resolve_fn) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(image_resolve_fn),"image_resolve_fn"},
      #endif
      #if defined(REAPERAPI_WANT_InsertAutomationItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertAutomationItem),"InsertAutomationItem"},
      #endif
      #if defined(REAPERAPI_WANT_InsertEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertEnvelopePoint),"InsertEnvelopePoint"},
      #endif
      #if defined(REAPERAPI_WANT_InsertEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertEnvelopePointEx),"InsertEnvelopePointEx"},
      #endif
      #if defined(REAPERAPI_WANT_InsertMedia) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertMedia),"InsertMedia"},
      #endif
      #if defined(REAPERAPI_WANT_InsertMediaSection) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertMediaSection),"InsertMediaSection"},
      #endif
      #if defined(REAPERAPI_WANT_InsertTrackAtIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertTrackAtIndex),"InsertTrackAtIndex"},
      #endif
      #if defined(REAPERAPI_WANT_InsertTrackInProject) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(InsertTrackInProject),"InsertTrackInProject"},
      #endif
      #if defined(REAPERAPI_WANT_IsInRealTimeAudio) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsInRealTimeAudio),"IsInRealTimeAudio"},
      #endif
      #if defined(REAPERAPI_WANT_IsItemTakeActiveForPlayback) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsItemTakeActiveForPlayback),"IsItemTakeActiveForPlayback"},
      #endif
      #if defined(REAPERAPI_WANT_IsMediaExtension) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsMediaExtension),"IsMediaExtension"},
      #endif
      #if defined(REAPERAPI_WANT_IsMediaItemSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsMediaItemSelected),"IsMediaItemSelected"},
      #endif
      #if defined(REAPERAPI_WANT_IsProjectDirty) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsProjectDirty),"IsProjectDirty"},
      #endif
      #if defined(REAPERAPI_WANT_IsREAPER) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsREAPER),"IsREAPER"},
      #endif
      #if defined(REAPERAPI_WANT_IsTrackSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsTrackSelected),"IsTrackSelected"},
      #endif
      #if defined(REAPERAPI_WANT_IsTrackVisible) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsTrackVisible),"IsTrackVisible"},
      #endif
      #if defined(REAPERAPI_WANT_IsWindowTextField) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(IsWindowTextField),"IsWindowTextField"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_create),"joystick_create"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_destroy) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_destroy),"joystick_destroy"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_enum) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_enum),"joystick_enum"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_getaxis) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_getaxis),"joystick_getaxis"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_getbuttonmask) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_getbuttonmask),"joystick_getbuttonmask"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_getinfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_getinfo),"joystick_getinfo"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_getpov) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_getpov),"joystick_getpov"},
      #endif
      #if defined(REAPERAPI_WANT_joystick_update) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(joystick_update),"joystick_update"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_enumerateActions) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_enumerateActions),"kbd_enumerateActions"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_formatKeyName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_formatKeyName),"kbd_formatKeyName"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_getCommandName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_getCommandName),"kbd_getCommandName"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_getTextFromCmd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_getTextFromCmd),"kbd_getTextFromCmd"},
      #endif
      #if defined(REAPERAPI_WANT_KBD_OnMainActionEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(KBD_OnMainActionEx),"KBD_OnMainActionEx"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_OnMidiEvent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_OnMidiEvent),"kbd_OnMidiEvent"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_OnMidiList) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_OnMidiList),"kbd_OnMidiList"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_ProcessActionsMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_ProcessActionsMenu),"kbd_ProcessActionsMenu"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_processMidiEventActionEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_processMidiEventActionEx),"kbd_processMidiEventActionEx"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_reprocessMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_reprocessMenu),"kbd_reprocessMenu"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_RunCommandThroughHooks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_RunCommandThroughHooks),"kbd_RunCommandThroughHooks"},
      #endif
      #if defined(REAPERAPI_WANT_kbd_translateAccelerator) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(kbd_translateAccelerator),"kbd_translateAccelerator"},
      #endif


    #ifndef REAPERAPI_NO_LICE
      #if defined(REAPERAPI_WANT_LICE__Destroy) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__Destroy),"LICE__Destroy"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__DestroyFont) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__DestroyFont),"LICE__DestroyFont"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__DrawText) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__DrawText),"LICE__DrawText"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__GetBits) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__GetBits),"LICE__GetBits"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__GetDC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__GetDC),"LICE__GetDC"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__GetHeight) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__GetHeight),"LICE__GetHeight"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__GetRowSpan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__GetRowSpan),"LICE__GetRowSpan"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__GetWidth) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__GetWidth),"LICE__GetWidth"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__IsFlipped) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__IsFlipped),"LICE__IsFlipped"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__resize) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__resize),"LICE__resize"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__SetBkColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__SetBkColor),"LICE__SetBkColor"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__SetFromHFont) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__SetFromHFont),"LICE__SetFromHFont"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__SetTextColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__SetTextColor),"LICE__SetTextColor"},
      #endif
      #if defined(REAPERAPI_WANT_LICE__SetTextCombineMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE__SetTextCombineMode),"LICE__SetTextCombineMode"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Arc) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Arc),"LICE_Arc"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Blit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Blit),"LICE_Blit"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Blur) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Blur),"LICE_Blur"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_BorderedRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_BorderedRect),"LICE_BorderedRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Circle) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Circle),"LICE_Circle"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Clear) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Clear),"LICE_Clear"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_ClearRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_ClearRect),"LICE_ClearRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_ClipLine) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_ClipLine),"LICE_ClipLine"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_CombinePixels) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_CombinePixels),"LICE_CombinePixels"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Copy) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Copy),"LICE_Copy"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_CreateBitmap) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_CreateBitmap),"LICE_CreateBitmap"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_CreateFont) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_CreateFont),"LICE_CreateFont"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_DrawCBezier) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_DrawCBezier),"LICE_DrawCBezier"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_DrawChar) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_DrawChar),"LICE_DrawChar"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_DrawGlyph) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_DrawGlyph),"LICE_DrawGlyph"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_DrawRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_DrawRect),"LICE_DrawRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_DrawText) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_DrawText),"LICE_DrawText"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillCBezier) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillCBezier),"LICE_FillCBezier"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillCircle) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillCircle),"LICE_FillCircle"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillConvexPolygon) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillConvexPolygon),"LICE_FillConvexPolygon"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillRect),"LICE_FillRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillTrapezoid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillTrapezoid),"LICE_FillTrapezoid"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_FillTriangle) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_FillTriangle),"LICE_FillTriangle"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_GetPixel) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_GetPixel),"LICE_GetPixel"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_GradRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_GradRect),"LICE_GradRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_Line) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_Line),"LICE_Line"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_LineInt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_LineInt),"LICE_LineInt"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_LoadPNG) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_LoadPNG),"LICE_LoadPNG"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_LoadPNGFromResource) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_LoadPNGFromResource),"LICE_LoadPNGFromResource"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_MeasureText) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_MeasureText),"LICE_MeasureText"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_MultiplyAddRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_MultiplyAddRect),"LICE_MultiplyAddRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_PutPixel) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_PutPixel),"LICE_PutPixel"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_RotatedBlit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_RotatedBlit),"LICE_RotatedBlit"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_RoundRect) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_RoundRect),"LICE_RoundRect"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_ScaledBlit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_ScaledBlit),"LICE_ScaledBlit"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_SimpleFill) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_SimpleFill),"LICE_SimpleFill"},
      #endif
      #if defined(REAPERAPI_WANT_LICE_ThickFLine) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LICE_ThickFLine),"LICE_ThickFLine"},
      #endif

    #endif // !REAPERAPI_NO_LICE

      #if defined(REAPERAPI_WANT_LocalizeString) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(LocalizeString),"LocalizeString"},
      #endif
      #if defined(REAPERAPI_WANT_Loop_OnArrow) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Loop_OnArrow),"Loop_OnArrow"},
      #endif
      #if defined(REAPERAPI_WANT_Main_OnCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_OnCommand),"Main_OnCommand"},
      #endif
      #if defined(REAPERAPI_WANT_Main_OnCommandEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_OnCommandEx),"Main_OnCommandEx"},
      #endif
      #if defined(REAPERAPI_WANT_Main_openProject) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_openProject),"Main_openProject"},
      #endif
      #if defined(REAPERAPI_WANT_Main_SaveProject) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_SaveProject),"Main_SaveProject"},
      #endif
      #if defined(REAPERAPI_WANT_Main_SaveProjectEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_SaveProjectEx),"Main_SaveProjectEx"},
      #endif
      #if defined(REAPERAPI_WANT_Main_UpdateLoopInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Main_UpdateLoopInfo),"Main_UpdateLoopInfo"},
      #endif
      #if defined(REAPERAPI_WANT_MarkProjectDirty) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MarkProjectDirty),"MarkProjectDirty"},
      #endif
      #if defined(REAPERAPI_WANT_MarkTrackItemsDirty) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MarkTrackItemsDirty),"MarkTrackItemsDirty"},
      #endif
      #if defined(REAPERAPI_WANT_Master_GetPlayRate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Master_GetPlayRate),"Master_GetPlayRate"},
      #endif
      #if defined(REAPERAPI_WANT_Master_GetPlayRateAtTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Master_GetPlayRateAtTime),"Master_GetPlayRateAtTime"},
      #endif
      #if defined(REAPERAPI_WANT_Master_GetTempo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Master_GetTempo),"Master_GetTempo"},
      #endif
      #if defined(REAPERAPI_WANT_Master_NormalizePlayRate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Master_NormalizePlayRate),"Master_NormalizePlayRate"},
      #endif
      #if defined(REAPERAPI_WANT_Master_NormalizeTempo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Master_NormalizeTempo),"Master_NormalizeTempo"},
      #endif
      #if defined(REAPERAPI_WANT_MB) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MB),"MB"},
      #endif
      #if defined(REAPERAPI_WANT_MediaExplorerGetLastPlayedFileInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MediaExplorerGetLastPlayedFileInfo),"MediaExplorerGetLastPlayedFileInfo"},
      #endif
      #if defined(REAPERAPI_WANT_MediaItemDescendsFromTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MediaItemDescendsFromTrack),"MediaItemDescendsFromTrack"},
      #endif
      #if defined(REAPERAPI_WANT_Menu_GetHash) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Menu_GetHash),"Menu_GetHash"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_CountEvts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_CountEvts),"MIDI_CountEvts"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_DeleteCC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_DeleteCC),"MIDI_DeleteCC"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_DeleteEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_DeleteEvt),"MIDI_DeleteEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_DeleteNote) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_DeleteNote),"MIDI_DeleteNote"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_DeleteTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_DeleteTextSysexEvt),"MIDI_DeleteTextSysexEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_DisableSort) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_DisableSort),"MIDI_DisableSort"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_EnumSelCC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_EnumSelCC),"MIDI_EnumSelCC"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_EnumSelEvts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_EnumSelEvts),"MIDI_EnumSelEvts"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_EnumSelNotes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_EnumSelNotes),"MIDI_EnumSelNotes"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_EnumSelTextSysexEvts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_EnumSelTextSysexEvts),"MIDI_EnumSelTextSysexEvts"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_eventlist_Create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_eventlist_Create),"MIDI_eventlist_Create"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_eventlist_Destroy) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_eventlist_Destroy),"MIDI_eventlist_Destroy"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetAllEvts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetAllEvts),"MIDI_GetAllEvts"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetCC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetCC),"MIDI_GetCC"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetCCShape) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetCCShape),"MIDI_GetCCShape"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetEvt),"MIDI_GetEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetGrid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetGrid),"MIDI_GetGrid"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetHash) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetHash),"MIDI_GetHash"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetNote) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetNote),"MIDI_GetNote"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetPPQPos_EndOfMeasure) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetPPQPos_EndOfMeasure),"MIDI_GetPPQPos_EndOfMeasure"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetPPQPos_StartOfMeasure) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetPPQPos_StartOfMeasure),"MIDI_GetPPQPos_StartOfMeasure"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetPPQPosFromProjQN) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetPPQPosFromProjQN),"MIDI_GetPPQPosFromProjQN"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetPPQPosFromProjTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetPPQPosFromProjTime),"MIDI_GetPPQPosFromProjTime"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetProjQNFromPPQPos) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetProjQNFromPPQPos),"MIDI_GetProjQNFromPPQPos"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetProjTimeFromPPQPos) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetProjTimeFromPPQPos),"MIDI_GetProjTimeFromPPQPos"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetRecentInputEvent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetRecentInputEvent),"MIDI_GetRecentInputEvent"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetScale) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetScale),"MIDI_GetScale"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetTextSysexEvt),"MIDI_GetTextSysexEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_GetTrackHash) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_GetTrackHash),"MIDI_GetTrackHash"},
      #endif
      #if defined(REAPERAPI_WANT_midi_init) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(midi_init),"midi_init"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_InsertCC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_InsertCC),"MIDI_InsertCC"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_InsertEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_InsertEvt),"MIDI_InsertEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_InsertNote) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_InsertNote),"MIDI_InsertNote"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_InsertTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_InsertTextSysexEvt),"MIDI_InsertTextSysexEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_RefreshEditors) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_RefreshEditors),"MIDI_RefreshEditors"},
      #endif
      #if defined(REAPERAPI_WANT_midi_reinit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(midi_reinit),"midi_reinit"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SelectAll) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SelectAll),"MIDI_SelectAll"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetAllEvts) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetAllEvts),"MIDI_SetAllEvts"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetCC) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetCC),"MIDI_SetCC"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetCCShape) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetCCShape),"MIDI_SetCCShape"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetEvt),"MIDI_SetEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetItemExtents) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetItemExtents),"MIDI_SetItemExtents"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetNote) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetNote),"MIDI_SetNote"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_SetTextSysexEvt) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_SetTextSysexEvt),"MIDI_SetTextSysexEvt"},
      #endif
      #if defined(REAPERAPI_WANT_MIDI_Sort) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDI_Sort),"MIDI_Sort"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_EnumTakes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_EnumTakes),"MIDIEditor_EnumTakes"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_GetActive) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_GetActive),"MIDIEditor_GetActive"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_GetMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_GetMode),"MIDIEditor_GetMode"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_GetSetting_int) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_GetSetting_int),"MIDIEditor_GetSetting_int"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_GetSetting_str) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_GetSetting_str),"MIDIEditor_GetSetting_str"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_GetTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_GetTake),"MIDIEditor_GetTake"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_LastFocused_OnCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_LastFocused_OnCommand),"MIDIEditor_LastFocused_OnCommand"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_OnCommand) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_OnCommand),"MIDIEditor_OnCommand"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditor_SetSetting_int) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditor_SetSetting_int),"MIDIEditor_SetSetting_int"},
      #endif
      #if defined(REAPERAPI_WANT_MIDIEditorFlagsForTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MIDIEditorFlagsForTrack),"MIDIEditorFlagsForTrack"},
      #endif
      #if defined(REAPERAPI_WANT_mkpanstr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(mkpanstr),"mkpanstr"},
      #endif
      #if defined(REAPERAPI_WANT_mkvolpanstr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(mkvolpanstr),"mkvolpanstr"},
      #endif
      #if defined(REAPERAPI_WANT_mkvolstr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(mkvolstr),"mkvolstr"},
      #endif
      #if defined(REAPERAPI_WANT_MoveEditCursor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MoveEditCursor),"MoveEditCursor"},
      #endif
      #if defined(REAPERAPI_WANT_MoveMediaItemToTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MoveMediaItemToTrack),"MoveMediaItemToTrack"},
      #endif
      #if defined(REAPERAPI_WANT_MuteAllTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(MuteAllTracks),"MuteAllTracks"},
      #endif
      #if defined(REAPERAPI_WANT_my_getViewport) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(my_getViewport),"my_getViewport"},
      #endif
      #if defined(REAPERAPI_WANT_NamedCommandLookup) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(NamedCommandLookup),"NamedCommandLookup"},
      #endif
      #if defined(REAPERAPI_WANT_OnPauseButton) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnPauseButton),"OnPauseButton"},
      #endif
      #if defined(REAPERAPI_WANT_OnPauseButtonEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnPauseButtonEx),"OnPauseButtonEx"},
      #endif
      #if defined(REAPERAPI_WANT_OnPlayButton) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnPlayButton),"OnPlayButton"},
      #endif
      #if defined(REAPERAPI_WANT_OnPlayButtonEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnPlayButtonEx),"OnPlayButtonEx"},
      #endif
      #if defined(REAPERAPI_WANT_OnStopButton) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnStopButton),"OnStopButton"},
      #endif
      #if defined(REAPERAPI_WANT_OnStopButtonEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OnStopButtonEx),"OnStopButtonEx"},
      #endif
      #if defined(REAPERAPI_WANT_OpenColorThemeFile) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OpenColorThemeFile),"OpenColorThemeFile"},
      #endif
      #if defined(REAPERAPI_WANT_OpenMediaExplorer) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OpenMediaExplorer),"OpenMediaExplorer"},
      #endif
      #if defined(REAPERAPI_WANT_OscLocalMessageToHost) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(OscLocalMessageToHost),"OscLocalMessageToHost"},
      #endif
      #if defined(REAPERAPI_WANT_parse_timestr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(parse_timestr),"parse_timestr"},
      #endif
      #if defined(REAPERAPI_WANT_parse_timestr_len) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(parse_timestr_len),"parse_timestr_len"},
      #endif
      #if defined(REAPERAPI_WANT_parse_timestr_pos) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(parse_timestr_pos),"parse_timestr_pos"},
      #endif
      #if defined(REAPERAPI_WANT_parsepanstr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(parsepanstr),"parsepanstr"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_Create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_Create),"PCM_Sink_Create"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_CreateEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_CreateEx),"PCM_Sink_CreateEx"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_CreateMIDIFile) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_CreateMIDIFile),"PCM_Sink_CreateMIDIFile"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_CreateMIDIFileEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_CreateMIDIFileEx),"PCM_Sink_CreateMIDIFileEx"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_Enum) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_Enum),"PCM_Sink_Enum"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_GetExtension) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_GetExtension),"PCM_Sink_GetExtension"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Sink_ShowConfig) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Sink_ShowConfig),"PCM_Sink_ShowConfig"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_BuildPeaks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_BuildPeaks),"PCM_Source_BuildPeaks"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_CreateFromFile) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_CreateFromFile),"PCM_Source_CreateFromFile"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_CreateFromFileEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_CreateFromFileEx),"PCM_Source_CreateFromFileEx"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_CreateFromSimple) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_CreateFromSimple),"PCM_Source_CreateFromSimple"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_CreateFromType) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_CreateFromType),"PCM_Source_CreateFromType"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_Destroy) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_Destroy),"PCM_Source_Destroy"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_GetPeaks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_GetPeaks),"PCM_Source_GetPeaks"},
      #endif
      #if defined(REAPERAPI_WANT_PCM_Source_GetSectionInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PCM_Source_GetSectionInfo),"PCM_Source_GetSectionInfo"},
      #endif
      #if defined(REAPERAPI_WANT_PeakBuild_Create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PeakBuild_Create),"PeakBuild_Create"},
      #endif
      #if defined(REAPERAPI_WANT_PeakBuild_CreateEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PeakBuild_CreateEx),"PeakBuild_CreateEx"},
      #endif
      #if defined(REAPERAPI_WANT_PeakGet_Create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PeakGet_Create),"PeakGet_Create"},
      #endif
      #if defined(REAPERAPI_WANT_PitchShiftSubModeMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PitchShiftSubModeMenu),"PitchShiftSubModeMenu"},
      #endif
      #if defined(REAPERAPI_WANT_PlayPreview) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PlayPreview),"PlayPreview"},
      #endif
      #if defined(REAPERAPI_WANT_PlayPreviewEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PlayPreviewEx),"PlayPreviewEx"},
      #endif
      #if defined(REAPERAPI_WANT_PlayTrackPreview) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PlayTrackPreview),"PlayTrackPreview"},
      #endif
      #if defined(REAPERAPI_WANT_PlayTrackPreview2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PlayTrackPreview2),"PlayTrackPreview2"},
      #endif
      #if defined(REAPERAPI_WANT_PlayTrackPreview2Ex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PlayTrackPreview2Ex),"PlayTrackPreview2Ex"},
      #endif
      #if defined(REAPERAPI_WANT_plugin_getapi) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(plugin_getapi),"plugin_getapi"},
      #endif
      #if defined(REAPERAPI_WANT_plugin_getFilterList) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(plugin_getFilterList),"plugin_getFilterList"},
      #endif
      #if defined(REAPERAPI_WANT_plugin_getImportableProjectFilterList) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(plugin_getImportableProjectFilterList),"plugin_getImportableProjectFilterList"},
      #endif
      #if defined(REAPERAPI_WANT_plugin_register) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(plugin_register),"plugin_register"},
      #endif
      #if defined(REAPERAPI_WANT_PluginWantsAlwaysRunFx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PluginWantsAlwaysRunFx),"PluginWantsAlwaysRunFx"},
      #endif
      #if defined(REAPERAPI_WANT_PreventUIRefresh) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PreventUIRefresh),"PreventUIRefresh"},
      #endif
      #if defined(REAPERAPI_WANT_projectconfig_var_addr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(projectconfig_var_addr),"projectconfig_var_addr"},
      #endif
      #if defined(REAPERAPI_WANT_projectconfig_var_getoffs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(projectconfig_var_getoffs),"projectconfig_var_getoffs"},
      #endif
      #if defined(REAPERAPI_WANT_PromptForAction) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(PromptForAction),"PromptForAction"},
      #endif
      #if defined(REAPERAPI_WANT_realloc_cmd_clear) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(realloc_cmd_clear),"realloc_cmd_clear"},
      #endif
      #if defined(REAPERAPI_WANT_realloc_cmd_ptr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(realloc_cmd_ptr),"realloc_cmd_ptr"},
      #endif
      #if defined(REAPERAPI_WANT_realloc_cmd_register_buf) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(realloc_cmd_register_buf),"realloc_cmd_register_buf"},
      #endif
      #if defined(REAPERAPI_WANT_ReaperGetPitchShiftAPI) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ReaperGetPitchShiftAPI),"ReaperGetPitchShiftAPI"},
      #endif
      #if defined(REAPERAPI_WANT_ReaScriptError) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ReaScriptError),"ReaScriptError"},
      #endif
      #if defined(REAPERAPI_WANT_RecursiveCreateDirectory) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(RecursiveCreateDirectory),"RecursiveCreateDirectory"},
      #endif
      #if defined(REAPERAPI_WANT_reduce_open_files) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(reduce_open_files),"reduce_open_files"},
      #endif
      #if defined(REAPERAPI_WANT_RefreshToolbar) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(RefreshToolbar),"RefreshToolbar"},
      #endif
      #if defined(REAPERAPI_WANT_RefreshToolbar2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(RefreshToolbar2),"RefreshToolbar2"},
      #endif
      #if defined(REAPERAPI_WANT_relative_fn) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(relative_fn),"relative_fn"},
      #endif
      #if defined(REAPERAPI_WANT_RemoveTrackSend) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(RemoveTrackSend),"RemoveTrackSend"},
      #endif
      #if defined(REAPERAPI_WANT_RenderFileSection) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(RenderFileSection),"RenderFileSection"},
      #endif
      #if defined(REAPERAPI_WANT_ReorderSelectedTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ReorderSelectedTracks),"ReorderSelectedTracks"},
      #endif
      #if defined(REAPERAPI_WANT_Resample_EnumModes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Resample_EnumModes),"Resample_EnumModes"},
      #endif
      #if defined(REAPERAPI_WANT_Resampler_Create) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Resampler_Create),"Resampler_Create"},
      #endif
      #if defined(REAPERAPI_WANT_resolve_fn) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(resolve_fn),"resolve_fn"},
      #endif
      #if defined(REAPERAPI_WANT_resolve_fn2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(resolve_fn2),"resolve_fn2"},
      #endif
      #if defined(REAPERAPI_WANT_ResolveRenderPattern) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ResolveRenderPattern),"ResolveRenderPattern"},
      #endif
      #if defined(REAPERAPI_WANT_ResolveWildcards) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ResolveWildcards),"ResolveWildcards"},
      #endif
      #if defined(REAPERAPI_WANT_ReverseNamedCommandLookup) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ReverseNamedCommandLookup),"ReverseNamedCommandLookup"},
      #endif
      #if defined(REAPERAPI_WANT_ScaleFromEnvelopeMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ScaleFromEnvelopeMode),"ScaleFromEnvelopeMode"},
      #endif
      #if defined(REAPERAPI_WANT_ScaleToEnvelopeMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ScaleToEnvelopeMode),"ScaleToEnvelopeMode"},
      #endif
      #if defined(REAPERAPI_WANT_screenset_register) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(screenset_register),"screenset_register"},
      #endif
      #if defined(REAPERAPI_WANT_screenset_registerNew) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(screenset_registerNew),"screenset_registerNew"},
      #endif
      #if defined(REAPERAPI_WANT_screenset_unregister) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(screenset_unregister),"screenset_unregister"},
      #endif
      #if defined(REAPERAPI_WANT_screenset_unregisterByParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(screenset_unregisterByParam),"screenset_unregisterByParam"},
      #endif
      #if defined(REAPERAPI_WANT_screenset_updateLastFocus) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(screenset_updateLastFocus),"screenset_updateLastFocus"},
      #endif
      #if defined(REAPERAPI_WANT_SectionFromUniqueID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SectionFromUniqueID),"SectionFromUniqueID"},
      #endif
      #if defined(REAPERAPI_WANT_SelectAllMediaItems) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SelectAllMediaItems),"SelectAllMediaItems"},
      #endif
      #if defined(REAPERAPI_WANT_SelectProjectInstance) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SelectProjectInstance),"SelectProjectInstance"},
      #endif
      #if defined(REAPERAPI_WANT_SendLocalOscMessage) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SendLocalOscMessage),"SendLocalOscMessage"},
      #endif
      #if defined(REAPERAPI_WANT_SendMIDIMessageToHardware) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SendMIDIMessageToHardware),"SendMIDIMessageToHardware"},
      #endif
      #if defined(REAPERAPI_WANT_SetActiveTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetActiveTake),"SetActiveTake"},
      #endif
      #if defined(REAPERAPI_WANT_SetAutomationMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetAutomationMode),"SetAutomationMode"},
      #endif
      #if defined(REAPERAPI_WANT_SetCurrentBPM) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetCurrentBPM),"SetCurrentBPM"},
      #endif
      #if defined(REAPERAPI_WANT_SetCursorContext) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetCursorContext),"SetCursorContext"},
      #endif
      #if defined(REAPERAPI_WANT_SetEditCurPos) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetEditCurPos),"SetEditCurPos"},
      #endif
      #if defined(REAPERAPI_WANT_SetEditCurPos2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetEditCurPos2),"SetEditCurPos2"},
      #endif
      #if defined(REAPERAPI_WANT_SetEnvelopePoint) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetEnvelopePoint),"SetEnvelopePoint"},
      #endif
      #if defined(REAPERAPI_WANT_SetEnvelopePointEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetEnvelopePointEx),"SetEnvelopePointEx"},
      #endif
      #if defined(REAPERAPI_WANT_SetEnvelopeStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetEnvelopeStateChunk),"SetEnvelopeStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_SetExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetExtState),"SetExtState"},
      #endif
      #if defined(REAPERAPI_WANT_SetGlobalAutomationOverride) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetGlobalAutomationOverride),"SetGlobalAutomationOverride"},
      #endif
      #if defined(REAPERAPI_WANT_SetItemStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetItemStateChunk),"SetItemStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_SetMasterTrackVisibility) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMasterTrackVisibility),"SetMasterTrackVisibility"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemInfo_Value),"SetMediaItemInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemLength) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemLength),"SetMediaItemLength"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemPosition) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemPosition),"SetMediaItemPosition"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemSelected),"SetMediaItemSelected"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemTake_Source) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemTake_Source),"SetMediaItemTake_Source"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaItemTakeInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaItemTakeInfo_Value),"SetMediaItemTakeInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_SetMediaTrackInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMediaTrackInfo_Value),"SetMediaTrackInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_SetMIDIEditorGrid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMIDIEditorGrid),"SetMIDIEditorGrid"},
      #endif
      #if defined(REAPERAPI_WANT_SetMixerScroll) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMixerScroll),"SetMixerScroll"},
      #endif
      #if defined(REAPERAPI_WANT_SetMouseModifier) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetMouseModifier),"SetMouseModifier"},
      #endif
      #if defined(REAPERAPI_WANT_SetOnlyTrackSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetOnlyTrackSelected),"SetOnlyTrackSelected"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectGrid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectGrid),"SetProjectGrid"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarker),"SetProjectMarker"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarker2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarker2),"SetProjectMarker2"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarker3) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarker3),"SetProjectMarker3"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarker4) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarker4),"SetProjectMarker4"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarkerByIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarkerByIndex),"SetProjectMarkerByIndex"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjectMarkerByIndex2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjectMarkerByIndex2),"SetProjectMarkerByIndex2"},
      #endif
      #if defined(REAPERAPI_WANT_SetProjExtState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetProjExtState),"SetProjExtState"},
      #endif
      #if defined(REAPERAPI_WANT_SetRegionRenderMatrix) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetRegionRenderMatrix),"SetRegionRenderMatrix"},
      #endif
      #if defined(REAPERAPI_WANT_SetRenderLastError) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetRenderLastError),"SetRenderLastError"},
      #endif
      #if defined(REAPERAPI_WANT_SetTakeMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTakeMarker),"SetTakeMarker"},
      #endif
      #if defined(REAPERAPI_WANT_SetTakeStretchMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTakeStretchMarker),"SetTakeStretchMarker"},
      #endif
      #if defined(REAPERAPI_WANT_SetTakeStretchMarkerSlope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTakeStretchMarkerSlope),"SetTakeStretchMarkerSlope"},
      #endif
      #if defined(REAPERAPI_WANT_SetTempoTimeSigMarker) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTempoTimeSigMarker),"SetTempoTimeSigMarker"},
      #endif
      #if defined(REAPERAPI_WANT_SetThemeColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetThemeColor),"SetThemeColor"},
      #endif
      #if defined(REAPERAPI_WANT_SetToggleCommandState) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetToggleCommandState),"SetToggleCommandState"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackAutomationMode) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackAutomationMode),"SetTrackAutomationMode"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackColor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackColor),"SetTrackColor"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackMIDILyrics) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackMIDILyrics),"SetTrackMIDILyrics"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackMIDINoteName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackMIDINoteName),"SetTrackMIDINoteName"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackMIDINoteNameEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackMIDINoteNameEx),"SetTrackMIDINoteNameEx"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackSelected) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackSelected),"SetTrackSelected"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackSendInfo_Value) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackSendInfo_Value),"SetTrackSendInfo_Value"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackSendUIPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackSendUIPan),"SetTrackSendUIPan"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackSendUIVol) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackSendUIVol),"SetTrackSendUIVol"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackStateChunk) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackStateChunk),"SetTrackStateChunk"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIInputMonitor) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIInputMonitor),"SetTrackUIInputMonitor"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIMute),"SetTrackUIMute"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIPan) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIPan),"SetTrackUIPan"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIPolarity) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIPolarity),"SetTrackUIPolarity"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIRecArm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIRecArm),"SetTrackUIRecArm"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUISolo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUISolo),"SetTrackUISolo"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIVolume) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIVolume),"SetTrackUIVolume"},
      #endif
      #if defined(REAPERAPI_WANT_SetTrackUIWidth) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SetTrackUIWidth),"SetTrackUIWidth"},
      #endif
      #if defined(REAPERAPI_WANT_ShowActionList) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ShowActionList),"ShowActionList"},
      #endif
      #if defined(REAPERAPI_WANT_ShowConsoleMsg) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ShowConsoleMsg),"ShowConsoleMsg"},
      #endif
      #if defined(REAPERAPI_WANT_ShowMessageBox) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ShowMessageBox),"ShowMessageBox"},
      #endif
      #if defined(REAPERAPI_WANT_ShowPopupMenu) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ShowPopupMenu),"ShowPopupMenu"},
      #endif
      #if defined(REAPERAPI_WANT_SLIDER2DB) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SLIDER2DB),"SLIDER2DB"},
      #endif
      #if defined(REAPERAPI_WANT_SnapToGrid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SnapToGrid),"SnapToGrid"},
      #endif
      #if defined(REAPERAPI_WANT_SoloAllTracks) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SoloAllTracks),"SoloAllTracks"},
      #endif
      #if defined(REAPERAPI_WANT_Splash_GetWnd) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Splash_GetWnd),"Splash_GetWnd"},
      #endif
      #if defined(REAPERAPI_WANT_SplitMediaItem) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(SplitMediaItem),"SplitMediaItem"},
      #endif
      #if defined(REAPERAPI_WANT_StopPreview) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(StopPreview),"StopPreview"},
      #endif
      #if defined(REAPERAPI_WANT_StopTrackPreview) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(StopTrackPreview),"StopTrackPreview"},
      #endif
      #if defined(REAPERAPI_WANT_StopTrackPreview2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(StopTrackPreview2),"StopTrackPreview2"},
      #endif
      #if defined(REAPERAPI_WANT_stringToGuid) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(stringToGuid),"stringToGuid"},
      #endif
      #if defined(REAPERAPI_WANT_StuffMIDIMessage) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(StuffMIDIMessage),"StuffMIDIMessage"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_AddByName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_AddByName),"TakeFX_AddByName"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_CopyToTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_CopyToTake),"TakeFX_CopyToTake"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_CopyToTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_CopyToTrack),"TakeFX_CopyToTrack"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_Delete) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_Delete),"TakeFX_Delete"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_EndParamEdit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_EndParamEdit),"TakeFX_EndParamEdit"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_FormatParamValue) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_FormatParamValue),"TakeFX_FormatParamValue"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_FormatParamValueNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_FormatParamValueNormalized),"TakeFX_FormatParamValueNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetChainVisible) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetChainVisible),"TakeFX_GetChainVisible"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetCount) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetCount),"TakeFX_GetCount"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetEnabled),"TakeFX_GetEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetEnvelope) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetEnvelope),"TakeFX_GetEnvelope"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetFloatingWindow) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetFloatingWindow),"TakeFX_GetFloatingWindow"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetFormattedParamValue) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetFormattedParamValue),"TakeFX_GetFormattedParamValue"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetFXGUID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetFXGUID),"TakeFX_GetFXGUID"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetFXName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetFXName),"TakeFX_GetFXName"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetIOSize) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetIOSize),"TakeFX_GetIOSize"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetNamedConfigParm),"TakeFX_GetNamedConfigParm"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetNumParams) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetNumParams),"TakeFX_GetNumParams"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetOffline) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetOffline),"TakeFX_GetOffline"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetOpen) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetOpen),"TakeFX_GetOpen"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParam),"TakeFX_GetParam"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParameterStepSizes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParameterStepSizes),"TakeFX_GetParameterStepSizes"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParamEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParamEx),"TakeFX_GetParamEx"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParamFromIdent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParamFromIdent),"TakeFX_GetParamFromIdent"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParamIdent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParamIdent),"TakeFX_GetParamIdent"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParamName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParamName),"TakeFX_GetParamName"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetParamNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetParamNormalized),"TakeFX_GetParamNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetPinMappings) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetPinMappings),"TakeFX_GetPinMappings"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetPreset) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetPreset),"TakeFX_GetPreset"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetPresetIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetPresetIndex),"TakeFX_GetPresetIndex"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_GetUserPresetFilename) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_GetUserPresetFilename),"TakeFX_GetUserPresetFilename"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_NavigatePresets) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_NavigatePresets),"TakeFX_NavigatePresets"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetEnabled),"TakeFX_SetEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetNamedConfigParm),"TakeFX_SetNamedConfigParm"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetOffline) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetOffline),"TakeFX_SetOffline"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetOpen) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetOpen),"TakeFX_SetOpen"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetParam),"TakeFX_SetParam"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetParamNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetParamNormalized),"TakeFX_SetParamNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetPinMappings) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetPinMappings),"TakeFX_SetPinMappings"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetPreset) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetPreset),"TakeFX_SetPreset"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_SetPresetByIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_SetPresetByIndex),"TakeFX_SetPresetByIndex"},
      #endif
      #if defined(REAPERAPI_WANT_TakeFX_Show) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeFX_Show),"TakeFX_Show"},
      #endif
      #if defined(REAPERAPI_WANT_TakeIsMIDI) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TakeIsMIDI),"TakeIsMIDI"},
      #endif
      #if defined(REAPERAPI_WANT_ThemeLayout_GetLayout) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ThemeLayout_GetLayout),"ThemeLayout_GetLayout"},
      #endif
      #if defined(REAPERAPI_WANT_ThemeLayout_GetParameter) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ThemeLayout_GetParameter),"ThemeLayout_GetParameter"},
      #endif
      #if defined(REAPERAPI_WANT_ThemeLayout_RefreshAll) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ThemeLayout_RefreshAll),"ThemeLayout_RefreshAll"},
      #endif
      #if defined(REAPERAPI_WANT_ThemeLayout_SetLayout) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ThemeLayout_SetLayout),"ThemeLayout_SetLayout"},
      #endif
      #if defined(REAPERAPI_WANT_ThemeLayout_SetParameter) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ThemeLayout_SetParameter),"ThemeLayout_SetParameter"},
      #endif
      #if defined(REAPERAPI_WANT_time_precise) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(time_precise),"time_precise"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_beatsToTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_beatsToTime),"TimeMap2_beatsToTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_GetDividedBpmAtTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_GetDividedBpmAtTime),"TimeMap2_GetDividedBpmAtTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_GetNextChangeTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_GetNextChangeTime),"TimeMap2_GetNextChangeTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_QNToTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_QNToTime),"TimeMap2_QNToTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_timeToBeats) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_timeToBeats),"TimeMap2_timeToBeats"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap2_timeToQN) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap2_timeToQN),"TimeMap2_timeToQN"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_curFrameRate) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_curFrameRate),"TimeMap_curFrameRate"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_GetDividedBpmAtTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_GetDividedBpmAtTime),"TimeMap_GetDividedBpmAtTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_GetMeasureInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_GetMeasureInfo),"TimeMap_GetMeasureInfo"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_GetMetronomePattern) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_GetMetronomePattern),"TimeMap_GetMetronomePattern"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_GetTimeSigAtTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_GetTimeSigAtTime),"TimeMap_GetTimeSigAtTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_QNToMeasures) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_QNToMeasures),"TimeMap_QNToMeasures"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_QNToTime) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_QNToTime),"TimeMap_QNToTime"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_QNToTime_abs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_QNToTime_abs),"TimeMap_QNToTime_abs"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_timeToQN) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_timeToQN),"TimeMap_timeToQN"},
      #endif
      #if defined(REAPERAPI_WANT_TimeMap_timeToQN_abs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TimeMap_timeToQN_abs),"TimeMap_timeToQN_abs"},
      #endif
      #if defined(REAPERAPI_WANT_ToggleTrackSendUIMute) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ToggleTrackSendUIMute),"ToggleTrackSendUIMute"},
      #endif
      #if defined(REAPERAPI_WANT_Track_GetPeakHoldDB) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Track_GetPeakHoldDB),"Track_GetPeakHoldDB"},
      #endif
      #if defined(REAPERAPI_WANT_Track_GetPeakInfo) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Track_GetPeakInfo),"Track_GetPeakInfo"},
      #endif
      #if defined(REAPERAPI_WANT_TrackCtl_SetToolTip) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackCtl_SetToolTip),"TrackCtl_SetToolTip"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_AddByName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_AddByName),"TrackFX_AddByName"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_CopyToTake) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_CopyToTake),"TrackFX_CopyToTake"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_CopyToTrack) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_CopyToTrack),"TrackFX_CopyToTrack"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_Delete) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_Delete),"TrackFX_Delete"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_EndParamEdit) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_EndParamEdit),"TrackFX_EndParamEdit"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_FormatParamValue) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_FormatParamValue),"TrackFX_FormatParamValue"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_FormatParamValueNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_FormatParamValueNormalized),"TrackFX_FormatParamValueNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetByName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetByName),"TrackFX_GetByName"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetChainVisible) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetChainVisible),"TrackFX_GetChainVisible"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetCount) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetCount),"TrackFX_GetCount"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetEnabled),"TrackFX_GetEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetEQ) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetEQ),"TrackFX_GetEQ"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetEQBandEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetEQBandEnabled),"TrackFX_GetEQBandEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetEQParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetEQParam),"TrackFX_GetEQParam"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetFloatingWindow) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetFloatingWindow),"TrackFX_GetFloatingWindow"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetFormattedParamValue) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetFormattedParamValue),"TrackFX_GetFormattedParamValue"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetFXGUID) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetFXGUID),"TrackFX_GetFXGUID"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetFXName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetFXName),"TrackFX_GetFXName"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetInstrument) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetInstrument),"TrackFX_GetInstrument"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetIOSize) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetIOSize),"TrackFX_GetIOSize"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetNamedConfigParm),"TrackFX_GetNamedConfigParm"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetNumParams) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetNumParams),"TrackFX_GetNumParams"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetOffline) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetOffline),"TrackFX_GetOffline"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetOpen) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetOpen),"TrackFX_GetOpen"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParam),"TrackFX_GetParam"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParameterStepSizes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParameterStepSizes),"TrackFX_GetParameterStepSizes"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParamEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParamEx),"TrackFX_GetParamEx"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParamFromIdent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParamFromIdent),"TrackFX_GetParamFromIdent"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParamIdent) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParamIdent),"TrackFX_GetParamIdent"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParamName) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParamName),"TrackFX_GetParamName"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetParamNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetParamNormalized),"TrackFX_GetParamNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetPinMappings) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetPinMappings),"TrackFX_GetPinMappings"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetPreset) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetPreset),"TrackFX_GetPreset"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetPresetIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetPresetIndex),"TrackFX_GetPresetIndex"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetRecChainVisible) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetRecChainVisible),"TrackFX_GetRecChainVisible"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetRecCount) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetRecCount),"TrackFX_GetRecCount"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_GetUserPresetFilename) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_GetUserPresetFilename),"TrackFX_GetUserPresetFilename"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_NavigatePresets) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_NavigatePresets),"TrackFX_NavigatePresets"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetEnabled),"TrackFX_SetEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetEQBandEnabled) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetEQBandEnabled),"TrackFX_SetEQBandEnabled"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetEQParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetEQParam),"TrackFX_SetEQParam"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetNamedConfigParm) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetNamedConfigParm),"TrackFX_SetNamedConfigParm"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetOffline) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetOffline),"TrackFX_SetOffline"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetOpen) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetOpen),"TrackFX_SetOpen"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetParam) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetParam),"TrackFX_SetParam"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetParamNormalized) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetParamNormalized),"TrackFX_SetParamNormalized"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetPinMappings) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetPinMappings),"TrackFX_SetPinMappings"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetPreset) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetPreset),"TrackFX_SetPreset"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_SetPresetByIndex) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_SetPresetByIndex),"TrackFX_SetPresetByIndex"},
      #endif
      #if defined(REAPERAPI_WANT_TrackFX_Show) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackFX_Show),"TrackFX_Show"},
      #endif
      #if defined(REAPERAPI_WANT_TrackList_AdjustWindows) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackList_AdjustWindows),"TrackList_AdjustWindows"},
      #endif
      #if defined(REAPERAPI_WANT_TrackList_UpdateAllExternalSurfaces) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(TrackList_UpdateAllExternalSurfaces),"TrackList_UpdateAllExternalSurfaces"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_BeginBlock) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_BeginBlock),"Undo_BeginBlock"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_BeginBlock2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_BeginBlock2),"Undo_BeginBlock2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_CanRedo2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_CanRedo2),"Undo_CanRedo2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_CanUndo2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_CanUndo2),"Undo_CanUndo2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_DoRedo2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_DoRedo2),"Undo_DoRedo2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_DoUndo2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_DoUndo2),"Undo_DoUndo2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_EndBlock) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_EndBlock),"Undo_EndBlock"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_EndBlock2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_EndBlock2),"Undo_EndBlock2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_OnStateChange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_OnStateChange),"Undo_OnStateChange"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_OnStateChange2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_OnStateChange2),"Undo_OnStateChange2"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_OnStateChange_Item) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_OnStateChange_Item),"Undo_OnStateChange_Item"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_OnStateChangeEx) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_OnStateChangeEx),"Undo_OnStateChangeEx"},
      #endif
      #if defined(REAPERAPI_WANT_Undo_OnStateChangeEx2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(Undo_OnStateChangeEx2),"Undo_OnStateChangeEx2"},
      #endif
      #if defined(REAPERAPI_WANT_update_disk_counters) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(update_disk_counters),"update_disk_counters"},
      #endif
      #if defined(REAPERAPI_WANT_UpdateArrange) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(UpdateArrange),"UpdateArrange"},
      #endif
      #if defined(REAPERAPI_WANT_UpdateItemInProject) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(UpdateItemInProject),"UpdateItemInProject"},
      #endif
      #if defined(REAPERAPI_WANT_UpdateItemLanes) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(UpdateItemLanes),"UpdateItemLanes"},
      #endif
      #if defined(REAPERAPI_WANT_UpdateTimeline) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(UpdateTimeline),"UpdateTimeline"},
      #endif
      #if defined(REAPERAPI_WANT_ValidatePtr) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ValidatePtr),"ValidatePtr"},
      #endif
      #if defined(REAPERAPI_WANT_ValidatePtr2) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ValidatePtr2),"ValidatePtr2"},
      #endif
      #if defined(REAPERAPI_WANT_ViewPrefs) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(ViewPrefs),"ViewPrefs"},
      #endif
      #if defined(REAPERAPI_WANT_WDL_VirtualWnd_ScaledBlitBG) || !defined(REAPERAPI_MINIMAL)
        {(void**)&REAPERAPI_FUNCNAME(WDL_VirtualWnd_ScaledBlitBG),"WDL_VirtualWnd_ScaledBlitBG"},
      #endif
      {NULL, NULL}
    };
    int i,failcnt=0;
    for (i=0;table[i].dest; i++)
      failcnt += !(*table[i].dest = getAPI(table[i].name));
    return failcnt;
  }
#else//REAPERAPI_IMPLEMENT
  int REAPERAPI_LoadAPI(void *(*getAPI)(const char *));
#endif 
#endif // _REAPER_PLUGIN_FUNCTIONS_H_

