/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_dcerpc.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_dcerpc_ctx_list(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_ctx_list *r)
{
	uint32_t cntr_transfer_syntaxes_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_transfer_syntaxes));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		for (cntr_transfer_syntaxes_0 = 0; cntr_transfer_syntaxes_0 < (r->num_transfer_syntaxes); cntr_transfer_syntaxes_0++) {
			NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntaxes[cntr_transfer_syntaxes_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_ctx_list(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_ctx_list *r)
{
	uint32_t size_transfer_syntaxes_0 = 0;
	uint32_t cntr_transfer_syntaxes_0;
	TALLOC_CTX *_mem_save_transfer_syntaxes_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_transfer_syntaxes));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		size_transfer_syntaxes_0 = r->num_transfer_syntaxes;
		NDR_PULL_ALLOC_N(ndr, r->transfer_syntaxes, size_transfer_syntaxes_0);
		_mem_save_transfer_syntaxes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->transfer_syntaxes, 0);
		for (cntr_transfer_syntaxes_0 = 0; cntr_transfer_syntaxes_0 < (size_transfer_syntaxes_0); cntr_transfer_syntaxes_0++) {
			NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntaxes[cntr_transfer_syntaxes_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transfer_syntaxes_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ctx_list(struct ndr_print *ndr, const char *name, const struct dcerpc_ctx_list *r)
{
	uint32_t cntr_transfer_syntaxes_0;
	ndr_print_struct(ndr, name, "dcerpc_ctx_list");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "num_transfer_syntaxes", r->num_transfer_syntaxes);
	ndr_print_ndr_syntax_id(ndr, "abstract_syntax", &r->abstract_syntax);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "transfer_syntaxes", (uint32_t)(r->num_transfer_syntaxes));
	ndr->depth++;
	for (cntr_transfer_syntaxes_0 = 0; cntr_transfer_syntaxes_0 < (r->num_transfer_syntaxes); cntr_transfer_syntaxes_0++) {
		ndr_print_ndr_syntax_id(ndr, "transfer_syntaxes", &r->transfer_syntaxes[cntr_transfer_syntaxes_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_bind(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_bind *r)
{
	uint32_t cntr_ctx_list_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_xmit_frag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_recv_frag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->assoc_group_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_contexts));
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (r->num_contexts); cntr_ctx_list_0++) {
			NDR_CHECK(ndr_push_dcerpc_ctx_list(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_bind(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_bind *r)
{
	uint32_t size_ctx_list_0 = 0;
	uint32_t cntr_ctx_list_0;
	TALLOC_CTX *_mem_save_ctx_list_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_xmit_frag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_recv_frag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->assoc_group_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_contexts));
		size_ctx_list_0 = r->num_contexts;
		NDR_PULL_ALLOC_N(ndr, r->ctx_list, size_ctx_list_0);
		_mem_save_ctx_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ctx_list, 0);
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (size_ctx_list_0); cntr_ctx_list_0++) {
			NDR_CHECK(ndr_pull_dcerpc_ctx_list(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctx_list_0, 0);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_bind(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_bind *r)
{
	ndr_print_dcerpc_bind(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_bind(struct ndr_print *ndr, const char *name, const struct dcerpc_bind *r)
{
	uint32_t cntr_ctx_list_0;
	ndr_print_struct(ndr, name, "dcerpc_bind");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "max_xmit_frag", r->max_xmit_frag);
	ndr_print_uint16(ndr, "max_recv_frag", r->max_recv_frag);
	ndr_print_uint32(ndr, "assoc_group_id", r->assoc_group_id);
	ndr_print_uint8(ndr, "num_contexts", r->num_contexts);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ctx_list", (uint32_t)(r->num_contexts));
	ndr->depth++;
	for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (r->num_contexts); cntr_ctx_list_0++) {
		ndr_print_dcerpc_ctx_list(ndr, "ctx_list", &r->ctx_list[cntr_ctx_list_0]);
	}
	ndr->depth--;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_empty(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_empty *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_empty(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_empty *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_empty(struct ndr_print *ndr, const char *name, const struct dcerpc_empty *r)
{
	ndr_print_struct(ndr, name, "dcerpc_empty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_object(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dcerpc_object *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			default: {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->object));
			break; }

			case false: {
				NDR_CHECK(ndr_push_dcerpc_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_object(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dcerpc_object *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			default: {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->object));
			break; }

			case false: {
				NDR_CHECK(ndr_pull_dcerpc_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_object(struct ndr_print *ndr, const char *name, const union dcerpc_object *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_object");
	switch (level) {
		default:
			ndr_print_GUID(ndr, "object", &r->object);
		break;

		case false:
			ndr_print_dcerpc_empty(ndr, "empty", &r->empty);
		break;

	}
}

static enum ndr_err_code ndr_push_dcerpc_request(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_request *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->object, NDR_DCERPC_REQUEST_OBJECT_PRESENT));
		NDR_CHECK(ndr_push_dcerpc_object(ndr, NDR_SCALARS, &r->object));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_request(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_request *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->object, NDR_DCERPC_REQUEST_OBJECT_PRESENT));
		NDR_CHECK(ndr_pull_dcerpc_object(ndr, NDR_SCALARS, &r->object));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_request(struct ndr_print *ndr, const char *name, const struct dcerpc_request *r)
{
	ndr_print_struct(ndr, name, "dcerpc_request");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint16(ndr, "opnum", r->opnum);
	ndr_print_set_switch_value(ndr, &r->object, NDR_DCERPC_REQUEST_OBJECT_PRESENT);
	ndr_print_dcerpc_object(ndr, "object", &r->object);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "stub_and_verifier", r->stub_and_verifier);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_ack_result(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_ack_result r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_ack_result(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_ack_result *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_ack_result(struct ndr_print *ndr, const char *name, enum dcerpc_bind_ack_result r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_BIND_ACK_RESULT_ACCEPTANCE: val = "DCERPC_BIND_ACK_RESULT_ACCEPTANCE"; break;
		case DCERPC_BIND_ACK_RESULT_USER_REJECTION: val = "DCERPC_BIND_ACK_RESULT_USER_REJECTION"; break;
		case DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION: val = "DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION"; break;
		case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK: val = "DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_bind_ack_reason_values(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_ack_reason_values r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_ack_reason_values(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_ack_reason_values *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_ack_reason_values(struct ndr_print *ndr, const char *name, enum dcerpc_bind_ack_reason_values r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_BIND_ACK_REASON_NOT_SPECIFIED: val = "DCERPC_BIND_ACK_REASON_NOT_SPECIFIED"; break;
		case DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED: val = "DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED"; break;
		case DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED: val = "DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED"; break;
		case DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED: val = "DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_bind_time_features(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_time_features(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_time_features(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DCERPC_BIND_TIME_SECURITY_CONTEXT_MULTIPLEXING", DCERPC_BIND_TIME_SECURITY_CONTEXT_MULTIPLEXING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DCERPC_BIND_TIME_KEEP_CONNECTION_ON_ORPHAN", DCERPC_BIND_TIME_KEEP_CONNECTION_ON_ORPHAN, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_ack_reason(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dcerpc_bind_ack_reason *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 2));
		switch (level) {
			case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK: {
				NDR_CHECK(ndr_push_dcerpc_bind_time_features(ndr, NDR_SCALARS, r->negotiate));
			break; }

			default: {
				NDR_CHECK(ndr_push_dcerpc_bind_ack_reason_values(ndr, NDR_SCALARS, r->value));
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_ack_reason(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dcerpc_bind_ack_reason *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 2));
		switch (level) {
			case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_bind_time_features(ndr, NDR_SCALARS, &r->negotiate));
			break; }

			default: {
				NDR_CHECK(ndr_pull_dcerpc_bind_ack_reason_values(ndr, NDR_SCALARS, &r->value));
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_ack_reason(struct ndr_print *ndr, const char *name, const union dcerpc_bind_ack_reason *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_bind_ack_reason");
	switch (level) {
		case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK:
			ndr_print_dcerpc_bind_time_features(ndr, "negotiate", r->negotiate);
		break;

		default:
			ndr_print_dcerpc_bind_ack_reason_values(ndr, "value", r->value);
		break;

	}
}

static enum ndr_err_code ndr_push_dcerpc_ack_ctx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_ack_ctx *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_bind_ack_result(ndr, NDR_SCALARS, r->result));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->reason, r->result));
		NDR_CHECK(ndr_push_dcerpc_bind_ack_reason(ndr, NDR_SCALARS, &r->reason));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->syntax));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_ack_ctx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_ack_ctx *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dcerpc_bind_ack_result(ndr, NDR_SCALARS, &r->result));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->reason, r->result));
		NDR_CHECK(ndr_pull_dcerpc_bind_ack_reason(ndr, NDR_SCALARS, &r->reason));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->syntax));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ack_ctx(struct ndr_print *ndr, const char *name, const struct dcerpc_ack_ctx *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ack_ctx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_bind_ack_result(ndr, "result", r->result);
	ndr_print_set_switch_value(ndr, &r->reason, r->result);
	ndr_print_dcerpc_bind_ack_reason(ndr, "reason", &r->reason);
	ndr_print_ndr_syntax_id(ndr, "syntax", &r->syntax);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_ack(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_bind_ack *r)
{
	uint32_t cntr_ctx_list_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_xmit_frag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_recv_frag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->assoc_group_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term_null(r->secondary_address)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->secondary_address, strlen_m_term_null(r->secondary_address), sizeof(uint8_t), CH_DOS));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad1));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_results));
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (r->num_results); cntr_ctx_list_0++) {
			NDR_CHECK(ndr_push_dcerpc_ack_ctx(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_ack(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_bind_ack *r)
{
	uint32_t size_secondary_address_0 = 0;
	uint32_t size_ctx_list_0 = 0;
	uint32_t cntr_ctx_list_0;
	TALLOC_CTX *_mem_save_ctx_list_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_xmit_frag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_recv_frag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->assoc_group_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->secondary_address_size));
		size_secondary_address_0 = r->secondary_address_size;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->secondary_address, size_secondary_address_0, sizeof(uint8_t), CH_DOS));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad1));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_results));
		size_ctx_list_0 = r->num_results;
		NDR_PULL_ALLOC_N(ndr, r->ctx_list, size_ctx_list_0);
		_mem_save_ctx_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ctx_list, 0);
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (size_ctx_list_0); cntr_ctx_list_0++) {
			NDR_CHECK(ndr_pull_dcerpc_ack_ctx(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctx_list_0, 0);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_ack *r)
{
	uint32_t cntr_ctx_list_0;
	ndr_print_struct(ndr, name, "dcerpc_bind_ack");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "max_xmit_frag", r->max_xmit_frag);
	ndr_print_uint16(ndr, "max_recv_frag", r->max_recv_frag);
	ndr_print_uint32(ndr, "assoc_group_id", r->assoc_group_id);
	ndr_print_uint16(ndr, "secondary_address_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term_null(r->secondary_address):r->secondary_address_size);
	ndr_print_string(ndr, "secondary_address", r->secondary_address);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
		ndr_print_DATA_BLOB(ndr, "_pad1", r->_pad1);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr_print_uint8(ndr, "num_results", r->num_results);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ctx_list", (uint32_t)(r->num_results));
	ndr->depth++;
	for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < (r->num_results); cntr_ctx_list_0++) {
		ndr_print_dcerpc_ack_ctx(ndr, "ctx_list", &r->ctx_list[cntr_ctx_list_0]);
	}
	ndr->depth--;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_bind_nak_reason(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_nak_reason r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_bind_nak_reason(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_bind_nak_reason *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak_reason(struct ndr_print *ndr, const char *name, enum dcerpc_bind_nak_reason r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_BIND_NAK_REASON_NOT_SPECIFIED: val = "DCERPC_BIND_NAK_REASON_NOT_SPECIFIED"; break;
		case DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION: val = "DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION"; break;
		case DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED: val = "DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED"; break;
		case DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED: val = "DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED"; break;
		case DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE: val = "DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE"; break;
		case DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM: val = "DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_bind_nak_version(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_bind_nak_version *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers_minor));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_bind_nak_version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_bind_nak_version *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers_minor));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_bind_nak_version(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_bind_nak_version *r)
{
	ndr_print_dcerpc_bind_nak_version(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak_version(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_nak_version *r)
{
	ndr_print_struct(ndr, name, "dcerpc_bind_nak_version");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "rpc_vers", r->rpc_vers);
	ndr_print_uint8(ndr, "rpc_vers_minor", r->rpc_vers_minor);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_bind_nak(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_bind_nak *r)
{
	uint32_t cntr_versions_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_bind_nak_reason(ndr, NDR_SCALARS, r->reject_reason));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_versions));
		for (cntr_versions_0 = 0; cntr_versions_0 < (r->num_versions); cntr_versions_0++) {
			NDR_CHECK(ndr_push_dcerpc_bind_nak_version(ndr, NDR_SCALARS, &r->versions[cntr_versions_0]));
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_bind_nak(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_bind_nak *r)
{
	ndr_print_dcerpc_bind_nak(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_nak *r)
{
	uint32_t cntr_versions_0;
	ndr_print_struct(ndr, name, "dcerpc_bind_nak");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_bind_nak_reason(ndr, "reject_reason", r->reject_reason);
	ndr_print_uint8(ndr, "num_versions", r->num_versions);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "versions", (uint32_t)(r->num_versions));
	ndr->depth++;
	for (cntr_versions_0 = 0; cntr_versions_0 < (r->num_versions); cntr_versions_0++) {
		ndr_print_dcerpc_bind_nak_version(ndr, "versions", &r->versions[cntr_versions_0]);
	}
	ndr->depth--;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_response(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_response *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->cancel_count));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_response(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_response *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->cancel_count));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->reserved));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_response(struct ndr_print *ndr, const char *name, const struct dcerpc_response *r)
{
	ndr_print_struct(ndr, name, "dcerpc_response");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "cancel_count", r->cancel_count);
	ndr_print_uint8(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "stub_and_verifier", r->stub_and_verifier);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_nca_status(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_nca_status r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_nca_status(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_nca_status *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_nca_status(struct ndr_print *ndr, const char *name, enum dcerpc_nca_status r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_NCA_S_COMM_FAILURE: val = "DCERPC_NCA_S_COMM_FAILURE"; break;
		case DCERPC_NCA_S_OP_RNG_ERROR: val = "DCERPC_NCA_S_OP_RNG_ERROR"; break;
		case DCERPC_NCA_S_UNKNOWN_IF: val = "DCERPC_NCA_S_UNKNOWN_IF"; break;
		case DCERPC_NCA_S_WRONG_BOOT_TIME: val = "DCERPC_NCA_S_WRONG_BOOT_TIME"; break;
		case DCERPC_NCA_S_YOU_CRASHED: val = "DCERPC_NCA_S_YOU_CRASHED"; break;
		case DCERPC_NCA_S_PROTO_ERROR: val = "DCERPC_NCA_S_PROTO_ERROR"; break;
		case DCERPC_NCA_S_OUT_ARGS_TOO_BIG: val = "DCERPC_NCA_S_OUT_ARGS_TOO_BIG"; break;
		case DCERPC_NCA_S_SERVER_TOO_BUSY: val = "DCERPC_NCA_S_SERVER_TOO_BUSY"; break;
		case DCERPC_NCA_S_FAULT_STRING_TOO_LARGE: val = "DCERPC_NCA_S_FAULT_STRING_TOO_LARGE"; break;
		case DCERPC_NCA_S_UNSUPPORTED_TYPE: val = "DCERPC_NCA_S_UNSUPPORTED_TYPE"; break;
		case DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO: val = "DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO"; break;
		case DCERPC_NCA_S_FAULT_ADDR_ERROR: val = "DCERPC_NCA_S_FAULT_ADDR_ERROR"; break;
		case DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO: val = "DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO"; break;
		case DCERPC_NCA_S_FAULT_FP_UNDERFLOW: val = "DCERPC_NCA_S_FAULT_FP_UNDERFLOW"; break;
		case DCERPC_NCA_S_FAULT_FP_OVERRFLOW: val = "DCERPC_NCA_S_FAULT_FP_OVERRFLOW"; break;
		case DCERPC_NCA_S_FAULT_INVALID_TAG: val = "DCERPC_NCA_S_FAULT_INVALID_TAG"; break;
		case DCERPC_NCA_S_FAULT_INVALID_BOUND: val = "DCERPC_NCA_S_FAULT_INVALID_BOUND"; break;
		case DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH: val = "DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH"; break;
		case DCERPC_NCA_S_FAULT_UNSPEC_REJECT: val = "DCERPC_NCA_S_FAULT_UNSPEC_REJECT"; break;
		case DCERPC_NCA_S_FAULT_BAD_ACTID: val = "DCERPC_NCA_S_FAULT_BAD_ACTID"; break;
		case DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED: val = "DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED"; break;
		case DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED: val = "DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED"; break;
		case DCERPC_NCA_S_FAULT_CANCEL: val = "DCERPC_NCA_S_FAULT_CANCEL"; break;
		case DCERPC_NCA_S_FAULT_ILL_INST: val = "DCERPC_NCA_S_FAULT_ILL_INST"; break;
		case DCERPC_NCA_S_FAULT_FP_ERROR: val = "DCERPC_NCA_S_FAULT_FP_ERROR"; break;
		case DCERPC_NCA_S_FAULT_INT_OVERFLOW: val = "DCERPC_NCA_S_FAULT_INT_OVERFLOW"; break;
		case DCERPC_NCA_S_UNUSED_1C000011: val = "DCERPC_NCA_S_UNUSED_1C000011"; break;
		case DCERPC_NCA_S_FAULT_UNSPEC: val = "DCERPC_NCA_S_FAULT_UNSPEC"; break;
		case DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE: val = "DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE"; break;
		case DCERPC_NCA_S_FAULT_PIPE_EMPTY: val = "DCERPC_NCA_S_FAULT_PIPE_EMPTY"; break;
		case DCERPC_NCA_S_FAULT_PIPE_CLOSED: val = "DCERPC_NCA_S_FAULT_PIPE_CLOSED"; break;
		case DCERPC_NCA_S_FAULT_PIPE_ORDER: val = "DCERPC_NCA_S_FAULT_PIPE_ORDER"; break;
		case DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE: val = "DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE"; break;
		case DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR: val = "DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR"; break;
		case DCERPC_NCA_S_FAULT_PIPE_MEMORY: val = "DCERPC_NCA_S_FAULT_PIPE_MEMORY"; break;
		case DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH: val = "DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH"; break;
		case DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY: val = "DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY"; break;
		case DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID: val = "DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID"; break;
		case DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL: val = "DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL"; break;
		case DCERPC_NCA_S_UNUSED_1C00001E: val = "DCERPC_NCA_S_UNUSED_1C00001E"; break;
		case DCERPC_NCA_S_INVALID_CHECKSUM: val = "DCERPC_NCA_S_INVALID_CHECKSUM"; break;
		case DCERPC_NCA_S_INVALID_CRC: val = "DCERPC_NCA_S_INVALID_CRC"; break;
		case DCERPC_NCA_S_FAULT_USER_DEFINED: val = "DCERPC_NCA_S_FAULT_USER_DEFINED"; break;
		case DCERPC_NCA_S_FAULT_TX_OPEN_FAILED: val = "DCERPC_NCA_S_FAULT_TX_OPEN_FAILED"; break;
		case DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR: val = "DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR"; break;
		case DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND: val = "DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND"; break;
		case DCERPC_NCA_S_FAULT_NO_CLIENT_STUB: val = "DCERPC_NCA_S_FAULT_NO_CLIENT_STUB"; break;
		case DCERPC_FAULT_ACCESS_DENIED: val = "DCERPC_FAULT_ACCESS_DENIED"; break;
		case DCERPC_FAULT_SERVER_UNAVAILABLE: val = "DCERPC_FAULT_SERVER_UNAVAILABLE"; break;
		case DCERPC_FAULT_NO_CALL_ACTIVE: val = "DCERPC_FAULT_NO_CALL_ACTIVE"; break;
		case DCERPC_FAULT_CANT_PERFORM: val = "DCERPC_FAULT_CANT_PERFORM"; break;
		case DCERPC_FAULT_OUT_OF_RESOURCES: val = "DCERPC_FAULT_OUT_OF_RESOURCES"; break;
		case DCERPC_FAULT_BAD_STUB_DATA: val = "DCERPC_FAULT_BAD_STUB_DATA"; break;
		case DCERPC_FAULT_SEC_PKG_ERROR: val = "DCERPC_FAULT_SEC_PKG_ERROR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_fault_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_fault_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_fault_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_FAULT_FLAG_EXTENDED_ERROR_INFORMATION", DCERPC_FAULT_FLAG_EXTENDED_ERROR_INFORMATION, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_fault(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_fault *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->cancel_count));
		NDR_CHECK(ndr_push_dcerpc_fault_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_dcerpc_nca_status(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->error_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_fault(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_fault *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->cancel_count));
		NDR_CHECK(ndr_pull_dcerpc_fault_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_dcerpc_nca_status(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->error_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_fault(struct ndr_print *ndr, const char *name, const struct dcerpc_fault *r)
{
	ndr_print_struct(ndr, name, "dcerpc_fault");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "cancel_count", r->cancel_count);
	ndr_print_dcerpc_fault_flags(ndr, "flags", r->flags);
	ndr_print_dcerpc_nca_status(ndr, "status", r->status);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "error_and_verifier", r->error_and_verifier);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_AuthType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_AuthType r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_AuthType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_AuthType *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_AuthType(struct ndr_print *ndr, const char *name, enum dcerpc_AuthType r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_AUTH_TYPE_NONE: val = "DCERPC_AUTH_TYPE_NONE"; break;
		case DCERPC_AUTH_TYPE_KRB5_1: val = "DCERPC_AUTH_TYPE_KRB5_1"; break;
		case DCERPC_AUTH_TYPE_SPNEGO: val = "DCERPC_AUTH_TYPE_SPNEGO"; break;
		case DCERPC_AUTH_TYPE_NTLMSSP: val = "DCERPC_AUTH_TYPE_NTLMSSP"; break;
		case DCERPC_AUTH_TYPE_KRB5: val = "DCERPC_AUTH_TYPE_KRB5"; break;
		case DCERPC_AUTH_TYPE_DPA: val = "DCERPC_AUTH_TYPE_DPA"; break;
		case DCERPC_AUTH_TYPE_MSN: val = "DCERPC_AUTH_TYPE_MSN"; break;
		case DCERPC_AUTH_TYPE_DIGEST: val = "DCERPC_AUTH_TYPE_DIGEST"; break;
		case DCERPC_AUTH_TYPE_SCHANNEL: val = "DCERPC_AUTH_TYPE_SCHANNEL"; break;
		case DCERPC_AUTH_TYPE_MSMQ: val = "DCERPC_AUTH_TYPE_MSMQ"; break;
		case DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM: val = "DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_AuthLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_AuthLevel r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_AuthLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_AuthLevel *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_AuthLevel(struct ndr_print *ndr, const char *name, enum dcerpc_AuthLevel r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_AUTH_LEVEL_NONE: val = "DCERPC_AUTH_LEVEL_NONE"; break;
		case DCERPC_AUTH_LEVEL_CONNECT: val = "DCERPC_AUTH_LEVEL_CONNECT"; break;
		case DCERPC_AUTH_LEVEL_CALL: val = "DCERPC_AUTH_LEVEL_CALL"; break;
		case DCERPC_AUTH_LEVEL_PACKET: val = "DCERPC_AUTH_LEVEL_PACKET"; break;
		case DCERPC_AUTH_LEVEL_INTEGRITY: val = "DCERPC_AUTH_LEVEL_INTEGRITY"; break;
		case DCERPC_AUTH_LEVEL_PRIVACY: val = "DCERPC_AUTH_LEVEL_PRIVACY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_auth(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_auth *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_AuthType(ndr, NDR_SCALARS, r->auth_type));
		NDR_CHECK(ndr_push_dcerpc_AuthLevel(ndr, NDR_SCALARS, r->auth_level));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_pad_length));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_reserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_context_id));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->credentials));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_auth(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_auth *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dcerpc_AuthType(ndr, NDR_SCALARS, &r->auth_type));
		NDR_CHECK(ndr_pull_dcerpc_AuthLevel(ndr, NDR_SCALARS, &r->auth_level));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_pad_length));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_reserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_context_id));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->credentials));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_auth(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_auth *r)
{
	ndr_print_dcerpc_auth(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_auth(struct ndr_print *ndr, const char *name, const struct dcerpc_auth *r)
{
	ndr_print_struct(ndr, name, "dcerpc_auth");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_AuthType(ndr, "auth_type", r->auth_type);
	ndr_print_dcerpc_AuthLevel(ndr, "auth_level", r->auth_level);
	ndr_print_uint8(ndr, "auth_pad_length", r->auth_pad_length);
	ndr_print_uint8(ndr, "auth_reserved", r->auth_reserved);
	ndr_print_uint32(ndr, "auth_context_id", r->auth_context_id);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "credentials", r->credentials);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_auth3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_auth3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_auth3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_auth3 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_auth3(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_auth3 *r)
{
	ndr_print_dcerpc_auth3(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_auth3(struct ndr_print *ndr, const char *name, const struct dcerpc_auth3 *r)
{
	ndr_print_struct(ndr, name, "dcerpc_auth3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->_pad);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_orphaned(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_orphaned *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_orphaned(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_orphaned *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_orphaned(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_orphaned *r)
{
	ndr_print_dcerpc_orphaned(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_orphaned(struct ndr_print *ndr, const char *name, const struct dcerpc_orphaned *r)
{
	ndr_print_struct(ndr, name, "dcerpc_orphaned");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_co_cancel(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_co_cancel *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_co_cancel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_co_cancel *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_co_cancel(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_co_cancel *r)
{
	ndr_print_dcerpc_co_cancel(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_co_cancel(struct ndr_print *ndr, const char *name, const struct dcerpc_co_cancel *r)
{
	ndr_print_struct(ndr, name, "dcerpc_co_cancel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_cl_cancel(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_cl_cancel *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_cl_cancel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_cl_cancel *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_cl_cancel(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_cl_cancel *r)
{
	ndr_print_dcerpc_cl_cancel(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_cl_cancel(struct ndr_print *ndr, const char *name, const struct dcerpc_cl_cancel *r)
{
	ndr_print_struct(ndr, name, "dcerpc_cl_cancel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "id", r->id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_cancel_ack(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_cancel_ack *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->server_is_accepting));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_cancel_ack(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_cancel_ack *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->server_is_accepting));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_cancel_ack(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_cancel_ack *r)
{
	ndr_print_dcerpc_cancel_ack(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_cancel_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_cancel_ack *r)
{
	ndr_print_struct(ndr, name, "dcerpc_cancel_ack");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "id", r->id);
	ndr_print_uint32(ndr, "server_is_accepting", r->server_is_accepting);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_fack(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_fack *r)
{
	uint32_t cntr_selack_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->_pad1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->window_size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_tdsu));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_frag_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->serial_no));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->selack_size));
		for (cntr_selack_0 = 0; cntr_selack_0 < (r->selack_size); cntr_selack_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->selack[cntr_selack_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_fack(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_fack *r)
{
	uint32_t size_selack_0 = 0;
	uint32_t cntr_selack_0;
	TALLOC_CTX *_mem_save_selack_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->_pad1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->window_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_tdsu));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_frag_size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->serial_no));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->selack_size));
		size_selack_0 = r->selack_size;
		NDR_PULL_ALLOC_N(ndr, r->selack, size_selack_0);
		_mem_save_selack_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->selack, 0);
		for (cntr_selack_0 = 0; cntr_selack_0 < (size_selack_0); cntr_selack_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->selack[cntr_selack_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_selack_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_fack(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_fack *r)
{
	ndr_print_dcerpc_fack(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_fack(struct ndr_print *ndr, const char *name, const struct dcerpc_fack *r)
{
	uint32_t cntr_selack_0;
	ndr_print_struct(ndr, name, "dcerpc_fack");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint8(ndr, "_pad1", r->_pad1);
	ndr_print_uint16(ndr, "window_size", r->window_size);
	ndr_print_uint32(ndr, "max_tdsu", r->max_tdsu);
	ndr_print_uint32(ndr, "max_frag_size", r->max_frag_size);
	ndr_print_uint16(ndr, "serial_no", r->serial_no);
	ndr_print_uint16(ndr, "selack_size", r->selack_size);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "selack", (uint32_t)(r->selack_size));
	ndr->depth++;
	for (cntr_selack_0 = 0; cntr_selack_0 < (r->selack_size); cntr_selack_0++) {
		ndr_print_uint32(ndr, "selack", r->selack[cntr_selack_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_ack(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_ack *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_ack(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_ack *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_ack(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_ack *r)
{
	ndr_print_dcerpc_ack(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_ack *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ack");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_ping(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_ping *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_ping(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_ping *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_ping(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_ping *r)
{
	ndr_print_dcerpc_ping(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_ping(struct ndr_print *ndr, const char *name, const struct dcerpc_ping *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ping");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_shutdown(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_shutdown *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_shutdown(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_shutdown *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_shutdown(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_shutdown *r)
{
	ndr_print_dcerpc_shutdown(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_shutdown(struct ndr_print *ndr, const char *name, const struct dcerpc_shutdown *r)
{
	ndr_print_struct(ndr, name, "dcerpc_shutdown");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_working(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_working *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_working(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_working *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_working(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_working *r)
{
	ndr_print_dcerpc_working(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_working(struct ndr_print *ndr, const char *name, const struct dcerpc_working *r)
{
	ndr_print_struct(ndr, name, "dcerpc_working");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_RTSCookie(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct RTSCookie *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->Cookie));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_RTSCookie(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct RTSCookie *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->Cookie));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_RTSCookie(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct RTSCookie *r)
{
	ndr_print_RTSCookie(ndr, name, r);
}

_PUBLIC_ void ndr_print_RTSCookie(struct ndr_print *ndr, const char *name, const struct RTSCookie *r)
{
	ndr_print_struct(ndr, name, "RTSCookie");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "Cookie", &r->Cookie);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_AddressType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum AddressType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_AddressType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum AddressType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_AddressType(struct ndr_print *ndr, const char *name, enum AddressType r)
{
	const char *val = NULL;

	switch (r) {
		case RTS_IPV4: val = "RTS_IPV4"; break;
		case RTS_IPV6: val = "RTS_IPV6"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ClientAddressType(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ClientAddressType *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case RTS_IPV4: {
				NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ClientAddressIPV4));
			break; }

			case RTS_IPV6: {
				NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ClientAddressIPV6));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case RTS_IPV4:
			break;

			case RTS_IPV6:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ClientAddressType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ClientAddressType *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case RTS_IPV4: {
				NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ClientAddressIPV4));
			break; }

			case RTS_IPV6: {
				NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ClientAddressIPV6));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case RTS_IPV4:
			break;

			case RTS_IPV6:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ClientAddressType(struct ndr_print *ndr, const char *name, const union ClientAddressType *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "ClientAddressType");
	switch (level) {
		case RTS_IPV4:
			ndr_print_ipv4address(ndr, "ClientAddressIPV4", r->ClientAddressIPV4);
		break;

		case RTS_IPV6:
			ndr_print_ipv6address(ndr, "ClientAddressIPV6", r->ClientAddressIPV6);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_ClientAddress(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ClientAddress *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_AddressType(ndr, NDR_SCALARS, r->AddressType));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ClientAddress, r->AddressType));
		NDR_CHECK(ndr_push_ClientAddressType(ndr, NDR_SCALARS, &r->ClientAddress));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Padding, 12));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ClientAddress(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ClientAddress *r)
{
	uint32_t size_Padding_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_AddressType(ndr, NDR_SCALARS, &r->AddressType));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ClientAddress, r->AddressType));
		NDR_CHECK(ndr_pull_ClientAddressType(ndr, NDR_SCALARS, &r->ClientAddress));
		size_Padding_0 = 12;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Padding, size_Padding_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ClientAddress(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ClientAddress *r)
{
	ndr_print_ClientAddress(ndr, name, r);
}

_PUBLIC_ void ndr_print_ClientAddress(struct ndr_print *ndr, const char *name, const struct ClientAddress *r)
{
	ndr_print_struct(ndr, name, "ClientAddress");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_AddressType(ndr, "AddressType", r->AddressType);
	ndr_print_set_switch_value(ndr, &r->ClientAddress, r->AddressType);
	ndr_print_ClientAddressType(ndr, "ClientAddress", &r->ClientAddress);
	ndr_print_array_uint8(ndr, "Padding", r->Padding, 12);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ForwardDestination(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ForwardDestination r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ForwardDestination(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ForwardDestination *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ForwardDestination(struct ndr_print *ndr, const char *name, enum ForwardDestination r)
{
	const char *val = NULL;

	switch (r) {
		case FDClient: val = "FDClient"; break;
		case FDInProxy: val = "FDInProxy"; break;
		case FDServer: val = "FDServer"; break;
		case FDOutProxy: val = "FDOutProxy"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_FlowControlAcknowledgment(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct FlowControlAcknowledgment *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->BytesReceived));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->AvailableWindow));
		NDR_CHECK(ndr_push_RTSCookie(ndr, NDR_SCALARS, &r->ChannelCookie));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_FlowControlAcknowledgment(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct FlowControlAcknowledgment *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->BytesReceived));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->AvailableWindow));
		NDR_CHECK(ndr_pull_RTSCookie(ndr, NDR_SCALARS, &r->ChannelCookie));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_FlowControlAcknowledgment(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct FlowControlAcknowledgment *r)
{
	ndr_print_FlowControlAcknowledgment(ndr, name, r);
}

_PUBLIC_ void ndr_print_FlowControlAcknowledgment(struct ndr_print *ndr, const char *name, const struct FlowControlAcknowledgment *r)
{
	ndr_print_struct(ndr, name, "FlowControlAcknowledgment");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "BytesReceived", r->BytesReceived);
	ndr_print_uint32(ndr, "AvailableWindow", r->AvailableWindow);
	ndr_print_RTSCookie(ndr, "ChannelCookie", &r->ChannelCookie);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ReceiveWindowSize(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ReceiveWindowSize *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ReceiveWindowSize));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ReceiveWindowSize *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ReceiveWindowSize));
		if (r->ReceiveWindowSize < 8192 || r->ReceiveWindowSize > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->ReceiveWindowSize), (uint32_t)(8192), (uint32_t)(262144));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ReceiveWindowSize(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ReceiveWindowSize *r)
{
	ndr_print_dcerpc_rts_cmd_ReceiveWindowSize(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ReceiveWindowSize(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ReceiveWindowSize *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ReceiveWindowSize");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ReceiveWindowSize", r->ReceiveWindowSize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_FlowControlAck(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_FlowControlAck *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_FlowControlAcknowledgment(ndr, NDR_SCALARS, &r->Ack));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_FlowControlAck(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_FlowControlAck *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_FlowControlAcknowledgment(ndr, NDR_SCALARS, &r->Ack));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_FlowControlAck(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_FlowControlAck *r)
{
	ndr_print_dcerpc_rts_cmd_FlowControlAck(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_FlowControlAck(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_FlowControlAck *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_FlowControlAck");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_FlowControlAcknowledgment(ndr, "Ack", &r->Ack);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ConnectionTimeout(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ConnectionTimeout *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ConnectionTimeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ConnectionTimeout(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ConnectionTimeout *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ConnectionTimeout));
		if (r->ConnectionTimeout < 120000 || r->ConnectionTimeout > 14400000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->ConnectionTimeout), (uint32_t)(120000), (uint32_t)(14400000));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ConnectionTimeout(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ConnectionTimeout *r)
{
	ndr_print_dcerpc_rts_cmd_ConnectionTimeout(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ConnectionTimeout(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ConnectionTimeout *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ConnectionTimeout");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ConnectionTimeout", r->ConnectionTimeout);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_Cookie(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_Cookie *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_RTSCookie(ndr, NDR_SCALARS, &r->Cookie));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_Cookie(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_Cookie *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_RTSCookie(ndr, NDR_SCALARS, &r->Cookie));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_Cookie(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_Cookie *r)
{
	ndr_print_dcerpc_rts_cmd_Cookie(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_Cookie(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_Cookie *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_Cookie");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_RTSCookie(ndr, "Cookie", &r->Cookie);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ChannelLifetime(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ChannelLifetime *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ChannelLifetime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ChannelLifetime(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ChannelLifetime *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ChannelLifetime));
		if (r->ChannelLifetime < 131072 || r->ChannelLifetime > 2147483648) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->ChannelLifetime), (uint32_t)(131072), (uint32_t)(2147483648));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ChannelLifetime(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ChannelLifetime *r)
{
	ndr_print_dcerpc_rts_cmd_ChannelLifetime(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ChannelLifetime(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ChannelLifetime *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ChannelLifetime");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ChannelLifetime", r->ChannelLifetime);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ClientKeepalive(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ClientKeepalive *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ClientKeepalive));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ClientKeepalive(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ClientKeepalive *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ClientKeepalive));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ClientKeepalive(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ClientKeepalive *r)
{
	ndr_print_dcerpc_rts_cmd_ClientKeepalive(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ClientKeepalive(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ClientKeepalive *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ClientKeepalive");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ClientKeepalive", r->ClientKeepalive);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_Version(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_Version *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_Version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_Version *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_Version(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_Version *r)
{
	ndr_print_dcerpc_rts_cmd_Version(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_Version(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_Version *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_Version");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "Version", r->Version);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_Empty(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_Empty *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_Empty(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_Empty *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_Empty(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_Empty *r)
{
	ndr_print_dcerpc_rts_cmd_Empty(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_Empty(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_Empty *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_Empty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_Padding(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_Padding *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ConformanceCount));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Padding, r->ConformanceCount));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_Padding(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_Padding *r)
{
	uint32_t size_Padding_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ConformanceCount));
		if (r->ConformanceCount > 65535) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->ConformanceCount), (uint32_t)(0), (uint32_t)(65535));
		}
		size_Padding_0 = r->ConformanceCount;
		NDR_PULL_ALLOC_N(ndr, r->Padding, size_Padding_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Padding, size_Padding_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_Padding(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_Padding *r)
{
	ndr_print_dcerpc_rts_cmd_Padding(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_Padding(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_Padding *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_Padding");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ConformanceCount", r->ConformanceCount);
	ndr_print_array_uint8(ndr, "Padding", r->Padding, r->ConformanceCount);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_NegativeANCE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_NegativeANCE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_NegativeANCE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_NegativeANCE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_NegativeANCE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_NegativeANCE *r)
{
	ndr_print_dcerpc_rts_cmd_NegativeANCE(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_NegativeANCE(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_NegativeANCE *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_NegativeANCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ANCE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ANCE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ANCE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ANCE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ANCE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ANCE *r)
{
	ndr_print_dcerpc_rts_cmd_ANCE(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ANCE(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ANCE *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ANCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_ClientAddress(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_ClientAddress *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ClientAddress(ndr, NDR_SCALARS, &r->ClientAddress));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_ClientAddress(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_ClientAddress *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ClientAddress(ndr, NDR_SCALARS, &r->ClientAddress));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_ClientAddress(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_ClientAddress *r)
{
	ndr_print_dcerpc_rts_cmd_ClientAddress(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_ClientAddress(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_ClientAddress *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_ClientAddress");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ClientAddress(ndr, "ClientAddress", &r->ClientAddress);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_AssociationGroupId(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_AssociationGroupId *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_RTSCookie(ndr, NDR_SCALARS, &r->AssociationGroupId));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_AssociationGroupId(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_AssociationGroupId *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_RTSCookie(ndr, NDR_SCALARS, &r->AssociationGroupId));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_AssociationGroupId(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_AssociationGroupId *r)
{
	ndr_print_dcerpc_rts_cmd_AssociationGroupId(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_AssociationGroupId(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_AssociationGroupId *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_AssociationGroupId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_RTSCookie(ndr, "AssociationGroupId", &r->AssociationGroupId);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_Destination(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_Destination *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ForwardDestination(ndr, NDR_SCALARS, r->ForwardDestination));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_Destination(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_Destination *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ForwardDestination(ndr, NDR_SCALARS, &r->ForwardDestination));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_Destination(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_Destination *r)
{
	ndr_print_dcerpc_rts_cmd_Destination(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_Destination(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_Destination *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_Destination");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ForwardDestination(ndr, "ForwardDestination", r->ForwardDestination);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd_PingTrafficSentNotify(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd_PingTrafficSentNotify *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->PingTrafficSent));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd_PingTrafficSentNotify *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->PingTrafficSent));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd_PingTrafficSentNotify(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd_PingTrafficSentNotify *r)
{
	ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd_PingTrafficSentNotify *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd_PingTrafficSentNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "PingTrafficSent", r->PingTrafficSent);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_rts_cmds(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dcerpc_rts_cmds *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 0x0: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ReceiveWindowSize(ndr, NDR_SCALARS, &r->ReceiveWindowSize));
			break; }

			case 0x1: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_FlowControlAck(ndr, NDR_SCALARS, &r->FlowControlAck));
			break; }

			case 0x2: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ConnectionTimeout(ndr, NDR_SCALARS, &r->ConnectionTimeout));
			break; }

			case 0x3: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_Cookie(ndr, NDR_SCALARS, &r->Cookie));
			break; }

			case 0x4: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ChannelLifetime(ndr, NDR_SCALARS, &r->ChannelLifetime));
			break; }

			case 0x5: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ClientKeepalive(ndr, NDR_SCALARS, &r->ClientKeepalive));
			break; }

			case 0x6: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_Version(ndr, NDR_SCALARS, &r->Version));
			break; }

			case 0x7: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_Empty(ndr, NDR_SCALARS, &r->Empty));
			break; }

			case 0x8: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_Padding(ndr, NDR_SCALARS, &r->Padding));
			break; }

			case 0x9: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_NegativeANCE(ndr, NDR_SCALARS, &r->NegativeANCE));
			break; }

			case 0xA: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ANCE(ndr, NDR_SCALARS, &r->ANCE));
			break; }

			case 0xB: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_ClientAddress(ndr, NDR_SCALARS, &r->ClientAddress));
			break; }

			case 0xC: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_AssociationGroupId(ndr, NDR_SCALARS, &r->AssociationGroupId));
			break; }

			case 0xD: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_Destination(ndr, NDR_SCALARS, &r->Destination));
			break; }

			case 0xE: {
				NDR_CHECK(ndr_push_dcerpc_rts_cmd_PingTrafficSentNotify(ndr, NDR_SCALARS, &r->PingTrafficSentNotify));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0x0:
			break;

			case 0x1:
			break;

			case 0x2:
			break;

			case 0x3:
			break;

			case 0x4:
			break;

			case 0x5:
			break;

			case 0x6:
			break;

			case 0x7:
			break;

			case 0x8:
			break;

			case 0x9:
			break;

			case 0xA:
			break;

			case 0xB:
			break;

			case 0xC:
			break;

			case 0xD:
			break;

			case 0xE:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_rts_cmds(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dcerpc_rts_cmds *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 0x0: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize(ndr, NDR_SCALARS, &r->ReceiveWindowSize));
			break; }

			case 0x1: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_FlowControlAck(ndr, NDR_SCALARS, &r->FlowControlAck));
			break; }

			case 0x2: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ConnectionTimeout(ndr, NDR_SCALARS, &r->ConnectionTimeout));
			break; }

			case 0x3: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_Cookie(ndr, NDR_SCALARS, &r->Cookie));
			break; }

			case 0x4: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ChannelLifetime(ndr, NDR_SCALARS, &r->ChannelLifetime));
			break; }

			case 0x5: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ClientKeepalive(ndr, NDR_SCALARS, &r->ClientKeepalive));
			break; }

			case 0x6: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_Version(ndr, NDR_SCALARS, &r->Version));
			break; }

			case 0x7: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_Empty(ndr, NDR_SCALARS, &r->Empty));
			break; }

			case 0x8: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_Padding(ndr, NDR_SCALARS, &r->Padding));
			break; }

			case 0x9: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_NegativeANCE(ndr, NDR_SCALARS, &r->NegativeANCE));
			break; }

			case 0xA: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ANCE(ndr, NDR_SCALARS, &r->ANCE));
			break; }

			case 0xB: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_ClientAddress(ndr, NDR_SCALARS, &r->ClientAddress));
			break; }

			case 0xC: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_AssociationGroupId(ndr, NDR_SCALARS, &r->AssociationGroupId));
			break; }

			case 0xD: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_Destination(ndr, NDR_SCALARS, &r->Destination));
			break; }

			case 0xE: {
				NDR_CHECK(ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify(ndr, NDR_SCALARS, &r->PingTrafficSentNotify));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0x0:
			break;

			case 0x1:
			break;

			case 0x2:
			break;

			case 0x3:
			break;

			case 0x4:
			break;

			case 0x5:
			break;

			case 0x6:
			break;

			case 0x7:
			break;

			case 0x8:
			break;

			case 0x9:
			break;

			case 0xA:
			break;

			case 0xB:
			break;

			case 0xC:
			break;

			case 0xD:
			break;

			case 0xE:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmds(struct ndr_print *ndr, const char *name, const union dcerpc_rts_cmds *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_rts_cmds");
	switch (level) {
		case 0x0:
			ndr_print_dcerpc_rts_cmd_ReceiveWindowSize(ndr, "ReceiveWindowSize", &r->ReceiveWindowSize);
		break;

		case 0x1:
			ndr_print_dcerpc_rts_cmd_FlowControlAck(ndr, "FlowControlAck", &r->FlowControlAck);
		break;

		case 0x2:
			ndr_print_dcerpc_rts_cmd_ConnectionTimeout(ndr, "ConnectionTimeout", &r->ConnectionTimeout);
		break;

		case 0x3:
			ndr_print_dcerpc_rts_cmd_Cookie(ndr, "Cookie", &r->Cookie);
		break;

		case 0x4:
			ndr_print_dcerpc_rts_cmd_ChannelLifetime(ndr, "ChannelLifetime", &r->ChannelLifetime);
		break;

		case 0x5:
			ndr_print_dcerpc_rts_cmd_ClientKeepalive(ndr, "ClientKeepalive", &r->ClientKeepalive);
		break;

		case 0x6:
			ndr_print_dcerpc_rts_cmd_Version(ndr, "Version", &r->Version);
		break;

		case 0x7:
			ndr_print_dcerpc_rts_cmd_Empty(ndr, "Empty", &r->Empty);
		break;

		case 0x8:
			ndr_print_dcerpc_rts_cmd_Padding(ndr, "Padding", &r->Padding);
		break;

		case 0x9:
			ndr_print_dcerpc_rts_cmd_NegativeANCE(ndr, "NegativeANCE", &r->NegativeANCE);
		break;

		case 0xA:
			ndr_print_dcerpc_rts_cmd_ANCE(ndr, "ANCE", &r->ANCE);
		break;

		case 0xB:
			ndr_print_dcerpc_rts_cmd_ClientAddress(ndr, "ClientAddress", &r->ClientAddress);
		break;

		case 0xC:
			ndr_print_dcerpc_rts_cmd_AssociationGroupId(ndr, "AssociationGroupId", &r->AssociationGroupId);
		break;

		case 0xD:
			ndr_print_dcerpc_rts_cmd_Destination(ndr, "Destination", &r->Destination);
		break;

		case 0xE:
			ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify(ndr, "PingTrafficSentNotify", &r->PingTrafficSentNotify);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_cmd(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts_cmd *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->CommandType));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Command, r->CommandType));
		NDR_CHECK(ndr_push_dcerpc_rts_cmds(ndr, NDR_SCALARS, &r->Command));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_cmd(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts_cmd *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->CommandType));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Command, r->CommandType));
		NDR_CHECK(ndr_pull_dcerpc_rts_cmds(ndr, NDR_SCALARS, &r->Command));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts_cmd(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts_cmd *r)
{
	ndr_print_dcerpc_rts_cmd(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts_cmd(struct ndr_print *ndr, const char *name, const struct dcerpc_rts_cmd *r)
{
	ndr_print_struct(ndr, name, "dcerpc_rts_cmd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "CommandType", r->CommandType);
	ndr_print_set_switch_value(ndr, &r->Command, r->CommandType);
	ndr_print_dcerpc_rts_cmds(ndr, "Command", &r->Command);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_rts_flags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_NONE", RTS_FLAG_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_PING", RTS_FLAG_PING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_OTHER_CMD", RTS_FLAG_OTHER_CMD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_RECYCLE_CHANNEL", RTS_FLAG_RECYCLE_CHANNEL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_IN_CHANNEL", RTS_FLAG_IN_CHANNEL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_OUT_CHANNEL", RTS_FLAG_OUT_CHANNEL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_EOF", RTS_FLAG_EOF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "RTS_FLAG_ECHO", RTS_FLAG_ECHO, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_rts(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_rts *r)
{
	uint32_t cntr_Commands_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_rts_flags(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NumberOfCommands));
		for (cntr_Commands_0 = 0; cntr_Commands_0 < (r->NumberOfCommands); cntr_Commands_0++) {
			NDR_CHECK(ndr_push_dcerpc_rts_cmd(ndr, NDR_SCALARS, &r->Commands[cntr_Commands_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_rts(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_rts *r)
{
	uint32_t size_Commands_0 = 0;
	uint32_t cntr_Commands_0;
	TALLOC_CTX *_mem_save_Commands_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dcerpc_rts_flags(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NumberOfCommands));
		size_Commands_0 = r->NumberOfCommands;
		NDR_PULL_ALLOC_N(ndr, r->Commands, size_Commands_0);
		_mem_save_Commands_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->Commands, 0);
		for (cntr_Commands_0 = 0; cntr_Commands_0 < (size_Commands_0); cntr_Commands_0++) {
			NDR_CHECK(ndr_pull_dcerpc_rts_cmd(ndr, NDR_SCALARS, &r->Commands[cntr_Commands_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Commands_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_rts(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_rts *r)
{
	ndr_print_dcerpc_rts(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_rts(struct ndr_print *ndr, const char *name, const struct dcerpc_rts *r)
{
	uint32_t cntr_Commands_0;
	ndr_print_struct(ndr, name, "dcerpc_rts");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_rts_flags(ndr, "Flags", r->Flags);
	ndr_print_uint16(ndr, "NumberOfCommands", r->NumberOfCommands);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Commands", (uint32_t)(r->NumberOfCommands));
	ndr->depth++;
	for (cntr_Commands_0 = 0; cntr_Commands_0 < (r->NumberOfCommands); cntr_Commands_0++) {
		ndr_print_dcerpc_rts_cmd(ndr, "Commands", &r->Commands[cntr_Commands_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_pkt_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dcerpc_pkt_type r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_pkt_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dcerpc_pkt_type *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_pkt_type(struct ndr_print *ndr, const char *name, enum dcerpc_pkt_type r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_PKT_REQUEST: val = "DCERPC_PKT_REQUEST"; break;
		case DCERPC_PKT_PING: val = "DCERPC_PKT_PING"; break;
		case DCERPC_PKT_RESPONSE: val = "DCERPC_PKT_RESPONSE"; break;
		case DCERPC_PKT_FAULT: val = "DCERPC_PKT_FAULT"; break;
		case DCERPC_PKT_WORKING: val = "DCERPC_PKT_WORKING"; break;
		case DCERPC_PKT_NOCALL: val = "DCERPC_PKT_NOCALL"; break;
		case DCERPC_PKT_REJECT: val = "DCERPC_PKT_REJECT"; break;
		case DCERPC_PKT_ACK: val = "DCERPC_PKT_ACK"; break;
		case DCERPC_PKT_CL_CANCEL: val = "DCERPC_PKT_CL_CANCEL"; break;
		case DCERPC_PKT_FACK: val = "DCERPC_PKT_FACK"; break;
		case DCERPC_PKT_CANCEL_ACK: val = "DCERPC_PKT_CANCEL_ACK"; break;
		case DCERPC_PKT_BIND: val = "DCERPC_PKT_BIND"; break;
		case DCERPC_PKT_BIND_ACK: val = "DCERPC_PKT_BIND_ACK"; break;
		case DCERPC_PKT_BIND_NAK: val = "DCERPC_PKT_BIND_NAK"; break;
		case DCERPC_PKT_ALTER: val = "DCERPC_PKT_ALTER"; break;
		case DCERPC_PKT_ALTER_RESP: val = "DCERPC_PKT_ALTER_RESP"; break;
		case DCERPC_PKT_AUTH3: val = "DCERPC_PKT_AUTH3"; break;
		case DCERPC_PKT_SHUTDOWN: val = "DCERPC_PKT_SHUTDOWN"; break;
		case DCERPC_PKT_CO_CANCEL: val = "DCERPC_PKT_CO_CANCEL"; break;
		case DCERPC_PKT_ORPHANED: val = "DCERPC_PKT_ORPHANED"; break;
		case DCERPC_PKT_RTS: val = "DCERPC_PKT_RTS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_payload(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dcerpc_payload *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case DCERPC_PKT_REQUEST: {
				NDR_CHECK(ndr_push_dcerpc_request(ndr, NDR_SCALARS, &r->request));
			break; }

			case DCERPC_PKT_PING: {
				NDR_CHECK(ndr_push_dcerpc_ping(ndr, NDR_SCALARS, &r->ping));
			break; }

			case DCERPC_PKT_RESPONSE: {
				NDR_CHECK(ndr_push_dcerpc_response(ndr, NDR_SCALARS, &r->response));
			break; }

			case DCERPC_PKT_FAULT: {
				NDR_CHECK(ndr_push_dcerpc_fault(ndr, NDR_SCALARS, &r->fault));
			break; }

			case DCERPC_PKT_WORKING: {
				NDR_CHECK(ndr_push_dcerpc_working(ndr, NDR_SCALARS, &r->working));
			break; }

			case DCERPC_PKT_NOCALL: {
				NDR_CHECK(ndr_push_dcerpc_fack(ndr, NDR_SCALARS, &r->nocall));
			break; }

			case DCERPC_PKT_REJECT: {
				NDR_CHECK(ndr_push_dcerpc_fault(ndr, NDR_SCALARS, &r->reject));
			break; }

			case DCERPC_PKT_ACK: {
				NDR_CHECK(ndr_push_dcerpc_ack(ndr, NDR_SCALARS, &r->ack));
			break; }

			case DCERPC_PKT_CL_CANCEL: {
				NDR_CHECK(ndr_push_dcerpc_cl_cancel(ndr, NDR_SCALARS, &r->cl_cancel));
			break; }

			case DCERPC_PKT_FACK: {
				NDR_CHECK(ndr_push_dcerpc_fack(ndr, NDR_SCALARS, &r->fack));
			break; }

			case DCERPC_PKT_CANCEL_ACK: {
				NDR_CHECK(ndr_push_dcerpc_cancel_ack(ndr, NDR_SCALARS, &r->cancel_ack));
			break; }

			case DCERPC_PKT_BIND: {
				NDR_CHECK(ndr_push_dcerpc_bind(ndr, NDR_SCALARS, &r->bind));
			break; }

			case DCERPC_PKT_BIND_ACK: {
				NDR_CHECK(ndr_push_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->bind_ack));
			break; }

			case DCERPC_PKT_BIND_NAK: {
				NDR_CHECK(ndr_push_dcerpc_bind_nak(ndr, NDR_SCALARS, &r->bind_nak));
			break; }

			case DCERPC_PKT_ALTER: {
				NDR_CHECK(ndr_push_dcerpc_bind(ndr, NDR_SCALARS, &r->alter));
			break; }

			case DCERPC_PKT_ALTER_RESP: {
				NDR_CHECK(ndr_push_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->alter_resp));
			break; }

			case DCERPC_PKT_SHUTDOWN: {
				NDR_CHECK(ndr_push_dcerpc_shutdown(ndr, NDR_SCALARS, &r->shutdown));
			break; }

			case DCERPC_PKT_CO_CANCEL: {
				NDR_CHECK(ndr_push_dcerpc_co_cancel(ndr, NDR_SCALARS, &r->co_cancel));
			break; }

			case DCERPC_PKT_ORPHANED: {
				NDR_CHECK(ndr_push_dcerpc_orphaned(ndr, NDR_SCALARS, &r->orphaned));
			break; }

			case DCERPC_PKT_AUTH3: {
				NDR_CHECK(ndr_push_dcerpc_auth3(ndr, NDR_SCALARS, &r->auth3));
			break; }

			case DCERPC_PKT_RTS: {
				NDR_CHECK(ndr_push_dcerpc_rts(ndr, NDR_SCALARS, &r->rts));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DCERPC_PKT_REQUEST:
			break;

			case DCERPC_PKT_PING:
			break;

			case DCERPC_PKT_RESPONSE:
			break;

			case DCERPC_PKT_FAULT:
			break;

			case DCERPC_PKT_WORKING:
			break;

			case DCERPC_PKT_NOCALL:
			break;

			case DCERPC_PKT_REJECT:
			break;

			case DCERPC_PKT_ACK:
			break;

			case DCERPC_PKT_CL_CANCEL:
			break;

			case DCERPC_PKT_FACK:
			break;

			case DCERPC_PKT_CANCEL_ACK:
			break;

			case DCERPC_PKT_BIND:
			break;

			case DCERPC_PKT_BIND_ACK:
			break;

			case DCERPC_PKT_BIND_NAK:
			break;

			case DCERPC_PKT_ALTER:
			break;

			case DCERPC_PKT_ALTER_RESP:
			break;

			case DCERPC_PKT_SHUTDOWN:
			break;

			case DCERPC_PKT_CO_CANCEL:
			break;

			case DCERPC_PKT_ORPHANED:
			break;

			case DCERPC_PKT_AUTH3:
			break;

			case DCERPC_PKT_RTS:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_payload(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dcerpc_payload *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case DCERPC_PKT_REQUEST: {
				NDR_CHECK(ndr_pull_dcerpc_request(ndr, NDR_SCALARS, &r->request));
			break; }

			case DCERPC_PKT_PING: {
				NDR_CHECK(ndr_pull_dcerpc_ping(ndr, NDR_SCALARS, &r->ping));
			break; }

			case DCERPC_PKT_RESPONSE: {
				NDR_CHECK(ndr_pull_dcerpc_response(ndr, NDR_SCALARS, &r->response));
			break; }

			case DCERPC_PKT_FAULT: {
				NDR_CHECK(ndr_pull_dcerpc_fault(ndr, NDR_SCALARS, &r->fault));
			break; }

			case DCERPC_PKT_WORKING: {
				NDR_CHECK(ndr_pull_dcerpc_working(ndr, NDR_SCALARS, &r->working));
			break; }

			case DCERPC_PKT_NOCALL: {
				NDR_CHECK(ndr_pull_dcerpc_fack(ndr, NDR_SCALARS, &r->nocall));
			break; }

			case DCERPC_PKT_REJECT: {
				NDR_CHECK(ndr_pull_dcerpc_fault(ndr, NDR_SCALARS, &r->reject));
			break; }

			case DCERPC_PKT_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_ack(ndr, NDR_SCALARS, &r->ack));
			break; }

			case DCERPC_PKT_CL_CANCEL: {
				NDR_CHECK(ndr_pull_dcerpc_cl_cancel(ndr, NDR_SCALARS, &r->cl_cancel));
			break; }

			case DCERPC_PKT_FACK: {
				NDR_CHECK(ndr_pull_dcerpc_fack(ndr, NDR_SCALARS, &r->fack));
			break; }

			case DCERPC_PKT_CANCEL_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_cancel_ack(ndr, NDR_SCALARS, &r->cancel_ack));
			break; }

			case DCERPC_PKT_BIND: {
				NDR_CHECK(ndr_pull_dcerpc_bind(ndr, NDR_SCALARS, &r->bind));
			break; }

			case DCERPC_PKT_BIND_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->bind_ack));
			break; }

			case DCERPC_PKT_BIND_NAK: {
				NDR_CHECK(ndr_pull_dcerpc_bind_nak(ndr, NDR_SCALARS, &r->bind_nak));
			break; }

			case DCERPC_PKT_ALTER: {
				NDR_CHECK(ndr_pull_dcerpc_bind(ndr, NDR_SCALARS, &r->alter));
			break; }

			case DCERPC_PKT_ALTER_RESP: {
				NDR_CHECK(ndr_pull_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->alter_resp));
			break; }

			case DCERPC_PKT_SHUTDOWN: {
				NDR_CHECK(ndr_pull_dcerpc_shutdown(ndr, NDR_SCALARS, &r->shutdown));
			break; }

			case DCERPC_PKT_CO_CANCEL: {
				NDR_CHECK(ndr_pull_dcerpc_co_cancel(ndr, NDR_SCALARS, &r->co_cancel));
			break; }

			case DCERPC_PKT_ORPHANED: {
				NDR_CHECK(ndr_pull_dcerpc_orphaned(ndr, NDR_SCALARS, &r->orphaned));
			break; }

			case DCERPC_PKT_AUTH3: {
				NDR_CHECK(ndr_pull_dcerpc_auth3(ndr, NDR_SCALARS, &r->auth3));
			break; }

			case DCERPC_PKT_RTS: {
				NDR_CHECK(ndr_pull_dcerpc_rts(ndr, NDR_SCALARS, &r->rts));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DCERPC_PKT_REQUEST:
			break;

			case DCERPC_PKT_PING:
			break;

			case DCERPC_PKT_RESPONSE:
			break;

			case DCERPC_PKT_FAULT:
			break;

			case DCERPC_PKT_WORKING:
			break;

			case DCERPC_PKT_NOCALL:
			break;

			case DCERPC_PKT_REJECT:
			break;

			case DCERPC_PKT_ACK:
			break;

			case DCERPC_PKT_CL_CANCEL:
			break;

			case DCERPC_PKT_FACK:
			break;

			case DCERPC_PKT_CANCEL_ACK:
			break;

			case DCERPC_PKT_BIND:
			break;

			case DCERPC_PKT_BIND_ACK:
			break;

			case DCERPC_PKT_BIND_NAK:
			break;

			case DCERPC_PKT_ALTER:
			break;

			case DCERPC_PKT_ALTER_RESP:
			break;

			case DCERPC_PKT_SHUTDOWN:
			break;

			case DCERPC_PKT_CO_CANCEL:
			break;

			case DCERPC_PKT_ORPHANED:
			break;

			case DCERPC_PKT_AUTH3:
			break;

			case DCERPC_PKT_RTS:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_payload(struct ndr_print *ndr, const char *name, const union dcerpc_payload *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_payload");
	switch (level) {
		case DCERPC_PKT_REQUEST:
			ndr_print_dcerpc_request(ndr, "request", &r->request);
		break;

		case DCERPC_PKT_PING:
			ndr_print_dcerpc_ping(ndr, "ping", &r->ping);
		break;

		case DCERPC_PKT_RESPONSE:
			ndr_print_dcerpc_response(ndr, "response", &r->response);
		break;

		case DCERPC_PKT_FAULT:
			ndr_print_dcerpc_fault(ndr, "fault", &r->fault);
		break;

		case DCERPC_PKT_WORKING:
			ndr_print_dcerpc_working(ndr, "working", &r->working);
		break;

		case DCERPC_PKT_NOCALL:
			ndr_print_dcerpc_fack(ndr, "nocall", &r->nocall);
		break;

		case DCERPC_PKT_REJECT:
			ndr_print_dcerpc_fault(ndr, "reject", &r->reject);
		break;

		case DCERPC_PKT_ACK:
			ndr_print_dcerpc_ack(ndr, "ack", &r->ack);
		break;

		case DCERPC_PKT_CL_CANCEL:
			ndr_print_dcerpc_cl_cancel(ndr, "cl_cancel", &r->cl_cancel);
		break;

		case DCERPC_PKT_FACK:
			ndr_print_dcerpc_fack(ndr, "fack", &r->fack);
		break;

		case DCERPC_PKT_CANCEL_ACK:
			ndr_print_dcerpc_cancel_ack(ndr, "cancel_ack", &r->cancel_ack);
		break;

		case DCERPC_PKT_BIND:
			ndr_print_dcerpc_bind(ndr, "bind", &r->bind);
		break;

		case DCERPC_PKT_BIND_ACK:
			ndr_print_dcerpc_bind_ack(ndr, "bind_ack", &r->bind_ack);
		break;

		case DCERPC_PKT_BIND_NAK:
			ndr_print_dcerpc_bind_nak(ndr, "bind_nak", &r->bind_nak);
		break;

		case DCERPC_PKT_ALTER:
			ndr_print_dcerpc_bind(ndr, "alter", &r->alter);
		break;

		case DCERPC_PKT_ALTER_RESP:
			ndr_print_dcerpc_bind_ack(ndr, "alter_resp", &r->alter_resp);
		break;

		case DCERPC_PKT_SHUTDOWN:
			ndr_print_dcerpc_shutdown(ndr, "shutdown", &r->shutdown);
		break;

		case DCERPC_PKT_CO_CANCEL:
			ndr_print_dcerpc_co_cancel(ndr, "co_cancel", &r->co_cancel);
		break;

		case DCERPC_PKT_ORPHANED:
			ndr_print_dcerpc_orphaned(ndr, "orphaned", &r->orphaned);
		break;

		case DCERPC_PKT_AUTH3:
			ndr_print_dcerpc_auth3(ndr, "auth3", &r->auth3);
		break;

		case DCERPC_PKT_RTS:
			ndr_print_dcerpc_rts(ndr, "rts", &r->rts);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_pfc_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_pfc_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_pfc_flags(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_FIRST", DCERPC_PFC_FLAG_FIRST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_LAST", DCERPC_PFC_FLAG_LAST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING", DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_CONC_MPX", DCERPC_PFC_FLAG_CONC_MPX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_DID_NOT_EXECUTE", DCERPC_PFC_FLAG_DID_NOT_EXECUTE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_MAYBE", DCERPC_PFC_FLAG_MAYBE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DCERPC_PFC_FLAG_OBJECT_UUID", DCERPC_PFC_FLAG_OBJECT_UUID, r);
	ndr->depth--;
}

static void ndr_print_flags_ncacn_packet(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ncacn_packet *r)
{
	ndr_print_ncacn_packet(ndr, name, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_ncadg_packet(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ncadg_packet *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ptype));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pfc_flags));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ncadg_flags));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->drep, 3));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->serial_high));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->iface));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->activity));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->server_boot));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->iface_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seq_num));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opnum));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ihint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ahint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->fragnum));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_proto));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->serial_low));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_push_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ncadg_packet(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ncadg_packet *r)
{
	uint32_t size_drep_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ptype));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pfc_flags));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ncadg_flags));
		size_drep_0 = 3;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->drep, size_drep_0));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->serial_high));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->iface));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->activity));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->server_boot));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->iface_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seq_num));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opnum));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ihint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ahint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->fragnum));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_proto));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->serial_low));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_pull_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ncadg_packet(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ncadg_packet *r)
{
	ndr_print_ncadg_packet(ndr, name, r);
}

_PUBLIC_ void ndr_print_ncadg_packet(struct ndr_print *ndr, const char *name, const struct ncadg_packet *r)
{
	ndr_print_struct(ndr, name, "ncadg_packet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "rpc_vers", r->rpc_vers);
	ndr_print_uint8(ndr, "ptype", r->ptype);
	ndr_print_uint8(ndr, "pfc_flags", r->pfc_flags);
	ndr_print_uint8(ndr, "ncadg_flags", r->ncadg_flags);
	ndr_print_array_uint8(ndr, "drep", r->drep, 3);
	ndr_print_uint8(ndr, "serial_high", r->serial_high);
	ndr_print_GUID(ndr, "object", &r->object);
	ndr_print_GUID(ndr, "iface", &r->iface);
	ndr_print_GUID(ndr, "activity", &r->activity);
	ndr_print_uint32(ndr, "server_boot", r->server_boot);
	ndr_print_uint32(ndr, "iface_version", r->iface_version);
	ndr_print_uint32(ndr, "seq_num", r->seq_num);
	ndr_print_uint16(ndr, "opnum", r->opnum);
	ndr_print_uint16(ndr, "ihint", r->ihint);
	ndr_print_uint16(ndr, "ahint", r->ahint);
	ndr_print_uint16(ndr, "len", r->len);
	ndr_print_uint16(ndr, "fragnum", r->fragnum);
	ndr_print_uint8(ndr, "auth_proto", r->auth_proto);
	ndr_print_uint8(ndr, "serial_low", r->serial_low);
	ndr_print_set_switch_value(ndr, &r->u, r->ptype);
	ndr_print_dcerpc_payload(ndr, "u", &r->u);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt_command(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt_command(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_command(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DCERPC_SEC_VT_COMMAND_ENUM", DCERPC_SEC_VT_COMMAND_ENUM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DCERPC_SEC_VT_COMMAND_END", DCERPC_SEC_VT_COMMAND_END, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DCERPC_SEC_VT_MUST_PROCESS", DCERPC_SEC_VT_MUST_PROCESS, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt_bitmask1(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt_bitmask1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_bitmask1(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DCERPC_SEC_VT_CLIENT_SUPPORTS_HEADER_SIGNING", DCERPC_SEC_VT_CLIENT_SUPPORTS_HEADER_SIGNING, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt_pcontext(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_sec_vt_pcontext *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntax));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt_pcontext(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_sec_vt_pcontext *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntax));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_pcontext(struct ndr_print *ndr, const char *name, const struct dcerpc_sec_vt_pcontext *r)
{
	ndr_print_struct(ndr, name, "dcerpc_sec_vt_pcontext");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ndr_syntax_id(ndr, "abstract_syntax", &r->abstract_syntax);
	ndr_print_ndr_syntax_id(ndr, "transfer_syntax", &r->transfer_syntax);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt_header2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_sec_vt_header2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_pkt_type(ndr, NDR_SCALARS, r->ptype));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->drep, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->call_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opnum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt_header2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_sec_vt_header2 *r)
{
	uint32_t size_drep_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dcerpc_pkt_type(ndr, NDR_SCALARS, &r->ptype));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved2));
		size_drep_0 = 4;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->drep, size_drep_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->call_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opnum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_header2(struct ndr_print *ndr, const char *name, const struct dcerpc_sec_vt_header2 *r)
{
	ndr_print_struct(ndr, name, "dcerpc_sec_vt_header2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_pkt_type(ndr, "ptype", r->ptype);
	ndr_print_uint8(ndr, "reserved1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved1);
	ndr_print_uint16(ndr, "reserved2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved2);
	ndr_print_array_uint8(ndr, "drep", r->drep, 4);
	ndr_print_uint32(ndr, "call_id", r->call_id);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint16(ndr, "opnum", r->opnum);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt_union(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dcerpc_sec_vt_union *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case DCERPC_SEC_VT_COMMAND_BITMASK1: {
				NDR_CHECK(ndr_push_dcerpc_sec_vt_bitmask1(ndr, NDR_SCALARS, r->bitmask1));
			break; }

			case DCERPC_SEC_VT_COMMAND_PCONTEXT: {
				NDR_CHECK(ndr_push_dcerpc_sec_vt_pcontext(ndr, NDR_SCALARS, &r->pcontext));
			break; }

			case DCERPC_SEC_VT_COMMAND_HEADER2: {
				NDR_CHECK(ndr_push_dcerpc_sec_vt_header2(ndr, NDR_SCALARS, &r->header2));
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_unknown));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt_union(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dcerpc_sec_vt_union *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case DCERPC_SEC_VT_COMMAND_BITMASK1: {
				NDR_CHECK(ndr_pull_dcerpc_sec_vt_bitmask1(ndr, NDR_SCALARS, &r->bitmask1));
			break; }

			case DCERPC_SEC_VT_COMMAND_PCONTEXT: {
				NDR_CHECK(ndr_pull_dcerpc_sec_vt_pcontext(ndr, NDR_SCALARS, &r->pcontext));
			break; }

			case DCERPC_SEC_VT_COMMAND_HEADER2: {
				NDR_CHECK(ndr_pull_dcerpc_sec_vt_header2(ndr, NDR_SCALARS, &r->header2));
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_unknown));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_union(struct ndr_print *ndr, const char *name, const union dcerpc_sec_vt_union *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_sec_vt_union");
	switch (level) {
		case DCERPC_SEC_VT_COMMAND_BITMASK1:
			ndr_print_dcerpc_sec_vt_bitmask1(ndr, "bitmask1", r->bitmask1);
		break;

		case DCERPC_SEC_VT_COMMAND_PCONTEXT:
			ndr_print_dcerpc_sec_vt_pcontext(ndr, "pcontext", &r->pcontext);
		break;

		case DCERPC_SEC_VT_COMMAND_HEADER2:
			ndr_print_dcerpc_sec_vt_header2(ndr, "header2", &r->header2);
		break;

		default:
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr_print_DATA_BLOB(ndr, "_unknown", r->_unknown);
				ndr->flags = _flags_save_DATA_BLOB;
			}
		break;

	}
}

static enum ndr_err_code ndr_push_dcerpc_sec_vt(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_sec_vt *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_dcerpc_sec_vt_command(ndr, NDR_SCALARS, r->command));
		{
			libndr_flags _flags_save_dcerpc_sec_vt_union = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_SUBCONTEXT_NO_UNREAD_BYTES);
			{
				struct ndr_push *_ndr_u;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_u, 2, -1));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_u, &r->u, r->command & DCERPC_SEC_VT_COMMAND_ENUM));
				NDR_CHECK(ndr_push_dcerpc_sec_vt_union(_ndr_u, NDR_SCALARS, &r->u));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_u, 2, -1));
			}
			ndr->flags = _flags_save_dcerpc_sec_vt_union;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_sec_vt(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_sec_vt *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_dcerpc_sec_vt_command(ndr, NDR_SCALARS, &r->command));
		{
			libndr_flags _flags_save_dcerpc_sec_vt_union = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_SUBCONTEXT_NO_UNREAD_BYTES);
			{
				struct ndr_pull *_ndr_u;
				ssize_t sub_size = -1;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_u, 2, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_u, &r->u, r->command & DCERPC_SEC_VT_COMMAND_ENUM));
				NDR_CHECK(ndr_pull_dcerpc_sec_vt_union(_ndr_u, NDR_SCALARS, &r->u));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_u, 2, sub_size));
			}
			ndr->flags = _flags_save_dcerpc_sec_vt_union;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt(struct ndr_print *ndr, const char *name, const struct dcerpc_sec_vt *r)
{
	ndr_print_struct(ndr, name, "dcerpc_sec_vt");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dcerpc_sec_vt_command(ndr, "command", r->command);
	{
		libndr_flags _flags_save_dcerpc_sec_vt_union = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_SUBCONTEXT_NO_UNREAD_BYTES);
		ndr_print_set_switch_value(ndr, &r->u, r->command & DCERPC_SEC_VT_COMMAND_ENUM);
		ndr_print_dcerpc_sec_vt_union(ndr, "u", &r->u);
		ndr->flags = _flags_save_dcerpc_sec_vt_union;
	}
	ndr->depth--;
}

static void ndr_print_flags_dcerpc_sec_vt_count(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_sec_vt_count *r)
{
	ndr_print_dcerpc_sec_vt_count(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_sec_vt_count(struct ndr_print *ndr, const char *name, const struct dcerpc_sec_vt_count *r)
{
	ndr_print_struct(ndr, name, "dcerpc_sec_vt_count");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "count", r->count);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_sec_verification_trailer(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dcerpc_sec_verification_trailer *r)
{
	uint32_t cntr_commands_0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, DCERPC_SEC_VT_MAGIC, 8));
			NDR_CHECK(ndr_push_dcerpc_sec_vt_count(ndr, NDR_SCALARS, &r->count));
			for (cntr_commands_0 = 0; cntr_commands_0 < (r->count.count); cntr_commands_0++) {
				NDR_CHECK(ndr_push_dcerpc_sec_vt(ndr, NDR_SCALARS, &r->commands[cntr_commands_0]));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_sec_verification_trailer(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dcerpc_sec_verification_trailer *r)
{
	uint32_t size_magic_0 = 0;
	uint32_t size_commands_0 = 0;
	uint32_t cntr_commands_0;
	TALLOC_CTX *_mem_save_commands_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			size_magic_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->magic, size_magic_0));
			NDR_CHECK(ndr_pull_dcerpc_sec_vt_count(ndr, NDR_SCALARS, &r->count));
			size_commands_0 = r->count.count;
			NDR_PULL_ALLOC_N(ndr, r->commands, size_commands_0);
			_mem_save_commands_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->commands, 0);
			for (cntr_commands_0 = 0; cntr_commands_0 < (size_commands_0); cntr_commands_0++) {
				NDR_CHECK(ndr_pull_dcerpc_sec_vt(ndr, NDR_SCALARS, &r->commands[cntr_commands_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_commands_0, 0);
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dcerpc_sec_verification_trailer(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dcerpc_sec_verification_trailer *r)
{
	ndr_print_dcerpc_sec_verification_trailer(ndr, name, r);
}

_PUBLIC_ void ndr_print_dcerpc_sec_verification_trailer(struct ndr_print *ndr, const char *name, const struct dcerpc_sec_verification_trailer *r)
{
	uint32_t cntr_commands_0;
	ndr_print_struct(ndr, name, "dcerpc_sec_verification_trailer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr_print_array_uint8(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?DCERPC_SEC_VT_MAGIC:r->magic, 8);
		ndr_print_dcerpc_sec_vt_count(ndr, "count", &r->count);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "commands", (uint32_t)(r->count.count));
		ndr->depth++;
		for (cntr_commands_0 = 0; cntr_commands_0 < (r->count.count); cntr_commands_0++) {
			ndr_print_dcerpc_sec_vt(ndr, "commands", &r->commands[cntr_commands_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_dcerpc
static const struct ndr_interface_public_struct dcerpc_public_structs[] = {
	{
		.name = "dcerpc_bind",
		.struct_size = sizeof(struct dcerpc_bind ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_bind,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_bind,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_bind,
	},
	{
		.name = "dcerpc_bind_nak_version",
		.struct_size = sizeof(struct dcerpc_bind_nak_version ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_bind_nak_version,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_bind_nak_version,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_bind_nak_version,
	},
	{
		.name = "dcerpc_bind_nak",
		.struct_size = sizeof(struct dcerpc_bind_nak ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_bind_nak,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_bind_nak,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_bind_nak,
	},
	{
		.name = "dcerpc_auth",
		.struct_size = sizeof(struct dcerpc_auth ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_auth,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_auth,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_auth,
	},
	{
		.name = "dcerpc_auth3",
		.struct_size = sizeof(struct dcerpc_auth3 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_auth3,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_auth3,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_auth3,
	},
	{
		.name = "dcerpc_orphaned",
		.struct_size = sizeof(struct dcerpc_orphaned ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_orphaned,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_orphaned,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_orphaned,
	},
	{
		.name = "dcerpc_co_cancel",
		.struct_size = sizeof(struct dcerpc_co_cancel ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_co_cancel,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_co_cancel,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_co_cancel,
	},
	{
		.name = "dcerpc_cl_cancel",
		.struct_size = sizeof(struct dcerpc_cl_cancel ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_cl_cancel,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_cl_cancel,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_cl_cancel,
	},
	{
		.name = "dcerpc_cancel_ack",
		.struct_size = sizeof(struct dcerpc_cancel_ack ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_cancel_ack,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_cancel_ack,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_cancel_ack,
	},
	{
		.name = "dcerpc_fack",
		.struct_size = sizeof(struct dcerpc_fack ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_fack,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_fack,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_fack,
	},
	{
		.name = "dcerpc_ack",
		.struct_size = sizeof(struct dcerpc_ack ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_ack,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_ack,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_ack,
	},
	{
		.name = "dcerpc_ping",
		.struct_size = sizeof(struct dcerpc_ping ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_ping,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_ping,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_ping,
	},
	{
		.name = "dcerpc_shutdown",
		.struct_size = sizeof(struct dcerpc_shutdown ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_shutdown,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_shutdown,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_shutdown,
	},
	{
		.name = "dcerpc_working",
		.struct_size = sizeof(struct dcerpc_working ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_working,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_working,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_working,
	},
	{
		.name = "RTSCookie",
		.struct_size = sizeof(struct RTSCookie ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_RTSCookie,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_RTSCookie,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_RTSCookie,
	},
	{
		.name = "ClientAddress",
		.struct_size = sizeof(struct ClientAddress ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ClientAddress,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ClientAddress,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ClientAddress,
	},
	{
		.name = "FlowControlAcknowledgment",
		.struct_size = sizeof(struct FlowControlAcknowledgment ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_FlowControlAcknowledgment,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_FlowControlAcknowledgment,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_FlowControlAcknowledgment,
	},
	{
		.name = "dcerpc_rts_cmd_ReceiveWindowSize",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ReceiveWindowSize ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ReceiveWindowSize,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ReceiveWindowSize,
	},
	{
		.name = "dcerpc_rts_cmd_FlowControlAck",
		.struct_size = sizeof(struct dcerpc_rts_cmd_FlowControlAck ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_FlowControlAck,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_FlowControlAck,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_FlowControlAck,
	},
	{
		.name = "dcerpc_rts_cmd_ConnectionTimeout",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ConnectionTimeout ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ConnectionTimeout,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ConnectionTimeout,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ConnectionTimeout,
	},
	{
		.name = "dcerpc_rts_cmd_Cookie",
		.struct_size = sizeof(struct dcerpc_rts_cmd_Cookie ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_Cookie,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_Cookie,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_Cookie,
	},
	{
		.name = "dcerpc_rts_cmd_ChannelLifetime",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ChannelLifetime ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ChannelLifetime,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ChannelLifetime,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ChannelLifetime,
	},
	{
		.name = "dcerpc_rts_cmd_ClientKeepalive",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ClientKeepalive ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ClientKeepalive,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ClientKeepalive,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ClientKeepalive,
	},
	{
		.name = "dcerpc_rts_cmd_Version",
		.struct_size = sizeof(struct dcerpc_rts_cmd_Version ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_Version,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_Version,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_Version,
	},
	{
		.name = "dcerpc_rts_cmd_Empty",
		.struct_size = sizeof(struct dcerpc_rts_cmd_Empty ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_Empty,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_Empty,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_Empty,
	},
	{
		.name = "dcerpc_rts_cmd_Padding",
		.struct_size = sizeof(struct dcerpc_rts_cmd_Padding ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_Padding,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_Padding,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_Padding,
	},
	{
		.name = "dcerpc_rts_cmd_NegativeANCE",
		.struct_size = sizeof(struct dcerpc_rts_cmd_NegativeANCE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_NegativeANCE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_NegativeANCE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_NegativeANCE,
	},
	{
		.name = "dcerpc_rts_cmd_ANCE",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ANCE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ANCE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ANCE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ANCE,
	},
	{
		.name = "dcerpc_rts_cmd_ClientAddress",
		.struct_size = sizeof(struct dcerpc_rts_cmd_ClientAddress ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_ClientAddress,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_ClientAddress,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_ClientAddress,
	},
	{
		.name = "dcerpc_rts_cmd_AssociationGroupId",
		.struct_size = sizeof(struct dcerpc_rts_cmd_AssociationGroupId ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_AssociationGroupId,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_AssociationGroupId,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_AssociationGroupId,
	},
	{
		.name = "dcerpc_rts_cmd_Destination",
		.struct_size = sizeof(struct dcerpc_rts_cmd_Destination ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_Destination,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_Destination,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_Destination,
	},
	{
		.name = "dcerpc_rts_cmd_PingTrafficSentNotify",
		.struct_size = sizeof(struct dcerpc_rts_cmd_PingTrafficSentNotify ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd_PingTrafficSentNotify,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd_PingTrafficSentNotify,
	},
	{
		.name = "dcerpc_rts_cmd",
		.struct_size = sizeof(struct dcerpc_rts_cmd ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts_cmd,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts_cmd,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts_cmd,
	},
	{
		.name = "dcerpc_rts",
		.struct_size = sizeof(struct dcerpc_rts ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_rts,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_rts,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_rts,
	},
	{
		.name = "ncacn_packet",
		.struct_size = sizeof(struct ncacn_packet ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ncacn_packet,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ncacn_packet,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ncacn_packet,
	},
	{
		.name = "ncadg_packet",
		.struct_size = sizeof(struct ncadg_packet ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ncadg_packet,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ncadg_packet,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ncadg_packet,
	},
	{
		.name = "dcerpc_sec_vt_count",
		.struct_size = sizeof(struct dcerpc_sec_vt_count ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_sec_vt_count,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_sec_vt_count,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_sec_vt_count,
	},
	{
		.name = "dcerpc_sec_verification_trailer",
		.struct_size = sizeof(struct dcerpc_sec_verification_trailer ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dcerpc_sec_verification_trailer,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dcerpc_sec_verification_trailer,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dcerpc_sec_verification_trailer,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call dcerpc_calls[] = {
	{ .name = NULL }
};

static const char * const dcerpc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dcerpc]", 
};

static const struct ndr_interface_string_array dcerpc_endpoints = {
	.count	= 1,
	.names	= dcerpc_endpoint_strings
};

static const char * const dcerpc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dcerpc_authservices = {
	.count	= 1,
	.names	= dcerpc_authservice_strings
};


const struct ndr_interface_table ndr_table_dcerpc = {
	.name		= "dcerpc",
	.num_calls	= 0,
	.calls		= dcerpc_calls,
	.num_public_structs	= 38,
	.public_structs		= dcerpc_public_structs,
	.endpoints	= &dcerpc_endpoints,
	.authservices	= &dcerpc_authservices
};

#endif /* SKIP_NDR_TABLE_dcerpc */
