/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_ODJ
#define _PIDL_HEADER_ODJ

#include <stdint.h>


#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/security.h"
#define OP_JP2_FLAG_PERSISTENTSITE    0x00000001
#ifndef _HEADER_ODJ
#define _HEADER_ODJ

#define ODJ_GUID_JOIN_PROVIDER	( "{631c7621-5289-4321-bc9e-80f843f868c3}" )
#define ODJ_GUID_JOIN_PROVIDER2	( "{57BFC56B-52F9-480C-ADCB-91B3F8A82317}" )
#define ODJ_GUID_JOIN_PROVIDER3	( "{FC0CCF25-7FFA-474A-8611-69FFE269645F}" )
#define ODJ_GUID_CERT_PROVIDER	( "{9c0971e9-832f-4873-8e87-ef1419d4781e}" )
#define ODJ_GUID_POLICY_PROVIDER	( "{68fb602a-0c09-48ce-b75f-07b7bd58f7ec}" )
struct OP_BLOB {
	uint32_t cbBlob;
	uint8_t *pBlob;/* [flag(LIBNDR_PRINT_ARRAY_HEX),size_is(cbBlob),unique] */
};

struct ODJ_POLICY_DNS_DOMAIN_INFO {
	struct lsa_StringLarge Name;
	struct lsa_StringLarge DnsDomainName;
	struct lsa_StringLarge DnsForestName;
	struct GUID DomainGuid;
	struct dom_sid2 *Sid;/* [unique] */
};

struct ODJ_WIN7BLOB {
	const char *lpDomain;/* [charset(UTF16),unique] */
	const char *lpMachineName;/* [charset(UTF16),unique] */
	const char *lpMachinePassword;/* [charset(UTF16),flag(LIBNDR_FLAG_IS_SECRET),unique] */
	uint32_t _pad;/* [value(0xffffffff)] */
	struct ODJ_POLICY_DNS_DOMAIN_INFO DnsDomainInfo;
	struct netr_DsRGetDCNameInfo DcInfo;
	uint32_t Options;
};

struct OP_JOINPROV2_PART {
	uint32_t dwFlags;
	const char *lpNetbiosName;/* [charset(UTF16),unique] */
	const char *lpSiteName;/* [charset(UTF16),unique] */
	const char *lpPrimaryDNSDomain;/* [charset(UTF16),unique] */
	uint32_t dwReserved;
	const char *lpReserved;/* [charset(UTF16),unique] */
};

struct OP_JOINPROV3_PART {
	uint32_t Rid;
	const char *lpSid;/* [charset(UTF16),unique] */
};

struct OP_POLICY_ELEMENT {
	const char *pKeyPath;/* [charset(UTF16),unique] */
	const char *pValueName;/* [charset(UTF16),unique] */
	enum winreg_Type ulValueType;
	uint32_t cbValueData;
	uint8_t *pValueData;/* [flag(LIBNDR_PRINT_ARRAY_HEX),size_is(cbValueData),unique] */
};

struct OP_POLICY_ELEMENT_LIST {
	const char *pSource;/* [charset(UTF16),unique] */
	uint32_t ulRootKeyId;
	uint32_t cElements;
	struct OP_POLICY_ELEMENT *pElements;/* [size_is(cElements),unique] */
};

struct OP_POLICY_PART {
	uint32_t cElementLists;
	struct OP_POLICY_ELEMENT_LIST *pElementLists;/* [size_is(cElementLists),unique] */
	struct OP_BLOB Extension;
};

struct OP_CERT_PFX_STORE {
	const char *pTemplateName;/* [charset(UTF16),unique] */
	uint32_t ulPrivateKeyExportPolicy;
	const char *pPolicyServerUrl;/* [charset(UTF16),unique] */
	uint32_t ulPolicyServerUrlFlags;
	const char *pPolicyServerId;/* [charset(UTF16),unique] */
	uint32_t cbPfx;
	uint8_t *pPfx;/* [size_is(cbPfx),unique] */
};

struct OP_CERT_SST_STORE {
	uint32_t StoreLocation;
	const char *pStoreName;/* [charset(UTF16),unique] */
	uint32_t cbSst;
	uint8_t *pSst;/* [size_is(cbSst),unique] */
};

struct OP_CERT_PART {
	uint32_t cPfxStores;
	struct OP_CERT_PFX_STORE *pPfxStores;/* [size_is(cPfxStores),unique] */
	uint32_t cSstStores;
	struct OP_CERT_SST_STORE *pSstStores;/* [size_is(cSstStores),unique] */
	struct OP_BLOB Extension;
};

struct ODJ_WIN7BLOB_ctr {
	struct ODJ_WIN7BLOB *p;/* [unique] */
}/* [public] */;

struct ODJ_WIN7BLOB_serialized_ptr {
	struct ODJ_WIN7BLOB_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_JOINPROV2_PART_ctr {
	struct OP_JOINPROV2_PART *p;/* [unique] */
}/* [public] */;

struct OP_JOINPROV2_PART_serialized_ptr {
	struct OP_JOINPROV2_PART_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_JOINPROV3_PART_ctr {
	struct OP_JOINPROV3_PART *p;/* [unique] */
}/* [public] */;

struct OP_JOINPROV3_PART_serialized_ptr {
	struct OP_JOINPROV3_PART_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_POLICY_PART_ctr {
	struct OP_POLICY_PART *p;/* [unique] */
}/* [public] */;

struct OP_POLICY_PART_serialized_ptr {
	struct OP_POLICY_PART_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_CERT_PART_ctr {
	struct OP_CERT_PART *p;/* [unique] */
}/* [public] */;

struct OP_CERT_PART_serialized_ptr {
	struct OP_CERT_PART_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

union OP_PACKAGE_PART_u {
	struct ODJ_WIN7BLOB win7blob;/* [case,subcontext(0xFFFFFC01)] */
	struct OP_JOINPROV2_PART_ctr join_prov2;/* [case(2),subcontext(0xFFFFFC01)] */
	struct OP_JOINPROV3_PART_ctr join_prov3;/* [case(3),subcontext(0xFFFFFC01)] */
	struct OP_CERT_PART_ctr cert_part;/* [case(4),subcontext(0xFFFFFC01)] */
	struct OP_POLICY_PART_ctr policy_part;/* [case(5),subcontext(0xFFFFFC01)] */
}/* [gensize,nodiscriminant,public] */;

/* bitmap ODJ_PackageFlags */
#define OPSPI_PACKAGE_PART_ESSENTIAL ( 0x00000001 )

struct OP_PACKAGE_PART {
	struct GUID PartType;
	uint32_t ulFlags;
	uint32_t part_len;/* [value(ndr_size_OP_PACKAGE_PART_u(Part,odj_switch_level_from_guid(&PartType),0))] */
	union OP_PACKAGE_PART_u *Part;/* [subcontext(4),subcontext_size(part_len),switch_is(odj_switch_level_from_guid(&PartType)),unique] */
	struct OP_BLOB Extension;
};

struct OP_PACKAGE_PART_ctr {
	struct OP_PACKAGE_PART *p;/* [unique] */
}/* [public] */;

struct OP_PACKAGE_PART_serialized_ptr {
	struct OP_PACKAGE_PART_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_PACKAGE_PART_COLLECTION {
	uint32_t cParts;
	struct OP_PACKAGE_PART *pParts;/* [size_is(cParts),unique] */
	struct OP_BLOB Extension;
};

struct OP_PACKAGE_PART_COLLECTION_ctr {
	struct OP_PACKAGE_PART_COLLECTION *p;/* [unique] */
}/* [public] */;

struct OP_PACKAGE_PART_COLLECTION_serialized_ptr {
	struct OP_PACKAGE_PART_COLLECTION_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

struct OP_PACKAGE_PART_COLLECTION_blob {
	uint32_t cbBlob;/* [value(ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(w,0))] */
	struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *w;/* [subcontext(4),subcontext_size(cbBlob),unique] */
};

struct OP_PACKAGE {
	struct GUID EncryptionType;
	struct OP_BLOB EncryptionContext;
	struct OP_PACKAGE_PART_COLLECTION_blob WrappedPartCollection;
	uint32_t cbDecryptedPartCollection;
	struct OP_BLOB Extension;
};

struct OP_PACKAGE_ctr {
	struct OP_PACKAGE *p;/* [unique] */
}/* [public] */;

struct OP_PACKAGE_serialized_ptr {
	struct OP_PACKAGE_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

enum ODJFormat
#ifndef USE_UINT_ENUMS
 {
	ODJ_WIN7_FORMAT=(int)(0x00000001),
	ODJ_WIN8_FORMAT=(int)(0x00000002)
}
#else
 { __do_not_use_enum_ODJFormat=INT_MAX}
#define ODJ_WIN7_FORMAT ( 0x00000001 )
#define ODJ_WIN8_FORMAT ( 0x00000002 )
#endif
;

union ODJ_BLOB_u {
	struct ODJ_WIN7BLOB odj_win7blob;/* [case(ODJ_WIN7_FORMAT),subcontext(0xFFFFFC01)] */
	struct OP_PACKAGE_ctr op_package;/* [case(ODJ_WIN8_FORMAT),subcontext(0xFFFFFC01)] */
	DATA_BLOB blob;/* [default,flag(LIBNDR_FLAG_REMAINING),subcontext(0xFFFFFC01)] */
}/* [gensize,nodiscriminant,public] */;

struct ODJ_BLOB {
	enum ODJFormat ulODJFormat;
	uint32_t cbBlob;/* [value(ndr_size_ODJ_BLOB_u(pBlob,ulODJFormat,0))] */
	union ODJ_BLOB_u *pBlob;/* [subcontext(4),subcontext_size(cbBlob),switch_is(ulODJFormat),unique] */
};

struct ODJ_PROVISION_DATA {
	uint32_t ulVersion;/* [value] */
	uint32_t ulcBlobs;
	struct ODJ_BLOB *pBlobs;/* [size_is(ulcBlobs),unique] */
}/* [public] */;

struct ODJ_PROVISION_DATA_ctr {
	struct ODJ_PROVISION_DATA *p;/* [unique] */
}/* [public] */;

struct ODJ_PROVISION_DATA_serialized_ptr {
	struct ODJ_PROVISION_DATA_ctr s;/* [subcontext(0xFFFFFC01)] */
}/* [gensize,public] */;

#endif /* _HEADER_ODJ */
#endif /* _PIDL_HEADER_ODJ */
