/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TritonInstrumentOps.td                                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::triton::instrument::ExperimentalAssertInThreadOp,
::mlir::triton::instrument::ExperimentalBufferPointersOp,
::mlir::triton::instrument::ExperimentalCheckBarrierWritesClearedOp,
::mlir::triton::instrument::ExperimentalCheckOutstandingCommitsOp,
::mlir::triton::instrument::ExperimentalCheckReadBarriersOp,
::mlir::triton::instrument::ExperimentalCheckWriteStateOp,
::mlir::triton::instrument::ExperimentalClearOutstandingCommitsOp,
::mlir::triton::instrument::ExperimentalClearReadBarrierOp,
::mlir::triton::instrument::ExperimentalClearWriteBarrierOp,
::mlir::triton::instrument::ExperimentalCommitAccessesOp,
::mlir::triton::instrument::ExperimentalCommitWriteWithBarrierOp,
::mlir::triton::instrument::ExperimentalSetReadBarrierOp,
::mlir::triton::instrument::ExperimentalSetWriteStateOp,
::mlir::triton::instrument::ExperimentalStageAccessForCommitOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace triton {
namespace instrument {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonInstrumentOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::TensorType>(type))) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be tensor of 1-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonInstrumentOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return (((::llvm::isa<::mlir::Float8E4M3FNType>(elementType))) || ((::llvm::isa<::mlir::Float8E4M3FNUZType>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2Type>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2FNUZType>(elementType))) || ((elementType.isF16())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((elementType.isF32())) || ((elementType.isF64()))) || (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(4))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64)))) || (((::mlir::isa<::mlir::triton::PointerType>(elementType))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(elementType).getPointeeType()))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ranked tensor of floating-point or integer or ptr values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonInstrumentOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::MemDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be memory descriptor type (`::mlir::triton::gpu::MemDescType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonInstrumentOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((::mlir::isa<::mlir::triton::PointerType>(type))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(type).getPointeeType()))) || (((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return ((::mlir::isa<::mlir::triton::PointerType>(elementType))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(elementType).getPointeeType())); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ptr or ranked tensor of ptr values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonInstrumentOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(1)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::StringAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: string attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::BoolAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: bool attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::DenseI32ArrayAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: i32 dense array attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::instrument::MemTypeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::TypeAttr>(attr))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(attr).getValue()))) && ((true))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: any type attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(1)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 1-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonInstrumentOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonInstrumentOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalAssertInThreadOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalAssertInThreadOpGenericAdaptorBase::ExperimentalAssertInThreadOpGenericAdaptorBase(ExperimentalAssertInThreadOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::llvm::StringRef ExperimentalAssertInThreadOpGenericAdaptorBase::getMessage() {
  auto attr = getMessageAttr();
  return attr.getValue();
}

bool ExperimentalAssertInThreadOpGenericAdaptorBase::getCheckAny() {
  auto attr = getCheckAnyAttr();
  return attr.getValue();
}

} // namespace detail
ExperimentalAssertInThreadOpAdaptor::ExperimentalAssertInThreadOpAdaptor(ExperimentalAssertInThreadOp op) : ExperimentalAssertInThreadOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalAssertInThreadOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_check_any = getProperties().check_any; (void)tblgen_check_any;
  if (!tblgen_check_any) return emitError(loc, "'tti.experimental_assert_in_thread' op ""requires attribute 'check_any'");
  auto tblgen_message = getProperties().message; (void)tblgen_message;
  if (!tblgen_message) return emitError(loc, "'tti.experimental_assert_in_thread' op ""requires attribute 'message'");

  if (tblgen_message && !((::llvm::isa<::mlir::StringAttr>(tblgen_message))))
    return emitError(loc, "'tti.experimental_assert_in_thread' op ""attribute 'message' failed to satisfy constraint: string attribute");

  if (tblgen_check_any && !((::llvm::isa<::mlir::BoolAttr>(tblgen_check_any))))
    return emitError(loc, "'tti.experimental_assert_in_thread' op ""attribute 'check_any' failed to satisfy constraint: bool attribute");
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalAssertInThreadOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.check_any;
       auto attr = dict.get("check_any");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `check_any` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.message;
       auto attr = dict.get("message");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `message` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalAssertInThreadOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.check_any;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("check_any",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.message;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("message",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalAssertInThreadOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.check_any.getAsOpaquePointer()), 
    llvm::hash_value(prop.message.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalAssertInThreadOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "check_any")
      return prop.check_any;

    if (name == "message")
      return prop.message;
  return std::nullopt;
}

void ExperimentalAssertInThreadOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "check_any") {
       prop.check_any = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.check_any)>>(value);
       return;
    }

    if (name == "message") {
       prop.message = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.message)>>(value);
       return;
    }
}

void ExperimentalAssertInThreadOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.check_any) attrs.append("check_any", prop.check_any);

    if (prop.message) attrs.append("message", prop.message);
}

::llvm::LogicalResult ExperimentalAssertInThreadOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCheckAnyAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps2(attr, "check_any", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getMessageAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps1(attr, "message", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalAssertInThreadOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.check_any)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.message)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalAssertInThreadOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.check_any);
  writer.writeAttribute(prop.message);
}

::llvm::StringRef ExperimentalAssertInThreadOp::getMessage() {
  auto attr = getMessageAttr();
  return attr.getValue();
}

bool ExperimentalAssertInThreadOp::getCheckAny() {
  auto attr = getCheckAnyAttr();
  return attr.getValue();
}

void ExperimentalAssertInThreadOp::setMessage(::llvm::StringRef attrValue) {
  getProperties().message = ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue);
}

void ExperimentalAssertInThreadOp::setCheckAny(bool attrValue) {
  getProperties().check_any = ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  odsState.addOperands(condition);
  odsState.getOrAddProperties<Properties>().message = message;
  odsState.getOrAddProperties<Properties>().check_any = check_any;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, condition, message, check_any);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  return create(builder, builder.getLoc(), condition, message, check_any);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  odsState.addOperands(condition);
  odsState.getOrAddProperties<Properties>().message = message;
  odsState.getOrAddProperties<Properties>().check_any = check_any;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, condition, message, check_any);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any) {
  return create(builder, builder.getLoc(), resultTypes, condition, message, check_any);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  odsState.addOperands(condition);
  odsState.getOrAddProperties<Properties>().message = odsBuilder.getStringAttr(message);
  odsState.getOrAddProperties<Properties>().check_any = odsBuilder.getBoolAttr(check_any);
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, condition, message, check_any);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  return create(builder, builder.getLoc(), condition, message, check_any);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  odsState.addOperands(condition);
  odsState.getOrAddProperties<Properties>().message = odsBuilder.getStringAttr(message);
  odsState.getOrAddProperties<Properties>().check_any = odsBuilder.getBoolAttr(check_any);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, condition, message, check_any);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any) {
  return create(builder, builder.getLoc(), resultTypes, condition, message, check_any);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalAssertInThreadOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalAssertInThreadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalAssertInThreadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalAssertInThreadOp ExperimentalAssertInThreadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalAssertInThreadOp::verifyInvariantsImpl() {
  auto tblgen_check_any = getProperties().check_any; (void)tblgen_check_any;
  if (!tblgen_check_any) return emitOpError("requires attribute 'check_any'");
  auto tblgen_message = getProperties().message; (void)tblgen_message;
  if (!tblgen_message) return emitOpError("requires attribute 'message'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps1(*this, tblgen_message, "message")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps2(*this, tblgen_check_any, "check_any")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalAssertInThreadOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ExperimentalAssertInThreadOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand conditionRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> conditionOperands(&conditionRawOperand, 1);  ::llvm::SMLoc conditionOperandsLoc;
  (void)conditionOperandsLoc;
  ::mlir::StringAttr messageAttr;
  ::mlir::Type conditionRawType{};
  ::llvm::ArrayRef<::mlir::Type> conditionTypes(&conditionRawType, 1);

  conditionOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(conditionRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(messageAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (messageAttr) result.getOrAddProperties<ExperimentalAssertInThreadOp::Properties>().message = messageAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    conditionRawType = type;
  }
  if (parser.resolveOperands(conditionOperands, conditionTypes, conditionOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalAssertInThreadOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getCondition();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getMessageAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("message");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getCondition().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::TensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalAssertInThreadOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalAssertInThreadOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalBufferPointersOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalBufferPointersOpGenericAdaptorBase::ExperimentalBufferPointersOpGenericAdaptorBase(ExperimentalBufferPointersOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::llvm::ArrayRef<int32_t> ExperimentalBufferPointersOpGenericAdaptorBase::getOffsets() {
  auto attr = getOffsetsAttr();
  return attr;
}

::mlir::triton::instrument::MemType ExperimentalBufferPointersOpGenericAdaptorBase::getMemType() {
  auto attr = getMemTypeAttr();
  return attr.getValue();
}

} // namespace detail
ExperimentalBufferPointersOpAdaptor::ExperimentalBufferPointersOpAdaptor(ExperimentalBufferPointersOp op) : ExperimentalBufferPointersOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalBufferPointersOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_memType = getProperties().memType; (void)tblgen_memType;
  if (!tblgen_memType) return emitError(loc, "'tti.experimental_buffer_pointers' op ""requires attribute 'memType'");
  auto tblgen_offsets = getProperties().offsets; (void)tblgen_offsets;
  if (!tblgen_offsets) return emitError(loc, "'tti.experimental_buffer_pointers' op ""requires attribute 'offsets'");

  if (tblgen_offsets && !((::llvm::isa<::mlir::DenseI32ArrayAttr>(tblgen_offsets))))
    return emitError(loc, "'tti.experimental_buffer_pointers' op ""attribute 'offsets' failed to satisfy constraint: i32 dense array attribute");

  if (tblgen_memType && !((::llvm::isa<::mlir::triton::instrument::MemTypeAttr>(tblgen_memType))))
    return emitError(loc, "'tti.experimental_buffer_pointers' op ""attribute 'memType' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1");
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalBufferPointersOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.memType;
       auto attr = dict.get("memType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `memType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.offsets;
       auto attr = dict.get("offsets");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `offsets` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalBufferPointersOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.memType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("memType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.offsets;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("offsets",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalBufferPointersOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.memType.getAsOpaquePointer()), 
    llvm::hash_value(prop.offsets.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalBufferPointersOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "memType")
      return prop.memType;

    if (name == "offsets")
      return prop.offsets;
  return std::nullopt;
}

void ExperimentalBufferPointersOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "memType") {
       prop.memType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.memType)>>(value);
       return;
    }

    if (name == "offsets") {
       prop.offsets = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.offsets)>>(value);
       return;
    }
}

void ExperimentalBufferPointersOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.memType) attrs.append("memType", prop.memType);

    if (prop.offsets) attrs.append("offsets", prop.offsets);
}

::llvm::LogicalResult ExperimentalBufferPointersOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getMemTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps4(attr, "memType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getOffsetsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps3(attr, "offsets", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalBufferPointersOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.memType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.offsets)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalBufferPointersOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.memType);
  writer.writeAttribute(prop.offsets);
}

::llvm::ArrayRef<int32_t> ExperimentalBufferPointersOp::getOffsets() {
  auto attr = getOffsetsAttr();
  return attr;
}

::mlir::triton::instrument::MemType ExperimentalBufferPointersOp::getMemType() {
  auto attr = getMemTypeAttr();
  return attr.getValue();
}

void ExperimentalBufferPointersOp::setOffsets(::llvm::ArrayRef<int32_t> attrValue) {
  getProperties().offsets = ::mlir::Builder((*this)->getContext()).getDenseI32ArrayAttr(attrValue);
}

void ExperimentalBufferPointersOp::setMemType(::mlir::triton::instrument::MemType attrValue) {
  getProperties().memType = ::mlir::triton::instrument::MemTypeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  odsState.getOrAddProperties<Properties>().offsets = offsets;
  odsState.getOrAddProperties<Properties>().memType = memType;
  odsState.addTypes(result);
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, offsets, memType);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  return create(builder, builder.getLoc(), result, offsets, memType);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  odsState.getOrAddProperties<Properties>().offsets = offsets;
  odsState.getOrAddProperties<Properties>().memType = memType;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, offsets, memType);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType) {
  return create(builder, builder.getLoc(), resultTypes, offsets, memType);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  odsState.getOrAddProperties<Properties>().offsets = odsBuilder.getDenseI32ArrayAttr(offsets);
  odsState.getOrAddProperties<Properties>().memType = ::mlir::triton::instrument::MemTypeAttr::get(odsBuilder.getContext(), memType);
  odsState.addTypes(result);
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, offsets, memType);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  return create(builder, builder.getLoc(), result, offsets, memType);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  odsState.getOrAddProperties<Properties>().offsets = odsBuilder.getDenseI32ArrayAttr(offsets);
  odsState.getOrAddProperties<Properties>().memType = ::mlir::triton::instrument::MemTypeAttr::get(odsBuilder.getContext(), memType);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, offsets, memType);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType) {
  return create(builder, builder.getLoc(), resultTypes, offsets, memType);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalBufferPointersOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalBufferPointersOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalBufferPointersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalBufferPointersOp ExperimentalBufferPointersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalBufferPointersOp::verifyInvariantsImpl() {
  auto tblgen_memType = getProperties().memType; (void)tblgen_memType;
  if (!tblgen_memType) return emitOpError("requires attribute 'memType'");
  auto tblgen_offsets = getProperties().offsets; (void)tblgen_offsets;
  if (!tblgen_offsets) return emitOpError("requires attribute 'offsets'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps3(*this, tblgen_offsets, "offsets")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps4(*this, tblgen_memType, "memType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalBufferPointersOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ExperimentalBufferPointersOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::DenseI32ArrayAttr offsetsAttr;
  ::mlir::triton::instrument::MemTypeAttr memTypeAttr;
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  if (parser.parseCustomAttributeWithFallback(offsetsAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (offsetsAttr) result.getOrAddProperties<ExperimentalBufferPointersOp::Properties>().offsets = offsetsAttr;
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"shared_mem","tensor_mem"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "memType", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'memType' [shared_mem, tensor_mem]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::instrument::symbolizeMemType(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "memType attribute specification: \"" << attrStr << '"';;

      memTypeAttr = ::mlir::triton::instrument::MemTypeAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<ExperimentalBufferPointersOp::Properties>().memType = memTypeAttr;
    }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resultRawType = type;
  }
  result.addTypes(resultTypes);
  return ::mlir::success();
}

void ExperimentalBufferPointersOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getOffsetsAttr());
  _odsPrinter << ",";
  _odsPrinter << ' ';

  {
    auto caseValue = getMemType();
    auto caseValueStr = stringifyMemType(caseValue);
    _odsPrinter << caseValueStr;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("offsets");
  elidedAttrs.push_back("memType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getResult().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalBufferPointersOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalBufferPointersOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckBarrierWritesClearedOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase::ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase(ExperimentalCheckBarrierWritesClearedOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalCheckBarrierWritesClearedOpAdaptor::ExperimentalCheckBarrierWritesClearedOpAdaptor(ExperimentalCheckBarrierWritesClearedOp op) : ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitError(loc, "'tti.experimental_check_barrier_writes_cleared' op ""requires attribute 'writeBarsType'");

  if (tblgen_writeBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_check_barrier_writes_cleared' op ""attribute 'writeBarsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCheckBarrierWritesClearedOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCheckBarrierWritesClearedOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.writeBarsType;
       auto attr = dict.get("writeBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCheckBarrierWritesClearedOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.writeBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeBarsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCheckBarrierWritesClearedOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.writeBarsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCheckBarrierWritesClearedOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "writeBarsType")
      return prop.writeBarsType;
  return std::nullopt;
}

void ExperimentalCheckBarrierWritesClearedOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "writeBarsType") {
       prop.writeBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeBarsType)>>(value);
       return;
    }
}

void ExperimentalCheckBarrierWritesClearedOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.writeBarsType) attrs.append("writeBarsType", prop.writeBarsType);
}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getWriteBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeBarsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.writeBarsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckBarrierWritesClearedOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.writeBarsType);
}

::mlir::Type ExperimentalCheckBarrierWritesClearedOp::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalCheckBarrierWritesClearedOp::setWriteBarsType(::mlir::Type attrValue) {
  getProperties().writeBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, pred);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, pred);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, pred);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, pred);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCheckBarrierWritesClearedOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCheckBarrierWritesClearedOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckBarrierWritesClearedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckBarrierWritesClearedOp ExperimentalCheckBarrierWritesClearedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOp::verifyInvariantsImpl() {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitOpError("requires attribute 'writeBarsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeBarsType, "writeBarsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckBarrierWritesClearedOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalCheckBarrierWritesClearedOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand mbarRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> mbarOperands(&mbarRawOperand, 1);  ::llvm::SMLoc mbarOperandsLoc;
  (void)mbarOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barriersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barriersOperands(&barriersRawOperand, 1);  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand writeBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeBarsOperands(&writeBarsRawOperand, 1);  ::llvm::SMLoc writeBarsOperandsLoc;
  (void)writeBarsOperandsLoc;
  ::mlir::TypeAttr writeBarsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type mbarRawType{};
  ::llvm::ArrayRef<::mlir::Type> mbarTypes(&mbarRawType, 1);
  ::mlir::Type barriersRawType{};
  ::llvm::ArrayRef<::mlir::Type> barriersTypes(&barriersRawType, 1);
  ::mlir::Type writeBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeBarsTypes(&writeBarsRawType, 1);

  mbarOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(mbarRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  barriersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barriersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeBarsTypeAttr) result.getOrAddProperties<ExperimentalCheckBarrierWritesClearedOp::Properties>().writeBarsType = writeBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    mbarRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    barriersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeBarsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(mbarOperands, mbarTypes, mbarOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeBarsOperands, writeBarsTypes, writeBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckBarrierWritesClearedOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMbar();
  _odsPrinter << "{";
  _odsPrinter << getBarriers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("writeBarsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMbar().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBarriers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCheckBarrierWritesClearedOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckBarrierWritesClearedOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckOutstandingCommitsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase::ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase(ExperimentalCheckOutstandingCommitsOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::llvm::StringRef ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase::getPendingAccessType() {
  auto attr = getPendingAccessTypeAttr();
  return attr.getValue();
}

} // namespace detail
ExperimentalCheckOutstandingCommitsOpAdaptor::ExperimentalCheckOutstandingCommitsOpAdaptor(ExperimentalCheckOutstandingCommitsOp op) : ExperimentalCheckOutstandingCommitsOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitError(loc, "'tti.experimental_check_outstanding_commits' op ""requires attribute 'outstandingCommitsType'");
  auto tblgen_pendingAccessType = getProperties().pendingAccessType; (void)tblgen_pendingAccessType;
  if (!tblgen_pendingAccessType) return emitError(loc, "'tti.experimental_check_outstanding_commits' op ""requires attribute 'pendingAccessType'");

  if (tblgen_outstandingCommitsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_outstandingCommitsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_outstandingCommitsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_check_outstanding_commits' op ""attribute 'outstandingCommitsType' failed to satisfy constraint: any type attribute");

  if (tblgen_pendingAccessType && !((::llvm::isa<::mlir::StringAttr>(tblgen_pendingAccessType))))
    return emitError(loc, "'tti.experimental_check_outstanding_commits' op ""attribute 'pendingAccessType' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCheckOutstandingCommitsOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCheckOutstandingCommitsOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.outstandingCommitsType;
       auto attr = dict.get("outstandingCommitsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `outstandingCommitsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.pendingAccessType;
       auto attr = dict.get("pendingAccessType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `pendingAccessType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCheckOutstandingCommitsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.outstandingCommitsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("outstandingCommitsType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.pendingAccessType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("pendingAccessType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCheckOutstandingCommitsOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.outstandingCommitsType.getAsOpaquePointer()), 
    llvm::hash_value(prop.pendingAccessType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCheckOutstandingCommitsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "outstandingCommitsType")
      return prop.outstandingCommitsType;

    if (name == "pendingAccessType")
      return prop.pendingAccessType;
  return std::nullopt;
}

void ExperimentalCheckOutstandingCommitsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "outstandingCommitsType") {
       prop.outstandingCommitsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.outstandingCommitsType)>>(value);
       return;
    }

    if (name == "pendingAccessType") {
       prop.pendingAccessType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.pendingAccessType)>>(value);
       return;
    }
}

void ExperimentalCheckOutstandingCommitsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.outstandingCommitsType) attrs.append("outstandingCommitsType", prop.outstandingCommitsType);

    if (prop.pendingAccessType) attrs.append("pendingAccessType", prop.pendingAccessType);
}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getOutstandingCommitsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "outstandingCommitsType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPendingAccessTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps1(attr, "pendingAccessType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.outstandingCommitsType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.pendingAccessType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckOutstandingCommitsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.outstandingCommitsType);
  writer.writeAttribute(prop.pendingAccessType);
}

::mlir::Type ExperimentalCheckOutstandingCommitsOp::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::llvm::StringRef ExperimentalCheckOutstandingCommitsOp::getPendingAccessType() {
  auto attr = getPendingAccessTypeAttr();
  return attr.getValue();
}

void ExperimentalCheckOutstandingCommitsOp::setOutstandingCommitsType(::mlir::Type attrValue) {
  getProperties().outstandingCommitsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCheckOutstandingCommitsOp::setPendingAccessType(::llvm::StringRef attrValue) {
  getProperties().pendingAccessType = ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  odsState.getOrAddProperties<Properties>().pendingAccessType = pendingAccessType;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  odsState.getOrAddProperties<Properties>().pendingAccessType = pendingAccessType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  odsState.getOrAddProperties<Properties>().pendingAccessType = odsBuilder.getStringAttr(pendingAccessType);
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  odsState.getOrAddProperties<Properties>().pendingAccessType = odsBuilder.getStringAttr(pendingAccessType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pendingAccessType, pred);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCheckOutstandingCommitsOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCheckOutstandingCommitsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckOutstandingCommitsOp ExperimentalCheckOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOp::verifyInvariantsImpl() {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitOpError("requires attribute 'outstandingCommitsType'");
  auto tblgen_pendingAccessType = getProperties().pendingAccessType; (void)tblgen_pendingAccessType;
  if (!tblgen_pendingAccessType) return emitOpError("requires attribute 'pendingAccessType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_outstandingCommitsType, "outstandingCommitsType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps1(*this, tblgen_pendingAccessType, "pendingAccessType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckOutstandingCommitsOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalCheckOutstandingCommitsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand outstandingCommitsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> outstandingCommitsOperands(&outstandingCommitsRawOperand, 1);  ::llvm::SMLoc outstandingCommitsOperandsLoc;
  (void)outstandingCommitsOperandsLoc;
  ::mlir::TypeAttr outstandingCommitsTypeAttr;
  ::mlir::StringAttr pendingAccessTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type outstandingCommitsRawType{};
  ::llvm::ArrayRef<::mlir::Type> outstandingCommitsTypes(&outstandingCommitsRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  outstandingCommitsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(outstandingCommitsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(outstandingCommitsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (outstandingCommitsTypeAttr) result.getOrAddProperties<ExperimentalCheckOutstandingCommitsOp::Properties>().outstandingCommitsType = outstandingCommitsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(pendingAccessTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (pendingAccessTypeAttr) result.getOrAddProperties<ExperimentalCheckOutstandingCommitsOp::Properties>().pendingAccessType = pendingAccessTypeAttr;
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    outstandingCommitsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(outstandingCommitsOperands, outstandingCommitsTypes, outstandingCommitsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckOutstandingCommitsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getOutstandingCommits();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getOutstandingCommitsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getPendingAccessTypeAttr());
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("outstandingCommitsType");
  elidedAttrs.push_back("pendingAccessType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getOutstandingCommits().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCheckOutstandingCommitsOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckOutstandingCommitsOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckReadBarriersOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCheckReadBarriersOpGenericAdaptorBase::ExperimentalCheckReadBarriersOpGenericAdaptorBase(ExperimentalCheckReadBarriersOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCheckReadBarriersOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCheckReadBarriersOpGenericAdaptorBase::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalCheckReadBarriersOpAdaptor::ExperimentalCheckReadBarriersOpAdaptor(ExperimentalCheckReadBarriersOp op) : ExperimentalCheckReadBarriersOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCheckReadBarriersOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitError(loc, "'tti.experimental_check_read_barriers' op ""requires attribute 'readBarsType'");

  if (tblgen_readBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_readBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_readBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_check_read_barriers' op ""attribute 'readBarsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCheckReadBarriersOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCheckReadBarriersOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCheckReadBarriersOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.readBarsType;
       auto attr = dict.get("readBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `readBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCheckReadBarriersOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.readBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("readBarsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCheckReadBarriersOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.readBarsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCheckReadBarriersOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "readBarsType")
      return prop.readBarsType;
  return std::nullopt;
}

void ExperimentalCheckReadBarriersOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "readBarsType") {
       prop.readBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.readBarsType)>>(value);
       return;
    }
}

void ExperimentalCheckReadBarriersOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.readBarsType) attrs.append("readBarsType", prop.readBarsType);
}

::llvm::LogicalResult ExperimentalCheckReadBarriersOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getReadBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "readBarsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckReadBarriersOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.readBarsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckReadBarriersOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.readBarsType);
}

::mlir::Type ExperimentalCheckReadBarriersOp::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalCheckReadBarriersOp::setReadBarsType(::mlir::Type attrValue) {
  getProperties().readBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, readBars, readBarsType, pred);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, readBars, readBarsType, pred);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, readBars, readBarsType, pred);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, readBars, readBarsType, pred);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCheckReadBarriersOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCheckReadBarriersOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckReadBarriersOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckReadBarriersOp ExperimentalCheckReadBarriersOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCheckReadBarriersOp::verifyInvariantsImpl() {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitOpError("requires attribute 'readBarsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_readBarsType, "readBarsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckReadBarriersOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalCheckReadBarriersOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand readBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> readBarsOperands(&readBarsRawOperand, 1);  ::llvm::SMLoc readBarsOperandsLoc;
  (void)readBarsOperandsLoc;
  ::mlir::TypeAttr readBarsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type readBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> readBarsTypes(&readBarsRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  readBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(readBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(readBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (readBarsTypeAttr) result.getOrAddProperties<ExperimentalCheckReadBarriersOp::Properties>().readBarsType = readBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    readBarsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(readBarsOperands, readBarsTypes, readBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckReadBarriersOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getReadBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getReadBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("readBarsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getReadBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCheckReadBarriersOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckReadBarriersOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckWriteStateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCheckWriteStateOpGenericAdaptorBase::ExperimentalCheckWriteStateOpGenericAdaptorBase(ExperimentalCheckWriteStateOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCheckWriteStateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCheckWriteStateOpGenericAdaptorBase::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalCheckWriteStateOpGenericAdaptorBase::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

bool ExperimentalCheckWriteStateOpGenericAdaptorBase::getHwPipelined() {
  auto attr = getHwPipelinedAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
ExperimentalCheckWriteStateOpAdaptor::ExperimentalCheckWriteStateOpAdaptor(ExperimentalCheckWriteStateOp op) : ExperimentalCheckWriteStateOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCheckWriteStateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_hwPipelined = getProperties().hwPipelined; (void)tblgen_hwPipelined;
  if (!tblgen_hwPipelined) return emitError(loc, "'tti.experimental_check_write_state' op ""requires attribute 'hwPipelined'");
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitError(loc, "'tti.experimental_check_write_state' op ""requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitError(loc, "'tti.experimental_check_write_state' op ""requires attribute 'writeStateType'");

  if (tblgen_writeBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_check_write_state' op ""attribute 'writeBarsType' failed to satisfy constraint: any type attribute");

  if (tblgen_writeStateType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeStateType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeStateType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_check_write_state' op ""attribute 'writeStateType' failed to satisfy constraint: any type attribute");

  if (tblgen_hwPipelined && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_hwPipelined))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_hwPipelined).getType().isSignlessInteger(1)))))
    return emitError(loc, "'tti.experimental_check_write_state' op ""attribute 'hwPipelined' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCheckWriteStateOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCheckWriteStateOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCheckWriteStateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.hwPipelined;
       auto attr = dict.get("hwPipelined");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hwPipelined` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.writeBarsType;
       auto attr = dict.get("writeBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.writeStateType;
       auto attr = dict.get("writeStateType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeStateType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCheckWriteStateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.hwPipelined;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hwPipelined",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.writeBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeBarsType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.writeStateType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeStateType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCheckWriteStateOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.hwPipelined.getAsOpaquePointer()), 
    llvm::hash_value(prop.writeBarsType.getAsOpaquePointer()), 
    llvm::hash_value(prop.writeStateType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCheckWriteStateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "hwPipelined")
      return prop.hwPipelined;

    if (name == "writeBarsType")
      return prop.writeBarsType;

    if (name == "writeStateType")
      return prop.writeStateType;
  return std::nullopt;
}

void ExperimentalCheckWriteStateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "hwPipelined") {
       prop.hwPipelined = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hwPipelined)>>(value);
       return;
    }

    if (name == "writeBarsType") {
       prop.writeBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeBarsType)>>(value);
       return;
    }

    if (name == "writeStateType") {
       prop.writeStateType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeStateType)>>(value);
       return;
    }
}

void ExperimentalCheckWriteStateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.hwPipelined) attrs.append("hwPipelined", prop.hwPipelined);

    if (prop.writeBarsType) attrs.append("writeBarsType", prop.writeBarsType);

    if (prop.writeStateType) attrs.append("writeStateType", prop.writeStateType);
}

::llvm::LogicalResult ExperimentalCheckWriteStateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getHwPipelinedAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps6(attr, "hwPipelined", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWriteBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeBarsType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWriteStateTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeStateType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckWriteStateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.hwPipelined)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.writeBarsType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.writeStateType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckWriteStateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.hwPipelined);
  writer.writeAttribute(prop.writeBarsType);
  writer.writeAttribute(prop.writeStateType);
}

::mlir::Type ExperimentalCheckWriteStateOp::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalCheckWriteStateOp::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

bool ExperimentalCheckWriteStateOp::getHwPipelined() {
  auto attr = getHwPipelinedAttr();
  return attr.getValue().getZExtValue();
}

void ExperimentalCheckWriteStateOp::setWriteBarsType(::mlir::Type attrValue) {
  getProperties().writeBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCheckWriteStateOp::setWriteStateType(::mlir::Type attrValue) {
  getProperties().writeStateType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCheckWriteStateOp::setHwPipelined(bool attrValue) {
  getProperties().hwPipelined = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  odsState.getOrAddProperties<Properties>().hwPipelined = hwPipelined;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  odsState.getOrAddProperties<Properties>().hwPipelined = hwPipelined;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  odsState.getOrAddProperties<Properties>().hwPipelined = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), hwPipelined);
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  odsState.getOrAddProperties<Properties>().hwPipelined = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), hwPipelined);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, writeBars, writeBarsType, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCheckWriteStateOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCheckWriteStateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCheckWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCheckWriteStateOp ExperimentalCheckWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCheckWriteStateOp::verifyInvariantsImpl() {
  auto tblgen_hwPipelined = getProperties().hwPipelined; (void)tblgen_hwPipelined;
  if (!tblgen_hwPipelined) return emitOpError("requires attribute 'hwPipelined'");
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitOpError("requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitOpError("requires attribute 'writeStateType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeBarsType, "writeBarsType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeStateType, "writeStateType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps6(*this, tblgen_hwPipelined, "hwPipelined")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCheckWriteStateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalCheckWriteStateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand writeBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeBarsOperands(&writeBarsRawOperand, 1);  ::llvm::SMLoc writeBarsOperandsLoc;
  (void)writeBarsOperandsLoc;
  ::mlir::TypeAttr writeBarsTypeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand writeStateRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeStateOperands(&writeStateRawOperand, 1);  ::llvm::SMLoc writeStateOperandsLoc;
  (void)writeStateOperandsLoc;
  ::mlir::TypeAttr writeStateTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::IntegerAttr hwPipelinedAttr;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type writeBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeBarsTypes(&writeBarsRawType, 1);
  ::mlir::Type writeStateRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeStateTypes(&writeStateRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeBarsTypeAttr) result.getOrAddProperties<ExperimentalCheckWriteStateOp::Properties>().writeBarsType = writeBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeStateOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeStateRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeStateTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeStateTypeAttr) result.getOrAddProperties<ExperimentalCheckWriteStateOp::Properties>().writeStateType = writeStateTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  if (parser.parseKeyword("pipelined"))
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(hwPipelinedAttr, parser.getBuilder().getIntegerType(1))) {
    return ::mlir::failure();
  }
  if (hwPipelinedAttr) result.getOrAddProperties<ExperimentalCheckWriteStateOp::Properties>().hwPipelined = hwPipelinedAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeBarsRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeStateRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeBarsOperands, writeBarsTypes, writeBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeStateOperands, writeStateTypes, writeStateOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCheckWriteStateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteState();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteStateTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  _odsPrinter << ' ' << "pipelined";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getHwPipelinedAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("writeBarsType");
  elidedAttrs.push_back("writeStateType");
  elidedAttrs.push_back("hwPipelined");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteState().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCheckWriteStateOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckWriteStateOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearOutstandingCommitsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalClearOutstandingCommitsOpGenericAdaptorBase::ExperimentalClearOutstandingCommitsOpGenericAdaptorBase(ExperimentalClearOutstandingCommitsOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalClearOutstandingCommitsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalClearOutstandingCommitsOpGenericAdaptorBase::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

uint32_t ExperimentalClearOutstandingCommitsOpGenericAdaptorBase::getOutstandingNum() {
  auto attr = getOutstandingNumAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
ExperimentalClearOutstandingCommitsOpAdaptor::ExperimentalClearOutstandingCommitsOpAdaptor(ExperimentalClearOutstandingCommitsOp op) : ExperimentalClearOutstandingCommitsOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitError(loc, "'tti.experimental_clear_outstanding_commits' op ""requires attribute 'outstandingCommitsType'");
  auto tblgen_outstandingNum = getProperties().outstandingNum; (void)tblgen_outstandingNum;
  if (!tblgen_outstandingNum) return emitError(loc, "'tti.experimental_clear_outstanding_commits' op ""requires attribute 'outstandingNum'");

  if (tblgen_outstandingCommitsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_outstandingCommitsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_outstandingCommitsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_clear_outstanding_commits' op ""attribute 'outstandingCommitsType' failed to satisfy constraint: any type attribute");

  if (tblgen_outstandingNum && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_outstandingNum))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_outstandingNum).getType().isSignlessInteger(32)))))
    return emitError(loc, "'tti.experimental_clear_outstanding_commits' op ""attribute 'outstandingNum' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalClearOutstandingCommitsOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalClearOutstandingCommitsOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.outstandingCommitsType;
       auto attr = dict.get("outstandingCommitsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `outstandingCommitsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.outstandingNum;
       auto attr = dict.get("outstandingNum");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `outstandingNum` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalClearOutstandingCommitsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.outstandingCommitsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("outstandingCommitsType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.outstandingNum;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("outstandingNum",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalClearOutstandingCommitsOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.outstandingCommitsType.getAsOpaquePointer()), 
    llvm::hash_value(prop.outstandingNum.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalClearOutstandingCommitsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "outstandingCommitsType")
      return prop.outstandingCommitsType;

    if (name == "outstandingNum")
      return prop.outstandingNum;
  return std::nullopt;
}

void ExperimentalClearOutstandingCommitsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "outstandingCommitsType") {
       prop.outstandingCommitsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.outstandingCommitsType)>>(value);
       return;
    }

    if (name == "outstandingNum") {
       prop.outstandingNum = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.outstandingNum)>>(value);
       return;
    }
}

void ExperimentalClearOutstandingCommitsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.outstandingCommitsType) attrs.append("outstandingCommitsType", prop.outstandingCommitsType);

    if (prop.outstandingNum) attrs.append("outstandingNum", prop.outstandingNum);
}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getOutstandingCommitsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "outstandingCommitsType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getOutstandingNumAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps7(attr, "outstandingNum", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.outstandingCommitsType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.outstandingNum)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearOutstandingCommitsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.outstandingCommitsType);
  writer.writeAttribute(prop.outstandingNum);
}

::mlir::Type ExperimentalClearOutstandingCommitsOp::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

uint32_t ExperimentalClearOutstandingCommitsOp::getOutstandingNum() {
  auto attr = getOutstandingNumAttr();
  return attr.getValue().getZExtValue();
}

void ExperimentalClearOutstandingCommitsOp::setOutstandingCommitsType(::mlir::Type attrValue) {
  getProperties().outstandingCommitsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalClearOutstandingCommitsOp::setOutstandingNum(uint32_t attrValue) {
  getProperties().outstandingNum = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  odsState.getOrAddProperties<Properties>().outstandingNum = outstandingNum;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), outstandingCommits, outstandingCommitsType, outstandingNum, pred);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  odsState.getOrAddProperties<Properties>().outstandingNum = outstandingNum;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  odsState.getOrAddProperties<Properties>().outstandingNum = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), outstandingNum);
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), outstandingCommits, outstandingCommitsType, outstandingNum, pred);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  odsState.getOrAddProperties<Properties>().outstandingNum = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), outstandingNum);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, outstandingCommits, outstandingCommitsType, outstandingNum, pred);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalClearOutstandingCommitsOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalClearOutstandingCommitsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearOutstandingCommitsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearOutstandingCommitsOp ExperimentalClearOutstandingCommitsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOp::verifyInvariantsImpl() {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitOpError("requires attribute 'outstandingCommitsType'");
  auto tblgen_outstandingNum = getProperties().outstandingNum; (void)tblgen_outstandingNum;
  if (!tblgen_outstandingNum) return emitOpError("requires attribute 'outstandingNum'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_outstandingCommitsType, "outstandingCommitsType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps7(*this, tblgen_outstandingNum, "outstandingNum")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearOutstandingCommitsOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ExperimentalClearOutstandingCommitsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand outstandingCommitsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> outstandingCommitsOperands(&outstandingCommitsRawOperand, 1);  ::llvm::SMLoc outstandingCommitsOperandsLoc;
  (void)outstandingCommitsOperandsLoc;
  ::mlir::TypeAttr outstandingCommitsTypeAttr;
  ::mlir::IntegerAttr outstandingNumAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type outstandingCommitsRawType{};
  ::llvm::ArrayRef<::mlir::Type> outstandingCommitsTypes(&outstandingCommitsRawType, 1);
  if (parser.parseLBrace())
    return ::mlir::failure();

  outstandingCommitsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(outstandingCommitsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(outstandingCommitsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (outstandingCommitsTypeAttr) result.getOrAddProperties<ExperimentalClearOutstandingCommitsOp::Properties>().outstandingCommitsType = outstandingCommitsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(outstandingNumAttr, parser.getBuilder().getIntegerType(32))) {
    return ::mlir::failure();
  }
  if (outstandingNumAttr) result.getOrAddProperties<ExperimentalClearOutstandingCommitsOp::Properties>().outstandingNum = outstandingNumAttr;
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    outstandingCommitsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(outstandingCommitsOperands, outstandingCommitsTypes, outstandingCommitsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearOutstandingCommitsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "{";
  _odsPrinter << getOutstandingCommits();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getOutstandingCommitsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getOutstandingNumAttr());
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("outstandingCommitsType");
  elidedAttrs.push_back("outstandingNum");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getOutstandingCommits().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalClearOutstandingCommitsOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearOutstandingCommitsOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearReadBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalClearReadBarrierOpGenericAdaptorBase::ExperimentalClearReadBarrierOpGenericAdaptorBase(ExperimentalClearReadBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalClearReadBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalClearReadBarrierOpGenericAdaptorBase::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalClearReadBarrierOpAdaptor::ExperimentalClearReadBarrierOpAdaptor(ExperimentalClearReadBarrierOp op) : ExperimentalClearReadBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalClearReadBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitError(loc, "'tti.experimental_clear_read_barrier' op ""requires attribute 'readBarsType'");

  if (tblgen_readBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_readBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_readBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_clear_read_barrier' op ""attribute 'readBarsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalClearReadBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalClearReadBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalClearReadBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.readBarsType;
       auto attr = dict.get("readBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `readBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalClearReadBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.readBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("readBarsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalClearReadBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.readBarsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalClearReadBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "readBarsType")
      return prop.readBarsType;
  return std::nullopt;
}

void ExperimentalClearReadBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "readBarsType") {
       prop.readBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.readBarsType)>>(value);
       return;
    }
}

void ExperimentalClearReadBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.readBarsType) attrs.append("readBarsType", prop.readBarsType);
}

::llvm::LogicalResult ExperimentalClearReadBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getReadBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "readBarsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearReadBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.readBarsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearReadBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.readBarsType);
}

::mlir::Type ExperimentalClearReadBarrierOp::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalClearReadBarrierOp::setReadBarsType(::mlir::Type attrValue) {
  getProperties().readBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, readBars, readBarsType, pred);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, readBars, readBarsType, pred);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, readBars, readBarsType, pred);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, readBars, readBarsType, pred);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalClearReadBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalClearReadBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearReadBarrierOp ExperimentalClearReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalClearReadBarrierOp::verifyInvariantsImpl() {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitOpError("requires attribute 'readBarsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_readBarsType, "readBarsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearReadBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalClearReadBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand mbarRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> mbarOperands(&mbarRawOperand, 1);  ::llvm::SMLoc mbarOperandsLoc;
  (void)mbarOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barriersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barriersOperands(&barriersRawOperand, 1);  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand readBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> readBarsOperands(&readBarsRawOperand, 1);  ::llvm::SMLoc readBarsOperandsLoc;
  (void)readBarsOperandsLoc;
  ::mlir::TypeAttr readBarsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type mbarRawType{};
  ::llvm::ArrayRef<::mlir::Type> mbarTypes(&mbarRawType, 1);
  ::mlir::Type barriersRawType{};
  ::llvm::ArrayRef<::mlir::Type> barriersTypes(&barriersRawType, 1);
  ::mlir::Type readBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> readBarsTypes(&readBarsRawType, 1);

  mbarOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(mbarRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  barriersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barriersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  readBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(readBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(readBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (readBarsTypeAttr) result.getOrAddProperties<ExperimentalClearReadBarrierOp::Properties>().readBarsType = readBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    mbarRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    barriersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    readBarsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(mbarOperands, mbarTypes, mbarOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(readBarsOperands, readBarsTypes, readBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearReadBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMbar();
  _odsPrinter << "{";
  _odsPrinter << getBarriers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getReadBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getReadBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("readBarsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMbar().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBarriers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getReadBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalClearReadBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearReadBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearWriteBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalClearWriteBarrierOpGenericAdaptorBase::ExperimentalClearWriteBarrierOpGenericAdaptorBase(ExperimentalClearWriteBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalClearWriteBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalClearWriteBarrierOpGenericAdaptorBase::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalClearWriteBarrierOpGenericAdaptorBase::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalClearWriteBarrierOpAdaptor::ExperimentalClearWriteBarrierOpAdaptor(ExperimentalClearWriteBarrierOp op) : ExperimentalClearWriteBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalClearWriteBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitError(loc, "'tti.experimental_clear_write_barrier' op ""requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitError(loc, "'tti.experimental_clear_write_barrier' op ""requires attribute 'writeStateType'");

  if (tblgen_writeBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_clear_write_barrier' op ""attribute 'writeBarsType' failed to satisfy constraint: any type attribute");

  if (tblgen_writeStateType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeStateType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeStateType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_clear_write_barrier' op ""attribute 'writeStateType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalClearWriteBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalClearWriteBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalClearWriteBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.writeBarsType;
       auto attr = dict.get("writeBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.writeStateType;
       auto attr = dict.get("writeStateType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeStateType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalClearWriteBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.writeBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeBarsType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.writeStateType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeStateType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalClearWriteBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.writeBarsType.getAsOpaquePointer()), 
    llvm::hash_value(prop.writeStateType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalClearWriteBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "writeBarsType")
      return prop.writeBarsType;

    if (name == "writeStateType")
      return prop.writeStateType;
  return std::nullopt;
}

void ExperimentalClearWriteBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "writeBarsType") {
       prop.writeBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeBarsType)>>(value);
       return;
    }

    if (name == "writeStateType") {
       prop.writeStateType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeStateType)>>(value);
       return;
    }
}

void ExperimentalClearWriteBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.writeBarsType) attrs.append("writeBarsType", prop.writeBarsType);

    if (prop.writeStateType) attrs.append("writeStateType", prop.writeStateType);
}

::llvm::LogicalResult ExperimentalClearWriteBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getWriteBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeBarsType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWriteStateTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeStateType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearWriteBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.writeBarsType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.writeStateType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearWriteBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.writeBarsType);
  writer.writeAttribute(prop.writeStateType);
}

::mlir::Type ExperimentalClearWriteBarrierOp::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalClearWriteBarrierOp::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalClearWriteBarrierOp::setWriteBarsType(::mlir::Type attrValue) {
  getProperties().writeBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalClearWriteBarrierOp::setWriteStateType(::mlir::Type attrValue) {
  getProperties().writeStateType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalClearWriteBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalClearWriteBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalClearWriteBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalClearWriteBarrierOp ExperimentalClearWriteBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalClearWriteBarrierOp::verifyInvariantsImpl() {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitOpError("requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitOpError("requires attribute 'writeStateType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeBarsType, "writeBarsType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeStateType, "writeStateType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalClearWriteBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalClearWriteBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand mbarRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> mbarOperands(&mbarRawOperand, 1);  ::llvm::SMLoc mbarOperandsLoc;
  (void)mbarOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barriersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barriersOperands(&barriersRawOperand, 1);  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand writeBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeBarsOperands(&writeBarsRawOperand, 1);  ::llvm::SMLoc writeBarsOperandsLoc;
  (void)writeBarsOperandsLoc;
  ::mlir::TypeAttr writeBarsTypeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand writeStateRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeStateOperands(&writeStateRawOperand, 1);  ::llvm::SMLoc writeStateOperandsLoc;
  (void)writeStateOperandsLoc;
  ::mlir::TypeAttr writeStateTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type mbarRawType{};
  ::llvm::ArrayRef<::mlir::Type> mbarTypes(&mbarRawType, 1);
  ::mlir::Type barriersRawType{};
  ::llvm::ArrayRef<::mlir::Type> barriersTypes(&barriersRawType, 1);
  ::mlir::Type writeBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeBarsTypes(&writeBarsRawType, 1);
  ::mlir::Type writeStateRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeStateTypes(&writeStateRawType, 1);

  mbarOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(mbarRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  barriersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barriersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeBarsTypeAttr) result.getOrAddProperties<ExperimentalClearWriteBarrierOp::Properties>().writeBarsType = writeBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeStateOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeStateRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeStateTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeStateTypeAttr) result.getOrAddProperties<ExperimentalClearWriteBarrierOp::Properties>().writeStateType = writeStateTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    mbarRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    barriersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeBarsRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeStateRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(mbarOperands, mbarTypes, mbarOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeBarsOperands, writeBarsTypes, writeBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeStateOperands, writeStateTypes, writeStateOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalClearWriteBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMbar();
  _odsPrinter << "{";
  _odsPrinter << getBarriers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteState();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteStateTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("writeBarsType");
  elidedAttrs.push_back("writeStateType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMbar().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBarriers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteState().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalClearWriteBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearWriteBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCommitAccessesOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCommitAccessesOpGenericAdaptorBase::ExperimentalCommitAccessesOpGenericAdaptorBase(ExperimentalCommitAccessesOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCommitAccessesOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCommitAccessesOpGenericAdaptorBase::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalCommitAccessesOpAdaptor::ExperimentalCommitAccessesOpAdaptor(ExperimentalCommitAccessesOp op) : ExperimentalCommitAccessesOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCommitAccessesOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitError(loc, "'tti.experimental_commit_accesses' op ""requires attribute 'outstandingCommitsType'");

  if (tblgen_outstandingCommitsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_outstandingCommitsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_outstandingCommitsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_commit_accesses' op ""attribute 'outstandingCommitsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCommitAccessesOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCommitAccessesOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCommitAccessesOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.outstandingCommitsType;
       auto attr = dict.get("outstandingCommitsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `outstandingCommitsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCommitAccessesOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.outstandingCommitsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("outstandingCommitsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCommitAccessesOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.outstandingCommitsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCommitAccessesOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "outstandingCommitsType")
      return prop.outstandingCommitsType;
  return std::nullopt;
}

void ExperimentalCommitAccessesOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "outstandingCommitsType") {
       prop.outstandingCommitsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.outstandingCommitsType)>>(value);
       return;
    }
}

void ExperimentalCommitAccessesOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.outstandingCommitsType) attrs.append("outstandingCommitsType", prop.outstandingCommitsType);
}

::llvm::LogicalResult ExperimentalCommitAccessesOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getOutstandingCommitsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "outstandingCommitsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCommitAccessesOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.outstandingCommitsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCommitAccessesOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.outstandingCommitsType);
}

::mlir::Type ExperimentalCommitAccessesOp::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalCommitAccessesOp::setOutstandingCommitsType(::mlir::Type attrValue) {
  getProperties().outstandingCommitsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCommitAccessesOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCommitAccessesOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitAccessesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitAccessesOp ExperimentalCommitAccessesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCommitAccessesOp::verifyInvariantsImpl() {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitOpError("requires attribute 'outstandingCommitsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_outstandingCommitsType, "outstandingCommitsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCommitAccessesOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ExperimentalCommitAccessesOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand outstandingCommitsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> outstandingCommitsOperands(&outstandingCommitsRawOperand, 1);  ::llvm::SMLoc outstandingCommitsOperandsLoc;
  (void)outstandingCommitsOperandsLoc;
  ::mlir::TypeAttr outstandingCommitsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type outstandingCommitsRawType{};
  ::llvm::ArrayRef<::mlir::Type> outstandingCommitsTypes(&outstandingCommitsRawType, 1);
  if (parser.parseLBrace())
    return ::mlir::failure();

  outstandingCommitsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(outstandingCommitsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(outstandingCommitsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (outstandingCommitsTypeAttr) result.getOrAddProperties<ExperimentalCommitAccessesOp::Properties>().outstandingCommitsType = outstandingCommitsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    outstandingCommitsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(outstandingCommitsOperands, outstandingCommitsTypes, outstandingCommitsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCommitAccessesOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "{";
  _odsPrinter << getOutstandingCommits();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getOutstandingCommitsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("outstandingCommitsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getOutstandingCommits().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCommitAccessesOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCommitAccessesOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCommitWriteWithBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase::ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase(ExperimentalCommitWriteWithBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalCommitWriteWithBarrierOpAdaptor::ExperimentalCommitWriteWithBarrierOpAdaptor(ExperimentalCommitWriteWithBarrierOp op) : ExperimentalCommitWriteWithBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitError(loc, "'tti.experimental_commit_write_with_barrier' op ""requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitError(loc, "'tti.experimental_commit_write_with_barrier' op ""requires attribute 'writeStateType'");

  if (tblgen_writeBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_commit_write_with_barrier' op ""attribute 'writeBarsType' failed to satisfy constraint: any type attribute");

  if (tblgen_writeStateType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeStateType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeStateType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_commit_write_with_barrier' op ""attribute 'writeStateType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalCommitWriteWithBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalCommitWriteWithBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.writeBarsType;
       auto attr = dict.get("writeBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.writeStateType;
       auto attr = dict.get("writeStateType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeStateType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalCommitWriteWithBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.writeBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeBarsType",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.writeStateType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeStateType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalCommitWriteWithBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.writeBarsType.getAsOpaquePointer()), 
    llvm::hash_value(prop.writeStateType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalCommitWriteWithBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "writeBarsType")
      return prop.writeBarsType;

    if (name == "writeStateType")
      return prop.writeStateType;
  return std::nullopt;
}

void ExperimentalCommitWriteWithBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "writeBarsType") {
       prop.writeBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeBarsType)>>(value);
       return;
    }

    if (name == "writeStateType") {
       prop.writeStateType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeStateType)>>(value);
       return;
    }
}

void ExperimentalCommitWriteWithBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.writeBarsType) attrs.append("writeBarsType", prop.writeBarsType);

    if (prop.writeStateType) attrs.append("writeStateType", prop.writeStateType);
}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getWriteBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeBarsType", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWriteStateTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeStateType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.writeBarsType)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.writeStateType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCommitWriteWithBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.writeBarsType);
  writer.writeAttribute(prop.writeStateType);
}

::mlir::Type ExperimentalCommitWriteWithBarrierOp::getWriteBarsType() {
  auto attr = getWriteBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Type ExperimentalCommitWriteWithBarrierOp::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalCommitWriteWithBarrierOp::setWriteBarsType(::mlir::Type attrValue) {
  getProperties().writeBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCommitWriteWithBarrierOp::setWriteStateType(::mlir::Type attrValue) {
  getProperties().writeStateType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = writeBarsType;
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(mbar);
  odsState.addOperands(barriers);
  odsState.addOperands(writeBars);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeBarsType = ::mlir::TypeAttr::get(writeBarsType);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, mbar, barriers, writeBars, writeBarsType, writeState, writeStateType, pred);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalCommitWriteWithBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalCommitWriteWithBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalCommitWriteWithBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalCommitWriteWithBarrierOp ExperimentalCommitWriteWithBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOp::verifyInvariantsImpl() {
  auto tblgen_writeBarsType = getProperties().writeBarsType; (void)tblgen_writeBarsType;
  if (!tblgen_writeBarsType) return emitOpError("requires attribute 'writeBarsType'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitOpError("requires attribute 'writeStateType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeBarsType, "writeBarsType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeStateType, "writeStateType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalCommitWriteWithBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalCommitWriteWithBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand mbarRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> mbarOperands(&mbarRawOperand, 1);  ::llvm::SMLoc mbarOperandsLoc;
  (void)mbarOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barriersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barriersOperands(&barriersRawOperand, 1);  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand writeBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeBarsOperands(&writeBarsRawOperand, 1);  ::llvm::SMLoc writeBarsOperandsLoc;
  (void)writeBarsOperandsLoc;
  ::mlir::TypeAttr writeBarsTypeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand writeStateRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeStateOperands(&writeStateRawOperand, 1);  ::llvm::SMLoc writeStateOperandsLoc;
  (void)writeStateOperandsLoc;
  ::mlir::TypeAttr writeStateTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type mbarRawType{};
  ::llvm::ArrayRef<::mlir::Type> mbarTypes(&mbarRawType, 1);
  ::mlir::Type barriersRawType{};
  ::llvm::ArrayRef<::mlir::Type> barriersTypes(&barriersRawType, 1);
  ::mlir::Type writeBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeBarsTypes(&writeBarsRawType, 1);
  ::mlir::Type writeStateRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeStateTypes(&writeStateRawType, 1);

  mbarOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(mbarRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  barriersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barriersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeBarsTypeAttr) result.getOrAddProperties<ExperimentalCommitWriteWithBarrierOp::Properties>().writeBarsType = writeBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeStateOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeStateRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeStateTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeStateTypeAttr) result.getOrAddProperties<ExperimentalCommitWriteWithBarrierOp::Properties>().writeStateType = writeStateTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    mbarRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    barriersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeBarsRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeStateRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(mbarOperands, mbarTypes, mbarOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeBarsOperands, writeBarsTypes, writeBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeStateOperands, writeStateTypes, writeStateOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalCommitWriteWithBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMbar();
  _odsPrinter << "{";
  _odsPrinter << getBarriers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteState();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteStateTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("writeBarsType");
  elidedAttrs.push_back("writeStateType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMbar().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBarriers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteState().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalCommitWriteWithBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCommitWriteWithBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalSetReadBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalSetReadBarrierOpGenericAdaptorBase::ExperimentalSetReadBarrierOpGenericAdaptorBase(ExperimentalSetReadBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalSetReadBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 5) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalSetReadBarrierOpGenericAdaptorBase::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalSetReadBarrierOpAdaptor::ExperimentalSetReadBarrierOpAdaptor(ExperimentalSetReadBarrierOp op) : ExperimentalSetReadBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalSetReadBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitError(loc, "'tti.experimental_set_read_barrier' op ""requires attribute 'readBarsType'");

  if (tblgen_readBarsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_readBarsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_readBarsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_set_read_barrier' op ""attribute 'readBarsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalSetReadBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 5) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalSetReadBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalSetReadBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.readBarsType;
       auto attr = dict.get("readBarsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `readBarsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalSetReadBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.readBarsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("readBarsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalSetReadBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.readBarsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalSetReadBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "readBarsType")
      return prop.readBarsType;
  return std::nullopt;
}

void ExperimentalSetReadBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "readBarsType") {
       prop.readBarsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.readBarsType)>>(value);
       return;
    }
}

void ExperimentalSetReadBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.readBarsType) attrs.append("readBarsType", prop.readBarsType);
}

::llvm::LogicalResult ExperimentalSetReadBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getReadBarsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "readBarsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalSetReadBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.readBarsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalSetReadBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.readBarsType);
}

::mlir::Type ExperimentalSetReadBarrierOp::getReadBarsType() {
  auto attr = getReadBarsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalSetReadBarrierOp::setReadBarsType(::mlir::Type attrValue) {
  getProperties().readBarsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(mbar);
  odsState.addOperands(buffers);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, mbar, buffers, barriers, readBars, readBarsType, pred);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(mbar);
  odsState.addOperands(buffers);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = readBarsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(mbar);
  odsState.addOperands(buffers);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, mbar, buffers, barriers, readBars, readBarsType, pred);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(mbar);
  odsState.addOperands(buffers);
  odsState.addOperands(barriers);
  odsState.addOperands(readBars);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().readBarsType = ::mlir::TypeAttr::get(readBarsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, mbar, buffers, barriers, readBars, readBarsType, pred);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalSetReadBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalSetReadBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetReadBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetReadBarrierOp ExperimentalSetReadBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalSetReadBarrierOp::verifyInvariantsImpl() {
  auto tblgen_readBarsType = getProperties().readBarsType; (void)tblgen_readBarsType;
  if (!tblgen_readBarsType) return emitOpError("requires attribute 'readBarsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_readBarsType, "readBarsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    if (valueGroup5.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup5.size();
    }

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalSetReadBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalSetReadBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand mbarRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> mbarOperands(&mbarRawOperand, 1);  ::llvm::SMLoc mbarOperandsLoc;
  (void)mbarOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barriersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barriersOperands(&barriersRawOperand, 1);  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand readBarsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> readBarsOperands(&readBarsRawOperand, 1);  ::llvm::SMLoc readBarsOperandsLoc;
  (void)readBarsOperandsLoc;
  ::mlir::TypeAttr readBarsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type mbarRawType{};
  ::llvm::ArrayRef<::mlir::Type> mbarTypes(&mbarRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type barriersRawType{};
  ::llvm::ArrayRef<::mlir::Type> barriersTypes(&barriersRawType, 1);
  ::mlir::Type readBarsRawType{};
  ::llvm::ArrayRef<::mlir::Type> readBarsTypes(&readBarsRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  mbarOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(mbarRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  barriersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barriersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  readBarsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(readBarsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(readBarsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (readBarsTypeAttr) result.getOrAddProperties<ExperimentalSetReadBarrierOp::Properties>().readBarsType = readBarsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    mbarRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    barriersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    readBarsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(mbarOperands, mbarTypes, mbarOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(readBarsOperands, readBarsTypes, readBarsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalSetReadBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMbar();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBarriers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getReadBars();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getReadBarsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("readBarsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getMbar().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBarriers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getReadBars().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalSetReadBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalSetReadBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalSetWriteStateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalSetWriteStateOpGenericAdaptorBase::ExperimentalSetWriteStateOpGenericAdaptorBase(ExperimentalSetWriteStateOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalSetWriteStateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalSetWriteStateOpGenericAdaptorBase::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

bool ExperimentalSetWriteStateOpGenericAdaptorBase::getHwPipelined() {
  auto attr = getHwPipelinedAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
ExperimentalSetWriteStateOpAdaptor::ExperimentalSetWriteStateOpAdaptor(ExperimentalSetWriteStateOp op) : ExperimentalSetWriteStateOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalSetWriteStateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_hwPipelined = getProperties().hwPipelined; (void)tblgen_hwPipelined;
  if (!tblgen_hwPipelined) return emitError(loc, "'tti.experimental_set_write_state' op ""requires attribute 'hwPipelined'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitError(loc, "'tti.experimental_set_write_state' op ""requires attribute 'writeStateType'");

  if (tblgen_writeStateType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_writeStateType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_writeStateType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_set_write_state' op ""attribute 'writeStateType' failed to satisfy constraint: any type attribute");

  if (tblgen_hwPipelined && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_hwPipelined))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_hwPipelined).getType().isSignlessInteger(1)))))
    return emitError(loc, "'tti.experimental_set_write_state' op ""attribute 'hwPipelined' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalSetWriteStateOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalSetWriteStateOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalSetWriteStateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.hwPipelined;
       auto attr = dict.get("hwPipelined");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hwPipelined` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.writeStateType;
       auto attr = dict.get("writeStateType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `writeStateType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalSetWriteStateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.hwPipelined;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hwPipelined",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.writeStateType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("writeStateType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalSetWriteStateOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.hwPipelined.getAsOpaquePointer()), 
    llvm::hash_value(prop.writeStateType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalSetWriteStateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "hwPipelined")
      return prop.hwPipelined;

    if (name == "writeStateType")
      return prop.writeStateType;
  return std::nullopt;
}

void ExperimentalSetWriteStateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "hwPipelined") {
       prop.hwPipelined = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hwPipelined)>>(value);
       return;
    }

    if (name == "writeStateType") {
       prop.writeStateType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.writeStateType)>>(value);
       return;
    }
}

void ExperimentalSetWriteStateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.hwPipelined) attrs.append("hwPipelined", prop.hwPipelined);

    if (prop.writeStateType) attrs.append("writeStateType", prop.writeStateType);
}

::llvm::LogicalResult ExperimentalSetWriteStateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getHwPipelinedAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps6(attr, "hwPipelined", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWriteStateTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "writeStateType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalSetWriteStateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.hwPipelined)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.writeStateType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalSetWriteStateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.hwPipelined);
  writer.writeAttribute(prop.writeStateType);
}

::mlir::Type ExperimentalSetWriteStateOp::getWriteStateType() {
  auto attr = getWriteStateTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

bool ExperimentalSetWriteStateOp::getHwPipelined() {
  auto attr = getHwPipelinedAttr();
  return attr.getValue().getZExtValue();
}

void ExperimentalSetWriteStateOp::setWriteStateType(::mlir::Type attrValue) {
  getProperties().writeStateType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalSetWriteStateOp::setHwPipelined(bool attrValue) {
  getProperties().hwPipelined = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  odsState.getOrAddProperties<Properties>().hwPipelined = hwPipelined;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeStateType = writeStateType;
  odsState.getOrAddProperties<Properties>().hwPipelined = hwPipelined;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  odsState.getOrAddProperties<Properties>().hwPipelined = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), hwPipelined);
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(writeState);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().writeStateType = ::mlir::TypeAttr::get(writeStateType);
  odsState.getOrAddProperties<Properties>().hwPipelined = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), hwPipelined);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, writeState, writeStateType, hwPipelined, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, writeState, writeStateType, hwPipelined, pred);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalSetWriteStateOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalSetWriteStateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalSetWriteStateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalSetWriteStateOp ExperimentalSetWriteStateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalSetWriteStateOp::verifyInvariantsImpl() {
  auto tblgen_hwPipelined = getProperties().hwPipelined; (void)tblgen_hwPipelined;
  if (!tblgen_hwPipelined) return emitOpError("requires attribute 'hwPipelined'");
  auto tblgen_writeStateType = getProperties().writeStateType; (void)tblgen_writeStateType;
  if (!tblgen_writeStateType) return emitOpError("requires attribute 'writeStateType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_writeStateType, "writeStateType")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps6(*this, tblgen_hwPipelined, "hwPipelined")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalSetWriteStateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalSetWriteStateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand writeStateRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> writeStateOperands(&writeStateRawOperand, 1);  ::llvm::SMLoc writeStateOperandsLoc;
  (void)writeStateOperandsLoc;
  ::mlir::TypeAttr writeStateTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::IntegerAttr hwPipelinedAttr;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type writeStateRawType{};
  ::llvm::ArrayRef<::mlir::Type> writeStateTypes(&writeStateRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  writeStateOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(writeStateRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(writeStateTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (writeStateTypeAttr) result.getOrAddProperties<ExperimentalSetWriteStateOp::Properties>().writeStateType = writeStateTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  if (parser.parseKeyword("pipelined"))
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(hwPipelinedAttr, parser.getBuilder().getIntegerType(1))) {
    return ::mlir::failure();
  }
  if (hwPipelinedAttr) result.getOrAddProperties<ExperimentalSetWriteStateOp::Properties>().hwPipelined = hwPipelinedAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    writeStateRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(writeStateOperands, writeStateTypes, writeStateOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalSetWriteStateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getWriteState();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getWriteStateTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  _odsPrinter << ' ' << "pipelined";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getHwPipelinedAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("writeStateType");
  elidedAttrs.push_back("hwPipelined");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getWriteState().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalSetWriteStateOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalSetWriteStateOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalStageAccessForCommitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExperimentalStageAccessForCommitOpGenericAdaptorBase::ExperimentalStageAccessForCommitOpGenericAdaptorBase(ExperimentalStageAccessForCommitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ExperimentalStageAccessForCommitOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Type ExperimentalStageAccessForCommitOpGenericAdaptorBase::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

} // namespace detail
ExperimentalStageAccessForCommitOpAdaptor::ExperimentalStageAccessForCommitOpAdaptor(ExperimentalStageAccessForCommitOp op) : ExperimentalStageAccessForCommitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ExperimentalStageAccessForCommitOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitError(loc, "'tti.experimental_stage_access_for_commit' op ""requires attribute 'outstandingCommitsType'");

  if (tblgen_outstandingCommitsType && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_outstandingCommitsType))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_outstandingCommitsType).getValue()))) && ((true))))
    return emitError(loc, "'tti.experimental_stage_access_for_commit' op ""attribute 'outstandingCommitsType' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExperimentalStageAccessForCommitOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ExperimentalStageAccessForCommitOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ExperimentalStageAccessForCommitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.outstandingCommitsType;
       auto attr = dict.get("outstandingCommitsType");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `outstandingCommitsType` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExperimentalStageAccessForCommitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.outstandingCommitsType;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("outstandingCommitsType",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExperimentalStageAccessForCommitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.outstandingCommitsType.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExperimentalStageAccessForCommitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "outstandingCommitsType")
      return prop.outstandingCommitsType;
  return std::nullopt;
}

void ExperimentalStageAccessForCommitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "outstandingCommitsType") {
       prop.outstandingCommitsType = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.outstandingCommitsType)>>(value);
       return;
    }
}

void ExperimentalStageAccessForCommitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.outstandingCommitsType) attrs.append("outstandingCommitsType", prop.outstandingCommitsType);
}

::llvm::LogicalResult ExperimentalStageAccessForCommitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getOutstandingCommitsTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(attr, "outstandingCommitsType", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ExperimentalStageAccessForCommitOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.outstandingCommitsType)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalStageAccessForCommitOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.outstandingCommitsType);
}

::mlir::Type ExperimentalStageAccessForCommitOp::getOutstandingCommitsType() {
  auto attr = getOutstandingCommitsTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void ExperimentalStageAccessForCommitOp::setOutstandingCommitsType(::mlir::Type attrValue) {
  getProperties().outstandingCommitsType = ::mlir::TypeAttr::get(attrValue);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = outstandingCommitsType;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), buf, buffers, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  odsState.addOperands(buf);
  odsState.addOperands(buffers);
  odsState.addOperands(outstandingCommits);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().outstandingCommitsType = ::mlir::TypeAttr::get(outstandingCommitsType);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, buf, buffers, outstandingCommits, outstandingCommitsType, pred);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ExperimentalStageAccessForCommitOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ExperimentalStageAccessForCommitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ExperimentalStageAccessForCommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ExperimentalStageAccessForCommitOp ExperimentalStageAccessForCommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ExperimentalStageAccessForCommitOp::verifyInvariantsImpl() {
  auto tblgen_outstandingCommitsType = getProperties().outstandingCommitsType; (void)tblgen_outstandingCommitsType;
  if (!tblgen_outstandingCommitsType) return emitOpError("requires attribute 'outstandingCommitsType'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonInstrumentOps5(*this, tblgen_outstandingCommitsType, "outstandingCommitsType")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonInstrumentOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ExperimentalStageAccessForCommitOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExperimentalStageAccessForCommitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufOperands(&bufRawOperand, 1);  ::llvm::SMLoc bufOperandsLoc;
  (void)bufOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand buffersRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> buffersOperands(&buffersRawOperand, 1);  ::llvm::SMLoc buffersOperandsLoc;
  (void)buffersOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand outstandingCommitsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> outstandingCommitsOperands(&outstandingCommitsRawOperand, 1);  ::llvm::SMLoc outstandingCommitsOperandsLoc;
  (void)outstandingCommitsOperandsLoc;
  ::mlir::TypeAttr outstandingCommitsTypeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type bufRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufTypes(&bufRawType, 1);
  ::mlir::Type buffersRawType{};
  ::llvm::ArrayRef<::mlir::Type> buffersTypes(&buffersRawType, 1);
  ::mlir::Type outstandingCommitsRawType{};
  ::llvm::ArrayRef<::mlir::Type> outstandingCommitsTypes(&outstandingCommitsRawType, 1);

  bufOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufRawOperand))
    return ::mlir::failure();
  if (parser.parseLBrace())
    return ::mlir::failure();

  buffersOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(buffersRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  outstandingCommitsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(outstandingCommitsRawOperand))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(outstandingCommitsTypeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (outstandingCommitsTypeAttr) result.getOrAddProperties<ExperimentalStageAccessForCommitOp::Properties>().outstandingCommitsType = outstandingCommitsTypeAttr;
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseRBrace())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::MemDescType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    bufRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    buffersRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    outstandingCommitsRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(bufOperands, bufTypes, bufOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(buffersOperands, buffersTypes, buffersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(outstandingCommitsOperands, outstandingCommitsTypes, outstandingCommitsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExperimentalStageAccessForCommitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuf();
  _odsPrinter << "{";
  _odsPrinter << getBuffers();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getOutstandingCommits();
  _odsPrinter << "(";
  _odsPrinter.printAttributeWithoutType(getOutstandingCommitsTypeAttr());
  _odsPrinter << ")";
  _odsPrinter << "}";
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("outstandingCommitsType");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBuf().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::MemDescType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getBuffers().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getOutstandingCommits().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExperimentalStageAccessForCommitOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalStageAccessForCommitOp)


#endif  // GET_OP_CLASSES

