/* SessionUtils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SessionUtils.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN gboolean settings_daemon_utils_is_running_in_demo_mode (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
settings_daemon_utils_is_running_in_demo_mode (void)
{
	GFile* proc_cmdline = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = g_file_new_for_path ("/proc/cmdline");
	proc_cmdline = _tmp0_;
	{
		GFileInputStream* is = NULL;
		GFile* _tmp1_;
		GFileInputStream* _tmp2_;
		GDataInputStream* dis = NULL;
		GFileInputStream* _tmp3_;
		GDataInputStream* _tmp4_;
		gchar* line = NULL;
		GDataInputStream* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		_tmp1_ = proc_cmdline;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
		is = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = is;
		_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
		dis = _tmp4_;
		_tmp5_ = dis;
		_tmp6_ = g_data_input_stream_read_line (_tmp5_, NULL, NULL, &_inner_error0_);
		line = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_object_unref0 (is);
			goto __catch0_g_error;
		}
		_tmp9_ = line;
		if (string_contains (_tmp9_, "boot=casper")) {
			_tmp8_ = TRUE;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = line;
			_tmp8_ = string_contains (_tmp10_, "boot=live");
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = line;
			_tmp7_ = string_contains (_tmp11_, "rd.live.image");
		}
		if (_tmp7_) {
			result = TRUE;
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (is);
			_g_object_unref0 (proc_cmdline);
			return result;
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (is);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("SessionUtils.vala:18: Couldn't detect if running in Demo Mode: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		_g_object_unref0 (proc_cmdline);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = FALSE;
	_g_object_unref0 (proc_cmdline);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

