/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <camel/camel.h>

#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE "compose_message"
#define MAIL_MAIN_WINDOW_ACTION_REFRESH "refresh"
#define MAIL_MAIN_WINDOW_ACTION_REPLY "reply"
#define MAIL_MAIN_WINDOW_ACTION_REPLY_ALL "reply-all"
#define MAIL_MAIN_WINDOW_ACTION_FORWARD "forward"
#define MAIL_MAIN_WINDOW_ACTION_PRINT "print"
#define MAIL_MAIN_WINDOW_ACTION_MODIFY "modify"
#define MAIL_MAIN_WINDOW_ACTION_MARK_READ "mark-read"
#define MAIL_MAIN_WINDOW_ACTION_MARK_STAR "mark-star"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD "mark-unread"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR "mark-unstar"
#define MAIL_MAIN_WINDOW_ACTION_ARCHIVE "archive"
#define MAIL_MAIN_WINDOW_ACTION_MOVE "move"
#define MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH "trash"
#define MAIL_MAIN_WINDOW_ACTION_FULLSCREEN "full-screen"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_MAIN_WINDOW (mail_main_window_get_type ())
#define MAIL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindow))
#define MAIL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))
#define MAIL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MAIN_WINDOW))
#define MAIL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MAIN_WINDOW, MailMainWindowClass))

typedef struct _MailMainWindow MailMainWindow;
typedef struct _MailMainWindowClass MailMainWindowClass;
typedef struct _MailMainWindowPrivate MailMainWindowPrivate;

#define MAIL_TYPE_FOLDERS_LIST_VIEW (mail_folders_list_view_get_type ())
#define MAIL_FOLDERS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView))
#define MAIL_FOLDERS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListViewClass))
#define MAIL_IS_FOLDERS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW))
#define MAIL_IS_FOLDERS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDERS_LIST_VIEW))
#define MAIL_FOLDERS_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListViewClass))

typedef struct _MailFoldersListView MailFoldersListView;
typedef struct _MailFoldersListViewClass MailFoldersListViewClass;

#define MAIL_TYPE_CONVERSATION_LIST (mail_conversation_list_get_type ())
#define MAIL_CONVERSATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_LIST, MailConversationList))
#define MAIL_CONVERSATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_LIST, MailConversationListClass))
#define MAIL_IS_CONVERSATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_LIST))
#define MAIL_IS_CONVERSATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_LIST))
#define MAIL_CONVERSATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_LIST, MailConversationListClass))

typedef struct _MailConversationList MailConversationList;
typedef struct _MailConversationListClass MailConversationListClass;

#define MAIL_TYPE_MESSAGE_LIST (mail_message_list_get_type ())
#define MAIL_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageList))
#define MAIL_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))
#define MAIL_IS_MESSAGE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_IS_MESSAGE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MESSAGE_LIST))
#define MAIL_MESSAGE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MESSAGE_LIST, MailMessageListClass))

typedef struct _MailMessageList MailMessageList;
typedef struct _MailMessageListClass MailMessageListClass;
enum  {
	MAIL_MAIN_WINDOW_0_PROPERTY,
	MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY,
	MAIL_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* mail_main_window_properties[MAIL_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_TYPE_COMPOSER (mail_composer_get_type ())
#define MAIL_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_COMPOSER, MailComposer))
#define MAIL_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_COMPOSER, MailComposerClass))
#define MAIL_IS_COMPOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_COMPOSER))
#define MAIL_IS_COMPOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_COMPOSER))
#define MAIL_COMPOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_COMPOSER, MailComposerClass))

typedef struct _MailComposer MailComposer;
typedef struct _MailComposerClass MailComposerClass;
typedef enum  {
	MAIL_COMPOSER_TYPE_REPLY,
	MAIL_COMPOSER_TYPE_REPLY_ALL,
	MAIL_COMPOSER_TYPE_FORWARD,
	MAIL_COMPOSER_TYPE_DRAFT
} MailComposerType;

#define MAIL_COMPOSER_TYPE_TYPE (mail_composer_type_get_type ())
typedef enum  {
	MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH,
	MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH
} MailMoveOperationMoveType;

#define MAIL_MOVE_OPERATION_TYPE_MOVE_TYPE (mail_move_operation_move_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAIL_TYPE_WELCOME_VIEW (mail_welcome_view_get_type ())
#define MAIL_WELCOME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WELCOME_VIEW, MailWelcomeView))
#define MAIL_WELCOME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WELCOME_VIEW, MailWelcomeViewClass))
#define MAIL_IS_WELCOME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WELCOME_VIEW))
#define MAIL_IS_WELCOME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WELCOME_VIEW))
#define MAIL_WELCOME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WELCOME_VIEW, MailWelcomeViewClass))

typedef struct _MailWelcomeView MailWelcomeView;
typedef struct _MailWelcomeViewClass MailWelcomeViewClass;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _Block19Data Block19Data;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;

#define MAIL_TYPE_APPLICATION (mail_application_get_type ())
#define MAIL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_APPLICATION, MailApplication))
#define MAIL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_APPLICATION, MailApplicationClass))
#define MAIL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_APPLICATION))
#define MAIL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_APPLICATION))
#define MAIL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_APPLICATION, MailApplicationClass))

typedef struct _MailApplication MailApplication;
typedef struct _MailApplicationClass MailApplicationClass;
enum  {
	MAIL_MAIN_WINDOW_SESSION_STARTED_SIGNAL,
	MAIL_MAIN_WINDOW_NUM_SIGNALS
};
static guint mail_main_window_signals[MAIL_MAIN_WINDOW_NUM_SIGNALS] = {0};

struct _MailMainWindow {
	HdyApplicationWindow parent_instance;
	MailMainWindowPrivate * priv;
};

struct _MailMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _MailMainWindowPrivate {
	GtkPaned* paned_end;
	GtkPaned* paned_start;
	MailFoldersListView* folders_list_view;
	GraniteWidgetsToast* move_toast;
	GraniteWidgetsToast* error_toast;
	MailConversationList* conversation_list;
	MailMessageList* message_list;
	guint configure_id;
	gboolean _is_session_started;
};

struct _Block19Data {
	int _ref_count_;
	MailMainWindow* self;
	GraniteWidgetsOverlayBar* message_overlay;
	MailWelcomeView* welcome_view;
	GtkStack* placeholder_stack;
	MailBackendSession* session;
	gulong account_removed_handler;
	gulong account_added_handler;
};

static gint MailMainWindow_private_offset;
static gpointer mail_main_window_parent_class = NULL;
VALA_EXTERN GeeMultiMap* mail_main_window_action_accelerators;
GeeMultiMap* mail_main_window_action_accelerators = NULL;
VALA_EXTERN GSettings* mail_application_settings;

VALA_EXTERN GType mail_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMainWindow, g_object_unref)
VALA_EXTERN GType mail_folders_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFoldersListView, g_object_unref)
VALA_EXTERN GType mail_conversation_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationList, g_object_unref)
VALA_EXTERN GType mail_message_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMessageList, g_object_unref)
static void mail_main_window_action_compose (MailMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* parameter);
static void _mail_main_window_action_compose_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void mail_main_window_on_refresh (MailMainWindow* self);
static void _mail_main_window_on_refresh_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void mail_main_window_on_print (MailMainWindow* self,
                                GSimpleAction* action,
                                GVariant* parameter);
static void _mail_main_window_on_print_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void mail_main_window_on_mark_read (MailMainWindow* self);
static void _mail_main_window_on_mark_read_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void mail_main_window_on_mark_star (MailMainWindow* self);
static void _mail_main_window_on_mark_star_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void mail_main_window_on_mark_unread (MailMainWindow* self);
static void _mail_main_window_on_mark_unread_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void mail_main_window_on_mark_unstar (MailMainWindow* self);
static void _mail_main_window_on_mark_unstar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void mail_main_window_action_move (MailMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter);
static void _mail_main_window_action_move_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void mail_main_window_on_fullscreen (MailMainWindow* self);
static void _mail_main_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN MailMainWindow* mail_main_window_new (GtkApplication* application);
VALA_EXTERN MailMainWindow* mail_main_window_construct (GType object_type,
                                            GtkApplication* application);
VALA_EXTERN void mail_conversation_list_refresh_folder (MailConversationList* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void mail_conversation_list_refresh_folder_finish (MailConversationList* self,
                                                   GAsyncResult* _res_);
VALA_EXTERN void mail_conversation_list_mark_read_selected_messages (MailConversationList* self);
static GSimpleAction* mail_main_window_get_action (MailMainWindow* self,
                                            const gchar* name);
VALA_EXTERN void mail_conversation_list_mark_star_selected_messages (MailConversationList* self);
VALA_EXTERN void mail_conversation_list_mark_unread_selected_messages (MailConversationList* self);
VALA_EXTERN void mail_conversation_list_mark_unstar_selected_messages (MailConversationList* self);
VALA_EXTERN MailComposer* mail_composer_new (const gchar* to,
                                 const gchar* mailto_query);
VALA_EXTERN MailComposer* mail_composer_construct (GType object_type,
                                       const gchar* to,
                                       const gchar* mailto_query);
VALA_EXTERN GType mail_composer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailComposer, g_object_unref)
VALA_EXTERN GType mail_composer_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void mail_message_list_compose (MailMessageList* self,
                                MailComposerType type,
                                GVariant* uid,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void mail_message_list_compose_finish (MailMessageList* self,
                                       GAsyncResult* _res_);
VALA_EXTERN void mail_message_list_print (MailMessageList* self,
                              GVariant* uid);
VALA_EXTERN GType mail_move_operation_move_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void mail_conversation_list_move_selected_messages (MailConversationList* self,
                                                    MailMoveOperationMoveType move_type,
                                                    GVariant* dst_folder_full_name,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN guint mail_conversation_list_move_selected_messages_finish (MailConversationList* self,
                                                            GAsyncResult* _res_,
                                                            gchar** error_message);
static void ___lambda124_ (MailMainWindow* self,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN void mail_main_window_send_error_message (const gchar* title,
                                          const gchar* description,
                                          const gchar* icon_name,
                                          const gchar* error_details);
static void ____lambda124__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda125_ (MailMainWindow* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda125__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda126_ (MailMainWindow* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda126__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN HdyHeaderBar* mail_message_list_get_headerbar (MailMessageList* self);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static gboolean mail_main_window_real_configure_event (GtkWidget* base,
                                                GdkEventConfigure* event);
static gboolean __lambda127_ (MailMainWindow* self);
static gboolean ___lambda127__gsource_func (gpointer self);
VALA_EXTERN gboolean mail_main_window_get_is_session_started (MailMainWindow* self);
static void mail_main_window_set_is_session_started (MailMainWindow* self,
                                              gboolean value);
static GObject * mail_main_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN GType mail_welcome_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWelcomeView, g_object_unref)
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN MailFoldersListView* mail_folders_list_view_new (void);
VALA_EXTERN MailFoldersListView* mail_folders_list_view_construct (GType object_type);
VALA_EXTERN MailConversationList* mail_conversation_list_new (void);
VALA_EXTERN MailConversationList* mail_conversation_list_construct (GType object_type);
VALA_EXTERN MailMessageList* mail_message_list_new (void);
VALA_EXTERN MailMessageList* mail_message_list_construct (GType object_type);
static void _mail_main_window___lambda128_ (MailMainWindow* self);
VALA_EXTERN void mail_move_operation_undo_last_move (void);
static void __mail_main_window___lambda128__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                           gpointer self);
static void _mail_main_window___lambda129_ (Block19Data* _data19_,
                                     const gchar* label,
                                     const gchar* url);
static void __mail_main_window___lambda129__mail_message_list_hovering_over_link (MailMessageList* _sender,
                                                                           const gchar* label,
                                                                           const gchar* uri,
                                                                           gpointer self);
VALA_EXTERN MailWelcomeView* mail_welcome_view_new (void);
VALA_EXTERN MailWelcomeView* mail_welcome_view_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* mail_folders_list_view_get_header_bar (MailFoldersListView* self);
VALA_EXTERN HdyHeaderBar* mail_conversation_list_get_search_header (MailConversationList* self);
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN void mail_conversation_list_load_folder (MailConversationList* self,
                                         GeeMap* folder_info_per_account,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void mail_conversation_list_load_folder_finish (MailConversationList* self,
                                                GAsyncResult* _res_);
static void _mail_conversation_list_load_folder_mail_folders_list_view_folder_selected (MailFoldersListView* _sender,
                                                                                 GeeMap* folder_info_per_account,
                                                                                 gpointer self);
VALA_EXTERN void mail_message_list_set_conversation (MailMessageList* self,
                                         CamelFolderThreadNode* node);
static void _mail_message_list_set_conversation_mail_conversation_list_conversation_selected (MailConversationList* _sender,
                                                                                       CamelFolderThreadNode* node,
                                                                                       gpointer self);
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
static void _mail_main_window___lambda131_ (Block19Data* _data19_);
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
static void __mail_main_window___lambda131__mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                           MailBackendAccount* account,
                                                                           gpointer self);
static void _mail_main_window___lambda132_ (Block19Data* _data19_);
static void __mail_main_window___lambda132__mail_backend_session_account_added (MailBackendSession* _sender,
                                                                         MailBackendAccount* account,
                                                                         gpointer self);
VALA_EXTERN void mail_backend_session_start (MailBackendSession* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void mail_backend_session_start_finish (MailBackendSession* self,
                                        GAsyncResult* _res_);
static void _mail_main_window___lambda133_ (Block19Data* _data19_,
                                     GObject* obj,
                                     GAsyncResult* res);
static void __mail_main_window___lambda133__gasync_ready_callback (GObject* source_object,
                                                            GAsyncResult* res,
                                                            gpointer self);
static gboolean _mail_main_window___lambda134_ (MailMainWindow* self);
VALA_EXTERN GType mail_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailApplication, g_object_unref)
VALA_EXTERN void mail_application_request_background (MailApplication* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void mail_application_request_background_finish (MailApplication* self,
                                                 GAsyncResult* _res_);
static void __lambda135_ (MailMainWindow* self);
static void ___lambda135__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __mail_main_window___lambda134__gtk_widget_delete_event (GtkWidget* _sender,
                                                                  GdkEventAny* event,
                                                                  gpointer self);
static void _mail_main_window___lambda136_ (Block19Data* _data19_);
static void __mail_main_window___lambda136__gtk_widget_destroy (GtkWidget* _sender,
                                                         gpointer self);
static void mail_main_window_finalize (GObject * obj);
static GType mail_main_window_get_type_once (void);
static void _vala_mail_main_window_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_mail_main_window_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry MAIL_MAIN_WINDOW_ACTION_ENTRIES[15] = {{MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE, _mail_main_window_action_compose_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_REFRESH, _mail_main_window_on_refresh_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_REPLY, _mail_main_window_action_compose_gsimple_action_activate_callback, "s"}, {MAIL_MAIN_WINDOW_ACTION_REPLY_ALL, _mail_main_window_action_compose_gsimple_action_activate_callback, "s"}, {MAIL_MAIN_WINDOW_ACTION_FORWARD, _mail_main_window_action_compose_gsimple_action_activate_callback, "s"}, {MAIL_MAIN_WINDOW_ACTION_PRINT, _mail_main_window_on_print_gsimple_action_activate_callback, "s"}, {MAIL_MAIN_WINDOW_ACTION_MODIFY, NULL}, {MAIL_MAIN_WINDOW_ACTION_MARK_READ, _mail_main_window_on_mark_read_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_MARK_STAR, _mail_main_window_on_mark_star_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD, _mail_main_window_on_mark_unread_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR, _mail_main_window_on_mark_unstar_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_ARCHIVE, _mail_main_window_action_move_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_MOVE, _mail_main_window_action_move_gsimple_action_activate_callback, "s"}, {MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH, _mail_main_window_action_move_gsimple_action_activate_callback}, {MAIL_MAIN_WINDOW_ACTION_FULLSCREEN, _mail_main_window_on_fullscreen_gsimple_action_activate_callback}};

static inline gpointer
mail_main_window_get_instance_private (MailMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MailMainWindow_private_offset);
}

static void
_mail_main_window_action_compose_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	mail_main_window_action_compose ((MailMainWindow*) self, action, parameter);
}

static void
_mail_main_window_on_refresh_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	mail_main_window_on_refresh ((MailMainWindow*) self);
}

static void
_mail_main_window_on_print_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	mail_main_window_on_print ((MailMainWindow*) self, action, parameter);
}

static void
_mail_main_window_on_mark_read_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	mail_main_window_on_mark_read ((MailMainWindow*) self);
}

static void
_mail_main_window_on_mark_star_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	mail_main_window_on_mark_star ((MailMainWindow*) self);
}

static void
_mail_main_window_on_mark_unread_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	mail_main_window_on_mark_unread ((MailMainWindow*) self);
}

static void
_mail_main_window_on_mark_unstar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	mail_main_window_on_mark_unstar ((MailMainWindow*) self);
}

static void
_mail_main_window_action_move_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	mail_main_window_action_move ((MailMainWindow*) self, action, parameter);
}

static void
_mail_main_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	mail_main_window_on_fullscreen ((MailMainWindow*) self);
}

MailMainWindow*
mail_main_window_construct (GType object_type,
                            GtkApplication* application)
{
	MailMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (MailMainWindow*) g_object_new (object_type, "application", application, "height-request", 600, "icon-name", "io.elementary.mail", "width-request", 800, "title", _ ("Mail"), NULL);
	return self;
}

MailMainWindow*
mail_main_window_new (GtkApplication* application)
{
	return mail_main_window_construct (MAIL_TYPE_MAIN_WINDOW, application);
}

static void
mail_main_window_on_refresh (MailMainWindow* self)
{
	MailConversationList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conversation_list;
	mail_conversation_list_refresh_folder (_tmp0_, NULL, NULL, NULL);
}

static void
mail_main_window_on_mark_read (MailMainWindow* self)
{
	MailConversationList* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conversation_list;
	mail_conversation_list_mark_read_selected_messages (_tmp0_);
	_tmp1_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_READ);
	_tmp2_ = _tmp1_;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
	_tmp4_ = _tmp3_;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_g_object_unref0 (_tmp4_);
}

static void
mail_main_window_on_mark_star (MailMainWindow* self)
{
	MailConversationList* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conversation_list;
	mail_conversation_list_mark_star_selected_messages (_tmp0_);
	_tmp1_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
	_tmp2_ = _tmp1_;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
	_tmp4_ = _tmp3_;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_g_object_unref0 (_tmp4_);
}

static void
mail_main_window_on_mark_unread (MailMainWindow* self)
{
	MailConversationList* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conversation_list;
	mail_conversation_list_mark_unread_selected_messages (_tmp0_);
	_tmp1_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
	_tmp2_ = _tmp1_;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_READ);
	_tmp4_ = _tmp3_;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_g_object_unref0 (_tmp4_);
}

static void
mail_main_window_on_mark_unstar (MailMainWindow* self)
{
	MailConversationList* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->conversation_list;
	mail_conversation_list_mark_unstar_selected_messages (_tmp0_);
	_tmp1_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
	_tmp2_ = _tmp1_;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
	_tmp4_ = _tmp3_;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_g_object_unref0 (_tmp4_);
}

static void
mail_main_window_action_compose (MailMainWindow* self,
                                 GSimpleAction* action,
                                 GVariant* parameter)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_name ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE)))) {
		switch (0) {
			default:
			{
				MailComposer* _tmp5_;
				MailComposer* _tmp6_;
				_tmp5_ = mail_composer_new (NULL, NULL);
				g_object_ref_sink (_tmp5_);
				_tmp6_ = _tmp5_;
				gtk_window_present ((GtkWindow*) _tmp6_);
				_g_object_unref0 (_tmp6_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_REPLY)))) {
		switch (0) {
			default:
			{
				MailMessageList* _tmp7_;
				_tmp7_ = self->priv->message_list;
				mail_message_list_compose (_tmp7_, MAIL_COMPOSER_TYPE_REPLY, parameter, NULL, NULL);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_REPLY_ALL)))) {
		switch (0) {
			default:
			{
				MailMessageList* _tmp8_;
				_tmp8_ = self->priv->message_list;
				mail_message_list_compose (_tmp8_, MAIL_COMPOSER_TYPE_REPLY_ALL, parameter, NULL, NULL);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_FORWARD)))) {
		switch (0) {
			default:
			{
				MailMessageList* _tmp9_;
				_tmp9_ = self->priv->message_list;
				mail_message_list_compose (_tmp9_, MAIL_COMPOSER_TYPE_FORWARD, parameter, NULL, NULL);
				break;
			}
		}
	}
}

static void
mail_main_window_on_print (MailMainWindow* self,
                           GSimpleAction* action,
                           GVariant* parameter)
{
	MailMessageList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->message_list;
	mail_message_list_print (_tmp0_, parameter);
}

static void
___lambda124_ (MailMainWindow* self,
               GObject* obj,
               GAsyncResult* res)
{
	gchar* error_message = NULL;
	guint _result_ = 0U;
	MailConversationList* _tmp0_;
	gchar* _tmp1_ = NULL;
	guint _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->conversation_list;
	_tmp2_ = mail_conversation_list_move_selected_messages_finish (_tmp0_, res, &_tmp1_);
	_g_free0 (error_message);
	error_message = _tmp1_;
	_result_ = _tmp2_;
	if (_result_ > ((guint) 0)) {
		GraniteWidgetsToast* _tmp3_;
		GraniteWidgetsToast* _tmp4_;
		_tmp3_ = self->priv->move_toast;
		granite_widgets_toast_set_title (_tmp3_, ngettext ("Message Archived", "Messages Archived", (gulong) _result_));
		_tmp4_ = self->priv->move_toast;
		granite_widgets_toast_send_notification (_tmp4_);
	} else {
		const gchar* _tmp5_;
		_tmp5_ = error_message;
		if (g_strcmp0 (_tmp5_, "") != 0) {
			const gchar* _tmp6_;
			_tmp6_ = error_message;
			mail_main_window_send_error_message (_ ("Couldn't archive message"), _tmp6_, "mail-archive", NULL);
		}
	}
	_g_free0 (error_message);
}

static void
____lambda124__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda124_ ((MailMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda125_ (MailMainWindow* self,
               GObject* obj,
               GAsyncResult* res)
{
	gchar* error_message = NULL;
	guint _result_ = 0U;
	MailConversationList* _tmp0_;
	gchar* _tmp1_ = NULL;
	guint _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->conversation_list;
	_tmp2_ = mail_conversation_list_move_selected_messages_finish (_tmp0_, res, &_tmp1_);
	_g_free0 (error_message);
	error_message = _tmp1_;
	_result_ = _tmp2_;
	if (_result_ > ((guint) 0)) {
		GraniteWidgetsToast* _tmp3_;
		GraniteWidgetsToast* _tmp4_;
		_tmp3_ = self->priv->move_toast;
		granite_widgets_toast_set_title (_tmp3_, ngettext ("Message Moved", "Messages Moved", (gulong) _result_));
		_tmp4_ = self->priv->move_toast;
		granite_widgets_toast_send_notification (_tmp4_);
	} else {
		const gchar* _tmp5_;
		_tmp5_ = error_message;
		if (g_strcmp0 (_tmp5_, "") != 0) {
			const gchar* _tmp6_;
			_tmp6_ = error_message;
			mail_main_window_send_error_message (_ ("Couldn't move message"), _tmp6_, "mail-move", NULL);
		}
	}
	_g_free0 (error_message);
}

static void
____lambda125__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda125_ ((MailMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda126_ (MailMainWindow* self,
               GObject* obj,
               GAsyncResult* res)
{
	gchar* error_message = NULL;
	guint _result_ = 0U;
	MailConversationList* _tmp0_;
	gchar* _tmp1_ = NULL;
	guint _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->conversation_list;
	_tmp2_ = mail_conversation_list_move_selected_messages_finish (_tmp0_, res, &_tmp1_);
	_g_free0 (error_message);
	error_message = _tmp1_;
	_result_ = _tmp2_;
	if (_result_ > ((guint) 0)) {
		GraniteWidgetsToast* _tmp3_;
		GraniteWidgetsToast* _tmp4_;
		_tmp3_ = self->priv->move_toast;
		granite_widgets_toast_set_title (_tmp3_, ngettext ("Message Deleted", "Messages Deleted", (gulong) _result_));
		_tmp4_ = self->priv->move_toast;
		granite_widgets_toast_send_notification (_tmp4_);
	} else {
		const gchar* _tmp5_;
		_tmp5_ = error_message;
		if (g_strcmp0 (_tmp5_, "") != 0) {
			const gchar* _tmp6_;
			_tmp6_ = error_message;
			mail_main_window_send_error_message (_ ("Couldn't delete message"), _tmp6_, "edit-delete", NULL);
		}
	}
	_g_free0 (error_message);
}

static void
____lambda126__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda126_ ((MailMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
mail_main_window_action_move (MailMainWindow* self,
                              GSimpleAction* action,
                              GVariant* parameter)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_name ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_ARCHIVE)))) {
		switch (0) {
			default:
			{
				MailConversationList* _tmp5_;
				_tmp5_ = self->priv->conversation_list;
				mail_conversation_list_move_selected_messages (_tmp5_, MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE, NULL, ____lambda124__gasync_ready_callback, g_object_ref (self));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_MOVE)))) {
		switch (0) {
			default:
			{
				MailConversationList* _tmp6_;
				_tmp6_ = self->priv->conversation_list;
				mail_conversation_list_move_selected_messages (_tmp6_, MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE, parameter, ____lambda125__gasync_ready_callback, g_object_ref (self));
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string (MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH)))) {
		switch (0) {
			default:
			{
				MailConversationList* _tmp7_;
				_tmp7_ = self->priv->conversation_list;
				mail_conversation_list_move_selected_messages (_tmp7_, MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH, NULL, ____lambda126__gasync_ready_callback, g_object_ref (self));
				break;
			}
		}
	}
}

static void
mail_main_window_on_fullscreen (MailMainWindow* self)
{
	GdkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	if ((gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN) {
		MailMessageList* _tmp1_;
		HdyHeaderBar* _tmp2_;
		HdyHeaderBar* _tmp3_;
		_tmp1_ = self->priv->message_list;
		_tmp2_ = mail_message_list_get_headerbar (_tmp1_);
		_tmp3_ = _tmp2_;
		hdy_header_bar_set_show_close_button (_tmp3_, TRUE);
		gtk_window_unfullscreen ((GtkWindow*) self);
	} else {
		MailMessageList* _tmp4_;
		HdyHeaderBar* _tmp5_;
		HdyHeaderBar* _tmp6_;
		_tmp4_ = self->priv->message_list;
		_tmp5_ = mail_message_list_get_headerbar (_tmp4_);
		_tmp6_ = _tmp5_;
		hdy_header_bar_set_show_close_button (_tmp6_, FALSE);
		gtk_window_fullscreen ((GtkWindow*) self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GSimpleAction*
mail_main_window_get_action (MailMainWindow* self,
                             const gchar* name)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

void
mail_main_window_send_error_message (const gchar* title,
                                     const gchar* description,
                                     const gchar* icon_name,
                                     const gchar* error_details)
{
	GraniteMessageDialog* dialog = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GApplication* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	GraniteMessageDialog* _tmp6_ = NULL;
	GraniteMessageDialog* _tmp7_;
	GraniteMessageDialog* _tmp15_;
	GraniteMessageDialog* _tmp16_;
	GraniteMessageDialog* _tmp17_;
	g_return_if_fail (title != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_get_default ();
	_tmp3_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_application_get_type (), GtkApplication));
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = granite_message_dialog_new (title, description, (GIcon*) _tmp1_, GTK_BUTTONS_CLOSE);
	gtk_window_set_modal ((GtkWindow*) _tmp6_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp1_);
	dialog = _tmp7_;
	if (icon_name != NULL) {
		GraniteMessageDialog* _tmp8_;
		GThemedIcon* _tmp9_;
		GThemedIcon* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GThemedIcon* _tmp12_;
		GThemedIcon* _tmp13_;
		_tmp8_ = dialog;
		_tmp9_ = (GThemedIcon*) g_themed_icon_new (icon_name);
		_tmp10_ = _tmp9_;
		granite_message_dialog_set_image_icon (_tmp8_, (GIcon*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_tmp11_ = dialog;
		_tmp12_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp13_ = _tmp12_;
		granite_message_dialog_set_badge_icon (_tmp11_, (GIcon*) _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	if (error_details != NULL) {
		GraniteMessageDialog* _tmp14_;
		_tmp14_ = dialog;
		granite_message_dialog_show_error_details (_tmp14_, error_details);
	}
	_tmp15_ = dialog;
	gtk_window_present ((GtkWindow*) _tmp15_);
	_tmp16_ = dialog;
	_tmp17_ = dialog;
	g_signal_connect_object ((GtkDialog*) _tmp16_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp17_, 0);
	_g_object_unref0 (dialog);
}

static gboolean
__lambda127_ (MailMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self->priv->configure_id = (guint) 0;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = mail_application_settings;
		g_settings_set_boolean (_tmp2_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp3_;
		GdkRectangle rect = {0};
		GtkAllocation _tmp4_ = {0};
		GSettings* _tmp5_;
		GdkRectangle _tmp6_;
		GdkRectangle _tmp7_;
		_tmp3_ = mail_application_settings;
		g_settings_set_boolean (_tmp3_, "window-maximized", FALSE);
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
		rect = _tmp4_;
		_tmp5_ = mail_application_settings;
		_tmp6_ = rect;
		_tmp7_ = rect;
		g_settings_set (_tmp5_, "window-size", "(ii)", _tmp6_.width, _tmp7_.height);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda127__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda127_ ((MailMainWindow*) self);
	return result;
}

static gboolean
mail_main_window_real_configure_event (GtkWidget* base,
                                       GdkEventConfigure* event)
{
	MailMainWindow * self;
	gboolean result;
	self = (MailMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda127__gsource_func, g_object_ref (self), g_object_unref);
	result = GTK_WIDGET_CLASS (mail_main_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

gboolean
mail_main_window_get_is_session_started (MailMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_session_started;
	return result;
}

static void
mail_main_window_set_is_session_started (MailMainWindow* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_main_window_get_is_session_started (self);
	if (old_value != value) {
		self->priv->_is_session_started = value;
		g_object_notify_by_pspec ((GObject *) self, mail_main_window_properties[MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY]);
	}
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		MailMainWindow* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->placeholder_stack);
		_g_object_unref0 (_data19_->welcome_view);
		_g_object_unref0 (_data19_->message_overlay);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
_mail_main_window___lambda128_ (MailMainWindow* self)
{
	mail_move_operation_undo_last_move ();
}

static void
__mail_main_window___lambda128__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                      gpointer self)
{
	_mail_main_window___lambda128_ ((MailMainWindow*) self);
}

static void
_mail_main_window___lambda129_ (Block19Data* _data19_,
                                const gchar* label,
                                const gchar* url)
{
	MailMainWindow* self;
	gchar* _tmp0_ = NULL;
	gchar* hover_url = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data19_->self;
	if (url != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_uri_unescape_string (url, NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp2_ = g_strdup (_tmp0_);
	hover_url = _tmp2_;
	_tmp3_ = hover_url;
	if (_tmp3_ == NULL) {
		GraniteWidgetsOverlayBar* _tmp4_;
		_tmp4_ = _data19_->message_overlay;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		GraniteWidgetsOverlayBar* _tmp5_;
		const gchar* _tmp6_;
		GraniteWidgetsOverlayBar* _tmp7_;
		_tmp5_ = _data19_->message_overlay;
		_tmp6_ = hover_url;
		granite_widgets_overlay_bar_set_label (_tmp5_, _tmp6_);
		_tmp7_ = _data19_->message_overlay;
		gtk_widget_show ((GtkWidget*) _tmp7_);
	}
	_g_free0 (hover_url);
	_g_free0 (_tmp0_);
}

static void
__mail_main_window___lambda129__mail_message_list_hovering_over_link (MailMessageList* _sender,
                                                                      const gchar* label,
                                                                      const gchar* uri,
                                                                      gpointer self)
{
	_mail_main_window___lambda129_ (self, label, uri);
}

static void
_mail_conversation_list_load_folder_mail_folders_list_view_folder_selected (MailFoldersListView* _sender,
                                                                            GeeMap* folder_info_per_account,
                                                                            gpointer self)
{
	mail_conversation_list_load_folder ((MailConversationList*) self, folder_info_per_account, NULL, NULL);
}

static void
_mail_message_list_set_conversation_mail_conversation_list_conversation_selected (MailConversationList* _sender,
                                                                                  CamelFolderThreadNode* node,
                                                                                  gpointer self)
{
	mail_message_list_set_conversation ((MailMessageList*) self, node);
}

static void
_mail_main_window___lambda131_ (Block19Data* _data19_)
{
	MailMainWindow* self;
	GeeLinkedList* accounts_left = NULL;
	MailBackendSession* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = _data19_->self;
	_tmp0_ = _data19_->session;
	_tmp1_ = mail_backend_session_get_accounts (_tmp0_);
	accounts_left = _tmp1_;
	_tmp2_ = accounts_left;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
		_tmp5_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE);
		_tmp6_ = _tmp5_;
		g_simple_action_set_enabled (_tmp6_, FALSE);
		_g_object_unref0 (_tmp6_);
	}
	_g_object_unref0 (accounts_left);
}

static void
__mail_main_window___lambda131__mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                      MailBackendAccount* account,
                                                                      gpointer self)
{
	_mail_main_window___lambda131_ (self);
}

static void
_mail_main_window___lambda132_ (Block19Data* _data19_)
{
	MailMainWindow* self;
	GtkStack* _tmp0_;
	GtkPaned* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	self = _data19_->self;
	_tmp0_ = _data19_->placeholder_stack;
	_tmp1_ = self->priv->paned_end;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE);
	_tmp3_ = _tmp2_;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	_g_object_unref0 (_tmp3_);
}

static void
__mail_main_window___lambda132__mail_backend_session_account_added (MailBackendSession* _sender,
                                                                    MailBackendAccount* account,
                                                                    gpointer self)
{
	_mail_main_window___lambda132_ (self);
}

static void
_mail_main_window___lambda133_ (Block19Data* _data19_,
                                GObject* obj,
                                GAsyncResult* res)
{
	MailMainWindow* self;
	MailBackendSession* _tmp0_;
	MailBackendSession* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	self = _data19_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data19_->session;
	mail_backend_session_start_finish (_tmp0_, res);
	_tmp1_ = _data19_->session;
	_tmp2_ = mail_backend_session_get_accounts (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ > 0;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		GtkStack* _tmp7_;
		GtkPaned* _tmp8_;
		GSimpleAction* _tmp9_;
		GSimpleAction* _tmp10_;
		_tmp7_ = _data19_->placeholder_stack;
		_tmp8_ = self->priv->paned_end;
		gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
		_tmp9_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE);
		_tmp10_ = _tmp9_;
		g_simple_action_set_enabled (_tmp10_, TRUE);
		_g_object_unref0 (_tmp10_);
	} else {
		GtkStack* _tmp11_;
		MailWelcomeView* _tmp12_;
		GtkStack* _tmp13_;
		_tmp11_ = _data19_->placeholder_stack;
		_tmp12_ = _data19_->welcome_view;
		gtk_stack_set_visible_child (_tmp11_, (GtkWidget*) _tmp12_);
		_tmp13_ = _data19_->placeholder_stack;
		gtk_stack_set_transition_type (_tmp13_, GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP);
	}
	mail_main_window_set_is_session_started (self, TRUE);
	g_signal_emit (self, mail_main_window_signals[MAIL_MAIN_WINDOW_SESSION_STARTED_SIGNAL], 0);
}

static void
__mail_main_window___lambda133__gasync_ready_callback (GObject* source_object,
                                                       GAsyncResult* res,
                                                       gpointer self)
{
	_mail_main_window___lambda133_ (self, source_object, res);
	block19_data_unref (self);
}

static void
__lambda135_ (MailMainWindow* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda135__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda135_ ((MailMainWindow*) self);
	g_object_unref (self);
}

static gboolean
_mail_main_window___lambda134_ (MailMainWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	mail_application_request_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAIL_TYPE_APPLICATION, MailApplication), ___lambda135__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__mail_main_window___lambda134__gtk_widget_delete_event (GtkWidget* _sender,
                                                         GdkEventAny* event,
                                                         gpointer self)
{
	gboolean result;
	result = _mail_main_window___lambda134_ ((MailMainWindow*) self);
	return result;
}

static void
_mail_main_window___lambda136_ (Block19Data* _data19_)
{
	MailMainWindow* self;
	MailBackendSession* _tmp0_;
	MailBackendSession* _tmp1_;
	self = _data19_->self;
	_tmp0_ = _data19_->session;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data19_->account_removed_handler);
	_tmp1_ = _data19_->session;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data19_->account_added_handler);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__mail_main_window___lambda136__gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self)
{
	_mail_main_window___lambda136_ (self);
}

static GObject *
mail_main_window_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailMainWindow * self;
	Block19Data* _data19_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	MailFoldersListView* _tmp21_;
	MailConversationList* _tmp22_;
	MailMessageList* _tmp23_;
	GtkOverlay* view_overlay = NULL;
	MailMessageList* _tmp24_;
	GtkWidget* _tmp25_;
	GtkOverlay* _tmp26_ = NULL;
	GraniteWidgetsToast* _tmp27_;
	GraniteWidgetsToast* _tmp28_;
	GraniteWidgetsToast* _tmp29_;
	GtkOverlay* _tmp30_;
	GraniteWidgetsToast* _tmp31_;
	GraniteWidgetsToast* _tmp32_;
	GraniteWidgetsToast* _tmp33_;
	GraniteWidgetsToast* _tmp34_;
	GtkOverlay* _tmp35_;
	GraniteWidgetsToast* _tmp36_;
	GtkOverlay* _tmp37_;
	GraniteWidgetsOverlayBar* _tmp38_;
	GraniteWidgetsOverlayBar* _tmp39_;
	MailMessageList* _tmp40_;
	GtkPaned* _tmp41_;
	GtkPaned* _tmp42_;
	MailFoldersListView* _tmp43_;
	GtkPaned* _tmp44_;
	MailConversationList* _tmp45_;
	GtkPaned* _tmp46_;
	GtkPaned* _tmp47_;
	GtkPaned* _tmp48_;
	GtkPaned* _tmp49_;
	GtkOverlay* _tmp50_;
	MailWelcomeView* _tmp51_;
	GtkStack* _tmp52_;
	GtkStack* _tmp53_;
	GtkPaned* _tmp54_;
	GtkStack* _tmp55_;
	MailWelcomeView* _tmp56_;
	GtkStack* _tmp57_;
	HdyHeaderGroup* header_group = NULL;
	HdyHeaderGroup* _tmp58_;
	HdyHeaderGroup* _tmp59_;
	MailFoldersListView* _tmp60_;
	HdyHeaderBar* _tmp61_;
	HdyHeaderBar* _tmp62_;
	HdyHeaderGroup* _tmp63_;
	MailConversationList* _tmp64_;
	HdyHeaderBar* _tmp65_;
	HdyHeaderBar* _tmp66_;
	HdyHeaderGroup* _tmp67_;
	MailMessageList* _tmp68_;
	HdyHeaderBar* _tmp69_;
	HdyHeaderBar* _tmp70_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp71_;
	GtkSizeGroup* _tmp72_;
	MailFoldersListView* _tmp73_;
	HdyHeaderBar* _tmp74_;
	HdyHeaderBar* _tmp75_;
	GtkSizeGroup* _tmp76_;
	MailConversationList* _tmp77_;
	HdyHeaderBar* _tmp78_;
	HdyHeaderBar* _tmp79_;
	GtkSizeGroup* _tmp80_;
	MailMessageList* _tmp81_;
	HdyHeaderBar* _tmp82_;
	HdyHeaderBar* _tmp83_;
	GSettings* settings = NULL;
	GSettings* _tmp84_;
	GSettings* _tmp85_;
	GtkPaned* _tmp86_;
	GSettings* _tmp87_;
	GtkPaned* _tmp88_;
	MailFoldersListView* _tmp89_;
	MailConversationList* _tmp90_;
	MailConversationList* _tmp91_;
	MailMessageList* _tmp92_;
	MailBackendSession* _tmp93_;
	MailBackendSession* _tmp94_;
	gulong _tmp95_;
	MailBackendSession* _tmp96_;
	gulong _tmp97_;
	MailBackendSession* _tmp98_;
	parent_class = G_OBJECT_CLASS (mail_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MAIN_WINDOW, MailMainWindow);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, MAIL_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MAIL_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = mail_main_window_get_action (self, MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE);
	_tmp1_ = _tmp0_;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp2_ = mail_main_window_action_accelerators;
		_tmp3_ = gee_multi_map_get_keys (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_action_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* action = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GApplication* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GeeMultiMap* _tmp14_;
			const gchar* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gint _tmp18_ = 0;
			gpointer* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp7_ = _action_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _action_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			action = (gchar*) _tmp9_;
			_tmp10_ = g_application_get_default ();
			_tmp11_ = action;
			_tmp12_ = g_strconcat (MAIL_MAIN_WINDOW_ACTION_PREFIX, _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = mail_main_window_action_accelerators;
			_tmp15_ = action;
			_tmp16_ = gee_multi_map_get (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = gee_collection_to_array (_tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _tmp18_;
			gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_application_get_type (), GtkApplication), _tmp13_, _tmp20_);
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp21_ = mail_folders_list_view_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->folders_list_view);
	self->priv->folders_list_view = _tmp21_;
	_tmp22_ = mail_conversation_list_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->conversation_list);
	self->priv->conversation_list = _tmp22_;
	_tmp23_ = mail_message_list_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->message_list);
	self->priv->message_list = _tmp23_;
	_tmp24_ = self->priv->message_list;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	_tmp26_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp26_, TRUE);
	g_object_set ((GtkContainer*) _tmp26_, "child", _tmp25_, NULL);
	_g_object_unref0 (_tmp25_);
	g_object_ref_sink (_tmp26_);
	view_overlay = _tmp26_;
	_tmp27_ = granite_widgets_toast_new ("");
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->move_toast);
	self->priv->move_toast = _tmp27_;
	_tmp28_ = self->priv->move_toast;
	granite_widgets_toast_set_default_action (_tmp28_, _ ("Undo"));
	_tmp29_ = self->priv->move_toast;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_tmp30_ = view_overlay;
	_tmp31_ = self->priv->move_toast;
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->move_toast;
	g_signal_connect_object (_tmp32_, "default-action", (GCallback) __mail_main_window___lambda128__granite_widgets_toast_default_action, self, 0);
	_tmp33_ = granite_widgets_toast_new ("");
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->error_toast);
	self->priv->error_toast = _tmp33_;
	_tmp34_ = self->priv->error_toast;
	gtk_widget_show_all ((GtkWidget*) _tmp34_);
	_tmp35_ = view_overlay;
	_tmp36_ = self->priv->error_toast;
	gtk_overlay_add_overlay (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = view_overlay;
	_tmp38_ = granite_widgets_overlay_bar_new (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_data19_->message_overlay = _tmp38_;
	_tmp39_ = _data19_->message_overlay;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp39_, TRUE);
	_tmp40_ = self->priv->message_list;
	g_signal_connect_data (_tmp40_, "hovering-over-link", (GCallback) __mail_main_window___lambda129__mail_message_list_hovering_over_link, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp41_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->paned_start);
	self->priv->paned_start = _tmp41_;
	_tmp42_ = self->priv->paned_start;
	_tmp43_ = self->priv->folders_list_view;
	gtk_paned_pack1 (_tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE);
	_tmp44_ = self->priv->paned_start;
	_tmp45_ = self->priv->conversation_list;
	gtk_paned_pack2 (_tmp44_, (GtkWidget*) _tmp45_, TRUE, FALSE);
	_tmp46_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->paned_end);
	self->priv->paned_end = _tmp46_;
	_tmp47_ = self->priv->paned_end;
	_tmp48_ = self->priv->paned_start;
	gtk_paned_pack1 (_tmp47_, (GtkWidget*) _tmp48_, FALSE, FALSE);
	_tmp49_ = self->priv->paned_end;
	_tmp50_ = view_overlay;
	gtk_paned_pack2 (_tmp49_, (GtkWidget*) _tmp50_, TRUE, FALSE);
	_tmp51_ = mail_welcome_view_new ();
	g_object_ref_sink (_tmp51_);
	_data19_->welcome_view = _tmp51_;
	_tmp52_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp52_);
	_data19_->placeholder_stack = _tmp52_;
	_tmp53_ = _data19_->placeholder_stack;
	_tmp54_ = self->priv->paned_end;
	gtk_stack_add_named (_tmp53_, (GtkWidget*) _tmp54_, "mail");
	_tmp55_ = _data19_->placeholder_stack;
	_tmp56_ = _data19_->welcome_view;
	gtk_stack_add_named (_tmp55_, (GtkWidget*) _tmp56_, "welcome");
	_tmp57_ = _data19_->placeholder_stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp57_);
	_tmp58_ = hdy_header_group_new ();
	header_group = _tmp58_;
	_tmp59_ = header_group;
	_tmp60_ = self->priv->folders_list_view;
	_tmp61_ = mail_folders_list_view_get_header_bar (_tmp60_);
	_tmp62_ = _tmp61_;
	hdy_header_group_add_header_bar (_tmp59_, _tmp62_);
	_tmp63_ = header_group;
	_tmp64_ = self->priv->conversation_list;
	_tmp65_ = mail_conversation_list_get_search_header (_tmp64_);
	_tmp66_ = _tmp65_;
	hdy_header_group_add_header_bar (_tmp63_, _tmp66_);
	_tmp67_ = header_group;
	_tmp68_ = self->priv->message_list;
	_tmp69_ = mail_message_list_get_headerbar (_tmp68_);
	_tmp70_ = _tmp69_;
	hdy_header_group_add_header_bar (_tmp67_, _tmp70_);
	_tmp71_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	size_group = _tmp71_;
	_tmp72_ = size_group;
	_tmp73_ = self->priv->folders_list_view;
	_tmp74_ = mail_folders_list_view_get_header_bar (_tmp73_);
	_tmp75_ = _tmp74_;
	gtk_size_group_add_widget (_tmp72_, (GtkWidget*) _tmp75_);
	_tmp76_ = size_group;
	_tmp77_ = self->priv->conversation_list;
	_tmp78_ = mail_conversation_list_get_search_header (_tmp77_);
	_tmp79_ = _tmp78_;
	gtk_size_group_add_widget (_tmp76_, (GtkWidget*) _tmp79_);
	_tmp80_ = size_group;
	_tmp81_ = self->priv->message_list;
	_tmp82_ = mail_message_list_get_headerbar (_tmp81_);
	_tmp83_ = _tmp82_;
	gtk_size_group_add_widget (_tmp80_, (GtkWidget*) _tmp83_);
	_tmp84_ = g_settings_new ("io.elementary.mail");
	settings = _tmp84_;
	_tmp85_ = settings;
	_tmp86_ = self->priv->paned_start;
	g_settings_bind (_tmp85_, "paned-start-position", (GObject*) _tmp86_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp87_ = settings;
	_tmp88_ = self->priv->paned_end;
	g_settings_bind (_tmp87_, "paned-end-position", (GObject*) _tmp88_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp89_ = self->priv->folders_list_view;
	_tmp90_ = self->priv->conversation_list;
	g_signal_connect_object (_tmp89_, "folder-selected", (GCallback) _mail_conversation_list_load_folder_mail_folders_list_view_folder_selected, _tmp90_, 0);
	_tmp91_ = self->priv->conversation_list;
	_tmp92_ = self->priv->message_list;
	g_signal_connect_object (_tmp91_, "conversation-selected", (GCallback) _mail_message_list_set_conversation_mail_conversation_list_conversation_selected, _tmp92_, 0);
	_tmp93_ = mail_backend_session_get_default ();
	_data19_->session = _tmp93_;
	_tmp94_ = _data19_->session;
	_tmp95_ = g_signal_connect_data (_tmp94_, "account-removed", (GCallback) __mail_main_window___lambda131__mail_backend_session_account_removed, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_data19_->account_removed_handler = _tmp95_;
	_tmp96_ = _data19_->session;
	_tmp97_ = g_signal_connect_data (_tmp96_, "account-added", (GCallback) __mail_main_window___lambda132__mail_backend_session_account_added, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_data19_->account_added_handler = _tmp97_;
	_tmp98_ = _data19_->session;
	mail_backend_session_start (_tmp98_, __mail_main_window___lambda133__gasync_ready_callback, block19_data_ref (_data19_));
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __mail_main_window___lambda134__gtk_widget_delete_event, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __mail_main_window___lambda136__gtk_widget_destroy, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (size_group);
	_g_object_unref0 (header_group);
	_g_object_unref0 (view_overlay);
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return obj;
}

static void
mail_main_window_class_init (MailMainWindowClass * klass,
                             gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _tmp6_;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	GeeMultiMap* _tmp9_;
	GeeMultiMap* _tmp10_;
	GeeMultiMap* _tmp11_;
	GeeMultiMap* _tmp12_;
	GeeMultiMap* _tmp13_;
	mail_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMainWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) mail_main_window_real_configure_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY, mail_main_window_properties[MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY] = g_param_spec_boolean ("is-session-started", "is-session-started", "is-session-started", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_main_window_signals[MAIL_MAIN_WINDOW_SESSION_STARTED_SIGNAL] = g_signal_new ("session-started", MAIL_TYPE_MAIN_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	mail_main_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp1_, MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE, "<Control>N");
	_tmp2_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp2_, MAIL_MAIN_WINDOW_ACTION_REFRESH, "F12");
	_tmp3_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp3_, MAIL_MAIN_WINDOW_ACTION_REPLY "::", "<Control>R");
	_tmp4_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp4_, MAIL_MAIN_WINDOW_ACTION_REPLY_ALL "::", "<Control><Shift>R");
	_tmp5_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp5_, MAIL_MAIN_WINDOW_ACTION_FORWARD "::", "<Ctrl><Shift>F");
	_tmp6_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp6_, MAIL_MAIN_WINDOW_ACTION_MARK_READ, "<Ctrl><Shift>i");
	_tmp7_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp7_, MAIL_MAIN_WINDOW_ACTION_MARK_STAR, "<Ctrl>l");
	_tmp8_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp8_, MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD, "<Ctrl><Shift>u");
	_tmp9_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp9_, MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR, "<Ctrl><Shift>l");
	_tmp10_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp10_, MAIL_MAIN_WINDOW_ACTION_ARCHIVE, "<Ctrl><Shift>a");
	_tmp11_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp11_, MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH, "Delete");
	_tmp12_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp12_, MAIL_MAIN_WINDOW_ACTION_MOVE_TO_TRASH, "BackSpace");
	_tmp13_ = mail_main_window_action_accelerators;
	gee_multi_map_set (_tmp13_, MAIL_MAIN_WINDOW_ACTION_FULLSCREEN, "F11");
}

static void
mail_main_window_instance_init (MailMainWindow * self,
                                gpointer klass)
{
	self->priv = mail_main_window_get_instance_private (self);
	self->priv->_is_session_started = FALSE;
}

static void
mail_main_window_finalize (GObject * obj)
{
	MailMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MAIN_WINDOW, MailMainWindow);
	_g_object_unref0 (self->priv->paned_end);
	_g_object_unref0 (self->priv->paned_start);
	_g_object_unref0 (self->priv->folders_list_view);
	_g_object_unref0 (self->priv->move_toast);
	_g_object_unref0 (self->priv->error_toast);
	_g_object_unref0 (self->priv->conversation_list);
	_g_object_unref0 (self->priv->message_list);
	G_OBJECT_CLASS (mail_main_window_parent_class)->finalize (obj);
}

static GType
mail_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMainWindow), 0, (GInstanceInitFunc) mail_main_window_instance_init, NULL };
	GType mail_main_window_type_id;
	mail_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "MailMainWindow", &g_define_type_info, 0);
	MailMainWindow_private_offset = g_type_add_instance_private (mail_main_window_type_id, sizeof (MailMainWindowPrivate));
	return mail_main_window_type_id;
}

GType
mail_main_window_get_type (void)
{
	static volatile gsize mail_main_window_type_id__once = 0;
	if (g_once_init_enter (&mail_main_window_type_id__once)) {
		GType mail_main_window_type_id;
		mail_main_window_type_id = mail_main_window_get_type_once ();
		g_once_init_leave (&mail_main_window_type_id__once, mail_main_window_type_id);
	}
	return mail_main_window_type_id__once;
}

static void
_vala_mail_main_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	MailMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MAIN_WINDOW, MailMainWindow);
	switch (property_id) {
		case MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY:
		g_value_set_boolean (value, mail_main_window_get_is_session_started (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_main_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	MailMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_MAIN_WINDOW, MailMainWindow);
	switch (property_id) {
		case MAIL_MAIN_WINDOW_IS_SESSION_STARTED_PROPERTY:
		mail_main_window_set_is_session_started (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

