/* FolderSourceItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FolderSourceItem.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <camel/camel.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_SOURCE_LIST_TYPE_ITEM (mail_source_list_item_get_type ())
#define MAIL_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItem))
#define MAIL_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))
#define MAIL_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))

typedef struct _MailSourceListItem MailSourceListItem;
typedef struct _MailSourceListItemClass MailSourceListItemClass;
typedef struct _MailSourceListItemPrivate MailSourceListItemPrivate;

#define MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM (mail_source_list_expandable_item_get_type ())
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItem))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))

typedef struct _MailSourceListExpandableItem MailSourceListExpandableItem;
typedef struct _MailSourceListExpandableItemClass MailSourceListExpandableItemClass;
typedef struct _MailSourceListExpandableItemPrivate MailSourceListExpandableItemPrivate;

#define MAIL_TYPE_FOLDER_SOURCE_ITEM (mail_folder_source_item_get_type ())
#define MAIL_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem))
#define MAIL_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))
#define MAIL_IS_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_IS_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_FOLDER_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))

typedef struct _MailFolderSourceItem MailFolderSourceItem;
typedef struct _MailFolderSourceItemClass MailFolderSourceItemClass;
typedef struct _MailFolderSourceItemPrivate MailFolderSourceItemPrivate;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;
enum  {
	MAIL_FOLDER_SOURCE_ITEM_0_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY,
	MAIL_FOLDER_SOURCE_ITEM_NUM_PROPERTIES
};
static GParamSpec* mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_NUM_PROPERTIES];
#define __vala_CamelFolderInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelFolderInfo_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailFolderSourceItemRefreshData MailFolderSourceItemRefreshData;
typedef struct _MailFolderSourceItemRenameData MailFolderSourceItemRenameData;
enum  {
	MAIL_FOLDER_SOURCE_ITEM_START_EDIT_SIGNAL,
	MAIL_FOLDER_SOURCE_ITEM_NUM_SIGNALS
};
static guint mail_folder_source_item_signals[MAIL_FOLDER_SOURCE_ITEM_NUM_SIGNALS] = {0};

struct _MailSourceListItem {
	GObject parent_instance;
	MailSourceListItemPrivate * priv;
};

struct _MailSourceListItemClass {
	GObjectClass parent_class;
	GtkMenu* (*get_context_menu) (MailSourceListItem* self);
	void (*edited) (MailSourceListItem* self, const gchar* new_name);
	void (*action_activated) (MailSourceListItem* self);
	void (*activated) (MailSourceListItem* self);
};

struct _MailSourceListExpandableItem {
	MailSourceListItem parent_instance;
	MailSourceListExpandableItemPrivate * priv;
};

struct _MailSourceListExpandableItemClass {
	MailSourceListItemClass parent_class;
	void (*toggled) (MailSourceListExpandableItem* self);
};

struct _MailFolderSourceItem {
	MailSourceListExpandableItem parent_instance;
	MailFolderSourceItemPrivate * priv;
};

struct _MailFolderSourceItemClass {
	MailSourceListExpandableItemClass parent_class;
};

struct _MailFolderSourceItemPrivate {
	CamelFolderInfo* _folder_info;
	gchar* _full_name;
	gboolean _is_special_folder;
	gint _pos;
	MailBackendAccount* _account;
	gboolean can_modify;
	GCancellable* cancellable;
	gchar* old_name;
};

struct _MailFolderSourceItemRefreshData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailFolderSourceItem* self;
	CamelStore* offlinestore;
	MailBackendAccount* _tmp0_;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	CamelStore* _tmp3_;
	CamelFolder* folder;
	CamelStore* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	CamelFolder* _tmp7_;
	CamelFolder* _tmp8_;
	GCancellable* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _MailFolderSourceItemRenameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailFolderSourceItem* self;
	gchar* new_name;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** split_full_name;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint split_full_name_length1;
	gint _split_full_name_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* new_full_name;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	CamelStore* offlinestore;
	MailBackendAccount* _tmp16_;
	CamelService* _tmp17_;
	CamelService* _tmp18_;
	CamelStore* _tmp19_;
	CamelFolderInfo* folder_info;
	CamelFolderInfo* _tmp20_;
	CamelStore* _tmp21_;
	const gchar* _tmp22_;
	GCancellable* _tmp23_;
	CamelFolderInfo* _tmp24_;
	CamelFolderInfo* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	CamelFolderInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	CamelStore* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GCancellable* _tmp41_;
	GError* _vala1_e;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GError* _tmp49_;
	const gchar* _tmp50_;
	GError* _inner_error0_;
};

static gint MailFolderSourceItem_private_offset;
static gpointer mail_folder_source_item_parent_class = NULL;

VALA_EXTERN GType mail_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListItem, g_object_unref)
VALA_EXTERN GType mail_source_list_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListExpandableItem, g_object_unref)
VALA_EXTERN GType mail_folder_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFolderSourceItem, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN GtkMenu* mail_source_list_item_get_context_menu (MailSourceListItem* self);
static void _vala_CamelFolderInfo_free (CamelFolderInfo* self);
VALA_EXTERN MailFolderSourceItem* mail_folder_source_item_new (MailBackendAccount* account,
                                                   CamelFolderInfo* folderinfo);
VALA_EXTERN MailFolderSourceItem* mail_folder_source_item_construct (GType object_type,
                                                         MailBackendAccount* account,
                                                         CamelFolderInfo* folderinfo);
VALA_EXTERN void mail_folder_source_item_update_infos (MailFolderSourceItem* self,
                                           CamelFolderInfo* folderinfo);
static GtkMenu* mail_folder_source_item_real_get_context_menu (MailSourceListItem* base);
static void __lambda13_ (MailFolderSourceItem* self);
static void mail_folder_source_item_refresh (MailFolderSourceItem* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void mail_folder_source_item_refresh_finish (MailFolderSourceItem* self,
                                             GAsyncResult* _res_);
static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
VALA_EXTERN gboolean mail_folder_source_item_get_is_special_folder (MailFolderSourceItem* self);
static void ___lambda14_ (MailFolderSourceItem* self);
static void ____lambda14__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void mail_folder_source_item_set_folder_info (MailFolderSourceItem* self,
                                              CamelFolderInfo* value);
VALA_EXTERN void mail_source_list_item_set_name (MailSourceListItem* self,
                                     const gchar* value);
static void mail_folder_source_item_set_full_name (MailFolderSourceItem* self,
                                            const gchar* value);
VALA_EXTERN void mail_source_list_item_set_badge (MailSourceListItem* self,
                                      const gchar* value);
VALA_EXTERN CamelFolderInfoFlags mail_utils_get_full_folder_info_flags (CamelService* service,
                                                            CamelFolderInfo* folderinfo);
VALA_EXTERN MailBackendAccount* mail_folder_source_item_get_account (MailFolderSourceItem* self);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
VALA_EXTERN void mail_source_list_item_set_icon (MailSourceListItem* self,
                                     GIcon* value);
static void mail_folder_source_item_set_pos (MailFolderSourceItem* self,
                                      gint value);
static void mail_folder_source_item_set_is_special_folder (MailFolderSourceItem* self,
                                                    gboolean value);
VALA_EXTERN gboolean mail_source_list_item_get_editable (MailSourceListItem* self);
VALA_EXTERN void mail_source_list_item_set_editable (MailSourceListItem* self,
                                         gboolean value);
static void mail_folder_source_item_rename (MailFolderSourceItem* self,
                                     const gchar* new_name,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void mail_folder_source_item_rename_finish (MailFolderSourceItem* self,
                                            GAsyncResult* _res_);
static void _mail_folder_source_item_rename_mail_source_list_item_edited (MailSourceListItem* _sender,
                                                                   const gchar* new_name,
                                                                   gpointer self);
static void mail_folder_source_item_refresh_data_free (gpointer _data);
static gboolean mail_folder_source_item_refresh_co (MailFolderSourceItemRefreshData* _data_);
VALA_EXTERN const gchar* mail_folder_source_item_get_full_name (MailFolderSourceItem* self);
static void mail_folder_source_item_refresh_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void mail_folder_source_item_cancel_rename (MailFolderSourceItem* self);
static void _mail_folder_source_item_cancel_rename_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void mail_folder_source_item_rename_data_free (gpointer _data);
static gboolean mail_folder_source_item_rename_co (MailFolderSourceItemRenameData* _data_);
VALA_EXTERN const gchar* mail_source_list_item_get_name (MailSourceListItem* self);
VALA_EXTERN void mail_main_window_send_error_message (const gchar* title,
                                          const gchar* description,
                                          const gchar* icon_name,
                                          const gchar* error_details);
static void mail_folder_source_item_rename_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN CamelFolderInfo* mail_folder_source_item_get_folder_info (MailFolderSourceItem* self);
static CamelFolderInfo* _vala_CamelFolderInfo_copy (CamelFolderInfo* self);
VALA_EXTERN gint mail_folder_source_item_get_pos (MailFolderSourceItem* self);
static void mail_folder_source_item_set_account (MailFolderSourceItem* self,
                                          MailBackendAccount* value);
static GObject * mail_folder_source_item_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void mail_folder_source_item_finalize (GObject * obj);
static GType mail_folder_source_item_get_type_once (void);
static void _vala_mail_folder_source_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_mail_folder_source_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_folder_source_item_get_instance_private (MailFolderSourceItem* self)
{
	return G_STRUCT_MEMBER_P (self, MailFolderSourceItem_private_offset);
}

static void
_vala_CamelFolderInfo_free (CamelFolderInfo* self)
{
	g_boxed_free (camel_folder_info_get_type (), self);
}

MailFolderSourceItem*
mail_folder_source_item_construct (GType object_type,
                                   MailBackendAccount* account,
                                   CamelFolderInfo* folderinfo)
{
	MailFolderSourceItem * self = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (folderinfo != NULL, NULL);
	self = (MailFolderSourceItem*) g_object_new (object_type, "account", account, NULL);
	mail_folder_source_item_update_infos (self, folderinfo);
	return self;
}

MailFolderSourceItem*
mail_folder_source_item_new (MailBackendAccount* account,
                             CamelFolderInfo* folderinfo)
{
	return mail_folder_source_item_construct (MAIL_TYPE_FOLDER_SOURCE_ITEM, account, folderinfo);
}

static void
__lambda13_ (MailFolderSourceItem* self)
{
	mail_folder_source_item_refresh (self, NULL, NULL);
}

static void
___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda13_ ((MailFolderSourceItem*) self);
}

static void
___lambda14_ (MailFolderSourceItem* self)
{
	g_signal_emit (self, mail_folder_source_item_signals[MAIL_FOLDER_SOURCE_ITEM_START_EDIT_SIGNAL], 0);
}

static void
____lambda14__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda14_ ((MailFolderSourceItem*) self);
}

static GtkMenu*
mail_folder_source_item_real_get_context_menu (MailSourceListItem* base)
{
	MailFolderSourceItem * self;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* refresh_item = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenu* _tmp3_;
	GtkMenuItem* _tmp4_;
	gboolean _tmp5_;
	GtkMenu* _tmp13_;
	GtkMenu* result;
	self = (MailFolderSourceItem*) base;
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Refresh folder"));
	g_object_ref_sink (_tmp1_);
	refresh_item = _tmp1_;
	_tmp2_ = refresh_item;
	g_signal_connect_object (_tmp2_, "activate", (GCallback) ___lambda13__gtk_menu_item_activate, self, 0);
	_tmp3_ = menu;
	_tmp4_ = refresh_item;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_is_special_folder;
	if (!_tmp5_) {
		GtkMenuItem* rename_item = NULL;
		GtkMenuItem* _tmp6_;
		GtkMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkSeparatorMenuItem* _tmp9_;
		GtkSeparatorMenuItem* _tmp10_;
		GtkMenu* _tmp11_;
		GtkMenuItem* _tmp12_;
		_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Rename folder"));
		g_object_ref_sink (_tmp6_);
		rename_item = _tmp6_;
		_tmp7_ = rename_item;
		g_signal_connect_object (_tmp7_, "activate", (GCallback) ____lambda14__gtk_menu_item_activate, self, 0);
		_tmp8_ = menu;
		_tmp9_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_tmp11_ = menu;
		_tmp12_ = rename_item;
		gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
		_g_object_unref0 (rename_item);
	}
	_tmp13_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
	result = menu;
	_g_object_unref0 (refresh_item);
	return result;
}

static void
_mail_folder_source_item_rename_mail_source_list_item_edited (MailSourceListItem* _sender,
                                                              const gchar* new_name,
                                                              gpointer self)
{
	mail_folder_source_item_rename ((MailFolderSourceItem*) self, new_name, NULL, NULL);
}

void
mail_folder_source_item_update_infos (MailFolderSourceItem* self,
                                      CamelFolderInfo* folderinfo)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	CamelFolderInfoFlags full_folder_info_flags = 0U;
	MailBackendAccount* _tmp6_;
	CamelService* _tmp7_;
	CamelService* _tmp8_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folderinfo != NULL);
	mail_folder_source_item_set_folder_info (self, folderinfo);
	_tmp0_ = folderinfo->display_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->old_name);
	self->priv->old_name = _tmp1_;
	_tmp2_ = self->priv->old_name;
	mail_source_list_item_set_name ((MailSourceListItem*) self, _tmp2_);
	_tmp3_ = folderinfo->full_name;
	mail_folder_source_item_set_full_name (self, _tmp3_);
	if (folderinfo->unread > ((gint32) 0)) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("%d", (gint) folderinfo->unread);
		_tmp5_ = _tmp4_;
		mail_source_list_item_set_badge ((MailSourceListItem*) self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = self->priv->_account;
	_tmp7_ = mail_backend_account_get_service (_tmp6_);
	_tmp8_ = _tmp7_;
	full_folder_info_flags = mail_utils_get_full_folder_info_flags (_tmp8_, folderinfo);
	switch (full_folder_info_flags & CAMEL_FOLDER_TYPE_MASK) {
		case CAMEL_FOLDER_TYPE_INBOX:
		{
			GThemedIcon* _tmp9_;
			GThemedIcon* _tmp10_;
			_tmp9_ = (GThemedIcon*) g_themed_icon_new ("mail-inbox");
			_tmp10_ = _tmp9_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp10_);
			_g_object_unref0 (_tmp10_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 1);
			break;
		}
		case CAMEL_FOLDER_TYPE_DRAFTS:
		{
			GThemedIcon* _tmp11_;
			GThemedIcon* _tmp12_;
			_tmp11_ = (GThemedIcon*) g_themed_icon_new ("mail-drafts");
			_tmp12_ = _tmp11_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp12_);
			_g_object_unref0 (_tmp12_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 2);
			break;
		}
		case CAMEL_FOLDER_TYPE_OUTBOX:
		{
			GThemedIcon* _tmp13_;
			GThemedIcon* _tmp14_;
			_tmp13_ = (GThemedIcon*) g_themed_icon_new ("mail-outbox");
			_tmp14_ = _tmp13_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp14_);
			_g_object_unref0 (_tmp14_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 3);
			break;
		}
		case CAMEL_FOLDER_TYPE_SENT:
		{
			GThemedIcon* _tmp15_;
			GThemedIcon* _tmp16_;
			_tmp15_ = (GThemedIcon*) g_themed_icon_new ("mail-sent");
			_tmp16_ = _tmp15_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp16_);
			_g_object_unref0 (_tmp16_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 4);
			break;
		}
		case CAMEL_FOLDER_TYPE_ARCHIVE:
		{
			GThemedIcon* _tmp17_;
			GThemedIcon* _tmp18_;
			_tmp17_ = (GThemedIcon*) g_themed_icon_new ("mail-archive");
			_tmp18_ = _tmp17_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp18_);
			_g_object_unref0 (_tmp18_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 5);
			mail_source_list_item_set_badge ((MailSourceListItem*) self, NULL);
			break;
		}
		case CAMEL_FOLDER_TYPE_TRASH:
		{
			const gchar* _tmp19_ = NULL;
			GThemedIcon* _tmp20_;
			GThemedIcon* _tmp21_;
			if (folderinfo->total == ((gint32) 0)) {
				_tmp19_ = "user-trash";
			} else {
				_tmp19_ = "user-trash-full";
			}
			_tmp20_ = (GThemedIcon*) g_themed_icon_new (_tmp19_);
			_tmp21_ = _tmp20_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp21_);
			_g_object_unref0 (_tmp21_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 6);
			mail_source_list_item_set_badge ((MailSourceListItem*) self, NULL);
			break;
		}
		case CAMEL_FOLDER_TYPE_JUNK:
		{
			GThemedIcon* _tmp22_;
			GThemedIcon* _tmp23_;
			_tmp22_ = (GThemedIcon*) g_themed_icon_new ("edit-flag");
			_tmp23_ = _tmp22_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp23_);
			_g_object_unref0 (_tmp23_);
			self->priv->can_modify = FALSE;
			mail_folder_source_item_set_pos (self, 7);
			break;
		}
		default:
		{
			GThemedIcon* _tmp24_;
			GThemedIcon* _tmp25_;
			_tmp24_ = (GThemedIcon*) g_themed_icon_new ("folder");
			_tmp25_ = _tmp24_;
			mail_source_list_item_set_icon ((MailSourceListItem*) self, (GIcon*) _tmp25_);
			_g_object_unref0 (_tmp25_);
			self->priv->can_modify = TRUE;
			mail_folder_source_item_set_pos (self, 8);
			mail_folder_source_item_set_is_special_folder (self, FALSE);
			break;
		}
	}
	_tmp27_ = self->priv->_is_special_folder;
	if (!_tmp27_) {
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp28_ = mail_source_list_item_get_editable ((MailSourceListItem*) self);
		_tmp29_ = _tmp28_;
		_tmp26_ = _tmp29_ != TRUE;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		mail_source_list_item_set_editable ((MailSourceListItem*) self, TRUE);
		g_signal_connect_object ((MailSourceListItem*) self, "edited", (GCallback) _mail_folder_source_item_rename_mail_source_list_item_edited, self, 0);
	} else {
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_special_folder;
		if (_tmp30_) {
			guint _tmp31_;
			mail_source_list_item_set_editable ((MailSourceListItem*) self, FALSE);
			g_signal_parse_name ("edited", MAIL_SOURCE_LIST_TYPE_ITEM, &_tmp31_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((MailSourceListItem*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _mail_folder_source_item_rename_mail_source_list_item_edited, self);
		}
	}
}

static void
mail_folder_source_item_refresh_data_free (gpointer _data)
{
	MailFolderSourceItemRefreshData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailFolderSourceItemRefreshData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_folder_source_item_refresh (MailFolderSourceItem* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailFolderSourceItemRefreshData* _data_;
	MailFolderSourceItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailFolderSourceItemRefreshData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_folder_source_item_refresh_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_folder_source_item_refresh_co (_data_);
}

static void
mail_folder_source_item_refresh_finish (MailFolderSourceItem* self,
                                        GAsyncResult* _res_)
{
	MailFolderSourceItemRefreshData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_folder_source_item_refresh_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	MailFolderSourceItemRefreshData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_folder_source_item_refresh_co (_data_);
}

static gboolean
mail_folder_source_item_refresh_co (MailFolderSourceItemRefreshData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_account;
	_data_->_tmp1_ = mail_backend_account_get_service (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, camel_store_get_type (), CamelStore));
	_data_->offlinestore = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->offlinestore;
		_data_->_tmp5_ = _data_->self->priv->_full_name;
		_data_->_tmp6_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		camel_store_get_folder (_data_->_tmp4_, _data_->_tmp5_, 0, G_PRIORITY_DEFAULT, _data_->_tmp6_, mail_folder_source_item_refresh_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = camel_store_get_folder_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		_data_->folder = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->folder;
		_data_->_tmp9_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		camel_folder_refresh_info (_data_->_tmp8_, G_PRIORITY_DEFAULT, _data_->_tmp9_, mail_folder_source_item_refresh_ready, _data_);
		return FALSE;
		_state_2:
		camel_folder_refresh_info_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->folder);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->folder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_critical ("FolderSourceItem.vala:139: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->offlinestore);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->offlinestore);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_mail_folder_source_item_cancel_rename_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	mail_folder_source_item_cancel_rename ((MailFolderSourceItem*) self);
}

static void
mail_folder_source_item_cancel_rename (MailFolderSourceItem* self)
{
	const gchar* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->old_name;
	mail_source_list_item_set_name ((MailSourceListItem*) self, _tmp0_);
	g_signal_parse_name ("notify::name", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _mail_folder_source_item_cancel_rename_g_object_notify, self);
}

static void
mail_folder_source_item_rename_data_free (gpointer _data)
{
	MailFolderSourceItemRenameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->new_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailFolderSourceItemRenameData, _data_);
}

static void
mail_folder_source_item_rename (MailFolderSourceItem* self,
                                const gchar* new_name,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	MailFolderSourceItemRenameData* _data_;
	MailFolderSourceItem* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_name != NULL);
	_data_ = g_slice_new0 (MailFolderSourceItemRenameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_folder_source_item_rename_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (new_name);
	_g_free0 (_data_->new_name);
	_data_->new_name = _tmp1_;
	mail_folder_source_item_rename_co (_data_);
}

static void
mail_folder_source_item_rename_finish (MailFolderSourceItem* self,
                                       GAsyncResult* _res_)
{
	MailFolderSourceItemRenameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
mail_folder_source_item_rename_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	MailFolderSourceItemRenameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_folder_source_item_rename_co (_data_);
}

static gboolean
mail_folder_source_item_rename_co (MailFolderSourceItemRenameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->old_name;
	if (g_strcmp0 (_data_->new_name, _data_->_tmp0_) == 0) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (string_contains (_data_->new_name, "/")) {
		_data_->_tmp1_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->self->priv->old_name;
		if (g_strcmp0 (_data_->_tmp2_, _data_->_tmp3_) == 0) {
			g_signal_connect_object ((GObject*) _data_->self, "notify::name", (GCallback) _mail_folder_source_item_cancel_rename_g_object_notify, _data_->self, 0);
		} else {
			mail_folder_source_item_cancel_rename (_data_->self);
		}
		_data_->_tmp4_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_strdup_printf (_ ("Couldn't rename “%s”"), _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		mail_main_window_send_error_message (_data_->_tmp7_, _ ("Folder names cannot contain “/”"), "folder", NULL);
		_g_free0 (_data_->_tmp7_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->_full_name;
	_data_->_tmp10_ = _data_->_tmp9_ = g_strsplit_set (_data_->_tmp8_, "/", 0);
	_data_->split_full_name = _data_->_tmp10_;
	_data_->split_full_name_length1 = _vala_array_length (_data_->_tmp9_);
	_data_->_split_full_name_size_ = _data_->split_full_name_length1;
	_data_->_tmp11_ = _data_->split_full_name;
	_data_->_tmp11__length1 = _data_->split_full_name_length1;
	_data_->_tmp12_ = _data_->split_full_name;
	_data_->_tmp12__length1 = _data_->split_full_name_length1;
	_data_->_tmp13_ = g_strdup (_data_->new_name);
	_g_free0 (_data_->_tmp11_[_data_->_tmp12__length1 - 1]);
	_data_->_tmp11_[_data_->_tmp12__length1 - 1] = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->split_full_name;
	_data_->_tmp14__length1 = _data_->split_full_name_length1;
	_data_->_tmp15_ = _vala_g_strjoinv ("/", _data_->_tmp14_, (gint) _data_->_tmp14__length1);
	_data_->new_full_name = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->self->priv->_account;
	_data_->_tmp17_ = mail_backend_account_get_service (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, camel_store_get_type (), CamelStore));
	_data_->offlinestore = _data_->_tmp19_;
	_data_->folder_info = NULL;
	{
		_data_->_tmp21_ = _data_->offlinestore;
		_data_->_tmp22_ = _data_->new_full_name;
		_data_->_tmp23_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		camel_store_get_folder_info (_data_->_tmp21_, _data_->_tmp22_, CAMEL_STORE_FOLDER_INFO_FAST, G_PRIORITY_DEFAULT, _data_->_tmp23_, mail_folder_source_item_rename_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp24_ = camel_store_get_folder_info_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp20_ = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp25_ = _data_->_tmp20_;
		_data_->_tmp20_ = NULL;
		__vala_CamelFolderInfo_free0 (_data_->folder_info);
		_data_->folder_info = _data_->_tmp25_;
		__vala_CamelFolderInfo_free0 (_data_->_tmp20_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("FolderSourceItem.vala:179: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		__vala_CamelFolderInfo_free0 (_data_->folder_info);
		_g_object_unref0 (_data_->offlinestore);
		_g_free0 (_data_->new_full_name);
		_data_->split_full_name = (_vala_array_free (_data_->split_full_name, _data_->split_full_name_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = _data_->folder_info;
	if (NULL != _data_->_tmp28_) {
		_data_->_tmp29_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = _data_->self->priv->old_name;
		if (g_strcmp0 (_data_->_tmp30_, _data_->_tmp31_) == 0) {
			g_signal_connect_object ((GObject*) _data_->self, "notify::name", (GCallback) _mail_folder_source_item_cancel_rename_g_object_notify, _data_->self, 0);
		} else {
			mail_folder_source_item_cancel_rename (_data_->self);
		}
		_data_->_tmp32_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = g_strdup_printf (_ ("Couldn't rename “%s”"), _data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = g_strdup_printf (_ ("A folder named “%s” already exists"), _data_->new_name);
		_data_->_tmp37_ = _data_->_tmp36_;
		mail_main_window_send_error_message (_data_->_tmp35_, _data_->_tmp37_, "folder", NULL);
		_g_free0 (_data_->_tmp37_);
		_g_free0 (_data_->_tmp35_);
		__vala_CamelFolderInfo_free0 (_data_->folder_info);
		_g_object_unref0 (_data_->offlinestore);
		_g_free0 (_data_->new_full_name);
		_data_->split_full_name = (_vala_array_free (_data_->split_full_name, _data_->split_full_name_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp38_ = _data_->offlinestore;
		_data_->_tmp39_ = _data_->self->priv->_full_name;
		_data_->_tmp40_ = _data_->new_full_name;
		_data_->_tmp41_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		camel_store_rename_folder (_data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_, G_PRIORITY_DEFAULT, _data_->_tmp41_, mail_folder_source_item_rename_ready, _data_);
		return FALSE;
		_state_2:
		camel_store_rename_folder_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp42_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->_tmp44_ = _data_->self->priv->old_name;
		if (g_strcmp0 (_data_->_tmp43_, _data_->_tmp44_) == 0) {
			g_signal_connect_object ((GObject*) _data_->self, "notify::name", (GCallback) _mail_folder_source_item_cancel_rename_g_object_notify, _data_->self, 0);
		} else {
			mail_folder_source_item_cancel_rename (_data_->self);
		}
		_data_->_tmp45_ = mail_source_list_item_get_name ((MailSourceListItem*) _data_->self);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = g_strdup_printf (_ ("Couldn't rename “%s”"), _data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = _data_->_vala1_e;
		_data_->_tmp50_ = _data_->_tmp49_->message;
		mail_main_window_send_error_message (_data_->_tmp48_, _data_->_tmp50_, "folder", NULL);
		_g_free0 (_data_->_tmp48_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		__vala_CamelFolderInfo_free0 (_data_->folder_info);
		_g_object_unref0 (_data_->offlinestore);
		_g_free0 (_data_->new_full_name);
		_data_->split_full_name = (_vala_array_free (_data_->split_full_name, _data_->split_full_name_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__vala_CamelFolderInfo_free0 (_data_->folder_info);
	_g_object_unref0 (_data_->offlinestore);
	_g_free0 (_data_->new_full_name);
	_data_->split_full_name = (_vala_array_free (_data_->split_full_name, _data_->split_full_name_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

CamelFolderInfo*
mail_folder_source_item_get_folder_info (MailFolderSourceItem* self)
{
	CamelFolderInfo* result;
	CamelFolderInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder_info;
	result = _tmp0_;
	return result;
}

static CamelFolderInfo*
_vala_CamelFolderInfo_copy (CamelFolderInfo* self)
{
	return g_boxed_copy (camel_folder_info_get_type (), self);
}

static gpointer
__vala_CamelFolderInfo_copy0 (gpointer self)
{
	return self ? _vala_CamelFolderInfo_copy (self) : NULL;
}

static void
mail_folder_source_item_set_folder_info (MailFolderSourceItem* self,
                                         CamelFolderInfo* value)
{
	CamelFolderInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folder_source_item_get_folder_info (self);
	if (old_value != value) {
		CamelFolderInfo* _tmp0_;
		_tmp0_ = __vala_CamelFolderInfo_copy0 (value);
		__vala_CamelFolderInfo_free0 (self->priv->_folder_info);
		self->priv->_folder_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY]);
	}
}

const gchar*
mail_folder_source_item_get_full_name (MailFolderSourceItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}

static void
mail_folder_source_item_set_full_name (MailFolderSourceItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folder_source_item_get_full_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY]);
	}
}

gboolean
mail_folder_source_item_get_is_special_folder (MailFolderSourceItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_special_folder;
	return result;
}

static void
mail_folder_source_item_set_is_special_folder (MailFolderSourceItem* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folder_source_item_get_is_special_folder (self);
	if (old_value != value) {
		self->priv->_is_special_folder = value;
		g_object_notify_by_pspec ((GObject *) self, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY]);
	}
}

gint
mail_folder_source_item_get_pos (MailFolderSourceItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_pos;
	return result;
}

static void
mail_folder_source_item_set_pos (MailFolderSourceItem* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folder_source_item_get_pos (self);
	if (old_value != value) {
		self->priv->_pos = value;
		g_object_notify_by_pspec ((GObject *) self, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY]);
	}
}

MailBackendAccount*
mail_folder_source_item_get_account (MailFolderSourceItem* self)
{
	MailBackendAccount* result;
	MailBackendAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
mail_folder_source_item_set_account (MailFolderSourceItem* self,
                                     MailBackendAccount* value)
{
	MailBackendAccount* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folder_source_item_get_account (self);
	if (old_value != value) {
		MailBackendAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY]);
	}
}

static GObject *
mail_folder_source_item_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailFolderSourceItem * self;
	GCancellable* _tmp0_;
	parent_class = G_OBJECT_CLASS (mail_folder_source_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	return obj;
}

static void
mail_folder_source_item_class_init (MailFolderSourceItemClass * klass,
                                    gpointer klass_data)
{
	mail_folder_source_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailFolderSourceItem_private_offset);
	((MailSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (MailSourceListItem*)) mail_folder_source_item_real_get_context_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_folder_source_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_folder_source_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_folder_source_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_folder_source_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY] = g_param_spec_boxed ("folder-info", "folder-info", "folder-info", camel_folder_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY] = g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY] = g_param_spec_boolean ("is-special-folder", "is-special-folder", "is-special-folder", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY] = g_param_spec_int ("pos", "pos", "pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY, mail_folder_source_item_properties[MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", MAIL_BACKEND_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	mail_folder_source_item_signals[MAIL_FOLDER_SOURCE_ITEM_START_EDIT_SIGNAL] = g_signal_new ("start-edit", MAIL_TYPE_FOLDER_SOURCE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_folder_source_item_instance_init (MailFolderSourceItem * self,
                                       gpointer klass)
{
	self->priv = mail_folder_source_item_get_instance_private (self);
	self->priv->_is_special_folder = TRUE;
	self->priv->can_modify = TRUE;
}

static void
mail_folder_source_item_finalize (GObject * obj)
{
	MailFolderSourceItem * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	__vala_CamelFolderInfo_free0 (self->priv->_folder_info);
	_g_free0 (self->priv->_full_name);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->cancellable);
	_g_free0 (self->priv->old_name);
	G_OBJECT_CLASS (mail_folder_source_item_parent_class)->finalize (obj);
}

static GType
mail_folder_source_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailFolderSourceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_folder_source_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailFolderSourceItem), 0, (GInstanceInitFunc) mail_folder_source_item_instance_init, NULL };
	GType mail_folder_source_item_type_id;
	mail_folder_source_item_type_id = g_type_register_static (MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, "MailFolderSourceItem", &g_define_type_info, 0);
	MailFolderSourceItem_private_offset = g_type_add_instance_private (mail_folder_source_item_type_id, sizeof (MailFolderSourceItemPrivate));
	return mail_folder_source_item_type_id;
}

GType
mail_folder_source_item_get_type (void)
{
	static volatile gsize mail_folder_source_item_type_id__once = 0;
	if (g_once_init_enter (&mail_folder_source_item_type_id__once)) {
		GType mail_folder_source_item_type_id;
		mail_folder_source_item_type_id = mail_folder_source_item_get_type_once ();
		g_once_init_leave (&mail_folder_source_item_type_id__once, mail_folder_source_item_type_id);
	}
	return mail_folder_source_item_type_id__once;
}

static void
_vala_mail_folder_source_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MailFolderSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
	switch (property_id) {
		case MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY:
		g_value_set_boxed (value, mail_folder_source_item_get_folder_info (self));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY:
		g_value_set_string (value, mail_folder_source_item_get_full_name (self));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY:
		g_value_set_boolean (value, mail_folder_source_item_get_is_special_folder (self));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY:
		g_value_set_int (value, mail_folder_source_item_get_pos (self));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY:
		g_value_set_object (value, mail_folder_source_item_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_folder_source_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MailFolderSourceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
	switch (property_id) {
		case MAIL_FOLDER_SOURCE_ITEM_FOLDER_INFO_PROPERTY:
		mail_folder_source_item_set_folder_info (self, g_value_get_boxed (value));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_FULL_NAME_PROPERTY:
		mail_folder_source_item_set_full_name (self, g_value_get_string (value));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_IS_SPECIAL_FOLDER_PROPERTY:
		mail_folder_source_item_set_is_special_folder (self, g_value_get_boolean (value));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_POS_PROPERTY:
		mail_folder_source_item_set_pos (self, g_value_get_int (value));
		break;
		case MAIL_FOLDER_SOURCE_ITEM_ACCOUNT_PROPERTY:
		mail_folder_source_item_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

