/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 85;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 16;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 76,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 13,
  Feature_NoV5TBit = 67,
  Feature_HasV5TEBit = 11,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 9,
  Feature_HasV6MBit = 28,
  Feature_HasV8MBaselineBit = 35,
  Feature_HasV8_1MMainlineBit = 41,
  Feature_HasMVEIntBit = 65,
  Feature_HasMVEFloatBit = 66,
  Feature_HasCDEBit = 84,
  Feature_HasFPRegsBit = 42,
  Feature_HasFPRegs16Bit = 43,
  Feature_HasNoFPRegs16Bit = 75,
  Feature_HasFPRegs64Bit = 52,
  Feature_HasV6T2Bit = 8,
  Feature_HasV6KBit = 18,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 56,
  Feature_PreV8Bit = 19,
  Feature_HasV8_1aBit = 78,
  Feature_HasV8_3aBit = 79,
  Feature_NoVFPBit = 22,
  Feature_HasVFP2Bit = 21,
  Feature_HasVFP3Bit = 53,
  Feature_HasVFP4Bit = 50,
  Feature_HasDPVFPBit = 44,
  Feature_HasFPARMv8Bit = 47,
  Feature_HasNEONBit = 54,
  Feature_HasSHA2Bit = 63,
  Feature_HasAESBit = 55,
  Feature_HasDotProdBit = 57,
  Feature_HasCRCBit = 14,
  Feature_HasLOBBit = 40,
  Feature_HasFP16Bit = 62,
  Feature_HasFullFP16Bit = 46,
  Feature_HasBF16Bit = 64,
  Feature_HasMatMulInt8Bit = 58,
  Feature_HasDivideInThumbBit = 37,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 36,
  Feature_HasDBBit = 15,
  Feature_HasV7ClrexBit = 17,
  Feature_HasAcquireReleaseBit = 16,
  Feature_HasMPBit = 2,
  Feature_Has8MSecExtBit = 29,
  Feature_HasZCZBit = 59,
  Feature_UseNEONForFPBit = 82,
  Feature_DontUseNEONForFPBit = 45,
  Feature_IsThumbBit = 26,
  Feature_IsThumb1OnlyBit = 27,
  Feature_IsThumb2Bit = 34,
  Feature_IsNotMClassBit = 38,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPTPIDRURWBit = 70,
  Feature_IsReadTPTPIDRUROBit = 71,
  Feature_IsReadTPTPIDRPRWBit = 72,
  Feature_IsReadTPSoftBit = 20,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 39,
  Feature_DontUseMovtBit = 23,
  Feature_UseMovtInPicBit = 24,
  Feature_DontUseMovtInPicBit = 25,
  Feature_UseFPVMLxBit = 49,
  Feature_SLSBLRMitigationBit = 69,
  Feature_NoSLSBLRMitigationBit = 68,
  Feature_UseMulOpsBit = 10,
  Feature_UseFusedMACBit = 51,
  Feature_HasFastVGETLNi32Bit = 60,
  Feature_HasSlowVGETLNi32Bit = 80,
  Feature_HasFastVDUP32Bit = 61,
  Feature_HasSlowVDUP32Bit = 81,
  Feature_UseVMOVSRBit = 48,
  Feature_DontUseVMOVSRBit = 83,
  Feature_IsLEBit = 74,
  Feature_IsBEBit = 77,
  Feature_GenExecuteOnlyBit = 33,
  Feature_DontGenExecuteOnlyBit = 32,
  Feature_GenT1ExecuteOnlyBit = 73,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features.set(Feature_NoHonorSignDependentRoundingBit);
  if (Subtarget->hasV4TOps())
    Features.set(Feature_HasV4TBit);
  if (!Subtarget->hasV4TOps())
    Features.set(Feature_NoV4TBit);
  if (Subtarget->hasV5TOps())
    Features.set(Feature_HasV5TBit);
  if (!Subtarget->hasV5TOps())
    Features.set(Feature_NoV5TBit);
  if (Subtarget->hasV5TEOps())
    Features.set(Feature_HasV5TEBit);
  if (Subtarget->hasV6Ops())
    Features.set(Feature_HasV6Bit);
  if (!Subtarget->hasV6Ops())
    Features.set(Feature_NoV6Bit);
  if (Subtarget->hasV6MOps())
    Features.set(Feature_HasV6MBit);
  if (Subtarget->hasV8MBaselineOps())
    Features.set(Feature_HasV8MBaselineBit);
  if (Subtarget->hasV8_1MMainlineOps())
    Features.set(Feature_HasV8_1MMainlineBit);
  if (Subtarget->hasMVEIntegerOps())
    Features.set(Feature_HasMVEIntBit);
  if (Subtarget->hasMVEFloatOps())
    Features.set(Feature_HasMVEFloatBit);
  if (Subtarget->hasCDEOps())
    Features.set(Feature_HasCDEBit);
  if (Subtarget->hasFPRegs())
    Features.set(Feature_HasFPRegsBit);
  if (Subtarget->hasFPRegs16())
    Features.set(Feature_HasFPRegs16Bit);
  if (!Subtarget->hasFPRegs16())
    Features.set(Feature_HasNoFPRegs16Bit);
  if (Subtarget->hasFPRegs64())
    Features.set(Feature_HasFPRegs64Bit);
  if (Subtarget->hasV6T2Ops())
    Features.set(Feature_HasV6T2Bit);
  if (Subtarget->hasV6KOps())
    Features.set(Feature_HasV6KBit);
  if (Subtarget->hasV7Ops())
    Features.set(Feature_HasV7Bit);
  if (Subtarget->hasV8Ops())
    Features.set(Feature_HasV8Bit);
  if (!Subtarget->hasV8Ops())
    Features.set(Feature_PreV8Bit);
  if (Subtarget->hasV8_1aOps())
    Features.set(Feature_HasV8_1aBit);
  if (Subtarget->hasV8_3aOps())
    Features.set(Feature_HasV8_3aBit);
  if (!Subtarget->hasVFP2Base())
    Features.set(Feature_NoVFPBit);
  if (Subtarget->hasVFP2Base())
    Features.set(Feature_HasVFP2Bit);
  if (Subtarget->hasVFP3Base())
    Features.set(Feature_HasVFP3Bit);
  if (Subtarget->hasVFP4Base())
    Features.set(Feature_HasVFP4Bit);
  if (Subtarget->hasFP64())
    Features.set(Feature_HasDPVFPBit);
  if (Subtarget->hasFPARMv8Base())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLOB())
    Features.set(Feature_HasLOBBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasDivideInThumbMode())
    Features.set(Feature_HasDivideInThumbBit);
  if (Subtarget->hasDivideInARMMode())
    Features.set(Feature_HasDivideInARMBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDataBarrier())
    Features.set(Feature_HasDBBit);
  if (Subtarget->hasV7Clrex())
    Features.set(Feature_HasV7ClrexBit);
  if (Subtarget->hasAcquireRelease())
    Features.set(Feature_HasAcquireReleaseBit);
  if (Subtarget->hasMPExtension())
    Features.set(Feature_HasMPBit);
  if (Subtarget->has8MSecExt())
    Features.set(Feature_Has8MSecExtBit);
  if (Subtarget->hasZeroCycleZeroing())
    Features.set(Feature_HasZCZBit);
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseNEONForFPBit);
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseNEONForFPBit);
  if (Subtarget->isThumb())
    Features.set(Feature_IsThumbBit);
  if (Subtarget->isThumb1Only())
    Features.set(Feature_IsThumb1OnlyBit);
  if (Subtarget->isThumb2())
    Features.set(Feature_IsThumb2Bit);
  if (!Subtarget->isMClass())
    Features.set(Feature_IsNotMClassBit);
  if (!Subtarget->isThumb())
    Features.set(Feature_IsARMBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (!Subtarget->isTargetWindows())
    Features.set(Feature_IsNotWindowsBit);
  if (Subtarget->isReadTPTPIDRURW())
    Features.set(Feature_IsReadTPTPIDRURWBit);
  if (Subtarget->isReadTPTPIDRURO())
    Features.set(Feature_IsReadTPTPIDRUROBit);
  if (Subtarget->isReadTPTPIDRPRW())
    Features.set(Feature_IsReadTPTPIDRPRWBit);
  if (Subtarget->isReadTPSoft())
    Features.set(Feature_IsReadTPSoftBit);
  if (Subtarget->useNaClTrap())
    Features.set(Feature_UseNaClTrapBit);
  if (!Subtarget->useNaClTrap())
    Features.set(Feature_DontUseNaClTrapBit);
  if (Subtarget->useMulOps())
    Features.set(Feature_UseMulOpsBit);
  if (TM.Options.AllowFPOpFusion ==  FPOpFusion::Fast && Subtarget->useFPVFMx())
    Features.set(Feature_UseFusedMACBit);
  if (!Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasFastVGETLNi32Bit);
  if (Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasSlowVGETLNi32Bit);
  if (!Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasFastVDUP32Bit);
  if (Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasSlowVDUP32Bit);
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseVMOVSRBit);
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseVMOVSRBit);
  if (Subtarget->genExecuteOnly())
    Features.set(Feature_GenExecuteOnlyBit);
  if (!Subtarget->genExecuteOnly())
    Features.set(Feature_DontGenExecuteOnlyBit);
  if (Subtarget->genExecuteOnly() && Subtarget->isThumb1Only() && !Subtarget->hasV8MBaselineOps())
    Features.set(Feature_GenT1ExecuteOnlyBit);
  return Features;
}

void ARMInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const ARMSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (Subtarget->useMovt())
    Features.set(Feature_UseMovtBit);
  if (!Subtarget->useMovt())
    Features.set(Feature_DontUseMovtBit);
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_UseMovtInPicBit);
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_DontUseMovtInPicBit);
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features.set(Feature_UseFPVMLxBit);
  if ( MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (MF->getDataLayout().isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (MF->getDataLayout().isBigEndian())
    Features.set(Feature_IsBEBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_DontUseVMOVSR_HasNEON,
  GIFBS_Has8MSecExt_IsThumb,
  GIFBS_HasAES_HasV8,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasCRC_IsARM,
  GIFBS_HasCRC_IsThumb2,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPARMv8_HasNEON,
  GIFBS_HasFPRegs_HasFastVGETLNi32,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_HasV8_1MMainline,
  GIFBS_HasMVEInt_IsBE,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasV8_3a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasNEON_UseNEONForFP,
  GIFBS_HasSHA2_HasV8,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_DontUseMovt_GenExecuteOnly_IsThumb1Only,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFPARMv8_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_HasV8_3a,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasLOB_HasV8_1MMainline_IsThumb2,
  GIFBS_HasNEON_UseFPVMLx_UseNEONForFP,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_HasVFP4_UseFusedMAC_UseNEONForFP,
  GIFBS_IsARM_NoV6_UseMulOps,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_DontUseVMOVSRBit, Feature_HasNEONBit, },
  {Feature_Has8MSecExtBit, Feature_IsThumbBit, },
  {Feature_HasAESBit, Feature_HasV8Bit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasCRCBit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_IsThumb2Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_HasFastVGETLNi32Bit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsBEBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_UseNEONForFPBit, },
  {Feature_HasSHA2Bit, Feature_HasV8Bit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_DontUseMovtBit, Feature_GenExecuteOnlyBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFPARMv8Bit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasLOBBit, Feature_HasV8_1MMainlineBit, Feature_IsThumb2Bit, },
  {Feature_HasNEONBit, Feature_UseFPVMLxBit, Feature_UseNEONForFPBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasVFP4Bit, Feature_UseFusedMACBit, Feature_UseNEONForFPBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_bf_inv_mask_imm = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_vfp_f32imm,
  GICXXPred_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_bf_inv_mask_imm: {
    
        // There's better methods of implementing this check. IntImmLeaf<> would be
        // equivalent and have less boilerplate but we need a test for C++
        // predicates and this one causes new rules to be imported into GlobalISel
        // without requiring additional features first.
        const auto &MO = MI.getOperand(1);
        if (!MO.isCImm())
          return false;
        return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
      
    llvm_unreachable("bf_inv_mask_imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f32imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f32imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f64imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f64imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex8 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex16,
  GICXXPred_I64_Predicate_VectorIndex32,
  GICXXPred_I64_Predicate_VectorIndex64,
  GICXXPred_I64_Predicate_asr_imm,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_32,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_239,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm0_255_expr,
  GICXXPred_I64_Predicate_imm0_4095,
  GICXXPred_I64_Predicate_imm0_65535,
  GICXXPred_I64_Predicate_imm0_65535_expr,
  GICXXPred_I64_Predicate_imm0_65535_neg,
  GICXXPred_I64_Predicate_imm1_7,
  GICXXPred_I64_Predicate_imm1_15,
  GICXXPred_I64_Predicate_imm1_16,
  GICXXPred_I64_Predicate_imm1_31,
  GICXXPred_I64_Predicate_imm8,
  GICXXPred_I64_Predicate_imm8_255,
  GICXXPred_I64_Predicate_imm8_or_16,
  GICXXPred_I64_Predicate_imm16,
  GICXXPred_I64_Predicate_imm16_31,
  GICXXPred_I64_Predicate_imm24b,
  GICXXPred_I64_Predicate_imm32,
  GICXXPred_I64_Predicate_imm256_510,
  GICXXPred_I64_Predicate_imm_3b,
  GICXXPred_I64_Predicate_imm_4b,
  GICXXPred_I64_Predicate_imm_6b,
  GICXXPred_I64_Predicate_imm_7b,
  GICXXPred_I64_Predicate_imm_9b,
  GICXXPred_I64_Predicate_imm_11b,
  GICXXPred_I64_Predicate_imm_12b,
  GICXXPred_I64_Predicate_imm_13b,
  GICXXPred_I64_Predicate_imm_even,
  GICXXPred_I64_Predicate_imm_odd,
  GICXXPred_I64_Predicate_long_shift,
  GICXXPred_I64_Predicate_mod_imm,
  GICXXPred_I64_Predicate_pkh_asr_amt,
  GICXXPred_I64_Predicate_pkh_lsl_amt,
  GICXXPred_I64_Predicate_shr_imm8,
  GICXXPred_I64_Predicate_shr_imm16,
  GICXXPred_I64_Predicate_shr_imm32,
  GICXXPred_I64_Predicate_shr_imm64,
  GICXXPred_I64_Predicate_t2_so_imm,
  GICXXPred_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex8: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex16: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex32: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex64: {
    
      return ((uint64_t)Imm) < 1;
    
  }
  case GICXXPred_I64_Predicate_asr_imm: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return Imm >= 0 && Imm < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return Imm >= 0 && Imm < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return Imm >= 0 && Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_32: {
    
      return Imm >= 0 && Imm < 33;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return Imm >= 0 && Imm < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
  }
  case GICXXPred_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_255_expr: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_4095: {
    
      return Imm >= 0 && Imm < 4096;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_expr: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_neg: {
    
      return -Imm >= 0 && -Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
  }
  case GICXXPred_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_imm1_16: {
    
        return Imm > 0 && Imm <= 16;
      
  }
  case GICXXPred_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_imm8: {
     return Imm == 8; 
  }
  case GICXXPred_I64_Predicate_imm8_255: {
    
      return Imm >= 8 && Imm < 256;
    
  }
  case GICXXPred_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
  }
  case GICXXPred_I64_Predicate_imm16: {
     return Imm == 16; 
  }
  case GICXXPred_I64_Predicate_imm16_31: {
    
      return (int32_t)Imm >= 16 && (int32_t)Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm24b: {
    
      return Imm >= 0 && Imm <= 0xffffff;
    
  }
  case GICXXPred_I64_Predicate_imm32: {
     return Imm == 32; 
  }
  case GICXXPred_I64_Predicate_imm256_510: {
    
      return Imm >= 256 && Imm < 511;
    
  }
  case GICXXPred_I64_Predicate_imm_3b: {
    { return Imm >= 0 && Imm < (1 << 3); }
    llvm_unreachable("imm_3b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_4b: {
    { return Imm >= 0 && Imm < (1 << 4); }
    llvm_unreachable("imm_4b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_6b: {
    { return Imm >= 0 && Imm < (1 << 6); }
    llvm_unreachable("imm_6b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_7b: {
    { return Imm >= 0 && Imm < (1 << 7); }
    llvm_unreachable("imm_7b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_9b: {
    { return Imm >= 0 && Imm < (1 << 9); }
    llvm_unreachable("imm_9b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_11b: {
    { return Imm >= 0 && Imm < (1 << 11); }
    llvm_unreachable("imm_11b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_12b: {
    { return Imm >= 0 && Imm < (1 << 12); }
    llvm_unreachable("imm_12b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_13b: {
    { return Imm >= 0 && Imm < (1 << 13); }
    llvm_unreachable("imm_13b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
  }
  case GICXXPred_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
  }
  case GICXXPred_I64_Predicate_long_shift: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_mod_imm: {
    
        return ARM_AM::getSOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
  }
  case GICXXPred_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
  }
  case GICXXPred_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
  }
  case GICXXPred_I64_Predicate_t2_so_imm: {
    
        return ARM_AM::getT2SOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_t2_so_imm_neg: {
    
      return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_arm_i32imm = GICXXPred_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_arm_i32imm: {
    
      if (Subtarget->useMovt())
        return true;
      if (ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue()))
        return true;
      return ARM_AM::isSOImmTwoPartValNeg(Imm.getZExtValue());
    
    llvm_unreachable("arm_i32imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("ARMInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderVFPF32Imm,
  GICR_renderVFPF64Imm,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &ARMInstructionSelector::renderVFPF32Imm,
  &ARMInstructionSelector::renderVFPF64Imm,
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void ARMInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("ARMInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(47), GIMT_Encode2(269), /*)*//*default:*//*Label 74*/ GIMT_Encode4(157540),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(898),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(10663),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(14339),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(15397),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(15522), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(15647),
    /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(19058),
    /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(25513), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(27380), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(27889), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(41273),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(41620), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ GIMT_Encode4(41913), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 13*/ GIMT_Encode4(42088), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 14*/ GIMT_Encode4(42114),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 15*/ GIMT_Encode4(112629), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 16*/ GIMT_Encode4(122223),
    /*TargetOpcode::G_TRUNC*//*Label 17*/ GIMT_Encode4(122414),
    /*TargetOpcode::G_CONSTANT*//*Label 18*/ GIMT_Encode4(122605),
    /*TargetOpcode::G_FCONSTANT*//*Label 19*/ GIMT_Encode4(122891), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 20*/ GIMT_Encode4(123001), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 21*/ GIMT_Encode4(123192),
    /*TargetOpcode::G_SHL*//*Label 22*/ GIMT_Encode4(123845),
    /*TargetOpcode::G_LSHR*//*Label 23*/ GIMT_Encode4(123980),
    /*TargetOpcode::G_ASHR*//*Label 24*/ GIMT_Encode4(124052), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 25*/ GIMT_Encode4(124317), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 26*/ GIMT_Encode4(124644),
    /*TargetOpcode::G_SMULH*//*Label 27*/ GIMT_Encode4(124931),
    /*TargetOpcode::G_UADDSAT*//*Label 28*/ GIMT_Encode4(125367),
    /*TargetOpcode::G_SADDSAT*//*Label 29*/ GIMT_Encode4(126165),
    /*TargetOpcode::G_USUBSAT*//*Label 30*/ GIMT_Encode4(127724),
    /*TargetOpcode::G_SSUBSAT*//*Label 31*/ GIMT_Encode4(128522), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 32*/ GIMT_Encode4(129761),
    /*TargetOpcode::G_FSUB*//*Label 33*/ GIMT_Encode4(132278),
    /*TargetOpcode::G_FMUL*//*Label 34*/ GIMT_Encode4(134131),
    /*TargetOpcode::G_FMA*//*Label 35*/ GIMT_Encode4(135288), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 36*/ GIMT_Encode4(137492), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 37*/ GIMT_Encode4(137702),
    /*TargetOpcode::G_FPEXT*//*Label 38*/ GIMT_Encode4(139435),
    /*TargetOpcode::G_FPTRUNC*//*Label 39*/ GIMT_Encode4(139705),
    /*TargetOpcode::G_FPTOSI*//*Label 40*/ GIMT_Encode4(140015),
    /*TargetOpcode::G_FPTOUI*//*Label 41*/ GIMT_Encode4(141526),
    /*TargetOpcode::G_SITOFP*//*Label 42*/ GIMT_Encode4(143037),
    /*TargetOpcode::G_UITOFP*//*Label 43*/ GIMT_Encode4(143779),
    /*TargetOpcode::G_FABS*//*Label 44*/ GIMT_Encode4(144521), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 45*/ GIMT_Encode4(145409),
    /*TargetOpcode::G_FMAXNUM*//*Label 46*/ GIMT_Encode4(146083), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 47*/ GIMT_Encode4(146757),
    /*TargetOpcode::G_FMAXIMUM*//*Label 48*/ GIMT_Encode4(147553),
    /*TargetOpcode::G_GET_FPENV*//*Label 49*/ GIMT_Encode4(148349),
    /*TargetOpcode::G_SET_FPENV*//*Label 50*/ GIMT_Encode4(148390),
    /*TargetOpcode::G_RESET_FPENV*//*Label 51*/ GIMT_Encode4(148434),
    /*TargetOpcode::G_GET_FPMODE*//*Label 52*/ GIMT_Encode4(148565), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 53*/ GIMT_Encode4(148606),
    /*TargetOpcode::G_SMAX*//*Label 54*/ GIMT_Encode4(149272),
    /*TargetOpcode::G_UMIN*//*Label 55*/ GIMT_Encode4(149938),
    /*TargetOpcode::G_UMAX*//*Label 56*/ GIMT_Encode4(151042),
    /*TargetOpcode::G_ABS*//*Label 57*/ GIMT_Encode4(152146), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 58*/ GIMT_Encode4(152905), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 59*/ GIMT_Encode4(152991), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 60*/ GIMT_Encode4(153167), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 61*/ GIMT_Encode4(153839),
    /*TargetOpcode::G_BSWAP*//*Label 62*/ GIMT_Encode4(153969),
    /*TargetOpcode::G_BITREVERSE*//*Label 63*/ GIMT_Encode4(154308),
    /*TargetOpcode::G_FCEIL*//*Label 64*/ GIMT_Encode4(154788), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 65*/ GIMT_Encode4(155081),
    /*TargetOpcode::G_FFLOOR*//*Label 66*/ GIMT_Encode4(155252),
    /*TargetOpcode::G_FRINT*//*Label 67*/ GIMT_Encode4(155545),
    /*TargetOpcode::G_FNEARBYINT*//*Label 68*/ GIMT_Encode4(155892), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_ADD*//*Label 69*/ GIMT_Encode4(156063), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 70*/ GIMT_Encode4(156270),
    /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 71*/ GIMT_Encode4(156581),
    /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 72*/ GIMT_Encode4(156901),
    /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 73*/ GIMT_Encode4(157213),
    // Label 0: @898
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 84*/ GIMT_Encode4(10662),
    /*GILLT_s32*//*Label 75*/ GIMT_Encode4(969),
    /*GILLT_s64*//*Label 76*/ GIMT_Encode4(3356), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 77*/ GIMT_Encode4(3418),
    /*GILLT_v2s64*//*Label 78*/ GIMT_Encode4(3968), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 79*/ GIMT_Encode4(5176),
    /*GILLT_v4s32*//*Label 80*/ GIMT_Encode4(5726), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 81*/ GIMT_Encode4(7593),
    /*GILLT_v8s16*//*Label 82*/ GIMT_Encode4(8143), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 83*/ GIMT_Encode4(10010),
    // Label 75: @969
    GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(3355),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1067), // Rule ID 5796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5796,
        GIR_Done,
      // Label 86: @1067
      GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1152), // Rule ID 5797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5797,
        GIR_Done,
      // Label 87: @1152
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1237), // Rule ID 5831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5831,
        GIR_Done,
      // Label 88: @1237
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1322), // Rule ID 5832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5832,
        GIR_Done,
      // Label 89: @1322
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1407), // Rule ID 2018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2018,
        GIR_Done,
      // Label 90: @1407
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1492), // Rule ID 2019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2019,
        GIR_Done,
      // Label 91: @1492
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1577), // Rule ID 2246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2246,
        GIR_Done,
      // Label 92: @1577
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1662), // Rule ID 2247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2247,
        GIR_Done,
      // Label 93: @1662
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1786), // Rule ID 5575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5575,
        GIR_Done,
      // Label 94: @1786
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1910), // Rule ID 5612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5612,
        GIR_Done,
      // Label 95: @1910
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(2034), // Rule ID 192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 192,
        GIR_Done,
      // Label 96: @2034
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(2158), // Rule ID 529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 529,
        GIR_Done,
      // Label 97: @2158
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(2225), // Rule ID 72 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ADDri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 98: @2225
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(2292), // Rule ID 415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ADDri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 99: @2292
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2353), // Rule ID 416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ADDri12),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 100: @2353
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2439), // Rule ID 171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 101: @2439
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2525), // Rule ID 172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 102: @2525
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(2605), // Rule ID 511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 103: @2605
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(2685), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 104: @2685
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2765), // Rule ID 517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 517,
        GIR_Done,
      // Label 105: @2765
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2851), // Rule ID 5569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5569,
        GIR_Done,
      // Label 106: @2851
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2937), // Rule ID 5570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5570,
        GIR_Done,
      // Label 107: @2937
      GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(3017), // Rule ID 5607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5607,
        GIR_Done,
      // Label 108: @3017
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(3097), // Rule ID 5571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5571,
        GIR_Done,
      // Label 109: @3097
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(3177), // Rule ID 5608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5608,
        GIR_Done,
      // Label 110: @3177
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(3236), // Rule ID 73 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ADDrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 111: @3236
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(3295), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 112: @3295
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(3354), // Rule ID 5589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5589,
        GIR_Done,
      // Label 113: @3354
      GIM_Reject,
    // Label 85: @3355
    GIM_Reject,
    // Label 76: @3356
    GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(3417), // Rule ID 779 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv1i64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 779,
      GIR_Done,
    // Label 114: @3417
    GIM_Reject,
    // Label 77: @3418
    GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(3967),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(3519), // Rule ID 5728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 3118:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5728,
        GIR_Done,
      // Label 116: @3519
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(3602), // Rule ID 5734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 3119:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5734,
        GIR_Done,
      // Label 117: @3602
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(3685), // Rule ID 1200 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 3118:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1200,
        GIR_Done,
      // Label 118: @3685
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(3768), // Rule ID 1206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 3119:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1206,
        GIR_Done,
      // Label 119: @3768
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(3843), // Rule ID 5658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5658,
        GIR_Done,
      // Label 120: @3843
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(3918), // Rule ID 906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 906,
        GIR_Done,
      // Label 121: @3918
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(3966), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 775,
        GIR_Done,
      // Label 122: @3966
      GIM_Reject,
    // Label 115: @3967
    GIM_Reject,
    // Label 78: @3968
    GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(5175),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(4083), // Rule ID 5740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 3118:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5740,
        GIR_Done,
      // Label 124: @4083
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(4180), // Rule ID 5743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 3119:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5743,
        GIR_Done,
      // Label 125: @4180
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(4277), // Rule ID 1212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 3118:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1212,
        GIR_Done,
      // Label 126: @4277
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(4374), // Rule ID 1215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 3119:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1215,
        GIR_Done,
      // Label 127: @4374
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(4450), // Rule ID 799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 799,
        GIR_Done,
      // Label 128: @4450
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(4526), // Rule ID 798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 798,
        GIR_Done,
      // Label 129: @4526
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(4602), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 130: @4602
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(4678), // Rule ID 797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 797,
        GIR_Done,
      // Label 131: @4678
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(4754), // Rule ID 796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 796,
        GIR_Done,
      // Label 132: @4754
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(4816), // Rule ID 5637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5637,
        GIR_Done,
      // Label 133: @4816
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(4878), // Rule ID 5631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5631,
        GIR_Done,
      // Label 134: @4878
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(4940), // Rule ID 5636 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5636,
        GIR_Done,
      // Label 135: @4940
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(5002), // Rule ID 808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 808,
        GIR_Done,
      // Label 136: @5002
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(5064), // Rule ID 802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 802,
        GIR_Done,
      // Label 137: @5064
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(5126), // Rule ID 807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 138: @5126
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(5174), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 780,
        GIR_Done,
      // Label 139: @5174
      GIM_Reject,
    // Label 123: @5175
    GIM_Reject,
    // Label 79: @5176
    GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(5725),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(5277), // Rule ID 5727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 3118:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5727,
        GIR_Done,
      // Label 141: @5277
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(5360), // Rule ID 5733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 3119:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5733,
        GIR_Done,
      // Label 142: @5360
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(5443), // Rule ID 1199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 3118:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1199,
        GIR_Done,
      // Label 143: @5443
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(5526), // Rule ID 1205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 3119:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1205,
        GIR_Done,
      // Label 144: @5526
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(5601), // Rule ID 5657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5657,
        GIR_Done,
      // Label 145: @5601
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(5676), // Rule ID 905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 905,
        GIR_Done,
      // Label 146: @5676
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(5724), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 147: @5724
      GIM_Reject,
    // Label 140: @5725
    GIM_Reject,
    // Label 80: @5726
    GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(7592),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(5841), // Rule ID 5739 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 3118:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5739,
        GIR_Done,
      // Label 149: @5841
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(5943), // Rule ID 5742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 3119:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5742,
        GIR_Done,
      // Label 150: @5943
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(6045), // Rule ID 1211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 3118:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1211,
        GIR_Done,
      // Label 151: @6045
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(6147), // Rule ID 1214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 3119:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 152: @6147
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(6235), // Rule ID 5731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 3118:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5731,
        GIR_Done,
      // Label 153: @6235
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(6323), // Rule ID 5737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 3119:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5737,
        GIR_Done,
      // Label 154: @6323
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(6411), // Rule ID 1203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 3118:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1203,
        GIR_Done,
      // Label 155: @6411
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(6499), // Rule ID 1209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 3119:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1209,
        GIR_Done,
      // Label 156: @6499
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(6580), // Rule ID 795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 795,
        GIR_Done,
      // Label 157: @6580
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(6661), // Rule ID 794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 158: @6661
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(6742), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 159: @6742
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(6823), // Rule ID 793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 160: @6823
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(6904), // Rule ID 792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 161: @6904
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(6984), // Rule ID 5661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5661,
        GIR_Done,
      // Label 162: @6984
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(7051), // Rule ID 5635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5635,
        GIR_Done,
      // Label 163: @7051
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(7118), // Rule ID 5630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5630,
        GIR_Done,
      // Label 164: @7118
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(7185), // Rule ID 5634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5634,
        GIR_Done,
      // Label 165: @7185
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(7265), // Rule ID 909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 909,
        GIR_Done,
      // Label 166: @7265
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(7332), // Rule ID 806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 806,
        GIR_Done,
      // Label 167: @7332
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(7399), // Rule ID 801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 801,
        GIR_Done,
      // Label 168: @7399
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(7466), // Rule ID 805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 805,
        GIR_Done,
      // Label 169: @7466
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(7519), // Rule ID 778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 778,
        GIR_Done,
      // Label 170: @7519
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(7591), // Rule ID 3602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3602,
        GIR_Done,
      // Label 171: @7591
      GIM_Reject,
    // Label 148: @7592
    GIM_Reject,
    // Label 81: @7593
    GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(8142),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(7694), // Rule ID 5726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 3118:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5726,
        GIR_Done,
      // Label 173: @7694
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(7777), // Rule ID 5732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 3119:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5732,
        GIR_Done,
      // Label 174: @7777
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(7860), // Rule ID 1198 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 3118:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 175: @7860
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(7943), // Rule ID 1204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 3119:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1204,
        GIR_Done,
      // Label 176: @7943
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(8018), // Rule ID 5656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5656,
        GIR_Done,
      // Label 177: @8018
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(8093), // Rule ID 904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 904,
        GIR_Done,
      // Label 178: @8093
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(8141), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 773,
        GIR_Done,
      // Label 179: @8141
      GIM_Reject,
    // Label 172: @8142
    GIM_Reject,
    // Label 82: @8143
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(10009),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(8258), // Rule ID 5738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 3118:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5738,
        GIR_Done,
      // Label 181: @8258
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(8360), // Rule ID 5741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 3119:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5741,
        GIR_Done,
      // Label 182: @8360
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(8462), // Rule ID 1210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 3118:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 183: @8462
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(8564), // Rule ID 1213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 3119:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABALuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 184: @8564
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(8652), // Rule ID 5730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 3118:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5730,
        GIR_Done,
      // Label 185: @8652
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(8740), // Rule ID 5736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 3119:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5736,
        GIR_Done,
      // Label 186: @8740
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(8828), // Rule ID 1202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 3118:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1202,
        GIR_Done,
      // Label 187: @8828
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(8916), // Rule ID 1208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 3119:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 188: @8916
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(8997), // Rule ID 791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 189: @8997
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(9078), // Rule ID 790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 190: @9078
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(9159), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 785,
        GIR_Done,
      // Label 191: @9159
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(9240), // Rule ID 789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 192: @9240
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(9321), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 193: @9321
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(9401), // Rule ID 5660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5660,
        GIR_Done,
      // Label 194: @9401
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(9468), // Rule ID 5633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5633,
        GIR_Done,
      // Label 195: @9468
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(9535), // Rule ID 5629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5629,
        GIR_Done,
      // Label 196: @9535
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(9602), // Rule ID 5632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5632,
        GIR_Done,
      // Label 197: @9602
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(9682), // Rule ID 908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 908,
        GIR_Done,
      // Label 198: @9682
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(9749), // Rule ID 804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 804,
        GIR_Done,
      // Label 199: @9749
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(9816), // Rule ID 800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 800,
        GIR_Done,
      // Label 200: @9816
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(9883), // Rule ID 803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 803,
        GIR_Done,
      // Label 201: @9883
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(9936), // Rule ID 777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 777,
        GIR_Done,
      // Label 202: @9936
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(10008), // Rule ID 3598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3598,
        GIR_Done,
      // Label 203: @10008
      GIM_Reject,
    // Label 180: @10009
    GIM_Reject,
    // Label 83: @10010
    GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(10661),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(10111), // Rule ID 5729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 3118:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5729,
        GIR_Done,
      // Label 205: @10111
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(10199), // Rule ID 5735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 3119:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5735,
        GIR_Done,
      // Label 206: @10199
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(10287), // Rule ID 1201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabds),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 3118:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAsv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1201,
        GIR_Done,
      // Label 207: @10287
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(10375), // Rule ID 1207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vabdu),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 3119:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VABAuv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1207,
        GIR_Done,
      // Label 208: @10375
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(10455), // Rule ID 5659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5659,
        GIR_Done,
      // Label 209: @10455
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(10535), // Rule ID 907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 907,
        GIR_Done,
      // Label 210: @10535
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(10588), // Rule ID 776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VADDv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 776,
        GIR_Done,
      // Label 211: @10588
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(10660), // Rule ID 3594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3594,
        GIR_Done,
      // Label 212: @10660
      GIM_Reject,
    // Label 204: @10661
    GIM_Reject,
    // Label 84: @10662
    GIM_Reject,
    // Label 1: @10663
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 222*/ GIMT_Encode4(14338),
    /*GILLT_s32*//*Label 213*/ GIMT_Encode4(10734),
    /*GILLT_s64*//*Label 214*/ GIMT_Encode4(11356), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 215*/ GIMT_Encode4(11418),
    /*GILLT_v2s64*//*Label 216*/ GIMT_Encode4(11556), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 217*/ GIMT_Encode4(12190),
    /*GILLT_v4s32*//*Label 218*/ GIMT_Encode4(12328), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 219*/ GIMT_Encode4(13154),
    /*GILLT_v8s16*//*Label 220*/ GIMT_Encode4(13292), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 221*/ GIMT_Encode4(14118),
    // Label 213: @10734
    GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(11355),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(10814), // Rule ID 96 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::RSBri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 96,
        GIR_Done,
      // Label 224: @10814
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(10881), // Rule ID 435 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2RSBri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 435,
        GIR_Done,
      // Label 225: @10881
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(10948), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SUBri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 226: @10948
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(11015), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SUBri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 227: @11015
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(11076), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SUBri12),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 228: @11076
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(11156), // Rule ID 173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MLS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 229: @11156
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(11236), // Rule ID 512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MLS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 512,
        GIR_Done,
      // Label 230: @11236
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(11295), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SUBrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 231: @11295
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(11354), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SUBrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 232: @11354
      GIM_Reject,
    // Label 223: @11355
    GIM_Reject,
    // Label 214: @11356
    GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(11417), // Rule ID 983 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv1i64),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 983,
      GIR_Done,
    // Label 233: @11417
    GIM_Reject,
    // Label 215: @11418
    GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(11555),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(11511), // Rule ID 934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 934,
        GIR_Done,
      // Label 235: @11511
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(11554), // Rule ID 979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 979,
        GIR_Done,
      // Label 236: @11554
      GIM_Reject,
    // Label 234: @11555
    GIM_Reject,
    // Label 216: @11556
    GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(12189),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(11650), // Rule ID 1003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1003,
        GIR_Done,
      // Label 238: @11650
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(11726), // Rule ID 1002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1002,
        GIR_Done,
      // Label 239: @11726
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(11802), // Rule ID 991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 240: @11802
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(11878), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1001,
        GIR_Done,
      // Label 241: @11878
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(11954), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 242: @11954
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(12016), // Rule ID 1012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1012,
        GIR_Done,
      // Label 243: @12016
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(12078), // Rule ID 1006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1006,
        GIR_Done,
      // Label 244: @12078
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(12140), // Rule ID 1011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1011,
        GIR_Done,
      // Label 245: @12140
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(12188), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 246: @12188
      GIM_Reject,
    // Label 237: @12189
    GIM_Reject,
    // Label 217: @12190
    GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(12327),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(12283), // Rule ID 933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 933,
        GIR_Done,
      // Label 248: @12283
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(12326), // Rule ID 978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 978,
        GIR_Done,
      // Label 249: @12326
      GIM_Reject,
    // Label 247: @12327
    GIM_Reject,
    // Label 218: @12328
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(13153),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(12422), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 251: @12422
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(12503), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 252: @12503
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(12584), // Rule ID 990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 253: @12584
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(12665), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 254: @12665
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(12746), // Rule ID 996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 255: @12746
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(12826), // Rule ID 937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 937,
        GIR_Done,
      // Label 256: @12826
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(12893), // Rule ID 1010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1010,
        GIR_Done,
      // Label 257: @12893
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(12960), // Rule ID 1005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 258: @12960
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(13027), // Rule ID 1009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1009,
        GIR_Done,
      // Label 259: @13027
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(13080), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 260: @13080
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(13152), // Rule ID 3614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3614,
        GIR_Done,
      // Label 261: @13152
      GIM_Reject,
    // Label 250: @13153
    GIM_Reject,
    // Label 219: @13154
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(13291),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(13247), // Rule ID 932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 263: @13247
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(13290), // Rule ID 977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 977,
        GIR_Done,
      // Label 264: @13290
      GIM_Reject,
    // Label 262: @13291
    GIM_Reject,
    // Label 220: @13292
    GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(14117),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(13386), // Rule ID 995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 266: @13386
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(13467), // Rule ID 994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 267: @13467
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(13548), // Rule ID 989 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 268: @13548
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(13629), // Rule ID 993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 269: @13629
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(13710), // Rule ID 992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 270: @13710
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(13790), // Rule ID 936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 936,
        GIR_Done,
      // Label 271: @13790
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(13857), // Rule ID 1008 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1008,
        GIR_Done,
      // Label 272: @13857
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(13924), // Rule ID 1004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1004,
        GIR_Done,
      // Label 273: @13924
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(13991), // Rule ID 1007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1007,
        GIR_Done,
      // Label 274: @13991
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(14044), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 275: @14044
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(14116), // Rule ID 3610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3610,
        GIR_Done,
      // Label 276: @14116
      GIM_Reject,
    // Label 265: @14117
    GIM_Reject,
    // Label 221: @14118
    GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(14337),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(14211), // Rule ID 935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMLSv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 935,
        GIR_Done,
      // Label 278: @14211
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(14264), // Rule ID 980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VSUBv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 980,
        GIR_Done,
      // Label 279: @14264
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(14336), // Rule ID 3606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3606,
        GIR_Done,
      // Label 280: @14336
      GIM_Reject,
    // Label 277: @14337
    GIM_Reject,
    // Label 222: @14338
    GIM_Reject,
    // Label 2: @14339
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 288*/ GIMT_Encode4(15396),
    /*GILLT_s32*//*Label 281*/ GIMT_Encode4(14410), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 282*/ GIMT_Encode4(14790), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 283*/ GIMT_Encode4(14852),
    /*GILLT_v4s32*//*Label 284*/ GIMT_Encode4(14914), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 285*/ GIMT_Encode4(15054),
    /*GILLT_v8s16*//*Label 286*/ GIMT_Encode4(15116), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 287*/ GIMT_Encode4(15256),
    // Label 281: @14410
    GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(14789),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(14520), // Rule ID 186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SMULTT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 186,
        GIR_Done,
      // Label 290: @14520
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(14617), // Rule ID 523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SMULTT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 523,
        GIR_Done,
      // Label 291: @14617
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(14676), // Rule ID 169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MUL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 169,
        GIR_Done,
      // Label 292: @14676
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(14735), // Rule ID 170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6_UseMulOps),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MULv5),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 170,
        GIR_Done,
      // Label 293: @14735
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(14788), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MUL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 294: @14788
      GIM_Reject,
    // Label 289: @14789
    GIM_Reject,
    // Label 282: @14790
    GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(14851), // Rule ID 854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv2i32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 854,
      GIR_Done,
    // Label 295: @14851
    GIM_Reject,
    // Label 283: @14852
    GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(14913), // Rule ID 853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv4i16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 853,
      GIR_Done,
    // Label 296: @14913
    GIM_Reject,
    // Label 284: @14914
    GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(15053),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(14980), // Rule ID 857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 857,
        GIR_Done,
      // Label 298: @14980
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(15052), // Rule ID 3572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VMULi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3572,
        GIR_Done,
      // Label 299: @15052
      GIM_Reject,
    // Label 297: @15053
    GIM_Reject,
    // Label 285: @15054
    GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(15115), // Rule ID 852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv8i8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 852,
      GIR_Done,
    // Label 300: @15115
    GIM_Reject,
    // Label 286: @15116
    GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(15255),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(15182), // Rule ID 856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 856,
        GIR_Done,
      // Label 302: @15182
      GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(15254), // Rule ID 3568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VMULi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3568,
        GIR_Done,
      // Label 303: @15254
      GIM_Reject,
    // Label 301: @15255
    GIM_Reject,
    // Label 287: @15256
    GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(15395),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(15322), // Rule ID 855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMULv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 855,
        GIR_Done,
      // Label 305: @15322
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(15394), // Rule ID 3564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VMULi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3564,
        GIR_Done,
      // Label 306: @15394
      GIM_Reject,
    // Label 304: @15395
    GIM_Reject,
    // Label 288: @15396
    GIM_Reject,
    // Label 3: @15397
    GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(15521),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(15467), // Rule ID 195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::SDIV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 195,
        GIR_Done,
      // Label 308: @15467
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(15520), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2SDIV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 309: @15520
      GIM_Reject,
    // Label 307: @15521
    GIM_Reject,
    // Label 4: @15522
    GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(15646),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(15592), // Rule ID 196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UDIV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 311: @15592
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(15645), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UDIV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 541,
        GIR_Done,
      // Label 312: @15645
      GIM_Reject,
    // Label 310: @15646
    GIM_Reject,
    // Label 5: @15647
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 326*/ GIMT_Encode4(19057),
    /*GILLT_s32*//*Label 313*/ GIMT_Encode4(15718),
    /*GILLT_s64*//*Label 314*/ GIMT_Encode4(17761),
    /*GILLT_v2s1*//*Label 315*/ GIMT_Encode4(17823),
    /*GILLT_v2s32*//*Label 316*/ GIMT_Encode4(17945),
    /*GILLT_v2s64*//*Label 317*/ GIMT_Encode4(18007),
    /*GILLT_v4s1*//*Label 318*/ GIMT_Encode4(18147),
    /*GILLT_v4s16*//*Label 319*/ GIMT_Encode4(18269),
    /*GILLT_v4s32*//*Label 320*/ GIMT_Encode4(18331), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 321*/ GIMT_Encode4(18471),
    /*GILLT_v8s8*//*Label 322*/ GIMT_Encode4(18593),
    /*GILLT_v8s16*//*Label 323*/ GIMT_Encode4(18655), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 324*/ GIMT_Encode4(18795),
    /*GILLT_v16s8*//*Label 325*/ GIMT_Encode4(18917),
    // Label 313: @15718
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(17760),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(15811), // Rule ID 1879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1879,
        GIR_Done,
      // Label 328: @15811
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(15891), // Rule ID 2125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2125,
        GIR_Done,
      // Label 329: @15891
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(15949), // Rule ID 2015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2015,
        GIR_Done,
      // Label 330: @15949
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(16007), // Rule ID 2016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2016,
        GIR_Done,
      // Label 331: @16007
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(16065), // Rule ID 2017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2017,
        GIR_Done,
      // Label 332: @16065
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(16123), // Rule ID 2243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2243,
        GIR_Done,
      // Label 333: @16123
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(16181), // Rule ID 2244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2244,
        GIR_Done,
      // Label 334: @16181
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(16239), // Rule ID 2245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2245,
        GIR_Done,
      // Label 335: @16239
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(16328), // Rule ID 5565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5565,
        GIR_Done,
      // Label 336: @16328
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(16417), // Rule ID 5598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5598,
        GIR_Done,
      // Label 337: @16417
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(16506), // Rule ID 5564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5564,
        GIR_Done,
      // Label 338: @16506
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(16595), // Rule ID 5597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5597,
        GIR_Done,
      // Label 339: @16595
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(16684), // Rule ID 5563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5563,
        GIR_Done,
      // Label 340: @16684
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(16773), // Rule ID 5596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5596,
        GIR_Done,
      // Label 341: @16773
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(16862), // Rule ID 159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 159,
        GIR_Done,
      // Label 342: @16862
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(16951), // Rule ID 498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 343: @16951
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(17032), // Rule ID 5566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5566,
        GIR_Done,
      // Label 344: @17032
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(17113), // Rule ID 5599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5599,
        GIR_Done,
      // Label 345: @17113
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(17194), // Rule ID 160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 160,
        GIR_Done,
      // Label 346: @17194
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(17275), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 499,
        GIR_Done,
      // Label 347: @17275
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(17330), // Rule ID 352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::tUXTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 348: @17330
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(17385), // Rule ID 353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::tUXTH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 349: @17385
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(17452), // Rule ID 147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ANDri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 350: @17452
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(17519), // Rule ID 489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ANDri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 351: @17519
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(17580), // Rule ID 163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::BFC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 163,
        GIR_Done,
      // Label 352: @17580
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(17641), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2BFC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 353: @17641
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(17700), // Rule ID 148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ANDrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 354: @17700
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(17759), // Rule ID 490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 490,
        GIR_Done,
      // Label 355: @17759
      GIM_Reject,
    // Label 327: @17760
    GIM_Reject,
    // Label 314: @17761
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(17822), // Rule ID 2532 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VANDd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2532,
      GIR_Done,
    // Label 356: @17822
    GIM_Reject,
    // Label 315: @17823
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(17944), // Rule ID 1850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1850,
      GIR_Done,
    // Label 357: @17944
    GIM_Reject,
    // Label 316: @17945
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(18006), // Rule ID 1150 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1150,
      GIR_Done,
    // Label 358: @18006
    GIM_Reject,
    // Label 317: @18007
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(18146),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(18073), // Rule ID 2535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VANDq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2535,
        GIR_Done,
      // Label 360: @18073
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(18145), // Rule ID 3476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3476,
        GIR_Done,
      // Label 361: @18145
      GIM_Reject,
    // Label 359: @18146
    GIM_Reject,
    // Label 318: @18147
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(18268), // Rule ID 1851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1851,
      GIR_Done,
    // Label 362: @18268
    GIM_Reject,
    // Label 319: @18269
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(18330), // Rule ID 2531 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VANDd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2531,
      GIR_Done,
    // Label 363: @18330
    GIM_Reject,
    // Label 320: @18331
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(18470),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(18397), // Rule ID 1151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1151,
        GIR_Done,
      // Label 365: @18397
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(18469), // Rule ID 3472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3472,
        GIR_Done,
      // Label 366: @18469
      GIM_Reject,
    // Label 364: @18470
    GIM_Reject,
    // Label 321: @18471
    GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(18592), // Rule ID 1852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1852,
      GIR_Done,
    // Label 367: @18592
    GIM_Reject,
    // Label 322: @18593
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(18654), // Rule ID 2530 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VANDd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2530,
      GIR_Done,
    // Label 368: @18654
    GIM_Reject,
    // Label 323: @18655
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(18794),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(18721), // Rule ID 2534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VANDq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2534,
        GIR_Done,
      // Label 370: @18721
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(18793), // Rule ID 3468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3468,
        GIR_Done,
      // Label 371: @18793
      GIM_Reject,
    // Label 369: @18794
    GIM_Reject,
    // Label 324: @18795
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(18916), // Rule ID 1853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1853,
      GIR_Done,
    // Label 372: @18916
    GIM_Reject,
    // Label 325: @18917
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(19056),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(18983), // Rule ID 2533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VANDq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2533,
        GIR_Done,
      // Label 374: @18983
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(19055), // Rule ID 3464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3464,
        GIR_Done,
      // Label 375: @19055
      GIM_Reject,
    // Label 373: @19056
    GIM_Reject,
    // Label 326: @19057
    GIM_Reject,
    // Label 6: @19058
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 389*/ GIMT_Encode4(25512),
    /*GILLT_s32*//*Label 376*/ GIMT_Encode4(19129),
    /*GILLT_s64*//*Label 377*/ GIMT_Encode4(24216),
    /*GILLT_v2s1*//*Label 378*/ GIMT_Encode4(24278),
    /*GILLT_v2s32*//*Label 379*/ GIMT_Encode4(24400),
    /*GILLT_v2s64*//*Label 380*/ GIMT_Encode4(24462),
    /*GILLT_v4s1*//*Label 381*/ GIMT_Encode4(24602),
    /*GILLT_v4s16*//*Label 382*/ GIMT_Encode4(24724),
    /*GILLT_v4s32*//*Label 383*/ GIMT_Encode4(24786), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 384*/ GIMT_Encode4(24926),
    /*GILLT_v8s8*//*Label 385*/ GIMT_Encode4(25048),
    /*GILLT_v8s16*//*Label 386*/ GIMT_Encode4(25110), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 387*/ GIMT_Encode4(25250),
    /*GILLT_v16s8*//*Label 388*/ GIMT_Encode4(25372),
    // Label 376: @19129
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(24215),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(19282), // Rule ID 5781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5781,
        GIR_Done,
      // Label 391: @19282
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(19422), // Rule ID 5823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5823,
        GIR_Done,
      // Label 392: @19422
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(19562), // Rule ID 1942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1942,
        GIR_Done,
      // Label 393: @19562
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(19702), // Rule ID 2212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2212,
        GIR_Done,
      // Label 394: @19702
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(19848), // Rule ID 5579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5579,
        GIR_Done,
      // Label 395: @19848
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(19994), // Rule ID 5616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5616,
        GIR_Done,
      // Label 396: @19994
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(20140), // Rule ID 5786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5786,
        GIR_Done,
      // Label 397: @20140
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(20286), // Rule ID 5828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5828,
        GIR_Done,
      // Label 398: @20286
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(20432), // Rule ID 5578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5578,
        GIR_Done,
      // Label 399: @20432
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(20578), // Rule ID 5615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5615,
        GIR_Done,
      // Label 400: @20578
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(20724), // Rule ID 203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 203,
        GIR_Done,
      // Label 401: @20724
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(20870), // Rule ID 548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 402: @20870
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(21016), // Rule ID 1947 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1947,
        GIR_Done,
      // Label 403: @21016
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(21162), // Rule ID 2217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2217,
        GIR_Done,
      // Label 404: @21162
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(21308), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 405: @21308
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(21454), // Rule ID 547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 406: @21454
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(21568), // Rule ID 1943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1943,
        GIR_Done,
      // Label 407: @21568
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(21682), // Rule ID 2213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2213,
        GIR_Done,
      // Label 408: @21682
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(21796), // Rule ID 5782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5782,
        GIR_Done,
      // Label 409: @21796
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(21910), // Rule ID 5824 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5824,
        GIR_Done,
      // Label 410: @21910
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(22027), // Rule ID 1946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1946,
        GIR_Done,
      // Label 411: @22027
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(22144), // Rule ID 2216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2216,
        GIR_Done,
      // Label 412: @22144
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(22261), // Rule ID 1945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1945,
        GIR_Done,
      // Label 413: @22261
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(22378), // Rule ID 2215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2215,
        GIR_Done,
      // Label 414: @22378
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(22495), // Rule ID 1944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1944,
        GIR_Done,
      // Label 415: @22495
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(22612), // Rule ID 2214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2214,
        GIR_Done,
      // Label 416: @22612
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(22729), // Rule ID 5785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5785,
        GIR_Done,
      // Label 417: @22729
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(22846), // Rule ID 5827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5827,
        GIR_Done,
      // Label 418: @22846
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(22963), // Rule ID 5784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5784,
        GIR_Done,
      // Label 419: @22963
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(23080), // Rule ID 5826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5826,
        GIR_Done,
      // Label 420: @23080
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(23197), // Rule ID 5783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5783,
        GIR_Done,
      // Label 421: @23197
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(23314), // Rule ID 5825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5825,
        GIR_Done,
      // Label 422: @23314
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(23403), // Rule ID 5603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5603,
        GIR_Done,
      // Label 423: @23403
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(23492), // Rule ID 5602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5602,
        GIR_Done,
      // Label 424: @23492
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(23581), // Rule ID 5601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5601,
        GIR_Done,
      // Label 425: @23581
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(23670), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 426: @23670
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(23751), // Rule ID 5604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5604,
        GIR_Done,
      // Label 427: @23751
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(23832), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 428: @23832
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(23897), // Rule ID 1872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MOVTi16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1872,
        GIR_Done,
      // Label 429: @23897
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(23962), // Rule ID 2107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MOVTi16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2107,
        GIR_Done,
      // Label 430: @23962
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(24029), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ORRri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 151,
        GIR_Done,
      // Label 431: @24029
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(24096), // Rule ID 492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORRri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 432: @24096
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(24155), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::ORRrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 152,
        GIR_Done,
      // Label 433: @24155
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(24214), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 434: @24214
      GIM_Reject,
    // Label 390: @24215
    GIM_Reject,
    // Label 377: @24216
    GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(24277), // Rule ID 2538 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VORRd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2538,
      GIR_Done,
    // Label 435: @24277
    GIM_Reject,
    // Label 378: @24278
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(24399), // Rule ID 1858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1858,
      GIR_Done,
    // Label 436: @24399
    GIM_Reject,
    // Label 379: @24400
    GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(24461), // Rule ID 1154 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1154,
      GIR_Done,
    // Label 437: @24461
    GIM_Reject,
    // Label 380: @24462
    GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(24601),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(24528), // Rule ID 2541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VORRq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2541,
        GIR_Done,
      // Label 439: @24528
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(24600), // Rule ID 3490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3490,
        GIR_Done,
      // Label 440: @24600
      GIM_Reject,
    // Label 438: @24601
    GIM_Reject,
    // Label 381: @24602
    GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(24723), // Rule ID 1859 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1859,
      GIR_Done,
    // Label 441: @24723
    GIM_Reject,
    // Label 382: @24724
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(24785), // Rule ID 2537 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VORRd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2537,
      GIR_Done,
    // Label 442: @24785
    GIM_Reject,
    // Label 383: @24786
    GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(24925),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(24852), // Rule ID 1155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 444: @24852
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(24924), // Rule ID 3486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3486,
        GIR_Done,
      // Label 445: @24924
      GIM_Reject,
    // Label 443: @24925
    GIM_Reject,
    // Label 384: @24926
    GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(25047), // Rule ID 1860 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1860,
      GIR_Done,
    // Label 446: @25047
    GIM_Reject,
    // Label 385: @25048
    GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(25109), // Rule ID 2536 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VORRd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2536,
      GIR_Done,
    // Label 447: @25109
    GIM_Reject,
    // Label 386: @25110
    GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(25249),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(25176), // Rule ID 2540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VORRq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2540,
        GIR_Done,
      // Label 449: @25176
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(25248), // Rule ID 3482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3482,
        GIR_Done,
      // Label 450: @25248
      GIM_Reject,
    // Label 448: @25249
    GIM_Reject,
    // Label 387: @25250
    GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(25371), // Rule ID 1861 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1861,
      GIR_Done,
    // Label 451: @25371
    GIM_Reject,
    // Label 388: @25372
    GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(25511),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(25438), // Rule ID 2539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VORRq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2539,
        GIR_Done,
      // Label 453: @25438
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(25510), // Rule ID 3478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3478,
        GIR_Done,
      // Label 454: @25510
      GIM_Reject,
    // Label 452: @25511
    GIM_Reject,
    // Label 389: @25512
    GIM_Reject,
    // Label 7: @25513
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 468*/ GIMT_Encode4(27379),
    /*GILLT_s32*//*Label 455*/ GIMT_Encode4(25584),
    /*GILLT_s64*//*Label 456*/ GIMT_Encode4(26083),
    /*GILLT_v2s1*//*Label 457*/ GIMT_Encode4(26145),
    /*GILLT_v2s32*//*Label 458*/ GIMT_Encode4(26267),
    /*GILLT_v2s64*//*Label 459*/ GIMT_Encode4(26329),
    /*GILLT_v4s1*//*Label 460*/ GIMT_Encode4(26469),
    /*GILLT_v4s16*//*Label 461*/ GIMT_Encode4(26591),
    /*GILLT_v4s32*//*Label 462*/ GIMT_Encode4(26653), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 463*/ GIMT_Encode4(26793),
    /*GILLT_v8s8*//*Label 464*/ GIMT_Encode4(26915),
    /*GILLT_v8s16*//*Label 465*/ GIMT_Encode4(26977), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 466*/ GIMT_Encode4(27117),
    /*GILLT_v16s8*//*Label 467*/ GIMT_Encode4(27239),
    // Label 455: @25584
    GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(26082),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(25659), // Rule ID 5606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 5606,
        GIR_Done,
      // Label 470: @25659
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(25721), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 471: @25721
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(25775), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2MVNr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 472: @25775
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(25829), // Rule ID 165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVNr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 473: @25829
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(25896), // Rule ID 155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::EORri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 155,
        GIR_Done,
      // Label 474: @25896
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(25963), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2EORri),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 475: @25963
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(26022), // Rule ID 156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::EORrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 156,
        GIR_Done,
      // Label 476: @26022
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(26081), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 477: @26081
      GIM_Reject,
    // Label 469: @26082
    GIM_Reject,
    // Label 456: @26083
    GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(26144), // Rule ID 2544 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VEORd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2544,
      GIR_Done,
    // Label 478: @26144
    GIM_Reject,
    // Label 457: @26145
    GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(26266), // Rule ID 1854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1854,
      GIR_Done,
    // Label 479: @26266
    GIM_Reject,
    // Label 458: @26267
    GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(26328), // Rule ID 1152 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1152,
      GIR_Done,
    // Label 480: @26328
    GIM_Reject,
    // Label 459: @26329
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(26468),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(26395), // Rule ID 2547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VEORq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2547,
        GIR_Done,
      // Label 482: @26395
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(26467), // Rule ID 3504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3504,
        GIR_Done,
      // Label 483: @26467
      GIM_Reject,
    // Label 481: @26468
    GIM_Reject,
    // Label 460: @26469
    GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(26590), // Rule ID 1855 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1855,
      GIR_Done,
    // Label 484: @26590
    GIM_Reject,
    // Label 461: @26591
    GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(26652), // Rule ID 2543 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VEORd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2543,
      GIR_Done,
    // Label 485: @26652
    GIM_Reject,
    // Label 462: @26653
    GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(26792),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(26719), // Rule ID 1153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1153,
        GIR_Done,
      // Label 487: @26719
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(26791), // Rule ID 3500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3500,
        GIR_Done,
      // Label 488: @26791
      GIM_Reject,
    // Label 486: @26792
    GIM_Reject,
    // Label 463: @26793
    GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(26914), // Rule ID 1856 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1856,
      GIR_Done,
    // Label 489: @26914
    GIM_Reject,
    // Label 464: @26915
    GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(26976), // Rule ID 2542 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VEORd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2542,
      GIR_Done,
    // Label 490: @26976
    GIM_Reject,
    // Label 465: @26977
    GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(27116),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(27043), // Rule ID 2546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VEORq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2546,
        GIR_Done,
      // Label 492: @27043
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(27115), // Rule ID 3496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3496,
        GIR_Done,
      // Label 493: @27115
      GIM_Reject,
    // Label 491: @27116
    GIM_Reject,
    // Label 466: @27117
    GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(27238), // Rule ID 1857 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1857,
      GIR_Done,
    // Label 494: @27238
    GIM_Reject,
    // Label 467: @27239
    GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(27378),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(27305), // Rule ID 2545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VEORq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2545,
        GIR_Done,
      // Label 496: @27305
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(27377), // Rule ID 3492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3492,
        GIR_Done,
      // Label 497: @27377
      GIM_Reject,
    // Label 495: @27378
    GIM_Reject,
    // Label 468: @27379
    GIM_Reject,
    // Label 8: @27380
    GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(27888),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(5), GIMT_Encode2(16), /*)*//*default:*//*Label 503*/ GIMT_Encode4(27887),
      /*GILLT_v2s64*//*Label 499*/ GIMT_Encode4(27443), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v4s32*//*Label 500*/ GIMT_Encode4(27515), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v8s16*//*Label 501*/ GIMT_Encode4(27641), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v16s8*//*Label 502*/ GIMT_Encode4(27815),
      // Label 499: @27443
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(27514), // Rule ID 3125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Dn, DPR:{ *:[v1i64] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v2i64] } QPR:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3125,
        GIR_Done,
      // Label 504: @27514
      GIM_Reject,
      // Label 500: @27515
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(27640),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(27591), // Rule ID 3126 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4i32] } DPR:{ *:[v2i32] }:$Dn, DPR:{ *:[v2i32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4i32] } QPR:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 3126,
          GIR_Done,
        // Label 506: @27591
        GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(27639), // Rule ID 3129 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4f32] } DPR:{ *:[v2f32] }:$Dn, DPR:{ *:[v2f32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4f32] } QPR:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 3129,
          GIR_Done,
        // Label 507: @27639
        GIM_Reject,
      // Label 505: @27640
      GIM_Reject,
      // Label 501: @27641
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(27814),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(27717), // Rule ID 3127 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8i16] } DPR:{ *:[v4i16] }:$Dn, DPR:{ *:[v4i16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8i16] } QPR:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 3127,
          GIR_Done,
        // Label 509: @27717
        GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(27765), // Rule ID 3130 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8f16] } DPR:{ *:[v4f16] }:$Dn, DPR:{ *:[v4f16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8f16] } QPR:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 3130,
          GIR_Done,
        // Label 510: @27765
        GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(27813), // Rule ID 3131 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8bf16] } DPR:{ *:[v4bf16] }:$Dn, DPR:{ *:[v4bf16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8bf16] } QPR:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 3131,
          GIR_Done,
        // Label 511: @27813
        GIM_Reject,
      // Label 508: @27814
      GIM_Reject,
      // Label 502: @27815
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(27886), // Rule ID 3128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v16i8] } DPR:{ *:[v8i8] }:$Dn, DPR:{ *:[v8i8] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v16i8] } QPR:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 3128,
        GIR_Done,
      // Label 512: @27886
      GIM_Reject,
      // Label 503: @27887
      GIM_Reject,
    // Label 498: @27888
    GIM_Reject,
    // Label 9: @27889
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 522*/ GIMT_Encode4(41272),
    /*GILLT_s32*//*Label 513*/ GIMT_Encode4(27960),
    /*GILLT_s64*//*Label 514*/ GIMT_Encode4(28136), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 515*/ GIMT_Encode4(29301),
    /*GILLT_v2s64*//*Label 516*/ GIMT_Encode4(30466), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 517*/ GIMT_Encode4(32805),
    /*GILLT_v4s32*//*Label 518*/ GIMT_Encode4(34324), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 519*/ GIMT_Encode4(36663),
    /*GILLT_v8s16*//*Label 520*/ GIMT_Encode4(37294), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 521*/ GIMT_Encode4(39987),
    // Label 513: @27960
    GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(28135),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(28013), // Rule ID 706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMOVRS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 706,
        GIR_Done,
      // Label 524: @28013
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(28057), // Rule ID 707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs_UseVMOVSR),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VMOVSR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sn]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rt
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 707,
        GIR_Done,
      // Label 525: @28057
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(28134), // Rule ID 2745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseVMOVSR_HasNEON),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$a)  =>  (EXTRACT_SUBREG:{ *:[f32] } (VMOVDRR:{ *:[f64] } GPR:{ *:[i32] }:$a, GPR:{ *:[i32] }:$a), ssub_0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::VMOVDRR),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPR_VFP2RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2745,
        GIR_Done,
      // Label 526: @28134
      GIM_Reject,
    // Label 523: @28135
    GIM_Reject,
    // Label 514: @28136
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(28178), // Rule ID 2747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2747,
      GIR_Done,
    // Label 527: @28178
    GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(28220), // Rule ID 2748 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2748,
      GIR_Done,
    // Label 528: @28220
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(28262), // Rule ID 2763 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2763,
      GIR_Done,
    // Label 529: @28262
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(28304), // Rule ID 2764 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2764,
      GIR_Done,
    // Label 530: @28304
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(28346), // Rule ID 2765 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2765,
      GIR_Done,
    // Label 531: @28346
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(28388), // Rule ID 2766 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2766,
      GIR_Done,
    // Label 532: @28388
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(28430), // Rule ID 2767 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2767,
      GIR_Done,
    // Label 533: @28430
    GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(28472), // Rule ID 2768 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2768,
      GIR_Done,
    // Label 534: @28472
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(28514), // Rule ID 2769 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2769,
      GIR_Done,
    // Label 535: @28514
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(28556), // Rule ID 2770 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2770,
      GIR_Done,
    // Label 536: @28556
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(28598), // Rule ID 2771 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2771,
      GIR_Done,
    // Label 537: @28598
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(28640), // Rule ID 2772 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2772,
      GIR_Done,
    // Label 538: @28640
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(28682), // Rule ID 2773 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2773,
      GIR_Done,
    // Label 539: @28682
    GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(28724), // Rule ID 2774 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2774,
      GIR_Done,
    // Label 540: @28724
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(28772), // Rule ID 2855 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2855,
      GIR_Done,
    // Label 541: @28772
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(28820), // Rule ID 2856 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2856,
      GIR_Done,
    // Label 542: @28820
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(28868), // Rule ID 2857 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2857,
      GIR_Done,
    // Label 543: @28868
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(28916), // Rule ID 2858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2858,
      GIR_Done,
    // Label 544: @28916
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(28964), // Rule ID 2859 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2859,
      GIR_Done,
    // Label 545: @28964
    GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(29012), // Rule ID 2860 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2860,
      GIR_Done,
    // Label 546: @29012
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(29060), // Rule ID 2861 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2861,
      GIR_Done,
    // Label 547: @29060
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(29108), // Rule ID 2862 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2862,
      GIR_Done,
    // Label 548: @29108
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(29156), // Rule ID 2863 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2863,
      GIR_Done,
    // Label 549: @29156
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(29204), // Rule ID 2864 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2864,
      GIR_Done,
    // Label 550: @29204
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(29252), // Rule ID 2865 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2865,
      GIR_Done,
    // Label 551: @29252
    GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(29300), // Rule ID 2866 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2866,
      GIR_Done,
    // Label 552: @29300
    GIM_Reject,
    // Label 515: @29301
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(29343), // Rule ID 2749 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2749,
      GIR_Done,
    // Label 553: @29343
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(29385), // Rule ID 2750 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2750,
      GIR_Done,
    // Label 554: @29385
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(29427), // Rule ID 2775 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2775,
      GIR_Done,
    // Label 555: @29427
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(29469), // Rule ID 2776 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2776,
      GIR_Done,
    // Label 556: @29469
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(29511), // Rule ID 2777 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2777,
      GIR_Done,
    // Label 557: @29511
    GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(29553), // Rule ID 2778 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2778,
      GIR_Done,
    // Label 558: @29553
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(29595), // Rule ID 2779 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2779,
      GIR_Done,
    // Label 559: @29595
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(29637), // Rule ID 2780 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2780,
      GIR_Done,
    // Label 560: @29637
    GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(29679), // Rule ID 2781 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2781,
      GIR_Done,
    // Label 561: @29679
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(29721), // Rule ID 2782 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2782,
      GIR_Done,
    // Label 562: @29721
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(29763), // Rule ID 2783 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2783,
      GIR_Done,
    // Label 563: @29763
    GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(29805), // Rule ID 2784 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2784,
      GIR_Done,
    // Label 564: @29805
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(29847), // Rule ID 2785 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2785,
      GIR_Done,
    // Label 565: @29847
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(29889), // Rule ID 2786 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2786,
      GIR_Done,
    // Label 566: @29889
    GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(29937), // Rule ID 2867 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2867,
      GIR_Done,
    // Label 567: @29937
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(29985), // Rule ID 2868 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2868,
      GIR_Done,
    // Label 568: @29985
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(30033), // Rule ID 2869 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2869,
      GIR_Done,
    // Label 569: @30033
    GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(30081), // Rule ID 2870 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2870,
      GIR_Done,
    // Label 570: @30081
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(30129), // Rule ID 2871 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2871,
      GIR_Done,
    // Label 571: @30129
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(30177), // Rule ID 2872 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2872,
      GIR_Done,
    // Label 572: @30177
    GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(30225), // Rule ID 2873 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2873,
      GIR_Done,
    // Label 573: @30225
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(30273), // Rule ID 2874 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2874,
      GIR_Done,
    // Label 574: @30273
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(30321), // Rule ID 2875 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2875,
      GIR_Done,
    // Label 575: @30321
    GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(30369), // Rule ID 2876 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2876,
      GIR_Done,
    // Label 576: @30369
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(30417), // Rule ID 2877 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2877,
      GIR_Done,
    // Label 577: @30417
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(30465), // Rule ID 2878 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2878,
      GIR_Done,
    // Label 578: @30465
    GIM_Reject,
    // Label 516: @30466
    GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(30508), // Rule ID 2755 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2755,
      GIR_Done,
    // Label 579: @30508
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(30550), // Rule ID 2756 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2756,
      GIR_Done,
    // Label 580: @30550
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(30592), // Rule ID 2809 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2809,
      GIR_Done,
    // Label 581: @30592
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(30634), // Rule ID 2810 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2810,
      GIR_Done,
    // Label 582: @30634
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(30676), // Rule ID 2811 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2811,
      GIR_Done,
    // Label 583: @30676
    GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(30718), // Rule ID 2812 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2812,
      GIR_Done,
    // Label 584: @30718
    GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(30760), // Rule ID 2813 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2813,
      GIR_Done,
    // Label 585: @30760
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(30802), // Rule ID 2814 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2814,
      GIR_Done,
    // Label 586: @30802
    GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(30844), // Rule ID 2815 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2815,
      GIR_Done,
    // Label 587: @30844
    GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(30886), // Rule ID 2816 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2816,
      GIR_Done,
    // Label 588: @30886
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(30928), // Rule ID 2817 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2817,
      GIR_Done,
    // Label 589: @30928
    GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(30970), // Rule ID 2818 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2818,
      GIR_Done,
    // Label 590: @30970
    GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(31012), // Rule ID 2819 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2819,
      GIR_Done,
    // Label 591: @31012
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(31054), // Rule ID 2820 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2820,
      GIR_Done,
    // Label 592: @31054
    GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(31102), // Rule ID 2901 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2901,
      GIR_Done,
    // Label 593: @31102
    GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(31150), // Rule ID 2902 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2902,
      GIR_Done,
    // Label 594: @31150
    GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(31198), // Rule ID 2903 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2903,
      GIR_Done,
    // Label 595: @31198
    GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(31246), // Rule ID 2904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2904,
      GIR_Done,
    // Label 596: @31246
    GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(31294), // Rule ID 2905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2905,
      GIR_Done,
    // Label 597: @31294
    GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(31342), // Rule ID 2906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2906,
      GIR_Done,
    // Label 598: @31342
    GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(31390), // Rule ID 2907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2907,
      GIR_Done,
    // Label 599: @31390
    GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(31438), // Rule ID 2908 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2908,
      GIR_Done,
    // Label 600: @31438
    GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(31486), // Rule ID 2909 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2909,
      GIR_Done,
    // Label 601: @31486
    GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(31534), // Rule ID 2910 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2910,
      GIR_Done,
    // Label 602: @31534
    GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(31582), // Rule ID 2911 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2911,
      GIR_Done,
    // Label 603: @31582
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(31630), // Rule ID 2912 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2912,
      GIR_Done,
    // Label 604: @31630
    GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(31672), // Rule ID 5409 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5409,
      GIR_Done,
    // Label 605: @31672
    GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(31714), // Rule ID 5410 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5410,
      GIR_Done,
    // Label 606: @31714
    GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(31756), // Rule ID 5415 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5415,
      GIR_Done,
    // Label 607: @31756
    GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(31798), // Rule ID 5416 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5416,
      GIR_Done,
    // Label 608: @31798
    GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(31840), // Rule ID 5417 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5417,
      GIR_Done,
    // Label 609: @31840
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(31882), // Rule ID 5418 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5418,
      GIR_Done,
    // Label 610: @31882
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(31924), // Rule ID 5419 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5419,
      GIR_Done,
    // Label 611: @31924
    GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(31966), // Rule ID 5420 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5420,
      GIR_Done,
    // Label 612: @31966
    GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(32008), // Rule ID 5421 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5421,
      GIR_Done,
    // Label 613: @32008
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(32050), // Rule ID 5422 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5422,
      GIR_Done,
    // Label 614: @32050
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(32092), // Rule ID 5423 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5423,
      GIR_Done,
    // Label 615: @32092
    GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(32134), // Rule ID 5424 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5424,
      GIR_Done,
    // Label 616: @32134
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(32201), // Rule ID 5451 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5451,
      GIR_Done,
    // Label 617: @32201
    GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(32268), // Rule ID 5452 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5452,
      GIR_Done,
    // Label 618: @32268
    GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(32335), // Rule ID 5453 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5453,
      GIR_Done,
    // Label 619: @32335
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(32402), // Rule ID 5454 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5454,
      GIR_Done,
    // Label 620: @32402
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(32469), // Rule ID 5455 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5455,
      GIR_Done,
    // Label 621: @32469
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(32536), // Rule ID 5456 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5456,
      GIR_Done,
    // Label 622: @32536
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(32603), // Rule ID 5457 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5457,
      GIR_Done,
    // Label 623: @32603
    GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(32670), // Rule ID 5458 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5458,
      GIR_Done,
    // Label 624: @32670
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(32737), // Rule ID 5459 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5459,
      GIR_Done,
    // Label 625: @32737
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(32804), // Rule ID 5460 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5460,
      GIR_Done,
    // Label 626: @32804
    GIM_Reject,
    // Label 517: @32805
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(32847), // Rule ID 2751 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2751,
      GIR_Done,
    // Label 627: @32847
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(32889), // Rule ID 2752 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2752,
      GIR_Done,
    // Label 628: @32889
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(32931), // Rule ID 2753 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2753,
      GIR_Done,
    // Label 629: @32931
    GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(32973), // Rule ID 2754 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2754,
      GIR_Done,
    // Label 630: @32973
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(33015), // Rule ID 2787 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2787,
      GIR_Done,
    // Label 631: @33015
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(33057), // Rule ID 2788 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2788,
      GIR_Done,
    // Label 632: @33057
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(33099), // Rule ID 2789 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2789,
      GIR_Done,
    // Label 633: @33099
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(33141), // Rule ID 2790 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2790,
      GIR_Done,
    // Label 634: @33141
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(33183), // Rule ID 2791 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2791,
      GIR_Done,
    // Label 635: @33183
    GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(33225), // Rule ID 2792 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2792,
      GIR_Done,
    // Label 636: @33225
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(33267), // Rule ID 2793 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2793,
      GIR_Done,
    // Label 637: @33267
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(33309), // Rule ID 2794 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2794,
      GIR_Done,
    // Label 638: @33309
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(33351), // Rule ID 2795 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2795,
      GIR_Done,
    // Label 639: @33351
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(33393), // Rule ID 2796 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2796,
      GIR_Done,
    // Label 640: @33393
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(33435), // Rule ID 2797 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2797,
      GIR_Done,
    // Label 641: @33435
    GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(33477), // Rule ID 2798 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2798,
      GIR_Done,
    // Label 642: @33477
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(33519), // Rule ID 2799 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2799,
      GIR_Done,
    // Label 643: @33519
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(33561), // Rule ID 2800 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2800,
      GIR_Done,
    // Label 644: @33561
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(33603), // Rule ID 2801 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2801,
      GIR_Done,
    // Label 645: @33603
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(33651), // Rule ID 2879 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2879,
      GIR_Done,
    // Label 646: @33651
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(33699), // Rule ID 2880 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2880,
      GIR_Done,
    // Label 647: @33699
    GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(33747), // Rule ID 2881 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2881,
      GIR_Done,
    // Label 648: @33747
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(33795), // Rule ID 2882 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2882,
      GIR_Done,
    // Label 649: @33795
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(33843), // Rule ID 2883 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2883,
      GIR_Done,
    // Label 650: @33843
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(33891), // Rule ID 2884 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2884,
      GIR_Done,
    // Label 651: @33891
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(33939), // Rule ID 2885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2885,
      GIR_Done,
    // Label 652: @33939
    GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(33987), // Rule ID 2886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2886,
      GIR_Done,
    // Label 653: @33987
    GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(34035), // Rule ID 2887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2887,
      GIR_Done,
    // Label 654: @34035
    GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(34083), // Rule ID 2888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2888,
      GIR_Done,
    // Label 655: @34083
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(34131), // Rule ID 2889 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2889,
      GIR_Done,
    // Label 656: @34131
    GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(34179), // Rule ID 2890 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2890,
      GIR_Done,
    // Label 657: @34179
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(34227), // Rule ID 2891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2891,
      GIR_Done,
    // Label 658: @34227
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(34275), // Rule ID 2892 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2892,
      GIR_Done,
    // Label 659: @34275
    GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(34323), // Rule ID 2893 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2893,
      GIR_Done,
    // Label 660: @34323
    GIM_Reject,
    // Label 518: @34324
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(34366), // Rule ID 2757 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2757,
      GIR_Done,
    // Label 661: @34366
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(34408), // Rule ID 2758 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2758,
      GIR_Done,
    // Label 662: @34408
    GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(34450), // Rule ID 2821 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2821,
      GIR_Done,
    // Label 663: @34450
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(34492), // Rule ID 2822 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2822,
      GIR_Done,
    // Label 664: @34492
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(34534), // Rule ID 2823 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2823,
      GIR_Done,
    // Label 665: @34534
    GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(34576), // Rule ID 2824 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2824,
      GIR_Done,
    // Label 666: @34576
    GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(34618), // Rule ID 2825 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2825,
      GIR_Done,
    // Label 667: @34618
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(34660), // Rule ID 2826 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2826,
      GIR_Done,
    // Label 668: @34660
    GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(34702), // Rule ID 2827 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2827,
      GIR_Done,
    // Label 669: @34702
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(34744), // Rule ID 2828 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2828,
      GIR_Done,
    // Label 670: @34744
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(34786), // Rule ID 2829 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2829,
      GIR_Done,
    // Label 671: @34786
    GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(34828), // Rule ID 2830 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2830,
      GIR_Done,
    // Label 672: @34828
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(34870), // Rule ID 2831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2831,
      GIR_Done,
    // Label 673: @34870
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(34912), // Rule ID 2832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2832,
      GIR_Done,
    // Label 674: @34912
    GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(34960), // Rule ID 2913 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2913,
      GIR_Done,
    // Label 675: @34960
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(35008), // Rule ID 2914 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2914,
      GIR_Done,
    // Label 676: @35008
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(35056), // Rule ID 2915 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2915,
      GIR_Done,
    // Label 677: @35056
    GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(35104), // Rule ID 2916 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2916,
      GIR_Done,
    // Label 678: @35104
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(35152), // Rule ID 2917 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2917,
      GIR_Done,
    // Label 679: @35152
    GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(35200), // Rule ID 2918 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2918,
      GIR_Done,
    // Label 680: @35200
    GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(35248), // Rule ID 2919 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2919,
      GIR_Done,
    // Label 681: @35248
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(35296), // Rule ID 2920 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2920,
      GIR_Done,
    // Label 682: @35296
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(35344), // Rule ID 2921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2921,
      GIR_Done,
    // Label 683: @35344
    GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(35392), // Rule ID 2922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2922,
      GIR_Done,
    // Label 684: @35392
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(35440), // Rule ID 2923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2923,
      GIR_Done,
    // Label 685: @35440
    GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(35488), // Rule ID 2924 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2924,
      GIR_Done,
    // Label 686: @35488
    GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(35530), // Rule ID 5411 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5411,
      GIR_Done,
    // Label 687: @35530
    GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(35572), // Rule ID 5412 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5412,
      GIR_Done,
    // Label 688: @35572
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(35614), // Rule ID 5425 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5425,
      GIR_Done,
    // Label 689: @35614
    GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(35656), // Rule ID 5426 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5426,
      GIR_Done,
    // Label 690: @35656
    GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(35698), // Rule ID 5427 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5427,
      GIR_Done,
    // Label 691: @35698
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(35740), // Rule ID 5428 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5428,
      GIR_Done,
    // Label 692: @35740
    GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(35782), // Rule ID 5429 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5429,
      GIR_Done,
    // Label 693: @35782
    GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(35824), // Rule ID 5430 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5430,
      GIR_Done,
    // Label 694: @35824
    GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(35866), // Rule ID 5431 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5431,
      GIR_Done,
    // Label 695: @35866
    GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(35908), // Rule ID 5432 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5432,
      GIR_Done,
    // Label 696: @35908
    GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(35950), // Rule ID 5433 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5433,
      GIR_Done,
    // Label 697: @35950
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(35992), // Rule ID 5434 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5434,
      GIR_Done,
    // Label 698: @35992
    GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(36059), // Rule ID 5461 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5461,
      GIR_Done,
    // Label 699: @36059
    GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(36126), // Rule ID 5462 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5462,
      GIR_Done,
    // Label 700: @36126
    GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(36193), // Rule ID 5463 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5463,
      GIR_Done,
    // Label 701: @36193
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(36260), // Rule ID 5464 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5464,
      GIR_Done,
    // Label 702: @36260
    GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(36327), // Rule ID 5465 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5465,
      GIR_Done,
    // Label 703: @36327
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(36394), // Rule ID 5466 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5466,
      GIR_Done,
    // Label 704: @36394
    GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(36461), // Rule ID 5467 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5467,
      GIR_Done,
    // Label 705: @36461
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(36528), // Rule ID 5468 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5468,
      GIR_Done,
    // Label 706: @36528
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(36595), // Rule ID 5469 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5469,
      GIR_Done,
    // Label 707: @36595
    GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(36662), // Rule ID 5470 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5470,
      GIR_Done,
    // Label 708: @36662
    GIM_Reject,
    // Label 519: @36663
    GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(36705), // Rule ID 2802 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2802,
      GIR_Done,
    // Label 709: @36705
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(36747), // Rule ID 2803 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2803,
      GIR_Done,
    // Label 710: @36747
    GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(36789), // Rule ID 2804 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2804,
      GIR_Done,
    // Label 711: @36789
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(36831), // Rule ID 2805 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2805,
      GIR_Done,
    // Label 712: @36831
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(36873), // Rule ID 2806 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2806,
      GIR_Done,
    // Label 713: @36873
    GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(36915), // Rule ID 2807 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2807,
      GIR_Done,
    // Label 714: @36915
    GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(36957), // Rule ID 2808 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2808,
      GIR_Done,
    // Label 715: @36957
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(37005), // Rule ID 2894 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2894,
      GIR_Done,
    // Label 716: @37005
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(37053), // Rule ID 2895 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2895,
      GIR_Done,
    // Label 717: @37053
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(37101), // Rule ID 2896 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2896,
      GIR_Done,
    // Label 718: @37101
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(37149), // Rule ID 2897 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2897,
      GIR_Done,
    // Label 719: @37149
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(37197), // Rule ID 2898 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2898,
      GIR_Done,
    // Label 720: @37197
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(37245), // Rule ID 2899 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2899,
      GIR_Done,
    // Label 721: @37245
    GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(37293), // Rule ID 2900 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2900,
      GIR_Done,
    // Label 722: @37293
    GIM_Reject,
    // Label 520: @37294
    GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(37336), // Rule ID 2759 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2759,
      GIR_Done,
    // Label 723: @37336
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(37378), // Rule ID 2760 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2760,
      GIR_Done,
    // Label 724: @37378
    GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(37420), // Rule ID 2761 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2761,
      GIR_Done,
    // Label 725: @37420
    GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(37462), // Rule ID 2762 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2762,
      GIR_Done,
    // Label 726: @37462
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(37504), // Rule ID 2833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2833,
      GIR_Done,
    // Label 727: @37504
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(37546), // Rule ID 2834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2834,
      GIR_Done,
    // Label 728: @37546
    GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(37588), // Rule ID 2835 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2835,
      GIR_Done,
    // Label 729: @37588
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(37630), // Rule ID 2836 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2836,
      GIR_Done,
    // Label 730: @37630
    GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(37672), // Rule ID 2837 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2837,
      GIR_Done,
    // Label 731: @37672
    GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(37714), // Rule ID 2838 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2838,
      GIR_Done,
    // Label 732: @37714
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(37756), // Rule ID 2839 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2839,
      GIR_Done,
    // Label 733: @37756
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(37798), // Rule ID 2840 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2840,
      GIR_Done,
    // Label 734: @37798
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(37840), // Rule ID 2841 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2841,
      GIR_Done,
    // Label 735: @37840
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(37882), // Rule ID 2842 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2842,
      GIR_Done,
    // Label 736: @37882
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(37924), // Rule ID 2843 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2843,
      GIR_Done,
    // Label 737: @37924
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(37966), // Rule ID 2844 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2844,
      GIR_Done,
    // Label 738: @37966
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(38008), // Rule ID 2845 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2845,
      GIR_Done,
    // Label 739: @38008
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(38050), // Rule ID 2846 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2846,
      GIR_Done,
    // Label 740: @38050
    GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(38092), // Rule ID 2847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2847,
      GIR_Done,
    // Label 741: @38092
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(38140), // Rule ID 2925 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2925,
      GIR_Done,
    // Label 742: @38140
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(38188), // Rule ID 2926 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2926,
      GIR_Done,
    // Label 743: @38188
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(38236), // Rule ID 2927 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2927,
      GIR_Done,
    // Label 744: @38236
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(38284), // Rule ID 2928 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2928,
      GIR_Done,
    // Label 745: @38284
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(38332), // Rule ID 2929 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2929,
      GIR_Done,
    // Label 746: @38332
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(38380), // Rule ID 2930 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2930,
      GIR_Done,
    // Label 747: @38380
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(38428), // Rule ID 2931 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2931,
      GIR_Done,
    // Label 748: @38428
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(38476), // Rule ID 2932 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2932,
      GIR_Done,
    // Label 749: @38476
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(38524), // Rule ID 2933 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2933,
      GIR_Done,
    // Label 750: @38524
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(38572), // Rule ID 2934 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2934,
      GIR_Done,
    // Label 751: @38572
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(38620), // Rule ID 2935 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2935,
      GIR_Done,
    // Label 752: @38620
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(38668), // Rule ID 2936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2936,
      GIR_Done,
    // Label 753: @38668
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(38716), // Rule ID 2937 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2937,
      GIR_Done,
    // Label 754: @38716
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(38764), // Rule ID 2938 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2938,
      GIR_Done,
    // Label 755: @38764
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(38812), // Rule ID 2939 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2939,
      GIR_Done,
    // Label 756: @38812
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(38854), // Rule ID 5413 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5413,
      GIR_Done,
    // Label 757: @38854
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(38896), // Rule ID 5414 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5414,
      GIR_Done,
    // Label 758: @38896
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(38938), // Rule ID 5435 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5435,
      GIR_Done,
    // Label 759: @38938
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(38980), // Rule ID 5436 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5436,
      GIR_Done,
    // Label 760: @38980
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(39022), // Rule ID 5437 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5437,
      GIR_Done,
    // Label 761: @39022
    GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(39064), // Rule ID 5438 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5438,
      GIR_Done,
    // Label 762: @39064
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(39106), // Rule ID 5439 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5439,
      GIR_Done,
    // Label 763: @39106
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(39148), // Rule ID 5440 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5440,
      GIR_Done,
    // Label 764: @39148
    GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(39190), // Rule ID 5441 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5441,
      GIR_Done,
    // Label 765: @39190
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(39232), // Rule ID 5442 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5442,
      GIR_Done,
    // Label 766: @39232
    GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(39274), // Rule ID 5443 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5443,
      GIR_Done,
    // Label 767: @39274
    GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(39316), // Rule ID 5444 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5444,
      GIR_Done,
    // Label 768: @39316
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(39383), // Rule ID 5471 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5471,
      GIR_Done,
    // Label 769: @39383
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(39450), // Rule ID 5472 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5472,
      GIR_Done,
    // Label 770: @39450
    GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(39517), // Rule ID 5473 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5473,
      GIR_Done,
    // Label 771: @39517
    GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(39584), // Rule ID 5474 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5474,
      GIR_Done,
    // Label 772: @39584
    GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(39651), // Rule ID 5475 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5475,
      GIR_Done,
    // Label 773: @39651
    GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(39718), // Rule ID 5476 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5476,
      GIR_Done,
    // Label 774: @39718
    GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(39785), // Rule ID 5477 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5477,
      GIR_Done,
    // Label 775: @39785
    GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(39852), // Rule ID 5478 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5478,
      GIR_Done,
    // Label 776: @39852
    GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(39919), // Rule ID 5479 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5479,
      GIR_Done,
    // Label 777: @39919
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(39986), // Rule ID 5480 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5480,
      GIR_Done,
    // Label 778: @39986
    GIM_Reject,
    // Label 521: @39987
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(40029), // Rule ID 2848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2848,
      GIR_Done,
    // Label 779: @40029
    GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(40071), // Rule ID 2849 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2849,
      GIR_Done,
    // Label 780: @40071
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(40113), // Rule ID 2850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2850,
      GIR_Done,
    // Label 781: @40113
    GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(40155), // Rule ID 2851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2851,
      GIR_Done,
    // Label 782: @40155
    GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(40197), // Rule ID 2852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2852,
      GIR_Done,
    // Label 783: @40197
    GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(40239), // Rule ID 2853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2853,
      GIR_Done,
    // Label 784: @40239
    GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(40281), // Rule ID 2854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2854,
      GIR_Done,
    // Label 785: @40281
    GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(40329), // Rule ID 2940 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2940,
      GIR_Done,
    // Label 786: @40329
    GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(40377), // Rule ID 2941 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2941,
      GIR_Done,
    // Label 787: @40377
    GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(40425), // Rule ID 2942 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2942,
      GIR_Done,
    // Label 788: @40425
    GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(40473), // Rule ID 2943 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2943,
      GIR_Done,
    // Label 789: @40473
    GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(40521), // Rule ID 2944 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2944,
      GIR_Done,
    // Label 790: @40521
    GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(40569), // Rule ID 2945 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2945,
      GIR_Done,
    // Label 791: @40569
    GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(40617), // Rule ID 2946 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2946,
      GIR_Done,
    // Label 792: @40617
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(40659), // Rule ID 5445 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5445,
      GIR_Done,
    // Label 793: @40659
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(40701), // Rule ID 5446 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5446,
      GIR_Done,
    // Label 794: @40701
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(40743), // Rule ID 5447 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5447,
      GIR_Done,
    // Label 795: @40743
    GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(40785), // Rule ID 5448 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5448,
      GIR_Done,
    // Label 796: @40785
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(40827), // Rule ID 5449 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5449,
      GIR_Done,
    // Label 797: @40827
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(40869), // Rule ID 5450 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5450,
      GIR_Done,
    // Label 798: @40869
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(40936), // Rule ID 5481 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5481,
      GIR_Done,
    // Label 799: @40936
    GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(41003), // Rule ID 5482 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5482,
      GIR_Done,
    // Label 800: @41003
    GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(41070), // Rule ID 5483 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5483,
      GIR_Done,
    // Label 801: @41070
    GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(41137), // Rule ID 5484 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5484,
      GIR_Done,
    // Label 802: @41137
    GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(41204), // Rule ID 5485 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5485,
      GIR_Done,
    // Label 803: @41204
    GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(41271), // Rule ID 5486 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5486,
      GIR_Done,
    // Label 804: @41271
    GIM_Reject,
    // Label 522: @41272
    GIM_Reject,
    // Label 10: @41273
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 810*/ GIMT_Encode4(41619),
    /*GILLT_s16*//*Label 805*/ GIMT_Encode4(41336),
    /*GILLT_s32*//*Label 806*/ GIMT_Encode4(41385),
    /*GILLT_s64*//*Label 807*/ GIMT_Encode4(41434), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 808*/ GIMT_Encode4(41483), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 809*/ GIMT_Encode4(41551),
    // Label 805: @41336
    GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(41384), // Rule ID 682 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (ftrunc:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTZH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTZH),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 682,
      GIR_Done,
    // Label 811: @41384
    GIM_Reject,
    // Label 806: @41385
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(41433), // Rule ID 683 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (ftrunc:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTZS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTZS),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 683,
      GIR_Done,
    // Label 812: @41433
    GIM_Reject,
    // Label 807: @41434
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(41482), // Rule ID 684 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (ftrunc:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTZD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTZD),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Dd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 684,
      GIR_Done,
    // Label 813: @41482
    GIM_Reject,
    // Label 808: @41483
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(41550), // Rule ID 4106 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32Z:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32Z),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 4106,
      GIR_Done,
    // Label 814: @41550
    GIM_Reject,
    // Label 809: @41551
    GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(41618), // Rule ID 4094 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16Z:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16Z),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 4094,
      GIR_Done,
    // Label 815: @41618
    GIM_Reject,
    // Label 810: @41619
    GIM_Reject,
    // Label 11: @41620
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 821*/ GIMT_Encode4(41912),
    /*GILLT_s16*//*Label 816*/ GIMT_Encode4(41683),
    /*GILLT_s32*//*Label 817*/ GIMT_Encode4(41714),
    /*GILLT_s64*//*Label 818*/ GIMT_Encode4(41745), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 819*/ GIMT_Encode4(41776), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 820*/ GIMT_Encode4(41844),
    // Label 816: @41683
    GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(41713), // Rule ID 691 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (fround:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTAH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAH),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 691,
      GIR_Done,
    // Label 822: @41713
    GIM_Reject,
    // Label 817: @41714
    GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(41744), // Rule ID 692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (fround:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTAS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAS),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 823: @41744
    GIM_Reject,
    // Label 818: @41745
    GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(41775), // Rule ID 693 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (fround:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTAD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 824: @41775
    GIM_Reject,
    // Label 819: @41776
    GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(41843), // Rule ID 4104 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32A:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32A),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 4104,
      GIR_Done,
    // Label 825: @41843
    GIM_Reject,
    // Label 820: @41844
    GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(41911), // Rule ID 4092 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16A:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16A),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Qd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 4092,
      GIR_Done,
    // Label 826: @41911
    GIM_Reject,
    // Label 821: @41912
    GIM_Reject,
    // Label 12: @41913
    GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(42087),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(42004), // Rule ID 2070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (tLDRSB:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::tMOVi8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::tLDRSB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2070,
        GIR_Done,
      // Label 828: @42004
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(42086), // Rule ID 2071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (tLDRSH:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::tMOVi8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::tLDRSH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2071,
        GIR_Done,
      // Label 829: @42086
      GIM_Reject,
    // Label 827: @42087
    GIM_Reject,
    // Label 13: @42088
    GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(42113), // Rule ID 5547 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      // MIs[0] Operand 0
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
      // (atomic_fence (timm:{ *:[i32] }), 0:{ *:[i32] })  =>  (MEMBARRIER)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::MEMBARRIER),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 5547,
      GIR_Done,
    // Label 830: @42113
    GIM_Reject,
    // Label 14: @42114
    GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(49540),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(42182), // Rule ID 1880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3321:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1880,
        GIR_Done,
      // Label 832: @42182
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(42242), // Rule ID 2123 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3321:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2123,
        GIR_Done,
      // Label 833: @42242
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(42290), // Rule ID 694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f16] } 3207:{ *:[iPTR] }, HPR:{ *:[f16] }:$Sm)  =>  (VRINTNH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTNH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 834: @42290
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(42338), // Rule ID 695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3207:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTNS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 835: @42338
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(42386), // Rule ID 696 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 3207:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Dd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 836: @42386
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(42443), // Rule ID 710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3322:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VTOSIRD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 710,
        GIR_Done,
      // Label 837: @42443
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(42500), // Rule ID 711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3322:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VTOSIRS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 711,
        GIR_Done,
      // Label 838: @42500
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(42557), // Rule ID 712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3323:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VTOUIRD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 839: @42557
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(42614), // Rule ID 713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3323:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VTOUIRS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Sd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 713,
        GIR_Done,
      // Label 840: @42614
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(42671), // Rule ID 1261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3173:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 841: @42671
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(42728), // Rule ID 1262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3173:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1262,
        GIR_Done,
      // Label 842: @42728
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(42785), // Rule ID 1263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3173:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 843: @42785
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(42842), // Rule ID 1264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3173:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 844: @42842
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(42899), // Rule ID 1265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3173:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 845: @42899
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(42956), // Rule ID 1266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3173:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 846: @42956
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(43013), // Rule ID 1267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3174:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 847: @43013
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(43070), // Rule ID 1268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3174:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 848: @43070
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(43127), // Rule ID 1269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3174:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 849: @43127
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(43184), // Rule ID 1270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3174:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 850: @43184
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(43241), // Rule ID 1271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3174:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 851: @43241
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(43298), // Rule ID 1272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3174:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1272,
        GIR_Done,
      // Label 852: @43298
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(43355), // Rule ID 1301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3201:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1301,
        GIR_Done,
      // Label 853: @43355
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(43412), // Rule ID 1302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3201:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1302,
        GIR_Done,
      // Label 854: @43412
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(43469), // Rule ID 1303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3201:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEfd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1303,
        GIR_Done,
      // Label 855: @43469
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(43526), // Rule ID 1304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3201:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEfq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1304,
        GIR_Done,
      // Label 856: @43526
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(43583), // Rule ID 1305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3201:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEhd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1305,
        GIR_Done,
      // Label 857: @43583
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(43640), // Rule ID 1306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3201:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRECPEhq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1306,
        GIR_Done,
      // Label 858: @43640
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(43697), // Rule ID 1311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3214:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 859: @43697
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(43754), // Rule ID 1312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3214:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1312,
        GIR_Done,
      // Label 860: @43754
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(43811), // Rule ID 1313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3214:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 861: @43811
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(43868), // Rule ID 1314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3214:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 862: @43868
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(43925), // Rule ID 1315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3214:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhd),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 863: @43925
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(43982), // Rule ID 1316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3214:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhq),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1316,
        GIR_Done,
      // Label 864: @43982
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(44039), // Rule ID 1537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3179:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1537,
        GIR_Done,
      // Label 865: @44039
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(44096), // Rule ID 1538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3179:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1538,
        GIR_Done,
      // Label 866: @44096
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(44153), // Rule ID 1539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3179:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1539,
        GIR_Done,
      // Label 867: @44153
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(44210), // Rule ID 1540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3179:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1540,
        GIR_Done,
      // Label 868: @44210
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(44267), // Rule ID 1541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3179:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1541,
        GIR_Done,
      // Label 869: @44267
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(44324), // Rule ID 1542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3179:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1542,
        GIR_Done,
      // Label 870: @44324
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(44381), // Rule ID 1553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3185:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1553,
        GIR_Done,
      // Label 871: @44381
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(44438), // Rule ID 1554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3185:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1554,
        GIR_Done,
      // Label 872: @44438
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(44495), // Rule ID 1555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3185:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1555,
        GIR_Done,
      // Label 873: @44495
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(44552), // Rule ID 1556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3185:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1556,
        GIR_Done,
      // Label 874: @44552
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(44609), // Rule ID 1557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3185:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1557,
        GIR_Done,
      // Label 875: @44609
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(44666), // Rule ID 1558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3185:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1558,
        GIR_Done,
      // Label 876: @44666
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(44723), // Rule ID 1559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3126:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1559,
        GIR_Done,
      // Label 877: @44723
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(44780), // Rule ID 1560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3126:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1560,
        GIR_Done,
      // Label 878: @44780
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(44837), // Rule ID 1561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3126:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1561,
        GIR_Done,
      // Label 879: @44837
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(44894), // Rule ID 1562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3126:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv16i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 880: @44894
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(44951), // Rule ID 1563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3126:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1563,
        GIR_Done,
      // Label 881: @44951
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(45008), // Rule ID 1564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3126:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1564,
        GIR_Done,
      // Label 882: @45008
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(45065), // Rule ID 1608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3182:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1608,
        GIR_Done,
      // Label 883: @45065
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(45122), // Rule ID 1609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3182:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 884: @45122
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(45179), // Rule ID 1610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3182:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1610,
        GIR_Done,
      // Label 885: @45179
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(45236), // Rule ID 1611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3184:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1611,
        GIR_Done,
      // Label 886: @45236
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(45293), // Rule ID 1612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3184:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1612,
        GIR_Done,
      // Label 887: @45293
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(45350), // Rule ID 1613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3184:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1613,
        GIR_Done,
      // Label 888: @45350
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(45407), // Rule ID 1614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3183:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv8i8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1614,
        GIR_Done,
      // Label 889: @45407
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(45464), // Rule ID 1615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3183:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv4i16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1615,
        GIR_Done,
      // Label 890: @45464
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(45521), // Rule ID 1616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3183:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv2i32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1616,
        GIR_Done,
      // Label 891: @45521
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(45569), // Rule ID 1639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3127:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 892: @45569
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(45617), // Rule ID 1640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3127:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 893: @45617
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(45665), // Rule ID 1641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3128:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 894: @45665
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(45713), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3128:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1642,
        GIR_Done,
      // Label 895: @45713
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(45761), // Rule ID 1643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3127:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 896: @45761
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(45809), // Rule ID 1644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3127:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 897: @45809
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(45857), // Rule ID 1645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3128:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 898: @45857
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(45905), // Rule ID 1646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3128:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 899: @45905
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(45953), // Rule ID 1647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3139:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1647,
        GIR_Done,
      // Label 900: @45953
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(46001), // Rule ID 1648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3139:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1648,
        GIR_Done,
      // Label 901: @46001
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(46049), // Rule ID 1649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3140:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1649,
        GIR_Done,
      // Label 902: @46049
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(46097), // Rule ID 1650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3140:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1650,
        GIR_Done,
      // Label 903: @46097
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(46145), // Rule ID 1651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3139:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1651,
        GIR_Done,
      // Label 904: @46145
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(46193), // Rule ID 1652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3139:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1652,
        GIR_Done,
      // Label 905: @46193
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(46241), // Rule ID 1653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3140:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1653,
        GIR_Done,
      // Label 906: @46241
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(46289), // Rule ID 1654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3140:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1654,
        GIR_Done,
      // Label 907: @46289
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(46337), // Rule ID 1655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3141:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1655,
        GIR_Done,
      // Label 908: @46337
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(46385), // Rule ID 1656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3141:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1656,
        GIR_Done,
      // Label 909: @46385
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(46433), // Rule ID 1657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3142:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUDf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1657,
        GIR_Done,
      // Label 910: @46433
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(46481), // Rule ID 1658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3142:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUQf),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1658,
        GIR_Done,
      // Label 911: @46481
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(46529), // Rule ID 1659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3141:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1659,
        GIR_Done,
      // Label 912: @46529
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(46577), // Rule ID 1660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3141:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQh),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1660,
        GIR_Done,
      // Label 913: @46577
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(46625), // Rule ID 1661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intr