/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-enums.h"
#include "libical-glib-private.h"

/**
 * i_cal_request_status_desc:
 * @stat: The #ICalRequestStatus to be translated
 *
 * Returns the descriptive text for a request status.
 *
 * Returns: The description of the @stat
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_request_status_desc (ICalRequestStatus stat)
{
	return icalenum_reqstat_desc ((icalrequeststatus) (stat));
}

/**
 * i_cal_request_status_major:
 * @stat: The #ICalRequestStatus to be queried
 *
 * Returns the major number for a request status.
 *
 * Returns: The major number for a request status
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_request_status_major (ICalRequestStatus stat)
{
	return icalenum_reqstat_major ((icalrequeststatus) (stat));
}

/**
 * i_cal_request_status_minor:
 * @stat: The #ICalRequestStatus to be queried
 *
 * Returns the minor number for a request status.
 *
 * Returns: The minor number for a request status
 *
 * Since: 1.0
 *
 **/
gshort
i_cal_request_status_minor (ICalRequestStatus stat)
{
	return icalenum_reqstat_minor ((icalrequeststatus) (stat));
}

/**
 * i_cal_request_status_from_num:
 * @major: The major number
 * @minor: The minor number
 *
 * Returns a request status for major/minor status numbers.
 *
 * Returns: The corresponding #ICalRequestStatus
 *
 * Since: 1.0
 *
 **/
ICalRequestStatus
i_cal_request_status_from_num (gshort major, 
                               gshort minor)
{
	return (ICalRequestStatus) (icalenum_num_to_reqstat (major, minor));
}

/**
 * i_cal_request_status_code:
 * @stat: The #ICalRequestStatus to be queried
 *
 * Returns the code for a request status.
 *
 * Returns: (transfer full): The code for a request status
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_request_status_code (ICalRequestStatus stat)
{
	return icalenum_reqstat_code_r ((icalrequeststatus) (stat));
}
