/* night-light-monitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from night-light-monitor.vala, do not modify */

/*
  This file is part of GNOME Reversi

  GNOME Reversi is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  GNOME Reversi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/
/*
  This code has been inspired by the one for a similar function in Calendar
  https://gitlab.gnome.org/GNOME/gnome-calendar commit 474ce8b9da4a3322f2fe
  Copyright 2018 Georges Basile Stavracas Neto <georges.stavracas@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#define NIGHT_LIGHT_MONITOR_warning_init_connection "Impossible to get connection for session bus, night-light mode disable" \
"d."
#define NIGHT_LIGHT_MONITOR_warning_init_dbus_proxy "Impossible to get dbus proxy for session bus, night-light mode disable" \
"d."
#define NIGHT_LIGHT_MONITOR_warning_cached_property "Impossible to get cached property from proxy, night-light mode disable" \
"d."
#define NIGHT_LIGHT_MONITOR_warning_check_your_logs "Something went wrong during the night mode support init, doing nothing" \
"."
#define NIGHT_LIGHT_MONITOR_warning_get_gtksettings "Something went wrong getting GtkSettings default object, doing nothing" \
"."
#define NIGHT_LIGHT_MONITOR_schema_name "org.gnome.Reversi.Lib"
#define NIGHT_LIGHT_MONITOR_automatic_night_mode_key "automatic-night-mode"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NIGHT_LIGHT_MONITOR (night_light_monitor_get_type ())
#define NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor))
#define NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))
#define IS_NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_LIGHT_MONITOR))
#define IS_NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_LIGHT_MONITOR))
#define NIGHT_LIGHT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))

typedef struct _NightLightMonitor NightLightMonitor;
typedef struct _NightLightMonitorClass NightLightMonitorClass;
typedef struct _NightLightMonitorPrivate NightLightMonitorPrivate;
typedef enum  {
	NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN,
	NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT,
	NIGHT_LIGHT_MONITOR_NIGHT_TIME_DAY
} NightLightMonitorNightTime;

#define NIGHT_LIGHT_MONITOR_TYPE_NIGHT_TIME (night_light_monitor_night_time_get_type ())
enum  {
	NIGHT_LIGHT_MONITOR_0_PROPERTY,
	NIGHT_LIGHT_MONITOR_SCHEMA_PATH_PROPERTY,
	NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY,
	NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY,
	NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY,
	NIGHT_LIGHT_MONITOR_NUM_PROPERTIES
};
static GParamSpec* night_light_monitor_properties[NIGHT_LIGHT_MONITOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _NightLightMonitor {
	GObject parent_instance;
	NightLightMonitorPrivate * priv;
};

struct _NightLightMonitorClass {
	GObjectClass parent_class;
};

struct _NightLightMonitorPrivate {
	gchar* _schema_path;
	NightLightMonitorNightTime _night_time;
	gboolean _dark_theme;
	gboolean _automatic_night_mode;
	GSettings* settings;
	GDBusProxy* proxy;
	gboolean paused;
};

static gint NightLightMonitor_private_offset;
static gpointer night_light_monitor_parent_class = NULL;

VALA_EXTERN GType night_light_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightLightMonitor, g_object_unref)
VALA_EXTERN GType night_light_monitor_night_time_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean night_light_monitor_night_time_should_use_dark_theme (NightLightMonitorNightTime state);
VALA_EXTERN NightLightMonitor* night_light_monitor_new (const gchar* _schema_path);
VALA_EXTERN NightLightMonitor* night_light_monitor_construct (GType object_type,
                                                  const gchar* _schema_path);
VALA_EXTERN NightLightMonitorNightTime night_light_monitor_get_night_time (NightLightMonitor* self);
static void night_light_monitor_connect_properties (NightLightMonitor* self);
VALA_EXTERN void night_light_monitor_set_use_night_mode (NightLightMonitor* self,
                                             gboolean night_mode_state);
static void night_light_monitor_update (NightLightMonitor* self);
static void night_light_monitor_init_connection (GDBusConnection** connection);
static void night_light_monitor_init_proxy (GDBusConnection* connection,
                                     GDBusProxy** proxy);
static NightLightMonitorNightTime night_light_monitor_get_updated_night_time (GDBusProxy** proxy,
                                                                       gboolean automatic_night_mode);
static void __lambda5_ (NightLightMonitor* self);
VALA_EXTERN gboolean night_light_monitor_get_automatic_night_mode (NightLightMonitor* self);
static void night_light_monitor_set_night_time (NightLightMonitor* self,
                                         NightLightMonitorNightTime value);
static void ___lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                    GVariant* changed_properties,
                                                    gchar** invalidated_properties,
                                                    gpointer self);
static void __lambda6_ (NightLightMonitor* self,
                 GSettings* _settings,
                 const gchar* _key_name);
static void night_light_monitor_set_automatic_night_mode (NightLightMonitor* self,
                                                   gboolean value);
static void ___lambda6__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void night_light_monitor_set_dark_theme_real (NightLightMonitor* self,
                                              gboolean night_mode);
static gboolean _night_light_monitor_set_dark_theme_real (gboolean night_mode);
static void night_light_monitor_set_dark_theme (NightLightMonitor* self,
                                         gboolean value);
static const gchar* night_light_monitor_get_schema_path (NightLightMonitor* self);
static void night_light_monitor_set_schema_path (NightLightMonitor* self,
                                          const gchar* value);
VALA_EXTERN gboolean night_light_monitor_get_dark_theme (NightLightMonitor* self);
static GObject * night_light_monitor_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void night_light_monitor_finalize (GObject * obj);
static GType night_light_monitor_get_type_once (void);
static void _vala_night_light_monitor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_night_light_monitor_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
night_light_monitor_get_instance_private (NightLightMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, NightLightMonitor_private_offset);
}

gboolean
night_light_monitor_night_time_should_use_dark_theme (NightLightMonitorNightTime state)
{
	gboolean result;
	result = state == NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT;
	return result;
}

static GType
night_light_monitor_night_time_get_type_once (void)
{
	static const GEnumValue values[] = {{NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN, "NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN", "unknown"}, {NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT, "NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT", "night"}, {NIGHT_LIGHT_MONITOR_NIGHT_TIME_DAY, "NIGHT_LIGHT_MONITOR_NIGHT_TIME_DAY", "day"}, {0, NULL, NULL}};
	GType night_light_monitor_night_time_type_id;
	night_light_monitor_night_time_type_id = g_enum_register_static ("NightLightMonitorNightTime", values);
	return night_light_monitor_night_time_type_id;
}

GType
night_light_monitor_night_time_get_type (void)
{
	static volatile gsize night_light_monitor_night_time_type_id__once = 0;
	if (g_once_init_enter (&night_light_monitor_night_time_type_id__once)) {
		GType night_light_monitor_night_time_type_id;
		night_light_monitor_night_time_type_id = night_light_monitor_night_time_get_type_once ();
		g_once_init_leave (&night_light_monitor_night_time_type_id__once, night_light_monitor_night_time_type_id);
	}
	return night_light_monitor_night_time_type_id__once;
}

NightLightMonitor*
night_light_monitor_construct (GType object_type,
                               const gchar* _schema_path)
{
	NightLightMonitor * self = NULL;
	NightLightMonitorNightTime _tmp0_;
	g_return_val_if_fail (_schema_path != NULL, NULL);
	self = (NightLightMonitor*) g_object_new (object_type, "schema-path", _schema_path, NULL);
	_tmp0_ = self->priv->_night_time;
	if (_tmp0_ == NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN) {
		return self;
	}
	night_light_monitor_connect_properties (self);
	return self;
}

NightLightMonitor*
night_light_monitor_new (const gchar* _schema_path)
{
	return night_light_monitor_construct (TYPE_NIGHT_LIGHT_MONITOR, _schema_path);
}

void
night_light_monitor_set_use_night_mode (NightLightMonitor* self,
                                        gboolean night_mode_state)
{
	NightLightMonitorNightTime _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_night_time;
	if (_tmp0_ == NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN) {
		g_warning ("night-light-monitor.vala:74: %s", NIGHT_LIGHT_MONITOR_warning_check_your_logs);
	} else {
		self->priv->paused = !night_mode_state;
		night_light_monitor_update (self);
	}
}

static void
night_light_monitor_init_connection (GDBusConnection** connection)
{
	GDBusConnection* _vala_connection = NULL;
	GError* _inner_error0_ = NULL;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_vala_connection);
		_vala_connection = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_warning ("night-light-monitor.vala:117: %s", NIGHT_LIGHT_MONITOR_warning_init_connection);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("night-light-monitor.vala:118: %s", _tmp4_);
		_g_object_unref0 (_vala_connection);
		_vala_connection = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_vala_connection);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (connection) {
		*connection = _vala_connection;
	} else {
		_g_object_unref0 (_vala_connection);
	}
}

static void
night_light_monitor_init_proxy (GDBusConnection* connection,
                                GDBusProxy** proxy)
{
	GDBusProxy* _vala_proxy = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	{
		GDBusProxy* _tmp0_ = NULL;
		GDBusProxy* _tmp1_;
		GDBusProxy* _tmp2_;
		_tmp1_ = g_dbus_proxy_new_sync (connection, G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, NULL, "org.gnome.SettingsDaemon.Color", "/org/gnome/SettingsDaemon/Color", "org.gnome.SettingsDaemon.Color", NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_vala_proxy);
		_vala_proxy = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_warning ("night-light-monitor.vala:137: %s", NIGHT_LIGHT_MONITOR_warning_init_dbus_proxy);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("night-light-monitor.vala:138: %s", _tmp4_);
		_g_object_unref0 (_vala_proxy);
		_vala_proxy = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_vala_proxy);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (proxy) {
		*proxy = _vala_proxy;
	} else {
		_g_object_unref0 (_vala_proxy);
	}
}

static NightLightMonitorNightTime
night_light_monitor_get_updated_night_time (GDBusProxy** proxy,
                                            gboolean automatic_night_mode)
{
	GVariant* variant_active = NULL;
	GVariant* _tmp0_;
	GVariant* variant_paused = NULL;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean night_time_is_night = FALSE;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	NightLightMonitorNightTime result;
	g_return_val_if_fail (*proxy != NULL, 0);
	_tmp0_ = g_dbus_proxy_get_cached_property (*proxy, "NightLightActive");
	variant_active = _tmp0_;
	_tmp1_ = g_dbus_proxy_get_cached_property (*proxy, "DisabledUntilTomorrow");
	variant_paused = _tmp1_;
	_tmp2_ = variant_active;
	if (_tmp2_ == NULL) {
		g_warning ("night-light-monitor.vala:149: %s", NIGHT_LIGHT_MONITOR_warning_cached_property);
		result = NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN;
		_g_variant_unref0 (variant_paused);
		_g_variant_unref0 (variant_active);
		return result;
	}
	_tmp3_ = variant_active;
	night_time_is_night = g_variant_get_boolean ((GVariant*) _tmp3_);
	_tmp4_ = variant_paused;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		if (night_time_is_night) {
			gboolean _tmp6_ = FALSE;
			GVariant* _tmp7_;
			_tmp7_ = variant_paused;
			if (g_variant_get_boolean ((GVariant*) _tmp7_)) {
				_tmp6_ = automatic_night_mode;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp5_ = !_tmp6_;
		} else {
			_tmp5_ = FALSE;
		}
		night_time_is_night = _tmp5_;
	}
	if (night_time_is_night) {
		result = NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT;
		_g_variant_unref0 (variant_paused);
		_g_variant_unref0 (variant_active);
		return result;
	} else {
		result = NIGHT_LIGHT_MONITOR_NIGHT_TIME_DAY;
		_g_variant_unref0 (variant_paused);
		_g_variant_unref0 (variant_active);
		return result;
	}
}

static void
__lambda5_ (NightLightMonitor* self)
{
	gboolean _tmp0_;
	NightLightMonitorNightTime _tmp1_;
	NightLightMonitorNightTime _tmp2_;
	_tmp0_ = self->priv->_automatic_night_mode;
	_tmp1_ = night_light_monitor_get_updated_night_time (&self->priv->proxy, _tmp0_);
	night_light_monitor_set_night_time (self, _tmp1_);
	_tmp2_ = self->priv->_night_time;
	if (_tmp2_ != NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_automatic_night_mode;
		self->priv->paused = !_tmp3_;
	}
	night_light_monitor_update (self);
}

static void
___lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                               GVariant* changed_properties,
                                               gchar** invalidated_properties,
                                               gpointer self)
{
	__lambda5_ ((NightLightMonitor*) self);
}

static void
__lambda6_ (NightLightMonitor* self,
            GSettings* _settings,
            const gchar* _key_name)
{
	gboolean _tmp0_;
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (_key_name != NULL);
	night_light_monitor_set_automatic_night_mode (self, g_settings_get_boolean (_settings, _key_name));
	_tmp0_ = self->priv->_automatic_night_mode;
	self->priv->paused = !_tmp0_;
	night_light_monitor_update (self);
}

static void
___lambda6__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda6_ ((NightLightMonitor*) self, _sender, key);
}

static void
night_light_monitor_connect_properties (NightLightMonitor* self)
{
	GDBusProxy* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	g_signal_connect_object (_tmp0_, "g-properties-changed", (GCallback) ___lambda5__g_dbus_proxy_g_properties_changed, self, 0);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_strconcat ("changed::", NIGHT_LIGHT_MONITOR_automatic_night_mode_key, NULL);
	g_signal_connect_object (_tmp1_, _tmp2_, (GCallback) ___lambda6__g_settings_changed, self, 0);
	_g_free0 (_tmp2_);
	night_light_monitor_update (self);
}

static void
night_light_monitor_update (NightLightMonitor* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_automatic_night_mode;
	if (_tmp0_) {
		if (self->priv->paused) {
			night_light_monitor_set_dark_theme_real (self, FALSE);
		} else {
			NightLightMonitorNightTime _tmp1_;
			_tmp1_ = self->priv->_night_time;
			night_light_monitor_set_dark_theme_real (self, night_light_monitor_night_time_should_use_dark_theme (_tmp1_));
		}
	} else {
		NightLightMonitorNightTime _tmp2_;
		_tmp2_ = self->priv->_night_time;
		if (_tmp2_ == NIGHT_LIGHT_MONITOR_NIGHT_TIME_NIGHT) {
			if (self->priv->paused) {
				night_light_monitor_set_dark_theme_real (self, FALSE);
			} else {
				night_light_monitor_set_dark_theme_real (self, TRUE);
			}
		} else {
			night_light_monitor_set_dark_theme_real (self, FALSE);
		}
	}
}

static void
night_light_monitor_set_dark_theme_real (NightLightMonitor* self,
                                         gboolean night_mode)
{
	g_return_if_fail (self != NULL);
	if (_night_light_monitor_set_dark_theme_real (night_mode)) {
		night_light_monitor_set_dark_theme (self, night_mode);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_night_light_monitor_set_dark_theme_real (gboolean night_mode)
{
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtk_settings = _tmp1_;
	_tmp2_ = gtk_settings;
	if (_tmp2_ == NULL) {
		g_warning ("night-light-monitor.vala:214: %s", NIGHT_LIGHT_MONITOR_warning_get_gtksettings);
		result = FALSE;
		_g_object_unref0 (gtk_settings);
		return result;
	}
	_tmp3_ = gtk_settings;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_settings_get_type (), GtkSettings), "gtk-application-prefer-dark-theme", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (night_mode != _tmp5_) {
		GtkSettings* _tmp6_;
		_tmp6_ = gtk_settings;
		g_object_set ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_settings_get_type (), GtkSettings), "gtk-application-prefer-dark-theme", night_mode, NULL);
	}
	result = TRUE;
	_g_object_unref0 (gtk_settings);
	return result;
}

static const gchar*
night_light_monitor_get_schema_path (NightLightMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_schema_path;
	result = _tmp0_;
	return result;
}

static void
night_light_monitor_set_schema_path (NightLightMonitor* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_schema_path);
	self->priv->_schema_path = _tmp0_;
}

NightLightMonitorNightTime
night_light_monitor_get_night_time (NightLightMonitor* self)
{
	NightLightMonitorNightTime result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_night_time;
	return result;
}

static void
night_light_monitor_set_night_time (NightLightMonitor* self,
                                    NightLightMonitorNightTime value)
{
	NightLightMonitorNightTime old_value;
	g_return_if_fail (self != NULL);
	old_value = night_light_monitor_get_night_time (self);
	if (old_value != value) {
		self->priv->_night_time = value;
		g_object_notify_by_pspec ((GObject *) self, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY]);
	}
}

gboolean
night_light_monitor_get_dark_theme (NightLightMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dark_theme;
	return result;
}

static void
night_light_monitor_set_dark_theme (NightLightMonitor* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = night_light_monitor_get_dark_theme (self);
	if (old_value != value) {
		self->priv->_dark_theme = value;
		g_object_notify_by_pspec ((GObject *) self, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY]);
	}
}

gboolean
night_light_monitor_get_automatic_night_mode (NightLightMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic_night_mode;
	return result;
}

static void
night_light_monitor_set_automatic_night_mode (NightLightMonitor* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = night_light_monitor_get_automatic_night_mode (self);
	if (old_value != value) {
		self->priv->_automatic_night_mode = value;
		g_object_notify_by_pspec ((GObject *) self, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY]);
	}
}

static GObject *
night_light_monitor_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NightLightMonitor * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	GDBusConnection* connection = NULL;
	GDBusConnection* _tmp4_ = NULL;
	GDBusConnection* _tmp5_;
	GDBusProxy* nullable_proxy = NULL;
	GDBusConnection* _tmp6_;
	GDBusProxy* _tmp7_ = NULL;
	GDBusProxy* _tmp8_;
	GDBusProxy* _tmp9_;
	GDBusProxy* _tmp10_;
	gboolean _tmp11_;
	NightLightMonitorNightTime _tmp12_;
	parent_class = G_OBJECT_CLASS (night_light_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor);
	_tmp0_ = self->priv->_schema_path;
	_tmp1_ = g_settings_new_with_path (NIGHT_LIGHT_MONITOR_schema_name, _tmp0_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	night_light_monitor_set_automatic_night_mode (self, g_settings_get_boolean (_tmp2_, NIGHT_LIGHT_MONITOR_automatic_night_mode_key));
	_tmp3_ = self->priv->_automatic_night_mode;
	self->priv->paused = !_tmp3_;
	night_light_monitor_init_connection (&_tmp4_);
	_g_object_unref0 (connection);
	connection = _tmp4_;
	_tmp5_ = connection;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (connection);
		return obj;
	}
	_tmp6_ = connection;
	night_light_monitor_init_proxy (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_dbus_connection_get_type (), GDBusConnection), &_tmp7_);
	_g_object_unref0 (nullable_proxy);
	nullable_proxy = _tmp7_;
	_tmp8_ = nullable_proxy;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (nullable_proxy);
		_g_object_unref0 (connection);
		return obj;
	}
	_tmp9_ = nullable_proxy;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_dbus_proxy_get_type (), GDBusProxy));
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp10_;
	_tmp11_ = self->priv->_automatic_night_mode;
	_tmp12_ = night_light_monitor_get_updated_night_time (&self->priv->proxy, _tmp11_);
	night_light_monitor_set_night_time (self, _tmp12_);
	_g_object_unref0 (nullable_proxy);
	_g_object_unref0 (connection);
	return obj;
}

static void
night_light_monitor_class_init (NightLightMonitorClass * klass,
                                gpointer klass_data)
{
	night_light_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NightLightMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_night_light_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_night_light_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = night_light_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = night_light_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHT_LIGHT_MONITOR_SCHEMA_PATH_PROPERTY, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY] = g_param_spec_enum ("night-time", "night-time", "night-time", NIGHT_LIGHT_MONITOR_TYPE_NIGHT_TIME, NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY] = g_param_spec_boolean ("dark-theme", "dark-theme", "dark-theme", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY, night_light_monitor_properties[NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY] = g_param_spec_boolean ("automatic-night-mode", "automatic-night-mode", "automatic-night-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
night_light_monitor_instance_init (NightLightMonitor * self,
                                   gpointer klass)
{
	self->priv = night_light_monitor_get_instance_private (self);
	self->priv->_night_time = NIGHT_LIGHT_MONITOR_NIGHT_TIME_UNKNOWN;
	self->priv->_dark_theme = FALSE;
	self->priv->_automatic_night_mode = FALSE;
	self->priv->paused = FALSE;
}

static void
night_light_monitor_finalize (GObject * obj)
{
	NightLightMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor);
	_g_free0 (self->priv->_schema_path);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (night_light_monitor_parent_class)->finalize (obj);
}

static GType
night_light_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightLightMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) night_light_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightLightMonitor), 0, (GInstanceInitFunc) night_light_monitor_instance_init, NULL };
	GType night_light_monitor_type_id;
	night_light_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "NightLightMonitor", &g_define_type_info, 0);
	NightLightMonitor_private_offset = g_type_add_instance_private (night_light_monitor_type_id, sizeof (NightLightMonitorPrivate));
	return night_light_monitor_type_id;
}

GType
night_light_monitor_get_type (void)
{
	static volatile gsize night_light_monitor_type_id__once = 0;
	if (g_once_init_enter (&night_light_monitor_type_id__once)) {
		GType night_light_monitor_type_id;
		night_light_monitor_type_id = night_light_monitor_get_type_once ();
		g_once_init_leave (&night_light_monitor_type_id__once, night_light_monitor_type_id);
	}
	return night_light_monitor_type_id__once;
}

static void
_vala_night_light_monitor_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	NightLightMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor);
	switch (property_id) {
		case NIGHT_LIGHT_MONITOR_SCHEMA_PATH_PROPERTY:
		g_value_set_string (value, night_light_monitor_get_schema_path (self));
		break;
		case NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY:
		g_value_set_enum (value, night_light_monitor_get_night_time (self));
		break;
		case NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY:
		g_value_set_boolean (value, night_light_monitor_get_dark_theme (self));
		break;
		case NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY:
		g_value_set_boolean (value, night_light_monitor_get_automatic_night_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_night_light_monitor_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	NightLightMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor);
	switch (property_id) {
		case NIGHT_LIGHT_MONITOR_SCHEMA_PATH_PROPERTY:
		night_light_monitor_set_schema_path (self, g_value_get_string (value));
		break;
		case NIGHT_LIGHT_MONITOR_NIGHT_TIME_PROPERTY:
		night_light_monitor_set_night_time (self, g_value_get_enum (value));
		break;
		case NIGHT_LIGHT_MONITOR_DARK_THEME_PROPERTY:
		night_light_monitor_set_dark_theme (self, g_value_get_boolean (value));
		break;
		case NIGHT_LIGHT_MONITOR_AUTOMATIC_NIGHT_MODE_PROPERTY:
		night_light_monitor_set_automatic_night_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

