{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The AtkImplementor interface is implemented by objects for which
-- AtkObject peers may be obtained via calls to
-- iface->(ref_accessible)(implementor);

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.ImplementorIface
    ( 

-- * Exported types
    ImplementorIface(..)                    ,
    IsImplementorIface                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveImplementorIfaceMethod           ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- interface ImplementorIface 
-- | Memory-managed wrapper type.
newtype ImplementorIface = ImplementorIface (SP.ManagedPtr ImplementorIface)
    deriving (Eq)

instance SP.ManagedPtrNewtype ImplementorIface where
    toManagedPtr (ImplementorIface p) = p

-- | Type class for types which implement t'ImplementorIface'.
class (ManagedPtrNewtype o, O.IsDescendantOf ImplementorIface o) => IsImplementorIface o
instance (ManagedPtrNewtype o, O.IsDescendantOf ImplementorIface o) => IsImplementorIface o
-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ImplementorIface where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
type family ResolveImplementorIfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveImplementorIfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveImplementorIfaceMethod t ImplementorIface, O.OverloadedMethod info ImplementorIface p) => OL.IsLabel t (ImplementorIface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveImplementorIfaceMethod t ImplementorIface, O.OverloadedMethod info ImplementorIface p, R.HasField t ImplementorIface p) => R.HasField t ImplementorIface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveImplementorIfaceMethod t ImplementorIface, O.OverloadedMethodInfo info ImplementorIface) => OL.IsLabel t (O.MethodProxy info ImplementorIface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ImplementorIface = ImplementorIfaceSignalList
type ImplementorIfaceSignalList = ('[ ] :: [(Symbol, DK.Type)])

#endif


