/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_symbol_sync_cc = R"doc(Symbol Synchronizer block with complex input, complex output.

This implements a discrete-time error-tracking synchronizer.


For this block to work properly, the input stream must meet the following requirements:

Constructor Specific Documentation:

Make a Symbol Synchronizer block.


This implements a discrete-time error-tracking synchronizer.


For this block to work properly, the input stream must meet the following requirements:

Args:
    detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
    sps : User specified nominal clock period in samples per symbol.
    loop_bw : Approximate normalized loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
    damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
    ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
    max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
    osps : The number of output samples per symbol (default=1).
    slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
    interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
    n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
    taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_symbol_sync_cc_0 = R"doc()doc";


static const char* __doc_gr_digital_symbol_sync_cc_symbol_sync_cc_1 = R"doc()doc";


static const char* __doc_gr_digital_symbol_sync_cc_make = R"doc(Symbol Synchronizer block with complex input, complex output.

This implements a discrete-time error-tracking synchronizer.


For this block to work properly, the input stream must meet the following requirements:

Constructor Specific Documentation:

Make a Symbol Synchronizer block.


This implements a discrete-time error-tracking synchronizer.


For this block to work properly, the input stream must meet the following requirements:

Args:
    detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
    sps : User specified nominal clock period in samples per symbol.
    loop_bw : Approximate normalized loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
    damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
    ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
    max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
    osps : The number of output samples per symbol (default=1).
    slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
    interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
    n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
    taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_loop_bandwidth = R"doc(Returns the normalized approximate loop bandwidth.

See the documentation for set_loop_bandwidth() for more details.


Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_damping_factor = R"doc(Returns the loop damping factor.

See the documentation for set_damping_factor() for more details.


Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_ted_gain = R"doc(Returns the user provided expected gain of the Timing Error Detector.

See the documentation for set_ted_gain() for more details.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_alpha = R"doc(Returns the PI filter proportional gain, alpha.

See the documentation for set_alpha() for more details.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_beta = R"doc(Returns the PI filter integral gain, beta.

See the documentation for set_beta() for more details.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_sps = R"doc(Returns the nominal clock period in samples per symbol.

See the doecumentation for set_sps() for more details.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_loop_bandwidth = R"doc(Set the normalized approximate loop bandwidth.

Set the normalized approximate loop bandwidth. Useful values are usually close to 0.0, e.g. 2*pi*0.045.


It should be a small positive number, corresponding to the normalized natural radian frequency of the loop as digital low-pass filter that is filtering the clock phase/timing error.


Technically this parameter corresponds to the natural radian frequency of the 2nd order loop transfer function (scaled by Fs), which is the radius of the pole locations in the s-plane of an underdamped analog 2nd order system.


The input parameter corresponds to omega_n_norm in the following relation: 


where T is the period of the clock being estimated by this clock tracking loop, and omega_n is the natural radian frequency of the 2nd order loop transfer function.


When a new loop bandwidth is set, the gains, alpha and beta, of the loop are automatically recalculated.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_damping_factor = R"doc(Set the loop damping factor.

Set the damping factor of the loop. Damping in the range (0.0, 1.0) yields an under-damped loop. Damping in the range (1.0, Inf) yields an over-damped loop. Damping equal to 1.0 yields a crtically-damped loop. Damping equal to 1.0/sqrt(2.0) yields a maximally flat loop filter response.


Damping factor of the 2nd order loop transfer function. When a new damping factor is set, the gains, alpha and beta, of the loop are automatically recalculated.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_ted_gain = R"doc(Set the expected gain of the Timing Error Detector.

Sets the expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.


When a new ted_gain is set, the gains, alpha and beta, of the loop are automatically recalculated.)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_alpha = R"doc(Set the PI filter proportional gain, alpha.

Sets the PI filter proportional gain, alpha. This gain directly multiplies the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the instantaneous clock period estimate, T_inst, and instantaneous clock phase estimate, tau.


This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_beta = R"doc(Set the PI filter integral gain, beta.

Sets the PI filter integral gain, beta. This gain is used when integrating the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the average clock period estimate, T_avg.


This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).)doc";


static const char* __doc_gr_digital_symbol_sync_cc_set_sps = R"doc(Set the nominal clock period in samples per symbol.

Sets the nominal clock period, resetting some of the tracking loop variables to adjust to the new clock period.)doc";
