/* -*- c++ -*- */
/*
 * Copyright 2021 Cesar Martinez.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_crc16_async_bb = R"doc(Byte-stream CRC block for async messages.

Processes packets (as async PDU messages) for CRC16. The  parameter determines if the block acts to check and strip the CRC or to calculate and append the CRC16.


The input PDU is expected to be a message of packet bytes.


When using check mode, if the CRC passes, the output is a payload of the message with the CRC stripped, so the output will be 2 bytes smaller than the input.


When using calculate mode (check == false), then the CRC is calculated on the PDU and appended to it. The output is then 2 bytes longer than the input.


This block implements the CRC16 using the standard generator 0x1021.

Constructor Specific Documentation:



Args:
    check : Set to true if you want to check CRC, false to create CRC.)doc";


static const char* __doc_gr_digital_crc16_async_bb_crc32_async_bb = R"doc()doc";


static const char* __doc_gr_digital_crc16_async_bb_make = R"doc(Byte-stream CRC block for async messages.

Processes packets (as async PDU messages) for CRC16. The  parameter determines if the block acts to check and strip the CRC or to calculate and append the CRC16.


The input PDU is expected to be a message of packet bytes.


When using check mode, if the CRC passes, the output is a payload of the message with the CRC stripped, so the output will be 2 bytes smaller than the input.


When using calculate mode (check == false), then the CRC is calculated on the PDU and appended to it. The output is then 2 bytes longer than the input.


This block implements the CRC16 using the standard generator 0x1021.

Constructor Specific Documentation:



Args:
    check : Set to true if you want to check CRC, false to create CRC.)doc";
