/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014, 2020 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include "libsudoku.h"

#define SUDOKU_WINDOW_SMALL_WINDOW_WIDTH 360
#define SUDOKU_WINDOW_MEDIUM_WINDOW_WIDTH 600
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
typedef struct _SudokuWindowPrivate SudokuWindowPrivate;

#define TYPE_SUDOKU_START_VIEW (sudoku_start_view_get_type ())
#define SUDOKU_START_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_START_VIEW, SudokuStartView))
#define SUDOKU_START_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_START_VIEW, SudokuStartViewClass))
#define IS_SUDOKU_START_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_START_VIEW))
#define IS_SUDOKU_START_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_START_VIEW))
#define SUDOKU_START_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_START_VIEW, SudokuStartViewClass))

typedef struct _SudokuStartView SudokuStartView;
typedef struct _SudokuStartViewClass SudokuStartViewClass;

#define TYPE_SUDOKU_GAME_VIEW (sudoku_game_view_get_type ())
#define SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameView))
#define SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))
#define IS_SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME_VIEW))
#define IS_SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME_VIEW))
#define SUDOKU_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))

typedef struct _SudokuGameView SudokuGameView;
typedef struct _SudokuGameViewClass SudokuGameViewClass;
typedef enum  {
	SUDOKU_WINDOW_SCREEN_NONE,
	SUDOKU_WINDOW_SCREEN_PLAY,
	SUDOKU_WINDOW_SCREEN_CREATE,
	SUDOKU_WINDOW_SCREEN_START
} SudokuWindowScreen;

#define TYPE_SUDOKU_WINDOW_SCREEN (sudoku_window_screen_get_type ())
enum  {
	SUDOKU_WINDOW_0_PROPERTY,
	SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY,
	SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY,
	SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY,
	SUDOKU_WINDOW_NUM_PROPERTIES
};
static GParamSpec* sudoku_window_properties[SUDOKU_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SudokuStartViewPrivate SudokuStartViewPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SudokuGameViewPrivate SudokuGameViewPrivate;

#define TYPE_SUDOKU_GRID (sudoku_grid_get_type ())
#define SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GRID, SudokuGrid))
#define SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GRID, SudokuGridClass))
#define IS_SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GRID))
#define IS_SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GRID))
#define SUDOKU_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GRID, SudokuGridClass))

typedef struct _SudokuGrid SudokuGrid;
typedef struct _SudokuGridClass SudokuGridClass;

struct _SudokuWindow {
	AdwApplicationWindow parent_instance;
	SudokuWindowPrivate * priv;
	SudokuStartView* start_view;
	SudokuGameView* game_view;
};

struct _SudokuWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _SudokuWindowPrivate {
	AdwViewStack* view_stack;
	gboolean _width_is_small;
	GtkCssProvider* accent_provider;
	AdwStyleManager* style_manager;
	GtkGestureClick* backwards_controller;
	GtkGestureClick* forwards_controller;
	GtkEventControllerScroll* scroll_controller;
	GtkEventControllerKey* capture_key_controller;
	gboolean _keyboard_pressed_recently;
	guint keyboard_pressed_timeout;
	SudokuWindowScreen _current_screen;
};

struct _SudokuStartView {
	AdwBin parent_instance;
	SudokuStartViewPrivate * priv;
	AdwHeaderBar* headerbar;
};

struct _SudokuStartViewClass {
	AdwBinClass parent_class;
};

struct _SudokuGameView {
	AdwBin parent_instance;
	SudokuGameViewPrivate * priv;
	SudokuGame* game;
	SudokuGrid* grid;
	SudokuWindow* window;
	gdouble* highscore;
};

struct _SudokuGameViewClass {
	AdwBinClass parent_class;
};

static gint SudokuWindow_private_offset;
static gpointer sudoku_window_parent_class = NULL;

VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN GType sudoku_start_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuStartView, g_object_unref)
VALA_EXTERN GType sudoku_game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGameView, g_object_unref)
VALA_EXTERN GType sudoku_window_screen_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
static void sudoku_window_visible_dialog_cb (SudokuWindow* self);
static void _sudoku_window_visible_dialog_cb_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void sudoku_window_construct_window_parameters (SudokuWindow* self);
static void sudoku_window_backwards_pressed_cb (SudokuWindow* self,
                                         GtkGestureClick* gesture,
                                         gint n_press,
                                         gdouble x,
                                         gdouble y);
static void _sudoku_window_backwards_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self);
static void sudoku_window_forwards_pressed_cb (SudokuWindow* self,
                                        GtkGestureClick* gesture,
                                        gint n_press,
                                        gdouble x,
                                        gdouble y);
static void _sudoku_window_forwards_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static gboolean sudoku_window_scroll_cb (SudokuWindow* self,
                                  GtkEventControllerScroll* event,
                                  gdouble dx,
                                  gdouble dy);
static gboolean _sudoku_window_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                      gdouble dx,
                                                                      gdouble dy,
                                                                      gpointer self);
static void sudoku_window_scroll_begin_cb (SudokuWindow* self,
                                    GtkEventControllerScroll* event);
static void _sudoku_window_scroll_begin_cb_gtk_event_controller_scroll_scroll_begin (GtkEventControllerScroll* _sender,
                                                                              gpointer self);
static void sudoku_window_scroll_end_cb (SudokuWindow* self,
                                  GtkEventControllerScroll* event);
static void _sudoku_window_scroll_end_cb_gtk_event_controller_scroll_scroll_end (GtkEventControllerScroll* _sender,
                                                                          gpointer self);
static gboolean sudoku_window_capture_key_pressed_cb (SudokuWindow* self,
                                               guint keyval,
                                               guint keycode,
                                               GdkModifierType state);
static gboolean _sudoku_window_capture_key_pressed_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                     guint keyval,
                                                                                     guint keycode,
                                                                                     GdkModifierType state,
                                                                                     gpointer self);
static void sudoku_window_set_accent_color (SudokuWindow* self);
static void _sudoku_window_set_accent_color_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void sudoku_window_set_width_is_small (SudokuWindow* self,
                                       gboolean value);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuBoard* board,
                               gdouble* highscore);
VALA_EXTERN void sudoku_game_view_init (SudokuGameView* self,
                            SudokuBoard* board,
                            gdouble* highscore,
                            SudokuWindow* window);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
VALA_EXTERN void sudoku_window_change_board (SudokuWindow* self,
                                 SudokuBoard* board,
                                 gdouble* highscore);
VALA_EXTERN void sudoku_game_view_change_board (SudokuGameView* self,
                                    SudokuBoard* board,
                                    gdouble* highscore);
VALA_EXTERN void sudoku_window_show_start_view (SudokuWindow* self);
static void sudoku_window_set_current_screen (SudokuWindow* self,
                                       SudokuWindowScreen value);
VALA_EXTERN GType sudoku_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGrid, g_object_unref)
VALA_EXTERN void sudoku_start_view_set_back_button_visible (SudokuStartView* self,
                                                gboolean enabled);
VALA_EXTERN SudokuWindowScreen sudoku_window_get_current_screen (SudokuWindow* self);
VALA_EXTERN void sudoku_grid_unselect (SudokuGrid* self);
static void sudoku_window_set_keyboard_pressed_recently (SudokuWindow* self,
                                                  gboolean value);
static gboolean __lambda6_ (SudokuWindow* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void sudoku_window_width_is_medium_cb (SudokuWindow* self);
static void sudoku_window_width_is_small_cb (SudokuWindow* self);
static void sudoku_window_real_size_allocate (GtkWidget* base,
                                       gint width,
                                       gint height,
                                       gint baseline);
VALA_EXTERN gboolean sudoku_window_get_width_is_small (SudokuWindow* self);
static void sudoku_window_real_dispose (GObject* base);
VALA_EXTERN gboolean sudoku_window_get_keyboard_pressed_recently (SudokuWindow* self);
static void sudoku_window_finalize (GObject * obj);
static GType sudoku_window_get_type_once (void);
static void _vala_sudoku_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_sudoku_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
sudoku_window_get_instance_private (SudokuWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuWindow_private_offset);
}

static void
_sudoku_window_visible_dialog_cb_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	sudoku_window_visible_dialog_cb ((SudokuWindow*) self);
}

static void
_sudoku_window_backwards_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                               gint n_press,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	sudoku_window_backwards_pressed_cb ((SudokuWindow*) self, _sender, n_press, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_sudoku_window_forwards_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                              gint n_press,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self)
{
	sudoku_window_forwards_pressed_cb ((SudokuWindow*) self, _sender, n_press, x, y);
}

static gboolean
_sudoku_window_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                             gdouble dx,
                                                             gdouble dy,
                                                             gpointer self)
{
	gboolean result;
	result = sudoku_window_scroll_cb ((SudokuWindow*) self, _sender, dx, dy);
	return result;
}

static void
_sudoku_window_scroll_begin_cb_gtk_event_controller_scroll_scroll_begin (GtkEventControllerScroll* _sender,
                                                                         gpointer self)
{
	sudoku_window_scroll_begin_cb ((SudokuWindow*) self, _sender);
}

static void
_sudoku_window_scroll_end_cb_gtk_event_controller_scroll_scroll_end (GtkEventControllerScroll* _sender,
                                                                     gpointer self)
{
	sudoku_window_scroll_end_cb ((SudokuWindow*) self, _sender);
}

static gboolean
_sudoku_window_capture_key_pressed_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self)
{
	gboolean result;
	result = sudoku_window_capture_key_pressed_cb ((SudokuWindow*) self, keyval, keycode, state);
	return result;
}

static void
_sudoku_window_set_accent_color_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	sudoku_window_set_accent_color ((SudokuWindow*) self);
}

SudokuWindow*
sudoku_window_construct (GType object_type,
                         GSettings* settings)
{
	SudokuWindow * self = NULL;
	GtkGestureClick* _tmp0_;
	GtkGestureClick* _tmp1_;
	GtkGestureClick* _tmp2_;
	GtkGestureClick* _tmp3_;
	GtkGestureClick* _tmp4_;
	GtkEventController* _tmp5_;
	GtkGestureClick* _tmp6_;
	GtkGestureClick* _tmp7_;
	GtkGestureClick* _tmp8_;
	GtkGestureClick* _tmp9_;
	GtkGestureClick* _tmp10_;
	GtkEventController* _tmp11_;
	GtkEventControllerScroll* _tmp12_;
	GtkEventControllerScroll* _tmp13_;
	GtkEventControllerScroll* _tmp14_;
	GtkEventControllerScroll* _tmp15_;
	GtkEventControllerScroll* _tmp16_;
	GtkEventControllerScroll* _tmp17_;
	GtkEventController* _tmp18_;
	GtkEventControllerKey* _tmp19_;
	GtkEventControllerKey* _tmp20_;
	GtkEventControllerKey* _tmp21_;
	GtkEventControllerKey* _tmp22_;
	GtkEventController* _tmp23_;
	GtkCssProvider* _tmp24_;
	GdkDisplay* _tmp25_;
	GtkCssProvider* _tmp26_;
	AdwStyleManager* _tmp27_;
	AdwStyleManager* _tmp28_;
	AdwStyleManager* _tmp29_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (SudokuWindow*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GObject*) self, "notify::visible-dialog", (GCallback) _sudoku_window_visible_dialog_cb_g_object_notify, self, 0);
	g_settings_bind (settings, "window-is-fullscreen", (GObject*) self, "fullscreened", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "window-is-maximized", (GObject*) self, "maximized", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "default-width", (GObject*) self, "default-width", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "default-height", (GObject*) self, "default-height", G_SETTINGS_BIND_DEFAULT);
	sudoku_window_construct_window_parameters (self);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->backwards_controller);
	self->priv->backwards_controller = _tmp0_;
	_tmp1_ = self->priv->backwards_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp1_, (guint) 8);
	_tmp2_ = self->priv->backwards_controller;
	g_signal_connect_object (_tmp2_, "pressed", (GCallback) _sudoku_window_backwards_pressed_cb_gtk_gesture_click_pressed, self, 0);
	_tmp3_ = self->priv->backwards_controller;
	gtk_event_controller_set_propagation_limit ((GtkEventController*) _tmp3_, GTK_LIMIT_NONE);
	_tmp4_ = self->priv->backwards_controller;
	_tmp5_ = _g_object_ref0 ((GtkEventController*) _tmp4_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp5_);
	_tmp6_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->forwards_controller);
	self->priv->forwards_controller = _tmp6_;
	_tmp7_ = self->priv->forwards_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp7_, (guint) 9);
	_tmp8_ = self->priv->forwards_controller;
	g_signal_connect_object (_tmp8_, "pressed", (GCallback) _sudoku_window_forwards_pressed_cb_gtk_gesture_click_pressed, self, 0);
	_tmp9_ = self->priv->forwards_controller;
	gtk_event_controller_set_propagation_limit ((GtkEventController*) _tmp9_, GTK_LIMIT_NONE);
	_tmp10_ = self->priv->forwards_controller;
	_tmp11_ = _g_object_ref0 ((GtkEventController*) _tmp10_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_);
	_tmp12_ = (GtkEventControllerScroll*) gtk_event_controller_scroll_new (GTK_EVENT_CONTROLLER_SCROLL_VERTICAL);
	_g_object_unref0 (self->priv->scroll_controller);
	self->priv->scroll_controller = _tmp12_;
	_tmp13_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp13_, "scroll", (GCallback) _sudoku_window_scroll_cb_gtk_event_controller_scroll_scroll, self, 0);
	_tmp14_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp14_, "scroll-begin", (GCallback) _sudoku_window_scroll_begin_cb_gtk_event_controller_scroll_scroll_begin, self, 0);
	_tmp15_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp15_, "scroll-end", (GCallback) _sudoku_window_scroll_end_cb_gtk_event_controller_scroll_scroll_end, self, 0);
	_tmp16_ = self->priv->scroll_controller;
	gtk_event_controller_set_propagation_limit ((GtkEventController*) _tmp16_, GTK_LIMIT_NONE);
	_tmp17_ = self->priv->scroll_controller;
	_tmp18_ = _g_object_ref0 ((GtkEventController*) _tmp17_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp18_);
	_tmp19_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->capture_key_controller);
	self->priv->capture_key_controller = _tmp19_;
	_tmp20_ = self->priv->capture_key_controller;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp20_, GTK_PHASE_CAPTURE);
	_tmp21_ = self->priv->capture_key_controller;
	g_signal_connect_object (_tmp21_, "key-pressed", (GCallback) _sudoku_window_capture_key_pressed_cb_gtk_event_controller_key_key_pressed, self, 0);
	_tmp22_ = self->priv->capture_key_controller;
	_tmp23_ = _g_object_ref0 ((GtkEventController*) _tmp22_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp23_);
	_tmp24_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->accent_provider);
	self->priv->accent_provider = _tmp24_;
	_tmp25_ = gtk_root_get_display ((GtkRoot*) self);
	_tmp26_ = self->priv->accent_provider;
	gtk_style_context_add_provider_for_display (_tmp25_, (GtkStyleProvider*) _tmp26_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp27_ = adw_style_manager_get_default ();
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (self->priv->style_manager);
	self->priv->style_manager = _tmp28_;
	sudoku_window_set_accent_color (self);
	_tmp29_ = self->priv->style_manager;
	g_signal_connect_object ((GObject*) _tmp29_, "notify::accent-color", (GCallback) _sudoku_window_set_accent_color_g_object_notify, self, 0);
	return self;
}

SudokuWindow*
sudoku_window_new (GSettings* settings)
{
	return sudoku_window_construct (TYPE_SUDOKU_WINDOW, settings);
}

static void
sudoku_window_construct_window_parameters (SudokuWindow* self)
{
	gint headerbar_natural_height = 0;
	SudokuStartView* _tmp0_;
	AdwHeaderBar* _tmp1_;
	gint _tmp2_ = 0;
	gint small_window_height = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->start_view;
	_tmp1_ = _tmp0_->headerbar;
	gtk_widget_measure ((GtkWidget*) _tmp1_, GTK_ORIENTATION_VERTICAL, -1, NULL, &_tmp2_, NULL, NULL);
	headerbar_natural_height = _tmp2_;
	small_window_height = SUDOKU_WINDOW_SMALL_WINDOW_WIDTH + headerbar_natural_height;
	g_object_get ((GtkWindow*) self, "default-width", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	sudoku_window_set_width_is_small (self, _tmp4_ <= SUDOKU_WINDOW_MEDIUM_WINDOW_WIDTH);
	gtk_widget_set_size_request ((GtkWidget*) self, SUDOKU_WINDOW_SMALL_WINDOW_WIDTH, small_window_height);
	g_object_get ((GtkWindow*) self, "default-width", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	g_object_get ((GtkWindow*) self, "default-height", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp6_, _tmp8_);
}

static void
sudoku_window_set_accent_color (SudokuWindow* self)
{
	AdwAccentColor color = 0;
	AdwStyleManager* _tmp0_;
	gchar* css_color = NULL;
	gchar* s = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkCssProvider* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->style_manager;
	color = adw_style_manager_get_accent_color (_tmp0_);
	switch (color) {
		case ADW_ACCENT_COLOR_BLUE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("blue");
			_g_free0 (css_color);
			css_color = _tmp1_;
			break;
		}
		case ADW_ACCENT_COLOR_TEAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("teal");
			_g_free0 (css_color);
			css_color = _tmp2_;
			break;
		}
		case ADW_ACCENT_COLOR_GREEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("green");
			_g_free0 (css_color);
			css_color = _tmp3_;
			break;
		}
		case ADW_ACCENT_COLOR_YELLOW:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("yellow");
			_g_free0 (css_color);
			css_color = _tmp4_;
			break;
		}
		case ADW_ACCENT_COLOR_ORANGE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("orange");
			_g_free0 (css_color);
			css_color = _tmp5_;
			break;
		}
		case ADW_ACCENT_COLOR_RED:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("red");
			_g_free0 (css_color);
			css_color = _tmp6_;
			break;
		}
		case ADW_ACCENT_COLOR_PINK:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("pink");
			_g_free0 (css_color);
			css_color = _tmp7_;
			break;
		}
		case ADW_ACCENT_COLOR_PURPLE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("purple");
			_g_free0 (css_color);
			css_color = _tmp8_;
			break;
		}
		case ADW_ACCENT_COLOR_SLATE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("slate");
			_g_free0 (css_color);
			css_color = _tmp9_;
			break;
		}
		default:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("blue");
			_g_free0 (css_color);
			css_color = _tmp10_;
			break;
		}
	}
	_tmp11_ = css_color;
	_tmp12_ = g_strconcat (":root {--sudoku-accent-color: var(--sudoku-accent-", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, ");}", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	s = _tmp15_;
	_tmp16_ = self->priv->accent_provider;
	gtk_css_provider_load_from_string (_tmp16_, s);
	_g_free0 (s);
	_g_free0 (css_color);
}

void
sudoku_window_start_game (SudokuWindow* self,
                          SudokuBoard* board,
                          gdouble* highscore)
{
	SudokuGameView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->game_view;
	sudoku_game_view_init (_tmp0_, board, highscore, self);
	sudoku_window_show_game_view (self);
}

void
sudoku_window_change_board (SudokuWindow* self,
                            SudokuBoard* board,
                            gdouble* highscore)
{
	SudokuGameView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->game_view;
	sudoku_game_view_change_board (_tmp0_, board, highscore);
	sudoku_window_show_game_view (self);
}

void
sudoku_window_show_start_view (SudokuWindow* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGameView* _tmp1_;
	SudokuStartView* _tmp4_;
	AdwViewStack* _tmp5_;
	SudokuStartView* _tmp6_;
	SudokuStartView* _tmp7_;
	g_return_if_fail (self != NULL);
	sudoku_window_set_current_screen (self, SUDOKU_WINDOW_SCREEN_START);
	_tmp1_ = self->game_view;
	if (_tmp1_ != NULL) {
		SudokuGameView* _tmp2_;
		SudokuGame* _tmp3_;
		_tmp2_ = self->game_view;
		_tmp3_ = _tmp2_->game;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = self->start_view;
	sudoku_start_view_set_back_button_visible (_tmp4_, _tmp0_);
	_tmp5_ = self->priv->view_stack;
	_tmp6_ = self->start_view;
	adw_view_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->start_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
}

void
sudoku_window_show_game_view (SudokuWindow* self)
{
	SudokuGameView* _tmp0_;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	GameMode _tmp3_;
	AdwViewStack* _tmp4_;
	SudokuGameView* _tmp5_;
	SudokuGameView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->game_view;
	_tmp1_ = _tmp0_->game;
	_tmp2_ = sudoku_game_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	sudoku_window_set_current_screen (self, (SudokuWindowScreen) _tmp3_);
	_tmp4_ = self->priv->view_stack;
	_tmp5_ = self->game_view;
	adw_view_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->game_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
}

static void
sudoku_window_visible_dialog_cb (SudokuWindow* self)
{
	SudokuWindowScreen _tmp0_;
	AdwDialog* _tmp1_;
	AdwDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_screen;
	if (_tmp0_ == SUDOKU_WINDOW_SCREEN_START) {
		return;
	}
	_tmp1_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SudokuGameView* _tmp3_;
		SudokuGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		SudokuGameView* _tmp9_;
		SudokuGrid* _tmp10_;
		_tmp3_ = self->game_view;
		_tmp4_ = _tmp3_->game;
		_tmp5_ = sudoku_game_get_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!_tmp6_) {
			SudokuGameView* _tmp7_;
			SudokuGame* _tmp8_;
			_tmp7_ = self->game_view;
			_tmp8_ = _tmp7_->game;
			sudoku_game_stop_clock (_tmp8_);
		}
		_tmp9_ = self->game_view;
		_tmp10_ = _tmp9_->grid;
		sudoku_grid_unselect (_tmp10_);
	} else {
		SudokuGameView* _tmp11_;
		SudokuGame* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp17_ = FALSE;
		SudokuGameView* _tmp18_;
		SudokuGame* _tmp19_;
		SudokuBoard* _tmp20_;
		SudokuBoard* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp11_ = self->game_view;
		_tmp12_ = _tmp11_->game;
		_tmp13_ = sudoku_game_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		if (!_tmp14_) {
			SudokuGameView* _tmp15_;
			SudokuGame* _tmp16_;
			_tmp15_ = self->game_view;
			_tmp16_ = _tmp15_->game;
			sudoku_game_resume_clock (_tmp16_);
		}
		_tmp18_ = self->game_view;
		_tmp19_ = _tmp18_->game;
		_tmp20_ = sudoku_game_get_board (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = sudoku_board_get_complete (_tmp21_);
		_tmp23_ = _tmp22_;
		if (!_tmp23_) {
			SudokuGameView* _tmp24_;
			SudokuGame* _tmp25_;
			GameMode _tmp26_;
			GameMode _tmp27_;
			_tmp24_ = self->game_view;
			_tmp25_ = _tmp24_->game;
			_tmp26_ = sudoku_game_get_mode (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp17_ = _tmp27_ == GAME_MODE_PLAY;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			SudokuGameView* _tmp28_;
			_tmp28_ = self->game_view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp28_);
		}
	}
}

static void
sudoku_window_backwards_pressed_cb (SudokuWindow* self,
                                    GtkGestureClick* gesture,
                                    gint n_press,
                                    gdouble x,
                                    gdouble y)
{
	SudokuWindowScreen _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_tmp0_ = self->priv->_current_screen;
	if (_tmp0_ == SUDOKU_WINDOW_SCREEN_START) {
		gtk_widget_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "app.back", NULL, NULL);
	} else {
		SudokuGameView* _tmp1_;
		_tmp1_ = self->game_view;
		gtk_widget_activate_action ((GtkWidget*) _tmp1_, "game-view.undo", NULL, NULL);
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

static void
sudoku_window_forwards_pressed_cb (SudokuWindow* self,
                                   GtkGestureClick* gesture,
                                   gint n_press,
                                   gdouble x,
                                   gdouble y)
{
	SudokuWindowScreen _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_tmp0_ = self->priv->_current_screen;
	if (_tmp0_ != SUDOKU_WINDOW_SCREEN_START) {
		SudokuGameView* _tmp1_;
		_tmp1_ = self->game_view;
		gtk_widget_activate_action ((GtkWidget*) _tmp1_, "game-view.redo", NULL, NULL);
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

static gboolean
sudoku_window_scroll_cb (SudokuWindow* self,
                         GtkEventControllerScroll* event,
                         gdouble dx,
                         gdouble dy)
{
	GdkModifierType state = 0U;
	gboolean control_pressed = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	state = gtk_event_controller_get_current_event_state ((GtkEventController*) event);
	control_pressed = (gboolean) (state & GDK_CONTROL_MASK);
	if (control_pressed) {
		if (dy <= ((gdouble) -1)) {
			gtk_widget_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "app.zoom-in", NULL, NULL);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			if (dy >= ((gdouble) 1)) {
				gtk_widget_activate_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "app.zoom-out", NULL, NULL);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
sudoku_window_scroll_begin_cb (SudokuWindow* self,
                               GtkEventControllerScroll* event)
{
	GdkModifierType state = 0U;
	gboolean control_pressed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	state = gtk_event_controller_get_current_event_state ((GtkEventController*) event);
	control_pressed = (gboolean) (state & GDK_CONTROL_MASK);
	if (control_pressed) {
		gtk_event_controller_scroll_set_flags (event, GTK_EVENT_CONTROLLER_SCROLL_VERTICAL | GTK_EVENT_CONTROLLER_SCROLL_DISCRETE);
	}
}

static void
sudoku_window_scroll_end_cb (SudokuWindow* self,
                             GtkEventControllerScroll* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	gtk_event_controller_scroll_set_flags (event, GTK_EVENT_CONTROLLER_SCROLL_VERTICAL);
}

static gboolean
__lambda6_ (SudokuWindow* self)
{
	gboolean result;
	sudoku_window_set_keyboard_pressed_recently (self, FALSE);
	self->priv->keyboard_pressed_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((SudokuWindow*) self);
	return result;
}

static gboolean
sudoku_window_capture_key_pressed_cb (SudokuWindow* self,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	sudoku_window_set_keyboard_pressed_recently (self, TRUE);
	if (self->priv->keyboard_pressed_timeout != ((guint) 0)) {
		g_source_remove (self->priv->keyboard_pressed_timeout);
		self->priv->keyboard_pressed_timeout = (guint) 0;
	}
	self->priv->keyboard_pressed_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
sudoku_window_width_is_medium_cb (SudokuWindow* self)
{
	g_return_if_fail (self != NULL);
	sudoku_window_set_width_is_small (self, FALSE);
}

static void
sudoku_window_width_is_small_cb (SudokuWindow* self)
{
	g_return_if_fail (self != NULL);
	sudoku_window_set_width_is_small (self, TRUE);
}

static void
sudoku_window_real_size_allocate (GtkWidget* base,
                                  gint width,
                                  gint height,
                                  gint baseline)
{
	SudokuWindow * self;
	gboolean _tmp0_ = FALSE;
	self = (SudokuWindow*) base;
	if (width < SUDOKU_WINDOW_MEDIUM_WINDOW_WIDTH) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_width_is_small;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		sudoku_window_width_is_small_cb (self);
	} else {
		gboolean _tmp2_ = FALSE;
		if (width >= SUDOKU_WINDOW_MEDIUM_WINDOW_WIDTH) {
			gboolean _tmp3_;
			_tmp3_ = self->priv->_width_is_small;
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			sudoku_window_width_is_medium_cb (self);
		}
	}
	GTK_WIDGET_CLASS (sudoku_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow), width, height, baseline);
}

static void
sudoku_window_real_dispose (GObject* base)
{
	SudokuWindow * self;
	self = (SudokuWindow*) base;
	gtk_widget_dispose_template ((GtkWidget*) self, G_TYPE_FROM_INSTANCE ((GObject*) self));
	G_OBJECT_CLASS (sudoku_window_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
}

gboolean
sudoku_window_get_width_is_small (SudokuWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_width_is_small;
	return result;
}

static void
sudoku_window_set_width_is_small (SudokuWindow* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_window_get_width_is_small (self);
	if (old_value != value) {
		self->priv->_width_is_small = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY]);
	}
}

gboolean
sudoku_window_get_keyboard_pressed_recently (SudokuWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_keyboard_pressed_recently;
	return result;
}

static void
sudoku_window_set_keyboard_pressed_recently (SudokuWindow* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_window_get_keyboard_pressed_recently (self);
	if (old_value != value) {
		self->priv->_keyboard_pressed_recently = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY]);
	}
}

SudokuWindowScreen
sudoku_window_get_current_screen (SudokuWindow* self)
{
	SudokuWindowScreen result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_screen;
	return result;
}

static void
sudoku_window_set_current_screen (SudokuWindow* self,
                                  SudokuWindowScreen value)
{
	SudokuWindowScreen old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_window_get_current_screen (self);
	if (old_value != value) {
		self->priv->_current_screen = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY]);
	}
}

static void
sudoku_window_class_init (SudokuWindowClass * klass,
                          gpointer klass_data)
{
	sudoku_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) sudoku_window_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_window_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY] = g_param_spec_boolean ("width-is-small", "width-is-small", "width-is-small", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY] = g_param_spec_boolean ("keyboard-pressed-recently", "keyboard-pressed-recently", "keyboard-pressed-recently", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY] = g_param_spec_enum ("current-screen", "current-screen", "current-screen", TYPE_SUDOKU_WINDOW_SCREEN, SUDOKU_WINDOW_SCREEN_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_stack", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, view_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_view", FALSE, G_STRUCT_OFFSET (SudokuWindow, start_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_view", FALSE, G_STRUCT_OFFSET (SudokuWindow, game_view));
}

static void
sudoku_window_instance_init (SudokuWindow * self,
                             gpointer klass)
{
	self->priv = sudoku_window_get_instance_private (self);
	self->priv->_current_screen = SUDOKU_WINDOW_SCREEN_NONE;
	g_type_ensure (TYPE_SUDOKU_START_VIEW);
	g_type_ensure (TYPE_SUDOKU_GAME_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sudoku_window_finalize (GObject * obj)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_WINDOW, SudokuWindow);
	_g_object_unref0 (self->priv->accent_provider);
	_g_object_unref0 (self->priv->style_manager);
	_g_object_unref0 (self->priv->backwards_controller);
	_g_object_unref0 (self->priv->forwards_controller);
	_g_object_unref0 (self->priv->scroll_controller);
	_g_object_unref0 (self->priv->capture_key_controller);
	G_OBJECT_CLASS (sudoku_window_parent_class)->finalize (obj);
}

static GType
sudoku_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuWindow), 0, (GInstanceInitFunc) sudoku_window_instance_init, NULL };
	GType sudoku_window_type_id;
	sudoku_window_type_id = g_type_register_static (adw_application_window_get_type (), "SudokuWindow", &g_define_type_info, 0);
	SudokuWindow_private_offset = g_type_add_instance_private (sudoku_window_type_id, sizeof (SudokuWindowPrivate));
	return sudoku_window_type_id;
}

GType
sudoku_window_get_type (void)
{
	static volatile gsize sudoku_window_type_id__once = 0;
	if (g_once_init_enter (&sudoku_window_type_id__once)) {
		GType sudoku_window_type_id;
		sudoku_window_type_id = sudoku_window_get_type_once ();
		g_once_init_leave (&sudoku_window_type_id__once, sudoku_window_type_id);
	}
	return sudoku_window_type_id__once;
}

static void
_vala_sudoku_window_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY:
		g_value_set_boolean (value, sudoku_window_get_width_is_small (self));
		break;
		case SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY:
		g_value_set_boolean (value, sudoku_window_get_keyboard_pressed_recently (self));
		break;
		case SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY:
		g_value_set_enum (value, sudoku_window_get_current_screen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_window_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_WIDTH_IS_SMALL_PROPERTY:
		sudoku_window_set_width_is_small (self, g_value_get_boolean (value));
		break;
		case SUDOKU_WINDOW_KEYBOARD_PRESSED_RECENTLY_PROPERTY:
		sudoku_window_set_keyboard_pressed_recently (self, g_value_get_boolean (value));
		break;
		case SUDOKU_WINDOW_CURRENT_SCREEN_PROPERTY:
		sudoku_window_set_current_screen (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
sudoku_window_screen_get_type_once (void)
{
	static const GEnumValue values[] = {{SUDOKU_WINDOW_SCREEN_NONE, "SUDOKU_WINDOW_SCREEN_NONE", "none"}, {SUDOKU_WINDOW_SCREEN_PLAY, "SUDOKU_WINDOW_SCREEN_PLAY", "play"}, {SUDOKU_WINDOW_SCREEN_CREATE, "SUDOKU_WINDOW_SCREEN_CREATE", "create"}, {SUDOKU_WINDOW_SCREEN_START, "SUDOKU_WINDOW_SCREEN_START", "start"}, {0, NULL, NULL}};
	GType sudoku_window_screen_type_id;
	sudoku_window_screen_type_id = g_enum_register_static ("SudokuWindowScreen", values);
	return sudoku_window_screen_type_id;
}

GType
sudoku_window_screen_get_type (void)
{
	static volatile gsize sudoku_window_screen_type_id__once = 0;
	if (g_once_init_enter (&sudoku_window_screen_type_id__once)) {
		GType sudoku_window_screen_type_id;
		sudoku_window_screen_type_id = sudoku_window_screen_get_type_once ();
		g_once_init_leave (&sudoku_window_screen_type_id__once, sudoku_window_screen_type_id);
	}
	return sudoku_window_screen_type_id__once;
}

