/* sudoku-generator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include "libsudoku.h"
#include <gee.h>
#include <qqwing-wrapper.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SUDOKU_GENERATOR_TYPE_WORKER (sudoku_generator_worker_get_type ())
#define SUDOKU_GENERATOR_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker))
#define SUDOKU_GENERATOR_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))
#define SUDOKU_GENERATOR_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))

typedef struct _SudokuGeneratorWorker SudokuGeneratorWorker;
typedef struct _SudokuGeneratorWorkerClass SudokuGeneratorWorkerClass;
typedef struct _SudokuGeneratorWorkerPrivate SudokuGeneratorWorkerPrivate;
enum  {
	SUDOKU_GENERATOR_WORKER_0_PROPERTY,
	SUDOKU_GENERATOR_WORKER_NUM_PROPERTIES
};
static GParamSpec* sudoku_generator_worker_properties[SUDOKU_GENERATOR_WORKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;

struct _SudokuGeneratorWorker {
	GObject parent_instance;
	SudokuGeneratorWorkerPrivate * priv;
};

struct _SudokuGeneratorWorkerClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorWorkerPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};

struct _Block1Data {
	int _ref_count_;
	GThreadPool* pool;
	gpointer _async_data_;
};

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gint nboards;
	DifficultyCategory category;
	GCancellable* cancellable;
	GeeList* result;
	Block1Data* _data1_;
	GeeArrayList* boards;
	GeeArrayList* _tmp0_;
	GThreadPool* _tmp1_;
	gint i;
	gboolean _tmp2_;
	gint _tmp3_;
	GThreadPool* _tmp4_;
	GeeArrayList* _tmp5_;
	SudokuGeneratorWorker* _tmp6_;
	GError* _inner_error0_;
};

static gint SudokuGeneratorWorker_private_offset;
static gpointer sudoku_generator_worker_parent_class = NULL;
static GMutex sudoku_generator_worker_mutex;
static GMutex sudoku_generator_worker_mutex = {0};

VALA_EXTERN GType sudoku_generator_worker_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus,
                                                    DifficultyCategory level,
                                                    GeeList* boards_list,
                                                    GSourceFunc callback,
                                                    gpointer callback_target);
VALA_EXTERN SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type,
                                                          gint nsudokus,
                                                          DifficultyCategory level,
                                                          GeeList* boards_list,
                                                          GSourceFunc callback,
                                                          gpointer callback_target);
VALA_EXTERN void sudoku_generator_worker_run (SudokuGeneratorWorker* self);
VALA_EXTERN SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
static gboolean ___lambda5_ (SudokuGeneratorWorker* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void sudoku_generator_worker_finalize (GObject * obj);
static GType sudoku_generator_worker_get_type_once (void);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (SudokuGeneratorWorker* worker);
static void ___lambda6__gfunc (gpointer data,
                        gpointer self);
static void ___lambda7_ (Block1Data* _data1_);
static void ____lambda7__gfunc (gconstpointer data,
                         gpointer self);
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sudoku_generator_worker_get_instance_private (SudokuGeneratorWorker* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuGeneratorWorker_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SudokuGeneratorWorker*
sudoku_generator_worker_construct (GType object_type,
                                   gint nsudokus,
                                   DifficultyCategory level,
                                   GeeList* boards_list,
                                   GSourceFunc callback,
                                   gpointer callback_target)
{
	SudokuGeneratorWorker * self = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (boards_list != NULL, NULL);
	self = (SudokuGeneratorWorker*) g_object_new (object_type, NULL);
	self->priv->nsudokus = nsudokus;
	self->priv->level = level;
	_tmp0_ = _g_object_ref0 (boards_list);
	_g_object_unref0 (self->priv->boards_list);
	self->priv->boards_list = _tmp0_;
	self->priv->callback = callback;
	self->priv->callback_target = callback_target;
	return self;
}

SudokuGeneratorWorker*
sudoku_generator_worker_new (gint nsudokus,
                             DifficultyCategory level,
                             GeeList* boards_list,
                             GSourceFunc callback,
                             gpointer callback_target)
{
	return sudoku_generator_worker_construct (SUDOKU_GENERATOR_TYPE_WORKER, nsudokus, level, boards_list, callback, callback_target);
}

static gboolean
___lambda5_ (SudokuGeneratorWorker* self)
{
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((SudokuGeneratorWorker*) self);
	return result;
}

void
sudoku_generator_worker_run (SudokuGeneratorWorker* self)
{
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	GeeList* _tmp1_;
	SudokuBoard* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_generator_generate_board (self->priv->level);
	board = _tmp0_;
	g_mutex_lock (&sudoku_generator_worker_mutex);
	_tmp1_ = self->priv->boards_list;
	_tmp2_ = board;
	gee_collection_add ((GeeCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->boards_list;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == self->priv->nsudokus) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
	}
	g_mutex_unlock (&sudoku_generator_worker_mutex);
	_g_object_unref0 (board);
}

static void
sudoku_generator_worker_class_init (SudokuGeneratorWorkerClass * klass,
                                    gpointer klass_data)
{
	sudoku_generator_worker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuGeneratorWorker_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_worker_finalize;
}

static void
sudoku_generator_worker_instance_init (SudokuGeneratorWorker * self,
                                       gpointer klass)
{
	self->priv = sudoku_generator_worker_get_instance_private (self);
}

static void
sudoku_generator_worker_finalize (GObject * obj)
{
	SudokuGeneratorWorker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker);
	_g_object_unref0 (self->priv->boards_list);
	G_OBJECT_CLASS (sudoku_generator_worker_parent_class)->finalize (obj);
}

static GType
sudoku_generator_worker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGeneratorWorker), 0, (GInstanceInitFunc) sudoku_generator_worker_instance_init, NULL };
	GType sudoku_generator_worker_type_id;
	sudoku_generator_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGeneratorWorker", &g_define_type_info, 0);
	SudokuGeneratorWorker_private_offset = g_type_add_instance_private (sudoku_generator_worker_type_id, sizeof (SudokuGeneratorWorkerPrivate));
	return sudoku_generator_worker_type_id;
}

GType
sudoku_generator_worker_get_type (void)
{
	static volatile gsize sudoku_generator_worker_type_id__once = 0;
	if (g_once_init_enter (&sudoku_generator_worker_type_id__once)) {
		GType sudoku_generator_worker_type_id;
		sudoku_generator_worker_type_id = sudoku_generator_worker_get_type_once ();
		g_once_init_leave (&sudoku_generator_worker_type_id__once, sudoku_generator_worker_type_id);
	}
	return sudoku_generator_worker_type_id__once;
}

SudokuBoard*
sudoku_generator_generate_board (DifficultyCategory category)
{
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	gint* puzzle = NULL;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SudokuBoard* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint puzzle_length1;
	gint _puzzle_size_;
	SudokuBoard* _tmp25_;
	SudokuBoard* result;
	_tmp0_ = sudoku_board_new ();
	board = _tmp0_;
	_tmp1_ = board;
	_tmp2_ = sudoku_board_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = board;
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint, _tmp3_ * _tmp6_);
	puzzle = _tmp7_;
	puzzle_length1 = _tmp3_ * _tmp6_;
	_puzzle_size_ = puzzle_length1;
	if (category != DIFFICULTY_CATEGORY_CUSTOM) {
		gint* _tmp8_;
		_tmp8_ = qqwing_generate_puzzle ((gint) category);
		puzzle = (g_free (puzzle), NULL);
		puzzle = _tmp8_;
		puzzle_length1 = -1;
		_puzzle_size_ = puzzle_length1;
	}
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = row;
					row = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = board;
				_tmp12_ = sudoku_board_get_rows (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(row < _tmp13_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint val = 0;
							gint* _tmp19_;
							gint _tmp19__length1;
							SudokuBoard* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = col;
								col = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = board;
							_tmp17_ = sudoku_board_get_cols (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(col < _tmp18_)) {
								break;
							}
							_tmp19_ = puzzle;
							_tmp19__length1 = puzzle_length1;
							_tmp20_ = board;
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
							_tmp22_ = _tmp21_;
							_tmp23_ = _tmp19_[(row * _tmp22_) + col];
							val = _tmp23_;
							if (val != 0) {
								SudokuBoard* _tmp24_;
								_tmp24_ = board;
								sudoku_board_insert (_tmp24_, row, col, val, TRUE);
							}
						}
					}
				}
			}
		}
	}
	_tmp25_ = board;
	sudoku_board_set_difficulty_category (_tmp25_, category);
	result = board;
	puzzle = (g_free (puzzle), NULL);
	return result;
}

static void
sudoku_generator_generate_boards_async_data_free (gpointer _data)
{
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
}

void
sudoku_generator_generate_boards_async (gint nboards,
                                        DifficultyCategory category,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	GCancellable* _tmp0_;
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
	_data_->nboards = nboards;
	_data_->category = category;
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	sudoku_generator_generate_boards_async_co (_data_);
}

GeeList*
sudoku_generator_generate_boards_finish (GAsyncResult* _res_,
                                         GError** error)
{
	GeeList* result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_thread_pool_free0 (_data1_->pool);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda6_ (SudokuGeneratorWorker* worker)
{
	g_return_if_fail (worker != NULL);
	sudoku_generator_worker_run (worker);
	_g_object_unref0 (worker);
}

static void
___lambda6__gfunc (gpointer data,
                   gpointer self)
{
	__lambda6_ ((SudokuGeneratorWorker*) data);
}

static void
vala__g_thread_pool_free_wrapper (GThreadPool* pool,
                                  gboolean immediate,
                                  gboolean wait)
{
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		_tmp2_ = ptr;
		g_thread_pool_free ((GThreadPool*) _tmp2_, immediate, wait);
	}
	_g_thread_pool_free0 (pool);
}

static void
___lambda7_ (Block1Data* _data1_)
{
	GThreadPool* _tmp0_;
	_tmp0_ = _data1_->pool;
	_data1_->pool = NULL;
	vala__g_thread_pool_free_wrapper (_tmp0_, TRUE, FALSE);
	sudoku_generator_generate_boards_async_co (_data1_->_async_data_);
}

static void
____lambda7__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda7_ (self);
}

static gboolean
_sudoku_generator_generate_boards_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
	return result;
}

static gboolean
sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->boards = _data_->_tmp0_;
	_data_->_tmp1_ = g_thread_pool_new (___lambda6__gfunc, NULL, (gint) g_get_num_processors (), FALSE, &_data_->_inner_error0_);
	_data_->_data1_->pool = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_THREAD_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->cancellable != NULL) {
		g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda7__gfunc, block1_data_ref (_data_->_data1_), block1_data_unref);
	}
	{
		_data_->i = 0;
		{
			_data_->_tmp2_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->i;
					_data_->i = _data_->_tmp3_ + 1;
				}
				_data_->_tmp2_ = FALSE;
				if (!(_data_->i < _data_->nboards)) {
					break;
				}
				_data_->_tmp4_ = _data_->_data1_->pool;
				_data_->_tmp5_ = _data_->boards;
				_data_->_tmp6_ = sudoku_generator_worker_new (_data_->nboards, _data_->category, (GeeList*) _data_->_tmp5_, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
				g_thread_pool_push (_data_->_tmp4_, _data_->_tmp6_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == G_THREAD_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->boards);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->boards);
						block1_data_unref (_data_->_data1_);
						_data_->_data1_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_cancellable_set_error_if_cancelled (_data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_THREAD_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->boards);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = (GeeList*) _data_->boards;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
sudoku_generator_print_stats (SudokuBoard* board)
{
	gint* cells = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint cells_length1;
	gint cells_length2;
	gint* puzzle = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint puzzle_length1;
	gint _puzzle_size_;
	gint* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (board != NULL);
	_tmp2_ = sudoku_board_get_cells (board, &_tmp0_, &_tmp1_);
	cells = _tmp2_;
	cells_length1 = _tmp0_;
	cells_length2 = _tmp1_;
	_tmp3_ = sudoku_board_get_rows (board);
	_tmp4_ = _tmp3_;
	_tmp5_ = sudoku_board_get_cols (board);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint, _tmp4_ * _tmp6_);
	puzzle = _tmp7_;
	puzzle_length1 = _tmp4_ * _tmp6_;
	_puzzle_size_ = puzzle_length1;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = row;
					row = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = sudoku_board_get_rows (board);
				_tmp11_ = _tmp10_;
				if (!(row < _tmp11_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp14_;
							gint _tmp15_;
							gint* _tmp16_;
							gint _tmp16__length1;
							gint _tmp17_;
							gint _tmp18_;
							gint* _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							gint _tmp20_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = col;
								col = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = sudoku_board_get_cols (board);
							_tmp15_ = _tmp14_;
							if (!(col < _tmp15_)) {
								break;
							}
							_tmp16_ = puzzle;
							_tmp16__length1 = puzzle_length1;
							_tmp17_ = sudoku_board_get_cols (board);
							_tmp18_ = _tmp17_;
							_tmp19_ = cells;
							_tmp19__length1 = cells_length1;
							_tmp19__length2 = cells_length2;
							_tmp20_ = _tmp19_[(row * _tmp19__length2) + col];
							_tmp16_[(row * _tmp18_) + col] = _tmp20_;
						}
					}
				}
			}
		}
	}
	_tmp21_ = puzzle;
	_tmp21__length1 = puzzle_length1;
	qqwing_print_stats (_tmp21_);
	puzzle = (g_free (puzzle), NULL);
	cells = (g_free (cells), NULL);
}

gchar*
sudoku_generator_qqwing_version (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = qqwing_get_version ();
	result = _tmp0_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

