//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBDatabaseFileChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBFactoryChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBVersionChangeTransactionChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBDatabaseChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PBackgroundIDBDatabaseChild::RecvPBackgroundIDBVersionChangeTransactionConstructor(
        PBackgroundIDBVersionChangeTransactionChild* actor,
        const uint64_t& currentVersion,
        const uint64_t& requestedVersion,
        const int64_t& nextObjectStoreId,
        const int64_t& nextIndexId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBDatabaseChild::PBackgroundIDBDatabaseChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBDatabaseChild);
}

PBackgroundIDBDatabaseChild::~PBackgroundIDBDatabaseChild()
{
    MOZ_COUNT_DTOR(PBackgroundIDBDatabaseChild);
}

auto PBackgroundIDBDatabaseChild::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBDatabaseChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBDatabaseChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBDatabaseChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBDatabaseChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBDatabaseChild::Manager() const -> PBackgroundIDBFactoryChild*
{
    return static_cast<PBackgroundIDBFactoryChild*>(IProtocol::Manager());
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBDatabaseFileChild(nsTArray<PBackgroundIDBDatabaseFileChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBDatabaseFileChild.ToArray(aArr);
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBDatabaseFileChild() const -> const ManagedContainer<PBackgroundIDBDatabaseFileChild>&
{
    return mManagedPBackgroundIDBDatabaseFileChild;
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBTransactionChild(nsTArray<PBackgroundIDBTransactionChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBTransactionChild.ToArray(aArr);
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBTransactionChild() const -> const ManagedContainer<PBackgroundIDBTransactionChild>&
{
    return mManagedPBackgroundIDBTransactionChild;
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBVersionChangeTransactionChild(nsTArray<PBackgroundIDBVersionChangeTransactionChild*>& aArr) const -> void
{
    mManagedPBackgroundIDBVersionChangeTransactionChild.ToArray(aArr);
}

auto PBackgroundIDBDatabaseChild::ManagedPBackgroundIDBVersionChangeTransactionChild() const -> const ManagedContainer<PBackgroundIDBVersionChangeTransactionChild>&
{
    return mManagedPBackgroundIDBVersionChangeTransactionChild;
}

auto PBackgroundIDBDatabaseChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PBackgroundIDBDatabaseFileMsgStart,
        PBackgroundIDBTransactionMsgStart,
        PBackgroundIDBVersionChangeTransactionMsgStart
    };
    return sIds;
}

auto PBackgroundIDBDatabaseChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PBackgroundIDBDatabaseFileMsgStart:
        return (&(mManagedPBackgroundIDBDatabaseFileChild));
    case PBackgroundIDBTransactionMsgStart:
        return (&(mManagedPBackgroundIDBTransactionChild));
    case PBackgroundIDBVersionChangeTransactionMsgStart:
        return (&(mManagedPBackgroundIDBVersionChangeTransactionChild));
    default:
        return nullptr;
    }
}

auto PBackgroundIDBDatabaseChild::OpenPBackgroundIDBDatabaseFileEndpoint(PBackgroundIDBDatabaseFileChild* aActor) -> ManagedEndpoint<PBackgroundIDBDatabaseFileParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseFileChild actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseFileParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseFileChild actor");
        return ManagedEndpoint<PBackgroundIDBDatabaseFileParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBDatabaseFileParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseChild::BindPBackgroundIDBDatabaseFileEndpoint(
        ManagedEndpoint<PBackgroundIDBDatabaseFileChild> aEndpoint,
        PBackgroundIDBDatabaseFileChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseChild::OpenPBackgroundIDBTransactionEndpoint(PBackgroundIDBTransactionChild* aActor) -> ManagedEndpoint<PBackgroundIDBTransactionParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBTransactionChild actor");
        return ManagedEndpoint<PBackgroundIDBTransactionParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBTransactionChild actor");
        return ManagedEndpoint<PBackgroundIDBTransactionParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBTransactionParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseChild::BindPBackgroundIDBTransactionEndpoint(
        ManagedEndpoint<PBackgroundIDBTransactionChild> aEndpoint,
        PBackgroundIDBTransactionChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseChild::OpenPBackgroundIDBVersionChangeTransactionEndpoint(PBackgroundIDBVersionChangeTransactionChild* aActor) -> ManagedEndpoint<PBackgroundIDBVersionChangeTransactionParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PBackgroundIDBVersionChangeTransactionChild actor");
        return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBVersionChangeTransactionChild actor");
        return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PBackgroundIDBVersionChangeTransactionParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PBackgroundIDBDatabaseChild::BindPBackgroundIDBVersionChangeTransactionEndpoint(
        ManagedEndpoint<PBackgroundIDBVersionChangeTransactionChild> aEndpoint,
        PBackgroundIDBVersionChangeTransactionChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PBackgroundIDBDatabaseChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseChild::SendBlocked() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_Blocked(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Blocked", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseChild::SendClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_Close(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Close", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBDatabaseChild::SendPBackgroundIDBDatabaseFileConstructor(const IPCBlob& blob) -> PBackgroundIDBDatabaseFileChild*
{
    PBackgroundIDBDatabaseFileChild* actor = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->AllocPBackgroundIDBDatabaseFileChild(blob);
    return SendPBackgroundIDBDatabaseFileConstructor(std::move(actor), std::move(blob));
}

auto PBackgroundIDBDatabaseChild::SendPBackgroundIDBDatabaseFileConstructor(
        PBackgroundIDBDatabaseFileChild* actor,
        const IPCBlob& blob) -> PBackgroundIDBDatabaseFileChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBDatabaseFileChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBDatabaseFileChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_PBackgroundIDBDatabaseFileConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), blob);
    // Sentinel = 'blob'
    ((&(writer__)))->WriteSentinel(68157856);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBDatabaseFileConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBDatabaseFileChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBDatabaseChild::SendPBackgroundIDBTransactionConstructor(
        PBackgroundIDBTransactionChild* actor,
        mozilla::Span<nsString const> objectStoreNames,
        const Mode& mode,
        const Durability& durability) -> PBackgroundIDBTransactionChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PBackgroundIDBTransactionChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PBackgroundIDBTransactionChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBDatabase::Msg_PBackgroundIDBTransactionConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), objectStoreNames);
    // Sentinel = 'objectStoreNames'
    ((&(writer__)))->WriteSentinel(924780153);
    IPC::WriteParam((&(writer__)), mode);
    // Sentinel = 'mode'
    ((&(writer__)))->WriteSentinel(70386086);
    IPC::WriteParam((&(writer__)), durability);
    // Sentinel = 'durability'
    ((&(writer__)))->WriteSentinel(384500794);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBDatabaseChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBTransactionConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PBackgroundIDBTransactionChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PBackgroundIDBDatabaseChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PBackgroundIDBDatabaseFileMsgStart:
        static_cast<indexedDB::BackgroundDatabaseChild*>(this)->DeallocPBackgroundIDBDatabaseFileChild(static_cast<PBackgroundIDBDatabaseFileChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PBackgroundIDBDatabaseChild::OnMessageReceived(const Message& msg__) -> PBackgroundIDBDatabaseChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Reply_PBackgroundIDBDatabaseFileConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Reply_PBackgroundIDBTransactionConstructor__ID:
        {
            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_VersionChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_VersionChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__oldVersion = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__oldVersion) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& oldVersion = *maybe__oldVersion;
            // Sentinel = 'oldVersion'
            if ((!(((&(reader__)))->ReadSentinel(378602534)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__newVersion = IPC::ReadParam<mozilla::Maybe<uint64_t>>((&(reader__)));
            if (!maybe__newVersion) {
                FatalError("Error deserializing 'uint64_t?'");
                return MsgValueError;

            }
            auto& newVersion = *maybe__newVersion;
            // Sentinel = 'newVersion'
            if ((!(((&(reader__)))->ReadSentinel(383779889)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->RecvVersionChange(std::move(oldVersion), std::move(newVersion));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_Invalidate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_Invalidate", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->RecvInvalidate();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_CloseAfterInvalidationComplete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_CloseAfterInvalidationComplete", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->RecvCloseAfterInvalidationComplete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PBackgroundIDBDatabase::Msg_PBackgroundIDBVersionChangeTransactionConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBDatabase", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBDatabaseChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBDatabase::Msg_PBackgroundIDBVersionChangeTransactionConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__currentVersion = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__currentVersion) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& currentVersion = *maybe__currentVersion;
            // Sentinel = 'currentVersion'
            if ((!(((&(reader__)))->ReadSentinel(744228330)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__requestedVersion = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__requestedVersion) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& requestedVersion = *maybe__requestedVersion;
            // Sentinel = 'requestedVersion'
            if ((!(((&(reader__)))->ReadSentinel(962660025)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__nextObjectStoreId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__nextObjectStoreId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& nextObjectStoreId = *maybe__nextObjectStoreId;
            // Sentinel = 'nextObjectStoreId'
            if ((!(((&(reader__)))->ReadSentinel(1046087377)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__nextIndexId = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__nextIndexId) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& nextIndexId = *maybe__nextIndexId;
            // Sentinel = 'nextIndexId'
            if ((!(((&(reader__)))->ReadSentinel(453510245)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PBackgroundIDBVersionChangeTransactionChild> actor = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->AllocPBackgroundIDBVersionChangeTransactionChild(currentVersion, requestedVersion, nextObjectStoreId, nextIndexId);
            if (!actor) {
                NS_WARNING("Cannot bind null PBackgroundIDBVersionChangeTransactionChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PBackgroundIDBVersionChangeTransactionChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundDatabaseChild*>(this))->RecvPBackgroundIDBVersionChangeTransactionConstructor(actor, std::move(currentVersion), std::move(requestedVersion), std::move(nextObjectStoreId), std::move(nextIndexId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBDatabaseChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBDatabaseChild::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBDatabase'
    (aWriter)->WriteSentinel(1567492149);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBDatabase actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBDatabase'
    if ((!((aReader)->ReadSentinel(1567492149)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBDatabase actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBDatabaseMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBDatabase)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBDatabaseChild*>(actor);
}

} // namespace IPC
