/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM TrackEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "TrackEvent.h"
#include "TrackEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/AudioTrack.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/TextTrack.h"
#include "mozilla/dom/TrackEvent.h"
#include "mozilla/dom/VideoTrack.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(TrackEvent)

NS_IMPL_ADDREF_INHERITED(TrackEvent, Event)
NS_IMPL_RELEASE_INHERITED(TrackEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(TrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTrack)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(TrackEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(TrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTrack)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(TrackEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

TrackEvent::TrackEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

TrackEvent::~TrackEvent()
{
}

TrackEvent*
TrackEvent::AsTrackEvent()
{
  return this;
}

JSObject*
TrackEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return TrackEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<TrackEvent>
TrackEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const TrackEventInit& aEventInitDict)
{
  RefPtr<TrackEvent> e = new TrackEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mTrack = aEventInitDict.mTrack;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<TrackEvent>
TrackEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const TrackEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
TrackEvent::GetTrack(Nullable<OwningVideoTrackOrAudioTrackOrTextTrack>& aRetVal) const
{
  aRetVal = mTrack;
}


} // namespace mozilla::dom
