# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.resources.v2022_09_01.aio import ResourceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceManagementDeploymentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_delete_at_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_delete_at_scope(
                scope="str",
                deployment_name="str",
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_check_existence_at_scope(self, resource_group):
        response = await self.client.deployments.check_existence_at_scope(
            scope="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_create_or_update_at_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_create_or_update_at_scope(
                scope="str",
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_get_at_scope(self, resource_group):
        response = await self.client.deployments.get_at_scope(
            scope="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_cancel_at_scope(self, resource_group):
        response = await self.client.deployments.cancel_at_scope(
            scope="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_validate_at_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_validate_at_scope(
                scope="str",
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_export_template_at_scope(self, resource_group):
        response = await self.client.deployments.export_template_at_scope(
            scope="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_list_at_scope(self, resource_group):
        response = self.client.deployments.list_at_scope(
            scope="str",
            api_version="2022-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_delete_at_tenant_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_delete_at_tenant_scope(
                deployment_name="str",
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_check_existence_at_tenant_scope(self, resource_group):
        response = await self.client.deployments.check_existence_at_tenant_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_create_or_update_at_tenant_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_create_or_update_at_tenant_scope(
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_get_at_tenant_scope(self, resource_group):
        response = await self.client.deployments.get_at_tenant_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_cancel_at_tenant_scope(self, resource_group):
        response = await self.client.deployments.cancel_at_tenant_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_validate_at_tenant_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_validate_at_tenant_scope(
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_what_if_at_tenant_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_what_if_at_tenant_scope(
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "whatIfSettings": {"resultFormat": "str"},
                    },
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_export_template_at_tenant_scope(self, resource_group):
        response = await self.client.deployments.export_template_at_tenant_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_list_at_tenant_scope(self, resource_group):
        response = self.client.deployments.list_at_tenant_scope(
            api_version="2022-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_delete_at_management_group_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_delete_at_management_group_scope(
                group_id="str",
                deployment_name="str",
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_check_existence_at_management_group_scope(self, resource_group):
        response = await self.client.deployments.check_existence_at_management_group_scope(
            group_id="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_create_or_update_at_management_group_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_create_or_update_at_management_group_scope(
                group_id="str",
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_get_at_management_group_scope(self, resource_group):
        response = await self.client.deployments.get_at_management_group_scope(
            group_id="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_cancel_at_management_group_scope(self, resource_group):
        response = await self.client.deployments.cancel_at_management_group_scope(
            group_id="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_validate_at_management_group_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_validate_at_management_group_scope(
                group_id="str",
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_what_if_at_management_group_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_what_if_at_management_group_scope(
                group_id="str",
                deployment_name="str",
                parameters={
                    "location": "str",
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "whatIfSettings": {"resultFormat": "str"},
                    },
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_export_template_at_management_group_scope(self, resource_group):
        response = await self.client.deployments.export_template_at_management_group_scope(
            group_id="str",
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_list_at_management_group_scope(self, resource_group):
        response = self.client.deployments.list_at_management_group_scope(
            group_id="str",
            api_version="2022-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_delete_at_subscription_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_delete_at_subscription_scope(
                deployment_name="str",
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_check_existence_at_subscription_scope(self, resource_group):
        response = await self.client.deployments.check_existence_at_subscription_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_create_or_update_at_subscription_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_create_or_update_at_subscription_scope(
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_get_at_subscription_scope(self, resource_group):
        response = await self.client.deployments.get_at_subscription_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_cancel_at_subscription_scope(self, resource_group):
        response = await self.client.deployments.cancel_at_subscription_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_validate_at_subscription_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_validate_at_subscription_scope(
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_what_if_at_subscription_scope(self, resource_group):
        response = await (
            await self.client.deployments.begin_what_if_at_subscription_scope(
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "whatIfSettings": {"resultFormat": "str"},
                    },
                    "location": "str",
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_export_template_at_subscription_scope(self, resource_group):
        response = await self.client.deployments.export_template_at_subscription_scope(
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_list_at_subscription_scope(self, resource_group):
        response = self.client.deployments.list_at_subscription_scope(
            api_version="2022-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_delete(self, resource_group):
        response = await (
            await self.client.deployments.begin_delete(
                resource_group_name=resource_group.name,
                deployment_name="str",
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_check_existence(self, resource_group):
        response = await self.client.deployments.check_existence(
            resource_group_name=resource_group.name,
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.deployments.begin_create_or_update(
                resource_group_name=resource_group.name,
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_get(self, resource_group):
        response = await self.client.deployments.get(
            resource_group_name=resource_group.name,
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_cancel(self, resource_group):
        response = await self.client.deployments.cancel(
            resource_group_name=resource_group.name,
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_validate(self, resource_group):
        response = await (
            await self.client.deployments.begin_validate(
                resource_group_name=resource_group.name,
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                    },
                    "location": "str",
                    "tags": {"str": "str"},
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_begin_what_if(self, resource_group):
        response = await (
            await self.client.deployments.begin_what_if(
                resource_group_name=resource_group.name,
                deployment_name="str",
                parameters={
                    "properties": {
                        "mode": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "expressionEvaluationOptions": {"scope": "str"},
                        "onErrorDeployment": {"deploymentName": "str", "type": "str"},
                        "parameters": {
                            "str": {
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "template": {},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "whatIfSettings": {"resultFormat": "str"},
                    },
                    "location": "str",
                },
                api_version="2022-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_export_template(self, resource_group):
        response = await self.client.deployments.export_template(
            resource_group_name=resource_group.name,
            deployment_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_list_by_resource_group(self, resource_group):
        response = self.client.deployments.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployments_calculate_template_hash(self, resource_group):
        response = await self.client.deployments.calculate_template_hash(
            template={},
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...
