with Standard_Natural_Numbers;           use Standard_Natural_Numbers;
with Symmetry_Group;                     use Symmetry_Group;

package Drivers_for_Symmetry_Group_io is

-- DESCRIPTION :
--   This package offers two interactive drivers for the input of
--   a symmetry group.

  procedure Read_Permutation_Group
                 ( n : in natural32; g,v : in out List_of_Permutations;
                   allperms : out boolean );

  -- DESCRIPTION :
  --   Reads a permutation group, generated by the permutations in g.

  -- ON ENTRY :
  --   n           dimension of the vector space.

  -- ON RETURN :
  --   g           generating list of permutations;
  --   v           the full list of permutations, if requested, 
  --               otherwise v = g;
  --   allperms    if true, then g generates the full permutation group.

  procedure Read_Symmetry_Group
                 ( n : in natural32; g,v : in out List_of_Permutations;
                   allperms,signsym,allsigns : out boolean );

  -- DESCRIPTION :
  --   Reads first a permutation group, and in addition to this allows to 
  --   enter sign permutations.  The parameters have the same meaning as the
  --   ones listed above.  Only the additional parameters will be specified.

  -- ON RETURN :
  --   signsym     if true, then g contains sign permutations;
  --   allsigns    if true, then g generates the full sign permutation group.

end Drivers_for_Symmetry_Group_io;
