// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file dds_xtypes_typeobjectPubSubTypes.hpp
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */


#ifndef FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECT_PUBSUBTYPES_HPP
#define FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECT_PUBSUBTYPES_HPP

#include <fastdds/dds/core/policy/QosPolicies.hpp>
#include <fastdds/dds/topic/TopicDataType.hpp>
#include <fastdds/rtps/common/InstanceHandle.hpp>
#include <fastdds/rtps/common/SerializedPayload.hpp>
#include <fastdds/utils/md5.hpp>

#include "dds_xtypes_typeobject.hpp"


#if !defined(FASTDDS_GEN_API_VER) || (FASTDDS_GEN_API_VER != 3)
#error \
    Generated dds_xtypes_typeobject is not compatible with current installed Fast DDS. Please, regenerate it with fastddsgen.
#endif  // FASTDDS_GEN_API_VER

namespace eprosima {

namespace fastdds {

namespace dds {


namespace xtypes {


typedef uint8_t EquivalenceKind;
typedef uint8_t TypeKind;
typedef uint8_t TypeIdentiferKind;
typedef eprosima::fastcdr::fixed_string<MEMBER_NAME_MAX_LENGTH> MemberName;
typedef eprosima::fastcdr::fixed_string<TYPE_NAME_MAX_LENGTH> QualifiedTypeName;
typedef uint8_t PrimitiveTypeId;
typedef std::array<uint8_t, 14> EquivalenceHash;
typedef std::array<uint8_t, 4> NameHash;
typedef uint32_t LBound;
typedef std::vector<eprosima::fastdds::dds::xtypes::LBound> LBoundSeq;
typedef uint8_t SBound;
typedef std::vector<eprosima::fastdds::dds::xtypes::SBound> SBoundSeq;
typedef eprosima::fastdds::dds::xtypes::MemberFlag CollectionElementFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag StructMemberFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag UnionMemberFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag UnionDiscriminatorFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag EnumeratedLiteralFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag AnnotationParameterFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag AliasMemberFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag BitflagFlag;
typedef eprosima::fastdds::dds::xtypes::MemberFlag BitsetMemberFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag StructTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag UnionTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag CollectionTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag AnnotationTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag AliasTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag EnumTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag BitmaskTypeFlag;
typedef eprosima::fastdds::dds::xtypes::TypeFlag BitsetTypeFlag;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct StringSTypeDefn_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct StringSTypeDefn_f
{
    typedef eprosima::fastdds::dds::xtypes::SBound StringSTypeDefn::* type;
    friend constexpr type get(
            StringSTypeDefn_f);
};

template struct StringSTypeDefn_rob<StringSTypeDefn_f, &StringSTypeDefn::m_bound>;

template <typename T, typename Tag>
inline size_t constexpr StringSTypeDefn_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG




#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct StringLTypeDefn_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct StringLTypeDefn_f
{
    typedef eprosima::fastdds::dds::xtypes::LBound StringLTypeDefn::* type;
    friend constexpr type get(
            StringLTypeDefn_f);
};

template struct StringLTypeDefn_rob<StringLTypeDefn_f, &StringLTypeDefn::m_bound>;

template <typename T, typename Tag>
inline size_t constexpr StringLTypeDefn_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



typedef std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifier> TypeIdentifierSeq;
typedef uint32_t MemberId;
typedef std::vector<eprosima::fastdds::dds::xtypes::AppliedAnnotationParameter> AppliedAnnotationParameterSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::AppliedAnnotation> AppliedAnnotationSeq;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct MinimalMemberDetail_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct MinimalMemberDetail_f
{
    typedef eprosima::fastdds::dds::xtypes::NameHash MinimalMemberDetail::* type;
    friend constexpr type get(
            MinimalMemberDetail_f);
};

template struct MinimalMemberDetail_rob<MinimalMemberDetail_f, &MinimalMemberDetail::m_name_hash>;

template <typename T, typename Tag>
inline size_t constexpr MinimalMemberDetail_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteStructMember> CompleteStructMemberSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalStructMember> MinimalStructMemberSeq;
typedef std::vector<int32_t> UnionCaseLabelSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteUnionMember> CompleteUnionMemberSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalUnionMember> MinimalUnionMemberSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteAnnotationParameter> CompleteAnnotationParameterSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalAnnotationParameter> MinimalAnnotationParameterSeq;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct CommonCollectionHeader_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct CommonCollectionHeader_f
{
    typedef eprosima::fastdds::dds::xtypes::LBound CommonCollectionHeader::* type;
    friend constexpr type get(
            CommonCollectionHeader_f);
};

template struct CommonCollectionHeader_rob<CommonCollectionHeader_f, &CommonCollectionHeader::m_bound>;

template <typename T, typename Tag>
inline size_t constexpr CommonCollectionHeader_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



typedef uint16_t BitBound;
typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteEnumeratedLiteral> CompleteEnumeratedLiteralSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalEnumeratedLiteral> MinimalEnumeratedLiteralSeq;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct CommonEnumeratedHeader_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct CommonEnumeratedHeader_f
{
    typedef eprosima::fastdds::dds::xtypes::BitBound CommonEnumeratedHeader::* type;
    friend constexpr type get(
            CommonEnumeratedHeader_f);
};

template struct CommonEnumeratedHeader_rob<CommonEnumeratedHeader_f, &CommonEnumeratedHeader::m_bit_bound>;

template <typename T, typename Tag>
inline size_t constexpr CommonEnumeratedHeader_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteBitflag> CompleteBitflagSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalBitflag> MinimalBitflagSeq;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct CommonBitmaskHeader_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct CommonBitmaskHeader_f
{
    typedef eprosima::fastdds::dds::xtypes::BitBound CommonBitmaskHeader::* type;
    friend constexpr type get(
            CommonBitmaskHeader_f);
};

template struct CommonBitmaskHeader_rob<CommonBitmaskHeader_f, &CommonBitmaskHeader::m_bit_bound>;

template <typename T, typename Tag>
inline size_t constexpr CommonBitmaskHeader_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



typedef eprosima::fastdds::dds::xtypes::CompleteEnumeratedHeader CompleteBitmaskHeader;
typedef eprosima::fastdds::dds::xtypes::MinimalEnumeratedHeader MinimalBitmaskHeader;
typedef std::vector<eprosima::fastdds::dds::xtypes::CompleteBitfield> CompleteBitfieldSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::MinimalBitfield> MinimalBitfieldSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeObject> TypeObjectSeq;
typedef eprosima::fastdds::dds::xtypes::TypeObjectSeq StronglyConnectedComponent;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierTypeObjectPair> TypeIdentifierTypeObjectPairSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierPair> TypeIdentifierPairSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeIdentfierWithSize> TypeIdentfierWithSizeSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeIdentifierWithDependencies> TypeIdentifierWithDependenciesSeq;
typedef std::vector<eprosima::fastdds::dds::xtypes::TypeInformation> TypeInformationSeq;

} // namespace xtypes


} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // FAST_DDS_GENERATED__DDS_XTYPES_TYPEOBJECT_PUBSUBTYPES_HPP

