#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lords of Xulima
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251022.6

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='lords-of-xulima'
GAME_NAME='Lords of Xulima'

ARCHIVE_BASE_0_NAME='gog_lords_of_xulima_2.3.0.9.sh'
ARCHIVE_BASE_0_MD5='480abf8d929da622eacd69595a4ebc80'
ARCHIVE_BASE_0_SIZE='1700000'
ARCHIVE_BASE_0_VERSION='2.1.1-gog2.3.0.9'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/lords_of_xulima'

ARCHIVE_REQUIRED_LIB64_NAME='lords-of-xulima_64bit-libraries.tar.xz'
ARCHIVE_REQUIRED_LIB64_MD5='e13bdc9c7a378c13ca1c0d64575013db'
ARCHIVE_REQUIRED_LIB64_SIZE='236'
ARCHIVE_REQUIRED_LIB64_URL='http://downloads.dotslashplay.it/games/lords-of-xulima/'

CONTENT_PATH_DEFAULT='data/noarch/game'
## Provided by lords-of-xulima_64bit-libraries.tar.xz
CONTENT_LIBS_LIBS64_PATH='.'
CONTENT_LIBS_LIBS64_FILES='
libbass.so'
## Provided by the GOG installer
CONTENT_LIBS_LIBS32_FILES='
libbass.so'
CONTENT_FONTS_DATA_FILES='
FoL_BB_RU.ttf
FoL_CB_RU.ttf
FoL_MB_RU.ttf
LOXBold.ttf
LOXCondensed.ttf
LOXMedium.ttf
WenQuanYiZenHei.ttf'
CONTENT_GAME_MAIN_FILES='
DXApp_Anim
DXApp_Sounds
DXApp.dx???
SOL_Anim
SOL_DATA
SOL_Sounds
SOLCredits.jxcredits
SOL.jxdat
SOL.jxdatgal
SOL.jxrul
SOL.jxworldmap
SOL.dx???
SOL_??.jx???
SOL
Cinematic
Resources
fonts.conf
local.conf
Bass.Net.dll
Bass.Net.dll.config
Bass.Net.iOS.dll
Bass.Net.Linux.dll
ChnCharInfo.dll
DXPlatform_Desktop.dll
DXVision.dll
DXVision.dll.config
ExcelWrapper.dll
ICSharpCode.SharpZipLib.dll
Ionic.Zip.dll
Ionic.Zlib.dll
JXEngine.dll
JXMapRenderer.dll
ManagedSquish.dll
OpenTK.Compatibility.dll
OpenTK.Compatibility.dll.config
OpenTK.dll
OpenTK.dll.config
OpenTK.GLControl.dll
OpenTK.GLControl.dll.config
SlimDX.dll
SOL.dll
LOXEditor.exe
LoX.exe
motionblur.fx
shaders.fx
PixelShader.glsl
VertexShader.glsl
LordsOfXulima.hqx
Info.jxmod
LOX.sqlite
LOXEditor.suo
CustomPortraits.txt
Temp_InteractiveObjects_Count.txt'
## TODO: Check if the Steam Mono assemblies can be dropped.
CONTENT_GAME0_MAIN_FILES='
Steamworks.NET.dll
Steamworks.NET.dll.config'
CONTENT_DOC_MAIN_FILES='
Manual'

FAKE_HOME_PERSISTENT_DIRECTORIES='
My Games/Lords of Xulima'

APP_MAIN_EXE='LoX.exe'
APP_MAIN_ICON='LoX.exe'

PACKAGES_LIST='
PKG_MAIN
PKG_LIBS64
PKG_LIBS32'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_LIBS'
## Easier upgrades from pre-20251022.2 packages
PKG_MAIN_PROVIDES='
lords-of-xulima-data'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS_DESCRIPTION='Shipped libraries'
PKG_LIBS64_ARCH='64'
PKG_LIBS32_ARCH='32'
PKG_LIBS_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libpthread.so.0
librt.so.1'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Check for presence of required 64-bit library.

archive_initialize_required \
	'ARCHIVE_LIB64' \
	'ARCHIVE_REQUIRED_LIB64'

# Extract game data.

archive_extraction_default
archive_extraction 'ARCHIVE_LIB64'

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
