% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.polr.R
\name{mice.impute.polr}
\alias{mice.impute.polr}
\title{Imputation of ordered data by polytomous regression}
\usage{
mice.impute.polr(
  y,
  ry,
  x,
  wy = NULL,
  nnet.maxit = 100,
  nnet.trace = FALSE,
  nnet.MaxNWts = 1500,
  polr.to.loggedEvents = FALSE,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{nnet.maxit}{Tuning parameter for \code{nnet()}.}

\item{nnet.trace}{Tuning parameter for \code{nnet()}.}

\item{nnet.MaxNWts}{Tuning parameter for \code{nnet()}.}

\item{polr.to.loggedEvents}{A logical indicating whether each fallback
to the \code{multinom()} function should be written to \code{loggedEvents}.
The default is \code{FALSE}.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}
}
\description{
Imputes missing data in a categorical variable using polytomous regression
}
\details{
The function \code{mice.impute.polr()} imputes for ordered categorical response
variables by the proportional odds logistic regression (polr) model. The
function repeatedly applies logistic regression on the successive splits. The
model is also known as the cumulative link model.

By default, ordered factors with more than two levels are imputed by
\code{mice.impute.polr}.

The algorithm of \code{mice.impute.polr} uses the function \code{polr()} from
the \code{MASS} package.

In order to avoid bias due to perfect prediction, the algorithm augment the
data according to the method of White, Daniel and Royston (2010).

The call to \code{polr} might fail, usually because the data are very sparse.
In that case, \code{multinom} is tried as a fallback.
If the local flag \code{polr.to.loggedEvents} is set to TRUE,
a record is written
to the \code{loggedEvents} component of the \code{\link{mids}} object.
Use \code{mice(data, polr.to.loggedEvents = TRUE)} to set the flag.
}
\note{
In December 2019 Simon White alerted that the
\code{polr} could always fail silently. I can confirm this behaviour for
versions \code{mice 3.0.0 - mice 3.6.6}, so any method requests
for \code{polr} in these versions were in fact handled by \code{multinom}.
See \url{https://github.com/amices/mice/issues/206} for details.
}
\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2011). \code{mice}: Multivariate
Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical
Software}, \bold{45}(3), 1-67. \doi{10.18637/jss.v045.i03}

Brand, J.P.L. (1999) \emph{Development, implementation and evaluation of
multiple imputation strategies for the statistical analysis of incomplete
data sets.} Dissertation. Rotterdam: Erasmus University.

White, I.R., Daniel, R. Royston, P. (2010). Avoiding bias due to perfect
prediction in multiple imputation of incomplete categorical variables.
\emph{Computational Statistics and Data Analysis}, 54, 2267-2275.

Venables, W.N. & Ripley, B.D. (2002). \emph{Modern applied statistics with
S-Plus (4th ed)}. Springer, Berlin.
}
\seealso{
\code{\link{mice}}, \code{\link[nnet]{multinom}},
\code{\link[MASS]{polr}}

Other univariate imputation functions: 
\code{\link{mice.impute.cart}()},
\code{\link{mice.impute.lasso.logreg}()},
\code{\link{mice.impute.lasso.norm}()},
\code{\link{mice.impute.lasso.select.logreg}()},
\code{\link{mice.impute.lasso.select.norm}()},
\code{\link{mice.impute.lda}()},
\code{\link{mice.impute.logreg}()},
\code{\link{mice.impute.logreg.boot}()},
\code{\link{mice.impute.mean}()},
\code{\link{mice.impute.midastouch}()},
\code{\link{mice.impute.mnar.logreg}()},
\code{\link{mice.impute.mpmm}()},
\code{\link{mice.impute.norm}()},
\code{\link{mice.impute.norm.boot}()},
\code{\link{mice.impute.norm.nob}()},
\code{\link{mice.impute.norm.predict}()},
\code{\link{mice.impute.pmm}()},
\code{\link{mice.impute.polyreg}()},
\code{\link{mice.impute.quadratic}()},
\code{\link{mice.impute.rf}()},
\code{\link{mice.impute.ri}()}
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn, 2000-2010
}
\concept{univariate imputation functions}
\keyword{datagen}
