# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
QEMU_SYSTEM_PPC64 ?= $(if $(value SNAP_INSTANCE_NAME),$$(test -z "$${SNAP_INSTANCE_NAME-}" && echo $(SNAP_INSTANCE_NAME).)qemu-system-ppc64,$(or $(shell command -v qemu-system-ppc64),$(warning program qemu-system-ppc64 is required)qemu-system-ppc64))
QEMU_SYSTEM_PPC64_MACHINE = pseries
QEMU_CPU_PPC64 = power9
QEMU_SMP_PPC64 = 1
QEMU_DEFAULT_NET_OPTION_PPC64 ?= \
	-netdev user,id=netdev0$(QEMU_DEFAULT_NETDEV_SYS_EXTRA)$${QEMU_NETDEV_USER_EXTRA:-} \
	-device virtio-net-pci,netdev=netdev0,id=net0
QEMU_SYSTEM_PPC64_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_PPC64) \
	-cpu $(QEMU_CPU_PPC64) \
	-machine $(QEMU_SYSTEM_PPC64_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_PPC64) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_PPC64)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_PPC64)}

.PHONY: clean
clean::
	rm -f *.ppc64.qcow2
