"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultActionKit = defaultActionKit;
const tslib_1 = require("tslib");
const path = tslib_1.__importStar(require("path"));
const quiet_1 = require("../reporter/quiet");
const suppressed_1 = require("../reporter/suppressed");
const command_1 = require("./command");
const echo_1 = require("./echo");
const fail_1 = require("./fail");
const file_1 = require("./file");
const command_2 = require("./nodejs/command");
function defaultActions(ce) {
    return {
        ...(0, command_1.createKit_Command)(ce),
        ...(0, command_2.createKit_NodeJS)(ce),
        ...(0, echo_1.createKit_Echo)(ce),
        ...(0, file_1.createKit_File)(ce),
        ...(0, fail_1.createKit_Fail)(ce),
    };
}
function defaultActionKit(ce) {
    function cd(into) {
        return Object.assign({ ...ce }, { cd: path.resolve(ce.cd || "", into) });
    }
    function withEnv(e) {
        return Object.assign({ ...ce }, { env: Object.assign({}, ce.env, e) });
    }
    return {
        ...defaultActions(ce),
        silently: defaultActions({ ...ce, reporter: new suppressed_1.SuppressedReporter(ce.reporter) }),
        absolutelySilently: defaultActions({ ...ce, reporter: new quiet_1.QuietReporter() }),
        cd: (into) => defaultActionKit(cd(into)),
        withEnv: (e) => defaultActionKit(withEnv(e)),
    };
}
