"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocaTableIo = exports.LocaTag = void 0;
const primitive_1 = require("@ot-builder/primitive");
const shared_1 = require("./shared");
exports.LocaTag = "loca";
exports.LocaTableIo = {
    read(view, head, maxp) {
        const indexToLocFormat = head.indexToLocFormat;
        const numGlyphs = maxp.numGlyphs;
        const offsets = [];
        for (let gid = 0; gid <= numGlyphs; gid++) {
            if (indexToLocFormat === 0) {
                offsets.push(view.uint16() * 2);
            }
            else {
                offsets.push(view.uint32() * 1);
            }
        }
        return { glyphOffsets: offsets };
    },
    write(frag, loca, head) {
        let canUseFormat0 = true;
        for (const offset of loca.glyphOffsets) {
            if (offset >= primitive_1.UInt16.max * 2 || offset % shared_1.LocaShortOffsetScaling)
                canUseFormat0 = false;
        }
        if (canUseFormat0) {
            head.indexToLocFormat = 0;
            for (const offset of loca.glyphOffsets) {
                frag.uint16(offset / shared_1.LocaShortOffsetScaling);
            }
        }
        else {
            head.indexToLocFormat = 1;
            for (const offset of loca.glyphOffsets) {
                frag.uint32(offset);
            }
        }
    }
};
//# sourceMappingURL=loca.js.map