---
myst:
  html_meta:
    keywords: LaTeX, composition, document, création d'un document,
              classes standards, bonnes pratiques, classes LaTeX
---

# Quelles alternatives existe-t-il aux classes standards ?

Beaucoup d'utilisateurs se plaisent à concocter sans cesse de nouvelles classes
pour remplacer les classes standards. Certaines ont eu leur heure de gloire :
- dans les années 80, une classe `ukart` (maintenant introuvable) était 
disponible pour les articles à la mode britannique. Elle appelait 
l'extension <ctanpkg:sober> et changeait quelques éléments pour être conforme 
aux usages du Royaume-Uni comme peut le faire l'extension <ctanpkg:babel> 
avec l'option `USenglish` ;
- l'extension <ctanpkg:ntgclass> propose de remplacer les classes `article`, 
`report` et `book` par de nombreuses autres, conformes aux usages néerlandais 
(mais son développement semble avoir cessé en 1994).

De façon générale, il n'est utile de développer une nouvelle classe que 
si la nature profonde du document diffère d'un article ou d'un livre 
(comme pour un poster, comme décrit à la question 
"[](/4_domaines_specialises/communication/communication_scientifique/mettre_en_page_un_poster)" 
ou un [diaporama](/4_domaines_specialises/communication/diaporama/start)). 
Pour personnaliser un document, il est toujours plus simple et modulaire 
de charger quelques extensions que de changer la classe du document.

Cependant, deux extensions fournissent des classes qui peuvent concurrencer 
les classes standards : [KOMA-script](ctanpkg:koma-script) et <ctanpkg:memoir>.
Elles sont d'ailleurs fréquemment citées dans les réponses données 
dans cette FAQ.


## Les classes [KOMA-script](ctanpkg:koma-script)

L'extension [KOMA-script](ctanpkg:koma-script) est activement développée 
par [Markus Kohm](https://www.ctan.org/author/kohm). Elle fournit les classes :

- `scrartcl` pour les articles ;
- `scrreprt` pour les rapports ;
- `scrbook` pour les livres ;
- `scrlttr2` pour les lettres.

Elle fournit également quelques autres extensions :

- `typearea` pour calculer les largeurs des marges des pages 
  suivant les principes du typographe renommé 
  [Jan Tschichold](wpfr:Jan_Tschichold). Vous pouvez la voir en application 
  avec la question 
  "[](3_composition/texte/pages/parametres_de_page/modifier_les_marges_d_un_document)" ;
- `scrdate` pour accéder à la date actuelle, y compris le jour de la semaine ;
- `scrtime` pour accéder à l'heure actuelle.

Ces classes couvrent entièrement les questions importantes de composition 
du document et elles produisent un résultat de bonne qualité typographique. 
Leur documentation de référence [est en allemand](texdoc:scrguide), 
mais elle a été progressivement [traduite en anglais](texdoc:scrguien). 
Raymond Rochedieu en a réalisé une adaptation en français, 
[disponible sous forme livre libre](https://archives.framabook.org/koma-script/).


## La classe <ctanpkg:memoir>

L'autre classe notable est <ctanpkg:memoir>, 
développée par [Peter Wilson](https://www.ctan.org/author/wilson) 
et actuellement maintenue par 
[Lars Madsen](https://www.ctan.org/author/madsen). Elle vise à remplacer 
directement les classes `book` et `report`, et 
(comme [KOMA-script](ctanpkg:koma-script)) elle couvre complètement 
tous les problèmes habituels. Son auteur la destine aux œuvres "de poésie, 
de fiction, de non-fiction et de mathématiques". 
[Sa documentation (en anglais)](texdoc:memman) est très appréciée, 
et notamment [sa longue introduction](texdoc:memdesign) est régulièrement
recommandée comme initiation à la typographie.

:::{warning}
D'anciens tutoriels notaient des incompatibilités entre la classe `memoir`
et l'extension <ctanpkg:hyperref>. La solution préconisée était de charger 
un patch, `memhfixc`. Cette démarche est maintenant inutile, <ctanpkg:hyperref>
s'occupant de le charger si besoin.
:::


:::{sources}
- [Replacing the standard classes](faquk:FAQ-replstdcls)
- [Creating a class file vs using packages](https://tex.stackexchange.com/q/261094),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Documentation de "memoir" : projet de traduction en français](https://github.com/jejust/memoir-fr)
:::