## TFSA-2023-005: Null dereference on ParallelConcat with XLA

### CVE Number
CVE-2023-25676

### Impact
When running with XLA, `tf.raw_ops.ParallelConcat` segfaults with a nullptr dereference when given a parameter `shape` with rank that is not greater than zero.

```python
import tensorflow as tf

func = tf.raw_ops.ParallelConcat
para = {'shape':  0, 'values': [1]}

@tf.function(jit_compile=True)
def test():
   y = func(**para)
   return y

test()
```

### Patches
We have patched the issue in GitHub commit [da66bc6d5ff466aee084f9e7397980a24890cd15](https://github.com/tensorflow/tensorflow/commit/da66bc6d5ff466aee084f9e7397980a24890cd15).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx of 360 AIVul Team
