<!-- markdownlint-disable first-line-h1 -->
### What's new in this release

#### HIP enhancements

The ROCm v5.4.1 release consists of the following new HIP API:

##### New HIP API - hipLaunchHostFunc

The following new HIP API is introduced in the ROCm v5.4.1 release.

:::{note}
This is a pre-official version (beta) release of the new APIs.
:::

```cpp
hipError_t hipLaunchHostFunc(hipStream_t stream, hipHostFn_t fn, void* userData);
```

This swaps the stream capture mode of a thread.

```text
@param [in] mode - Pointer to mode value to swap with the current mode
```

This parameter returns `#hipSuccess`, `#hipErrorInvalidValue`.

For more information, refer to the HIP API documentation at
/bundle/HIP_API_Guide/page/modules.html.

### Deprecations and warnings

#### HIP Perl scripts deprecation

The `hipcc` and `hipconfig` Perl scripts are deprecated. In a future release, compiled binaries will be
available as `hipcc.bin` and `hipconfig.bin` as replacements for the Perl scripts.

:::{note}
There will be a transition period where the Perl scripts and compiled binaries are available  before the
scripts are removed. There will be no functional difference between the Perl scripts and their compiled
binary counterpart. No user action is required. Once these are available, users can optionally switch to
`hipcc.bin` and `hipconfig.bin`. The `hipcc`/`hipconfig` soft link will be assimilated to point from
`hipcc`/`hipconfig` to the respective compiled binaries as the default option.
:::

### IFWI fixes

These defects were identified and documented as known issues in previous ROCm releases and are
fixed in this release.

#### AMD Instinct™ MI200 firmware IFWI maintenance update #3

This IFWI release fixes the following issue in AMD Instinct™ MI210/MI250 GPUs.

After prolonged periods of operation, certain MI200 Instinct™ GPUs may perform in a degraded
way resulting in application failures.

In this package, AMD delivers a new firmware version for MI200 GPU GPUs and a firmware
installation tool – AMD FW FLASH 1.2.

| GPU   | Productionp part number | SKU | IFWI name |
|-------|------------|--------|---------------|
| MI210 | 113-D673XX | D67302 | D6730200V.110 |
| MI210 | 113-D673XX | D67301 | D6730100V.073 |
| MI250 | 113-D652XX | D65209 | D6520900.073  |
| MI250 | 113-D652XX | D65210 | D6521000.073  |

Instructions on how to download and apply MI200 maintenance updates are available at:

<https://www.amd.com/en/support/server-accelerators/amd-instinct/amd-instinct-mi-series/amd-instinct-mi210>

#### AMD Instinct™ MI200 SRIOV virtualization support

Maintenance update #3, combined with ROCm 5.4.1, now provides SRIOV virtualization support for all
AMD Instinct™ MI200 devices.
